/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libm;

import nxm.sys.lib.Convert;
import nxm.sys.lib.Native;
import nxm.sys.lib.Shell;
import nxm.sys.libm.Operator;

public class Dbf
extends Operator {
    @Override
    public int validate(char type, int n, int mode) {
        switch (mode) {
            case 17: {
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    @Override
    public int getInputs() {
        return 1;
    }

    @Override
    public int getOutputs() {
        return 1;
    }

    @Override
    public final int process(float[][] v, int n, int mode) {
        if (v[0] != v[1]) {
            System.arraycopy(v[0], 0, v[1], 0, n);
        }
        if (Native.useMath) {
            Native.dbf(v[1], n, this.flags);
        } else {
            Dbf.work(v[1], n, this.flags);
        }
        return n;
    }

    @Override
    public final int process(double[][] v, int n, int mode) {
        if (v[0] != v[1]) {
            System.arraycopy(v[0], 0, v[1], 0, n);
        }
        Dbf.work(v[1], n, this.flags);
        return n;
    }

    @Override
    public final int process(int[][] v, int n, int mode) {
        if (v[0] != v[1]) {
            System.arraycopy(v[0], 0, v[1], 0, n);
        }
        Dbf.work(v[1], n, this.flags);
        return n;
    }

    public static void process(Object buf, int size, int flags) {
        if (buf instanceof double[]) {
            Dbf.work((double[])buf, size, flags);
        } else if (Native.useMath) {
            Native.dbf(buf, size, flags);
        } else if (buf instanceof float[]) {
            Dbf.work((float[])buf, size, flags);
        } else if (buf instanceof byte[]) {
            Dbf.work((byte[])buf, size, flags);
        }
    }

    public static void work(double[] buf, int size, int flags) {
        double scale = 0.0234375;
        int offset = 16256;
        for (int i = 0; i < size; ++i) {
            short iwork = (short)(Float.floatToIntBits((float)buf[i]) >> 16);
            buf[i] = scale * (double)(iwork - offset);
        }
    }

    public static void work(float[] buf, int size, int flags) {
        float scale = 0.0234375f;
        int offset = 16256;
        for (int i = 0; i < size; ++i) {
            short iwork = (short)(Float.floatToIntBits(buf[i]) >> 16);
            buf[i] = scale * (float)(iwork - offset);
        }
    }

    public static void work(int[] buf, int size, int flags) {
        float scale = 0.0234375f;
        int offset = 16256;
        for (int i = 0; i < size; ++i) {
            short iwork = (short)(Float.floatToIntBits(buf[i]) >> 16);
            buf[i] = (int)(scale * (float)(iwork - offset));
        }
    }

    public static void work(byte[] buf, int size, int flags) {
        int SOFF = Shell.rep == 73 ? 0 : 1;
        float scale = 0.0234375f;
        int offset = 16256;
        int i = 0;
        int j = SOFF;
        while (i < size) {
            float fwork = scale * (float)(Convert.unpackI(buf, j * 2) - offset);
            Convert.packF(buf, i * 4, fwork);
            ++i;
            j += 2;
        }
    }
}

