/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libm;

import nxm.sys.inc.DataTypes;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.MidasException;
import nxm.sys.libm.Argument;
import nxm.sys.libm.Operator;
import nxm.sys.libm.Operators;

public class ArgStack
implements DataTypes {
    private int iArg;
    private int maxArg;
    private int iStk;
    private int maxStk;
    public int nArgs;
    private String rawArgs;
    private Stack[] stks;
    public Argument[] args;
    private int flags;
    public char type;
    public int xfer;

    public ArgStack(int maxArg, int maxStk, char type, int xfer, int flags) {
        this.maxArg = maxArg;
        this.maxStk = maxStk;
        this.type = type;
        this.xfer = xfer;
        this.flags = flags;
        this.args = new Argument[maxArg];
        this.stks = new Stack[maxStk];
        this.clear();
    }

    public void clear() {
        this.iArg = 0;
        this.iStk = 0;
        this.rawArgs = null;
    }

    public void setXfer(int xfer) {
        this.xfer = xfer;
    }

    public int getStackValues() {
        return this.iStk;
    }

    public boolean parseNext(String s, Object ref) {
        Operator op = Operators.get(s);
        boolean ok = false;
        if (op != null) {
            ok = this.parseOperator(s, op);
        } else if (s.equals("PUSH")) {
            ok = this.parsePush();
        } else if (s.equals("POP")) {
            ok = this.parsePop();
        } else if (s.equals("<>")) {
            ok = this.parseSwap();
        } else if (s.startsWith("=")) {
            this.parseStackOut(s.substring(1));
        } else {
            ok = this.parseConstant(s, ref, false);
        }
        return ok;
    }

    public boolean parsePush() {
        this.addArg("PUSH");
        this.stks[this.iStk] = this.stks[this.iStk - 1];
        ++this.iStk;
        return true;
    }

    public boolean parsePop() {
        this.addArg("POP");
        if (this.iStk <= 0) {
            return false;
        }
        --this.iStk;
        return true;
    }

    public boolean parseSwap() {
        this.addArg("<>");
        if (this.iStk < 2) {
            return false;
        }
        Stack tstk = this.stks[this.iStk - 1];
        this.stks[this.iStk - 1] = this.stks[this.iStk - 2];
        this.stks[this.iStk - 2] = tstk;
        return true;
    }

    public boolean parseOperator(String s, Operator op) {
        this.addArg(s);
        Argument arg = new Argument(1, s);
        arg.op = op;
        int ins = arg.op.getInputs();
        int outs = arg.op.getOutputs();
        if (this.iStk < ins) {
            this.badArg("Insufficient parameters on stack for operator " + arg.name);
        }
        int omode = 0;
        int mode = 0;
        for (omode = 1; omode <= 3; ++omode) {
            int i;
            int i2;
            int osize = 0;
            mode = 0;
            int isize = ins == 0 ? this.xfer : this.stks[this.iStk - ins].size;
            for (i2 = 1; i2 < ins; ++i2) {
                int insize = this.stks[this.iStk - ins + i2].size;
                if (insize <= 1 || isize > 1 && insize >= isize) continue;
                isize = insize;
            }
            for (i2 = 0; i2 < ins; ++i2) {
                mode |= this.stks[this.iStk - ins + i2].mode << i2 * 4;
            }
            for (i2 = 0; i2 < outs; ++i2) {
                mode |= omode << (ins + i2) * 4;
            }
            osize = arg.op.validate(this.type, isize, mode |= arg.op.flags);
            if (osize == -1) continue;
            int ios = ins + outs;
            arg.mode = mode;
            this.iStk -= ins;
            if (this.type == 'D') {
                arg.dv = new double[ios][];
                for (i = 0; i < ins; ++i) {
                    arg.dv[i] = this.stks[this.iStk + i].d;
                }
                for (i = 0; i < outs; ++i) {
                    Stack stk = this.getStack(omode, osize, null);
                    this.stks[this.iStk++] = stk;
                    arg.dv[ins + i] = stk.d;
                }
            } else if (this.type == 'F') {
                arg.fv = new float[ios][];
                for (i = 0; i < ins; ++i) {
                    arg.fv[i] = this.stks[this.iStk + i].f;
                }
                for (i = 0; i < outs; ++i) {
                    Stack stk = this.getStack(omode, osize, null);
                    this.stks[this.iStk++] = stk;
                    arg.fv[ins + i] = stk.f;
                }
            } else if (this.type == 'L') {
                arg.lv = new int[ios][];
                for (i = 0; i < ins; ++i) {
                    arg.lv[i] = this.stks[this.iStk + i].l;
                }
                for (i = 0; i < outs; ++i) {
                    Stack stk = this.getStack(omode, osize, null);
                    this.stks[this.iStk++] = stk;
                    arg.lv[ins + i] = stk.l;
                }
            }
            arg.size = isize;
            this.args[this.iArg++] = arg;
            return true;
        }
        this.badArg("Invalid parameters on stack for operator " + arg.name);
        return false;
    }

    public boolean parseConstant(String s, Object ref) {
        return this.parseConstant(s, ref, false);
    }

    public boolean parseConstant(String s, Object ref, boolean soft) {
        return this.parseConstant(s, ref, soft, false);
    }

    public boolean parseConstant(String s, Object ref, boolean soft, boolean var) {
        if (!soft) {
            this.addArg(s);
        }
        if (this.iStk >= this.maxStk) {
            this.badArg("Stack too small for constant " + s);
        }
        Object obj = this.s2o(s, ref);
        if (var && obj != null) {
            boolean bl = var = this.s2o(s, null) == null;
        }
        if (!(obj instanceof Data)) {
            if (soft) {
                return false;
            }
            this.badArg("Could not convert argument " + s + " to constant");
        }
        if (soft) {
            this.addArg(s);
        }
        Data data = (Data)obj;
        Stack stk = this.getStack(data.spa, 1, data);
        this.stks[this.iStk++] = stk;
        if (var) {
            Argument arg = new Argument(3, s);
            if (this.type == 'D') {
                arg.dv = new double[1][];
                arg.dv[0] = stk.d;
            } else if (this.type == 'F') {
                arg.fv = new float[1][];
                arg.fv[0] = stk.f;
            } else if (this.type == 'L') {
                arg.lv = new int[1][];
                arg.lv[0] = stk.l;
            }
            this.args[this.iArg++] = arg;
        }
        return true;
    }

    private Object s2o(String s, Object ref) {
        Object obj = null;
        try {
            obj = Convert.s2o(s, this.type, ref);
        }
        catch (MidasException midasException) {
            // empty catch block
        }
        return obj;
    }

    @Deprecated
    public boolean parseVariable(String s, Object ref) {
        this.addArg(s);
        Argument arg = new Argument(3, s);
        if (this.iStk >= this.maxStk) {
            this.badArg("Stack too small for constant " + arg.name);
        }
        Data data = (Data)Convert.s2o(s, this.type, ref);
        Stack stk = this.getStack(data.spa, 1, data);
        if (this.type == 'D') {
            arg.dv = new double[1][];
            arg.dv[0] = stk.d;
        } else if (this.type == 'F') {
            arg.fv = new float[1][];
            arg.fv[0] = stk.f;
        } else if (this.type == 'L') {
            arg.lv = new int[1][];
            arg.lv[0] = stk.l;
        }
        this.stks[this.iStk++] = stk;
        this.args[this.iArg++] = arg;
        return true;
    }

    public Argument parseStackIn(String s, Data data, int size) {
        this.addArg(s);
        Argument arg = new Argument(11, s);
        if (this.iStk >= this.maxStk) {
            this.badArg("Stack too small for argument " + arg.name);
        }
        Stack stk = this.getStack(data.spa, size, data);
        if (this.type == 'D') {
            arg.dv = new double[1][];
            arg.dv[0] = stk.d;
        } else if (this.type == 'F') {
            arg.fv = new float[1][];
            arg.fv[0] = stk.f;
        } else if (this.type == 'L') {
            arg.lv = new int[1][];
            arg.lv[0] = stk.l;
        }
        this.stks[this.iStk++] = stk;
        this.args[this.iArg++] = arg;
        return arg;
    }

    public Argument parseStackOut(String s) {
        this.addArg("=" + s);
        Argument arg = new Argument(12, s);
        if (this.iStk <= 0) {
            this.badArg("Nothing on Stack for argument " + arg.name);
        }
        Stack stk = this.stks[--this.iStk];
        if (this.type == 'D') {
            arg.dv = new double[1][];
            arg.dv[0] = stk.d;
        } else if (this.type == 'F') {
            arg.fv = new float[1][];
            arg.fv[0] = stk.f;
        } else if (this.type == 'L') {
            arg.lv = new int[1][];
            arg.lv[0] = stk.l;
        }
        this.args[this.iArg++] = arg;
        return arg;
    }

    private Stack getStack(int mode, int size, Data data) {
        Stack stk = new Stack();
        stk.mode = mode;
        stk.size = size;
        if (this.type == 'D') {
            stk.d = new double[size * mode];
            if (data != null) {
                data.toArray(stk.d);
            }
        } else if (this.type == 'F') {
            stk.f = new float[size * mode];
            if (data != null) {
                data.toArray(stk.f);
            }
        } else if (this.type == 'L') {
            stk.l = new int[size * mode];
            if (data != null) {
                data.toArray(stk.l);
            }
        }
        return stk;
    }

    public int parseDone() {
        this.nArgs = this.iArg;
        if (this.iStk != 0) {
            this.badArg("Invalid number of arguments parsed, " + this.iStk + " left on stack");
        }
        return this.iStk;
    }

    public String getFormat() {
        int mode = this.stks[this.iStk - 1].mode;
        String fm = "S";
        if (mode == 2) {
            fm = "C";
        }
        if (mode == 3) {
            fm = "V";
        }
        return fm + this.type;
    }

    public int process() {
        this.iArg = 0;
        while (this.iArg < this.nArgs) {
            int stat = 0;
            Argument arg = this.args[this.iArg];
            if (arg.kind != 11 && arg.kind != 12) {
                if (this.type == 'D') {
                    stat = arg.op.process(arg.dv, arg.size, arg.mode);
                } else if (this.type == 'F') {
                    stat = arg.op.process(arg.fv, arg.size, arg.mode);
                } else if (this.type == 'L') {
                    stat = arg.op.process(arg.lv, arg.size, arg.mode);
                }
            }
            if (stat < 0) {
                return stat;
            }
            ++this.iArg;
        }
        return this.nArgs;
    }

    public double[] result() {
        return this.args[this.nArgs - 1].dv[0];
    }

    private void addArg(String arg) {
        this.rawArgs = this.rawArgs == null ? arg : this.rawArgs + "," + arg;
    }

    public void badArg(String reason) {
        if (this.nArgs == 0) {
            this.rawArgs = this.rawArgs + ",...";
        }
        throw new MidasException(reason + " in (" + this.rawArgs + ")");
    }

    private class Stack {
        int mode;
        int size;
        double[] d;
        float[] f;
        int[] l;

        private Stack() {
        }
    }
}

