/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Label;
import java.awt.List;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.beans.Expression;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.table.JTableHeader;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.Widget;
import nxm.sys.lib.Message;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Util;
import nxm.sys.libg.MBox;

public final class WidgetWrapper
implements Keyable,
ActionListener,
ChangeListener,
ItemListener,
AdjustmentListener,
TextListener,
Widget.WidgetListener {
    private static final String[] KEYS = new String[]{"V", "VALUE", "POS", "POSITION", "THEME", "TITLE"};
    private final Component comp;
    private final Widget widget;
    private final MessageHandler mh;
    private final String name;
    private final Object data;
    private final Object tid;
    private final Object fid;
    private static final boolean DEF_SEND_MSG = true;
    private boolean sendMsg = true;

    public WidgetWrapper(Widget widget, MessageHandler mh, String name, Object data, Object tid, Object fid) {
        this(widget, widget.getWidgetComponent(), mh, name, data, tid, fid);
    }

    public WidgetWrapper(Component comp, MessageHandler mh, String name, Object data, Object tid, Object fid) {
        this(null, comp, mh, name, data, tid, fid);
    }

    private WidgetWrapper(Widget widget, Component comp, MessageHandler mh, String name, Object data, Object tid, Object fid) {
        if (widget == null && comp instanceof Widget) {
            widget = (Widget)((Object)comp);
        }
        this.widget = widget;
        this.comp = comp;
        this.mh = mh;
        this.name = name;
        this.data = data;
        this.tid = tid;
        this.fid = fid;
        Class<? extends EventListener> listenerClass = this.getListenerClass();
        if (listenerClass != null) {
            try {
                String methName = "add" + Util.getClassName(listenerClass);
                Object[] params = new Object[]{this};
                Method listener = comp.getClass().getMethod(methName, listenerClass);
                listener.invoke((Object)comp, params);
            }
            catch (Exception e) {
                Shell.printStackTrace("ERROR: PANEL/JSETUP: Unable to add listener of type " + listenerClass.getName() + " to widget " + name, e);
            }
        }
    }

    private Class<? extends EventListener> getListenerClass() {
        if (this.widget != null) {
            return this.widget.getWidgetEventListener();
        }
        if (this.comp instanceof JComponent) {
            if (this.comp instanceof AbstractButton) {
                return ActionListener.class;
            }
            if (this.comp instanceof BasicInternalFrameTitlePane) {
                return null;
            }
            if (this.comp instanceof Box) {
                return null;
            }
            if (this.comp instanceof Box.Filler) {
                return null;
            }
            if (this.comp instanceof JColorChooser) {
                return null;
            }
            if (this.comp instanceof JComboBox) {
                return ItemListener.class;
            }
            if (this.comp instanceof JFileChooser) {
                return null;
            }
            if (this.comp instanceof JInternalFrame) {
                return null;
            }
            if (this.comp instanceof JInternalFrame.JDesktopIcon) {
                return null;
            }
            if (this.comp instanceof JLabel) {
                return null;
            }
            if (this.comp instanceof JLayeredPane) {
                return null;
            }
            if (this.comp instanceof JList) {
                return null;
            }
            if (this.comp instanceof JMenuBar) {
                return null;
            }
            if (this.comp instanceof JOptionPane) {
                return null;
            }
            if (this.comp instanceof JPanel) {
                return null;
            }
            if (this.comp instanceof JPopupMenu) {
                return null;
            }
            if (this.comp instanceof JProgressBar) {
                return null;
            }
            if (this.comp instanceof JRootPane) {
                return null;
            }
            if (this.comp instanceof JScrollBar) {
                return null;
            }
            if (this.comp instanceof JScrollPane) {
                return null;
            }
            if (this.comp instanceof JSeparator) {
                return null;
            }
            if (this.comp instanceof JSlider) {
                return ChangeListener.class;
            }
            if (this.comp instanceof JSpinner) {
                return ChangeListener.class;
            }
            if (this.comp instanceof JSplitPane) {
                return null;
            }
            if (this.comp instanceof JTabbedPane) {
                return ChangeListener.class;
            }
            if (this.comp instanceof JTable) {
                return null;
            }
            if (this.comp instanceof JTableHeader) {
                return null;
            }
            if (this.comp instanceof JTextField) {
                return ActionListener.class;
            }
            if (this.comp instanceof JTextArea) {
                return null;
            }
            if (this.comp instanceof JEditorPane) {
                return null;
            }
            if (this.comp instanceof JToolBar) {
                return null;
            }
            if (this.comp instanceof JToolTip) {
                return null;
            }
            if (this.comp instanceof JTree) {
                return null;
            }
            if (this.comp instanceof JViewport) {
                return null;
            }
            Shell.warning("PANEL/JSETUP: JComponent type (" + this.comp.getClass().getName() + ") not recognized by NeXtMidas, no messages will be made for component " + this.name + ". Have " + this.name + " implement nxm.sys.inc.Widget to avoid this warning.");
            return null;
        }
        if (this.comp instanceof Button) {
            return ActionListener.class;
        }
        if (this.comp instanceof Canvas) {
            return null;
        }
        if (this.comp instanceof Checkbox) {
            return ItemListener.class;
        }
        if (this.comp instanceof Choice) {
            return ItemListener.class;
        }
        if (this.comp instanceof Container) {
            return null;
        }
        if (this.comp instanceof Label) {
            return null;
        }
        if (this.comp instanceof List) {
            return ItemListener.class;
        }
        if (this.comp instanceof Scrollbar) {
            return AdjustmentListener.class;
        }
        if (this.comp instanceof TextComponent) {
            return TextListener.class;
        }
        Shell.warning("PANEL/JSETUP: Component type (" + this.comp.getClass().getName() + ") not recognized by NeXtMidas, no messages will be made for component " + this.name + ". Have " + this.name + " implement nxm.sys.inc.Widget to avoid this warning.");
        return null;
    }

    public void setAction(Object value) {
        if (this.widget != null) {
            this.widget.setWidgetAction(value);
        } else {
            this.setValue(value);
        }
    }

    public void setParent(Object value) {
    }

    public void setValue(Object value) {
        this.setValue(value, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(Object value, boolean sendMsg) {
        this.sendMsg = sendMsg;
        if (this.widget != null) {
            this.widget.setWidgetValue(value);
        } else if (this.comp instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)this.comp;
            String str = value.toString().toUpperCase();
            int index = -1;
            for (int i = 0; index < 0 && i < tabbedPane.getTabCount(); ++i) {
                if (!tabbedPane.getTitleAt(i).equals(str)) continue;
                index = i;
            }
            if (index < 0) throw new MidasException("WidgetWrapper: Can not set tab to '" + str + "' for " + this.name + ".");
            tabbedPane.setSelectedIndex(index);
        } else if (this.comp != null) {
            double fp = 0.0;
            long in = 0L;
            Object[] val = new Object[]{value};
            Object[] valS = new String[]{"" + value};
            Object[] valB = new Boolean[]{StringUtil.isTrue(valS[0])};
            try {
                fp = Double.parseDouble(valS[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                in = Long.parseLong(valS[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object[] valD = new Number[]{fp};
            Object[] valL = new Number[]{in};
            Object[] valF = new Number[]{Float.valueOf((float)fp)};
            Object[] valI = new Number[]{(int)in};
            Expression[] expressions = new Expression[]{new Expression(this.comp, "setValue", val), new Expression(this.comp, "setValue", valS), new Expression(this.comp, "setValue", valB), new Expression(this.comp, "setValue", valD), new Expression(this.comp, "setValue", valL), new Expression(this.comp, "setValue", valF), new Expression(this.comp, "setValue", valI), new Expression(this.comp, "setSelected", valB), new Expression(this.comp, "setText", val), new Expression(this.comp, "setText", valS), new Expression(this.comp, "setSelectedItem", val)};
            WidgetWrapper.executeExp(expressions);
        }
        this.sendMsg = true;
    }

    public Object getValue() {
        Object value = null;
        if (this.widget != null) {
            value = this.widget.getWidgetValue();
        } else if (this.comp instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)this.comp;
            value = tabbedPane.getTitleAt(tabbedPane.getSelectedIndex());
        } else if (this.comp != null) {
            Expression[] expressions = new Expression[]{new Expression(this.comp, "getValue", new Object[0]), new Expression(this.comp, "isSelected", new Object[0]), new Expression(this.comp, "getText", new Object[0]), new Expression(this.comp, "getSelectedItem", new Object[0])};
            value = WidgetWrapper.executeExp(expressions);
        }
        return value;
    }

    public void setTitle(Object value) {
        if (this.widget != null) {
            this.widget.setWidgetTitle(value);
        } else if (this.comp != null) {
            Object[] val = new Object[]{value};
            Object[] valS = new String[]{"" + value};
            Expression[] expressions = new Expression[]{new Expression(this.comp, "setTitle", val), new Expression(this.comp, "setTitle", valS), new Expression(this.comp, "setName", val), new Expression(this.comp, "setName", valS)};
            WidgetWrapper.executeExp(expressions);
        }
    }

    public Object getTitle() {
        Object title = null;
        if (this.widget != null) {
            title = this.widget.getWidgetTitle();
        } else if (this.comp != null) {
            Expression[] expressions = new Expression[]{new Expression(this.comp, "getTitle", new Object[0]), new Expression(this.comp, "getName", new Object[0])};
            title = WidgetWrapper.executeExp(expressions);
        }
        return title;
    }

    public Object getPosition() {
        if (this.comp == null) {
            return null;
        }
        Rectangle bounds = this.comp.getBounds();
        return new MBox(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void setPosition(MBox box) {
        if (this.comp != null) {
            this.comp.setBounds(box.x, box.y, box.w, box.h);
        }
    }

    public void refresh() {
        if (this.comp != null) {
            this.comp.repaint();
        }
    }

    @Override
    public Object getKey(String key) {
        if (key.equals("V")) {
            return this.getValue();
        }
        if (key.equals("VALUE")) {
            return this.getValue();
        }
        if (key.equals("POS")) {
            return this.getPosition();
        }
        if (key.equals("PARENT")) {
            return null;
        }
        if (key.equals("THEME")) {
            return null;
        }
        if (key.equals("TITLE")) {
            return this.getTitle();
        }
        return null;
    }

    @Override
    public String[] getKeys() {
        return KEYS;
    }

    @Override
    public Object setKey(String key, Object value) {
        if (key.equals("V")) {
            this.setValue(value);
            return value;
        }
        if (key.equals("VALUE")) {
            this.setValue(value);
            return value;
        }
        if (key.equals("ACTION")) {
            this.setAction(value);
            return value;
        }
        if (key.equals("POS")) {
            this.setPosition((MBox)value);
            return value;
        }
        if (key.equals("PARENT")) {
            this.setParent(value);
            return value;
        }
        if (key.equals("TITLE")) {
            this.setTitle(value);
            return value;
        }
        if (key.equals("SHOW")) {
            this.comp.setVisible(true);
            return value;
        }
        if (key.equals("REFRESH")) {
            this.refresh();
            return value;
        }
        return null;
    }

    private static Object executeExp(Expression[] exps) {
        for (int i = 0; i < exps.length; ++i) {
            try {
                return exps[i].getValue();
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    public String toString() {
        String clazz = this.comp == null ? "Unknown Widget" : this.comp.getClass().getName();
        return "WidgetWrapper for a '" + clazz + "' named '" + this.name + "'";
    }

    public Object getWidget() {
        return this.widget != null ? this.widget : this.comp;
    }

    private void sendMessage(EventObject e) {
        Object d;
        Object object = d = this.data != null ? this.data : this.getValue();
        if (this.mh != null && this.sendMsg) {
            Table quals = new Table();
            quals.put("EVENT", (Object)e);
            this.mh.processMessage(new Message(this.name, 0, d, this.tid, this.fid, quals));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.sendMessage(e);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.sendMessage(e);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.sendMessage(e);
    }

    @Override
    public void textValueChanged(TextEvent e) {
        this.sendMessage(e);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.sendMessage(e);
    }

    @Override
    public void widgetUpdated(EventObject e) {
        this.sendMessage(e);
    }
}

