/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.Message;
import nxm.sys.lib.Parser;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GPrompt;
import nxm.sys.libg.Layer;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MPlot;

public class Surface
implements MessageHandler {
    public static final String typeList = "Fill,Mesh,Dot,Contour";
    public static final int FILL = 1;
    public static final int MESH = 2;
    public static final int DOTS = 4;
    public static final int CONT = 8;
    public int type = 1;
    public int ncolors;
    public int cmap;
    public Color[] colors;
    public Layer layer;
    public MPlot MP;

    public void setType(int value) {
        this.type = value;
        this.refresh();
    }

    public void setType(String value) {
        this.setType(Parser.mask(typeList, value, this.type));
    }

    public void configure() {
        new GMenu(this.MP, "Surface.cfg", "Fill,Mesh,Dot,Contour,ColorMap>,Colors>", this.type, 1024, this);
    }

    @Override
    public int processMessage(Message msg) {
        if (msg.name.equals("SURFACE.CFG")) {
            String text = (String)msg.data;
            if (text.equals("COLORMAP>")) {
                new GMenu(this.MP, "Colormap", "GrayScale,Ramp,XRamp,Wheel,Terrain,Multi,T5Layer,MapLine,Grid,Spectrum,XDatalist", this.cmap, 0, this);
            } else if (text.equals("COLORS>")) {
                new GPrompt(this.MP, "Colors", "", 0, (MessageHandler)this);
            } else {
                this.setType(msg.info);
            }
        } else if (msg.name.equals("COLORMAP")) {
            this.setColorMap(msg.info);
        } else if (msg.name.equals("COLORS")) {
            this.setColors((String)msg.data);
        } else if (msg.name.equals("TYPE")) {
            this.setType((String)msg.data);
        } else {
            return 0;
        }
        return 1;
    }

    public void setColors(String value) {
        if (value.length() == 0) {
            return;
        }
        this.colors = MColor.getColorMap(value, -1);
        this.ncolors = this.colors.length - 1;
        this.refresh();
    }

    public void setColorMap(int value) {
        this.setColorMap(value, -1);
    }

    public void setColorMap(int value, int ncolors) {
        if (value == -1) {
            value = this.cmap;
        }
        if (value < 1 || value > 9) {
            return;
        }
        if (value == this.cmap && ncolors == this.ncolors) {
            return;
        }
        this.cmap = value;
        this.colors = MColor.getColorMap(value, ncolors);
        this.ncolors = this.colors.length - 1;
        this.refresh();
    }

    public void refresh() {
        this.layer.refresh();
    }
}

