/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Message;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MJFileChooser;
import nxm.sys.libg.MWindow;

public class MJPopup {
    private static boolean DEBUG = false;
    private static final String[] NO_BUTTONS = new String[0];
    private static final Integer ZERO = 0;
    private static final Integer USER_CANCEL = -1;
    private static final Integer FORCE_CANCEL = -2;
    private static final Pattern SEP_REGEX = Pattern.compile("[,|]");
    public static final int[] POSITION_CENTER = null;
    public static final int[] POSITION_MOUSE = new int[0];
    public static final String blockingOptionsList = "Macro,Mouse";
    public static final int BLOCK_MACRO = 1;
    public static final int BLOCK_MOUSE = 2;
    private Component parent;
    private JOptionPane optionPane;
    private JDialog dialogBox;
    private HasValue valuator;
    private boolean cancel;
    private int blocking;
    private static int popWidth = 80;

    public MJPopup(int popWidth) {
        MJPopup.popWidth = popWidth;
    }

    private MJPopup(Component parent, JOptionPane optionPane, JDialog dialogBox, HasValue valuator) {
        this.parent = parent;
        this.optionPane = optionPane;
        this.dialogBox = dialogBox;
        this.valuator = valuator;
    }

    public boolean getCancel() {
        Object[] val = this.getInfoValue();
        return val[2] != ZERO;
    }

    public int getInfo() {
        Object[] infoValue = this.getInfoValue();
        return (Integer)infoValue[0];
    }

    public Object getValue() {
        Object[] infoValue = this.getInfoValue();
        return infoValue[1];
    }

    public void dispose() {
        if (this.dialogBox != null) {
            this.dialogBox.dispose();
            this.dialogBox = null;
        }
        this.optionPane = null;
    }

    private boolean isYesNo() {
        int type = this.optionPane.getOptionType();
        return type == 1 || type == 0;
    }

    private Object[] getInfoValue() {
        Object value = this.optionPane == null ? null : this.optionPane.getValue();
        Object input = null;
        Integer info = ZERO;
        Integer cancl = ZERO;
        if (this.cancel || value == JOptionPane.UNINITIALIZED_VALUE) {
            cancl = FORCE_CANCEL;
        } else if (value == null) {
            cancl = USER_CANCEL;
        } else {
            int optionType = this.optionPane.getOptionType();
            info = ZERO;
            input = value.toString();
            if (value instanceof Number) {
                int button = ((Number)value).intValue();
                if (button == 0 && this.valuator != null) {
                    info = this.valuator.getInfo();
                    input = this.valuator.getValue();
                } else if (button == 0) {
                    input = this.isYesNo() ? "YES" : "OK";
                } else if (button == 1) {
                    input = "NO";
                } else {
                    cancl = USER_CANCEL;
                }
            } else {
                Object[] options = this.optionPane.getOptions();
                info = null;
                for (int i = 0; i < options.length && info == null; ++i) {
                    if (options[i] != input) continue;
                    info = i + 1;
                }
            }
        }
        if (cancl != ZERO) {
            info = cancl;
            input = "CANCEL";
        }
        return new Object[]{info, input, cancl};
    }

    public boolean isDone() {
        boolean uninit = this.optionPane != null && this.optionPane.getValue() == JOptionPane.UNINITIALIZED_VALUE;
        return this.cancel || !uninit;
    }

    public void cancel() {
        this.cancel = true;
    }

    private Object display() {
        this.display(3);
        Object[] val = this.getInfoValue();
        return val[2] == ZERO ? val[1] : null;
    }

    public void display(int blocking) {
        this.display(blocking, POSITION_CENTER);
    }

    public void display(int blocking, int[] position) {
        this.display(null, blocking, POSITION_CENTER);
    }

    public void display(MWindow mw, int blocking, int[] position) {
        this.display(mw, null, null, blocking, position);
    }

    private void display(MWindow mw, MessageHandler msgHandler, String msgName, int blocking, int[] position) {
        boolean modal = (blocking & 2) != 0;
        boolean block = (blocking & 1) != 0;
        this.setDialogPosition(position, mw);
        this.dialogBox.setModal(modal);
        if (block) {
            this.dialogBox.setVisible(true);
        } else {
            new MJPopupThread(msgHandler, msgName).start();
        }
    }

    private void sendMessage(MessageHandler msgHandler, String msgName) {
        if (msgHandler != null) {
            Message msg = new Message(msgName, this.getInfo(), this.getValue());
            msgHandler.processMessage(msg);
        }
    }

    private static Rectangle getBounds(Component parent) {
        Rectangle parentBounds = parent != null ? parent.getBounds() : GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        return parentBounds;
    }

    private static Point getCenterPoint(Component parent) {
        Point centerPoint;
        if (parent != null && parent.isShowing()) {
            Rectangle parentBounds = parent.getBounds();
            centerPoint = parent.getLocationOnScreen();
            centerPoint.x += parentBounds.width / 2;
            centerPoint.y += parentBounds.height / 2;
        } else {
            centerPoint = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        }
        return centerPoint;
    }

    private static Dimension getMaxSize(Component parent) {
        double scaleFact = parent != null ? 1.0 : 0.5;
        return MJPopup.getMaxSize(parent, scaleFact);
    }

    private static Dimension getAbsSize(Component parent) {
        return MJPopup.getMaxSize(parent, 1.0);
    }

    private static Dimension getMaxSize(Component parent, double scaleFact) {
        Rectangle parentBounds = MJPopup.getBounds(parent);
        int maxWidth = Math.max(400, (int)(scaleFact * parentBounds.getWidth()));
        int maxHeight = Math.max(200, (int)(scaleFact * parentBounds.getHeight()));
        return new Dimension(maxWidth, maxHeight);
    }

    private static int findColCount(int count, int width, int height, Dimension maxSize, Dimension absSize) {
        int stdWidth = (int)(1.5f * (float)width);
        int stdHeight = (int)(1.5f * (float)height);
        int columns = -1;
        int cols = 1;
        while (columns <= 0) {
            int rows = (count + cols - 1) / cols;
            int totWidth = stdWidth * (count / rows);
            int totHeight = stdHeight * (count / cols);
            if (totWidth > maxSize.width) {
                columns = absSize != null ? MJPopup.findColCount(count, width, height, absSize, null) : cols;
            } else if (totHeight <= maxSize.height) {
                columns = cols;
            }
            ++cols;
        }
        return columns;
    }

    private void setDialogPosition(int[] position, MWindow mw) {
        Rectangle parentBounds = MJPopup.getBounds(this.parent);
        Point centerPoint = MJPopup.getCenterPoint(this.parent);
        Dimension size = this.dialogBox.getSize();
        boolean manual = false;
        int x = -1;
        int y = -1;
        int w = this.dialogBox.getWidth();
        int h = this.dialogBox.getHeight();
        if (position != POSITION_CENTER) {
            if (position == POSITION_MOUSE) {
                centerPoint = MJPopup.getMousePosition(mw);
            } else if (position.length == 2 || position.length == 4) {
                Point los = this.parent == null ? new Point(0, 0) : this.parent.getLocationOnScreen();
                manual = true;
                x = position[0] + los.x;
                y = position[1] + los.y;
                if (position.length == 4) {
                    w = position[2];
                    h = position[3];
                }
            } else {
                throw new MidasException("MJPopup: Illegal dialog position, expected POSITION_CENTER, POSITION_MOUSE, {x,y}, or {x,y,w,h} but got " + Arrays.toString(position));
            }
        }
        if (x < 0) {
            x = centerPoint.x - w / 2;
        }
        if (y < 0) {
            y = centerPoint.y - h / 2;
        }
        if (!manual) {
            Rectangle screen = MJPopup.getBounds(null);
            int maxX = screen.x + screen.width;
            int maxY = screen.y + screen.height;
            w = Math.min(w, screen.width);
            h = Math.min(h, screen.height);
            if (x < screen.x) {
                x = screen.x;
            } else if (x + w > maxX) {
                x = maxX - w;
            }
            if (y < screen.y) {
                y = screen.y;
            } else if (y + h > maxY) {
                y = maxY - h;
            }
        }
        this.dialogBox.setBounds(x, y, w, h);
    }

    private static Point getMousePosition(MWindow mw) {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        return pointerInfo == null ? MJPopup.getCenterPoint(null) : pointerInfo.getLocation();
    }

    private static MJPopup create(Component parent, String title, int messageType, HasValue valuator) {
        return MJPopup.create(parent, title, messageType, valuator, null, 2);
    }

    private static MJPopup create(Component parent, String title, int messageType, Object message, Object[] options) {
        return MJPopup.create(parent, title, messageType, message, options, 2);
    }

    private static MJPopup create(Component parent, String title, int messageType, Object message, int optionType) {
        return MJPopup.create(parent, title, messageType, message, null, optionType);
    }

    private static MJPopup create(Component parent, String title, int messageType, Object message, Object[] options, int optionType) {
        HasValue valuator = null;
        Icon icon = null;
        Object initialValue = null;
        if (message instanceof HasValue) {
            valuator = (HasValue)message;
        }
        if (DEBUG) {
            System.out.println("MJPopup.create");
            System.out.println("  parent       = " + parent);
            System.out.println("  message      = " + message);
            System.out.println("  messageType  = " + messageType);
            System.out.println("  optionType   = " + optionType);
            System.out.println("  icon         = " + icon);
            System.out.println("  options      = " + options);
            System.out.println("  initialValue = " + initialValue);
            System.out.println("  valuator     = " + valuator);
        }
        JOptionPane optionPane = new JOptionPane(message, messageType, optionType, icon, options, initialValue){

            @Override
            public int getMaxCharactersPerLineCount() {
                return popWidth;
            }
        };
        optionPane.setWantsInput(false);
        JDialog dialogBox = optionPane.createDialog(parent, title);
        dialogBox.setDefaultCloseOperation(0);
        dialogBox.setResizable(true);
        if (dialogBox.getTitle() != null) {
            FontMetrics fm = dialogBox.getFontMetrics(dialogBox.getFont());
            int width = fm.stringWidth(dialogBox.getTitle()) + 75;
            width = Math.max(width, dialogBox.getPreferredSize().width);
            dialogBox.setSize(new Dimension(width, dialogBox.getPreferredSize().height));
        }
        return new MJPopup(parent, optionPane, dialogBox, valuator);
    }

    private static final String toString(Object obj, String def) {
        return obj == null ? def : obj.toString();
    }

    private static final String toString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    private static final String[] toStringArray(Object obj, boolean upcase) {
        String str = MJPopup.toString(obj, "");
        if (upcase) {
            str = str.toUpperCase();
        }
        return SEP_REGEX.split(str);
    }

    public static MJPopup createYesNo(Component parent, String title, int messageType, Object message) {
        return MJPopup.create(parent, title, messageType, message, 0);
    }

    public static MJPopup createYesNoCancel(Component parent, String title, int messageType, Object message) {
        return MJPopup.create(parent, title, messageType, message, 1);
    }

    public static MJPopup createOk(Component parent, String title, int messageType, Object message) {
        return MJPopup.create(parent, title, messageType, message, -1);
    }

    public static MJPopup createOkCancel(Component parent, String title, int messageType, Object message) {
        return MJPopup.create(parent, title, messageType, message, 2);
    }

    public static MJPopup createButtons(Component parent, String title, int messageType, Object message, Object[] choices) {
        return MJPopup.create(parent, title, messageType, message, choices);
    }

    public static MJPopup createAlert(Component parent, String title, int messageType, Object message) {
        return MJPopup.createButtons(parent, title, messageType, message, NO_BUTTONS);
    }

    public static MJPopup createText(Component parent, String title, int messageType, Object message, Object defValue) {
        return MJPopup.create(parent, title, messageType, new TextPanel(null, message, defValue, false));
    }

    public static MJPopup createPassword(Component parent, String title, int messageType, Object message, Object defValue) {
        return MJPopup.create(parent, title, messageType, new TextPanel(null, message, defValue, true));
    }

    public static MJPopup createLogin(Component parent, String title, int messageType, Object message, Object defValue) {
        return MJPopup.create(parent, title, messageType, new LoginPanel(null, message, defValue));
    }

    public static MJPopup createChoice(Component parent, String title, int messageType, Object message, Object[] choices, Object defValue) {
        return MJPopup.create(parent, title, messageType, new ChoicePanel(null, message, choices, defValue));
    }

    public static MJPopup createMask(Component parent, String title, int messageType, Object message, Object[] choices, Object defValue) {
        return MJPopup.createMask(parent, title, messageType, message, choices, defValue, false);
    }

    public static MJPopup createMask(Component parent, String title, int messageType, Object message, Object[] choices, Object defValue, boolean outputArray) {
        return MJPopup.create(parent, title, messageType, new MaskPanel(null, message, choices, defValue, MJPopup.getMaxSize(parent), MJPopup.getAbsSize(null), outputArray));
    }

    public static MJPopup createIntMask(Component parent, String title, int messageType, Object message, Object[] choices, Object defValue) {
        int maxWidth = MJPopup.getMaxSize((Component)parent).width;
        return MJPopup.create(parent, title, messageType, new IntMaskPanel(null, message, choices, defValue, maxWidth));
    }

    public static MJPopup createColor(Component parent, String title, int messageType, Object message, Object defValue) {
        return MJPopup.create(parent, title, messageType, new ColorPanel(null, message, defValue));
    }

    public static MJPopup createFile(Component parent, String title, int messageType, Object message, Object defValue) {
        return MJPopup.createFile(parent, title, messageType, message, defValue, null, null, null);
    }

    public static MJPopup createFile(Component parent, String title, int messageType, Object message, Object defValue, String filter, String auxList, String pathOpt) {
        return MJPopup.create(parent, title, messageType, new MJFileChooser(null, message, defValue, filter, auxList, pathOpt, null));
    }

    @InternalUseOnly
    public static MJPopup createGroup(Component parent, String title, int messageType, Object message, Table parameters) {
        return MJPopup.create(parent, title, messageType, new GroupPanel(null, parameters));
    }

    public static String showYesNo(Component parent, String title, int messageType, Object message) {
        return MJPopup.toString(MJPopup.createYesNo(parent, title, messageType, message).display());
    }

    public static String showYesNoCancel(Component parent, String title, int messageType, Object message) {
        return MJPopup.toString(MJPopup.createYesNoCancel(parent, title, messageType, message).display());
    }

    public static String showOk(Component parent, String title, int messageType, Object message) {
        return MJPopup.toString(MJPopup.createOk(parent, title, messageType, message).display());
    }

    public static String showOkCancel(Component parent, String title, int messageType, Object message) {
        return MJPopup.toString(MJPopup.createOkCancel(parent, title, messageType, message).display());
    }

    public static Object showButtons(Component parent, String title, int messageType, Object message, Object[] choices) {
        return MJPopup.createButtons(parent, title, messageType, message, choices).display();
    }

    public static String showText(Component parent, String title, int messageType, Object message, Object defValue) {
        return MJPopup.toString(MJPopup.createText(parent, title, messageType, message, defValue).display());
    }

    public static String showPassword(Component parent, String title, int messageType, Object message, Object defValue) {
        return MJPopup.toString(MJPopup.createPassword(parent, title, messageType, message, defValue).display());
    }

    public static Table showLogin(Component parent, String title, int messageType, Object message, Object defValue) {
        return Convert.o2t(MJPopup.createLogin(parent, title, messageType, message, defValue).display());
    }

    public static Object showChoice(Component parent, String title, int messageType, Object message, Object[] choices, Object defValue) {
        return MJPopup.createChoice(parent, title, messageType, message, choices, defValue).display();
    }

    public static String showMaskString(Component parent, String title, int messageType, Object message, Object[] choices, Object defValue) {
        return MJPopup.toString(MJPopup.createMask(parent, title, messageType, message, choices, defValue, false).display());
    }

    public static Object[] showMaskArray(Component parent, String title, int messageType, Object message, Object[] choices, Object defValue) {
        return (Object[])MJPopup.createMask(parent, title, messageType, message, choices, defValue, true).display();
    }

    public static Color showColor(Component parent, String title, int messageType, Object message, Object defValue) {
        Object val = MJPopup.createColor(parent, title, messageType, message, defValue).display();
        return val == null ? null : MColor.getColor(val);
    }

    public static String showFile(Component parent, String title, int messageType, Object message, Object defValue) {
        return MJPopup.showFile(parent, title, messageType, message, defValue, null, null, null);
    }

    public static String showFile(Component parent, String title, int messageType, Object message, Object defValue, String filter, String auxList, String pathOpt) {
        return MJPopup.toString(MJPopup.createFile(parent, title, messageType, message, defValue, filter, auxList, pathOpt).display());
    }

    private static class LoginPanel
    extends ValuePanel {
        private JTextField user;
        private JPasswordField pass;

        public LoginPanel(String name, Object msg, Object def) {
            super(new BorderLayout(), name, "LOGIN");
            JPanel panel2 = new JPanel(new GridLayout(2, 2));
            this.user = new JTextField(MJPopup.toString(def, ""));
            this.pass = new JPasswordField(16);
            this.add((Component)new JLabel(msg.toString()), "North");
            this.add((Component)panel2, "Center");
            panel2.add(new JLabel("User:"));
            panel2.add(this.user);
            panel2.add(new JLabel("Password:"));
            panel2.add(this.pass);
        }

        @Override
        public Object getValue() {
            return "{USER=" + this.user.getText() + ",PASS=" + new String(this.pass.getPassword()) + "}";
        }

        @Override
        public int getInfo() {
            return 0;
        }
    }

    private static class TextPanel
    extends ValuePanel {
        private JTextField input;

        public TextPanel(String name, Object msg, Object def, boolean passwd) {
            super(new BorderLayout(), name, passwd ? "PASSWORD" : "TEXT");
            this.input = passwd ? new JPasswordField(MJPopup.toString(def, "")) : (def != null ? new JTextField(MJPopup.toString(def, "")) : new JTextField());
            this.add((Component)new JLabel(msg.toString()), "North");
            this.add((Component)this.input, "Center");
        }

        @Override
        public Object getValue() {
            return this.input.getText();
        }

        @Override
        public int getInfo() {
            return 0;
        }
    }

    private static class IntMaskPanel
    extends ValuePanel {
        private JCheckBox[] checkBoxes;
        private String list;

        public IntMaskPanel(String name, Object msg, Object[] choices, Object defValue, int maxWidth) {
            super(new BorderLayout(), name, "INTMASK");
            this.list = StringUtil.join(choices, ",");
            this.checkBoxes = new JCheckBox[choices.length];
            if (this.checkBoxes.length >= 32) {
                Shell.getSharedMidasContext().warning("MJPopup: IntMask popup (MASK) will not work correctly when given 32+ options, use string-based Mask popup (MASK/S).");
            }
            int mask = Parser.mask(this.list, MJPopup.toString(defValue, ""), 0);
            int width = 0;
            for (int i = 0; i < this.checkBoxes.length; ++i) {
                boolean checked = (mask & 1) != 0;
                this.checkBoxes[i] = new JCheckBox(choices[i].toString(), checked);
                mask >>>= 1;
                width = Math.max(width, this.checkBoxes[i].getMinimumSize().width);
            }
            int cols = Math.min(choices.length, Math.max(1, 2 * maxWidth / (3 * width)));
            JPanel panel2 = new JPanel(new GridLayout(0, cols));
            this.add((Component)new JLabel(msg.toString()), "North");
            this.add((Component)panel2, "Center");
            for (int i = 0; i < this.checkBoxes.length; ++i) {
                panel2.add(this.checkBoxes[i]);
            }
        }

        @Override
        public Object getValue() {
            return Parser.mask2s(this.list, this.getInfo());
        }

        @Override
        public int getInfo() {
            int mask = 0;
            int value = 1;
            for (int i = 0; i < this.checkBoxes.length; ++i) {
                if (this.checkBoxes[i].isSelected()) {
                    mask |= value;
                }
                value <<= 1;
            }
            return mask;
        }
    }

    private static class MaskPanel
    extends ValuePanel {
        protected JCheckBox[] checkBoxes;
        protected Object[] choices;
        protected boolean outputArray;

        public MaskPanel(String name, Object msg, Object[] choices, Object defValue, Dimension maxSize, Dimension absSize, boolean outputArray) {
            super(new BorderLayout(), name, "MASK");
            this.choices = choices;
            this.checkBoxes = new JCheckBox[choices.length];
            this.outputArray = outputArray;
            int width = 0;
            int height = 0;
            Object[] defMask = MJPopup.toStringArray(defValue, true);
            Arrays.sort(defMask);
            for (int i = 0; i < this.checkBoxes.length; ++i) {
                String option = choices[i].toString().toUpperCase();
                boolean checked = Arrays.binarySearch(defMask, option) >= 0;
                this.checkBoxes[i] = new JCheckBox(choices[i].toString(), checked);
                Dimension minSize = this.checkBoxes[i].getMinimumSize();
                width = Math.max(width, minSize.width);
                height = Math.max(height, minSize.height);
            }
            int cols = MJPopup.findColCount(this.checkBoxes.length, width, height, maxSize, absSize);
            JPanel panel2 = new JPanel(new GridLayout(0, cols));
            for (int i = 0; i < this.checkBoxes.length; ++i) {
                panel2.add(this.checkBoxes[i]);
            }
            this.add((Component)new JLabel(msg.toString()), "North");
            this.add((Component)panel2, "Center");
        }

        private Object[] getSelected() {
            ArrayList<Object> selected = new ArrayList<Object>();
            for (int i = 0; i < this.checkBoxes.length; ++i) {
                if (!this.checkBoxes[i].isSelected()) continue;
                selected.add(this.choices[i]);
            }
            return selected.toArray();
        }

        @Override
        public Object getValue() {
            Object[] selected = this.getSelected();
            return this.outputArray ? selected : StringUtil.join(selected, ",");
        }
    }

    private static class ChoicePanel
    extends ValuePanel {
        private JComboBox input;

        public ChoicePanel(String name, Object msg, Object[] choices, Object defValue) {
            super(new BorderLayout(), name, "CHOICE");
            this.input = new JComboBox<Object>(choices);
            this.input.setSelectedItem(defValue);
            this.add((Component)new JLabel(msg.toString()), "North");
            this.add((Component)this.input, "Center");
        }

        @Override
        public Object getValue() {
            return this.input.getSelectedItem();
        }

        @Override
        public int getInfo() {
            return this.input.getSelectedIndex() + 1;
        }
    }

    private static class ColorPanel
    extends ValuePanel {
        private JColorChooser input;

        public ColorPanel(String name, Object msg, Object defValue) {
            super(new BorderLayout(), name, "COLOR");
            this.input = new JColorChooser(MColor.getColor(defValue));
            this.add((Component)new JLabel(msg.toString()), "North");
            this.add((Component)this.input, "Center");
        }

        private Color getColor() {
            Color color = this.input.getColor();
            return color == null ? Color.black : color;
        }

        @Override
        public Object getValue() {
            return MColor.toString(this.getColor());
        }

        @Override
        public int getInfo() {
            return this.getColor().getRGB();
        }
    }

    private static class GroupPanel
    extends ValuePanel {
        private HasValue[] valuators;

        public GroupPanel(String name, Table tbl) {
            super(new GridLayout(0, 2), name, "GROUP");
            String[] keys = tbl.getKeys();
            this.valuators = new HasValue[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                Table params = tbl.getTable(keys[i]);
                String type = params.getS("TYPE");
                Object title = params.getO("TITLE");
                Object options = params.getO("OPTIONS");
                Object defaults = params.getO("DEFAULTS");
                this.addValuator(i, keys[i], type, title, options, defaults);
            }
        }

        private void addValuator(int index, String name, String type, Object title, Object options, Object defaults) {
            System.out.println("addValuator(" + type + ", " + title + ", " + options + ", " + defaults + ")");
            this.valuators[index] = new TextPanel(name, "", "", false);
        }

        @Override
        public Object getValue() {
            Table values = new Table();
            for (int i = 0; i < this.valuators.length; ++i) {
                values.put(this.valuators[i].getName(), this.valuators[i].getValue());
            }
            return values;
        }
    }

    private static abstract class ValuePanel
    extends JPanel
    implements HasValue {
        private String name;

        public ValuePanel(LayoutManager layout, String name, String defName) {
            super(layout);
            this.name = name == null ? defName : name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public int getInfo() {
            return 0;
        }
    }

    public static interface HasValue {
        public String getName();

        public Object getValue();

        public int getInfo();
    }

    private class MJPopupThread
    extends Thread {
        private MessageHandler msgHandler;
        private String msgName;

        public MJPopupThread(MessageHandler msgHandler, String msgName) {
            super("MJPopup: " + MJPopup.this.dialogBox.getTitle());
            this.msgHandler = null;
            this.msgName = null;
            this.msgHandler = msgHandler;
            this.msgName = msgName == null ? "POPUP" : msgName;
        }

        @Override
        public void run() {
            MJPopup.this.dialogBox.setVisible(true);
        }
    }
}

