/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JPanel;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Shell;
import nxm.sys.libg.MBox;
import nxm.sys.libg.MPanel;
import nxm.sys.libg.MWindow;
import nxm.sys.libg.MidasFrame;

public class MJPanel
extends JPanel
implements MidasFrame {
    private static final long serialVersionUID = 2012021080311L;
    @InternalUseOnly
    public static final String UNSERIALIZABLE_MJPANEL_OBJECT_MESSAGE = "nxm.sys.libg.MJPanel does NOT currently support Java Serialization";
    public transient MWindow MW;
    private String title;
    private boolean needrefresh = false;

    public MJPanel() {
        this((String)null);
    }

    public MJPanel(String name) {
        this.setLayout(null);
        this.setOpaque(true);
        this.setTitle(name);
    }

    void setTitle(String t) {
        this.title = t;
    }

    String getTitle() {
        return this.title;
    }

    @Override
    public void setMWindow(MWindow mw) {
        this.MW = mw;
        if (this.needrefresh) {
            this.MW.process("REFRESH", 0, null);
        }
        this.needrefresh = false;
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return Shell.getMidasContext().io.getOptions().indexOf("EnableGraphicsOptimizationRequiringNoOverlappingPanes") > -1;
    }

    @Override
    public MWindow getMWindow() {
        return this.MW;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.MW == null) {
            this.paintComponentBasic(g, this.title);
        } else if (this.MW.status != -2) {
            this.MW.paintComponent(g);
        } else {
            this.MW.process("PAINT", 0, g);
        }
    }

    void paintComponentBasic(Graphics g, String text) {
        Dimension d = this.getSize();
        g.setClip(0, 0, d.width, d.height);
        g.clearRect(0, 0, d.width, d.height);
        g.drawRect(4, 4, d.width - 8, d.height - 8);
        if (text != null) {
            g.drawString(text, 10, 20);
        }
        this.needrefresh = true;
    }

    @Override
    public void setBounds(MBox pos) {
        this.setBounds(pos.x, pos.y, pos.w, pos.h);
    }

    @Override
    public void resizePanel() {
    }

    @Override
    public void display(int mode) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
        if (this.MW != null) {
            this.MW.process("SHOWN", 1);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
        if (this.MW != null) {
            this.MW.process("SHOWN", -1);
        }
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        this.repaint();
        if (this.MW != null) {
            this.MW.process("SHOWN", 1);
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.MW != null) {
            this.MW.process("EXIT", 0);
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
        if (this.MW != null) {
            for (int ic = 0; ic < this.MW.panel.getComponentCount(); ++ic) {
                Component sub = this.MW.panel.getComponent(ic);
                if (!(sub instanceof MPanel)) continue;
                ((MPanel)sub).MW.process("SHOWN", -1);
            }
        }
    }

    @Override
    public Graphics getGraphics() {
        Graphics g = super.getGraphics();
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setBackground(this.getBackground());
        }
        return g;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        throw new UnsupportedOperationException(UNSERIALIZABLE_MJPANEL_OBJECT_MESSAGE);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException(UNSERIALIZABLE_MJPANEL_OBJECT_MESSAGE);
    }
}

