/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import nxm.sys.intr.HelpSwap;
import nxm.sys.libg.MJBrowser;
import org.apache.lucene.document.Document;

public class MJHelp
extends JPanel {
    private static final String ENTER_SEARCH_MSG = "Enter your search";
    private HelpSwap.Searcher searcher;
    private DefaultListModel<Document> resultsModel = new DefaultListModel();
    private DocViewerIF viewer;
    private boolean showPathInResults = false;
    private static boolean debug = false;
    private int maxResults = 100;
    private Cursor waitCursor;
    protected JButton executeQuery;
    protected JPopupMenu popupMenu;
    protected JTextField queryInput;
    private JRadioButtonMenuItem radioMaxResults100;
    private JRadioButtonMenuItem radioMaxResults500;
    private JRadioButtonMenuItem radioMaxResultsUnlimited;
    protected JList<Document> results;
    protected JTextField statusLabel;

    public MJHelp() throws HeadlessException {
        this.initComponents();
        this.waitCursor = Cursor.getPredefinedCursor(3);
        this.requestFocusForSearch();
    }

    private DefaultListModel<Document> getResultsModel() {
        return this.resultsModel;
    }

    public void setIndexPath(String indexDir) {
        String emsg = null;
        try {
            this.searcher = new HelpSwap.Searcher(indexDir);
            this.showMessage(ENTER_SEARCH_MSG);
        }
        catch (IOException e) {
            emsg = "Could not initialize help for index path=" + indexDir + " " + e;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            emsg = "Could not initialize help! See console for stack trace.";
        }
        if (emsg != null) {
            this.showMessage(emsg);
        }
    }

    public boolean requestFocusForSearch() {
        return this.queryInput.requestFocusInWindow();
    }

    public DocViewerIF getViewer() {
        return this.viewer;
    }

    public void setViewer(DocViewerIF viewer) {
        this.viewer = viewer;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    protected Integer setMaxResults(String maxResultsStr) {
        Integer max = null;
        try {
            max = Integer.valueOf(maxResultsStr);
            this.setMaxResults(max);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return max;
    }

    private void showMessage(String msg) {
        this.showMessage(msg, msg);
    }

    private void showMessage(String msg, String tipMsg) {
        if (this.statusLabel != null) {
            this.statusLabel.setText(msg);
            this.statusLabel.moveCaretPosition(0);
            if (tipMsg != null) {
                this.statusLabel.setToolTipText(tipMsg);
            }
        }
    }

    private static void debug(String msg) {
        if (debug) {
            System.out.println(msg);
        }
    }

    private static void warn(String msg, Throwable t) {
        System.out.println("WARN: " + msg);
        if (debug && t != null) {
            t.printStackTrace(System.out);
        }
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.radioMaxResults100 = new JRadioButtonMenuItem();
        this.radioMaxResults500 = new JRadioButtonMenuItem();
        this.radioMaxResultsUnlimited = new JRadioButtonMenuItem();
        ButtonGroup maxResultsButtonGroup = new ButtonGroup();
        this.statusLabel = new JTextField();
        this.queryInput = new JTextField();
        this.executeQuery = new JButton();
        JScrollPane resultScrollPane = new JScrollPane();
        this.results = new JList();
        FormListener formListener = new FormListener();
        this.popupMenu.setToolTipText("Search Options");
        maxResultsButtonGroup.add(this.radioMaxResults100);
        this.radioMaxResults100.setMnemonic('1');
        this.radioMaxResults100.setSelected(true);
        this.radioMaxResults100.setText("100 Max Results");
        this.radioMaxResults100.setToolTipText("Set Max Search Results to 100");
        this.radioMaxResults100.setActionCommand("100");
        this.radioMaxResults100.addActionListener(formListener);
        this.popupMenu.add(this.radioMaxResults100);
        maxResultsButtonGroup.add(this.radioMaxResults500);
        this.radioMaxResults500.setMnemonic('5');
        this.radioMaxResults500.setText("500 Max Results");
        this.radioMaxResults500.setToolTipText("Set Max Search Results to 500");
        this.radioMaxResults500.setActionCommand("500");
        this.radioMaxResults500.addActionListener(formListener);
        this.popupMenu.add(this.radioMaxResults500);
        maxResultsButtonGroup.add(this.radioMaxResultsUnlimited);
        this.radioMaxResultsUnlimited.setMnemonic('u');
        this.radioMaxResultsUnlimited.setText("Unlimited Max Results");
        this.radioMaxResultsUnlimited.setToolTipText("Set max search results to be unlimited");
        this.radioMaxResultsUnlimited.setActionCommand("-1");
        this.radioMaxResultsUnlimited.addActionListener(formListener);
        this.popupMenu.add(this.radioMaxResultsUnlimited);
        this.popupMenu.getAccessibleContext().setAccessibleName("Search Options");
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setComponentPopupMenu(this.popupMenu);
        this.statusLabel.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.statusLabel.setEditable(false);
        this.statusLabel.setFont(new Font("Dialog", 0, 11));
        this.statusLabel.setText("status label");
        this.statusLabel.setToolTipText("status/informational messages");
        this.statusLabel.setAlignmentX(1.0f);
        this.statusLabel.setBorder(null);
        this.statusLabel.setDragEnabled(true);
        this.statusLabel.setInheritsPopupMenu(true);
        this.statusLabel.setOpaque(false);
        this.statusLabel.setRequestFocusEnabled(false);
        this.queryInput.setToolTipText("Enter your search here. Boolean operators (AND, OR, +, -, NOT), groupings using parentheses, and wildcards (*, ?) can be used.");
        this.queryInput.setDragEnabled(true);
        this.queryInput.setFocusCycleRoot(true);
        this.queryInput.setInheritsPopupMenu(true);
        this.queryInput.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent evt) {
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                MJHelp.this.performSearch(MJHelp.this.queryInput.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                MJHelp.this.performSearch(MJHelp.this.queryInput.getText());
            }
        });
        this.queryInput.addActionListener(formListener);
        this.executeQuery.setFont(new Font("Dialog", 1, 10));
        this.executeQuery.setText("search");
        this.executeQuery.setToolTipText("");
        this.executeQuery.setMargin(new Insets(2, 5, 2, 5));
        this.executeQuery.addActionListener(formListener);
        resultScrollPane.setInheritsPopupMenu(true);
        this.results.setModel(this.getResultsModel());
        this.results.setSelectionMode(0);
        this.results.setCellRenderer(new ResultsRenderer());
        this.results.setInheritsPopupMenu(true);
        this.results.addMouseListener(formListener);
        this.results.addKeyListener(formListener);
        resultScrollPane.setViewportView(this.results);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusLabel, GroupLayout.Alignment.TRAILING, -1, 266, Short.MAX_VALUE).addComponent(resultScrollPane, -1, 266, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.queryInput, -1, 203, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.executeQuery))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.statusLabel, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.executeQuery, 0, 0, Short.MAX_VALUE).addComponent(this.queryInput, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(resultScrollPane, -1, 344, Short.MAX_VALUE).addContainerGap()));
    }

    private void executeQueryActionPerformed(ActionEvent evt) {
        this.performSearch(this.queryInput.getText());
    }

    private void queryInputActionPerformed(ActionEvent evt) {
        this.performSearch(this.queryInput.getText());
    }

    private void setMaxResultsActionPerformed(ActionEvent evt) {
        this.setMaxResults(evt.getActionCommand());
    }

    private void resultsKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.showResultHit();
        }
    }

    private void resultsMouseClicked(MouseEvent evt) {
        this.showResultHit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSearch(String queryString) {
        if (this.searcher == null) {
            return;
        }
        this.resultsModel.clear();
        queryString = queryString.trim();
        if (queryString.length() == 0) {
            this.showMessage(ENTER_SEARCH_MSG);
            return;
        }
        if (queryString.endsWith("AND") || queryString.endsWith("OR") || queryString.endsWith("+") || queryString.endsWith("NOT") || queryString.endsWith("&&") || queryString.endsWith("^") || queryString.endsWith("||") || queryString.endsWith("(") || queryString.endsWith("-")) {
            this.showMessage("Waiting for additional search terms...");
            return;
        }
        Cursor prevCursor = null;
        Cursor prevInputCursor = null;
        try {
            String statusMessage;
            prevCursor = this.getCursor();
            prevInputCursor = this.queryInput.getCursor();
            this.setCursor(this.waitCursor);
            this.queryInput.setCursor(this.waitCursor);
            this.showMessage("Searching for " + queryString + " ...");
            List<Document> hits = this.searcher.query(queryString, this.maxResults + 1);
            int len = hits.size();
            if (len == 0 || len == 1) {
                statusMessage = len + " result found for: " + queryString;
            } else if (len <= this.maxResults || this.maxResults < 0) {
                statusMessage = len + " results found for: " + queryString;
            } else {
                len = this.maxResults;
                statusMessage = len + "+ results found for: " + queryString;
            }
            this.showMessage(statusMessage);
            for (int ii = 0; ii < len; ++ii) {
                this.resultsModel.addElement(hits.get(ii));
            }
        }
        catch (Exception e) {
            int endIndex;
            String message = "Invalid search string";
            String emsg = e.getMessage();
            int index = emsg.indexOf("column");
            if (index != -1 && (endIndex = emsg.indexOf(46, index)) != -1) {
                message = message + " at column " + emsg.substring(index + 7, endIndex);
            }
            message = message + " - " + emsg;
            this.showMessage(message);
            if (this.statusLabel != null) {
                this.statusLabel.setToolTipText(message);
            }
            MJHelp.warn("Help - caught exception. " + message, e);
        }
        catch (Throwable t) {
            String emsg = "Reload this page/GUI OR restart browser to recover from: " + t.getMessage();
            this.showMessage(emsg);
            if (this.statusLabel != null) {
                this.statusLabel.setToolTipText(emsg);
            }
            MJHelp.warn("Help ERROR: " + emsg, t);
        }
        finally {
            if (prevCursor != null) {
                this.setCursor(prevCursor);
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
            if (prevInputCursor != null) {
                this.queryInput.setCursor(prevInputCursor);
            }
        }
    }

    private void showResultHit() {
        block4: {
            int i = this.results.getSelectedIndex();
            String path = "";
            try {
                Document doc = this.resultsModel.get(i);
                if (doc != null) {
                    path = doc.get("path");
                    this.viewer.showDocument(new File(path).toURI().toURL());
                }
            }
            catch (MalformedURLException e) {
                this.showMessage("URL not found: " + path + " - " + e);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (!debug) break block4;
                MJHelp.warn("showResultHit Exception: " + e, e);
            }
        }
    }

    public static void runAsApplication(final String title, final String indexPath, final int width, final int height, final Integer defaultCloseOperation) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame(title);
                if (defaultCloseOperation != null) {
                    frame.setDefaultCloseOperation(defaultCloseOperation);
                }
                final MJHelp help = new MJHelp();
                help.setIndexPath(indexPath);
                help.setViewer(new DocViewerIF(){

                    @Override
                    public boolean showDocument(URL url) {
                        String urlStr = url.toString();
                        help.showMessage(urlStr, "Open this URL: " + urlStr);
                        MJBrowser.browse(url);
                        return true;
                    }
                });
                frame.getContentPane().add(help);
                frame.pack();
                frame.setSize(width, height);
                frame.setVisible(true);
            }
        });
    }

    public static void main(String[] args) {
        String indexPath = args[0];
        MJHelp.runAsApplication("NeXtMidas Help", indexPath, 300, 400, 3);
    }

    private class ResultsRenderer
    extends DefaultListCellRenderer {
        private ResultsRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list3, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent(list3, value, index, isSelected, cellHasFocus);
            int hitNumber = index + 1;
            if (value instanceof Document) {
                Document doc = (Document)value;
                String score = doc.get("score");
                String doctitle = doc.get("title");
                String path = doc.get("path");
                if (doctitle == null || doctitle.equals("")) {
                    File file = new File(path);
                    doctitle = file.getName();
                } else if (MJHelp.this.showPathInResults && path != null) {
                    doctitle = doctitle + " - " + path;
                }
                JLabel label = (JLabel)comp;
                label.setText(hitNumber + ". " + doctitle);
                label.setToolTipText(hitNumber + ". " + path + " (" + score + ")");
            }
            return comp;
        }
    }

    private class FormListener
    implements ActionListener,
    KeyListener,
    MouseListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == MJHelp.this.queryInput) {
                MJHelp.this.queryInputActionPerformed(evt);
            } else if (evt.getSource() == MJHelp.this.executeQuery) {
                MJHelp.this.executeQueryActionPerformed(evt);
            } else if (evt.getSource() == MJHelp.this.radioMaxResults100) {
                MJHelp.this.setMaxResultsActionPerformed(evt);
            } else if (evt.getSource() == MJHelp.this.radioMaxResults500) {
                MJHelp.this.setMaxResultsActionPerformed(evt);
            } else if (evt.getSource() == MJHelp.this.radioMaxResultsUnlimited) {
                MJHelp.this.setMaxResultsActionPerformed(evt);
            }
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (evt.getSource() == MJHelp.this.results) {
                MJHelp.this.resultsKeyPressed(evt);
            }
        }

        @Override
        public void keyReleased(KeyEvent evt) {
        }

        @Override
        public void keyTyped(KeyEvent evt) {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getSource() == MJHelp.this.results) {
                MJHelp.this.resultsMouseClicked(evt);
            }
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
        }
    }

    public static interface DocViewerIF {
        public boolean showDocument(URL var1);
    }
}

