/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RescaleOp;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MidasColor;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Util;

public class MColor
implements MidasColor {
    int ncolor = 0;
    Color tcolor;
    Color[] tcolors;
    public static String mapLegendList = "CoastLine,Political,InterPol,River,Rail,Road";

    public MColor() {
    }

    public MColor(String name, Color color) {
        this.ncolor = 0;
        this.tcolor = color;
    }

    public MColor(String name, Color[] colors) {
        this.ncolor = colors.length;
        this.tcolors = colors;
    }

    public static Color getColor(int r, int g, int b) {
        return MidasColor.getColor(r, g, b);
    }

    public static Color getColor(Object obj, int alpha) {
        Color color = MColor.getColor(obj);
        if (color != null && color.getAlpha() != alpha) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
        }
        return color;
    }

    public static Color getColor(Object obj) {
        return MidasColor.getColor(obj);
    }

    private static Color getColorFromJavaString(String str) {
        if (str.indexOf("r=") < 0 || str.indexOf("g=") < 0 || str.indexOf("b=") < 0) {
            return null;
        }
        int red = MColor.getIntfromColorString('r', str);
        int green = MColor.getIntfromColorString('g', str);
        int blue = MColor.getIntfromColorString('b', str);
        if (str.indexOf("a=") >= 0) {
            int alpha = MColor.getIntfromColorString('a', str);
            return new Color(red, green, blue, alpha);
        }
        return new Color(red, green, blue);
    }

    private static int getIntfromColorString(char color, String str) {
        String tmp = str;
        int startIndex = tmp.indexOf(color + "=");
        String colorString = tmp.substring(startIndex);
        int endIndex = colorString.indexOf(",") < 0 ? colorString.indexOf("]") : colorString.indexOf(",");
        int colorInt = Integer.parseInt(colorString.substring(2, endIndex));
        return colorInt;
    }

    public static Color getColorByIndex(int index) {
        return MidasColor.getColorByIndex(index);
    }

    public static Color[] getColorMap(String colormapType, int numColors, int alpha) {
        Color[] colormap = MColor.getColorMap(colormapType, numColors);
        int len = colormap.length;
        for (int i = 0; i < len; ++i) {
            Color color;
            colormap[i] = color = MColor.getColor((Object)colormap[i], alpha);
        }
        return colormap;
    }

    public static Color[] getColorMap(String s, int ncolors) {
        int type;
        if (s.indexOf(44) < 0 && (type = Parser.find("GrayScale,Ramp,XRamp,Wheel,Terrain,Multi,T5Layer,MapLine,Grid,Spectrum,XDatalist", s, 0)) > 0) {
            return MColor.getColorMap(type, ncolors);
        }
        if (s.charAt(0) == '\"' || s.charAt(0) == '(') {
            s = s.substring(1, s.length() - 1);
        }
        Parser p = new Parser(s, true);
        if (ncolors < 0) {
            ncolors = p.elements();
        }
        Color[] colors = MColor.getColorMap(-1, ncolors);
        for (int i = 1; i <= ncolors; ++i) {
            String cs = p.get(i);
            colors[i] = cs.length() > 0 ? MColor.getColor(cs) : Color.black;
        }
        return colors;
    }

    public static Color[] getColorMap(int type, int ncolors) {
        Color[] colors;
        switch (type) {
            case 1: {
                if (ncolors < 0) {
                    ncolors = 32;
                }
                colors = new Color[ncolors + 1];
                MColor.interpColors(colors, CM_GRAY);
                break;
            }
            case 2: {
                if (ncolors < 0) {
                    ncolors = 32;
                }
                colors = new Color[ncolors + 1];
                MColor.interpColors(colors, CM_RAMP);
                break;
            }
            case 3: {
                if (ncolors < 0) {
                    ncolors = 32;
                }
                colors = new Color[ncolors + 1];
                MColor.interpColors(colors, CM_XRAMP);
                break;
            }
            case 4: {
                if (ncolors < 0) {
                    ncolors = 32;
                }
                colors = new Color[ncolors + 1];
                MColor.interpColors(colors, CM_WHEEL);
                break;
            }
            case 5: {
                if (ncolors < 0) {
                    ncolors = 32;
                }
                colors = new Color[ncolors + 1];
                MColor.interpColors(colors, CM_TERRAIN);
                break;
            }
            case 6: {
                if (ncolors < 0) {
                    ncolors = 32;
                }
                colors = new Color[ncolors + 1];
                MColor.interpColors(colors, CM_MULTI);
                break;
            }
            case 10: {
                if (ncolors < 0) {
                    ncolors = 32;
                }
                colors = new Color[ncolors + 1];
                MColor.interpColors(colors, CM_SPECTRUM);
                break;
            }
            case 11: {
                if (ncolors < 0) {
                    ncolors = 16;
                }
                colors = new Color[ncolors + 1];
                MColor.interpColors(colors, CM_SPECTRUM);
                break;
            }
            case 7: {
                if (ncolors < 5) {
                    ncolors = 5;
                }
                colors = new Color[ncolors + 1];
                colors[1] = T5_COLOR1_CEP;
                colors[2] = T5_COLOR2_HORIZON;
                colors[3] = T5_COLOR3_TDOA;
                colors[4] = T5_COLOR4_FDOA;
                colors[5] = T5_COLOR5_TRACE5000;
                break;
            }
            case 8: {
                if (ncolors < 8) {
                    ncolors = 8;
                }
                colors = new Color[ncolors + 1];
                colors[1] = MColor.getColor(30, 40, 55);
                colors[2] = MColor.getColor(45, 45, 45);
                colors[3] = MColor.getColor(20, 30, 30);
                colors[4] = MColor.getColor(0, 20, 50);
                colors[5] = MColor.getColor(25, 15, 15);
                colors[6] = MColor.getColor(40, 40, 0);
                colors[7] = colors[2];
                colors[8] = colors[3];
                break;
            }
            case 9: {
                if (ncolors < 2) {
                    ncolors = 2;
                }
                colors = new Color[ncolors + 1];
                colors[1] = MColor.getColor(60, 60, 60);
                colors[2] = MColor.getColor(25, 25, 25);
                break;
            }
            default: {
                if (ncolors < 0) {
                    ncolors = 1;
                }
                colors = new Color[ncolors + 1];
            }
        }
        colors[0] = Color.black;
        return colors;
    }

    public static Table getMapColorTable() {
        Color[] colors = MColor.getColorMap(8, -1);
        Table ct = new Table();
        Parser p = new Parser(mapLegendList);
        for (int i = 1; i <= p.elements(); ++i) {
            String name = p.get(i).toUpperCase();
            ct.put(name, (Object)MColor.toString(colors[i]));
        }
        return ct;
    }

    public static Color[] getColorMap(Table ctab) {
        Table.Iterator ti = ctab.iterator();
        Color[] colors = new Color[ti.size + 1];
        colors[0] = Color.black;
        for (int i = 0; i < ti.size; ++i) {
            colors[i + 1] = MColor.getColor(ti.values[i].toString());
        }
        return colors;
    }

    public static Color[] reverseColorMap(Color[] cmap) {
        return Util.reverseArray(cmap, 1);
    }

    public static Color[] invertColorsMap(Color[] cmap) {
        return MColor.invertColors(cmap, 1);
    }

    public static Color[] invertColors(Color[] colors, int startIndex) {
        if (colors == null) {
            return null;
        }
        int len = colors.length;
        for (int ii = startIndex; ii < len; ++ii) {
            colors[ii] = MColor.invert(colors[ii]);
        }
        return colors;
    }

    public static Color invert(Color inColor) {
        return MidasColor.invert(inColor);
    }

    public static void interpColors(Color[] colors, byte[] table) {
        int ncolors = colors.length - 1;
        for (int i = 1; i <= ncolors; ++i) {
            int j;
            float p = ncolors == 1 ? 0.0f : 100.0f * (float)(i - 1) / (float)(ncolors - 1);
            for (j = 4; j < table.length && table[j] < (int)p; j += 4) {
            }
            float pp = (p - (float)table[j - 4]) / (float)(table[j] - table[j - 4]);
            pp = Math.max(0.0f, Math.min(1.0f, pp));
            float pq = 1.0f - pp;
            float r = Math.min(1.0f, (pp * (float)table[j + 1] + pq * (float)table[j + 1 - 4]) / 100.0f);
            float g = Math.min(1.0f, (pp * (float)table[j + 2] + pq * (float)table[j + 2 - 4]) / 100.0f);
            float b = Math.min(1.0f, (pp * (float)table[j + 3] + pq * (float)table[j + 3 - 4]) / 100.0f);
            colors[i] = new Color(r, g, b);
        }
    }

    public static ColorModel getColorModel(Color[] colors) {
        int size = colors.length;
        int bits = 8;
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        byte[] a = new byte[size];
        for (int i = 0; i < size; ++i) {
            r[i] = (byte)colors[i].getRed();
            g[i] = (byte)colors[i].getGreen();
            b[i] = (byte)colors[i].getBlue();
            a[i] = (byte)colors[i].getAlpha();
        }
        IndexColorModel cm = new IndexColorModel(bits, size, r, g, b, a);
        return cm;
    }

    public static Color getColorMix(Color c0, Color c1, double mix) {
        return MidasColor.getColorMix(c0, c1, mix);
    }

    public static String toString(Color color) {
        if (color == null) {
            return "null";
        }
        String str = MidasColor.NamedColors.getColorName(color);
        if (str == null) {
            int rgb = color.getRGB();
            String hex = Integer.toHexString(rgb);
            hex = StringUtil.padLeft(hex, 8, '0');
            if ((rgb & 0xFF000000) == -16777216) {
                hex = hex.substring(2);
            }
            str = "#" + hex;
        }
        return str;
    }

    public static String toString(Color[] colors) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < colors.length; ++i) {
            if (i != 0) {
                str.append(',');
            }
            str.append(MColor.toString(colors[i]));
        }
        return str.toString();
    }

    public static BufferedImage adjustImage(BufferedImage img, int xMin, int yMin, int xMax, int yMax, int contrast, int brightness, int alpha, boolean greyscale) {
        if (contrast == 50 && brightness == 50 && alpha == -1 && !greyscale) {
            return img;
        }
        int height = yMax - yMin;
        int width = xMax - xMin;
        BufferedImage out = new BufferedImage(width, height, 2);
        int[] buf = img.getRGB(xMin, yMin, width, height, new int[width * height], 0, width);
        float cnt = (float)contrast / 50.0f;
        float brt = (float)brightness / 50.0f;
        int alp = alpha == -1 ? -1 : Math.min(255, Math.max(0, alpha));
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = MColor.adjustColor0(buf[i], cnt, brt, alp, greyscale);
        }
        out.setRGB(xMin, yMin, width, height, buf, 0, width);
        return out;
    }

    static BufferedImage adjustImageFast(BufferedImage img, int xMin, int yMin, int xMax, int yMax, int contrast, int brightness, int alpha, boolean greyscale) {
        boolean alphaUpdate;
        boolean contrastUpdate = contrast != 50;
        boolean brightnessUpdate = brightness != 50;
        boolean bl = alphaUpdate = alpha != -1;
        if (!(contrastUpdate || brightnessUpdate || alphaUpdate || greyscale)) {
            return img;
        }
        int height = yMax - yMin;
        int width = xMax - xMin;
        BufferedImage out = null;
        float brt = (float)brightness / 50.0f;
        if (Shell.getJavaMajorVersion() >= 9 && brightnessUpdate && !contrastUpdate && !alphaUpdate && !greyscale) {
            RescaleOp op = new RescaleOp(brt, 0.0f, null);
            out = op.filter(img, null);
        } else {
            out = new BufferedImage(width, height, 2);
            int[] buf = img.getRGB(xMin, yMin, width, height, new int[width * height], 0, width);
            float cnt = (float)contrast / 50.0f;
            int alp = alpha == -1 ? -1 : Math.min(255, Math.max(0, alpha));
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = MColor.adjustColor0(buf[i], cnt, brt, alp, greyscale);
            }
            out.setRGB(xMin, yMin, width, height, buf, 0, width);
        }
        return out;
    }

    public static int adjustColor(int rgb, int contrast, int brightness, int alpha, boolean greyscale) {
        int alp;
        float cnt = (float)contrast / 50.0f;
        float brt = (float)brightness / 50.0f;
        int n = alp = alpha == -1 ? -1 : Math.min(255, Math.max(0, alpha));
        if (contrast == 50 && brightness == 50 && alpha == -1 && !greyscale) {
            return rgb;
        }
        return MColor.adjustColor0(rgb, cnt, brt, alp, greyscale);
    }

    private static int adjustColor0(int rgb, float cnt, float brt, int alp, boolean greyscale) {
        int rr;
        int gg;
        int bb;
        int aa;
        int alpha = rgb >> 24 & 0xFF;
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb >> 0 & 0xFF;
        int n = aa = alp != -1 ? alp : alpha;
        if (greyscale) {
            int grey = (red + green + blue) / 3;
            int gs = (int)(((float)grey * brt - 128.0f) * cnt + 128.0f);
            gg = bb = Math.min(255, Math.max(0, gs));
            rr = bb;
        } else {
            int r = (int)(((float)red * brt - 128.0f) * cnt + 128.0f);
            int g = (int)(((float)green * brt - 128.0f) * cnt + 128.0f);
            int b = (int)(((float)blue * brt - 128.0f) * cnt + 128.0f);
            rr = Math.min(255, Math.max(0, r));
            gg = Math.min(255, Math.max(0, g));
            bb = Math.min(255, Math.max(0, b));
        }
        return aa << 24 | rr << 16 | gg << 8 | bb << 0;
    }

    public static void applyAlpha(int[] rgbBuf, int alpha) {
        if (rgbBuf == null || rgbBuf.length == 0) {
            return;
        }
        int a = (alpha & 0xFF) << 24;
        int len = rgbBuf.length;
        for (int i = 0; i < len; ++i) {
            rgbBuf[i] = a | rgbBuf[i] & 0xFFFFFF;
        }
    }

    protected static int pct2alpha(int percent) {
        float pct = (float)percent / 100.0f;
        int alpha = (int)(255.0f * pct);
        alpha = Math.min(alpha, 255);
        alpha = Math.max(alpha, 0);
        return alpha;
    }

    protected static int alpha2pct(int alpha) {
        int pct = (int)((double)alpha / 2.55);
        pct = Math.min(pct, 100);
        pct = Math.max(pct, 0);
        return pct;
    }

    public static Color blend(Color color1, Color color2, double ratio) {
        return MidasColor.blend(color1, color2, ratio);
    }

    public static double colorDifference(Color color1, Color color2) {
        return MidasColor.colorDifference(color1, color2);
    }

    public static Color blend(Color color1, Color color2) {
        return MidasColor.blend(color1, color2, 0.5);
    }

    public static BufferedImage colorImage(BufferedImage img, Color color, float ratio) {
        if (color != null && img != null) {
            int h = img.getHeight();
            int w = img.getWidth();
            int[] rgb = new int[h * w];
            img.getRGB(0, 0, w, h, rgb, 0, w);
            for (int xx = 0; xx < rgb.length; ++xx) {
                rgb[xx] = MColor.blend(new Color(rgb[xx], true), color, ratio).getRGB();
            }
            img.setRGB(0, 0, w, h, rgb, 0, w);
        }
        return img;
    }

    @InternalUseOnly
    public static Color getSpecialXMidasColor(int colNum) {
        return MidasColor.getSpecialXMidasColor(colNum);
    }

    public static int BGRtoRGB(int bgr) {
        return MColor.RGBtoBGR(bgr);
    }

    public static Color BGRtoRGB(Color bgrColor) {
        return MColor.RGBtoBGR(bgrColor);
    }

    public static int RGBtoBGR(int rgbColor) {
        int aa = rgbColor >> 24 & 0xFF;
        int bb = rgbColor >> 16 & 0xFF;
        int gg = rgbColor >> 8 & 0xFF;
        int rr = rgbColor >> 0 & 0xFF;
        return aa << 24 | rr << 16 | gg << 8 | bb << 0;
    }

    public static Color RGBtoBGR(Color rgbColor) {
        int bgr = rgbColor.getRGB();
        int argb = MColor.RGBtoBGR(bgr);
        boolean hasAlpha = (bgr & 0xFF000000) != 0;
        return new Color(argb, hasAlpha);
    }

    @Deprecated
    public static Color getLegacyColor(String s) {
        return MidasColor.getLegacyColor(s);
    }
}

