/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import nxm.sys.inc.Keyable;
import nxm.sys.lib.Convert;

public class MBox
implements Keyable {
    private static final String[] keys = new String[]{"X", "Y", "W", "H"};
    public int x;
    public int y;
    public int w;
    public int h;

    public MBox() {
        this(0, 0, 100, 100);
    }

    public MBox(int x, int y, int w, int h) {
        this.setBounds(x, y, w, h);
    }

    public MBox(Rectangle rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public MBox(MBox pos) {
        this(pos.x, pos.y, pos.w, pos.h);
    }

    public void setBounds(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public void setBounds(MBox pos) {
        this.setBounds(pos.x, pos.y, pos.w, pos.h);
    }

    public void setBounds(Rectangle rect) {
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public void setSize(int w, int h) {
        this.w = w;
        this.h = h;
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public void reform() {
        if (this.w < 0) {
            this.w = -this.w;
            this.x -= this.w;
        }
        if (this.h < 0) {
            this.h = -this.h;
            this.y -= this.h;
        }
    }

    public boolean within(int px, int py) {
        return px >= this.x && px <= this.x + this.w && py >= this.y && py <= this.y + this.h;
    }

    public void translate(int px, int py) {
        this.x += px;
        this.y += py;
    }

    public Rectangle toRectangle() {
        return new Rectangle(this.x, this.y, this.w, this.h);
    }

    public boolean equals(Rectangle r) {
        return r != null && r.width == this.w && r.height == this.h && r.x == this.x && r.y == this.y;
    }

    public String toString() {
        return "Box(" + this.x + "," + this.y + "," + this.w + "," + this.h + ")";
    }

    @Override
    public String[] getKeys() {
        return keys;
    }

    @Override
    public Object setKey(String key, Object value) {
        if (key.equals("X")) {
            this.x = Convert.o2l(value);
        } else if (key.equals("Y")) {
            this.y = Convert.o2l(value);
        } else if (key.equals("W")) {
            this.w = Convert.o2l(value);
        } else if (key.equals("H")) {
            this.h = Convert.o2l(value);
        } else {
            return null;
        }
        return value;
    }

    @Override
    public Object getKey(String key) {
        if (key.equals("X")) {
            return Convert.l2o(this.x);
        }
        if (key.equals("Y")) {
            return Convert.l2o(this.y);
        }
        if (key.equals("W")) {
            return Convert.l2o(this.w);
        }
        if (key.equals("H")) {
            return Convert.l2o(this.h);
        }
        return null;
    }
}

