/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import nxm.sys.inc.Drawable;
import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Message;
import nxm.sys.lib.Parser;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Time;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GPrompt;
import nxm.sys.libg.GQuery;
import nxm.sys.libg.GValue;
import nxm.sys.libg.Layer;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MPlot;
import nxm.sys.libg.Symbol;

public class Line
implements MessageHandler {
    public static final String fontStyleList = "Bold,Italic";
    public static final String typeList = "Solid,Point,Dot,Fill,Bar,Symbol";
    public static final int SOLID = 1;
    public static final int POINT = 2;
    public static final int DOT = 4;
    public static final int FILL = 8;
    public static final int BAR = 16;
    public static final int SYMBOL = 32;
    private static final BasicStroke DEF_STROKE = new BasicStroke(1.0f, 1, 1, 1.0f, null, 0.0f);
    private static final Font DEF_FONT = new Font("Monospaced", 0, 12);
    private MPlot MP = null;
    private int thickness = 1;
    private Font font = DEF_FONT;
    private int type = 1;
    private int radius = 2;
    private Color color = MColor.DEFAULT_COLOR;
    private Symbol symbol = null;
    private int symbolSize = 6;
    private boolean symbolFill = false;
    private float symbolHeading = 0.0f;
    private Color fillColor = null;
    private BasicStroke stroke = DEF_STROKE;
    private Drawable parent = null;
    private boolean needRefresh = false;

    public Line() {
        this(null, null);
    }

    public Line(Layer layer) {
        this(layer.MP, layer);
    }

    public Line(Drawable parent) {
        this(null, parent);
    }

    private Line(MPlot mp, Drawable parent) {
        this.MP = mp;
        this.parent = parent;
    }

    private Line(Line line) {
        this.MP = line.MP;
        this.thickness = line.thickness;
        this.font = line.font;
        this.stroke = line.stroke;
        this.parent = line.parent;
        this.type = line.type;
        this.radius = line.radius;
        this.color = line.color;
        this.symbol = line.symbol;
        this.symbolSize = line.symbolSize;
        this.symbolFill = line.symbolFill;
        this.symbolHeading = line.symbolHeading;
        this.fillColor = line.fillColor;
        this.needRefresh = line.needRefresh;
    }

    public Line copy() {
        return new Line(this);
    }

    public boolean getNeedRefresh() {
        return this.needRefresh;
    }

    public void clearNeedRefresh() {
        this.needRefresh = false;
    }

    public void refresh() {
        this.needRefresh = true;
    }

    public void configure() {
        new GMenu(this.MP, "Line.cfg", "Solid,Point,Dot,Fill,Bar,Symbol,Thickness>,Radius>,SymbolMenu>,SymbolName>,SymbolSize>,SymbolAngle>,Color>,FillColor>,SymbolFill>,FontSize>,FontStyle>,Query", this.type, 1024, this);
    }

    @Override
    public int processMessage(Message msg) {
        if (msg.name.equals("LINE.CFG")) {
            int symbolAngle;
            String symbolName = this.symbol != null ? this.symbol.getName() : "NULL";
            int symbolSize = this.symbol != null ? this.symbol.getSize() : 16;
            int n = symbolAngle = this.symbol != null ? (int)Math.toDegrees(this.symbol.getAngle()) : 0;
            int symbolFill = this.symbol != null ? (this.symbol.isFilled() ? 1 : 2) : 0;
            int symbolIndex = Parser.find("Aero,Arrow,Circle,Cross,Diamond,Dot,Plus,Square,Star,Triangle,UTri,DTri,RTri,LTri,A,B,C,D,Ascii-XYZ,None", symbolName, 0);
            String colorName = MColor.toString(this.color);
            String fillColorName = MColor.toString(this.fillColor);
            String text = (String)msg.data;
            if (text.equals("COLOR>")) {
                new GPrompt(this.MP, "Color", colorName, 0, (MessageHandler)this);
            } else if (text.equals("FILLCOLOR>")) {
                new GPrompt(this.MP, "FillColor", fillColorName, 0, (MessageHandler)this);
            } else if (text.equals("THICKNESS>")) {
                new GValue((Object)this.MP, "Thickness", this.thickness, 0, 16, 1, 0, (MessageHandler)this);
            } else if (text.equals("RADIUS>")) {
                new GValue((Object)this.MP, "Radius", this.radius, 0, 16, 1, 0, (MessageHandler)this);
            } else if (text.equals("SYMBOLNAME>")) {
                new GPrompt(this.MP, "Symbol", symbolName, 0, (MessageHandler)this);
            } else if (text.equals("SYMBOLSIZE>")) {
                new GValue((Object)this.MP, "SymbolSize", symbolSize, 0, 48, 1, 0, (MessageHandler)this);
            } else if (text.equals("SYMBOLANGLE>")) {
                new GValue((Object)this.MP, "SymbolAngle", symbolAngle, 0, 360, 15, 0, (MessageHandler)this);
            } else if (text.equals("SYMBOLMENU>")) {
                new GMenu(this.MP, "Symbol", "Aero,Arrow,Circle,Cross,Diamond,Dot,Plus,Square,Star,Triangle,UTri,DTri,RTri,LTri,A,B,C,D,Ascii-XYZ,None", symbolIndex, 0, this);
            } else if (text.equals("SYMBOLFILL>")) {
                new GMenu(this.MP, "SymbolFill", "On,Off", symbolFill, 0, this);
            } else if (text.equals("FONTSIZE>")) {
                new GValue((Object)this.MP, "FontSize", this.getFontSize(), 8.0f, 48.0f, 1.0f, 0, (MessageHandler)this);
            } else if (text.equals("FONTSTYLE>")) {
                new GMenu(this.MP, "FontStyle", fontStyleList, this.getFontStyleInt(), 1024, this);
            } else if (text.equals("QUERY")) {
                new GQuery(this.parent, "Line on " + this.parent.getName(), this, 0, (MessageHandler)this);
            } else {
                this.setType(msg.info);
            }
        } else if (msg.name.equals("FONTSIZE")) {
            this.setFontSize(Convert.o2f(msg.data));
        } else if (msg.name.equals("FONTSTYLE")) {
            this.setFontStyle(Convert.o2s(msg.data));
        } else if (msg.name.equals("RADIUS")) {
            this.setRadius(Convert.o2l(msg.data));
        } else if (msg.name.equals("THICKNESS")) {
            this.setThickness(Convert.o2l(msg.data));
        } else if (msg.name.equals("SYMBOLSIZE")) {
            this.setSymbolSize(Convert.o2l(msg.data));
        } else if (msg.name.equals("SYMBOLANGLE")) {
            this.setSymbolAngleDeg(Convert.o2l(msg.data));
        } else if (msg.name.equals("SYMBOLFILL")) {
            this.setSymbolFill(((String)msg.data).equalsIgnoreCase("On"));
        } else if (msg.name.equals("SYMBOL")) {
            this.setSymbol((String)msg.data, false);
            if (this.symbol != null) {
                this.type |= 0x20;
            }
            this.pauseThenRefresh(0.125);
        } else if (msg.name.equals("COLOR")) {
            this.setColor((String)msg.data);
        } else if (msg.name.equals("FILLCOLOR")) {
            this.setFillColor(msg.data);
        } else {
            return -1;
        }
        return 0;
    }

    private void pauseThenRefresh(double pauseTime) {
        Time.sleep(pauseTime);
        this.refresh();
    }

    public int getThickness() {
        return Math.max(1, this.thickness);
    }

    public void setThickness(int value) {
        if ((value = Math.max(1, value)) == this.thickness) {
            return;
        }
        this.thickness = value;
        this.updateStroke();
        this.refresh();
    }

    public int getTypeInt() {
        return this.type;
    }

    public boolean isTypeSet(int flag) {
        return (this.type & flag) != 0;
    }

    public String getType() {
        return Parser.mask2s(typeList, this.getTypeInt());
    }

    public void setType(int value) {
        if (value == this.type) {
            return;
        }
        if (this.symbol == null && (value & 0x20) != 0) {
            this.symbol = new Symbol.Cross();
        }
        this.type = value;
        this.refresh();
    }

    public void setType(String value) {
        this.setType(Parser.mask(typeList, value, this.type));
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int value) {
        if ((value = Math.max(0, value)) == this.radius) {
            return;
        }
        this.radius = value;
        this.refresh();
    }

    public boolean isSymbolOn() {
        return (this.type & 0x20) != 0;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(Object val) {
        this.setSymbol(val, true);
    }

    public void setSymbol(Object val, boolean doRefresh) {
        Symbol sym = Symbol.getSymbol(val);
        if (sym == this.symbol) {
            return;
        }
        int size = this.getSymbolSize();
        boolean fill = this.getSymbolFill();
        float ang = this.getSymbolAngle();
        this.symbol = sym;
        this.setSymbolSize(size);
        this.setSymbolFill(fill);
        this.setSymbolAngle(ang);
        if (doRefresh) {
            this.refresh();
        }
    }

    public final void setSymbol(String value) {
        this.setSymbol(Symbol.get(value, 6), true);
    }

    public final void setSymbol(String value, boolean doRefresh) {
        this.setSymbol(Symbol.get(value, 6), doRefresh);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(String value) {
        this.setColor((Object)value);
    }

    public final void setColor(int index) {
        this.setColor(MColor.getColorByIndex(index));
    }

    public void setColor(Object value) {
        if (value instanceof String && value.toString().length() == 0) {
            return;
        }
        Color c = MColor.getColor(value);
        if (c.equals(this.color)) {
            return;
        }
        this.color = c;
        this.refresh();
    }

    public Color getFillColor() {
        return this.fillColor != null ? this.fillColor : this.color;
    }

    public void setFillColor(Object value) {
        if (StringUtil.isNullOrEmpty(value)) {
            if (this.fillColor == null) {
                return;
            }
            this.fillColor = null;
        } else {
            Color c = MColor.getColor(value);
            if (c.equals(this.fillColor)) {
                return;
            }
            this.fillColor = c;
        }
        this.refresh();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font value) {
        if (value == null) {
            value = DEF_FONT;
        }
        if (value == this.font) {
            return;
        }
        this.font = value;
        this.refresh();
    }

    public float getFontSize() {
        return this.getFont().getSize2D();
    }

    public void setFontSize(float size) {
        size = Math.max(1.0f, size);
        if (this.getFontSize() == size) {
            return;
        }
        this.setFont(this.getFont().deriveFont(size));
    }

    protected int getFontStyleInt() {
        return this.getFont().getStyle();
    }

    protected void setFontStyleInt(int style) {
        if (style == this.getFontStyleInt()) {
            return;
        }
        this.setFont(this.getFont().deriveFont(style));
    }

    public final String getFontStyle() {
        return Parser.mask2s(fontStyleList, this.getFontStyleInt());
    }

    public final void setFontStyle(String style) {
        int mask = this.getFontStyleInt();
        if (style != null) {
            mask = Parser.mask(fontStyleList, style, mask);
        }
        this.setFontStyleInt(mask);
    }

    public void setSymbolSize(int size) {
        if (this.getSymbolSize() == size) {
            return;
        }
        if (this.symbol != null) {
            this.symbol.setSize(size);
        }
        this.symbolSize = size;
        this.refresh();
    }

    public int getSymbolSize() {
        return this.symbol == null ? this.symbolSize : this.symbol.getSize();
    }

    public void setSymbolFill(boolean fill) {
        if (this.getSymbolFill() == fill) {
            return;
        }
        if (this.symbol != null) {
            this.symbol.setFilled(fill);
        }
        this.symbolFill = fill;
        this.refresh();
    }

    public boolean getSymbolFill() {
        return this.symbol == null ? this.symbolFill : this.symbol.isFilled();
    }

    public final void setSymbolAngleDeg(float deg) {
        this.setSymbolHeading(360.0f - deg);
    }

    public float getSymbolAngleDeg() {
        return 360.0f - this.getSymbolHeading();
    }

    public void setSymbolAngle(float radians) {
        this.setSymbolAngleDeg(radians * 57.29578f);
    }

    public float getSymbolAngle() {
        return this.getSymbolAngleDeg() * ((float)Math.PI / 180);
    }

    public final void setSymbolHeading(float deg) {
        if (deg >= 360.0f) {
            deg %= 360.0f;
        }
        if (deg < 0.0f) {
            deg = 360.0f - -deg % 360.0f;
        }
        if (this.getSymbolHeading() == deg) {
            return;
        }
        if (this.symbol != null) {
            this.symbol.setHeading(deg);
        }
        this.symbolHeading = deg;
        this.refresh();
    }

    public final float getSymbolHeading() {
        return this.symbol == null ? this.symbolHeading : this.symbol.getHeading();
    }

    public void setPlot(MPlot plot2) {
        this.MP = plot2;
    }

    public MPlot getPlot() {
        return this.MP;
    }

    public void setParent(Drawable parent) {
        this.parent = parent;
    }

    public Drawable getParent() {
        return this.parent;
    }

    void updateGraphics(Graphics g) {
        g.setColor(this.color);
        g.setFont(this.font);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(this.stroke);
        }
    }

    private void updateStroke() {
        float width = this.getThickness();
        int cap = 1;
        int join = 1;
        float limit = 1.0f;
        float[] dash = null;
        float phase = 0.0f;
        this.stroke = new BasicStroke(width, cap, join, limit, dash, phase);
    }
}

