/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import nxm.sys.inc.ListFile;
import nxm.sys.inc.PlotFile;
import nxm.sys.lib.Args;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Table;
import nxm.sys.libg.Layer;
import nxm.sys.libg.Line;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MPoint;

public class LayerXY
extends Layer {
    public double[] dbuf;
    private int colorIndex;
    private int xOffset;
    private int yOffset;
    private int nOffset;
    private char xFormat;
    private char yFormat;
    private char nFormat;
    private String tag;
    private Color[] colors;
    private String[] names;
    private double xMin;
    private double yMin;
    private double xlMin;
    private double ylMin;
    private boolean xnotDouble = true;
    private boolean ynotDouble = true;
    private boolean haveNames = false;

    public LayerXY() {
        this.line.setColor(MColor.getColorByIndex(1));
        this.enable &= 0xFFFFFFFD;
        this.name = "XY";
    }

    public void setXRecName(String value) {
    }

    public void setX(String value) {
        this.setXRecName(value);
    }

    public void setYRecName(String value) {
    }

    public void setY(String value) {
        this.setYRecName(value);
    }

    @Override
    public boolean setFile(PlotFile pf, Table tab, Args MA) {
        this.setFile(pf);
        boolean returnStatus = false;
        int xferLength = (int)pf.getSize();
        if (pf instanceof DataFile) {
            DataFile hcb = (DataFile)pf;
            if (hcb.typeClass == 3) {
                String nRec;
                Object xRec = tab.getKey("X");
                Object yRec = tab.getKey("Y");
                String string = nRec = tab.containsKey("NAME") ? tab.getKey("NAME") : "";
                if (xRec != null && yRec != null) {
                    String xRecName = "" + xRec;
                    String yRecName = "" + yRec;
                    String nRecName = "" + nRec;
                    int xRecIndex = hcb.findRec(xRecName);
                    int yRecIndex = hcb.findRec(yRecName);
                    int nRecIndex = hcb.findRec(nRecName);
                    if (xRecIndex >= 0 && yRecIndex >= 0) {
                        this.setColumns(xRecIndex, yRecIndex, nRecIndex, hcb);
                        this.setXAxis(0.0, 1.0);
                        this.setYAxis(0.0, 1.0);
                        Data dat = hcb.getDataBuffer(xferLength);
                        this.setSize(dat.size);
                        this.names = new String[dat.size];
                        this.setData(dat);
                    } else {
                        this.warning("Unable to find X record '" + xRecName + "' and/or Y record '" + yRecName + "' in header");
                    }
                } else {
                    this.warning("Need an X=TAG and Y=TAG for XY plot");
                }
            } else {
                this.warning("LayerXY plot for type 3000 file only");
            }
        } else if (pf instanceof ListFile) {
            ListFile lf = (ListFile)((Object)pf);
            String xRecName = tab.getS("X", "X");
            String yRecName = tab.getS("Y", "Y");
            String nRecName = tab.getS("LABEL", "NAME");
            this.name = this.tag = pf.getTag();
            this.xOffset = 0;
            this.yOffset = 0;
            this.xFormat = (char)32;
            this.yFormat = (char)32;
            this.nOffset = 0;
            this.nFormat = (char)32;
            this.haveNames = false;
            for (int i = 0; i < lf.getRecordDefCount(); ++i) {
                Table recDef = lf.getRecordDef(i);
                String fmt = recDef.getS("FORMAT", "XA");
                if (xRecName.equals(recDef.getS("NAME"))) {
                    this.xFormat = fmt.charAt(1);
                    this.xOffset = recDef.getL("OFFSET", this.xOffset);
                }
                if (yRecName.equals(recDef.getS("NAME"))) {
                    this.yFormat = fmt.charAt(1);
                    this.yOffset = recDef.getL("OFFSET", this.yOffset);
                }
                if (nRecName.equals(recDef.getS("NAME"))) {
                    this.haveNames = true;
                    this.nFormat = fmt.charAt(1);
                    this.nOffset = recDef.getL("OFFSET", this.nOffset);
                }
                if (this.xFormat == ' ') {
                    this.xOffset += Data.getBPA(fmt);
                }
                if (this.yFormat == ' ') {
                    this.yOffset += Data.getBPA(fmt);
                }
                if (this.nFormat != ' ') continue;
                this.nOffset += Data.getBPA(fmt);
            }
            if (this.xFormat == ' ') {
                this.warning("LayerXY Can not find subrecord '" + xRecName + "' in " + this);
            }
            if (this.yFormat == ' ') {
                this.warning("LayerXY Can not find subrecord '" + yRecName + "' in " + this);
            }
            if (this.nFormat == ' ') {
                this.warning("LayerXY Can not find subrecord '" + nRecName + "' in " + this);
            }
            this.setXAxis(0.0, 1.0);
            this.setYAxis(0.0, 1.0);
            Data dat = pf.getDataBuffer(xferLength);
            this.setSize(dat.size);
            this.names = new String[dat.size];
            this.setData(dat);
        }
        return returnStatus;
    }

    @Override
    public void process() {
        this.ndata = 0;
        if (this.data != null) {
            this.ndata = this.data.size;
            this.dbuf = this.data2daXY(this.data, this.ndata, this.dbuf, this.MP.mode);
            if (this.haveNames) {
                this.data2names(this.data, this.ndata, this.dbuf, this.MP.mode);
            }
            this.setXAxis(this.xMin, 1.0);
            this.setYAxis(this.yMin, 1.0);
        }
    }

    private double[] data2daXY(Data data, int ndata, double[] dbuf, int mode) {
        int i;
        double[] dbuftemp = new double[ndata];
        double scale = LayerXY.setScale(data, mode);
        this.yMin = Double.MAX_VALUE;
        this.xMin = Double.MAX_VALUE;
        this.setxnotDouble(true);
        this.setynotDouble(true);
        if (dbuf == null || dbuf.length < ndata * 2) {
            dbuf = new double[ndata * 2];
        }
        if (this.xFormat == 'D') {
            for (i = 0; i < ndata; ++i) {
                dbuftemp[i] = data.unpackD(i * data.bpe + this.xOffset);
            }
            for (i = 0; i < ndata; ++i) {
                if (!(dbuftemp[i] < this.xMin)) continue;
                this.xMin = dbuftemp[i];
            }
            for (i = 0; i < ndata; ++i) {
                dbuf[i * 2] = dbuftemp[i];
            }
            this.setxnotDouble(false);
        }
        if (this.yFormat == 'D') {
            for (i = 0; i < ndata; ++i) {
                dbuftemp[i] = data.unpackD(i * data.bpe + this.yOffset);
            }
            for (i = 0; i < ndata; ++i) {
                if (!(dbuftemp[i] < this.yMin)) continue;
                this.yMin = dbuftemp[i];
            }
            for (i = 0; i < ndata; ++i) {
                dbuf[i * 2 + 1] = dbuftemp[i];
            }
            this.setynotDouble(false);
        }
        if (this.getxnotDouble()) {
            for (i = 0; i < ndata; ++i) {
                dbuf[i * 2] = Convert.data2d(data, i * data.bpe + this.xOffset, this.xFormat);
            }
        }
        if (this.getynotDouble()) {
            for (i = 0; i < ndata; ++i) {
                dbuf[i * 2 + 1] = Convert.data2d(data, i * data.bpe + this.yOffset, this.yFormat);
            }
        }
        switch (mode) {
            case 7: 
            case 8: {
                for (i = 0; i < ndata; ++i) {
                    int iod = i * 2 + 1;
                    int iev = i * 2;
                    dbuf[iod] = scale * Math.log(Math.max(1.0E-10, Math.abs(dbuf[iod])));
                }
                break;
            }
        }
        return dbuf;
    }

    private void data2names(Data data, int ndata, double[] dbuf, int mode) {
        int len = Data.getBPA("XA");
        for (int i = 0; i < ndata; ++i) {
            this.names[i] = data.unpackS(i * data.bpe + this.nOffset, len);
        }
    }

    @Override
    public void findRange() {
        if (this.frame == 0) {
            this.frame = this.ndata;
        }
        this.x1 = 0.0;
        this.x2 = 1.0;
        this.y1 = 0.0;
        this.y2 = 1.0;
        if (this.dbuf == null) {
            return;
        }
        this.x1 = this.x2 = this.dbuf[0];
        this.y1 = this.y2 = this.dbuf[1];
        for (int i = 1; i < this.ndata; ++i) {
            if (this.dbuf[i * 2] > this.x2) {
                this.x2 = this.dbuf[i * 2];
            }
            if (this.dbuf[i * 2] < this.x1) {
                this.x1 = this.dbuf[i * 2];
            }
            if (this.dbuf[i * 2 + 1] > this.y2) {
                this.y2 = this.dbuf[i * 2 + 1];
            }
            if (!(this.dbuf[i * 2 + 1] < this.y1)) continue;
            this.y1 = this.dbuf[i * 2 + 1];
        }
        if (this.MP.mode == 6) {
            this.x1 = this.y1;
            this.x2 = this.y2;
        }
        this.autoScale4FindRange(this.y1, this.y2);
        this.setxlMin(this.xMin);
        this.setylMin(this.yMin);
    }

    @Override
    public void draw(int flag) {
        int i21;
        super.draw(flag);
        if (this.ndata <= 0) {
            return;
        }
        int i1 = 0;
        int i2 = this.ndata;
        if (this.size > 0) {
            i2 = this.frame;
        }
        if ((i21 = i2 - i1) <= 0) {
            return;
        }
        Line lin = this.line.copy();
        this.MP.drawLine(this.dbuf, 0, 2, this.data.size, lin, true);
        if (this.haveNames && (this.enable & 2) != 0) {
            MPoint pnt = new MPoint();
            for (int item = 0; item < this.names.length; ++item) {
                this.MP.viewer.rwc2pix(new double[]{this.dbuf[item * 2], this.dbuf[item * 2 + 1]}, pnt, true);
                this.MP.gc.drawString(this.names[item], pnt.x + lin.getFont().getSize() + lin.getRadius(), pnt.y + lin.getRadius());
            }
        }
    }

    @Override
    public void setSize(int value) {
        super.setSize(value);
        if (this.size > 1) {
            this.cmap = 6;
            this.colors = MColor.getColorMap(this.cmap, this.size);
            this.line.setColor(this.colors[1]);
        }
    }

    public void setColumns(int x, int y, DataFile hcb) {
        this.name = this.tag = hcb.getTag();
        this.xOffset = hcb.getRecOffset(x);
        this.xFormat = (char)hcb.getRecFormatType(x);
        this.yOffset = hcb.getRecOffset(y);
        this.yFormat = (char)hcb.getRecFormatType(y);
    }

    private void setColumns(int x, int y, int n, DataFile hcb) {
        this.setColumns(x, y, hcb);
        if (n >= 0) {
            this.haveNames = true;
            this.nOffset = hcb.getRecOffset(n);
            this.nFormat = (char)hcb.getRecFormatType(n);
        }
    }

    public void setColorIndex(int value) {
        this.colorIndex = value;
    }

    public String getTag() {
        return this.tag;
    }

    public double getxMin() {
        return this.xMin;
    }

    public double getyMin() {
        return this.yMin;
    }

    public double getxlMin() {
        return this.xlMin;
    }

    public double getylMin() {
        return this.ylMin;
    }

    public void setxlMin(double x) {
        this.xlMin = x;
    }

    public void setylMin(double x) {
        this.ylMin = x;
    }

    public boolean getxnotDouble() {
        return this.xnotDouble;
    }

    public boolean getynotDouble() {
        return this.ynotDouble;
    }

    public void setxnotDouble(boolean x) {
        this.xnotDouble = x;
    }

    public void setynotDouble(boolean x) {
        this.ynotDouble = x;
    }
}

