/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import javax.imageio.ImageIO;
import nxm.sys.inc.PlotFile;
import nxm.sys.lib.Args;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.libg.Layer;
import nxm.sys.libg.ViewMercader;

public class LayerGMap
extends Layer
implements ImageObserver {
    private BufferedImage[] mbis;
    private BufferedImage[] tbis;
    private BufferedImage[] ibis;
    private String[] murls;
    private String[] turls;
    private String[] iurls;
    private String imgServer;
    private String mapServer;
    private String localServer;
    private int mapAvailable;
    private int imgAvailable;
    private int localAvailable;
    private boolean mapUse;
    private boolean imgUse;
    private boolean tapUse;
    private boolean localUse;
    private int maxLocalLevel;
    public static final String optionsList = "Imagery,Charts,Overlay,Contrast";
    protected static final int O_IMAGERY = 1;
    protected static final int O_CHARTS = 2;
    protected static final int O_OVERLAY = 4;
    protected static final int O_CONTRAST = 8;
    protected static final int O_DEFAULT = 5;
    protected int options = 5;
    protected int opaqueness = 75;
    protected int contrast = 50;
    protected double maxComp = 1.5;
    protected double minComp = 0.001;
    protected static int maxLevel = 18;
    protected int jper;
    protected int busy;

    public LayerGMap() {
        this.name = "GMAP";
        this.typeClass = 7;
        this.frame = 0;
        this.size = 0;
        this.imgServer = "kh1.google.com";
        this.mapServer = "mt1.google.com";
        this.localServer = "/midas/mapdata/gmap";
        this.localAvailable = this.checkServer(this.localServer);
    }

    @Override
    public boolean setFile(PlotFile pf, Table tab, Args MA) {
        this.process();
        return true;
    }

    @Override
    public void process() {
        double[] box = this.MP.getXYGrid(-180.0, 180.0, -90.0, 90.0);
        double gx1 = box[0];
        double gx2 = box[1];
        double gy1 = box[2];
        double gy2 = box[3];
        this.process(gx1, gx2, gy1, gy2);
    }

    public void process(double gx1, double gx2, double gy1, double gy2) {
        double dpc;
        double ppc;
        double res = 1.0 / this.MP.mxx;
        if (this.MP.view == 13) {
            res *= 57.29577951308232;
        }
        int level = 1;
        int div = 1;
        while (!(level >= maxLevel || (ppc = (dpc = 360.0 / (double)div / 256.0) / res) < this.maxComp || this.imgAvailable < 0 && level >= this.maxLocalLevel)) {
            ++level;
            div *= 2;
        }
        this.xstart = -180.0;
        this.xdelta = 360.0 / (double)div;
        double d = Math.max(-180.0, gx1);
        int sx = Math.max(0, (int)((d - this.xstart) / this.xdelta + 0.01));
        this.xstart += this.xdelta * (double)sx;
        d = Math.min(180.0, gx2);
        this.frame = (int)((d - this.xstart) / this.xdelta + 0.99);
        this.frame = Math.min(this.frame, div - sx);
        this.ystart = 180.0;
        this.ydelta = -360.0 / (double)div;
        d = Math.max(-180.0, ViewMercader.lat2mer(gy2));
        int sy = Math.max(0, (int)((d - this.ystart) / this.ydelta + 0.01));
        this.ystart += this.ydelta * (double)sy;
        d = Math.min(180.0, ViewMercader.lat2mer(gy1));
        this.size = (int)((d - this.ystart) / this.ydelta + 0.99);
        this.size = Math.min(this.size, div - sy);
        this.jper = 256;
        if (this.MP.view != 12 && level < 4) {
            this.jper = 32;
        }
        this.imgUse = (this.options & 1) != 0;
        this.mapUse = (this.options & 2) != 0 && (this.options & 1) == 0;
        boolean bl = this.tapUse = (this.options & 4) != 0 && (this.options & 2) == 0;
        if (this.imgUse) {
            this.loadTiles(1, level, sx, sy, this.frame, this.size);
        }
        if (this.mapUse) {
            this.loadTiles(2, level, sx, sy, this.frame, this.size);
        }
        if (this.tapUse) {
            this.loadTiles(4, level, sx, sy, this.frame, this.size);
        }
    }

    private int checkServer(String server) {
        int defstat = -1;
        if (server.equals(this.localServer)) {
            File f = new File(server);
            return f.exists() ? 1 : -1;
        }
        try {
            Shell.info("Resolving " + server);
            InetAddress ia = InetAddress.getByName(server);
            Shell.info("Connecting to " + ia);
            return 1;
        }
        catch (Exception e) {
            this.warning(e.getMessage());
            this.warning("Problem connecting to " + server);
            return defstat;
        }
    }

    private void loadTiles(int type, int level, int sx, int sy, int nx, int ny) {
        int z = 0;
        String url = null;
        String lurl = null;
        BufferedImage bi = null;
        String[] urls = null;
        String[] u = new String[nx * ny];
        BufferedImage[] bis = null;
        BufferedImage[] b = new BufferedImage[nx * ny];
        if (type == 1) {
            urls = this.iurls;
            bis = this.ibis;
        }
        if (type == 2) {
            urls = this.murls;
            bis = this.mbis;
        }
        if (type == 4) {
            urls = this.turls;
            bis = this.tbis;
        }
        StringBuffer sb = new StringBuffer(32);
        for (int y = 0; y < ny; ++y) {
            int x = 0;
            while (x < nx) {
                block25: {
                    String surl;
                    block27: {
                        block28: {
                            block26: {
                                this.busy = (z + 1) * 100 / (nx * ny + 1);
                                bi = null;
                                int ix = sx + x;
                                int iy = sy + y;
                                if (type == 1) {
                                    sb.setLength(0);
                                    sb.append('t');
                                    for (int i = 2; i <= level; ++i) {
                                        boolean by;
                                        int mask = 1 << level - i;
                                        boolean bx = (ix & mask) != 0;
                                        boolean bl = by = (iy & mask) != 0;
                                        if (by) {
                                            sb.append(bx ? (char)'s' : 't');
                                            continue;
                                        }
                                        sb.append(bx ? (char)'r' : 'q');
                                    }
                                    url = "/kh?v=3&n=404&t=" + sb;
                                    lurl = "/kh_" + sb + ".jpg";
                                } else if (type == 2) {
                                    int iz = 18 - level;
                                    url = "/mt?v=t2.2&n=404&x=" + ix + "&y=" + iy + "&zoom=" + iz;
                                    lurl = "/mt_t2_x" + ix + "y" + iy + "zoom" + iz + ".jpg";
                                } else if (type == 4) {
                                    int iz = 18 - level;
                                    url = "/mt?v=t2t.2&n=404&x=" + ix + "&y=" + iy + "&zoom=" + iz;
                                    lurl = "/mt_t2t_x" + ix + "y" + iy + "zoom" + iz + ".jpg";
                                }
                                if (urls != null) {
                                    for (int c = 0; c < urls.length; ++c) {
                                        if (!url.equals(urls[c])) continue;
                                        bi = bis[c];
                                        break;
                                    }
                                }
                                if (bi != null) break block25;
                                surl = null;
                                if (this.localAvailable > 0) {
                                    surl = this.localServer + lurl;
                                    File f = new File(surl);
                                    String string = surl = f.exists() ? "file:" + this.localServer + lurl : null;
                                }
                                if (surl == null) break block26;
                                this.maxLocalLevel = Math.max(this.maxLocalLevel, level);
                                break block27;
                            }
                            if (type != 1) break block28;
                            if (this.imgAvailable == 0) {
                                this.imgAvailable = this.checkServer(this.imgServer);
                            }
                            if (this.imgAvailable < 0) break block25;
                            surl = "http://" + this.imgServer + url;
                            break block27;
                        }
                        if (this.mapAvailable == 0) {
                            this.mapAvailable = this.checkServer(this.mapServer);
                        }
                        if (this.mapAvailable < 0) break block25;
                        surl = "http://" + this.mapServer + url;
                    }
                    Shell.info("Loading " + surl);
                    try {
                        bi = ImageIO.read(new URI(surl).toURL());
                    }
                    catch (Exception e) {
                        this.warning("GMapErr: No data from Google: " + e);
                    }
                }
                u[z] = url;
                b[z] = bi;
                ++x;
                ++z;
            }
        }
        if (type == 1) {
            this.iurls = u;
            this.ibis = b;
        }
        if (type == 2) {
            this.murls = u;
            this.mbis = b;
        }
        if (type == 4) {
            this.turls = u;
            this.tbis = b;
        }
    }

    @Override
    public void findRange() {
        this.x1 = -180.0;
        this.x2 = 180.0;
        this.y1 = -90.0;
        this.y2 = 90.0;
        this.z1 = 0.0;
        this.z2 = 1.0;
        this.a1 = this.y1;
        this.a2 = this.y2;
    }

    @Override
    public void findFullRange() {
        this.findFullRange(this.pf);
    }

    @Override
    public void draw(int flag) {
        super.draw(flag);
        if (this.MP.xvy || this.MP.gc == null) {
            return;
        }
        double[] box = this.MP.getXYGrid(-180.0, 180.0, -90.0, 90.0);
        double gx1 = box[0];
        double gx2 = box[1];
        double gy1 = box[2];
        double gy2 = box[3];
        this.process(gx1, gx2, gy1, gy2);
        for (int y = 0; y < this.size; ++y) {
            for (int x = 0; x < this.frame && !this.MP.cancel; ++x) {
                int z = x + y * this.frame;
                int jx1 = 0;
                int jx2 = 256;
                int jy1 = 0;
                int jy2 = 256;
                int ix1 = this.MP.ix1;
                int ix2 = this.MP.ix2;
                int iy1 = this.MP.iy1;
                int iy2 = this.MP.iy2;
                double xs = this.xstart + (double)x * this.xdelta;
                double xe = this.xstart + (double)(x + 1) * this.xdelta;
                double xd = (xe - xs) / (double)jx2;
                double ys = this.ystart + (double)y * this.ydelta;
                double ye = this.ystart + (double)(y + 1) * this.ydelta;
                double yd = (ye - ys) / (double)jy2;
                if (this.MP.is2D) {
                    if (xs > this.MP.rx2 || xs + (double)jx2 * xd < this.MP.rx1) continue;
                } else {
                    if (!this.imgUse || this.ibis[z] == null) continue;
                    this.MP.drawImage(this.ibis[z], null, true, xs, xd, jx2, ys, yd, jy2);
                    continue;
                }
                jx1 = Math.max(jx1, (int)((this.MP.rx1 - xs) / xd + 0.49));
                jx2 = Math.min(jx2, (int)((this.MP.rx2 - xs) / xd + 1.51));
                ys = ViewMercader.mer2lat(ys);
                ye = ViewMercader.mer2lat(ye);
                yd = (ye - ys) / (double)jy2;
                ix1 = (int)(this.MP.mxx * (xs + (double)jx1 * xd) + this.MP.mxb);
                ix2 = (int)(this.MP.mxx * (xs + (double)jx2 * xd) + this.MP.mxb);
                while (jy1 < jy2) {
                    int jy2x = Math.min(jy1 + this.jper, jy2);
                    double ym1 = ViewMercader.mer2lat(this.ystart + (double)y * this.ydelta + (double)jy1 * this.ydelta / 256.0);
                    double ym2 = ViewMercader.mer2lat(this.ystart + (double)y * this.ydelta + (double)jy2x * this.ydelta / 256.0);
                    if (this.MP.view == 12) {
                        iy1 = this.MP.viewMerc.ry2iy(ym1);
                        iy2 = this.MP.viewMerc.ry2iy(ym2);
                    } else {
                        iy1 = (int)(this.MP.myy * ym1 + this.MP.myb);
                        iy2 = (int)(this.MP.myy * ym2 + this.MP.myb);
                    }
                    if (this.imgUse && this.ibis[z] != null) {
                        this.MP.gc.drawImage(this.ibis[z], ix1, iy1, ix2, iy2, jx1, jy1, jx2, jy2x, this);
                    }
                    if (this.mapUse && this.mbis[z] != null) {
                        this.MP.gc.drawImage(this.mbis[z], ix1, iy1, ix2, iy2, jx1, jy1, jx2, jy2x, this);
                    }
                    if (this.tapUse && this.tbis[z] != null) {
                        this.MP.gc.drawImage(this.tbis[z], ix1, iy1, ix2, iy2, jx1, jy1, jx2, jy2x, this);
                    }
                    jy1 = jy2x;
                }
            }
        }
        this.busy = 0;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return true;
    }

    public void setOptions(String list3) {
        int oldOptions = this.options;
        this.options = Parser.mask(optionsList, list3, this.options);
        if (this.options != oldOptions) {
            this.refresh();
        }
    }

    public String getOptions() {
        return Parser.mask2s(optionsList, this.options);
    }

    public void setContrast(int percent) {
        int oldContrast = this.contrast;
        this.contrast = Math.max(0, Math.min(100, percent));
        if (this.contrast != oldContrast && (this.options & 8) != 0) {
            this.refresh();
        }
    }

    public int getContrast() {
        return this.contrast;
    }

    public int getBusy() {
        return this.busy;
    }
}

