/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Graphics;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Message;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GWidget;

public class GLabel
extends GWidget {
    private int pw;
    private int active;
    public static final String activeList = "Collapsed,AlwaysClosed,Hidden,Closed,Open,AlwaysOpen,Collapsable,Toggle";
    private static final int activeOffset = -4;
    public static final int aCOLLAPSED = -3;
    public static final int aALWAYSCLOSED = -2;
    public static final int aHIDDEN = -1;
    public static final int aCLOSED = 0;
    public static final int aOPEN = 1;
    public static final int aALWAYSOPEN = 2;
    public static final int aCOLLAPSABLE = 3;
    public static final int aTOGGLE = 4;
    public GWidget lastWidget = null;

    public GLabel(Object parent, String name, int active, int flags, MessageHandler mh) {
        super("GLabel", parent, name, flags, mh);
        this.open(name, active);
        this.addTo(parent);
    }

    public GLabel(Object parent, String name, String active, int flags, MessageHandler mh) {
        super("GLabel", parent, name, flags, mh);
        this.open(name, this.getActiveID(active));
        this.addTo(parent);
    }

    public void open(String name, int active) {
        super.open();
        this.active = active;
        this.pw = this.stringWidth(this.title);
        this.setup();
    }

    @Override
    public void setup() {
        this.bw = this.is(32) ? 0 : 4;
        this.pos.w = this.bw + this.pw + this.bw;
        if (this.fixWidth > this.pos.w) {
            this.pos.w = this.fixWidth;
        }
        this.pos.h = this.bw + this.th + this.ta + this.bw - this.compression;
        this.layout();
    }

    @Override
    @Deprecated
    public void paint() {
        this.refresh();
    }

    @Override
    @ProvisionalUseOnly(value="Treat this as protected and should only be called by subclass paintComponent methods")
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (g == null) {
            return;
        }
        int bf = this.is(32) ? -5 : 0;
        boolean open = this.active > 0;
        this.shadowbox(g, 0, 0, this.pos.w, this.pos.h, bf);
        int tx = this.pos.w / 2 - this.pw / 2;
        int ty = this.pos.h / 2 + this.ta / 2;
        this.setColor(g, open ? this.theme.cwfh : this.theme.cwfh.darker());
        g.drawString(this.title, tx, ty);
        this.setColor(g, this.theme.cfg);
        if (!this.isFixed() && this.isEnabled()) {
            int yo;
            int aw = this.tw * 2 / 3;
            int n = yo = open ? aw : -aw;
            if (this.pos.w > this.pw + 10 * aw) {
                this.shadowarrow(g, this.pos.w - 3 * aw, this.pos.h / 2 + yo, aw, open ? (char)'u' : 'd');
            }
        }
    }

    @Override
    public String getLegend() {
        return this.isFixed() ? "(LM=Fixed)" : "(LM=Open/Close)";
    }

    public boolean isFixed() {
        return this.active == 2 || this.active == -2;
    }

    @Override
    public void setTitle(String title) {
        this.pw = this.stringWidth(title);
        super.setTitle(title);
    }

    @Override
    public int processEventMessage(String name, int info, Object data) {
        if (name.equals("POINTER")) {
            this.formatReadOut(info);
        }
        if (name.equals("BUTTON")) {
            if (info == 1) {
                this.setActive(this.toggledActive(), 1);
            } else if (info == 2) {
                this.configure();
            } else if (info == 3) {
                new GMenu(this.parent, "GLabel.active", activeList, this.active - -4, 0, this);
            }
            this.formatReadOut(info);
            return 1;
        }
        return -1;
    }

    @Override
    public int processMessage(Message msg) {
        if (msg.name.equals("GLABEL.CFG")) {
            this.flags = msg.info;
            this.setup();
            this.refresh();
        } else if (msg.name.equals("GLABEL.ACTIVE")) {
            this.setActive(msg.info + -4);
        }
        return 1;
    }

    @Override
    public Object getValue() {
        return Parser.get(activeList, this.active - -4);
    }

    @Override
    public void setValue(String value) {
        this.setActive(this.getActiveID(value), 0);
    }

    @Override
    public void setAction(String value) {
        this.setActionType();
        this.setActive(this.getActiveID(value), 1);
    }

    public void setActive(int value) {
        this.setActive(value, 1);
    }

    public void setActive(int value, int flag) {
        if (value == this.active) {
            return;
        }
        if (value == 4) {
            value = this.toggledActive();
        }
        this.active = value;
        this.refresh();
        if (flag > 0) {
            this.sendWidgetMessage(this.label, this.active, this.getValue());
        }
        this.layout();
    }

    private int toggledActive() {
        int tactive = this.active;
        if (this.active == 1) {
            tactive = 0;
        } else if (this.active == 0) {
            tactive = 1;
        } else if (this.active == -3) {
            tactive = 1;
        } else if (this.active == 3) {
            tactive = -3;
        }
        return tactive;
    }

    public int getActive() {
        return this.active;
    }

    @Override
    public Object setKey(String key, Object value) {
        if (key.equals("VALUE")) {
            this.setValue(Convert.o2s(value));
        } else if (key.equals("ACTIVE")) {
            this.setActive(Convert.o2l(value));
        } else {
            value = super.setKey(key, value);
        }
        return value;
    }

    @Override
    public Object getKey(String key) {
        Object value = key.equals("VALUE") ? this.getValue() : (key.equals("ACTIVE") ? Convert.l2o(this.active) : super.getKey(key));
        return value;
    }

    @Override
    public String toString() {
        return this.toList((String)this.getValue(), activeList);
    }

    private int getActiveID(String value) {
        int id = Parser.find(activeList, value, this.active, -4);
        if (id <= -4) {
            Shell.warning("GCONTROL LABEL: Unknown active state '" + value + "' using default.");
            id = 1;
        }
        return id;
    }
}

