/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Graphics;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Message;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Table;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.MBox;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MPlot;
import nxm.sys.libg.MWindow;
import nxm.sys.libg.WidgetPanel;

public class GDialog
extends GWidget
implements WidgetPanel {
    protected boolean needsResize = true;
    private static String defButtonsList = "Submit,Cancel";
    private static String defNoCloseButtons = null;
    private String noCloseButtons = defNoCloseButtons;
    private int sw;
    private int rw;
    private int gh;
    private int grid;
    private int dialog;
    private Table widgets;
    public GMenu gdialog;
    private int minw;
    private int minh;
    private int maxh;
    private int fullh;
    private int maxWidgets;
    private boolean rollup;
    private GWidget gwl;
    private boolean resizing;

    public GDialog(Object parent, String name, int pw, int ph, String buttonsList, String noCloseList, int flags, MessageHandler mh) {
        super("GDialog", parent, name, 0x10000000, mh);
        this.open();
        if (parent instanceof MPlot) {
            ++((MPlot)parent).popupCount;
        }
        this.init(buttonsList, noCloseList, pw, ph, flags);
        this.addTo(parent);
    }

    public GDialog(Object parent, String name, MessageHandler mh) {
        super("GDialog", parent, name, 0x10000000, mh);
        this.open();
    }

    public GDialog(Object parent, String name, int pw, int ph, int flags, MessageHandler mh) {
        this(parent, name, pw, ph, defButtonsList, defNoCloseButtons, flags, mh);
    }

    public GDialog(Object parent, String name, Table table, Table config, int flags, MessageHandler mh) {
        super("GDialog", parent, name, flags | 0x10000000, mh);
        this.open();
        this.setDialog(defButtonsList, -1);
        this.addTo(parent);
    }

    protected void init(String buttonsList, String noCloseList, int pw, int ph, int flags) {
        this.flags = flags;
        if (pw < 0) {
            pw = -pw * this.tw;
        }
        if (ph < 0) {
            ph = -ph * this.th;
        }
        if (pw == 0) {
            pw = 300;
        }
        if (ph == 0) {
            ph = 200;
        }
        this.open(this.name, pw, ph);
        this.setDialog(buttonsList, -1);
        this.setNoCloseButtonsList(noCloseList);
    }

    @Override
    public void close() {
        if (this.gdialog != null) {
            this.gdialog.close();
        }
        if (this.parent instanceof MPlot) {
            --((MPlot)this.parent).popupCount;
        }
        super.close();
    }

    @Override
    public void setup() {
        this.bw = 4;
        this.dialog = this.th + this.ta + this.bw;
        this.titleh = this.th + this.ta;
        this.sw = this.bw * 2;
        this.rw = 15;
        this.grid = 5;
        this.pos.w = this.sw + this.pw + this.sw;
        this.pos.h = this.titleh + this.ph + this.dialog;
        this.positionDialog();
        this.layout();
    }

    private void positionDialog() {
        if (this.gdialog == null) {
            return;
        }
        this.gdialog.pos.x = (this.pos.w - this.gdialog.pos.w) / 2;
        this.gdialog.pos.y = this.pos.h - this.dialog + (this.dialog - this.gdialog.pos.h) / 2;
        this.gdialog.setBounds(this.gdialog.pos);
    }

    @Override
    public void resize(int mode) {
        super.resize(mode);
        if (this.parent instanceof MWindow) {
            MWindow mw = (MWindow)this.parent;
            if (this.pos.h > mw.pos.h) {
                this.pos.h = Math.max(mw.pos.h, this.minDialogHeight());
            }
        }
        this.pw = this.pos.w - this.sw - this.sw;
        this.ph = this.pos.h - this.titleh - this.dialog;
        if (this.rollup) {
            return;
        }
        this.positionDialog();
        if (this.widgets == null || this.widgets.size() <= 1) {
            return;
        }
        Table.Iterator ti = this.widgets.iterator();
        GWidget gwl = this.gdialog;
        for (int i = 1; i < ti.size; ++i) {
            GWidget gw = (GWidget)ti.values[i];
            if (i == ti.size - 1 && gw.isStretchable()) {
                gw.pos.h = this.pos.h - this.dialog - gw.pos.y;
            }
            int w = this.pw;
            int h = gw.pos.h;
            if (gw.is(0x40000000)) {
                w = this.pw / 2;
            }
            if (gwl.is(0x40000000)) {
                gw.pos.x = this.sw + this.pw / 2;
                w = this.pw - this.pw / 2;
            }
            gw.fixWidth(w);
            if (w != gw.pos.w || h != gw.pos.h) {
                gw.pos.w = w;
                gw.pos.h = h;
            }
            gw.setBounds(gw.pos);
            gwl = gw;
        }
    }

    private int minDialogHeight() {
        int minHeight;
        int n = minHeight = this.gdialog.is(0x40000000) ? this.titleh : this.titleh + this.gdialog.pos.h;
        if (this.widgets == null || this.widgets.size() <= 1) {
            return minHeight;
        }
        Table.Iterator ti = this.widgets.iterator();
        GMenu gwl = this.gdialog;
        for (int i = 1; i < ti.size; ++i) {
            GWidget gw = (GWidget)ti.values[i];
            int h = gw.pos.h;
            if (gw.is(0x40000000)) continue;
            minHeight += gw.pos.h;
        }
        return minHeight;
    }

    @Override
    public void setWidgetTheme(Object obj) {
        super.setWidgetTheme(obj);
        if (this.gdialog != null) {
            this.gdialog.setWidgetTheme(obj);
        }
    }

    @Override
    @Deprecated
    public void paint() {
        this.refresh();
    }

    @Override
    @ProvisionalUseOnly(value="Treat this as protected and should only be called by subclass paintComponent methods")
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (g == null || this.bw == 0) {
            return;
        }
        int x = 0;
        int y = 0;
        int w = this.pos.w;
        int h = this.pos.h;
        int dh = this.titleh;
        int dd = this.dialog;
        int j1 = (int)((double)dh * 0.15);
        for (int i = 1; i < dh; ++i) {
            if (i < j1) {
                g.setColor(MColor.getColorMix(this.theme.cwbg, this.theme.cwbs, (double)i / (double)j1));
            } else {
                g.setColor(MColor.getColorMix(this.theme.cwbs, this.theme.cwms, (double)(i - j1) / (double)(dh - j1 - 1)));
            }
            g.drawLine(x, y + i, x + w, y + i);
            if (this.rollup) continue;
            g.drawLine(x, h - i, x + w, h - i);
        }
        g.drawLine(x, y, w, y);
        g.setColor(this.theme.getWidgetTitle());
        g.drawString(this.title, w / 2 - this.titlew / 2, this.titleh / 2 + this.ta / 2);
        int aw = this.tw * 2 / 3;
        int yo = this.rollup ? -aw : aw;
        this.shadowarrow(g, this.pos.w - 3 * aw, this.titleh / 2 + yo, aw, this.rollup ? (char)'d' : 'u');
        if (this.rollup) {
            return;
        }
        g.setColor(this.theme.cwms);
        g.fillRect(x, y + dh, w, h - 2 * dh + 1);
        g.drawLine(x, h, w, h);
        g.drawLine(w - 1, y, w - 1, y + h);
        g.setColor(this.theme.cwbg);
        g.drawLine(x, y, x, y + h);
        g.drawLine(w - 1, y, w - 1, y + h);
        g.setColor(this.theme.cwbs);
        g.drawLine(x + this.sw, y + dh - 1, w - this.sw - 2, y + dh - 1);
        g.drawLine(x + this.sw - 1, y + dh, x + this.sw - 1, h - dd - 1);
        g.setColor(this.theme.cwts);
        for (int i = 1; i < this.rw; i += 4) {
            g.drawLine(w - this.bw - i, h - this.bw, w - this.bw, h - this.bw - i);
        }
        Table.Iterator ti = this.widgets.iterator();
        for (int i = 0; i < ti.size; ++i) {
            GWidget gw = (GWidget)ti.values[i];
            if (gw.status == 1) continue;
            gw.display(1);
        }
    }

    public void setDialog(String list3, int item) {
        if (this.widgets == null) {
            this.widgets = new Table();
        }
        int mflags = 16974336;
        GMenu gw = this.gdialog = new GMenu(null, "DIALOG", list3, item, 0x25 | mflags, this);
        this.minw = Math.max(this.minw, gw.pos.w);
        if (this.minw > this.pw) {
            this.pw = this.minw;
        }
        gw.MW = this;
        gw.parent = gw.MW;
        gw.setWidgetPanel(this);
        this.widgets.put("DIALOG", (Object)this.gdialog);
        this.setup();
        this.addOn(gw.panel);
        this.gwl = gw;
    }

    @Override
    public Object addWidget(GWidget gw) {
        if (this.widgets == null) {
            this.widgets = new Table();
        }
        this.minw = Math.max(this.minw, gw.pos.w + (this.gwl.is(0x40000000) ? this.gwl.pos.w : 0));
        gw.MW = this;
        gw.parent = gw.MW;
        gw.setFlag(37, true);
        gw.setWidgetPanel(this);
        int w = this.pw;
        int h = gw.pos.h;
        gw.pos.x = this.sw;
        gw.pos.y = this.gh + this.titleh;
        if (gw.is(0x40000000)) {
            w = this.pw / 2;
        } else {
            this.gh += h;
        }
        if (this.gwl.is(0x40000000)) {
            gw.pos.x = this.sw + this.pw / 2;
            w = this.pw / 2;
        }
        this.minh = Math.max(this.minh, this.gh);
        if (this.gh >= this.ph) {
            this.ph = this.gh;
            this.setup();
            this.refresh();
        } else if (this.widgets.size() == this.maxWidgets) {
            h = this.ph - gw.pos.y;
        }
        if (w != gw.pos.w || h != gw.pos.h) {
            gw.pos.w = w;
            gw.pos.h = h;
        }
        gw.setBounds(gw.pos);
        gw.MW.panel.add(gw.panel);
        if (this.status == 1) {
            gw.display(1);
        }
        this.widgets.put(gw.label, (Object)gw);
        this.gwl = gw;
        if (this.needsResize) {
            this.layout();
            this.resize(1);
        }
        return gw;
    }

    @Override
    public void layoutWidget(GWidget obj) {
    }

    public Table getWidgets() {
        return this.widgets;
    }

    @Override
    protected int processEventMessage(String name, int info, Object data) {
        if (name.equals("DRAG")) {
            MBox mb = (MBox)data;
            if (this.resizing) {
                int w = Math.max(this.minw + this.sw * 2, mb.x + mb.w + this.rw);
                int h = Math.max(this.minh + this.titleh + this.dialog, mb.y + mb.h + this.rw);
                if (Math.abs(w - this.pos.w) > this.grid || Math.abs(h - this.pos.h) > this.grid) {
                    this.pos.w = w;
                    this.pos.h = h;
                    this.resize(1);
                    this.refresh();
                }
            } else if (mb.y > this.pos.h - this.dialog / 2 && mb.x > this.pos.w - this.dialog / 2) {
                this.resizing = true;
            } else if (this.dragging == 1 && (Math.abs(mb.w) > this.grid || Math.abs(mb.h) > this.grid)) {
                this.pos.x += mb.w;
                this.pos.y += mb.h;
                this.setBounds(this.pos);
                this.dragging = 0;
            }
            return 1;
        }
        if (name.equals("DRAGBOX") && this.resizing) {
            this.resizing = false;
            return 1;
        }
        if (name.equals("BUTTON") && info == 1 && this.py < this.titleh) {
            boolean bl = this.rollup = !this.rollup;
            if (this.rollup) {
                this.fullh = this.pos.h;
                this.pos.h = this.titleh;
            } else {
                this.pos.h = this.fullh;
            }
            this.resize(1);
            this.refresh();
            return 1;
        }
        return -1;
    }

    @Override
    public int processMessage(Message msg) {
        if (msg.name.equals("DIALOG")) {
            String action = (String)msg.data;
            if (!action.equalsIgnoreCase("CANCEL")) {
                Table msgTab = this.getWidgets();
                int info = this.gdialog.getItemIndex(action);
                this.sendWidgetMessage(this.label, info, msgTab);
            }
            if (!this.is(1) && this.isCloseButton(action)) {
                this.close();
            }
        }
        return 1;
    }

    public String getButtonsList() {
        return this.gdialog.getItems();
    }

    public String getNoCloseButtonsList() {
        return this.noCloseButtons;
    }

    public boolean isCloseButton(String buttonName) {
        boolean isClose = true;
        if (this.noCloseButtons != null) {
            isClose = Parser.find(this.noCloseButtons, buttonName, -1) < 0;
        }
        return isClose;
    }

    public void setButtonsList(String list3) {
        this.gdialog.setItems(list3);
    }

    public void setNoCloseButtonsList(String buttons) {
        this.noCloseButtons = buttons;
    }

    public void setMaxWidgets(int n) {
        this.maxWidgets = n;
    }
}

