/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Timer;
import nxm.sys.inc.Installation;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Message;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.MBox;

public class GAlert
extends GWidget {
    private Vector<Object> itemv = new Vector(8, 8);
    private int pw;
    private int items;
    private int maxwidth = 0;
    private int defitem = 0;
    private String list;
    private String prompt;
    private MBox bp;
    private MBox bt;
    private MBox bc;
    private ActionListener timeoutHandler;
    private Timer timeoutTimer;
    public static final String flagsList = GWidget.flagsList + ",List";
    public final int LIST = 256;

    public GAlert(Object parent, String name, String text, String list3, int item, int flags, MessageHandler mh) {
        this(parent, name, text, list3, item, flags, mh, -1);
    }

    public GAlert(Object parent, String name, String text, String list3, int item, int flags, MessageHandler mh, int timeout) {
        super("GAlert", parent, name, flags, mh);
        this.open(name, text, list3, item);
        this.addTo(parent);
        if (timeout > 0) {
            this.timeoutHandler = e -> {
                this.close();
                if (this.timeoutTimer != null) {
                    this.timeoutTimer.removeActionListener(this.timeoutHandler);
                    this.timeoutTimer = null;
                }
            };
            this.timeoutTimer = new Timer(timeout * 1000, this.timeoutHandler);
            this.timeoutTimer.start();
        }
    }

    public void open(String name, String text, String list3, int item) {
        super.open();
        this.prompt = text;
        this.list = list3;
        this.defitem = item;
        this.itemv.addElement(this.title);
        int j = 0;
        int i = 0;
        int k = list3.length();
        while (i < k) {
            j = list3.indexOf(44, i);
            if (j == -1) {
                j = k;
            }
            String tmpstr = list3.substring(i, j);
            this.itemv.addElement(tmpstr);
            int w = this.stringWidth(tmpstr) + this.tw;
            if (this.is(256)) {
                this.maxwidth += w;
            } else if (w > this.maxwidth) {
                this.maxwidth = w;
            }
            i = j + 1;
        }
        this.items = this.itemv.size() - 1;
        this.pw = this.stringWidth(this.prompt);
        this.setup();
    }

    @Override
    public void setup() {
        int h = this.th + this.ta;
        this.bw = this.is(32) ? 0 : 4;
        this.bp = new MBox(this.tw / 2, this.bw, this.pw, h);
        this.bc = new MBox(this.bp.x + this.bp.w, this.bw, this.th + this.tw, h);
        this.bt = new MBox(this.bc.x + this.bc.w, this.bw / 2, this.maxwidth, h + this.bw);
        this.pos.w = this.bt.x + this.bt.w + this.bw;
        this.pos.h = this.bw + h + this.bw;
        if (this.is(32)) {
            this.bt.h = this.pos.h;
            this.bt.y = 0;
        }
        this.layout();
    }

    @Override
    @Deprecated
    public void paint() {
        this.refresh();
    }

    @Override
    @ProvisionalUseOnly(value="Treat this as protected and should only be called by subclass paintComponent methods")
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.useSwing || Installation.ApplyBugFix.GCONTROL_WTHEME_OVERRIDES_THEME) {
            g.setColor(this.theme.cwbg);
            g.fillRect(0, 0, this.pos.w, this.pos.h);
        }
        this.shadowbox(g, 0, 0, this.pos.w, this.pos.h, 3);
        int aw = this.tw * 2 / 3;
        int ty = this.pos.h / 2 + this.th / 3;
        g.setColor(this.theme.getWidgetTitle());
        g.drawString(this.prompt, this.bp.x, ty);
        this.shadowarrow(g, this.bc.x + this.bc.w / 2, this.bc.y + this.bc.h / 2, aw, 'B');
        int j = 0;
        for (int i = 1; i <= this.items; ++i) {
            String value = (String)this.itemv.elementAt(i);
            g.setColor(i == this.defitem && this.items > 1 ? this.theme.cwfh : this.theme.cwfg);
            if (i == this.defitem || this.is(256)) {
                g.drawString(value, this.bt.x + j, ty);
            }
            if (!this.is(256)) continue;
            j += (value.length() + 1) * this.tw;
        }
    }

    @Override
    public int processEventMessage(String name, int info, Object data) {
        if (!name.equals("BUTTON")) {
            return -1;
        }
        if (info == 1 && this.px > this.bt.x) {
            if (!this.is(256) || this.items <= 1) {
                this.select(this.defitem, 1);
            } else {
                int j = this.bt.x;
                for (int i = 1; i <= this.items; ++i) {
                    String value = (String)this.itemv.elementAt(i);
                    if (this.px >= (j += (value.length() + 1) * this.tw)) continue;
                    this.select(i, 1);
                    break;
                }
            }
        } else if (info == 2 && this.px > this.bt.x) {
            new GMenu(this.parent, "", this.list, this.defitem, 0, this);
        } else if (this.px >= this.bc.x && this.px <= this.bc.x + this.bc.w) {
            int item = this.defitem;
            if (info == 1) {
                item = Math.min(this.defitem + 1, this.items);
            }
            if (info == 3) {
                item = Math.max(this.defitem - 1, 1);
            }
            if (item != this.defitem) {
                this.select(item, 0);
            }
        }
        return 1;
    }

    @Override
    public int processMessage(Message msg) {
        if (msg.name.isEmpty()) {
            this.select(msg.info, 1);
            return 1;
        }
        return super.processMessage(msg);
    }

    private void select(int item, int mode) {
        this.defitem = item;
        String data = ((String)this.itemv.elementAt(item)).toUpperCase();
        if (mode == 1) {
            this.sendWidgetMessage(this.label, item, data);
            this.close();
        } else {
            this.refresh();
        }
    }

    public void setText(String text) {
        this.prompt = text;
        this.pw = this.stringWidth(this.prompt);
        this.setup();
        this.panel.setSize(this.pos.w, this.pos.h);
        this.refresh();
    }

    public void setValue(String text, int button) {
        for (int i = 1; i <= this.items; ++i) {
            String value = ((String)this.itemv.elementAt(i)).toUpperCase();
            if (!value.startsWith(text)) continue;
            value = ((String)this.itemv.elementAt(i)).toUpperCase();
            if (button > 0) {
                this.sendWidgetMessage(this.label, i, value);
            }
            this.setValue(i);
            return;
        }
    }

    public void setValue(int item) {
        this.defitem = item;
        this.refresh();
    }

    @Override
    public Object setKey(String key, Object value) {
        if (key.equals("ACTION")) {
            this.setValue((String)value, 1);
        } else if (key.equals("VALUE")) {
            this.setValue((String)value, 0);
        } else if (key.equals("TEXT")) {
            this.setText((String)value);
        } else if (key.equals("ITEM")) {
            this.setValue(Convert.o2l(value));
        } else {
            value = super.setKey(key, value);
        }
        return value;
    }

    @Override
    public Object getKey(String key) {
        Object value = key.equals("VALUE") ? this.itemv.elementAt(this.defitem) : (key.equals("TEXT") ? this.prompt : (key.equals("ITEM") ? Convert.l2o(this.defitem) : super.getKey(key)));
        return value;
    }
}

