/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.Comparator;
import nxm.sys.inc.Chainable;
import nxm.sys.inc.Drawable;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.Tablizable;
import nxm.sys.lib.Convert;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.Message;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Position;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Util;
import nxm.sys.libg.GDialog;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GPrompt;
import nxm.sys.libg.GQuery;
import nxm.sys.libg.GValue;
import nxm.sys.libg.Layer;
import nxm.sys.libg.Line;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MPlot;
import nxm.sys.libg.MPoint;
import nxm.sys.libg.Symbol;

public class Feature
implements MessageHandler,
Chainable,
Drawable,
Tablizable {
    private static final boolean FAST_DT2DY = true;
    public static final String typeList = "Symbol,Data,HLine,VLine,Box,Circle,Oval,Elps,Ltag,Rtag,Ttag,Btag,Dtag,Peak,IPlot,VRide,OSymbol,Text,Inverse,Tri,Filled,XLine,YLine,HBar,VBar,DLine,CustomTag";
    public static final int SYMBOL = 1;
    public static final int DATA = 2;
    public static final int HLINE = 4;
    public static final int VLINE = 8;
    public static final int BOX = 16;
    public static final int CIRC = 32;
    public static final int OVAL = 64;
    public static final int ELPS = 128;
    public static final int LTAG = 256;
    public static final int RTAG = 512;
    public static final int TTAG = 1024;
    public static final int BTAG = 2048;
    public static final int DTAG = 4096;
    public static final int PEAK = 8192;
    public static final int IPLT = 16384;
    public static final int VRIDE = 32768;
    public static final int OSYMBOL = 65536;
    public static final int TEXT = 131072;
    public static final int INVERSE = 262144;
    public static final int TRI = 524288;
    public static final int FILLED = 0x100000;
    public static final int XLINE = 0x200000;
    public static final int YLINE = 0x400000;
    public static final int HBAR = 0x800000;
    public static final int VBAR = 0x1000000;
    @InternalUseOnly
    public static final int DLINE = 0x2000000;
    @InternalUseOnly
    public static final int CUSTOMTAG = 0x4000000;
    public static final String anchorList = "Data,Screen,Pixel";
    public static final int A_DATA = 1;
    public static final int A_SCREEN = 2;
    public static final int A_PIXEL = 3;
    final double DT_GAP = 0.1;
    static final int SYMBOL_AND_TEXT = 131073;
    static final int ALL_TAGS = 67116800;
    private CustomTagReference customTagReference = CustomTagReference.TR;
    private int customTagPixelX = 0;
    private int customTagPixelY = 0;
    protected String name;
    protected int enable = 251;
    protected boolean needRefresh = false;
    protected Line line;
    protected MPlot MP;
    private Layer layer;
    private int type = 1;
    private int anchor = 1;
    private String text;
    private double semiMajor = 10000.0;
    private double semiMinor = 1000.0;
    private double tilt = 30.0;
    private final MPoint pix = new MPoint();
    private double timeAtTop;
    private Object metadata;
    private double x;
    private double y;
    private double z;
    private double t;
    private double dx;
    private double dy;
    private double dz;
    private double dt = -1.0;
    private static boolean warningFeatureNotDrawn = false;
    private boolean needWarnIfFeatureNotDrawn = warningFeatureNotDrawn;
    private String group;
    private boolean visible = false;
    @InternalUseOnly
    private double textZoomRatio = 1.0;
    @InternalUseOnly
    private double featureZoomRatio = 1.0;
    int ix1Last;
    int ix2Last;
    int iy1Last;
    int iy2Last;

    public Feature() {
        this.line = new Line(this);
        this.line.setSymbol("CROSS");
    }

    public Feature(Layer layer) {
        this();
        this.type = 2;
        this.layer = layer;
        this.MP = layer.MP;
    }

    public Feature(Table t) {
        this();
        this.fromTable(t);
    }

    @Override
    public boolean getNeedRefresh() {
        return this.needRefresh || this.line.getNeedRefresh();
    }

    @Override
    public void clearNeedRefresh() {
        this.needRefresh = false;
        this.line.clearNeedRefresh();
    }

    @Override
    public void draw(int mode) {
        int iy2;
        int iy1;
        int ix2;
        int ix1;
        int iy;
        int ix;
        double ratio;
        if (this.MP.gc == null) {
            return;
        }
        if (this.featureZoomRatio != 1.0 && (ratio = (this.MP.rx2 - this.MP.rx1) / (this.MP.orx2 - this.MP.orx1)) > this.featureZoomRatio) {
            return;
        }
        this.clearNeedRefresh();
        if (this.MP == null) {
            return;
        }
        Layer lay = this.getLayer();
        Line lin = this.line.copy();
        boolean lay1d = lay != null && lay.pf instanceof DataFile && lay.typeClass == 1;
        boolean lay2d = lay != null && lay.pf instanceof DataFile && lay.typeClass == 2;
        String tag = "";
        if (this.text != null && this.text.length() != 0) {
            tag = this.text;
        } else if (this.name != null) {
            tag = this.name;
        }
        if ((this.type & 0x8000) != 0 && lay != null && lay.ndata > 0) {
            try {
                this.y = lay.getNearestYValue(this.x);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        if (lay != null && this.dt >= 0.0) {
            double startAdj = lay.pf.getStart();
            double tmpVal = lay.getPosAtTime(this.t);
            tmpVal += startAdj;
            this.timeAtTop = lay.getPosAtTime(this.t - this.dt / 2.0);
            this.timeAtTop += startAdj;
            double tmpDelta = this.dt;
            if (lay1d && this.MP.xvy) {
                this.x = tmpVal;
                this.dx = tmpDelta;
            } else {
                this.y = tmpVal;
                this.dy = tmpDelta;
            }
        }
        if (this.anchor == 3) {
            ix = (int)this.x;
            iy = (int)this.y;
        } else if (this.anchor == 2) {
            ix = (int)((double)this.MP.ix21 * (this.x / 100.0));
            iy = (int)((double)this.MP.iy21 * (this.y / 100.0));
        } else {
            if (this.MP.view == 14) {
                double effectiveX = this.x;
                if (this.dx == 0.0 && this.dy == 0.0) {
                    int iy22;
                    int iy12;
                    int ix22;
                    int ix12;
                    if (this.x < this.MP.rx1 && this.x + (double)MPlot.LONGITUDE_RANGE < this.MP.rx2) {
                        effectiveX += (double)MPlot.LONGITUDE_RANGE;
                    }
                    this.MP.getPoint(effectiveX, this.y, this.z, this.pix);
                    int ix3 = this.pix.x;
                    int iy3 = this.pix.y;
                    if (this.isIconAndTextOnly(this.line)) {
                        Symbol.IconSymbol icon = (Symbol.IconSymbol)this.line.getSymbol();
                        int halfWidthPixels = icon.getIconWidth() / 2;
                        int halfHeightPixels = icon.getIconHeight() / 2;
                        ix12 = ix3 - halfWidthPixels;
                        ix22 = ix3 + halfWidthPixels;
                        iy12 = iy3 - halfHeightPixels;
                        iy22 = iy3 + halfHeightPixels;
                    } else {
                        ix12 = ix22 = ix3;
                        iy12 = iy22 = iy3;
                    }
                    this.visible = this.checkRangeAndDrawFeature(lay, lin, tag, lay1d, ix3, ix12, ix22, iy3, iy12, iy22);
                    return;
                }
                double leftPoint = this.x - this.dx / 2.0;
                double rightPoint = this.x + this.dx / 2.0;
                double p = 1.0E-4;
                if (leftPoint > this.MP.orx1 && rightPoint < this.MP.orx2) {
                    this.getFeatureBoundingPointsAndDraw(lay, lin, tag, lay1d, effectiveX, true);
                } else if (leftPoint + (double)MPlot.LONGITUDE_RANGE > this.MP.orx1 && rightPoint + (double)MPlot.LONGITUDE_RANGE < this.MP.orx2) {
                    this.getFeatureBoundingPointsAndDraw(lay, lin, tag, lay1d, effectiveX += (double)MPlot.LONGITUDE_RANGE, true);
                } else if (leftPoint + (double)MPlot.LONGITUDE_RANGE < this.MP.orx2 && rightPoint > this.MP.orx1) {
                    this.getFeatureBoundingPointsAndDraw(lay, lin, tag, lay1d, this.x + p, false);
                    this.getFeatureBoundingPointsAndDraw(lay, lin, tag, lay1d, this.x + (double)MPlot.LONGITUDE_RANGE - p, true);
                } else if (leftPoint + (double)(2 * MPlot.LONGITUDE_RANGE) < this.MP.orx2 && rightPoint + (double)MPlot.LONGITUDE_RANGE > this.MP.orx1) {
                    this.getFeatureBoundingPointsAndDraw(lay, lin, tag, lay1d, this.x + (double)MPlot.LONGITUDE_RANGE, false);
                    this.getFeatureBoundingPointsAndDraw(lay, lin, tag, lay1d, this.x + (double)(2 * MPlot.LONGITUDE_RANGE), true);
                }
                return;
            }
            this.MP.getPoint(this.x, this.y, this.z, this.pix);
            ix = this.pix.x;
            iy = this.pix.y;
        }
        if (this.dx == 0.0 && this.dy == 0.0) {
            if (this.isIconAndTextOnly(this.line)) {
                Symbol.IconSymbol icon = (Symbol.IconSymbol)this.line.getSymbol();
                int halfWidthPixels = icon.getIconWidth() / 2;
                int halfHeightPixels = icon.getIconHeight() / 2;
                ix1 = ix - halfWidthPixels;
                ix2 = ix + halfWidthPixels;
                iy1 = iy - halfHeightPixels;
                iy2 = iy + halfHeightPixels;
            } else {
                ix1 = ix2 = ix;
                iy1 = iy2 = iy;
            }
        } else {
            this.MP.getPoint(this.x - this.dx / 2.0, this.y - this.dy / 2.0, this.z - this.dz / 2.0, this.pix);
            ix1 = this.pix.x;
            iy1 = this.pix.y;
            this.MP.getPoint(this.x + this.dx / 2.0, this.y + this.dy / 2.0, this.z + this.dz / 2.0, this.pix);
            ix2 = this.pix.x;
            iy2 = this.pix.y;
            if (this.MP.view == 13) {
                boolean oneVisible;
                boolean visXY = ix != 0 || iy != 0;
                boolean visXY1 = ix1 != 0 || iy1 != 0;
                boolean visXY2 = ix2 != 0 || iy2 != 0;
                boolean bl = oneVisible = visXY || visXY1 || visXY2;
                if (oneVisible) {
                    this.MP.tpix.flags = 64;
                    if (!visXY) {
                        this.MP.getPoint(this.x, this.y, this.z, this.pix);
                        ix = this.pix.x;
                        iy = this.pix.y;
                    }
                    if (!visXY1) {
                        this.MP.getPoint(this.x - this.dx / 2.0, this.y - this.dy / 2.0, this.z - this.dz / 2.0, this.pix);
                        ix1 = this.pix.x;
                        iy1 = this.pix.y;
                    }
                    if (!visXY2) {
                        this.MP.getPoint(this.x + this.dx / 2.0, this.y + this.dy / 2.0, this.z + this.dz / 2.0, this.pix);
                        ix2 = this.pix.x;
                        iy2 = this.pix.y;
                    }
                }
                this.MP.tpix.flags = 1;
            }
            if (ix2 < ix1) {
                int i = ix1;
                ix1 = ix2;
                ix2 = i;
            }
            if (iy2 < iy1) {
                int i = iy1;
                iy1 = iy2;
                iy2 = i;
            }
        }
        this.visible = this.checkRangeAndDrawFeature(lay, lin, tag, lay1d, ix, ix1, ix2, iy, iy1, iy2);
    }

    private boolean isIconAndTextOnly(Line lineCopy) {
        return (this.type & 0x20001) == 131073 && (this.type & 0x4021F01) == this.type && lineCopy != null && lineCopy.getSymbol() instanceof Symbol.IconSymbol;
    }

    boolean isVisible() {
        return this.visible;
    }

    private void getFeatureBoundingPointsAndDraw(Layer lay, Line lin, String tag, boolean lay1d, double effectiveX, boolean rangeAdjust) {
        int i;
        this.MP.getPoint(effectiveX, this.y, this.z, this.pix, rangeAdjust);
        int ix = this.pix.x;
        int iy = this.pix.y;
        this.MP.getPoint(effectiveX - this.dx / 2.0, this.y - this.dy / 2.0, this.z - this.dz / 2.0, this.pix, rangeAdjust);
        int ix1 = this.pix.x;
        int iy1 = this.pix.y;
        this.MP.getPoint(effectiveX + this.dx / 2.0, this.y + this.dy / 2.0, this.z + this.dz / 2.0, this.pix, rangeAdjust);
        int ix2 = this.pix.x;
        int iy2 = this.pix.y;
        if (ix2 < ix1) {
            i = ix1;
            ix1 = ix2;
            ix2 = i;
        }
        if (iy2 < iy1) {
            i = iy1;
            iy1 = iy2;
            iy2 = i;
        }
        this.visible = this.checkRangeAndDrawFeature(lay, lin, tag, lay1d, ix, ix1, ix2, iy, iy1, iy2);
    }

    private boolean checkRangeAndDrawFeature(Layer lay, Line lin, String tag, boolean lay1d, int ix, int ix1, int ix2, int iy, int iy1, int iy2) {
        boolean yok;
        boolean xok;
        boolean bl = this.anchor == 1 ? ix2 >= this.MP.ix1 && ix1 <= this.MP.ix2 : (xok = true);
        boolean bl2 = this.anchor == 1 ? iy2 >= this.MP.iy1 && iy1 <= this.MP.iy2 : (yok = true);
        if (this.isType(128)) {
            int i;
            double len = Math.max(this.semiMajor, this.semiMinor);
            double radius = 8.983152841195214E-6 * len;
            this.MP.getPoint(this.x - radius, this.y - radius, this.z - this.dz / 2.0, this.pix);
            int ex1 = this.pix.x;
            int ey1 = this.pix.y;
            this.MP.getPoint(this.x + radius, this.y + radius, this.z + this.dz / 2.0, this.pix);
            int ex2 = this.pix.x;
            int ey2 = this.pix.y;
            if (ex2 < ex1) {
                i = ex1;
                ex1 = ex2;
                ex2 = i;
            }
            if (ey2 < ey1) {
                i = ey1;
                ey1 = ey2;
                ey2 = i;
            }
            xok = xok || ex2 >= this.MP.ix1 && ex1 <= this.MP.ix2;
            boolean bl3 = yok = yok || ey2 >= this.MP.iy1 && ey1 <= this.MP.iy2;
        }
        if (this.isType(32)) {
            MPoint[] minMax = this.calcCircleMinMaxPoints();
            int cx1 = minMax[0].x;
            int cy1 = minMax[0].y;
            int cx2 = minMax[1].x;
            int cy2 = minMax[1].y;
            xok = xok || cx2 >= this.MP.ix1 && cx1 <= this.MP.ix2;
            boolean bl4 = yok = yok || cy2 >= this.MP.iy1 && cy1 <= this.MP.iy2;
        }
        if (!xok && !this.isType(0x800004)) {
            return false;
        }
        if (!yok && !this.isType(0x100000A)) {
            return false;
        }
        if (this.dt >= 0.0) {
            double max;
            double min = lay1d ? this.MP.orx1 : this.MP.ory1;
            double d = max = lay1d ? this.MP.orx2 : this.MP.ory2;
            if (this.timeAtTop < min || this.timeAtTop > max) {
                return false;
            }
        }
        Graphics gc = this.MP.gc;
        Graphics gt = this.MP.gc;
        lin.updateGraphics(gc);
        if ((this.type & 0x40000) != 0) {
            gc.setXORMode(this.MP.theme.cfg);
            gt.setXORMode(this.MP.theme.cfg);
        }
        if ((this.type & 0x800000) != 0 && yok) {
            gc.setColor(this.line.getFillColor());
            gc.fillRect(this.MP.ix1, iy1 + 1, this.MP.ix2 - 2, iy2 - iy1 - 1);
            gc.setColor(this.line.getColor());
        }
        if ((this.type & 0x1000000) != 0 && xok) {
            gc.setColor(this.line.getFillColor());
            gc.fillRect(ix1 + 1, this.MP.iy1, ix2 - ix1 - 1, this.MP.iy2 - 2);
            gc.setColor(this.line.getColor());
        }
        if (this.isType(4) && yok) {
            gc.drawLine(this.MP.ix1, iy1, this.MP.ix2 - 2, iy1);
            if (iy2 != iy1) {
                gc.drawLine(this.MP.ix1, iy2, this.MP.ix2 - 2, iy2);
            }
            if ((this.type & 0x4000) != 0) {
                if ((this.type & 0x100) != 0) {
                    gt.drawString(tag, this.MP.ix1, iy);
                }
                if ((this.type & 0x200) != 0) {
                    gt.drawString(tag, this.MP.ix2 - this.MP.tw * (1 + tag.length()), iy);
                }
            } else {
                if ((this.type & 0x100) != 0) {
                    gt.drawString(tag, this.MP.ix1 - this.MP.tw * (1 + tag.length()), iy);
                }
                if ((this.type & 0x200) != 0) {
                    gt.drawString(tag, this.MP.ix2 + this.MP.tw, iy);
                }
            }
        }
        if (this.isType(8) && xok) {
            gc.drawLine(ix1, this.MP.iy1, ix1, this.MP.iy2 - 2);
            if (ix2 != ix1) {
                gc.drawLine(ix2, this.MP.iy1, ix2, this.MP.iy2 - 2);
            }
            int iix = ix;
            if (this.dx > 0.0) {
                iix = ix - this.MP.tw * tag.length() / 2;
            }
            if ((this.type & 0x4000) != 0) {
                if ((this.type & 0x400) != 0) {
                    gt.drawString(tag, iix, this.MP.iy1 + this.MP.th - 2);
                }
                if ((this.type & 0x800) != 0) {
                    gt.drawString(tag, iix, this.MP.iy2);
                }
            } else {
                if ((this.type & 0x400) != 0) {
                    gt.drawString(tag, iix, this.MP.iy1 - 5);
                }
                if ((this.type & 0x800) != 0) {
                    gt.drawString(tag, iix, this.MP.iy2 + this.MP.th);
                }
            }
        }
        if (xok && yok) {
            int idx = ix2 - ix1;
            int idy = iy2 - iy1;
            int idc = Math.max(idx, idy);
            int radius = idc / 2;
            if ((this.type & 0x100000) != 0) {
                gc.setColor(this.line.getFillColor());
                if ((this.type & 0x10) != 0) {
                    gc.fillRect(ix1, iy1, idx, idy);
                }
                if ((this.type & 0x20) != 0) {
                    gc.fillOval(ix - radius, iy - radius, idc, idc);
                }
                if ((this.type & 0x40) != 0) {
                    gc.fillOval(ix1, iy1, idx, idy);
                }
                gc.setColor(this.line.getColor());
            }
            if ((this.type & 0x10) != 0) {
                gc.drawRect(ix1, iy1, idx, idy);
            }
            if ((this.type & 0x20) != 0) {
                gc.drawOval(ix - radius, iy - radius, idc, idc);
            }
            if ((this.type & 0x40) != 0) {
                gc.drawOval(ix1, iy1, idx, idy);
            }
            if ((this.type & 0x80000) != 0) {
                this.drawTriangle(ix, iy, (int)this.dx, gc);
            }
            if ((this.type & 0x80) != 0) {
                this.MP.drawEllipse(this.x, this.y, this.z, this.semiMajor, this.semiMinor, 90.0 - this.tilt, -1, lin, true);
            }
            if ((this.type & 1) != 0) {
                lin.getSymbol().draw(ix, iy, gc);
            }
            if ((this.type & 0x10000) != 0) {
                gc.drawOval(ix - 2, iy - 2, 4, 4);
            }
            if ((this.type & 0x20000) != 0) {
                this.drawText(gc, tag, ix, ix1, ix2, iy, iy1, iy2);
            }
            if ((this.type & 0x2000000) != 0 && ix < ix2 && ix >= ix2 - ix1 - 1) {
                if (this.dx * this.dy >= 0.0) {
                    gc.drawLine(ix1, iy1, ix2, iy2);
                } else {
                    gc.drawLine(ix2, iy1, ix1, iy2);
                }
            }
        }
        if ((this.type & 2) != 0 && xok && lay != null) {
            int npts = lay.drawDataSegment(lin, this.x - this.dx / 2.0, this.x + this.dx / 2.0);
            if (this.needWarnIfFeatureNotDrawn && npts == -1) {
                if (lay.getClass() != Layer.class) {
                    Shell.warning("Features of TYPE=|DATA| are not supported by " + lay.getClass().getSimpleName() + ". Feature " + this.getName() + " not being drawn on " + lay.getName() + ".");
                } else {
                    Shell.warning("Feature " + this.getName() + " of TYPE=|DATA| not being drawn until layer present.");
                }
                this.needWarnIfFeatureNotDrawn = false;
            }
        }
        this.ix1Last = ix1;
        this.ix2Last = ix2;
        this.iy1Last = iy1;
        this.iy2Last = iy2;
        gt.setColor(this.MP.theme.cfg);
        if ((this.type & 0x40000) != 0) {
            gc.setPaintMode();
            gt.setPaintMode();
        }
        return true;
    }

    private void drawText(Graphics gc, String tag, int ix, int ix1, int ix2, int iy, int iy1, int iy2) {
        int posy;
        int posx;
        double ratio;
        if (this.textZoomRatio != 1.0 && (ratio = (this.MP.rx2 - this.MP.rx1) / (this.MP.orx2 - this.MP.orx1)) > this.textZoomRatio) {
            return;
        }
        String[] tagLines = null;
        boolean multiLineTag = false;
        if (tag.contains("\n")) {
            tagLines = tag.split("\n");
            tag = Arrays.asList(tagLines).stream().max(Comparator.comparingInt(String::length)).get();
            multiLineTag = true;
        }
        ix1 = Math.max(ix1, this.MP.ix1);
        ix2 = Math.min(ix2, this.MP.ix2);
        iy1 = Math.max(iy1, this.MP.iy1);
        iy2 = Math.min(iy2, this.MP.iy2);
        int CENTER_OFFSET = 2;
        int centerx = ix1 + (ix2 - ix1) / 2 + 2;
        int centery = iy1 + (iy2 - iy1) / 2 - 2;
        int charWidth = this.MP.tw;
        int textWidth = charWidth * (1 + tag.length());
        int textHeight = this.MP.th;
        if ((this.type & 0x100) != 0) {
            posx = ix1 - textWidth;
            posy = centery + textHeight / 2;
            if (!multiLineTag) {
                gc.drawString(tag, posx, posy);
            } else {
                this.drawMultiLineTag(gc, tagLines, posx, posy -= (tagLines.length - 1) / 2 * textHeight, textHeight, tag.length(), true);
            }
        }
        if ((this.type & 0x200) != 0) {
            posx = ix2 + charWidth;
            posy = centery + textHeight / 2;
            if (!multiLineTag) {
                gc.drawString(tag, posx, posy);
            } else {
                this.drawMultiLineTag(gc, tagLines, posx, posy -= (tagLines.length - 1) / 2 * textHeight, textHeight, tag.length(), false);
            }
        }
        if ((this.type & 0x400) != 0) {
            posy = iy1 - 2;
            if (!multiLineTag) {
                posx = centerx - textWidth / 2;
                gc.drawString(tag, posx, posy);
            } else {
                posx = centerx - tagLines[tagLines.length - 1].length() * charWidth / 2;
                this.drawMultiLineTag(gc, tagLines, posx, posy -= (tagLines.length - 1) * textHeight, textHeight, tag.length(), false);
            }
        }
        if ((this.type & 0x800) != 0) {
            posy = iy2 + textHeight;
            if (!multiLineTag) {
                posx = centerx - textWidth / 2;
                gc.drawString(tag, posx, posy);
            } else {
                posx = centerx - tagLines[0].length() * charWidth / 2;
                this.drawMultiLineTag(gc, tagLines, posx, posy, textHeight, tag.length(), false);
            }
        }
        if ((this.type & 0x1000) != 0) {
            posx = centerx - textWidth / 2;
            posy = centery + textHeight / 2;
            if (!multiLineTag) {
                gc.drawString(tag, posx, posy);
            } else {
                posx = Math.max(ix1, posx);
                this.drawMultiLineTag(gc, tagLines, posx, posy -= (tagLines.length - 1) / 2 * textHeight, textHeight, tag.length(), false);
            }
        }
        if ((this.type & 0x4000000) != 0) {
            this.drawCustomTagText(gc, tag, multiLineTag, tagLines, ix, ix1, ix2, iy, iy1, iy2);
        }
        if ((this.type & 0x800) == 0 && (this.type & 0x400) == 0 && (this.type & 0x200) == 0 && (this.type & 0x100) == 0 && (this.type & 0x1000) == 0 && (this.type & 0x4000000) == 0) {
            posx = ix + 2;
            posy = iy - 2;
            if (!multiLineTag) {
                gc.drawString(tag, posx, posy);
            } else {
                this.drawMultiLineTag(gc, tagLines, posx, posy -= (tagLines.length - 1) / 2 * textHeight, textHeight, tag.length(), false);
            }
        }
    }

    private void drawMultiLineTag(Graphics gc, String[] tagLines, int posx, int posy, int textHeight, int longestLine, boolean leftPad) {
        for (String line : tagLines) {
            if (leftPad) {
                gc.drawString(StringUtil.padLeft(line, longestLine), posx, posy);
            } else {
                gc.drawString(line, posx, posy);
            }
            posy += textHeight;
        }
    }

    private void drawCustomTagText(Graphics gc, String tag, boolean multilineTag, String[] tagLines, int ix, int ix1, int ix2, int iy, int iy1, int iy2) {
        int posx = this.customTagPixelX;
        int posy = this.customTagPixelY;
        switch (this.customTagReference) {
            case TL: {
                posx += ix1;
                posy += iy1;
                break;
            }
            case TR: {
                posx += ix2;
                posy += iy1;
                break;
            }
            case BL: {
                posx += ix1;
                posy += iy2;
                break;
            }
            case BR: {
                posx += ix2;
                posy += iy2;
                break;
            }
            case CTR: {
                posx += ix;
                posy += iy;
            }
        }
        if (!multilineTag) {
            gc.drawString(tag, posx, posy);
        } else {
            this.drawMultiLineTag(gc, tagLines, posx, posy, this.MP.th, tag.length(), false);
        }
    }

    private void drawTriangle(int ix, int iy, int size, Graphics gc) {
        int[] xpoints = new int[4];
        int[] ypoints = new int[4];
        xpoints[0] = ix - size;
        ypoints[0] = iy;
        xpoints[1] = ix;
        ypoints[1] = iy + size;
        xpoints[2] = ix + size;
        ypoints[2] = iy;
        xpoints[3] = xpoints[0];
        ypoints[3] = ypoints[0];
        gc.fillPolygon(xpoints, ypoints, xpoints.length);
    }

    @Override
    public void refresh() {
        if (this.isEnabled(0)) {
            this.needRefresh = true;
        }
    }

    @Override
    public boolean reset() {
        return false;
    }

    public String getText() {
        return this.text;
    }

    public String getType() {
        return Parser.mask2s(typeList, this.type);
    }

    public String getAnchor() {
        return Parser.get(anchorList, this.anchor);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getT() {
        return this.t;
    }

    public double getDX() {
        return this.dx;
    }

    public double getDY() {
        return this.dy;
    }

    public double getDZ() {
        return this.dz;
    }

    public double getDT() {
        return this.dt;
    }

    public double getMajor() {
        return this.semiMajor;
    }

    public double getSemiMajor() {
        return this.semiMajor;
    }

    public double getMinor() {
        return this.semiMinor;
    }

    public double getSemiMinor() {
        return this.semiMinor;
    }

    public double getTilt() {
        return this.tilt;
    }

    public void setAnchor(String value) {
        this.setAnchor(Parser.find(anchorList, value, 1));
    }

    public void setName(String value) {
        if (value == null || value.length() == 0 || value.equals(this.name)) {
            return;
        }
        value = value.toUpperCase();
        if (this.MP != null && this.name != null) {
            this.MP.features.rename(this.name, value);
        }
        this.name = value;
        this.refresh();
    }

    public void setText(String value) {
        if (StringUtil.isNull(value)) {
            value = null;
        }
        if (!Util.equals(this.text, value)) {
            this.text = value;
            this.refresh();
        }
    }

    @Override
    public void setEnable(int value) {
        boolean nowDisplayed;
        if (this.enable == value) {
            return;
        }
        boolean wasDisplayed = (this.enable & 1) != 0;
        this.enable = value;
        this.refresh();
        boolean bl = nowDisplayed = (this.enable & 1) != 0;
        if (wasDisplayed && !nowDisplayed) {
            this.needRefresh = true;
        }
    }

    @InternalUseOnly
    public void setCustomTag(CustomTagReference reference, int xPixOffset, int yPixOffset) {
        this.customTagReference = reference;
        this.customTagPixelX = xPixOffset;
        this.customTagPixelY = yPixOffset;
    }

    @InternalUseOnly
    public void setCustomTagXPix(int xPixOffset) {
        this.customTagPixelX = xPixOffset;
    }

    @InternalUseOnly
    public void setCustomTagYPix(int yPixOffset) {
        this.customTagPixelY = yPixOffset;
    }

    @InternalUseOnly
    public void setCustomTagRef(String reference) {
        switch (reference) {
            case "TL": {
                this.customTagReference = CustomTagReference.TL;
                break;
            }
            case "BL": {
                this.customTagReference = CustomTagReference.BL;
                break;
            }
            case "BR": {
                this.customTagReference = CustomTagReference.BR;
                break;
            }
            case "CTR": {
                this.customTagReference = CustomTagReference.CTR;
                break;
            }
            default: {
                this.customTagReference = CustomTagReference.TR;
            }
        }
    }

    @Override
    public void setEnable(String value) {
        this.setEnable(Parser.mask("Global,Labels,BStore,Thin,Base,Zoom,FastBase,FastZoom", value, this.enable));
    }

    @Override
    public int getEnable() {
        return this.enable;
    }

    @Override
    public String getEnableString() {
        return Parser.mask2s("Global,Labels,BStore,Thin,Base,Zoom,FastBase,FastZoom", this.enable);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Line getLine() {
        return this.line;
    }

    @Override
    public MPlot getMPlot() {
        return this.MP;
    }

    @Override
    public Object getNextLink() {
        return this.getLine();
    }

    @Override
    public Object getPrevLink() {
        return this.getMPlot();
    }

    @Override
    public void findRange() {
    }

    @Override
    public double getXMin() {
        if (this.MP == null || this.MP.view != 15) {
            return this.x - this.getMaxDX() / 2.0;
        }
        return Math.min(-Math.abs(this.x + this.getMaxDX() / 2.0), this.x - this.getMaxDX() / 2.0) * Layer.threeDGraphMarginFactor;
    }

    @Override
    public double getXMax() {
        if (this.MP == null || this.MP.view != 15) {
            return this.x + this.getMaxDX() / 2.0;
        }
        return Math.max(Math.abs(this.x - this.getMaxDX() / 2.0), this.x + this.getMaxDX() / 2.0) * Layer.threeDGraphMarginFactor;
    }

    @Override
    public double getYMin() {
        if (this.MP == null || this.MP.view != 15) {
            return this.y - this.getMaxDY() / 2.0;
        }
        return Math.min(-Math.abs(this.y + this.getMaxDY() / 2.0), this.y - this.getMaxDY() / 2.0) * Layer.threeDGraphMarginFactor;
    }

    @Override
    public double getYMax() {
        if (this.MP == null || this.MP.view != 15) {
            return this.y + this.getMaxDY() / 2.0;
        }
        return Math.max(Math.abs(this.y - this.getMaxDY() / 2.0), this.y + this.getMaxDY() / 2.0) * Layer.threeDGraphMarginFactor;
    }

    @Override
    public double getZMin() {
        if (this.MP == null || this.MP.view != 15) {
            return this.z - this.dz / 2.0;
        }
        return Math.min(-Math.abs(this.z + this.dz / 2.0), this.z - this.dz / 2.0) * Layer.threeDGraphMarginFactor;
    }

    @Override
    public double getZMax() {
        if (this.MP == null || this.MP.view != 15) {
            return this.z + this.dz / 2.0;
        }
        return Math.max(Math.abs(this.z - this.dz / 2.0), this.z + this.dz / 2.0) * Layer.threeDGraphMarginFactor;
    }

    private double getMaxDX() {
        double maxDX = this.dx;
        if (this.isType(32)) {
            double diameter = Math.max(this.dx, this.dy);
            double d = maxDX = diameter > maxDX ? diameter : maxDX;
        }
        if (this.isType(128)) {
            double len = Math.max(this.semiMajor, this.semiMinor);
            double diameter = 8.983152841195214E-6 * len * 2.0;
            maxDX = diameter > maxDX ? diameter : maxDX;
        }
        return maxDX;
    }

    private double getMaxDY() {
        double maxDY = this.dy;
        if (this.isType(32)) {
            double diameter = Math.max(this.dx, this.dy);
            double d = maxDY = diameter > maxDY ? diameter : maxDY;
        }
        if (this.isType(128)) {
            double len = Math.max(this.semiMajor, this.semiMinor);
            double diameter = 8.983152841195214E-6 * len * 2.0;
            maxDY = diameter > maxDY ? diameter : maxDY;
        }
        return maxDY;
    }

    public void setType(String value) {
        this.setType(Parser.mask(typeList, value, this.type));
    }

    public void setType(int val) {
        if (this.type != val) {
            this.type = val;
            this.refresh();
        }
    }

    public void setAnchor(int val) {
        if (this.anchor != val) {
            this.anchor = val;
            this.refresh();
        }
    }

    public void setX(double val) {
        if (this.x != val) {
            this.x = val;
            this.refresh();
        }
    }

    public void setY(double val) {
        if (this.y != val) {
            this.y = val;
            this.refresh();
        }
    }

    public void setZ(double val) {
        if (this.z != val) {
            this.z = val;
            this.refresh();
        }
    }

    public void setT(double val) {
        if (this.t != val) {
            this.t = val;
            this.refresh();
        }
    }

    public void setDX(double val) {
        if (this.dx != val) {
            this.dx = val;
            this.refresh();
        }
    }

    public void setDY(double val) {
        if (this.dy != val) {
            this.dy = val;
            this.refresh();
        }
    }

    public void setDZ(double val) {
        if (this.dz != val) {
            this.dz = val;
            this.refresh();
        }
    }

    public void setDT(double val) {
        if (this.dt != val) {
            this.dt = val;
            this.refresh();
        }
    }

    public void setXMinMax(double min, double max) {
        if (min > max) {
            double temp = min;
            min = max;
            max = temp;
        }
        if (this.dx != max - min || this.x != min + (max - min) / 2.0) {
            this.dx = max - min;
            this.x = min + this.dx / 2.0;
            this.refresh();
        }
    }

    public void setYMinMax(double min, double max) {
        if (min > max) {
            double temp = min;
            min = max;
            max = temp;
        }
        if (this.dy != max - min || this.y != min + (max - min) / 2.0) {
            this.dy = max - min;
            this.y = min + this.dy / 2.0;
            this.refresh();
        }
    }

    public void setTMinMax(double min, double max) {
        if (min > max) {
            double temp = min;
            min = max;
            max = temp;
        }
        if (this.dt != max - min || this.t != min + (max - min) / 2.0) {
            this.dt = max - min;
            this.t = min + this.dt / 2.0;
            this.refresh();
        }
    }

    public double getTMin() {
        return this.t - this.dt / 2.0;
    }

    public double getTMax() {
        return this.t + this.dt / 2.0;
    }

    public void setMajor(double value) {
        this.setSemiMajor(value);
    }

    public void setSemiMajor(double value) {
        if (this.semiMajor != value) {
            this.semiMajor = value;
            this.refresh();
        }
    }

    public void setMinor(double value) {
        this.setSemiMinor(value);
    }

    public void setSemiMinor(double value) {
        if (this.semiMinor != value) {
            this.semiMinor = value;
            this.refresh();
        }
    }

    public void setTilt(double value) {
        if (this.tilt != value) {
            this.tilt = value;
            this.refresh();
        }
    }

    @InternalUseOnly
    public void setTextZoomRatio(double zoomRatio) {
        if (this.textZoomRatio != zoomRatio) {
            this.textZoomRatio = zoomRatio;
        }
    }

    @InternalUseOnly
    public void setFeatureZoomRatio(double zoomRatio) {
        if (this.featureZoomRatio != zoomRatio) {
            this.featureZoomRatio = zoomRatio;
        }
    }

    public void delete() {
        if (this.name != null) {
            this.MP.removeFeature(this.name);
        } else if (this.layer != null) {
            this.layer.feature = null;
        }
    }

    @Override
    public boolean isEnabled(int mode) {
        if ((this.enable & 1) == 0) {
            return false;
        }
        if (mode == 0) {
            return true;
        }
        return mode > 0 ^ (this.enable & 4) != 0;
    }

    public void configure() {
        String menuItems = "Rename,Delete,Enable,Type,Line,Anchor,Dialog,Query";
        if (this.metadata != null) {
            menuItems = menuItems + ",Metadata";
        }
        new GMenu(this.MP, "Feature.cfg", menuItems, 0, 0, this);
    }

    @Override
    public int processMessage(Message msg) {
        String text = Convert.o2s(msg.data);
        if (msg.name.equals("FEATURE.CFG")) {
            if (text.equals("RENAME")) {
                new GPrompt(this.MP, "Name", this.name, 0, (MessageHandler)this);
            } else if (text.equals("QUERY")) {
                new GQuery(this.MP, "Feature " + this.name, this, 0, (MessageHandler)this);
            } else if (text.equals("ENABLE")) {
                new GMenu(this.MP, "Enable", "Global,Labels,BStore,Thin,Base,Zoom,FastBase,FastZoom", this.enable, 1024, this);
            } else if (text.equals("TYPE")) {
                new GMenu(this.MP, "Type", typeList, this.type, 1024, this);
            } else if (text.equals("ANCHOR")) {
                new GMenu(this.MP, "Anchor", anchorList, this.anchor, 0, this);
            } else if (text.equals("METADATA")) {
                new GQuery((Object)this.MP, "Feature " + this.name, this, "Metadata", 0, (MessageHandler)this);
            } else if (text.equals("DELETE")) {
                this.MP.removeFeature(this.name);
            } else if (text.equals("LINE")) {
                this.line.configure();
            } else if (text.equals("DIALOG")) {
                this.dialog();
            } else {
                Shell.warning("FEATURE: Unknown message name=" + msg.getName() + " data=" + msg.getData());
            }
        } else if (msg.name.equals("ENABLE")) {
            this.enable = msg.info;
            this.refresh();
        } else if (msg.name.equals("TYPE")) {
            this.type = msg.info;
            this.refresh();
        } else if (msg.name.equals("NAME")) {
            this.setName(text);
        } else if (msg.name.equals("RENAME")) {
            this.setName(text);
        } else if (msg.name.equals("NEWNAME")) {
            this.setName(text);
        } else if (msg.name.equals("FEATURE.DIALOG")) {
            Table tbl = (Table)msg.data;
            String action = tbl.getS("DIALOG.VALUE");
            this.setX(tbl.getD("X.VALUE"));
            this.setY(tbl.getD("Y.VALUE"));
            this.setZ(tbl.getD("Z.VALUE"));
            this.setText(tbl.getString("TEXT.VALUE"));
            if (action.equals("ZOOMTO")) {
                double zr = tbl.getD("ZOOMRANGE.VALUE");
                double[] zoom = new double[]{this.x - zr, this.x + zr, this.y - zr, this.y + zr};
                this.MP.mh.processMessage(new Message("ZOOM", 0, zoom));
            }
        } else {
            Shell.warning("FEATURE: Unknown message name=" + msg.getName() + " data=" + msg.getData());
            return 0;
        }
        return 1;
    }

    public void dialog() {
        String sticky = "Apply,ZoomTo";
        String actions = "Submit,Cancel," + sticky;
        String ptext = this.text == null ? "null" : this.text;
        boolean geo = this.MP.view == 11 || this.MP.view == 14 || this.MP.view == 12 || this.MP.view == 13;
        GDialog gd = new GDialog(this.MP, "Feature.Dialog", 250, 75, actions, sticky, 0, this);
        GPrompt gl = new GPrompt(gd, "Text", ptext, 16, (MessageHandler)this);
        GValue gx = new GValue((Object)gd, "X  ", this.x, this.MP.orx1, this.MP.orx2, 1.0, 16, (MessageHandler)this);
        GValue gy = new GValue((Object)gd, "Y  ", this.y, this.MP.ory1, this.MP.ory2, 1.0, 16, (MessageHandler)this);
        GValue gz = new GValue((Object)gd, "Z  ", this.z, this.MP.orz1, this.MP.orz2, 1.0, 16, (MessageHandler)this);
        double zr = Math.min(Math.abs(this.MP.orx2 - this.MP.orx1), Math.abs(this.MP.ory2 - this.MP.ory1));
        GValue gr = new GValue((Object)gd, "ZoomRange", zr / 10.0, zr / 100.0, zr, zr / 100.0, 16, (MessageHandler)this);
        if (geo) {
            gx.setTitle("Lon");
            gy.setTitle("Lat");
            gz.setTitle("Alt");
        }
        gd.resize(1);
    }

    @Override
    public void setMPlot(MPlot plot2) {
        this.MP = plot2;
        this.line.setPlot(plot2);
        if (this.hasGroup()) {
            plot2.addFeatureToGroup(this);
        }
    }

    public void setPlot(MPlot plot2) {
        this.setMPlot(plot2);
    }

    public void setLayer(String layerName) {
        if (this.MP == null || this.MP.layers == null || this.MP.layers.size() == 0) {
            return;
        }
        Layer lay = (Layer)this.MP.layers.get(layerName);
        if (lay != null) {
            this.setLayer(lay);
        }
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
        this.line.setParent(layer);
    }

    public MPlot getPlot() {
        return this.getMPlot();
    }

    public Layer getLayer() {
        Layer result = this.layer;
        if (result == null && this.MP != null) {
            result = this.MP.getBaseLayer();
        }
        return result;
    }

    @Override
    public Table toTable() {
        Table ft = new Table();
        Color color = this.line.getColor();
        ft.put("NAME", (Object)this.name);
        ft.put("TYPE", (Object)this.getType());
        if (this.isType(1)) {
            ft.put("SYMBOL", (Object)this.line.getSymbol().getName());
        }
        if (this.anchor != 1) {
            ft.put("ANCHOR", (Object)this.getAnchor());
        }
        if (color != null) {
            ft.put("COLOR", (Object)MColor.toString(color));
        }
        if (this.x != 0.0) {
            ft.put("X", this.x);
        }
        if (this.y != 0.0) {
            ft.put("Y", this.y);
        }
        if (this.z != 0.0) {
            ft.put("Z", this.z);
        }
        if (this.t != 0.0) {
            ft.put("T", this.t);
        }
        if (this.dx != 0.0) {
            ft.put("DX", this.dx);
        }
        if (this.dy != 0.0) {
            ft.put("DY", this.dy);
        }
        if (this.dz != 0.0) {
            ft.put("DZ", this.dz);
        }
        if (this.dt != 0.0) {
            ft.put("DT", this.dt);
        }
        if (this.text != null) {
            ft.put("TEXT", (Object)this.text);
        }
        if (this.metadata != null) {
            ft.put("METADATA", this.metadata);
        }
        if (this.group != null) {
            ft.put("GROUP", (Object)this.group);
        }
        return ft;
    }

    public void fromTable(Table t) {
        KeyObject.setKeys(this, t);
    }

    public final boolean isType(int typeOptionMask) {
        if (this.MP != null) {
            if (this.MP.xvy) {
                if ((typeOptionMask & 0x200004) != 0) {
                    typeOptionMask |= 0x200004;
                }
                if ((typeOptionMask & 0x400008) != 0) {
                    typeOptionMask |= 0x400008;
                }
            } else {
                if ((typeOptionMask & 0x200008) != 0) {
                    typeOptionMask |= 0x200008;
                }
                if ((typeOptionMask & 0x400004) != 0) {
                    typeOptionMask |= 0x400004;
                }
            }
        }
        return (this.type & typeOptionMask) != 0;
    }

    @InternalUseOnly
    public void setRef(Object ref) {
    }

    private MPoint[] calcCircleMinMaxPoints() {
        int diffPixelsY;
        int diffPixelsX;
        int pixelsXGTY;
        int i;
        MPoint pixMin = new MPoint();
        MPoint pixMax = new MPoint();
        this.MP.tpix.flags = 64;
        this.MP.getPoint(this.x - this.dx / 2.0, this.y - this.dy / 2.0, this.z - this.dz / 2.0, pixMin);
        this.MP.getPoint(this.x + this.dx / 2.0, this.y + this.dy / 2.0, this.z + this.dz / 2.0, pixMax);
        this.MP.tpix.flags = 1;
        if (pixMax.x < pixMin.x) {
            i = pixMin.x;
            pixMin.x = pixMax.x;
            pixMax.x = i;
        }
        if (pixMax.y < pixMin.y) {
            i = pixMin.y;
            pixMin.y = pixMax.y;
            pixMax.y = i;
        }
        if ((pixelsXGTY = (diffPixelsX = pixMax.x - pixMin.x) - (diffPixelsY = pixMax.y - pixMin.y)) > 0) {
            pixMin.y -= pixelsXGTY;
            pixMax.y += pixelsXGTY;
        } else {
            pixMin.x += pixelsXGTY;
            pixMax.x -= pixelsXGTY;
        }
        MPoint[] minMaxPoints = new MPoint[]{pixMin, pixMax};
        return minMaxPoints;
    }

    @Override
    public boolean isAtPosition(Position pos, int dpx, int dpy) {
        int defDP;
        boolean okY;
        MPoint pixMin = new MPoint();
        MPoint pixMax = new MPoint();
        if (this.getMaxDX() == 0.0 && this.getMaxDY() == 0.0) {
            pixMin.x = pixMax.x = this.pix.x;
            pixMin.y = pixMax.y = this.pix.y;
        } else if (this.isType(32)) {
            MPoint[] minMax = this.calcCircleMinMaxPoints();
            pixMin = minMax[0];
            pixMax = minMax[1];
        } else {
            int i;
            double maxDX = this.getMaxDX();
            double maxDY = this.getMaxDY();
            this.MP.getPoint(this.x - maxDX / 2.0, this.y - maxDY / 2.0, this.z - this.dz / 2.0, pixMin);
            this.MP.getPoint(this.x + maxDX / 2.0, this.y + maxDY / 2.0, this.z + this.dz / 2.0, pixMax);
            if (pixMax.x < pixMin.x) {
                i = pixMin.x;
                pixMin.x = pixMax.x;
                pixMax.x = i;
            }
            if (pixMax.y < pixMin.y) {
                i = pixMin.y;
                pixMin.y = pixMax.y;
                pixMax.y = i;
            }
        }
        MPoint posPix = new MPoint();
        this.MP.getPoint(pos, posPix);
        boolean okX = dpx == -2;
        boolean bl = okY = dpy == -2;
        if (this.isType(58720496)) {
            okX = okX || pixMin.x <= posPix.x && posPix.x <= pixMax.x || this.isType(0x800000);
            okY = okY || pixMin.y <= posPix.y && posPix.y <= pixMax.y || this.isType(0x1000000);
        } else {
            okX = okX || this.isType(4);
            boolean bl2 = okY = okY || this.isType(8);
        }
        if (okX && okY) {
            return true;
        }
        if (dpx == 0 && dpy == 0) {
            return false;
        }
        int n = defDP = (this.type & 1) == 0 ? 4 : this.line.getSymbolSize() / 2;
        if (dpx == -1) {
            dpx = defDP;
        }
        if (dpy == -1) {
            dpy = defDP;
        }
        okX = okX || dpx >= 0 && Math.abs(posPix.x - this.pix.x) < dpx;
        okY = okY || dpy >= 0 && Math.abs(posPix.y - this.pix.y) < dpy;
        return okX && okY;
    }

    boolean isAtPix(MPoint posPix, int dpx, int dpy) {
        int defDP;
        boolean okY;
        MPoint pixMin = new MPoint();
        MPoint pixMax = new MPoint();
        if (this.getMaxDX() == 0.0 && this.getMaxDY() == 0.0) {
            pixMin.x = pixMax.x = this.pix.x;
            pixMin.y = pixMax.y = this.pix.y;
        } else if (this.isType(32)) {
            MPoint[] minMax = this.calcCircleMinMaxPoints();
            pixMin = minMax[0];
            pixMax = minMax[1];
        } else {
            int i;
            double maxDX = this.getMaxDX();
            double maxDY = this.getMaxDY();
            this.MP.getPoint(this.x - maxDX / 2.0, this.y - maxDY / 2.0, this.z - this.dz / 2.0, pixMin);
            this.MP.getPoint(this.x + maxDX / 2.0, this.y + maxDY / 2.0, this.z + this.dz / 2.0, pixMax);
            if (pixMax.x < pixMin.x) {
                i = pixMin.x;
                pixMin.x = pixMax.x;
                pixMax.x = i;
            }
            if (pixMax.y < pixMin.y) {
                i = pixMin.y;
                pixMin.y = pixMax.y;
                pixMax.y = i;
            }
        }
        boolean okX = dpx == -2;
        boolean bl = okY = dpy == -2;
        if (this.isType(58720496)) {
            okX = okX || pixMin.x <= posPix.x && posPix.x <= pixMax.x || this.isType(0x800000);
            okY = okY || pixMin.y <= posPix.y && posPix.y <= pixMax.y || this.isType(0x1000000);
        } else {
            okX = okX || this.isType(4);
            boolean bl2 = okY = okY || this.isType(8);
        }
        if (okX && okY) {
            return true;
        }
        if (dpx == 0 && dpy == 0) {
            return false;
        }
        int n = defDP = (this.type & 1) == 0 ? 4 : this.line.getSymbolSize() / 2;
        if (dpx == -1) {
            dpx = defDP;
        }
        if (dpy == -1) {
            dpy = defDP;
        }
        okX = okX || dpx >= 0 && Math.abs(posPix.x - this.pix.x) < dpx;
        okY = okY || dpy >= 0 && Math.abs(posPix.y - this.pix.y) < dpy;
        return okX && okY;
    }

    public void setBoundsFromTable(Table tblWithOuterBounds) {
        double xmin = tblWithOuterBounds.getD("XMIN.VALUE");
        double xmax = tblWithOuterBounds.getD("XMAX.VALUE");
        double ymin = tblWithOuterBounds.getD("YMIN.VALUE");
        double ymax = tblWithOuterBounds.getD("YMAX.VALUE");
        this.setXMinMax(xmin, xmax);
        this.setYMinMax(ymin, ymax);
    }

    public void setBoundsFromTableTime(Table tblWithOuterBounds) {
        double tmax;
        double tmin;
        if (tblWithOuterBounds.containsKey("XMIN") && (tmin = tblWithOuterBounds.getD("TMIN.VALUE")) != (tmax = tblWithOuterBounds.getD("TMAX.VALUE"))) {
            this.setTMinMax(tmin, tmax);
        }
        this.setBoundsFromTable(tblWithOuterBounds);
    }

    public String getGroup() {
        return this.group;
    }

    public boolean hasGroup() {
        return this.group != null && this.group != "";
    }

    public void setGroup(String group2) {
        if (group2.equals(this.group)) {
            return;
        }
        String oldGroup = this.group;
        this.group = group2;
        if (this.MP != null) {
            if (oldGroup == null || oldGroup.isEmpty()) {
                this.MP.addFeatureToGroup(this);
            } else {
                this.MP.moveFeatureToGroup(oldGroup, this);
            }
        }
    }

    public void setLine(Table tbl) {
        KeyObject.setKeys(this.getLine(), tbl);
    }

    @InternalUseOnly
    public void displayMetaData() {
        new GMenu(this.MP, "Metadata", this.getMetadata().toString(), 0, 0, this);
    }

    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    int[] getPixelXY() {
        return new int[]{this.pix.x, this.pix.y};
    }

    public static void setWarningFeatureNotDrawn(boolean warn) {
        warningFeatureNotDrawn = warn;
    }

    public static boolean isWarningFeatureNotDrawn() {
        return warningFeatureNotDrawn;
    }

    public void setElastic(boolean stretchable) {
        if (stretchable) {
            if (this.MP == null || this.layer != null) {
                Shell.warning("setElestic not allowed on Feature " + this + " Only Features associated with MPlot and not with a layer are eligible to be the Mplot elastic Feature");
            } else {
                if (this.MP.elasticFeature != null) {
                    Shell.warning("Overriding current elastic Feature " + this.MP.elasticFeature + " with Feature " + this);
                }
                this.MP.setElasticFeature(this);
            }
        } else if (this.MP.elasticFeature != null && this.MP.elasticFeature != this) {
            Shell.warning("This Feature is not the MPlot elastic Feature, so deselecting does nothing :" + this);
        } else {
            this.MP.setElasticFeature(null);
        }
    }

    public String toString() {
        return this.toTable().toString();
    }

    public static enum CustomTagReference {
        TR,
        TL,
        BL,
        BR,
        CTR;

    }
}

