/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import nxm.sys.libg.Pix;

public class DPix {
    int max;
    int off;
    int n;
    int flags;
    double[] x;
    double[] y;
    double[] z;
    boolean save;
    double[] sx = new double[2];
    double[] sy = new double[2];
    double[] sz = new double[2];

    public DPix(int maxsize, int flags) {
        this.max = maxsize + 1;
        this.x = new double[this.max];
        this.y = new double[this.max];
        this.z = new double[this.max];
        this.setFlags(flags);
    }

    Pix toPix() {
        int i;
        Pix pix = new Pix(this.max - 1, this.flags);
        for (i = 0; i < this.n; ++i) {
            pix.x[i] = (int)this.x[i];
            pix.y[i] = (int)this.y[i];
            pix.z[i] = (float)this.z[i];
        }
        if (this.save) {
            for (i = 0; i < 2; ++i) {
                pix.sx[i] = (int)this.sx[i];
                pix.sy[i] = (int)this.sy[i];
                pix.sz[i] = (int)this.sz[i];
            }
        }
        pix.n = this.n;
        pix.off = this.off;
        return pix;
    }

    void setX(double[] x) {
        this.x = x;
    }

    void setY(double[] y) {
        this.y = y;
    }

    void setOffset(int offset) {
        this.off = offset;
    }

    int getLengthX() {
        return this.x.length;
    }

    int getLengthY() {
        return this.y.length;
    }

    public int setSize(int npts) {
        if (npts > this.max) {
            this.n = this.max;
            this.off = this.max - 1;
        } else {
            this.n = npts;
            this.off = npts;
        }
        return this.n;
    }

    public void setFlags(int mask) {
        this.flags = mask;
    }

    public void setFlag(int mask) {
        this.flags |= mask;
    }

    public void clrFlag(int mask) {
        this.flags &= ~mask;
    }

    double[] getX() {
        return this.x;
    }

    double[] getY() {
        return this.y;
    }

    int getSize() {
        return this.n;
    }

    int getFlags() {
        return this.flags;
    }

    int getOffset() {
        return this.off;
    }

    public double[] getXYMinMax(int num) {
        double[] r = new double[]{0.0, 0.0, 0.0, 0.0};
        return this.getXYMinMax(r, num);
    }

    public double[] getXYMinMax(double[] ini, int num) {
        double xmin = ini[0];
        double ymin = ini[1];
        double xmax = ini[2];
        double ymax = ini[3];
        for (int i = 0; i < num; ++i) {
            xmax = Math.max(xmax, this.x[i]);
            xmin = Math.min(xmin, this.x[i]);
            ymax = Math.max(ymax, this.y[i]);
            ymin = Math.min(ymin, this.y[i]);
        }
        double[] retVal = new double[]{xmin, ymin, xmax, ymax};
        return retVal;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("Pix: {");
        for (int i = 0; i < this.n; ++i) {
            str.append(" (");
            str.append(this.x[i]);
            str.append(',');
            str.append(this.y[i]);
            str.append(',');
            str.append(this.z[i]);
            str.append(')');
        }
        str.append(" }");
        return str.toString();
    }
}

