/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import nxm.sys.lib.Convert;
import nxm.sys.lib.IOResource;

public class UdpResource
extends IOResource {
    private DatagramSocket dsock;
    private byte[] buffi;
    private byte[] buffo;
    private byte[] hb;
    private DatagramPacket dpacki;
    private DatagramPacket dpacko;
    private String rhost;
    private int port;
    private int rport;
    private InetAddress raddr;
    private int MAXPKTBUF = 65536;
    private int MINPKTSIZE = 128;
    private int woff = 0;
    private int roff = 0;

    @Override
    public boolean exists() {
        return this.dir < 0;
    }

    @Override
    public void setURL(String str) {
        super.setURL(str);
        if (str.startsWith("udp://")) {
            str = str.substring(6);
        } else if (str.startsWith("udp:/")) {
            str = str.substring(5);
        } else if (str.startsWith("udp:")) {
            str = str.substring(4);
        }
        int i = str.indexOf("/");
        if (i < 0) {
            this.port = Convert.s2l(str);
        } else {
            this.port = Convert.s2l(str.substring(0, i));
            int j = str.indexOf(":");
            if (j < 0) {
                this.rhost = "localhost";
                j = i;
            } else {
                this.rhost = str.substring(i + 1, j);
            }
            this.rport = Convert.s2l(str.substring(j + 1));
        }
    }

    @Override
    public boolean open() {
        this.isOpen = false;
        try {
            this.dsock = new DatagramSocket(this.port);
            this.dsock.setSoTimeout(50);
            if (this.dir > 0) {
                this.buffo = new byte[8 + this.MAXPKTBUF];
                this.dpacko = new DatagramPacket(this.buffo, this.buffo.length);
                this.raddr = InetAddress.getByName(this.rhost);
                this.dpacko.setAddress(this.raddr);
                this.dpacko.setPort(this.rport);
            } else if (this.dir <= 0) {
                this.buffi = new byte[8 + this.MAXPKTBUF];
                this.dpacki = new DatagramPacket(this.buffi, this.buffi.length);
            }
            this.isOpen = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.woff = 0;
        this.roff = 0;
        return this.isOpen;
    }

    @Override
    public boolean close() {
        if (this.dsock != null) {
            this.dsock.close();
        }
        return true;
    }

    @Override
    public boolean seek(long offset) {
        return offset == this.offset;
    }

    @Override
    public long avail() {
        return 0L;
    }

    @Override
    public int read(byte[] buf, int boff, int bytes) {
        int status = 0;
        int off = boff;
        while (bytes > 0) {
            try {
                this.dpacki.setLength(this.buffi.length);
                this.dsock.receive(this.dpacki);
                status = this.dpacki.getLength();
            }
            catch (IOException e) {
                status = -1;
            }
            if (status <= 0) break;
            System.arraycopy(this.buffi, 0, buf, off, status);
            bytes -= status;
            off += status;
        }
        bytes = off - boff;
        if (status < 0 && bytes == 0) {
            return status;
        }
        this.offset += (long)bytes;
        return bytes;
    }

    @Override
    public int write(byte[] buf, int boff, int bytes) {
        System.arraycopy(buf, boff, this.buffo, this.woff, bytes);
        this.woff += bytes;
        if (this.woff >= this.MINPKTSIZE) {
            try {
                this.dpacko.setLength(this.woff);
                this.dsock.send(this.dpacko);
                this.woff = 0;
            }
            catch (IOException e) {
                return -1;
            }
        }
        this.offset += (long)bytes;
        return bytes;
    }
}

