/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.FilenameFilter;
import java.util.ArrayList;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.TarFile;
import nxm.sys.lib.Time;

public class TarResource
extends IOResource {
    private final TarFile tarFile = new TarFile();
    private String fileName = null;
    private TarFile.TarEntry tarEntry = null;

    public String toString() {
        return "TarResource: " + this.getURL();
    }

    @Override
    public void setURL(String urlstr) {
        urlstr = urlstr.replace("\\", "/");
        super.setURL("tar:", ".tar", new String[]{"!", "!/"}, urlstr);
        String url = this.getURL();
        int index = url.indexOf(33);
        String archName = url.substring(4, index);
        this.fileName = url.substring(index + 1);
        this.tarFile.init(this.M, (Object)archName);
        this.tarFile.open();
    }

    @Override
    public boolean exists() {
        if (this.tarEntry == null) {
            this.tarEntry = this.tarFile.getEntry(this.fileName);
        }
        return this.tarEntry != null;
    }

    @Override
    public boolean open() {
        this.isOpen = false;
        if (this.dir <= 0) {
            this.tarEntry = this.tarFile.getEntry(this.fileName);
            if (this.tarEntry == null) {
                throw new MidasException("TarResource: Unable to open " + this.getURL() + ": Can not find " + this.fileName + " in " + this.tarFile.getName());
            }
        }
        if (this.dir >= 0) {
            throw new MidasException("TarResource: Output not supported at this time, URL=" + this.getURL());
        }
        this.isOpen = true;
        this.seek(this.offset);
        return this.isOpen;
    }

    @Override
    public boolean close() {
        this.tarEntry = null;
        this.tarFile.close();
        this.isOpen = false;
        return this.isOpen;
    }

    @Override
    public long getLength() {
        return this.tarEntry != null ? this.tarEntry.getSize() : 0L;
    }

    @Override
    public boolean seek(long off) {
        this.offset = off;
        double seek = off + this.tarEntry.getOffset();
        this.tarFile.seek(seek);
        return true;
    }

    @Override
    public long seek() {
        return (long)(this.tarFile.seek() - (double)this.tarEntry.getOffset());
    }

    @Override
    public long avail() {
        return this.tarEntry.getSize() - this.seek();
    }

    @Override
    public int read(byte[] buf, int boff, int bytes) {
        int avail = (int)Math.min(Integer.MAX_VALUE, this.avail());
        if (avail == 0) {
            return -1;
        }
        if (bytes > avail) {
            bytes = avail;
        }
        return this.tarFile.read(buf, boff, bytes);
    }

    @Override
    public int write(byte[] buf, int boff, int bytes) {
        throw new MidasException("TarResource: Output not supported at this time, URL=" + this.getURL());
    }

    public Object[] getEntries() {
        return this.tarFile.getEntries();
    }

    @Override
    public String[] getEntryList(FilenameFilter filter) {
        TarFile.TarEntry[] entries = (TarFile.TarEntry[])this.tarFile.getEntries();
        ArrayList<String> matches = new ArrayList<String>();
        for (TarFile.TarEntry entry : entries) {
            String name = entry.getName();
            if (!name.startsWith(this.fileName) || (name = name.substring(this.fileName.length())).length() <= 0 || name.indexOf(47) >= 0 || filter != null && !filter.accept(null, name)) continue;
            matches.add(name);
        }
        return matches.toArray(StringUtil.EMPTY_STRING_ARRAY);
    }

    @Override
    public Time lastModifiedTime() {
        return this.tarEntry == null ? new Time() : this.tarEntry.getTime();
    }

    @Override
    public long lastModified() {
        return (long)this.lastModifiedTime().toJ1970();
    }
}

