/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import nxm.sys.inc.ListFile;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.inc.Tablizable;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public class TarFile
extends BaseFile
implements ListFile {
    private static final int TAR_HEAD_LEN = 256;
    private static final int USTAR_HEAD_LEN = 512;
    private static final char LINK_NORMAL_ALT = '\u0000';
    private static final char LINK_NORMAL = '0';
    private static final char LINK_HARD_LINK = '1';
    private static final char LINK_SYMBOLIC_LINK = '2';
    private static final char LINK_CHARACTER_SPECIAL = '3';
    private static final char LINK_BLOCK_SPECIAL = '4';
    private static final char LINK_DIRECTORY = '5';
    private static final char LINK_FIFO = '6';
    private static final char LINK_CONTIGUIOUS_FILE = '7';
    private static final int S_IRWXU = 448;
    private static final int S_IRUSR = 256;
    private static final int S_IWUSR = 128;
    private static final int S_IXUSR = 64;
    private static final int S_IRWXG = 56;
    private static final int S_IRGRP = 32;
    private static final int S_IWGRP = 16;
    private static final int S_IXGRP = 8;
    private static final int S_IRWXO = 7;
    private static final int S_IROTH = 4;
    private static final int S_IWOTH = 2;
    private static final int S_IXOTH = 1;
    private static final int S_ISUID = 2048;
    private static final int S_ISGID = 1024;
    private static final int S_ISVTX = 512;
    private TarEntry[] entries = null;

    public TarFile() {
    }

    @Deprecated
    public TarFile(Object ref, Object filename) {
        if (ref instanceof MidasReference) {
            this.init((MidasReference)ref, filename);
        } else {
            this.init(Convert.ref2Midas(ref), filename);
        }
    }

    public TarFile(MidasReference ref, Object filename) {
        this.init(ref, filename);
    }

    @Override
    public String getMimeType() {
        return "application/x-tar";
    }

    @Override
    public boolean open() {
        if (super.open()) {
            TarEntry entry;
            ArrayList<TarEntry> vect = new ArrayList<TarEntry>();
            while ((entry = this.nextEntry()) != null) {
                vect.add(entry);
            }
            this.entries = vect.toArray(new TarEntry[vect.size()]);
        }
        return this.isOpen;
    }

    TarEntry getEntry(String name) {
        TarEntry entry = null;
        for (int i = this.entries.length - 1; entry == null && i >= 0; --i) {
            if (!this.entries[i].getName().equals(name)) continue;
            entry = this.entries[i];
        }
        return entry;
    }

    @Override
    public Object[] getEntries() {
        return this.entries;
    }

    private TarEntry nextEntry() {
        TarEntry entry = null;
        byte[] buf = new byte[512];
        long fileOffset = (long)this.seek();
        int numRead = this.read(buf, 0, buf.length);
        if (numRead > 0) {
            entry = new TarEntry(buf, fileOffset);
            if (entry.isBlank()) {
                entry = null;
            } else {
                long seek = (long)this.seek() + entry.getEntrySize() - (long)buf.length;
                this.seek(seek);
            }
        }
        return entry;
    }

    @Override
    public String toString() {
        String str = "TarFile ";
        if (this.io != null) {
            str = str + this.io.getTypeString();
        }
        str = str + " Resource";
        return str;
    }

    @Override
    public String listHeader() {
        String list3 = "TarFile   :  " + this.getURL() + "\nSize      :  " + (long)this.getSize() + " bytes\nEntries   :  " + this.entries.length + "\n";
        return list3;
    }

    @Override
    public String listElements(double start, int elements, String format, int flags) {
        int i = (int)start;
        return i < this.entries.length ? this.entries[i].toString(true) + '\n' : null;
    }

    @Override
    public int listElementsPerLine(int lineWidth, String form, int flags) {
        return 1;
    }

    public int getNumEntries() {
        return this.entries.length;
    }

    private void notEditable() {
        throw new UnsupportedOperationException("TarFile is not editable.");
    }

    @Override
    public double getNumberOfRows() {
        return this.getNumEntries();
    }

    @Override
    public boolean getProtected() {
        return true;
    }

    @Override
    public int setData(double d, Table t) {
        this.notEditable();
        return 0;
    }

    @Override
    public void setData(double d, String s, Object o) {
        this.notEditable();
    }

    @Override
    public void insertData(double d, Object o) {
        this.notEditable();
    }

    @Override
    public void removeData(double d) {
        this.notEditable();
    }

    @Override
    public void removeData(double d, long c) {
        this.notEditable();
    }

    @Override
    public void setRecordDefs(Table t) {
        this.notEditable();
    }

    @Override
    public Table getDataTable(double offset) {
        if (offset < 0.0) {
            return null;
        }
        if (offset >= (double)this.entries.length) {
            return null;
        }
        return this.entries[(int)offset].toTable();
    }

    @Override
    public int getRecordDefCount() {
        return this.entries.length == 0 || this.entries[0].isUstar() ? 13 : 11;
    }

    @Override
    public Table getRecordDef(int i) {
        Table t = new Table();
        switch (i) {
            case 0: {
                t.put("NAME", (Object)"NAME");
                break;
            }
            case 1: {
                t.put("NAME", (Object)"MODE");
                t.put("FORMAT", (Object)"SL");
                break;
            }
            case 2: {
                t.put("NAME", (Object)"MODE_STRING");
                break;
            }
            case 3: {
                t.put("NAME", (Object)"OWNER");
                t.put("FORMAT", (Object)"SL");
                break;
            }
            case 4: {
                t.put("NAME", (Object)"GROUP");
                t.put("FORMAT", (Object)"SL");
                break;
            }
            case 5: {
                t.put("NAME", (Object)"SIZE");
                t.put("FORMAT", (Object)"SX");
                break;
            }
            case 6: {
                t.put("NAME", (Object)"TIME");
                t.put("FORMAT", (Object)"SD");
                break;
            }
            case 7: {
                t.put("NAME", (Object)"CHECKSUM");
                break;
            }
            case 8: {
                t.put("NAME", (Object)"LINK_INDICATOR");
                break;
            }
            case 9: {
                t.put("NAME", (Object)"LINK_INDICATOR_NAME");
                break;
            }
            case 10: {
                t.put("NAME", (Object)"LINKED_FILE");
                break;
            }
            case 11: {
                t.put("NAME", (Object)"OWNER_NAME");
                break;
            }
            case 12: {
                t.put("NAME", (Object)"GROUP_NAME");
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException("Invalid record definition i=" + i);
            }
        }
        return t;
    }

    @Override
    public Table getRecordDefs() {
        Table t = new Table();
        for (int i = 0; i < this.getRecordDefCount(); ++i) {
            t.put(Integer.toString(i), (Object)this.getRecordDef(i));
        }
        return t;
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public static InputStream asTarFileInputStream(TarEntryWithData ... entries) {
        return TarFile.asTarFileInputStream(Arrays.asList(entries));
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public static InputStream asTarFileInputStream(List<TarEntryWithData> entries) {
        ArrayList<InputStream> streams = new ArrayList<InputStream>(entries.size());
        for (TarEntryWithData e : entries) {
            e.pushTarEntry(streams);
        }
        streams.add(new PadInputStream(1024, null));
        return new SequenceInputStream(Collections.enumeration(streams));
    }

    public static void createTarFile(MidasReference ref, Object fname, TarEntryWithData ... entries) {
        TarFile.createTarFile(ref, fname, Arrays.asList(entries));
    }

    public static void createTarFile(MidasReference ref, Object fname, List<TarEntryWithData> entries) {
        try {
            int n;
            BaseFile bf = new BaseFile(ref, fname);
            InputStream in = TarFile.asTarFileInputStream(entries);
            bf.open(2);
            byte[] buffer = new byte[4096];
            while ((n = in.read(buffer, 0, buffer.length)) >= 0) {
                bf.write(buffer, 0, n);
            }
            in.close();
            bf.close();
        }
        catch (IOException e) {
            throw new MidasException("Unable to create TAR file " + fname, e);
        }
    }

    private static class PadInputStream
    extends InputStream {
        Closeable toClose;
        int count;

        PadInputStream(int count, Closeable toClose) {
            this.count = count;
            this.toClose = toClose;
        }

        @Override
        public int read() {
            return this.count-- > 0 ? 0 : -1;
        }

        @Override
        public void close() throws IOException {
            if (this.toClose != null) {
                this.toClose.close();
            }
        }
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public static class TarEntryWithData
    extends TarEntry
    implements Closeable {
        final InputStream data;
        final Closeable toClose;

        public TarEntryWithData(String name, MidasReference ref, Object fname) {
            this(name, "664", 0, "root", 0, "root", null, ref, fname);
        }

        public TarEntryWithData(String name, String mode, int ownerID, String owner, int groupID, String group2, Time time, MidasReference ref, Object fname) {
            super(name, mode, ownerID, owner, groupID, group2, time, 0L, true);
            BaseFile bf = new BaseFile(ref, fname);
            bf.open();
            long len = bf.io.getLength();
            this.setSize(len);
            if (len == 0L) {
                Shell.warning("Zero length file given " + bf.getName());
            }
            if (name == null || name.isEmpty()) {
                this.setName(bf.getName().getBasename());
            } else if (name.endsWith("/")) {
                this.setName(name + bf.getName().getBasename());
            }
            if (time == null) {
                this.setTime(bf.io.lastModifiedTime());
            }
            this.data = bf.io.getInputStream();
            this.toClose = bf;
            this.skipChecksum = false;
            this.updateCheckSum();
        }

        public TarEntryWithData(String name, String mode, int ownerID, String owner, int groupID, String group2, Time time, long size, InputStream data) {
            super(name, mode, ownerID, owner, groupID, group2, time, size, true);
            this.data = data;
            this.toClose = null;
        }

        void pushTarEntry(List<InputStream> streams) {
            streams.add(new ByteArrayInputStream(this.buf, this.offset, 512));
            if (this.getSize() > 0L) {
                streams.add(this.data);
            }
            streams.add(new PadInputStream(this.getPadding(), this));
        }

        @Override
        public void close() throws IOException {
            if (this.data != null) {
                this.data.close();
            }
            if (this.toClose != null) {
                this.toClose.close();
            }
        }
    }

    public static class TarEntry
    implements Tablizable {
        final byte[] buf;
        final int offset;
        boolean skipChecksum;

        public TarEntry(byte[] buf, long off) {
            this.buf = buf;
            this.offset = (int)TarEntry.align(this.isUstar() ? off + 512L : off + 256L);
            this.skipChecksum = false;
        }

        TarEntry(String name, String mode, int ownerID, String owner, int groupID, String group2, Time time, long size, boolean skipChecksum) {
            this.buf = new byte[512];
            this.offset = 0;
            this.skipChecksum = true;
            this.buf[257] = 117;
            this.buf[258] = 115;
            this.buf[259] = 116;
            this.buf[260] = 97;
            this.buf[261] = 114;
            this.buf[262] = 32;
            this.buf[263] = 32;
            this.buf[264] = 0;
            this.setName(name);
            this.setSize(size);
            this.setModeString(mode);
            this.setOwner(ownerID);
            this.setOwnerName(owner);
            this.setGroup(groupID);
            this.setGroupName(group2);
            this.setTime(time);
            this.setLinkedFile(null);
            if (!skipChecksum) {
                this.skipChecksum = skipChecksum;
                this.updateCheckSum();
            }
        }

        private static long align(long seek) {
            long mod = seek % 512L;
            if (mod != 0L) {
                seek = seek + 512L - mod;
            }
            return seek;
        }

        long getOffset() {
            return this.offset;
        }

        long getEntrySize() {
            long size = this.getSize();
            size = this.isUstar() ? (size += 512L) : (size += 256L);
            return TarEntry.align(size);
        }

        private boolean isUstar() {
            return this.buf[257] == 117 && this.buf[258] == 115 && this.buf[259] == 116 && this.buf[260] == 97 && this.buf[261] == 114 && this.buf[262] == 32 && this.buf[263] == 32 && this.buf[264] == 0;
        }

        boolean isBlank() {
            boolean blank = true;
            for (int i = 0; blank && i < this.buf.length; ++i) {
                blank = this.buf[i] == 0;
            }
            return blank;
        }

        public String toString() {
            return this.toString(false);
        }

        String toString(boolean pad) {
            StringBuilder str = new StringBuilder(32);
            String size = Long.toString(this.getSize());
            if (pad) {
                size = StringUtil.padLeft(size, 9);
            }
            str.append(this.getModeString()).append(' ');
            str.append(this.getOwnerName()).append('/');
            str.append(this.getGroupName()).append(' ');
            str.append(size).append(' ');
            str.append(this.getTime().toString(-1)).append(' ');
            str.append(this.getName());
            if (this.isLink()) {
                str.append(" -> ").append(this.getLinkedFile());
            }
            return str.toString();
        }

        @Override
        public Table toTable() {
            Table tbl = new Table();
            tbl.put("NAME", (Object)this.getName());
            tbl.put("MODE", this.getMode());
            tbl.put("MODE_STRING", (Object)this.getModeString());
            tbl.put("OWNER", this.getOwner());
            tbl.put("OWNER_NAME", (Object)this.getOwnerName());
            tbl.put("GROUP", this.getGroup());
            tbl.put("GROUP_NAME", (Object)this.getGroupName());
            tbl.put("TIME", this.getTime().getSec());
            tbl.put("TIMESTAMP", (Object)this.getTime());
            tbl.put("CHECKSUM", (Object)this.getCheckSum());
            tbl.put("LINK_INDICATOR", this.getLinkIndicator());
            tbl.put("LINK_INDICATOR_NAME", (Object)this.getLinkIndicatorName());
            tbl.put("LINKED_FILE", (Object)this.getLinkedFile(""));
            return tbl;
        }

        String dumpToString(String sp) {
            return sp + "Name           : " + this.getName() + "\n" + sp + "Mode           : " + this.getModeString() + " (mode=" + this.getMode() + ")\n" + sp + "Owner          : " + this.getOwnerName() + " (ID=" + this.getOwner() + ")\n" + sp + "Group          : " + this.getGroupName() + " (ID=" + this.getGroup() + ")\n" + sp + "File Size      : " + this.getSize() + " bytes\n" + sp + "Last Mod Time  : " + this.getTime() + "\n" + sp + "Check Sum      : " + this.getCheckSum() + "\n" + sp + "Link Indicator : " + this.getLinkIndicatorName() + "\n" + sp + "Linked File    : " + this.getLinkedFile("n/a") + "\n";
        }

        public String getName() {
            String name = this.isUstar() ? this.unpackS(345, 155) + this.unpackS(0, 100) : this.unpackS(0, 100);
            return name;
        }

        public void setName(String name) {
            if (name == null) {
                name = "";
            }
            int length = name.length();
            if (!this.isUstar()) {
                this.packS(0, 100, name);
            } else if (length > 100) {
                this.packS(0, 100, name.substring(length - 100));
                this.packS(345, 155, name.substring(0, length - 100));
            } else {
                this.packS(0, 100, name);
                this.packS(345, 155, null);
            }
            this._updateCheckSum();
        }

        public String getModeString() {
            StringBuilder str = new StringBuilder(10);
            char link = this.getLinkIndicator();
            int mode = this.getMode();
            switch (link) {
                case '\u0000': {
                    str.append('-');
                    break;
                }
                case '0': {
                    str.append('-');
                    break;
                }
                case '1': {
                    str.append('l');
                    break;
                }
                case '2': {
                    str.append('l');
                    break;
                }
                case '3': {
                    str.append('c');
                    break;
                }
                case '4': {
                    str.append('b');
                    break;
                }
                case '5': {
                    str.append('d');
                    break;
                }
                case '6': {
                    str.append('p');
                    break;
                }
                default: {
                    str.append('?');
                }
            }
            if ((mode & 0x100) != 0) {
                str.append('r');
            } else {
                str.append('-');
            }
            if ((mode & 0x80) != 0) {
                str.append('w');
            } else {
                str.append('-');
            }
            if ((mode & 0x40) != 0) {
                str.append('x');
            } else {
                str.append('-');
            }
            if ((mode & 0x20) != 0) {
                str.append('r');
            } else {
                str.append('-');
            }
            if ((mode & 0x10) != 0) {
                str.append('w');
            } else {
                str.append('-');
            }
            if ((mode & 8) != 0) {
                str.append('x');
            } else {
                str.append('-');
            }
            if ((mode & 4) != 0) {
                str.append('r');
            } else {
                str.append('-');
            }
            if ((mode & 2) != 0) {
                str.append('w');
            } else {
                str.append('-');
            }
            if ((mode & 1) != 0) {
                str.append('x');
            } else {
                str.append('-');
            }
            if ((mode & 0x800) != 0) {
                if ((mode & 0x40) != 0) {
                    str.setCharAt(3, 's');
                } else {
                    str.setCharAt(3, 'S');
                }
            }
            if ((mode & 0x400) != 0) {
                if ((mode & 8) != 0) {
                    str.setCharAt(6, 's');
                } else {
                    str.setCharAt(6, 'S');
                }
            }
            if ((mode & 0x200) != 0) {
                if ((mode & 1) != 0) {
                    str.setCharAt(6, 't');
                } else {
                    str.setCharAt(6, 'T');
                }
            }
            return link == '7' ? null : str.toString();
        }

        public void setModeString(String str) {
            if (str == null) {
                this.setMode(436);
                return;
            }
            if (str.isEmpty()) {
                this.setMode(436);
                return;
            }
            if (str.length() == 3) {
                this.setMode(Integer.parseInt(str, 8));
                return;
            }
            if (str.length() == 9) {
                str = "-" + str;
            }
            if (str.length() != 10) {
                throw new MidasException("Illegal file mode: " + str);
            }
            switch (str.charAt(0)) {
                case '-': {
                    this.setLinkIndicator('0');
                    break;
                }
                case 'l': {
                    this.setLinkIndicator('1');
                    break;
                }
                case 'c': {
                    this.setLinkIndicator('3');
                    break;
                }
                case 'b': {
                    this.setLinkIndicator('4');
                    break;
                }
                case 'd': {
                    this.setLinkIndicator('5');
                    break;
                }
                case 'p': {
                    this.setLinkIndicator('6');
                    break;
                }
                case '?': {
                    break;
                }
                default: {
                    throw new MidasException("Illegal file mode: " + str);
                }
            }
            int mode = 0;
            mode |= this.modeFlag(str, 1, 256, 'r', 0, '-', 0, '-');
            mode |= this.modeFlag(str, 2, 128, 'w', 0, '-', 0, '-');
            mode |= this.modeFlag(str, 3, 64, 'x', 2112, 's', 2048, 'S');
            mode |= this.modeFlag(str, 4, 32, 'r', 0, '-', 0, '-');
            mode |= this.modeFlag(str, 5, 16, 'w', 0, '-', 0, '-');
            mode |= this.modeFlag(str, 6, 8, 'x', 1032, 's', 1024, 'S');
            mode |= this.modeFlag(str, 4, 4, 'r', 0, '-', 0, '-');
            mode |= this.modeFlag(str, 5, 2, 'w', 0, '-', 0, '-');
            this.setMode(mode |= this.modeFlag(str, 6, 1, 'x', 513, 't', 512, 'T'));
        }

        private int modeFlag(String str, int off, int flag1, char on1, int flag2, char on2, int flag3, char on3) {
            char c = str.charAt(off);
            if (c == '-') {
                return 0;
            }
            if (c == on1) {
                return flag1;
            }
            if (c == on2) {
                return flag2;
            }
            if (c == on3) {
                return flag3;
            }
            throw new MidasException("Illegal file mode: " + str);
        }

        public int getMode() {
            return this.unpackL(100, 8);
        }

        public void setMode(int val) {
            this.packL(100, 8, val);
            this._updateCheckSum();
        }

        public int getOwner() {
            return this.unpackL(108, 8);
        }

        public void setOwner(int val) {
            this.packL(108, 8, val);
            this._updateCheckSum();
        }

        public String getOwnerName() {
            return this.isUstar() ? this.unpackS(265, 32) : Integer.toString(this.getOwner());
        }

        public void setOwnerName(String val) {
            this.packS(265, 32, val);
            this._updateCheckSum();
        }

        public int getGroup() {
            return this.unpackL(116, 8);
        }

        public void setGroup(int val) {
            this.packL(116, 8, val);
            this._updateCheckSum();
        }

        public String getGroupName() {
            return this.isUstar() ? this.unpackS(297, 32) : Integer.toString(this.getGroup());
        }

        public void setGroupName(String val) {
            this.packS(297, 32, val);
            this._updateCheckSum();
        }

        int getPadding() {
            long padBytes = (512L - this.getSize() % 512L) % 512L;
            return (int)padBytes;
        }

        public long getSize() {
            return this.unpackL(124, 12);
        }

        public void setSize(long val) {
            this.packX(124, 12, val);
            this._updateCheckSum();
        }

        public long getTime1970() {
            return this.unpackX(136, 12);
        }

        public void setTime1970(long val) {
            this.packX(136, 12, val);
            this._updateCheckSum();
        }

        public Time getTime() {
            double j1970 = this.unpackX(136, 12);
            return new Time(j1970 + 6.31152E8);
        }

        public void setTime(Time t) {
            if (t == null || t.isZero()) {
                this.setTime1970(System.currentTimeMillis() / 1000L);
            } else {
                long j1970 = (long)(t.getWSec() - 6.31152E8);
                this.setTime1970(j1970);
            }
        }

        public String getCheckSum() {
            return this.unpackS(148, 8);
        }

        public void setCheckSum(int val) {
            this.packL(148, 7, val);
            this.buf[this.offset + 154] = 0;
            this.buf[this.offset + 155] = 32;
        }

        private void _updateCheckSum() {
            if (!this.skipChecksum) {
                this.updateCheckSum();
            }
        }

        public void updateCheckSum() {
            this.buf[this.offset + 148] = 32;
            this.buf[this.offset + 149] = 32;
            this.buf[this.offset + 150] = 32;
            this.buf[this.offset + 151] = 32;
            this.buf[this.offset + 152] = 32;
            this.buf[this.offset + 153] = 32;
            this.buf[this.offset + 154] = 32;
            this.buf[this.offset + 155] = 32;
            int len = this.isUstar() ? 512 : 256;
            int value = 0;
            for (int i = 0; i < len; ++i) {
                value += 0xFF & this.buf[this.offset + i];
            }
            this.setCheckSum(value);
        }

        public char getLinkIndicator() {
            return (char)this.buf[156];
        }

        public void setLinkIndicator(String val) {
            if (val.length() != 1) {
                throw new MidasException("Invalid link indicator: '" + val + "'");
            }
            this.setLinkIndicator(val.charAt(0));
        }

        public void setLinkIndicator(char val) {
            this.buf[156] = (byte)val;
            this._updateCheckSum();
        }

        public String getLinkIndicatorName() {
            char c = this.getLinkIndicator();
            switch (c) {
                case '\u0000': {
                    return "Normal";
                }
                case '0': {
                    return "Normal";
                }
                case '1': {
                    return "HardLink";
                }
                case '2': {
                    return "SymbolicLink";
                }
                case '3': {
                    return "CharacterSpecial";
                }
                case '4': {
                    return "BlockSpecial";
                }
                case '5': {
                    return "Directory";
                }
                case '6': {
                    return "FIFO";
                }
                case '7': {
                    return "ContiguousFile";
                }
            }
            throw new MidasException("Unknown link type '" + c + "'.");
        }

        public void setLinkIndicatorName(String val) {
            if (val.equalsIgnoreCase("Normal")) {
                this.setLinkIndicator('0');
            } else if (val.equalsIgnoreCase("HardLink")) {
                this.setLinkIndicator('1');
            } else if (val.equalsIgnoreCase("SymbolicLink")) {
                this.setLinkIndicator('2');
            } else if (val.equalsIgnoreCase("CharacterSpecial")) {
                this.setLinkIndicator('3');
            } else if (val.equalsIgnoreCase("BlockSpecial")) {
                this.setLinkIndicator('4');
            } else if (val.equalsIgnoreCase("Directory")) {
                this.setLinkIndicator('5');
            } else if (val.equalsIgnoreCase("FIFO")) {
                this.setLinkIndicator('6');
            } else if (val.equalsIgnoreCase("ContiguousFile")) {
                this.setLinkIndicator('7');
            } else {
                throw new MidasException("Unknown link type: '" + val + "'.");
            }
        }

        public boolean isLink() {
            char c = this.getLinkIndicator();
            return c == '1' || c == '2';
        }

        public String getLinkedFile() {
            return this.getLinkedFile(null);
        }

        private String getLinkedFile(String def) {
            String str = def;
            char c = this.getLinkIndicator();
            if (c == '1' || c == '2') {
                str = this.unpackS(157, 100);
            }
            return str;
        }

        public void setLinkedFile(String val) {
            if (val == null) {
                this.setLinkIndicator('0');
            } else if (this.isLink()) {
                this.setLinkIndicator('2');
            }
            this.packS(157, 100, val);
            this._updateCheckSum();
        }

        private int unpackL(int off, int len) {
            return (int)this.unpackX(off, len);
        }

        private void packL(int off, int len, int val) {
            this.packX(off, len, val);
        }

        private long unpackX(int off, int len) {
            String str = this.unpackS(off, len);
            try {
                return str.length() == 0 ? 0L : Long.parseLong(str, 8);
            }
            catch (NumberFormatException e) {
                throw new MidasException("Error converting octal number '" + str + "' to decimal.");
            }
        }

        private void packX(int off, int len, long val) {
            String str = Long.toOctalString(val);
            while (str.length() < len - 1) {
                str = "0" + str;
            }
            if (str.length() >= len) {
                throw new IllegalArgumentException("Given value exceeds limits: " + val);
            }
            this.packS(off, len, str);
        }

        private String unpackS(int off, int len) {
            if (off > 256 && !this.isUstar()) {
                return null;
            }
            while (len > 0 && this.buf[off + len - 1] == 0) {
                --len;
            }
            char[] chars = new char[len];
            for (int i = 0; i < len; ++i) {
                chars[i] = (char)this.buf[i + off];
            }
            return new String(chars);
        }

        private void packS(int off, int len, String str) {
            if (str == null) {
                str = "";
            }
            if (off > 256 && !this.isUstar()) {
                throw new IllegalArgumentException("TarFile: Can not set string value '" + str + "' at off=" + off + " tar file is not in in USTAR format.");
            }
            if (str.length() > len) {
                throw new IllegalArgumentException("TarFile: String value '" + str + "' exceeds maximum length of " + len + ".");
            }
            for (int i = 0; i < len; ++i) {
                this.buf[off++] = (byte)(i < str.length() ? str.charAt(i) : (char)'\u0000');
            }
        }
    }
}

