/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nxm.sys.inc.Constants;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.PlotFile;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.Keywords;
import nxm.sys.lib.Position;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.lib.Transform;
import nxm.sys.lib.Util;

public class StateVector
extends Position
implements Constants,
Keyable {
    private static final double SPEED_OF_LIGHT_INV = 3.3356409519815204E-9;
    private static final double FOUR_PI_INV = 0.07957747154594767;
    public double vx;
    public double vy;
    public double vz;
    protected double vn;
    protected double ve;
    protected double vu;
    protected double ax;
    protected double ay;
    protected double az;
    protected double an;
    protected double ae;
    protected double au;
    protected int iVel;
    protected int iVelOff;
    protected int iAcc;
    protected int iAccOff;
    protected InterpolationOrder interpolationOrder = InterpolationOrder.CubicHermite;
    private static String[] keys = new String[]{"X", "Y", "Z", "VX", "VY", "VZ", "AX", "AY", "AZ", "R", "T", "LAT", "LON", "ALT", "FRAME", "VE", "VN", "VU", "AE", "AN", "AU"};

    public StateVector() {
        this.referenceFrame = 1;
    }

    @Deprecated
    public StateVector(Object ref, Object name) {
        super(ref, name);
    }

    public StateVector(MidasReference ref, Object name) {
        super(ref, name);
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.5.4")
    public StateVector(BaseFile file) {
        super(file);
    }

    @Override
    public StateVector copy() {
        return this.copyTo(new StateVector());
    }

    protected StateVector copyTo(StateVector sv) {
        super.copyTo(sv);
        sv.vx = this.vx;
        sv.vy = this.vy;
        sv.vz = this.vz;
        sv.ax = this.ax;
        sv.ay = this.ay;
        sv.az = this.az;
        sv.vn = this.vn;
        sv.ve = this.ve;
        sv.vu = this.vu;
        sv.an = this.an;
        sv.ae = this.ae;
        sv.au = this.au;
        return sv;
    }

    @Override
    public Table toTable() {
        Table tbl = super.toTable();
        tbl.put("VX", this.getVX());
        tbl.put("VY", this.getVY());
        tbl.put("VZ", this.getVZ());
        tbl.put("AX", this.getAX());
        tbl.put("AY", this.getAY());
        tbl.put("AZ", this.getAZ());
        tbl.put("SPEED", this.getSpeed());
        tbl.put("HEADING", this.getHeading());
        tbl.put("TIMECODE", this.getTimeCode());
        tbl.put("VU", this.getVU());
        tbl.put("VE", this.getVE());
        tbl.put("VN", this.getVN());
        tbl.put("AU", this.getAU());
        tbl.put("AE", this.getAE());
        tbl.put("AN", this.getAN());
        return tbl;
    }

    @Override
    protected boolean setFileT5Data(DataFile df) {
        if (!super.setFileT5Data(df)) {
            return false;
        }
        this.iVel = df.findRec("VEL");
        this.iAcc = df.findRec("ACC");
        this.iVelOff = this.iVel < 0 ? -1 : (int)df.getCompOffset(this.iVel);
        this.iAccOff = this.iAcc < 0 ? -1 : (int)df.getCompOffset(this.iAcc);
        return true;
    }

    public List<Table> getStateEntries() {
        return this.getStateEntries(null, true);
    }

    public List<Table> getStateEntries(List<Time> times) {
        return this.getStateEntries(times, true);
    }

    private List<Table> getStateEntries(List<Time> times, boolean copy) {
        if (times != null) {
            ArrayList<Table> entries = new ArrayList<Table>();
            for (Time t : times) {
                this.setCurrentTime(t);
                entries.add(this.toTable());
            }
            return entries;
        }
        if (this.data != null) {
            if (copy) {
                ArrayList<Table> entries = new ArrayList<Table>();
                for (Table e : this.data) {
                    entries.add(e.copy());
                }
                return entries;
            }
            return this.data;
        }
        if (this.db == null) {
            return Arrays.asList(this.toTable());
        }
        ArrayList<Table> entries = new ArrayList<Table>();
        DataFile df = this.getDataFile();
        int i = 0;
        while ((double)i < df.getSize()) {
            int off = i * this.db.bpe;
            Table row = new Table();
            row.put("TIME", df.getTimeAt(i));
            row.put("CURRENTTIME", (Object)df.getTimeAt(i, null));
            if (this.iPos >= 0) {
                double[] p = StateVector.unpack(off, this.iPosOff, this.db, null);
                row.put("X", p[0]);
                row.put("Y", p[1]);
                row.put("Z", p[2]);
            }
            if (this.iVel >= 0) {
                double[] v = StateVector.unpack(off, this.iVelOff, this.db, null);
                row.put("VX", v[0]);
                row.put("VY", v[1]);
                row.put("VZ", v[2]);
            }
            if (this.iAcc >= 0) {
                double[] a = StateVector.unpack(off, this.iAccOff, this.db, null);
                row.put("AX", a[0]);
                row.put("AY", a[1]);
                row.put("AZ", a[2]);
            }
            entries.add(row);
            ++i;
        }
        return entries;
    }

    private Data[] _toKeywords(List<Time> times, Time timeEpoch, double timeDelta) {
        Object[] tc;
        Object[] _tc;
        Transform xform = Transform.toTransform("ECR");
        List<Table> ent = this.getStateEntries(times, false);
        int len = ent.size();
        Time[] time = new Time[len];
        double[] posX = new double[len];
        double[] posY = new double[len];
        double[] posZ = new double[len];
        double[] velX = new double[len];
        double[] velY = new double[len];
        double[] velZ = new double[len];
        double[] accX = new double[len];
        double[] accY = new double[len];
        double[] accZ = new double[len];
        int i = 0;
        for (Table e : ent) {
            double[] pva = new double[]{e.getD("X"), e.getD("Y"), e.getD("Z"), e.getD("VX"), e.getD("VY"), e.getD("VZ"), e.getD("AX"), e.getD("AY"), e.getD("AZ")};
            Time _time = this.getCurrentTime(e);
            Transform.fsu2fsu(pva, 3, this.transform, xform, _time);
            time[i] = _time;
            posX[i] = pva[0];
            posY[i] = pva[1];
            posZ[i] = pva[2];
            velX[i] = pva[3];
            velY[i] = pva[4];
            velZ[i] = pva[5];
            accX[i] = pva[6];
            accY[i] = pva[7];
            accZ[i] = pva[8];
            ++i;
        }
        if (timeEpoch == null) {
            _tc = new double[time.length];
            for (int j = 0; j < time.length; ++j) {
                _tc[j] = time[j].getSec();
            }
            tc = _tc;
        } else if (timeDelta == 0.0) {
            _tc = new double[time.length];
            for (int j = 0; j < time.length; ++j) {
                _tc[j] = time[j].diff(timeEpoch);
            }
            tc = _tc;
        } else {
            _tc = new long[time.length];
            for (int j = 0; j < time.length; ++j) {
                _tc[j] = time[j].toTimeTicks(timeEpoch, timeDelta);
            }
            tc = _tc;
        }
        return new Data[]{new Data(tc), new Data(posX), new Data(posY), new Data(posZ), new Data(velX), new Data(velY), new Data(velZ), new Data(accX), new Data(accY), new Data(accZ)};
    }

    public Map<String, Object> toKeywordsEph() {
        return this.toKeywordsEph(null);
    }

    public Map<String, Object> toKeywordsEph(List<Time> times) {
        LinkedHashMap<String, Object> kwds = new LinkedHashMap<String, Object>();
        Data[] vals = this._toKeywords(times, null, 0.0);
        int i = 0;
        int j = 1;
        while (i < vals[0].getSize()) {
            kwds.put("D:ETIM" + j, vals[0].getNumber(i));
            kwds.put("D:POSX" + j, vals[1].getNumber(i));
            kwds.put("D:POSY" + j, vals[2].getNumber(i));
            kwds.put("D:POSZ" + j, vals[3].getNumber(i));
            kwds.put("D:VELX" + j, vals[4].getNumber(i));
            kwds.put("D:VELY" + j, vals[5].getNumber(i));
            kwds.put("D:VELZ" + j, vals[6].getNumber(i));
            kwds.put("D:ACCX" + j, vals[7].getNumber(i));
            kwds.put("D:ACCY" + j, vals[8].getNumber(i));
            kwds.put("D:ACCZ" + j, vals[9].getNumber(i));
            ++i;
            ++j;
        }
        kwds.put("D:USE_SV_KEYWORDS", 1.0);
        return kwds;
    }

    public Map<String, Object> toKeywordsVec() {
        return this.toKeywordsVec(null);
    }

    public Map<String, Object> toKeywordsVec(List<Time> times) {
        LinkedHashMap<String, Object> kwds = new LinkedHashMap<String, Object>();
        Data[] vals = this._toKeywords(times, null, 0.0);
        kwds.put("D:ETIM_VEC", vals[0]);
        kwds.put("D:POSX_VEC", vals[1]);
        kwds.put("D:POSY_VEC", vals[2]);
        kwds.put("D:POSZ_VEC", vals[3]);
        kwds.put("D:VELX_VEC", vals[4]);
        kwds.put("D:VELY_VEC", vals[5]);
        kwds.put("D:VELZ_VEC", vals[6]);
        kwds.put("D:ACCX_VEC", vals[7]);
        kwds.put("D:ACCY_VEC", vals[8]);
        kwds.put("D:ACCZ_VEC", vals[9]);
        return kwds;
    }

    public Map<String, Object> toKeywordsPlat(Time timeEpoch, double timeDelta, String prefix) {
        return this.toKeywordsPlat(null, timeEpoch, timeDelta, prefix);
    }

    public Map<String, Object> toKeywordsPlat(List<Time> times, Time timeEpoch, double timeDelta, String prefix) {
        if (prefix == null) {
            prefix = "EPH";
        }
        char charDOUBLE = 'D';
        LinkedHashMap<String, Object> kwds = new LinkedHashMap<String, Object>();
        Data[] vals = this._toKeywords(times, timeEpoch, timeDelta);
        char type = (char)(timeDelta != 0.0 ? 88 : 68);
        int units = timeDelta != 0.0 ? 32 : 1;
        this.putWithUnits(kwds, type, prefix + ".TIME", vals[0], units);
        this.putWithUnits(kwds, charDOUBLE, prefix + "_POS.X", vals[1], 5);
        this.putWithUnits(kwds, charDOUBLE, prefix + "_POS.Y", vals[2], 5);
        this.putWithUnits(kwds, charDOUBLE, prefix + "_POS.Z", vals[3], 5);
        this.putWithUnits(kwds, charDOUBLE, prefix + "_VEL.X", vals[4], 6);
        this.putWithUnits(kwds, charDOUBLE, prefix + "_VEL.Y", vals[5], 6);
        this.putWithUnits(kwds, charDOUBLE, prefix + "_VEL.Z", vals[6], 6);
        this.putWithUnits(kwds, charDOUBLE, prefix + "_ACC.X", vals[7], 7);
        this.putWithUnits(kwds, charDOUBLE, prefix + "_ACC.Y", vals[8], 7);
        this.putWithUnits(kwds, charDOUBLE, prefix + "_ACC.Z", vals[9], 7);
        return kwds;
    }

    public Map<String, Object> toKeywordsPlat(DataFile df) {
        Keywords kw = df.getKeywordsObject();
        Time timeEpoch = Time.toTime(kw.get("TIME_EPOCH"), 10);
        double timeDelta = kw.getD("TIME_DELTA", 0.0);
        String prefix = df.getQualifiers().getS("SVPREFIX", "EPH");
        return this.toKeywordsPlat(timeEpoch, timeDelta, prefix);
    }

    public Map<String, Object> toKeywordsLLA(String prefix) {
        if (prefix == null) {
            throw new NullPointerException("Prefix can not be null.");
        }
        LinkedHashMap<String, Object> kwds = new LinkedHashMap<String, Object>();
        this.putWithUnits(kwds, prefix + ".LON", this.getLon(), 34);
        this.putWithUnits(kwds, prefix + ".LAT", this.getLat(), 34);
        this.putWithUnits(kwds, prefix + ".ALT", this.getAlt(), 5);
        return kwds;
    }

    public Map<String, Object> toKeywordsLLA(DataFile df) {
        String prefix = df.getQualifiers().getS("SVPREFIX", null);
        return this.toKeywordsLLA(prefix);
    }

    public List<Table> toFileEntries(Object xf) {
        Transform xform = Transform.toTransform(xf);
        ArrayList<Table> fileData = new ArrayList<Table>();
        for (Table e : this.getStateEntries(null, false)) {
            Time tc = Time.toTime(e.get("TIME"));
            Time curTime = this.getCurrentTime(e);
            Table row = new Table();
            double[] pva = new double[]{e.getD("X"), e.getD("Y"), e.getD("Z"), e.getD("VX"), e.getD("VY"), e.getD("VZ"), e.getD("AX"), e.getD("AY"), e.getD("AZ")};
            Transform.fsu2fsu(pva, 3, this.transform, xform, tc);
            Data dat = new Data(pva);
            row.put("TIME", (Object)tc);
            row.put("CURRENTTIME", (Object)curTime);
            row.put("POS", (Object)dat.getElementAt(0, "VD", 1));
            row.put("VEL", (Object)dat.getElementAt(24, "VD", 1));
            row.put("ACC", (Object)dat.getElementAt(48, "VD", 1));
            fileData.add(row);
        }
        return fileData;
    }

    public List<Table> toFileEntries(Time t0, Time t1, Double dt, Object xf) {
        int len;
        if (dt != null && dt <= 0.0) {
            dt = null;
        }
        int n = len = this.data == null ? -1 : this.data.size();
        if (this.db != null) {
            if (t0 == null) {
                t0 = this.getStartTime();
            }
            if (dt == null) {
                dt = this.getDataFile().getDelta();
            }
            if (t1 == null) {
                t1 = this.getEndTime();
            }
        } else if (len > 1) {
            Time _t0 = this.getStartTime();
            Time _t1 = this.getEndTime();
            double _dt = _t1.diff(_t0) / (double)(len - 1);
            if (t0 == null) {
                t0 = _t0;
            }
            if (t1 == null) {
                t1 = _t1;
            }
            if (dt == null) {
                dt = t1.diff(t0) > 1.0 ? Math.max(1.0, Math.rint(_dt)) : Math.max(1.0E-6, Time.roundToMicro(_dt));
            }
        } else if (len == 1) {
            if (t0 == null) {
                t0 = this.getStartTime();
            }
            if (dt == null) {
                dt = 60.0;
            }
            if (t1 == null) {
                t1 = this.getEndTime();
            }
        } else {
            if (t0 == null) {
                t0 = this.getCurrentTime();
            }
            if (dt == null) {
                dt = 60.0;
            }
            if (t1 == null) {
                t1 = this.getCurrentTime();
            }
        }
        ArrayList<Time> times = new ArrayList<Time>();
        int i = 0;
        while (true) {
            Time tc = Time.add(t0, dt * (double)i);
            times.add(tc);
            if (tc.compareTo(t1) >= 0) break;
            ++i;
        }
        return this.toFileEntries(times, xf);
    }

    public List<Table> toFileEntries(List<Time> times, Object xf) {
        if (times == null) {
            return null;
        }
        Transform xform = Transform.toTransform(xf);
        ArrayList<Table> fileData = new ArrayList<Table>();
        for (Time tc : times) {
            this.setCurrentTime(tc);
            Table row = new Table();
            double[] pva = new double[]{this.getX(), this.getY(), this.getZ(), this.getVX(), this.getVY(), this.getVZ(), this.getAX(), this.getAY(), this.getAZ()};
            Transform.fsu2fsu(pva, 3, this.transform, xform, tc);
            Data dat = new Data((Object)pva, 3);
            row.put("TIME", (Object)tc);
            row.put("CURRENTTIME", (Object)this.convertTimeToCurrentTime(tc));
            row.put("POS", (Object)dat.getElementAt(0, "VD", 1));
            row.put("VEL", (Object)dat.getElementAt(24, "VD", 1));
            row.put("ACC", (Object)dat.getElementAt(48, "VD", 1));
            fileData.add(row);
        }
        return fileData;
    }

    public final List<Table> toFileEntries(PlotFile pf) {
        Time t0 = pf instanceof DataFile ? ((DataFile)pf).getTime() : new Time(pf.getStart());
        double dt = pf.getDelta();
        double size = pf.getSize();
        Object xf = pf instanceof DataFile ? pf : "ECR";
        return this.toFileEntries(t0, Time.add(t0, dt * (size - 1.0)), dt, xf);
    }

    public final Table toFileRecDefs() {
        boolean hasACC;
        Table recDefs = new Table();
        String coordSys = this.transform.getCoordinateSystem();
        boolean hasPOS = this.db == null || this.iPos >= 0;
        boolean hasVEL = this.db == null || this.iVel >= 0;
        boolean bl = hasACC = this.db == null || this.iAcc >= 0;
        if (this.data != null && !this.data.isEmpty()) {
            Table tbl = (Table)this.data.get(0);
            hasPOS = tbl.containsKey("X");
            hasVEL = tbl.containsKey("VX");
            hasACC = tbl.containsKey("AX");
        }
        if (hasPOS) {
            recDefs.put("POS", (Object)FileUtil.recDef("POS", "VD", null, coordSys, this.transform.getPosUnits()));
        }
        if (hasVEL) {
            recDefs.put("VEL", (Object)FileUtil.recDef("VEL", "VD", null, coordSys, this.transform.getVelUnits()));
        }
        if (hasACC) {
            recDefs.put("ACC", (Object)FileUtil.recDef("ACC", "VD", null, coordSys, this.transform.getAccUnits()));
        }
        recDefs.put("TIME", (Object)FileUtil.recDef("TIME", "SD", null, "SCALAR", "TIME_S"));
        return recDefs;
    }

    public DataFile getDataFile() {
        return this.inFile instanceof DataFile ? (DataFile)this.inFile : null;
    }

    public final void setInterpolationOrder(String order) {
        if (StringUtil.isNull(order)) {
            this.setInterpolationOrder((InterpolationOrder)null);
        } else {
            this.setInterpolationOrder(Util.valueOf(InterpolationOrder.class, order));
        }
    }

    public void setInterpolationOrder(InterpolationOrder order) {
        this.interpolationOrder = order;
        this.process();
    }

    public InterpolationOrder getInterpolationOrder() {
        return this.interpolationOrder;
    }

    @Override
    public void process() {
        if (this.data == null && this.db == null) {
            this.alt = 0.0;
            this.lat = 0.0;
            this.lon = 0.0;
            this.az = 0.0;
            this.ay = 0.0;
            this.ax = 0.0;
            this.vz = 0.0;
            this.vy = 0.0;
            this.vx = 0.0;
            this.z = 0.0;
            this.y = 0.0;
            this.x = 0.0;
            return;
        }
        double[] pva = this.db != null ? StateVector.getPosVelAccAtTime(this.getDataFile(), this.t, this.db, false, this.interpolationOrder) : StateVector.getPosVelAccAtTime(this.data, this.currentTime, this.transform, false, this.interpolationOrder);
        double[] p = new double[]{pva[0], pva[1], pva[2]};
        double[] v = new double[]{pva[3], pva[4], pva[5]};
        double[] a = new double[]{pva[6], pva[7], pva[8]};
        this.setCar(p, v, a);
    }

    public static double[] getPosVelAccAtTime(DataFile df, double time, Data db, boolean convertToLLA) {
        return StateVector.getPosVelAccAtTime(df, time, db, convertToLLA, InterpolationOrder.CubicHermite);
    }

    public static double[] getPosVelAccAtTime(DataFile df, double time, Data db, boolean convertToLLA, InterpolationOrder order) {
        int off;
        int iAccOff;
        double[] pva = new double[9];
        double[] p = new double[3];
        double[] v = new double[3];
        double[] a = new double[3];
        if (db == null) {
            df.open();
            int dfSize = (int)df.size;
            db = df.getDataBuffer(dfSize);
            int ndo = (int)df.avail();
            df.read(db, ndo);
            df.close();
        }
        double offset = (time - df.getXStart()) / df.getXDelta();
        int size = (int)df.getSize();
        int iVel = df.findRec("VEL");
        int iAcc = df.findRec("ACC");
        int iPos = df.findRec("POS");
        int iPosOff = iPos < 0 ? -1 : (int)df.getCompOffset(iPos);
        int iVelOff = iVel < 0 ? -1 : (int)df.getCompOffset(iVel);
        int n = iAccOff = iAcc < 0 ? -1 : (int)df.getCompOffset(iAcc);
        if (offset < 0.0) {
            offset = 0.0;
        }
        if (offset > (double)(size - 1)) {
            offset = size - 1;
        }
        if ((double)(off = (int)offset) == offset) {
            int k = off * db.bpe;
            p = StateVector.unpack(k, iPosOff, db, p);
            v = StateVector.unpack(k, iVelOff, db, v);
            a = StateVector.unpack(k, iAccOff, db, a);
        } else {
            int off0 = off;
            int off1 = off + 1;
            if ((double)off1 == df.getSize()) {
                --off0;
                --off1;
            }
            int k0 = off0 * db.bpe;
            int k1 = off1 * db.bpe;
            double[] p0 = StateVector.unpack(k0, iPosOff, db, null);
            double[] v0 = StateVector.unpack(k0, iVelOff, db, null);
            double[] a0 = StateVector.unpack(k0, iAccOff, db, null);
            double[] p1 = StateVector.unpack(k1, iPosOff, db, null);
            double[] v1 = StateVector.unpack(k1, iVelOff, db, null);
            double[] a1 = StateVector.unpack(k1, iAccOff, db, null);
            double t0 = df.getXStart() + df.getXDelta() * (double)off0;
            double t1 = df.getXStart() + df.getXDelta() * (double)off1;
            StateVector.interpolate(p0, v0, a0, t0, p1, v1, a1, t1, p, v, a, time, 3, order);
        }
        if (convertToLLA) {
            Transform transform = new Transform(df);
            transform.toLonLatAlt(p, 1);
        }
        pva[0] = p[0];
        pva[1] = p[1];
        pva[2] = p[2];
        pva[3] = v[0];
        pva[4] = v[1];
        pva[5] = v[2];
        pva[6] = a[0];
        pva[7] = a[1];
        pva[8] = a[2];
        return pva;
    }

    private static double[] unpack(int off, int boff, Data db, double[] def) {
        if (boff < 0) {
            return def;
        }
        int k = off + boff;
        return new double[]{db.unpackD(k + 0), db.unpackD(k + 8), db.unpackD(k + 16)};
    }

    private static double[] unpack(String x, String y, String z, Table row, double[] def) {
        if (!row.containsKey(x)) {
            return def;
        }
        return new double[]{row.getD(x), row.getD(y), row.getD(z)};
    }

    public static double[] getPosVelAccAtTime(List<Table> data, Time time, Transform transform, boolean convertToLLA, InterpolationOrder order) {
        Table row0;
        Table table;
        int cmp;
        double[] pva = new double[9];
        double[] p = new double[3];
        double[] v = new double[3];
        double[] a = new double[3];
        int off0 = -1;
        int off1 = 0;
        Iterator<Table> iterator = data.iterator();
        while (iterator.hasNext() && (cmp = time.compareTo(Time.toTime((table = iterator.next()).getO("TIME")))) >= 0) {
            ++off0;
            if (cmp == 0) break;
            ++off1;
        }
        if (off0 == -1) {
            ++off0;
        }
        if (off1 == data.size()) {
            --off1;
        }
        if (off0 == off1) {
            row0 = data.get(off0);
            p = StateVector.unpack("X", "Y", "Z", row0, p);
            v = StateVector.unpack("VX", "VY", "VZ", row0, v);
            a = StateVector.unpack("AX", "AY", "AZ", row0, v);
        } else {
            row0 = data.get(off0);
            Table row1 = data.get(off1);
            Time t0 = Time.toTime(row0.get("TIME"));
            Time t1 = Time.toTime(row1.get("TIME"));
            double[] p0 = StateVector.unpack("X", "Y", "Z", row0, null);
            double[] v0 = StateVector.unpack("VX", "VY", "VZ", row0, null);
            double[] a0 = StateVector.unpack("AX", "AY", "AZ", row0, null);
            double[] p1 = StateVector.unpack("X", "Y", "Z", row1, null);
            double[] v1 = StateVector.unpack("VX", "VY", "VZ", row1, null);
            double[] a1 = StateVector.unpack("AX", "AY", "AZ", row1, null);
            StateVector.interpolate(p0, v0, a0, t0, p1, v1, a1, t1, p, v, a, time, 3, order);
        }
        if (convertToLLA) {
            transform.toLonLatAlt(p, 1);
        }
        pva[0] = p[0];
        pva[1] = p[1];
        pva[2] = p[2];
        pva[3] = v[0];
        pva[4] = v[1];
        pva[5] = v[2];
        pva[6] = a[0];
        pva[7] = a[1];
        pva[8] = a[2];
        return pva;
    }

    @Override
    public String toString() {
        return "SVPos(x " + this.x + ",y " + this.y + ",z " + this.z + ",vx " + this.vx + ",vy " + this.vy + ",vz " + this.vz + ",ax " + this.ax + ",ay " + this.ay + ",az " + this.az + ",vu " + this.vu + ",ve " + this.ve + ",vn " + this.vn + ",au " + this.au + ",ae " + this.ae + ",an " + this.an + ",t " + this.t + ", lon " + this.lon + ",lat " + this.lat + ",alt " + this.alt + ")";
    }

    public boolean setTimeCode(double value) {
        return this.setCurrentTime(new Time(value));
    }

    public double getTimeCode() {
        return this.getCurrentTime().getSec();
    }

    public void setHeadingSpeed(double heading, double speed) {
        double mLat;
        double mLon;
        if (speed == 0.0) {
            this.setVel(0.0, 0.0, 0.0);
            return;
        }
        if (heading >= 360.0) {
            heading %= 360.0;
        }
        double deg = heading % 90.0;
        double rad = deg * (Math.PI / 180);
        if (heading < 90.0) {
            mLon = speed * Math.sin(rad);
            mLat = speed * Math.cos(rad);
        } else if (heading < 180.0) {
            mLon = speed * Math.cos(rad);
            mLat = -speed * Math.sin(rad);
        } else if (heading < 270.0) {
            mLon = -speed * Math.sin(rad);
            mLat = -speed * Math.cos(rad);
        } else {
            mLon = -speed * Math.cos(rad);
            mLat = speed * Math.sin(rad);
        }
        double dLon = mLon * 8.983152841195214E-6;
        double dLat = mLat * 8.983152841195214E-6;
        Position p = Position.fromGeo(this.getAlt(), this.getLat() + dLat, this.getLon() + dLon);
        this.setVel(p.getX() - this.getX(), p.getY() - this.getY(), p.getZ() - this.getZ());
    }

    public void setHeadingSpeedGeodetic(double heading, double speed) {
        if (speed == 0.0) {
            this.setVel(0.0, 0.0, 0.0);
            return;
        }
        if (heading >= 360.0) {
            heading %= 360.0;
        }
        double rad = Math.PI / 180 * heading;
        double e = Math.sin(rad) * speed;
        double n = Math.cos(rad) * speed;
        double u = 0.0;
        this.setVelGeo(e, n, u);
        if (this.referenceFrame == 0) {
            Transform.geo2car(this);
        }
    }

    public void setCar(double[] pos, double[] vel, double[] acc) {
        if (pos != null) {
            this.setCar(pos);
        } else {
            this.setCar(0.0, 0.0, 0.0);
        }
        if (vel != null) {
            this.setVel(vel);
        } else {
            this.setVel(0.0, 0.0, 0.0);
        }
        if (acc != null) {
            this.setAcc(acc);
        } else {
            this.setAcc(0.0, 0.0, 0.0);
        }
    }

    public void setVel(double[] vel) {
        this.setVel(vel[0], vel[1], vel[2]);
    }

    public void setVelCar(double[] vel) {
        this.setVelCar(vel[0], vel[1], vel[2]);
    }

    public void setVelGeo(double[] vel) {
        this.setVelGeo(vel[0], vel[1], vel[2]);
    }

    public void setVel(double vx, double vy, double vz) {
        this.vx = vx;
        this.vy = vy;
        this.vz = vz;
    }

    public void setVelCar(double vx, double vy, double vz) {
        this.vx = vx;
        this.vy = vy;
        this.vz = vz;
    }

    public void setVelGeo(double ve, double vn, double vu) {
        this.ve = ve;
        this.vn = vn;
        this.vu = vu;
    }

    public void setVX(double val) {
        this.vx = val;
    }

    public void setVY(double val) {
        this.vy = val;
    }

    public void setVZ(double val) {
        this.vz = val;
    }

    public void setAX(double val) {
        this.ax = val;
    }

    public void setAY(double val) {
        this.ay = val;
    }

    public void setAZ(double val) {
        this.az = val;
    }

    public void setVN(double val) {
        this.vn = val;
    }

    public void setVE(double val) {
        this.ve = val;
    }

    public void setVU(double val) {
        this.vu = val;
    }

    public void setAN(double val) {
        this.an = val;
    }

    public void setAE(double val) {
        this.ae = val;
    }

    public void setAU(double val) {
        this.au = val;
    }

    @Override
    public double getVX() {
        return this.vx;
    }

    @Override
    public double getVY() {
        return this.vy;
    }

    @Override
    public double getVZ() {
        return this.vz;
    }

    @Override
    public double getAX() {
        return this.ax;
    }

    @Override
    public double getAY() {
        return this.ay;
    }

    @Override
    public double getAZ() {
        return this.az;
    }

    @Override
    public double getVN() {
        return this.vn;
    }

    @Override
    public double getVE() {
        return this.ve;
    }

    @Override
    public double getVU() {
        return this.vu;
    }

    @Override
    public double getAN() {
        return this.an;
    }

    @Override
    public double getAE() {
        return this.ae;
    }

    @Override
    public double getAU() {
        return this.au;
    }

    public void setAcc(double[] acc) {
        this.setAcc(acc[0], acc[1], acc[2]);
    }

    public void setAcc(double ax, double ay, double az) {
        this.ax = ax;
        this.ay = ay;
        this.az = az;
    }

    public void setAccCar(double ax, double ay, double az) {
        this.ax = ax;
        this.ay = ay;
        this.az = az;
    }

    public void setAccCar(double[] acc) {
        this.setAccCar(acc[0], acc[1], acc[2]);
    }

    public void setAccGeo(double ae, double an, double au) {
        this.ae = ae;
        this.an = an;
        this.au = au;
    }

    public void setAccGeo(double[] acc) {
        this.setAccGeo(acc[0], acc[1], acc[2]);
    }

    @Override
    public String[] getKeys() {
        return keys;
    }

    @Override
    public Object setKey(String name, Object value) {
        if (name.equals("VX")) {
            this.setVX(Convert.o2d(value));
        } else if (name.equals("VY")) {
            this.setVY(Convert.o2d(value));
        } else if (name.equals("VZ")) {
            this.setVZ(Convert.o2d(value));
        } else if (name.equals("VE")) {
            this.setVE(Convert.o2d(value));
        } else if (name.equals("VN")) {
            this.setVN(Convert.o2d(value));
        } else if (name.equals("VU")) {
            this.setVU(Convert.o2d(value));
        } else if (name.equals("AX")) {
            this.setAX(Convert.o2d(value));
        } else if (name.equals("AY")) {
            this.setAY(Convert.o2d(value));
        } else if (name.equals("AZ")) {
            this.setAZ(Convert.o2d(value));
        } else if (name.equals("AE")) {
            this.setAE(Convert.o2d(value));
        } else if (name.equals("AN")) {
            this.setAN(Convert.o2d(value));
        } else if (name.equals("AU")) {
            this.setAU(Convert.o2d(value));
        } else {
            return super.setKey(name, value);
        }
        return value;
    }

    @Override
    public Object getKey(String name) {
        if (name.equals("VX")) {
            return Convert.d2o(this.getVX());
        }
        if (name.equals("VY")) {
            return Convert.d2o(this.getVY());
        }
        if (name.equals("VZ")) {
            return Convert.d2o(this.getVZ());
        }
        if (name.equals("VE")) {
            return Convert.d2o(this.getVE());
        }
        if (name.equals("VN")) {
            return Convert.d2o(this.getVN());
        }
        if (name.equals("VU")) {
            return Convert.d2o(this.getVU());
        }
        if (name.equals("AX")) {
            return Convert.d2o(this.getAX());
        }
        if (name.equals("AY")) {
            return Convert.d2o(this.getAY());
        }
        if (name.equals("AZ")) {
            return Convert.d2o(this.getAZ());
        }
        if (name.equals("AE")) {
            return Convert.d2o(this.getAE());
        }
        if (name.equals("AN")) {
            return Convert.d2o(this.getAN());
        }
        if (name.equals("AU")) {
            return Convert.d2o(this.getAU());
        }
        return super.getKey(name);
    }

    public static void interpolate(double[] p0, double[] v0, double[] a0, double t0, double[] p1, double[] v1, double[] a1, double t1, double[] p, double[] v, double[] a, double t, int dim) {
        StateVector.interpolate(p0, v0, a0, t0, p1, v1, a1, t1, p, v, a, t, dim, InterpolationOrder.CubicHermite);
    }

    public static void interpolate(double[] p0, double[] v0, double[] a0, double t0, double[] p1, double[] v1, double[] a1, double t1, double[] p, double[] v, double[] a, double t, int dim, InterpolationOrder order) {
        if (t0 > t1) {
            throw new IllegalArgumentException("Given value of t0=" + t0 + " exceeds t1=" + t1);
        }
        if (p0 == null || p1 == null) {
            throw new NullPointerException("Position vector can not be null");
        }
        if (v0 == null != (v1 == null)) {
            throw new NullPointerException("One of the velocity vectors was null");
        }
        if (a0 == null != (a1 == null)) {
            throw new NullPointerException("One of the velocity vectors was null");
        }
        if (v0 == null && a0 != null) {
            throw new NullPointerException("Velocity vector null, but acceleration given");
        }
        if (t <= t0) {
            System.arraycopy(p0, 0, p, 0, dim);
            System.arraycopy(v0, 0, v, 0, dim);
            System.arraycopy(a0, 0, a, 0, dim);
            return;
        }
        if (t >= t1) {
            System.arraycopy(p1, 0, p, 0, dim);
            System.arraycopy(v1, 0, v, 0, dim);
            System.arraycopy(a1, 0, a, 0, dim);
            return;
        }
        if (order == null) {
            order = InterpolationOrder.QuinticHermite;
        }
        double t1t0 = t1 - t0;
        double dt = t - t0;
        double tt = dt / t1t0;
        if (order == InterpolationOrder.Linear) {
            if (v0 == null) {
                for (int i = 0; i < dim; ++i) {
                    p[i] = p0[i] + (p1[i] - p0[i]) * tt;
                }
            } else if (a0 == null) {
                for (int i = 0; i < dim; ++i) {
                    v[i] = v0[i] + (v1[i] - v0[i]) * tt;
                    p[i] = p0[i] + (p1[i] - p0[i]) * tt;
                }
            } else {
                for (int i = 0; i < dim; ++i) {
                    a[i] = a0[i] + (a1[i] - a0[i]) * tt;
                    v[i] = v0[i] + (v1[i] - v0[i]) * tt;
                    p[i] = p0[i] + (p1[i] - p0[i]) * tt;
                }
            }
        } else if (order == InterpolationOrder.CubicHermite) {
            double tt2 = tt * tt;
            double tt3 = tt * tt2;
            double h00 = 2.0 * tt3 - 3.0 * tt2 + 1.0;
            double h10 = tt3 - 2.0 * tt2 + tt;
            double h01 = -2.0 * tt3 + 3.0 * tt2;
            double h11 = tt3 - tt2;
            if (v0 == null) {
                for (int i = 0; i < dim; ++i) {
                    double vel_t1t0 = p1[i] - p0[i];
                    p[i] = h00 * p0[i] + h10 * vel_t1t0 + h01 * p1[i] + h11 * vel_t1t0;
                }
            } else if (a0 == null) {
                for (int i = 0; i < dim; ++i) {
                    double acc_t1t0 = v1[i] - v0[i];
                    v[i] = h00 * v0[i] + h10 * acc_t1t0 + h01 * v1[i] + h11 * acc_t1t0;
                    p[i] = h00 * p0[i] + h10 * v0[i] * t1t0 + h01 * p1[i] + h11 * v1[i] * t1t0;
                }
            } else {
                for (int i = 0; i < dim; ++i) {
                    double jerk_t1t0 = a1[i] - a0[i];
                    a[i] = h00 * a0[i] + h10 * jerk_t1t0 + h01 * a1[i] + h11 * jerk_t1t0;
                    v[i] = h00 * v0[i] + h10 * a0[i] * t1t0 + h01 * v1[i] + h11 * a1[i] * t1t0;
                    p[i] = h00 * p0[i] + h10 * v0[i] * t1t0 + h01 * p1[i] + h11 * v1[i] * t1t0;
                }
            }
        } else if (order == InterpolationOrder.QuinticHermite) {
            double tt2 = tt * tt;
            double tt3 = tt * tt2;
            double tt4 = tt * tt3;
            double tt5 = tt * tt4;
            double h0 = -6.0 * tt5 + 15.0 * tt4 - 10.0 * tt3 + 1.0;
            double h1 = -3.0 * tt5 + 8.0 * tt4 - 6.0 * tt3 + tt;
            double h2 = -0.5 * tt5 + 1.5 * tt4 - 1.5 * tt3 + 0.5 * tt2;
            double h3 = 0.5 * tt5 - tt4 + 0.5 * tt3;
            double h4 = -3.0 * tt5 + 7.0 * tt4 - 4.0 * tt3;
            double h5 = 6.0 * tt5 - 15.0 * tt4 + 10.0 * tt3;
            if (v0 == null) {
                for (int i = 0; i < dim; ++i) {
                    double vel_t1t0 = p1[i] - p0[i];
                    p[i] = h0 * p0[i] + h1 * vel_t1t0 + 0.0 + 0.0 + h4 * vel_t1t0 + h5 * p1[i];
                }
            } else if (a0 == null) {
                for (int i = 0; i < dim; ++i) {
                    double acc_t1t0 = v1[i] - v0[i];
                    v[i] = h0 * v0[i] + h1 * acc_t1t0 + 0.0 + 0.0 + h4 * acc_t1t0 + h5 * v1[i];
                    p[i] = h0 * p0[i] + h1 * v0[i] * t1t0 + h2 * acc_t1t0 + h3 * acc_t1t0 + h4 * v1[i] * t1t0 + h5 * p1[i];
                }
            } else {
                for (int i = 0; i < dim; ++i) {
                    double jerk_t1t0 = a1[i] - a0[i];
                    a[i] = h0 * a0[i] + h1 * jerk_t1t0 + 0.0 + 0.0 + h4 * jerk_t1t0 + h5 * a1[i];
                    v[i] = h0 * v0[i] + h1 * a0[i] * t1t0 + h2 * jerk_t1t0 + h3 * jerk_t1t0 + h4 * a1[i] * t1t0 + h5 * v1[i];
                    p[i] = h0 * p0[i] + h1 * v0[i] * t1t0 + h2 * a0[i] * t1t0 + h3 * a1[i] * t1t0 + h4 * v1[i] * t1t0 + h5 * p1[i];
                }
            }
        } else {
            throw new AssertionError((Object)("Unknown InterpolationOrder " + (Object)((Object)order)));
        }
    }

    public static void interpolate(double[] p0, double[] v0, double[] a0, Time t0, double[] p1, double[] v1, double[] a1, Time t1, double[] p, double[] v, double[] a, Time t, int dim, InterpolationOrder order) {
        StateVector.interpolate(p0, v0, a0, 0.0, p1, v1, a1, t1.diff(t0), p, v, a, t.diff(t0), dim, order);
    }

    public static Table computeMeasurements(Position a, Position b, double rf, Table tbl, boolean shortNames) {
        return StateVector.computeMeasurements(a, b, rf, tbl, shortNames, null, -1.0);
    }

    public static Table computeMeasurements(Position a, Position b, double rf, Table tbl, boolean shortNames, Time time, double tol) {
        double delay;
        double range;
        double dpz;
        double dpy;
        double dpx;
        if (tbl == null) {
            tbl = new Table();
        }
        if (tol == -1.0) {
            tol = 1.0E-6;
        }
        if (tol != -2.0) {
            tol = Math.max(tol, 1.0E-12);
        }
        Time timeA = time == null ? null : new Time(time);
        Time timeB = time == null ? null : time;
        double lastStep = 0.0;
        if (time != null) {
            b.setCurrentTime(timeB);
        }
        while (true) {
            double step;
            double dt;
            double err;
            if (time != null) {
                a.setCurrentTime(timeA);
            }
            if (a.referenceFrame == 1) {
                a.geo2car();
            }
            if (b.referenceFrame == 1) {
                b.geo2car();
            }
            dpx = b.getX() - a.getX();
            dpy = b.getY() - a.getY();
            dpz = b.getZ() - a.getZ();
            range = Math.sqrt(dpx * dpx + dpy * dpy + dpz * dpz);
            delay = range * 3.3356409519815204E-9;
            if (time == null || tol == -2.0 || (err = (dt = timeB.diff(timeA)) - delay) >= -tol && err <= tol) break;
            if (lastStep == 0.0) {
                step = err;
            } else if (err > 0.0) {
                step = Math.max(err / 2.0, tol / 2.0);
                if (lastStep < 0.0 && step > -lastStep / 2.0) {
                    step = -lastStep / 2.0;
                }
            } else {
                step = Math.min(err / 2.0, -tol / 2.0);
                if (lastStep > 0.0 && step < -lastStep / 2.0) {
                    step = -lastStep / 2.0;
                }
            }
            lastStep = step;
            timeA.addSec(step);
        }
        double dvx = b.getVX() - a.getVX();
        double dvy = b.getVY() - a.getVY();
        double dvz = b.getVZ() - a.getVZ();
        double rangeRate = range == 0.0 ? Math.sqrt(dvx * dvx + dvy * dvy + dvz * dvz) : (dpx * dvx + dpy * dvy + dpz * dvz) / range;
        double doppler = rangeRate * rf * 3.3356409519815204E-9;
        double spreadFact = 0.07957747154594767 / (range * range);
        double azimuth = Math.atan2(dpy, dpx) * 57.29577951308232;
        double elevation = range == 0.0 ? 0.0 : Math.asin(dpz / range) * 57.29577951308232;
        tbl.put("RANGE", range);
        tbl.put("RANGE_RATE", rangeRate);
        tbl.put("DELTA_T", delay);
        tbl.put("DELTA_F", doppler);
        tbl.put("SPREAD_FACTOR", spreadFact);
        tbl.put("AZIMUTH_ANGLE", azimuth);
        tbl.put("ELEVATION_ANGLE", elevation);
        if (shortNames) {
            tbl.put("R", range);
            tbl.put("RR", rangeRate);
            tbl.put("DELT", delay);
            tbl.put("DELF", doppler);
            tbl.put("SPRF", spreadFact);
            tbl.put("AZ", azimuth);
            tbl.put("EL", elevation);
        }
        return tbl;
    }

    private void putWithUnits(Map<String, Object> kwds, String key, double val, int units) {
        this.putWithUnits(kwds, 'D', key, new Data(val), units);
    }

    private void putWithUnits(Map<String, Object> kwds, char type, String key, Data val, int units) {
        kwds.put(type + ":" + key, val);
        kwds.put("B:" + key + ".UNITS", new Data(units));
    }

    private Time getCurrentTime(Table e) {
        Time time = Time.toTime(e.get("CURRENTTIME"));
        if (time == null) {
            return this.convertTimeToCurrentTime(Time.toTime(e.get("TIME")));
        }
        return this.convertTimeToCurrentTime(time);
    }

    private Time convertTimeToCurrentTime(Time t) {
        if (t.getSec() < 3.1536E7) {
            return new Time(t.getSec() + this.getStartTime().getSec());
        }
        return new Time(t.getSec());
    }

    public static enum InterpolationOrder {
        Linear,
        CubicHermite,
        QuinticHermite;

    }
}

