/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import nxm.sys.inc.InternalUseOnly;

public class Stack
implements Serializable {
    private static final long serialVersionUID = 2011031000291L;
    private int maxObjects;
    private Object[] objects;
    private int pushpos;
    private int peekpos;
    private int lastpeekpos;
    @InternalUseOnly
    public static final String UNSERIALIZABLE_STACK_OBJECT_MESSAGE = "nxm.sys.lib.Stack only Serializable if all objects added to stack are Serializable";

    public Stack() {
        this(32);
    }

    public Stack(Stack stack) {
        this.maxObjects = stack.maxObjects;
        this.objects = (Object[])stack.objects.clone();
        this.pushpos = stack.pushpos;
        this.peekpos = stack.peekpos;
        this.lastpeekpos = stack.lastpeekpos;
    }

    public Stack(int maximum) {
        this.maxObjects = maximum;
        this.lastpeekpos = 0;
        this.peekpos = 0;
        this.pushpos = 0;
        this.objects = new Object[this.maxObjects];
    }

    public void clear() {
        this.lastpeekpos = 0;
        this.peekpos = 0;
        this.pushpos = 0;
    }

    public void push(Object obj) {
        this.objects[this.pushpos] = obj;
        this.pushpos = (this.pushpos + 1) % this.maxObjects;
        this.objects[this.pushpos] = null;
        this.peekpos = this.pushpos;
    }

    public Object pop() {
        if (this.pushpos == 0) {
            return null;
        }
        return this.objects[--this.pushpos];
    }

    public Object peek(int code) {
        Object retval;
        switch (code) {
            case -1: {
                if (this.peekpos != this.pushpos && this.objects[this.peekpos] == null) break;
                --this.peekpos;
                break;
            }
            case 1: {
                if (this.peekpos == this.pushpos) break;
                ++this.peekpos;
                break;
            }
            case -2: {
                if (this.lastpeekpos != this.pushpos && this.objects[this.peekpos] == null) break;
                this.peekpos = this.lastpeekpos - 1;
                break;
            }
            case 2: {
                if (this.lastpeekpos == this.pushpos) break;
                this.peekpos = this.lastpeekpos + 1;
                break;
            }
            default: {
                this.peekpos = this.pushpos - 1;
            }
        }
        this.peekpos = (this.peekpos + this.maxObjects) % this.maxObjects;
        if (code != 0) {
            this.lastpeekpos = this.peekpos;
        }
        if ((retval = this.objects[this.peekpos]) == null) {
            this.peekpos = this.pushpos;
        }
        return retval;
    }

    public Object peek() {
        this.peekpos = this.pushpos;
        int pos = (this.peekpos - 1 + this.maxObjects) % this.maxObjects;
        return this.objects[pos];
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        try {
            oos.defaultWriteObject();
        }
        catch (NotSerializableException nse) {
            throw new UnsupportedOperationException(UNSERIALIZABLE_STACK_OBJECT_MESSAGE, nse);
        }
    }
}

