/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nxm.sys.inc.ListFile;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.Tablizable;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Data;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public final class Sp3File
extends BaseFile
implements ListFile {
    private char version;
    private char type;
    private Time startTime;
    private int numEpochs;
    private String dataUsed;
    private String coordSys;
    private String orbitType;
    private String agency;
    private int gpsWeek;
    private double gpsSoW;
    private double epochInt;
    private double mjd;
    private String[] satID;
    private double[] satAccuracy;
    private String[] comments;
    private final Map<String, List<SP3Entry>> entries = new LinkedHashMap<String, List<SP3Entry>>();
    private String selected;

    public Sp3File() {
    }

    @Deprecated
    public Sp3File(Object ref, Object filename) {
        super(ref, filename);
    }

    public Sp3File(MidasReference ref, Object filename) {
        super(ref, filename);
    }

    @Override
    public String getMimeType() {
        return "text/plain";
    }

    @Override
    public boolean open() {
        if (super.open()) {
            if (this.isInput) {
                this.readFile();
            }
            this.setInternals();
        }
        return this.isOpen;
    }

    @Override
    public String toString() {
        return "Sp3File " + (this.io != null ? this.io.getTypeString() : "") + " Resource";
    }

    @Override
    public String listHeader() {
        StringBuilder str = new StringBuilder();
        String _comments = StringUtil.join(this.getComments(), "\n                  ");
        String _type = "";
        switch (this.getType()) {
            case 'P': {
                _type = " (POS)";
                break;
            }
            case 'V': {
                _type = " (POS+VEL)";
            }
        }
        str.append("Sp3File         : ").append(this.getURL()).append('\n');
        str.append("Version         : ").append(this.getVersion()).append('\n');
        str.append("Type            : ").append(this.getType()).append(_type).append('\n');
        str.append("Start Time      : ").append(this.getStartTime()).append('\n');
        str.append("Number Epochs   : ").append(this.getNumEpochs()).append('\n');
        str.append("Data Used       : ").append(this.getDataUsed()).append('\n');
        str.append("Coord. System   : ").append(this.getCoordSys()).append('\n');
        str.append("Orbit Type      : ").append(this.getOrbitType()).append('\n');
        str.append("Agency          : ").append(this.getAgency()).append('\n');
        str.append("GPS Week        : ").append(this.getGpsWeek()).append('\n');
        str.append("GPS Sec-of-Week : ").append(this.getGpsSoW()).append('\n');
        str.append("Epoch Interval  : ").append(this.getEpochInt()).append(" sec\n");
        str.append("Mod Julian Day  : ").append(this.getMJD()).append('\n');
        str.append("Vehicle Count   : ").append(this.getVehicleCount()).append('\n');
        str.append("Comment         : ").append(_comments).append('\n');
        return str.toString();
    }

    @Override
    public String listElements(double start, int elem, String format, int flags) {
        if (start >= (double)this.getNumEpochs()) {
            return null;
        }
        return "" + this.getDataTable(start) + "\n";
    }

    @Override
    public int listElementsPerLine(int lineWidth, String format, int flags) {
        return 1;
    }

    public char getVersion() {
        return this.version;
    }

    public char getType() {
        return this.type;
    }

    public Time getStartTime() {
        return this.startTime;
    }

    public int getNumEpochs() {
        return this.numEpochs;
    }

    public String getDataUsed() {
        return this.dataUsed;
    }

    public String getCoordSys() {
        return this.coordSys;
    }

    public String getOrbitType() {
        return this.orbitType;
    }

    public String getAgency() {
        return this.agency;
    }

    public int getGpsWeek() {
        return this.gpsWeek;
    }

    public double getGpsSoW() {
        return this.gpsSoW;
    }

    public double getEpochInt() {
        return this.epochInt;
    }

    public double getMJD() {
        return this.mjd;
    }

    public int getVehicleCount() {
        return this.satID.length;
    }

    public String[] getVehicleIDs() {
        return (String[])this.satID.clone();
    }

    public String[] getComments() {
        return (String[])this.comments.clone();
    }

    @Override
    public String getComment() {
        return StringUtil.join(this.getComments(), "\n");
    }

    public String getSelected() {
        return this.selected != null ? this.selected : this.satID[0];
    }

    public void setSelected(String id) {
        this.selected = id;
    }

    @Override
    public Table getDataTable(double offset) {
        int row = (int)offset;
        String id = this.getSelected();
        return this.entries.get(id).get(row).toTable();
    }

    @Override
    public int getRecordDefCount() {
        switch (this.type) {
            case 'P': {
                return 3;
            }
            case 'V': {
                return 5;
            }
        }
        return 0;
    }

    @Override
    public Table getRecordDefs() {
        Table recDefs = new Table();
        for (int i = 0; i < this.getRecordDefCount(); ++i) {
            Table def = this.getRecordDef(i);
            recDefs.put(def.getS("NAME"), (Object)def);
        }
        return recDefs;
    }

    @Override
    public Table getRecordDef(int i) {
        switch (this.type + i) {
            case 80: 
            case 86: {
                return FileUtil.recDef("POS", "VD", null, "CARTESIAN", "DISTANCE_M");
            }
            case 87: {
                return FileUtil.recDef("VEL", "VD", null, "CARTESIAN", "SPEED_M_S");
            }
            case 81: 
            case 88: {
                return FileUtil.recDef("TIME", "SD", null, "SCALAR", "TIME_S");
            }
            case 82: 
            case 89: {
                return FileUtil.recDef("CLKR", "SD", null, "SCALAR", "TIME_S");
            }
            case 90: {
                return FileUtil.recDef("CROC", "SD", null, "SCALAR", "DIMENSIONLESS");
            }
        }
        return null;
    }

    @Override
    public double getSize() {
        return this.getNumEpochs();
    }

    @Override
    public double getOffset() {
        return this.getSize();
    }

    @Override
    public double seek() {
        return this.getSize();
    }

    @Override
    public double avail() {
        return 0.0;
    }

    @Override
    public boolean isReady(double b) {
        return false;
    }

    @Override
    public double getNumberOfRows() {
        return this.getNumEpochs();
    }

    @Override
    public boolean getProtected() {
        return true;
    }

    @Override
    public int setData(double o, Table t) {
        throw this.readonly();
    }

    @Override
    public void setData(double o, String n, Object v) {
        throw this.readonly();
    }

    @Override
    public void insertData(double o, Object v) {
        throw this.readonly();
    }

    @Override
    public void removeData(double o) {
        throw this.readonly();
    }

    @Override
    public void removeData(double o, long c) {
        throw this.readonly();
    }

    @Override
    public void setRecordDefs(Table d) {
        throw this.readonly();
    }

    @Override
    public void update() {
        throw this.readonly();
    }

    private MidasException readonly() {
        return new MidasException("Sp3File " + this.getName() + " is read only.");
    }

    private MidasException error(int lineNum, String msg) {
        return new MidasException("Error on line " + lineNum + " of " + this.getName() + ": " + msg);
    }

    private void readFile() {
        int lineNum = 0;
        if (this.isOpen) {
            try {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(this.io.getInputStream()));
                while (lineNum < 22) {
                    ++lineNum;
                    line = in.readLine();
                    if (line == null) {
                        throw this.error(lineNum, "Missing header information.");
                    }
                    if (lineNum == 1) {
                        if (!line.startsWith("#a")) {
                            throw this.error(lineNum, "Invalid file format or version.");
                        }
                        if (line.length() != 60) {
                            throw this.error(lineNum, "Invalid line length.");
                        }
                        String year = line.substring(3, 7);
                        String mon = line.substring(8, 10).replace(' ', '0');
                        String day = line.substring(11, 13).replace(' ', '0');
                        String hour = line.substring(14, 16).replace(' ', '0');
                        String min = line.substring(17, 19).replace(' ', '0');
                        String sec = line.substring(20, 31).replace(' ', '0');
                        String time = year + ":" + mon + ":" + day + "::" + hour + ":" + min + ":" + sec;
                        this.version = line.charAt(1);
                        this.type = line.charAt(2);
                        this.startTime = new Time(time);
                        this.numEpochs = Integer.parseInt(line.substring(32, 39).trim());
                        this.dataUsed = line.substring(40, 45).trim();
                        this.coordSys = line.substring(46, 51).trim();
                        this.orbitType = line.substring(52, 55).trim();
                        this.agency = line.substring(56, 60).trim();
                        continue;
                    }
                    if (lineNum == 2) {
                        if (!line.startsWith("##")) {
                            throw this.error(lineNum, "Invalid syntax.");
                        }
                        if (line.length() != 60) {
                            throw this.error(lineNum, "Invalid line length.");
                        }
                        this.gpsWeek = Integer.parseInt(line.substring(3, 7).trim());
                        this.gpsSoW = Double.parseDouble(line.substring(8, 23).trim());
                        this.epochInt = Double.parseDouble(line.substring(24, 38).trim());
                        this.mjd = (double)Integer.parseInt(line.substring(39, 44).trim()) + Double.parseDouble(line.substring(45, 60).trim());
                        continue;
                    }
                    if (lineNum <= 7) {
                        if (!line.startsWith("+ ")) {
                            throw this.error(lineNum, "Invalid syntax.");
                        }
                        if (line.length() != 60) {
                            throw this.error(lineNum, "Invalid line length.");
                        }
                        if (lineNum == 3) {
                            int numSC = Integer.parseInt(line.substring(4, 6).trim());
                            this.satID = new String[numSC];
                            this.satAccuracy = new double[numSC];
                        }
                        int off = (lineNum - 3) * 17;
                        for (int i = 9; i < 60 && off < this.satID.length; i += 3) {
                            this.satID[off++] = line.substring(i, i + 3).trim();
                        }
                        continue;
                    }
                    if (lineNum <= 12) {
                        if (!line.startsWith("++")) {
                            throw this.error(lineNum, "Invalid syntax.");
                        }
                        if (line.length() != 60) {
                            throw this.error(lineNum, "Invalid line length.");
                        }
                        int off = (lineNum - 3) * 17;
                        for (int i = 9; i < 60 && off < this.satID.length; i += 3) {
                            int accuracy = Integer.parseInt(line.substring(i, i + 3).trim());
                            this.satAccuracy[off++] = Math.pow(2.0, accuracy) * 0.001;
                        }
                        continue;
                    }
                    if (lineNum <= 14) {
                        if (!line.startsWith("%c")) {
                            throw this.error(lineNum, "Invalid syntax.");
                        }
                        if (line.length() == 60) continue;
                        throw this.error(lineNum, "Invalid line length.");
                    }
                    if (lineNum <= 16) {
                        if (!line.startsWith("%f")) {
                            throw this.error(lineNum, "Invalid syntax.");
                        }
                        if (line.length() == 60) continue;
                        throw this.error(lineNum, "Invalid line length.");
                    }
                    if (lineNum <= 18) {
                        if (!line.startsWith("%i")) {
                            throw this.error(lineNum, "Invalid syntax.");
                        }
                        if (line.length() == 60) continue;
                        throw this.error(lineNum, "Invalid line length.");
                    }
                    if (lineNum > 22) continue;
                    if (!line.startsWith("/*")) {
                        throw this.error(lineNum, "Invalid syntax.");
                    }
                    if (lineNum == 19) {
                        this.comments = new String[4];
                    }
                    this.comments[lineNum - 19] = line.substring(3).trim();
                }
                for (String id : this.satID) {
                    this.entries.put(id, new ArrayList(this.numEpochs));
                }
                for (int i = 0; i < this.numEpochs; ++i) {
                    ++lineNum;
                    line = in.readLine();
                    if (line == null || !line.startsWith("* ")) {
                        throw this.error(lineNum, "Missing epoch.");
                    }
                    String year = line.substring(3, 7);
                    String mon = line.substring(8, 10).replace(' ', '0');
                    String day = line.substring(11, 13).replace(' ', '0');
                    String hour = line.substring(14, 16).replace(' ', '0');
                    String min = line.substring(17, 19).replace(' ', '0');
                    String sec = line.substring(20, 31).replace(' ', '0');
                    String time = year + ":" + mon + ":" + day + "::" + hour + ":" + min + ":" + sec;
                    Time epoch = new Time(time);
                    for (int j = 0; j < this.satID.length; ++j) {
                        ++lineNum;
                        line = in.readLine();
                        if (line == null || !line.startsWith("P ")) {
                            throw this.error(lineNum, "Missing position.");
                        }
                        String id = line.substring(2, 4).trim();
                        SP3Entry entry = new SP3Entry(id, epoch);
                        entry.initPos(Double.parseDouble(line.substring(4, 18).trim()) * 1000.0, Double.parseDouble(line.substring(18, 32).trim()) * 1000.0, Double.parseDouble(line.substring(32, 46).trim()) * 1000.0, Double.parseDouble(line.substring(46, 60).trim()));
                        if (this.type == 'V') {
                            ++lineNum;
                            line = in.readLine();
                            if (line == null || !line.startsWith("V ")) {
                                throw this.error(lineNum, "Missing velocity.");
                            }
                            String idV = line.substring(2, 4).trim();
                            if (!id.equals(idV)) {
                                throw this.error(lineNum, "Missing velocity for '" + id + "'.");
                            }
                            entry.initVel(Double.parseDouble(line.substring(4, 18).trim()) * 0.1, Double.parseDouble(line.substring(18, 32).trim()) * 0.1, Double.parseDouble(line.substring(32, 46).trim()) * 0.1, Double.parseDouble(line.substring(46, 60).trim()));
                        }
                        this.entries.get(id).add(entry);
                    }
                }
            }
            catch (MidasException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MidasException("Error on line " + lineNum + " of " + this.getName() + ": " + e.getMessage(), e);
            }
        }
    }

    private final class SP3Entry
    implements Tablizable {
        private final String id;
        private final Time epoch;
        private final double[] pos;
        private final double[] vel;
        private Double clock;
        private Double rate;

        SP3Entry(String id, Time epoch) {
            this.id = id;
            this.epoch = epoch;
            this.pos = new double[3];
            this.vel = Sp3File.this.type == 'V' ? new double[3] : null;
        }

        void initPos(double x, double y, double z, double clock_us) {
            this.pos[0] = x;
            this.pos[1] = y;
            this.pos[2] = z;
            this.clock = (int)clock_us == 999999 ? null : Double.valueOf(clock_us * 1.0E-6);
        }

        void initVel(double x, double y, double z, double rate_us) {
            this.vel[0] = x;
            this.vel[1] = y;
            this.vel[2] = z;
            this.rate = (int)rate_us == 999999 ? null : Double.valueOf(rate_us * 1.0E-6);
        }

        public String toString() {
            return "SP3 Entry: " + this.toTable();
        }

        @Override
        public Table toTable() {
            Table tbl = new Table();
            tbl.put("ID", (Object)this.id);
            tbl.put("TIME", (Object)this.epoch);
            tbl.put("POS", (Object)new Data(this.pos));
            if (this.vel != null) {
                tbl.put("VEL", (Object)new Data(this.vel));
            }
            if (this.clock != null) {
                tbl.put("CLKR", (Object)this.clock);
            }
            if (this.rate != null) {
                tbl.put("CROC", (Object)this.rate);
            }
            return tbl;
        }
    }
}

