/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import nxm.sys.inc.Keyable;
import nxm.sys.lib.Convert;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Table;

public class Query {
    private Object obj;
    private int items;
    private int maxitems;
    private String[] keys;
    private String[] vals;
    private Method[] sets;
    private Method[] gets;
    private Method[] setS;
    private String propertyList;
    public Query parent;

    public Query(Object obj, String list3, int maxitems) {
        this.obj = obj;
        this.maxitems = maxitems;
        if (list3 != null && list3.length() > 0) {
            this.propertyList = list3;
        }
        this.keys = new String[maxitems];
        this.vals = new String[maxitems];
        this.sets = new Method[maxitems];
        this.gets = new Method[maxitems];
        this.setS = new Method[maxitems];
        this.parse();
    }

    public void parse() {
        this.items = 0;
        if (this.obj instanceof Table) {
            this.parseT();
        } else if (this.obj instanceof Hashtable) {
            this.parseHT();
        } else if (this.obj instanceof KeyVector) {
            this.parseKV();
        } else if (this.propertyList != null) {
            this.parseList(this.propertyList);
        } else {
            try {
                Field field = this.obj.getClass().getField("propertyList");
                String list3 = (String)field.get(this.obj);
                if (list3 == null) {
                    this.parseClass();
                } else {
                    this.parseList("Class," + list3);
                }
            }
            catch (Exception e) {
                this.parseClass();
            }
        }
    }

    private void parseClass() {
        Class<?> clas = this.obj.getClass();
        Method[] methods = clas.getMethods();
        for (int i = 0; i < methods.length && this.items < this.maxitems; ++i) {
            String name = methods[i].getName();
            if (name.length() <= 3 || !name.startsWith("get")) continue;
            String key = name.substring(3);
            if (methods[i].getParameterTypes().length > 0 || key.equals("Key") && this.obj instanceof Keyable) continue;
            this.gets[this.items] = methods[i];
            this.sets[this.items] = this.findSetMethod(key, i, methods);
            this.setS[this.items] = this.findSetStringMethod(key, i, methods);
            this.keys[this.items++] = key;
        }
        if (this.obj instanceof Keyable) {
            String[] keyables = ((Keyable)this.obj).getKeys();
            for (int i = 0; i < keyables.length; ++i) {
                String keyable = keyables[i];
                for (int j = 0; j < this.items && keyables != null; ++j) {
                    if (!keyable.equalsIgnoreCase(this.keys[i])) continue;
                    keyables = null;
                }
                if (keyables == null || this.items >= this.maxitems) continue;
                this.keys[this.items++] = keyable;
            }
        }
    }

    private void parseList(String list3) {
        Class<?> clas = this.obj.getClass();
        Method[] methods = clas.getMethods();
        Parser p = new Parser(list3);
        int i = 1;
        while (p.more() && this.items < this.maxitems) {
            String key = p.get(i);
            String getname = "get" + key;
            for (int j = 0; j < methods.length; ++j) {
                if (!getname.equals(methods[j].getName()) || methods[j].getParameterTypes().length != 0) continue;
                this.gets[this.items] = methods[j];
                this.sets[this.items] = this.findSetMethod(key, j, methods);
                this.keys[this.items++] = key;
                break;
            }
            ++i;
        }
    }

    private void parseT() {
        Table t = (Table)this.obj;
        Enumeration<String> e = t.keys();
        this.items = Math.min(this.maxitems, t.size());
        for (int i = 0; i < this.items; ++i) {
            this.keys[i] = e.nextElement();
        }
        Table tp = t.getPrevious();
        if (tp != null && this.items < this.maxitems) {
            this.keys[this.items++] = "getPrev";
        }
    }

    private void parseHT() {
        Hashtable ht = (Hashtable)this.obj;
        Enumeration e = ht.keys();
        this.items = Math.min(this.maxitems, ht.size());
        for (int i = 0; i < this.items; ++i) {
            this.keys[i] = (String)e.nextElement();
        }
    }

    private void parseKV() {
        KeyVector kv = (KeyVector)this.obj;
        this.items = Math.min(this.maxitems, kv.size());
        for (int i = 0; i < this.items; ++i) {
            this.keys[i] = kv.getKey(i);
        }
    }

    private Method findSetMethod(String key, int i, Method[] methods) {
        Class<?> ret = methods[i].getReturnType();
        String setName = "set" + key;
        for (int j = 0; j < methods.length; ++j) {
            Class<?>[] args;
            if (!setName.equals(methods[j].getName()) || (args = methods[j].getParameterTypes()).length != 1 || !ret.equals(args[0])) continue;
            return methods[j];
        }
        return null;
    }

    private Method findSetStringMethod(String key, int i, Method[] methods) {
        Class<?> ret = key.getClass();
        String setName = "set" + key;
        for (int j = 0; j < methods.length; ++j) {
            Class<?>[] args;
            if (!setName.equals(methods[j].getName()) || (args = methods[j].getParameterTypes()).length != 1 || !ret.equals(args[0])) continue;
            return methods[j];
        }
        return null;
    }

    public void evaluate() {
        for (int i = 0; i < this.items; ++i) {
            String value = "";
            Object object = this.getObject(i);
            if (object instanceof Hashtable) {
                value = "Hashtable of " + ((Hashtable)object).size() + " entries";
            } else if (object instanceof Table) {
                value = "Table of " + ((Table)object).size() + " entries";
            } else if (object instanceof KeyVector) {
                value = "KeyVector of " + ((KeyVector)object).size() + " entries";
            } else if (object != null) {
                value = object.toString();
            }
            this.vals[i] = value;
        }
    }

    public int getItems() {
        return this.items;
    }

    public String getName(int i) {
        return this.keys[i];
    }

    public String getValue(int i) {
        return this.vals[i];
    }

    public Method getGetMethod(int i) {
        return this.gets[i];
    }

    public Method getSetMethod(int i) {
        return this.sets[i];
    }

    public Method getSetStringMethod(int i) {
        return this.setS[i];
    }

    public Object getObject(String key) {
        for (int i = 0; i < this.items; ++i) {
            if (!key.equalsIgnoreCase(this.keys[i])) continue;
            return this.getObject(i);
        }
        return null;
    }

    public Object getObject(int i) {
        Object object = null;
        try {
            String key = this.keys[i];
            object = this.obj instanceof Table ? ((Table)this.obj).getKey(key) : (this.obj instanceof KeyVector ? ((KeyVector)this.obj).get(i) : (this.obj instanceof Hashtable ? ((Hashtable)this.obj).get(key) : (this.gets[i] != null ? this.gets[i].invoke(this.obj, (Object[])null) : (this.obj instanceof Keyable ? ((Keyable)this.obj).getKey(key) : null))));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public Object getObject() {
        return this.obj;
    }

    public void setObject(String key, Object value) {
        for (int i = 0; i < this.items; ++i) {
            if (!key.equalsIgnoreCase(this.keys[i])) continue;
            this.setObject(i, value);
        }
    }

    public void setObject(int i, Object value) {
        try {
            Object object = this.getObject(i);
            if (object instanceof String) {
                value = Convert.o2s(value);
            } else if (object instanceof Double) {
                value = Convert.o2d(value);
            } else if (object instanceof Float) {
                value = Float.valueOf(Convert.o2f(value));
            } else if (object instanceof Integer) {
                value = Convert.o2l(value);
            } else if (object instanceof Short) {
                value = Convert.o2i(value);
            } else if (object instanceof Byte) {
                value = Convert.o2b(value);
            }
            if (this.sets[i] != null) {
                Object[] args = new Object[]{value};
                if (value instanceof String && this.setS[i] != null) {
                    this.setS[i].invoke(this.obj, args);
                } else {
                    this.sets[i].invoke(this.obj, args);
                }
            } else if (this.obj instanceof Keyable) {
                ((Keyable)this.obj).setKey(this.keys[i], value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

