/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import nxm.sys.inc.MapKBT;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.inc.SpecialLoggingRequired;
import nxm.sys.lib.FileUtil;

@SpecialLoggingRequired
public class PropsUtilities {
    public static final String HOSTNAME;
    public static final String HOST;
    public static final String PID;
    public static final String SYSTEM_PROPS = "-- SYSTEM_PROPS --";
    public static final String REQUIRED_STRING;
    public static final Long REQUIRED_LONG;
    public static final Integer REQUIRED_INTEGER;
    public static final Double REQUIRED_DOUBLE;
    public static final Boolean REQUIRED_BOOLEAN;

    private PropsUtilities() {
    }

    public static Properties loadProps(String propsFile) {
        return PropsUtilities.loadProps(propsFile, null, null);
    }

    public static Properties loadProps(String propsFile, String defProps) {
        return PropsUtilities.loadProps(propsFile, null, defProps);
    }

    public static Properties loadProps(String propsFile, Properties defProps) {
        return PropsUtilities.loadProps(propsFile, defProps, null);
    }

    private static Properties loadProps(String propsFile, Properties defProps, String defPropsName) {
        if (defPropsName != null) {
            defProps = PropsUtilities.loadProps(defPropsName, null, null);
        }
        Props properties = new Props(defProps);
        if (propsFile != null && !propsFile.isEmpty()) {
            if (propsFile.equals(SYSTEM_PROPS)) {
                System.getProperties().stringPropertyNames().forEach(key -> properties.setProperty((String)key, System.getProperty(key)));
            } else {
                try (InputStream in = FileUtil.getInputStreamFor(propsFile);){
                    properties.load(in);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to load properties from '" + propsFile + "'", e);
                }
            }
        }
        return properties;
    }

    @ProvisionalUseOnly(value="API could change")
    public static Properties loadProps(MapKBT propMap) {
        Props properties = new Props();
        for (String key : propMap.getKeys()) {
            String value = propMap.get(key).toString();
            properties.setProperty(key, value);
        }
        return properties;
    }

    public static Properties extractProps(Properties props, String prefix, boolean keep) {
        Props p = new Props();
        int len = keep ? 0 : prefix.length();
        props.stringPropertyNames().forEach(name -> {
            if (name.startsWith(prefix)) {
                p.setProperty(name.substring(len), props.getProperty((String)name));
            }
        });
        return p;
    }

    public static <T> T getPropValue(Properties props, String name, T def) {
        return PropsUtilities.getPropValue(props, name, def, def.getClass(), false);
    }

    public static <T> T getPropValue(Properties props, String name, Class<T> type) {
        return PropsUtilities.getPropValue(props, name, null, type, false);
    }

    public static <T> T usePropValue(Properties props, String name, T def) {
        return PropsUtilities.getPropValue(props, name, def, def.getClass(), true);
    }

    public static <T> T usePropValue(Properties props, String name, Class<T> type) {
        return PropsUtilities.getPropValue(props, name, null, type, true);
    }

    private static <T> T getPropValue(Properties props, String name, T def, Class<T> type, boolean set) {
        String str = props.getProperty(name, null);
        if (str == null || str.isEmpty()) {
            if (def == REQUIRED_STRING || def == REQUIRED_LONG || def == REQUIRED_INTEGER || def == REQUIRED_DOUBLE || def == REQUIRED_BOOLEAN) {
                throw new NullPointerException("Missing required property '" + name + "'");
            }
            if (set) {
                props.setProperty(name, def == null ? "" : def.toString());
            }
            return def;
        }
        try {
            Object val = null;
            if (type == String.class) {
                val = str;
            }
            if (type == Double.class) {
                val = Double.valueOf(str);
            }
            if (type == Float.class) {
                val = Float.valueOf(str);
            }
            if (type == Long.class) {
                val = Long.valueOf(str);
            }
            if (type == Integer.class) {
                val = Integer.valueOf(str);
            }
            if (type == Short.class) {
                val = Short.valueOf(str);
            }
            if (type == Byte.class) {
                val = Byte.valueOf(str);
            }
            if (type == Boolean.class) {
                val = Boolean.valueOf(str);
            }
            if (type == Character.class) {
                val = Character.valueOf(str.charAt(0));
            }
            if (Enum.class.isAssignableFrom(type)) {
                val = Enum.valueOf(type, str);
            }
            if (val != null) {
                if (set) {
                    props.setProperty(name, val.toString());
                }
                return type.cast(val);
            }
        }
        catch (IllegalArgumentException e) {
            NumberFormatException ex = new NumberFormatException("Invalid value for property '" + name + "', expected value of type " + type.getName() + " but given: " + str);
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
        throw new IllegalArgumentException("Invalid type: " + type);
    }

    private static boolean isIP(String addr) {
        if (addr.startsWith("[") && addr.endsWith("]")) {
            return true;
        }
        for (int i = 0; i < addr.length(); ++i) {
            char c = addr.charAt(0);
            if (c == '.' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    static {
        String hostname;
        String mxName = ManagementFactory.getRuntimeMXBean().getName();
        int i = mxName.indexOf(46);
        int j = mxName.indexOf(64);
        String name = i < 0 ? mxName : mxName.substring(0, i);
        String altHostname = j < 0 ? null : mxName.substring(j + 1);
        String pid = j < 0 ? "0000" : name.substring(0, j);
        try {
            InetAddress ia = InetAddress.getLocalHost();
            hostname = ia.getHostName();
        }
        catch (UnknownHostException e) {
            hostname = null;
        }
        if (hostname == null || hostname.isEmpty()) {
            hostname = altHostname;
        }
        if (altHostname != null && !altHostname.isEmpty() && !PropsUtilities.isIP(altHostname) && PropsUtilities.isIP(hostname)) {
            hostname = altHostname;
        }
        if (hostname == null || hostname.isEmpty() || hostname.equals("127.0.0.1")) {
            hostname = "localhost";
        }
        String host = (i = hostname.indexOf(46)) > 0 ? hostname.substring(0, i) : hostname;
        HOSTNAME = hostname;
        HOST = host;
        PID = pid;
        REQUIRED_STRING = String.valueOf("-- REQUIRED_STRING --");
        REQUIRED_LONG = Long.MIN_VALUE;
        REQUIRED_INTEGER = Integer.MIN_VALUE;
        REQUIRED_DOUBLE = Double.NaN;
        REQUIRED_BOOLEAN = false;
    }

    public static class Props
    extends Properties {
        private static final long serialVersionUID = 4112578634029874840L;

        public Props() {
        }

        public Props(Properties defaults) {
            super(defaults);
        }

        @Override
        public final String getProperty(String key, String def) {
            return super.getProperty(key, def);
        }

        @Override
        public String getProperty(String key) {
            String value = super.getProperty(key);
            if (value == null) {
                switch (key) {
                    case "HOME": {
                        return this.getProperty("user.home");
                    }
                    case "HOST": {
                        return HOST;
                    }
                    case "HOSTNAME": {
                        return HOSTNAME;
                    }
                    case "PID": {
                        return PID;
                    }
                    case "USER": {
                        return this.getProperty("user.name");
                    }
                }
                return null;
            }
            return this.resolve(value);
        }

        private String resolve(String value) {
            int i = value.indexOf("${");
            if (i < 0) {
                return value;
            }
            int j = -1;
            int n = 1;
            block4: for (int ii = i + 2; j < 0 && ii < value.length(); ++ii) {
                switch (value.charAt(ii)) {
                    case '{': {
                        ++n;
                        continue block4;
                    }
                    case '}': {
                        if (--n != 0) continue block4;
                        j = ii;
                    }
                }
            }
            if (j < 0) {
                return value;
            }
            String tag = value.substring(i + 2, j);
            String val = this.getProperty(tag, "${" + tag + "}");
            return value.substring(0, i) + val + this.resolve(value.substring(j + 1));
        }
    }
}

