/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.File;
import java.util.HashMap;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.inc.ShellParent;
import nxm.sys.lib.Command;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.Terminal;

@ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
public class MatLab
implements ShellParent {
    private Shell shell;
    private boolean opened;
    private Terminal terminal;

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public MatLab() {
        Shell.setPriv(-1);
        System.setProperty("NOEXTERNAL", "TRUE");
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public MatLab(String nmroot, String home, String nonat) {
        this();
        System.setProperty("NMROOT", nmroot + "/");
        System.setProperty("HOME", home + "/");
        System.setProperty("NONATIVE", nonat);
        this.opened = false;
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public void open() {
        this.terminal = new MatLabTerminal();
        this.shell = new Shell(this);
        this.shell.open();
        String fname = this.shell.M.io.getName("SYS", "CFG", "nmstartup", "mm");
        File file = new File(fname);
        if (file.exists()) {
            this.runCommand("%nmstartup,/MFN=" + fname);
        }
        if ((file = new File(fname = this.shell.M.io.getName("AUX", "HOME", "nmstartup", "mm"))).exists()) {
            this.runCommand("%nmstartup,/MFN=" + fname);
        }
        this.opened = true;
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public boolean isOpen() {
        return this.opened;
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public String[] getNmOpts() {
        String path = (String)this.shell.M.results.get("OPT.PATH");
        String[] out = path.split(",");
        for (int m = 0; m < out.length; ++m) {
            String cur = this.shell.M.io.name("", "", "", out[m]);
            int ind = cur.indexOf("/nxm/");
            out[m] = ind > 0 ? cur.substring(0, ind) : cur;
        }
        return out;
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public HashMap<String, String> getResult(String rn) {
        Object res = this.shell.M.results.get(rn);
        HashMap<String, String> out = new HashMap<String, String>();
        if (res instanceof Table) {
            Table tbl = (Table)res;
            String[] keys = tbl.getKeys();
            for (int m = 0; m < keys.length; ++m) {
                out.put(keys[m], tbl.get(keys[m]).toString());
            }
        } else {
            out.put(rn, res.toString());
        }
        return out;
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public String runCommand(String cmdline) {
        Command cmd = Shell.runCommand(this.shell.M, cmdline, null, null);
        return cmd.getStatus();
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public void close() {
        this.opened = false;
    }

    @Override
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public String getNmRoot() {
        return Shell.getProperty("NMROOT");
    }

    @Override
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public String getHome() {
        return Shell.getProperty("HOME");
    }

    @Override
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public Terminal getTerminal() {
        return this.terminal;
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public Shell getShell() {
        return this.shell;
    }

    @Override
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public String getNMS() {
        return null;
    }

    @Override
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public String getAux() {
        return null;
    }

    @Override
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public String getOpts() {
        return null;
    }

    @Override
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public String getCWD() {
        return null;
    }

    @Override
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public String getServer() {
        return null;
    }

    @Override
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public String getTheme() {
        return null;
    }

    @Override
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public String getStyle() {
        return null;
    }

    private static class MatLabTerminal
    extends Terminal {
        private MatLabTerminal() {
        }

        @Override
        @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
        public String getInput(String prompt, String seed, int flags) {
            return seed == null ? "" : seed;
        }
    }
}

