/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.regex.Pattern;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;

public class MaskValue<E extends Enum<E>>
implements Cloneable {
    private static final Pattern SEPARATOR = Pattern.compile("[,|]");
    protected final Class<E> type;
    protected boolean isFinal;
    protected int value;
    private final int bitMask;

    protected MaskValue(Class<E> type) {
        this.type = type;
        this.bitMask = 0;
    }

    private MaskValue(Class<E> type, int len) {
        int bm = 0;
        for (int i = 0; i < len; ++i) {
            bm |= 1 << i;
        }
        this.type = type;
        this.bitMask = bm;
    }

    public MaskValue<E> clone() {
        try {
            return (MaskValue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)("Could not clone instance of " + this.getClass()));
        }
    }

    public MaskValue<E> copy() {
        Object mv = this.clone();
        ((MaskValue)mv).isFinal = false;
        return mv;
    }

    public static <E extends Enum<E>> MaskValue<E> forType(Class<E> type, E ... values) {
        int len = ((Enum[])type.getEnumConstants()).length;
        MaskValue mv = len <= 32 ? new MaskValue(type, len) : (len <= 64 ? new MaskValueLong(type, len) : new MaskValueBitSet(type, len));
        for (E v : values) {
            mv.set(v);
        }
        return mv;
    }

    public static <E extends Enum<E>> MaskValue<E> forLegacyField(Object legacyObject, String legacyField, Class<E> type, E ... values) {
        Field f;
        try {
            f = legacyObject.getClass().getField(legacyField);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can not access field " + legacyField + " in " + legacyObject);
        }
        return MaskValue.forLegacyField((Object)legacyObject, (Field)f, type, values);
    }

    public static <E extends Enum<E>> MaskValue<E> forLegacyField(Object legacyObject, Field legacyField, Class<E> type, E ... values) {
        MaskValue mv;
        int len = ((Enum[])type.getEnumConstants()).length;
        if (len <= 32) {
            mv = new MaskValueLegacy32(legacyObject, legacyField, type, len);
        } else if (len <= 64) {
            mv = new MaskValueLegacy64(legacyObject, legacyField, type, len);
        } else {
            throw new IllegalArgumentException("Legacy mask values only support 64 flags.");
        }
        for (E v : values) {
            mv.set(v);
        }
        return mv;
    }

    public static <E extends Enum<E>> MaskValue<E> with(E ... values) {
        return MaskValue.forType(values[0].getClass(), values);
    }

    public static <E extends Enum<E>> MaskValue<E> constant(Class<E> type, E ... values) {
        MaskValue mv = MaskValue.forType(type, values);
        mv.isFinal = true;
        return mv;
    }

    public static <E extends Enum<E>> MaskValue<E> constant(E ... values) {
        MaskValue mv = MaskValue.with(values);
        mv.isFinal = true;
        return mv;
    }

    public static final <E extends Enum<E>> MaskValue<E> fromString(CharSequence maskStr, Class<E> type) {
        MaskValue mv = MaskValue.forType(type, (Enum[])new Enum[0]);
        mv.setValue(maskStr, mv);
        return mv;
    }

    public static final <E extends Enum<E>> MaskValue<E> fromString(CharSequence maskStr, MaskValue<E> current, MaskValue<E> def) {
        MaskValue<E> mv = current == null ? def.copy() : current.copy();
        mv.setValue(maskStr, def);
        return mv;
    }

    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof MaskValue)) {
            return false;
        }
        MaskValue mv = (MaskValue)obj;
        return mv.type == this.type && mv.value == this.value;
    }

    public synchronized int hashCode() {
        return this.value;
    }

    public synchronized String toString() {
        StringBuilder str = new StringBuilder("|");
        for (Enum flag : (Enum[])this.type.getEnumConstants()) {
            if (!this.isSet(flag)) continue;
            str.append(flag).append('|');
        }
        return str.toString();
    }

    public synchronized boolean isSet(E flag) {
        return (this.value & 1 << ((Enum)flag).ordinal()) != 0;
    }

    public synchronized void set(E flag) {
        if (this.isFinal) {
            throw new ConstantValueException();
        }
        this.value |= 1 << ((Enum)flag).ordinal();
    }

    public synchronized void unset(E flag) {
        if (this.isFinal) {
            throw new ConstantValueException();
        }
        this.value &= ~(1 << ((Enum)flag).ordinal());
    }

    public synchronized void toggle(E flag) {
        if (this.isFinal) {
            throw new ConstantValueException();
        }
        this.value ^= 1 << ((Enum)flag).ordinal();
    }

    public synchronized boolean isSet(MaskValue<E> mv) {
        return (this.value & mv.value) == mv.value;
    }

    public synchronized void set(MaskValue<E> mv) {
        if (this.isFinal) {
            throw new ConstantValueException();
        }
        this.value |= mv.value;
    }

    public synchronized void unset(MaskValue<E> mv) {
        if (this.isFinal) {
            throw new ConstantValueException();
        }
        this.value &= ~mv.value;
    }

    public synchronized void toggle(MaskValue<E> mv) {
        if (this.isFinal) {
            throw new ConstantValueException();
        }
        this.value ^= mv.value;
    }

    public synchronized void setValue(MaskValue<E> mv) {
        if (this.isFinal) {
            throw new ConstantValueException();
        }
        this.value = mv.value;
    }

    public synchronized void setAll() {
        if (this.isFinal) {
            throw new ConstantValueException();
        }
        this.value = this.bitMask;
    }

    public synchronized void setNone() {
        if (this.isFinal) {
            throw new ConstantValueException();
        }
        this.value = 0;
    }

    private final E fromString(String str) throws IllegalArgumentException {
        Enum[] enums = (Enum[])this.type.getEnumConstants();
        ArrayList<Enum> validEnumValues = new ArrayList<Enum>();
        for (Enum e : enums) {
            if (!e.toString().equals(str)) continue;
            return (E)e;
        }
        for (Enum e : enums) {
            String enumStr = e.toString();
            if (enumStr.equalsIgnoreCase(str)) {
                return (E)e;
            }
            boolean isInternalUseOnly = false;
            try {
                isInternalUseOnly = e.getClass().getField(enumStr).isAnnotationPresent(InternalUseOnly.class);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (isInternalUseOnly) continue;
            validEnumValues.add(e);
        }
        throw new IllegalArgumentException("Mask value '" + str + "' not found in " + validEnumValues + "");
    }

    public final void setValue(E flag, boolean on) {
        if (on) {
            this.set(flag);
        } else {
            this.unset(flag);
        }
    }

    public final void setValue(String flag, boolean on) {
        this.setValue(this.fromString(flag), on);
    }

    public final boolean getValue(E flag) {
        return this.isSet(flag);
    }

    public final boolean getValue(String flag) {
        return this.isSet(flag);
    }

    public final boolean isSet(String flag) {
        return this.isSet(this.fromString(flag));
    }

    public final void set(String flag) {
        this.set(this.fromString(flag));
    }

    public final void unset(String flag) {
        this.unset(this.fromString(flag));
    }

    public synchronized void toggle(String flag) {
        this.toggle(this.fromString(flag));
    }

    public final void setValue(MaskValue<E> mv, boolean on) {
        if (on) {
            this.set(mv);
        } else {
            this.unset(mv);
        }
    }

    public final boolean getValue(MaskValue<E> mv) {
        return this.isSet(mv);
    }

    public final synchronized void setValue(CharSequence maskStr, MaskValue<E> def) {
        if (maskStr == null) {
            maskStr = "DEFAULT";
        }
        if (StringUtil.isHexInteger(maskStr.toString())) {
            this.setHexValue(Convert.o2l(maskStr));
            Shell.deprecate("Use of HEX for mask values is deprected, use " + this + " in place of " + maskStr);
            return;
        }
        String[] tokens = SEPARATOR.split(maskStr);
        if (tokens.length == 0) {
            this.setNone();
            return;
        }
        block5: for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i == 0) {
                if (token.equalsIgnoreCase("DEFAULT")) {
                    this.setValue(def);
                    continue;
                }
                if (token.equalsIgnoreCase("DEF")) {
                    this.setValue(def);
                    continue;
                }
                if (token.equalsIgnoreCase("ALL")) {
                    this.setAll();
                    continue;
                }
                if (token.equalsIgnoreCase("NONE")) {
                    this.setNone();
                    continue;
                }
                if (token.equalsIgnoreCase("")) {
                    this.setNone();
                    continue;
                }
            }
            if (token.length() == 0) continue;
            char op = token.charAt(0);
            if (i == 0 && op != '+' && op != '-' && op != '~') {
                this.setNone();
            }
            switch (op) {
                case '+': {
                    this.set(token.substring(1));
                    continue block5;
                }
                case '-': {
                    this.unset(token.substring(1));
                    continue block5;
                }
                case '~': {
                    this.toggle(token.substring(1));
                    continue block5;
                }
                default: {
                    this.set(token);
                }
            }
        }
    }

    public final synchronized void setHexValue(int val) {
        if (((Enum[])this.type.getEnumConstants()).length > 32) {
            throw new UnsupportedOperationException("Can not get hex mask value for " + this.type);
        }
        this.value = val & this.bitMask;
    }

    public final synchronized int getHexValue() {
        if (((Enum[])this.type.getEnumConstants()).length > 32) {
            throw new UnsupportedOperationException("Can not get hex mask value for " + this.type);
        }
        return this.value;
    }

    public static <E extends Enum<E>> int getHexValue(E value) {
        Class<?> type = value.getClass();
        if (type.getEnumConstants().length > 32) {
            throw new UnsupportedOperationException("Can not get hex mask value for " + type);
        }
        return 1 << value.ordinal();
    }

    private static final class MaskValueLegacy64<E extends Enum<E>>
    extends MaskValueLong<E> {
        private final Object legacyObject;
        private final Field legacyField;

        private MaskValueLegacy64(Object legacyObject, Field legacyField, Class<E> type, int len) {
            super(type, len);
            if (legacyField.getType() != Integer.TYPE) {
                throw new IllegalArgumentException("Only int fields can be used.");
            }
            try {
                this.legacyObject = legacyObject;
                this.legacyField = legacyField;
                this.val = 0xFFFFFFFFL & (long)legacyField.getInt(legacyObject);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can not access " + legacyField + " in " + legacyObject, e);
            }
        }

        private void getLegacy() {
            try {
                int legacyValue = this.legacyField.getInt(this.legacyObject);
                if ((int)this.val != legacyValue) {
                    Shell.warning("External changes to " + this.legacyObject + " made via " + this.legacyField + " this is deprecated.");
                    this.val = this.val & 0xFFFFFFFF00000000L | (long)legacyValue & 0xFFFFFFFFL;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Can not access " + this.legacyField + " in " + this.legacyObject, e);
            }
        }

        private void setLegacy() {
            try {
                this.legacyField.setInt(this.legacyObject, (int)this.val);
            }
            catch (Exception e) {
                throw new RuntimeException("Can not access " + this.legacyField + " in " + this.legacyObject, e);
            }
        }

        @Override
        public synchronized boolean equals(Object obj) {
            this.getLegacy();
            return super.equals(obj);
        }

        @Override
        public synchronized int hashCode() {
            this.getLegacy();
            return super.hashCode();
        }

        @Override
        public synchronized boolean isSet(E flag) {
            this.getLegacy();
            return super.isSet(flag);
        }

        @Override
        public synchronized boolean isSet(MaskValue<E> mv) {
            this.getLegacy();
            return super.isSet(mv);
        }

        @Override
        public synchronized void setAll() {
            super.setAll();
            this.setLegacy();
        }

        @Override
        public synchronized void setNone() {
            super.setNone();
            this.setLegacy();
        }

        @Override
        public synchronized void set(E flag) {
            this.getLegacy();
            super.set(flag);
            this.setLegacy();
        }

        @Override
        public synchronized void unset(E flag) {
            this.getLegacy();
            super.unset(flag);
            this.setLegacy();
        }

        @Override
        public synchronized void toggle(E flag) {
            this.getLegacy();
            super.toggle(flag);
            this.setLegacy();
        }

        @Override
        public synchronized void set(MaskValue<E> mv) {
            this.getLegacy();
            super.set(mv);
            this.setLegacy();
        }

        @Override
        public synchronized void unset(MaskValue<E> mv) {
            this.getLegacy();
            super.unset(mv);
            this.setLegacy();
        }

        @Override
        public synchronized void toggle(MaskValue<E> mv) {
            this.getLegacy();
            super.toggle(mv);
            this.setLegacy();
        }

        @Override
        public synchronized void setValue(MaskValue<E> mv) {
            super.setValue(mv);
            this.setLegacy();
        }
    }

    private static final class MaskValueLegacy32<E extends Enum<E>>
    extends MaskValue<E> {
        private final Object legacyObject;
        private final Field legacyField;

        private MaskValueLegacy32(Object legacyObject, Field legacyField, Class<E> type, int len) {
            super(type, len);
            if (legacyField.getType() != Integer.TYPE) {
                throw new IllegalArgumentException("Only int fields can be used.");
            }
            try {
                this.legacyObject = legacyObject;
                this.legacyField = legacyField;
                this.value = legacyField.getInt(legacyObject);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can not access " + legacyField + " in " + legacyObject, e);
            }
        }

        private void getLegacy() {
            try {
                int legacyValue = this.legacyField.getInt(this.legacyObject);
                if (this.value != legacyValue) {
                    Shell.warning("External changes to " + this.legacyObject + " made via " + this.legacyField + " this is deprecated.");
                    this.value = legacyValue;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Can not access " + this.legacyField + " in " + this.legacyObject, e);
            }
        }

        private void setLegacy() {
            try {
                this.legacyField.setInt(this.legacyObject, this.value);
            }
            catch (Exception e) {
                throw new RuntimeException("Can not access " + this.legacyField + " in " + this.legacyObject, e);
            }
        }

        @Override
        public synchronized boolean equals(Object obj) {
            this.getLegacy();
            return super.equals(obj);
        }

        @Override
        public synchronized int hashCode() {
            this.getLegacy();
            return super.hashCode();
        }

        @Override
        public synchronized boolean isSet(E flag) {
            this.getLegacy();
            return super.isSet(flag);
        }

        @Override
        public synchronized boolean isSet(MaskValue<E> mv) {
            this.getLegacy();
            return super.isSet(mv);
        }

        @Override
        public synchronized void setAll() {
            super.setAll();
            this.setLegacy();
        }

        @Override
        public synchronized void setNone() {
            super.setNone();
            this.setLegacy();
        }

        @Override
        public synchronized void set(E flag) {
            this.getLegacy();
            super.set(flag);
            this.setLegacy();
        }

        @Override
        public synchronized void unset(E flag) {
            this.getLegacy();
            super.unset(flag);
            this.setLegacy();
        }

        @Override
        public synchronized void toggle(E flag) {
            this.getLegacy();
            super.toggle(flag);
            this.setLegacy();
        }

        @Override
        public synchronized void set(MaskValue<E> mv) {
            this.getLegacy();
            super.set(mv);
            this.setLegacy();
        }

        @Override
        public synchronized void unset(MaskValue<E> mv) {
            this.getLegacy();
            super.unset(mv);
            this.setLegacy();
        }

        @Override
        public synchronized void toggle(MaskValue<E> mv) {
            this.getLegacy();
            super.toggle(mv);
            this.setLegacy();
        }

        @Override
        public synchronized void setValue(MaskValue<E> mv) {
            super.setValue(mv);
            this.setLegacy();
        }
    }

    private static final class MaskValueBitSet<E extends Enum<E>>
    extends MaskValue<E> {
        private final BitSet bs;
        private final int len;

        private MaskValueBitSet(Class<E> type, int len) {
            super(type);
            this.bs = new BitSet(len);
            this.len = len;
        }

        @Override
        public synchronized boolean equals(Object obj) {
            if (!(obj instanceof MaskValueBitSet)) {
                return false;
            }
            MaskValueBitSet mvbs = (MaskValueBitSet)obj;
            return mvbs.type == this.type && this.bs.equals(mvbs.bs);
        }

        @Override
        public synchronized int hashCode() {
            return this.bs.hashCode();
        }

        @Override
        public synchronized void setAll() {
            if (this.isFinal) {
                throw new ConstantValueException();
            }
            this.bs.set(0, this.len, true);
        }

        @Override
        public synchronized void setNone() {
            if (this.isFinal) {
                throw new ConstantValueException();
            }
            this.bs.clear();
        }

        @Override
        public synchronized boolean isSet(E flag) {
            return this.bs.get(((Enum)flag).ordinal());
        }

        @Override
        public synchronized void set(E flag) {
            if (this.isFinal) {
                throw new ConstantValueException();
            }
            this.bs.set(((Enum)flag).ordinal());
        }

        @Override
        public synchronized void unset(E flag) {
            if (this.isFinal) {
                throw new ConstantValueException();
            }
            this.bs.clear(((Enum)flag).ordinal());
        }

        @Override
        public synchronized void toggle(E flag) {
            if (this.isFinal) {
                throw new ConstantValueException();
            }
            this.bs.flip(((Enum)flag).ordinal());
        }

        @Override
        public synchronized boolean isSet(MaskValue<E> mv) {
            MaskValueBitSet mvbs = (MaskValueBitSet)mv;
            BitSet temp = this.bs.get(0, this.bs.length());
            temp.and(mvbs.bs);
            return temp.equals(mvbs.bs);
        }

        @Override
        public synchronized void set(MaskValue<E> mv) {
            if (this.isFinal) {
                throw new ConstantValueException();
            }
            MaskValueBitSet mvbs = (MaskValueBitSet)mv;
            this.bs.or(mvbs.bs);
        }

        @Override
        public synchronized void unset(MaskValue<E> mv) {
            if (this.isFinal) {
                throw new ConstantValueException();
            }
            MaskValueBitSet mvbs = (MaskValueBitSet)mv;
            this.bs.andNot(mvbs.bs);
        }

        @Override
        public synchronized void toggle(MaskValue<E> mv) {
            if (this.isFinal) {
                throw new ConstantValueException();
            }
            MaskValueBitSet mvbs = (MaskValueBitSet)mv;
            this.bs.xor(mvbs.bs);
        }

        @Override
        public synchronized void setValue(MaskValue<E> mv) {
            if (this.isFinal) {
                throw new ConstantValueException();
            }
            this.setNone();
            this.set(mv);
        }
    }

    private static class MaskValueLong<E extends Enum<E>>
    extends MaskValue<E> {
        protected long val;
        private final long bitMask;

        private MaskValueLong(Class<E> type, int len) {
            super(type);
            long bm = 0L;
            for (int i = 0; i < len; ++i) {
                bm |= 1L << i;
            }
            this.bitMask = bm;
        }

        @Override
        public synchronized boolean equals(Object obj) {
            if (!(obj instanceof MaskValueLong)) {
                return false;
            }
            MaskValueLong mvl = (MaskValueLong)obj;
            return mvl.type == this.type && mvl.val == this.val;
        }

        @Override
        public synchronized int hashCode() {
            return (int)(this.val >>> 32 ^ this.val);
        }

        @Override
        public synchronized void setAll() {
            if (this.isFinal) {
                throw new ConstantValueException();
            }
            this.val = this.bitMask;
        }

        @Override
        public synchronized void setNone() {
            if (this.isFinal) {
                throw new ConstantValueException();
            }
            this.val = 0L;
        }

        @Override
        public synchronized boolean isSet(E flag) {
            return (this.val & 1L << ((Enum)flag).ordinal()) != 0L;
        }

        @Override
        public synchronized void set(E flag) {
            if (this.isFinal) {
                throw new ConstantValueException();
            }
            this.val |= 1L << ((Enum)flag).ordinal();
        }

        @Override
        public synchronized void unset(E flag) {
            if (this.isFinal) {
                throw new ConstantValueException();
            }
            this.val &= 1L << ((Enum)flag).ordinal() ^ 0xFFFFFFFFFFFFFFFFL;
        }

        @Override
        public synchronized void toggle(E flag) {
            if (this.isFinal) {
                throw new ConstantValueException();
            }
            this.val ^= 1L << ((Enum)flag).ordinal();
        }

        @Override
        public synchronized boolean isSet(MaskValue<E> mv) {
            MaskValueLong mvl = (MaskValueLong)mv;
            return (this.val & mvl.val) == mvl.val;
        }

        @Override
        public synchronized void set(MaskValue<E> mv) {
            if (this.isFinal) {
                throw new ConstantValueException();
            }
            MaskValueLong mvl = (MaskValueLong)mv;
            this.val |= mvl.val;
        }

        @Override
        public synchronized void unset(MaskValue<E> mv) {
            if (this.isFinal) {
                throw new ConstantValueException();
            }
            MaskValueLong mvl = (MaskValueLong)mv;
            this.val &= mvl.val ^ 0xFFFFFFFFFFFFFFFFL;
        }

        @Override
        public synchronized void toggle(MaskValue<E> mv) {
            if (this.isFinal) {
                throw new ConstantValueException();
            }
            MaskValueLong mvl = (MaskValueLong)mv;
            this.val ^= mvl.val;
        }

        @Override
        public synchronized void setValue(MaskValue<E> mv) {
            if (this.isFinal) {
                throw new ConstantValueException();
            }
            MaskValueLong mvl = (MaskValueLong)mv;
            this.val = mvl.val;
        }
    }

    private static final class ConstantValueException
    extends UnsupportedOperationException {
        private static final long serialVersionUID = 2010061000290L;

        public ConstantValueException() {
            super("Can not modify a MaskValue created with MaskValue.constant(..)");
        }
    }
}

