/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import nxm.sys.lib.Data;
import nxm.sys.lib.MPULib;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;

public class MPULibNative
extends MPULib {
    protected long handle;

    public native long alloc();

    public native int setkey(long var1, String var3, byte[] var4, int var5);

    public native int getkey(long var1, String var3, byte[] var4, int var5);

    public native int init(long var1);

    public native int work(long var1, int var3);

    public native int work1(long var1, byte[] var3, int var4);

    public native int work2(long var1, byte[] var3, int var4, byte[] var5, int var6);

    public native int work3(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8);

    public native int free(long var1);

    public MPULibNative() {
        this.loadNative(this.getClass().getName());
    }

    public MPULibNative(String name) {
        this.loadNative(name);
    }

    public void loadNative(String libName) {
        boolean ok = Shell.loadLibrary(libName);
        if (!ok) {
            throw new MidasException("Problem with load of native library: " + libName);
        }
        this.handle = this.alloc();
        if (this.handle == 0L) {
            throw new MidasException("Problem with alloc of native library: " + libName);
        }
    }

    @Override
    public void set(String key, Data value) {
        int len;
        char ctype = (char)value.type;
        if (Data.isString(value.type)) {
            ctype = 'S';
        }
        if ((len = this.setkey(this.handle, ctype + ":" + key, value.buf, value.size * value.bpe)) <= 0) {
            super.set(key, value);
        }
    }

    @Override
    public Data get(String key, byte type) {
        byte[] buffer = new byte[256];
        char ctype = (char)type;
        int len = this.getkey(this.handle, ctype + ":" + key, buffer, buffer.length);
        if (type == 83) {
            type = (byte)65;
            while (len % 8 != 0) {
                buffer[len++] = 0;
            }
        }
        if (len > 0) {
            return new Data(buffer, 0, len, (int)type, 1);
        }
        return super.get(key, type);
    }

    @Override
    public int open() {
        return this.init(this.handle);
    }

    @Override
    public int process(int n) {
        return this.work(this.handle, n);
    }

    @Override
    public int process(byte[] buf1, int n1) {
        return this.work1(this.handle, buf1, n1);
    }

    @Override
    public int process(byte[] buf1, int n1, byte[] buf2, int n2) {
        return this.work2(this.handle, buf1, n1, buf2, n2);
    }

    @Override
    public int process(byte[] buf1, int n1, byte[] buf2, int n2, byte[] buf3, int n3) {
        return this.work3(this.handle, buf1, n1, buf2, n2, buf3, n3);
    }

    @Override
    public int close() {
        return this.free(this.handle);
    }
}

