/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.logging.Level;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MapKBT;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Data;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.LogUtilities;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;

@InternalUseOnly
public final class JsonUtilities {
    private static Type underlyingMap = LinkedHashMap.class;
    private static CharSequence tableDotSubstitute = "_";
    private static final Map<Class<?>, JsonObjectInfo<?>> jsonObjects = new WeakHashMap(64);
    private static final JsonEntry AUTO_ENTRY = new JsonEntry(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return JsonEntry.class;
        }

        @Override
        public String name() {
            return "";
        }

        @Override
        public boolean required() {
            return false;
        }

        @Override
        public boolean ignoreSet() {
            return false;
        }

        @Override
        public Class<?> type() {
            return Type.class;
        }

        @Override
        public Class<?> valtype() {
            return Object.class;
        }

        @Override
        public Class<?> keytype() {
            return String.class;
        }
    };
    public static final Mode MODE = Mode.valueOf(System.getProperty("JsonUtilities.MODE", "Auto"));
    public static final boolean ALLOW_IEEE754 = Boolean.valueOf(System.getProperty("JsonUtilities.ALLOW_IEEE754", "true"));
    public static final String MEDIA_TYPE = "application/json";
    public static final String FILE_EXT = ".json";

    private JsonUtilities() {
    }

    private static <T> JsonObjectInfo<T> getJsonObject(Class<T> clazz) {
        if (!jsonObjects.containsKey(clazz)) {
            JsonObject jo = clazz.getAnnotation(JsonObject.class);
            JsonObjectInfo<T> ji = jo == null ? null : new JsonObjectInfo<T>(clazz, jo);
            jsonObjects.put(clazz, ji);
        }
        return jsonObjects.get(clazz);
    }

    public static boolean isMediaTypeJSON(String mediaType) {
        return mediaType.equals(MEDIA_TYPE) || mediaType.equals("text/json");
    }

    public static CharSequence toJSON(Object obj) {
        return JsonUtilities.toJSON(obj, MODE);
    }

    public static CharSequence toJSON(Object obj, Mode mode) {
        StringBuilder str = new StringBuilder(128);
        return JsonUtilities.toJSON(str, "", obj, false, mode);
    }

    private static StringBuilder toJSON(StringBuilder str, String obj) {
        int i;
        if (obj.isEmpty()) {
            return str.append("\"\"");
        }
        char[] chars = obj.toCharArray();
        str.ensureCapacity(str.length() + chars.length + 2);
        str.append('\"');
        for (i = 0; i < chars.length && !Character.isISOControl(chars[i]); ++i) {
        }
        if (i == chars.length) {
            str.append(obj);
        } else {
            if (i != 0) {
                str.append(chars, 0, i);
            }
            block11: while (i < chars.length) {
                char c = chars[i++];
                switch (c) {
                    case '\"': {
                        str.append("\\\"");
                        continue block11;
                    }
                    case '\\': {
                        str.append("\\\\");
                        continue block11;
                    }
                    case '/': {
                        str.append('/');
                        continue block11;
                    }
                    case '\b': {
                        str.append("\\b");
                        continue block11;
                    }
                    case '\f': {
                        str.append("\\f");
                        continue block11;
                    }
                    case '\n': {
                        str.append("\\n");
                        continue block11;
                    }
                    case '\r': {
                        str.append("\\r");
                        continue block11;
                    }
                    case '\t': {
                        str.append("\\t");
                        continue block11;
                    }
                }
                if (!Character.isISOControl(c)) {
                    str.append(c);
                    continue;
                }
                str.append("\\u");
                str.append(JsonUtilities.hexChar(c >> 12));
                str.append(JsonUtilities.hexChar(c >> 8));
                str.append(JsonUtilities.hexChar(c >> 4));
                str.append(JsonUtilities.hexChar(c));
            }
        }
        str.append('\"');
        return str;
    }

    private static StringBuilder toJSON(StringBuilder str, String indent, Object obj, boolean inBlock, Mode mode) {
        String indent4;
        String indent2;
        String indent0;
        String newline;
        String space;
        JsonObjectInfo<?> jo;
        JsonObjectInfo<?> jsonObjectInfo = jo = obj == null ? null : JsonUtilities.getJsonObject(obj.getClass());
        if (jo != null) {
            obj = jo.toJSON(obj);
        }
        if (obj instanceof Data) {
            obj = ((Data)obj).toObject();
        }
        if (obj instanceof Number) {
            if (!ALLOW_IEEE754) {
                double d = ((Number)obj).doubleValue();
                if (Double.isNaN(d)) {
                    return str.append((String)null);
                }
                if (Double.isInfinite(d)) {
                    return str.append(Double.MAX_VALUE * Math.signum(d));
                }
            }
            return str.append(obj);
        }
        if (obj == null) {
            return str.append((String)null);
        }
        if (obj instanceof Boolean) {
            return str.append((Boolean)obj);
        }
        if (obj instanceof CharSequence) {
            return JsonUtilities.toJSON(str, obj.toString());
        }
        if (obj instanceof Character) {
            return JsonUtilities.toJSON(str, obj.toString());
        }
        if (obj instanceof Path) {
            return JsonUtilities.toJSON(str, obj.toString().replace('\\', '/'));
        }
        switch (mode) {
            case Auto: {
                StringBuilder s = new StringBuilder(80);
                s = JsonUtilities.toJSON(s, indent, obj, inBlock, Mode.Compact);
                if (s.length() < 80) {
                    return str.append((CharSequence)s);
                }
            }
            case FastAuto: {
                space = " ";
                newline = "\n";
                indent0 = indent;
                indent2 = indent + " ";
                indent4 = indent + "  ";
                break;
            }
            case Formal: {
                space = " ";
                newline = "\n";
                indent0 = indent;
                indent2 = indent + "  ";
                indent4 = indent + "    ";
                break;
            }
            case Compact: {
                space = "";
                newline = "";
                indent0 = "";
                indent2 = "";
                indent4 = "";
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown mode " + (Object)((Object)mode)));
            }
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            if (map.isEmpty()) {
                return str.append('{').append(space).append('}');
            }
            if (inBlock) {
                str.append(indent);
            }
            str.append('{').append(newline);
            int count = 0;
            for (Map.Entry e : map.entrySet()) {
                if (count > 0) {
                    str.append(',').append(newline);
                }
                str.append(indent2);
                if (e.getKey() == null) {
                    Midas.log("Map keys can not be null in JSON", 1);
                }
                JsonUtilities.toJSON(str, e.getKey().toString());
                str.append(space).append(':').append(space);
                JsonUtilities.toJSON(str, indent4, e.getValue(), false, mode);
                ++count;
            }
            return str.append(newline).append(indent0).append('}');
        }
        if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            if (len == 0) {
                return str.append('[').append(space).append(']');
            }
            if (inBlock) {
                str.append(indent);
            }
            str.append('[').append(newline).append(indent2);
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    str.append(',').append(newline);
                }
                JsonUtilities.toJSON(str, indent4, Array.get(obj, i), true, mode);
            }
            return str.append(newline).append(indent).append(']');
        }
        if (obj instanceof Iterable) {
            Iterable it = (Iterable)obj;
            if (inBlock) {
                str.append(indent);
            }
            str.append('[').append(newline);
            int count = 0;
            for (Object o : it) {
                if (count > 0) {
                    str.append(',').append(newline);
                }
                JsonUtilities.toJSON(str, indent4, o, true, mode);
                ++count;
            }
            return str.append(newline).append(indent0).append(']');
        }
        return JsonUtilities.toJSON(str, obj.toString());
    }

    private static boolean isOperator(char c) {
        return c == ':' || c == '[' || c == '{' || c == ',' || c == ']' || c == '}';
    }

    private static boolean isOperator(String s) {
        return s.length() == 1 && JsonUtilities.isOperator(s.charAt(0));
    }

    private static LinkedList<String> tokenize(String json) {
        LinkedList<String> tokens = new LinkedList<String>();
        int length = json.length();
        int start = -1;
        for (int i = 0; i < length; ++i) {
            char c = json.charAt(i);
            if (Character.isWhitespace(c)) {
                if (start >= 0) {
                    tokens.add(json.substring(start, i));
                }
                start = -1;
                continue;
            }
            if (JsonUtilities.isOperator(c)) {
                if (start >= 0) {
                    tokens.add(json.substring(start, i));
                }
                tokens.add(json.substring(i, i + 1));
                start = -1;
                continue;
            }
            if (start >= 0) continue;
            if (c == '\"') {
                start = i;
                while (start >= 0 && i < length) {
                    if ((c = json.charAt(++i)) == '\"') {
                        tokens.add(json.substring(start, i + 1));
                        start = -1;
                        continue;
                    }
                    if (c != '\\') continue;
                    if (i == length - 1) {
                        throw new IllegalArgumentException("Invalid JSON object, expected escape after '\\'");
                    }
                    ++i;
                }
                if (start < 0) continue;
                throw new IllegalArgumentException("Invalid JSON object, expected '\"'");
            }
            start = i;
        }
        if (start >= 0) {
            tokens.add(json.substring(start, length));
        }
        return tokens;
    }

    private static String _fromStr(String token) {
        if (!token.startsWith("\"") || !token.endsWith("\"")) {
            throw new IllegalArgumentException("Invalid JSON string, missing quote near '" + token + "'.");
        }
        if (token.indexOf(92) < 0) {
            return token.substring(1, token.length() - 1);
        }
        StringBuilder str = new StringBuilder(token.length());
        try {
            block17: for (int i = 1; i < token.length() - 1; ++i) {
                char c = token.charAt(i);
                if (c != '\\') {
                    str.append(c);
                    continue;
                }
                char c1 = token.charAt(++i);
                switch (c1) {
                    case '\"': {
                        str.append('\"');
                        continue block17;
                    }
                    case '\\': {
                        str.append('\\');
                        continue block17;
                    }
                    case '/': {
                        str.append('/');
                        continue block17;
                    }
                    case 'b': {
                        str.append('\b');
                        continue block17;
                    }
                    case 'f': {
                        str.append('\f');
                        continue block17;
                    }
                    case 'n': {
                        str.append('\n');
                        continue block17;
                    }
                    case 'r': {
                        str.append('\r');
                        continue block17;
                    }
                    case 't': {
                        str.append('\t');
                        continue block17;
                    }
                    case 'u': {
                        int u = JsonUtilities.hexBits(token.charAt(++i)) << 12 | JsonUtilities.hexBits(token.charAt(++i)) << 8 | JsonUtilities.hexBits(token.charAt(++i)) << 4 | JsonUtilities.hexBits(token.charAt(++i));
                        str.append((char)u);
                        continue block17;
                    }
                    case '\'': {
                        str.append('\'');
                        continue block17;
                    }
                    case 'v': {
                        str.append('\u000b');
                        continue block17;
                    }
                    case '0': {
                        str.append('\u0000');
                        continue block17;
                    }
                    case 'x': {
                        int x = JsonUtilities.hexBits(token.charAt(++i) << 4) | JsonUtilities.hexBits(token.charAt(++i));
                        str.append((char)x);
                        continue block17;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid JSON object, invalid escape sequence in '" + token + "'");
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid JSON object, invalid escape sequence in '" + token + "'", e);
        }
        return str.toString();
    }

    private static Object _fromJSON(String token) {
        if (token.equals("null")) {
            return null;
        }
        if (token.equals("true")) {
            return Boolean.TRUE;
        }
        if (token.equals("false")) {
            return Boolean.FALSE;
        }
        if (token.startsWith("\"")) {
            return JsonUtilities._fromStr(token);
        }
        int len = token.length();
        if (!JsonUtilities.isOperator(token) && len >= 1) {
            try {
                return JsonUtilities.parseNumber(token);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid JSON number, found '" + token + "'.");
            }
        }
        throw new IllegalArgumentException("Invalid JSON object, expected null, Boolean, String, or Number, but found '" + token + "'.");
    }

    public static <T> T fromJSON(CharSequence json) {
        String str = json.toString().trim();
        return (T)JsonUtilities.fromJSON(null, JsonUtilities.tokenize(str));
    }

    public static <T> T fromJSON(Class<T> type, CharSequence json) {
        return JsonUtilities.toType(type, JsonUtilities.fromJSON(json));
    }

    private static Object fromJSON(String first, LinkedList<String> tokens) {
        if (first == null) {
            first = tokens.poll();
        }
        if (first == null) {
            throw new IllegalArgumentException("Premature end of JSON object/array");
        }
        if (first.equals("{")) {
            Map<String, Object> map = new LinkedHashMap(32);
            if (underlyingMap == MapKBT.class) {
                map = MapKBT.wrapMap(map);
            }
            while (true) {
                if ((first = tokens.poll()) == null) {
                    throw new IllegalArgumentException("Invalid JSON object, expected '}'");
                }
                if (first.equals("}")) break;
                if (!map.isEmpty()) {
                    if (first.equals(",")) {
                        first = tokens.poll();
                    } else {
                        throw new IllegalArgumentException("Invalid JSON object, expected '}' or ','");
                    }
                }
                String sep = tokens.poll();
                String val = tokens.poll();
                if (first == null) {
                    throw new IllegalArgumentException("Invalid JSON object, expected key");
                }
                if (JsonUtilities.isOperator(first)) {
                    throw new IllegalArgumentException("Invalid JSON object, expected key before '" + first + "'");
                }
                if (sep == null) {
                    throw new IllegalArgumentException("Invalid JSON object, expected ':' after " + first);
                }
                if (!sep.equals(":")) {
                    throw new IllegalArgumentException("Invalid JSON object, expected ':' after " + first);
                }
                if (val == null) {
                    throw new IllegalArgumentException("Invalid JSON object, expected value for " + first);
                }
                map.put(JsonUtilities._fromStr(first), JsonUtilities.fromJSON(val, tokens));
            }
            return map;
        }
        if (first.equals("[")) {
            ArrayList<Object> list3 = new ArrayList<Object>(32);
            while (true) {
                if ((first = tokens.poll()) == null) {
                    throw new IllegalArgumentException("Invalid JSON array, expected ']'");
                }
                if (first.equals("]")) break;
                if (!list3.isEmpty()) {
                    if (first.equals(",")) {
                        first = tokens.poll();
                    } else {
                        throw new IllegalArgumentException("Invalid JSON array, expected '}' or ','");
                    }
                }
                if (first == null) {
                    throw new IllegalArgumentException("Invalid JSON array, expected value");
                }
                list3.add(JsonUtilities.fromJSON(first, tokens));
            }
            return list3;
        }
        return JsonUtilities._fromJSON(first);
    }

    public static Number parseNumber(String num) throws NumberFormatException {
        try {
            if (num == null) {
                return null;
            }
            int len = num.length();
            if (len == 1) {
                return Integer.valueOf(num);
            }
            if (num.indexOf(46) >= 0) {
                return Double.valueOf(num);
            }
            if (num.indexOf(101) > 0) {
                return Double.valueOf(num);
            }
            if (num.indexOf(69) > 0) {
                return Double.valueOf(num);
            }
            if (len <= 9) {
                return Integer.valueOf(num);
            }
            return Long.valueOf(num);
        }
        catch (NumberFormatException e) {
            return Double.valueOf(num);
        }
    }

    @InternalUseOnly
    public static <T extends Map<String, Object>> void setUnderlyingMap(Class<T> clazz) {
        underlyingMap = clazz;
    }

    public static void setTableDotSubstitute(CharSequence subForDot) {
        tableDotSubstitute = subForDot;
    }

    public static Type getUnderlyingMap() {
        return underlyingMap;
    }

    private static char hexChar(int i) {
        int off = ((i &= 0xF) >> 3 & (i >> 2 | i >> 1) & 1) * 7;
        return (char)(48 + i + off);
    }

    private static int hexBits(int c) {
        switch (c) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 65: {
                return 10;
            }
            case 97: {
                return 10;
            }
            case 66: {
                return 11;
            }
            case 98: {
                return 11;
            }
            case 67: {
                return 12;
            }
            case 99: {
                return 12;
            }
            case 68: {
                return 13;
            }
            case 100: {
                return 13;
            }
            case 69: {
                return 14;
            }
            case 101: {
                return 14;
            }
            case 70: {
                return 15;
            }
            case 102: {
                return 15;
            }
        }
        throw new IllegalArgumentException("Invalid hex char 0x" + Integer.toHexString(c));
    }

    public static Object toType(Type type, Object val) {
        if (type instanceof Class) {
            return JsonUtilities.toType((Class)type, val);
        }
        return JsonUtilities._toType(type, val);
    }

    public static <T> T toType(Class<T> type, Object val) {
        if (type == null) {
            throw new NullPointerException("Unable to convert class Object to class null");
        }
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return (T)JsonUtilities._toType(Boolean.class, val);
            }
            if (type == Character.TYPE) {
                return (T)JsonUtilities._toType(Character.class, val);
            }
            if (type == Byte.TYPE) {
                return (T)JsonUtilities._toType(Byte.class, val);
            }
            if (type == Short.TYPE) {
                return (T)JsonUtilities._toType(Short.class, val);
            }
            if (type == Integer.TYPE) {
                return (T)JsonUtilities._toType(Integer.class, val);
            }
            if (type == Long.TYPE) {
                return (T)JsonUtilities._toType(Long.class, val);
            }
            if (type == Float.TYPE) {
                return (T)JsonUtilities._toType(Float.class, val);
            }
            if (type == Double.TYPE) {
                return (T)JsonUtilities._toType(Double.class, val);
            }
        }
        return type.cast(JsonUtilities._toType(type, val));
    }

    private static Object _toType(Type origType, Object origVal) {
        if (origType == null) {
            throw new NullPointerException("Unable to convert class Object to class null");
        }
        if (origVal == null) {
            return null;
        }
        try {
            Collection col;
            Object val = origVal;
            Type type = JsonUtilities.refineType(origType);
            if (val instanceof Character) {
                val = val.toString();
            }
            if (val instanceof CharSequence) {
                val = val.toString();
            }
            if (val instanceof Data) {
                val = ((Data)val).toObject();
            }
            Class clazz = null;
            ParameterizedType pt = null;
            if (type instanceof Class) {
                clazz = (Class)type;
                if (clazz.isInstance(val)) {
                    return clazz.cast(val);
                }
                JsonObjectInfo jo = JsonUtilities.getJsonObject(clazz);
                if (jo != null) {
                    return jo.fromJSON((Map)val);
                }
            } else if (type instanceof ParameterizedType) {
                pt = (ParameterizedType)type;
                clazz = (Class)pt.getRawType();
            } else if (type instanceof GenericArrayType) {
                clazz = JsonUtilities.typeToClass(type);
            } else {
                throw new TypeCastException(origType, origVal, "unsupported Type " + type.getClass());
            }
            if (Table.class.equals((Object)clazz) && val instanceof Map) {
                Table tab = new Table();
                tab.setFlags("+CaseSensitive");
                boolean subNotNull = tableDotSubstitute != null;
                boolean subNotHaveDots = subNotNull && !tableDotSubstitute.toString().contains(".");
                String dotSubString = subNotHaveDots ? tableDotSubstitute.toString() : null;
                tab.putAllAsPureTable((Map)val, dotSubString, subNotHaveDots);
                return tab;
            }
            if (Map.class.isAssignableFrom(clazz)) {
                Map map = (Map)JsonUtilities.newInstance(clazz);
                if (pt == null) {
                    map.putAll((Map)val);
                } else {
                    Type K = pt.getActualTypeArguments()[0];
                    Type V = pt.getActualTypeArguments()[1];
                    for (Map.Entry e : ((Map)val).entrySet()) {
                        map.put(JsonUtilities.toType(K, e.getKey()), JsonUtilities.toType(V, e.getValue()));
                    }
                }
                return map;
            }
            if (Collection.class.isAssignableFrom(clazz) || Iterable.class.isAssignableFrom(clazz)) {
                col = (Collection)JsonUtilities.newInstance(clazz);
                if (pt == null) {
                    col.addAll((Collection)val);
                } else {
                    Type V = pt.getActualTypeArguments()[0];
                    for (Object o : (Iterable)val) {
                        col.add(JsonUtilities.toType(V, o));
                    }
                }
                return col;
            }
            if (clazz.isArray() || type instanceof GenericArrayType) {
                col = (Collection)val;
                int len = col.size();
                Object arr = Array.newInstance(clazz.getComponentType(), len);
                int i = 0;
                Type V = clazz.getComponentType();
                if (type instanceof GenericArrayType) {
                    V = ((GenericArrayType)type).getGenericComponentType();
                }
                for (Object v : col) {
                    Array.set(arr, i++, JsonUtilities.toType(V, v));
                }
                return arr;
            }
            if (clazz.isInstance(val)) {
                return val;
            }
            if (clazz.isAssignableFrom(String.class)) {
                return val.toString();
            }
            if (val instanceof String) {
                String str = val.toString();
                if (clazz == Character.class && str.length() == 1) {
                    return Character.valueOf(str.charAt(0));
                }
                if (!clazz.isInterface()) {
                    Object obj = JsonUtilities.tryStaticMethod(clazz, "fromString", String.class, str);
                    if (obj != null) {
                        return obj;
                    }
                    obj = JsonUtilities.tryStaticMethod(clazz, "valueOf", String.class, str);
                    if (obj != null) {
                        return obj;
                    }
                    obj = JsonUtilities.tryStaticMethod(clazz, "valueOf", CharSequence.class, str);
                    if (obj != null) {
                        return obj;
                    }
                    obj = JsonUtilities.tryStaticMethod(clazz, "parse", String.class, str);
                    if (obj != null) {
                        return obj;
                    }
                    obj = JsonUtilities.tryStaticMethod(clazz, "parse", CharSequence.class, str);
                    if (obj != null) {
                        return obj;
                    }
                    obj = JsonUtilities.tryStaticMethod(clazz, "<init>", String.class, str);
                    if (obj != null) {
                        return obj;
                    }
                    obj = JsonUtilities.tryStaticMethod(clazz, "<init>", CharSequence.class, str);
                    if (obj != null) {
                        return obj;
                    }
                }
                if (clazz == Number.class) {
                    return JsonUtilities.parseNumber(val.toString());
                }
            }
            if (val instanceof Number) {
                Number num = (Number)val;
                if (type == Number.class) {
                    return num;
                }
                if (type == Byte.class) {
                    return num.byteValue();
                }
                if (type == Short.class) {
                    return num.shortValue();
                }
                if (type == Integer.class) {
                    return num.intValue();
                }
                if (type == Long.class) {
                    return num.longValue();
                }
                if (type == Float.class) {
                    return Float.valueOf(num.floatValue());
                }
                if (type == Double.class) {
                    return num.doubleValue();
                }
            }
        }
        catch (TypeCastException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new TypeCastException(origType, origVal, e.getCause());
        }
        catch (Exception e) {
            throw new TypeCastException(origType, origVal, e);
        }
        throw new TypeCastException(origType, origVal);
    }

    private static void convertInnerPortionsToTable(Table tableToFix) {
        for (String key : tableToFix.getKeys()) {
            Object obj = tableToFix.get(key);
            if (!(obj instanceof Map)) continue;
            Table tab = new Table();
            tab.setFlags("+CaseSensitive");
            tab.putAll((Map)obj);
            tableToFix.put(key, (Object)tab);
            JsonUtilities.convertInnerPortionsToTable(tab);
        }
    }

    private static Type refineType(Type type) {
        while (type instanceof WildcardType || type instanceof TypeVariable) {
            Type[] bounds;
            Type[] typeArray = bounds = type instanceof WildcardType ? ((WildcardType)type).getUpperBounds() : ((TypeVariable)type).getBounds();
            if (bounds == null || bounds.length == 0) {
                type = Object.class;
                continue;
            }
            type = bounds[0];
        }
        return type;
    }

    private static Class<?> typeToClass(Type type) throws ClassNotFoundException {
        if ((type = JsonUtilities.refineType(type)) instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return JsonUtilities.typeToClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Class<?> c = JsonUtilities.typeToClass(((GenericArrayType)type).getGenericComponentType());
            return Array.newInstance(c, 0).getClass();
        }
        throw new UnsupportedOperationException("Could not determine Class matching " + type);
    }

    private static <T> T newInstance(Class<T> clazz) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (clazz.isInterface()) {
            if (clazz.isAssignableFrom(ArrayList.class)) {
                return clazz.cast(new ArrayList());
            }
            if (clazz.isAssignableFrom(LinkedList.class)) {
                return clazz.cast(new LinkedList());
            }
            if (clazz.isAssignableFrom(LinkedHashMap.class)) {
                return clazz.cast(new LinkedHashMap());
            }
            if (clazz.isAssignableFrom(TreeMap.class)) {
                return clazz.cast(new TreeMap());
            }
            if (clazz.isAssignableFrom(TreeSet.class)) {
                return clazz.cast(new TreeSet());
            }
        }
        return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private static <T, X> T tryStaticMethod(Class<T> clazz, String method, Class<X> type, X value) throws Exception {
        try {
            if (method.equals("<init>")) {
                Constructor<T> c = clazz.getConstructor(type);
                return c.newInstance(value);
            }
            Method m = clazz.getMethod(method, type);
            if (Modifier.isStatic(m.getModifiers())) {
                return clazz.cast(m.invoke(null, value));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    @ProvisionalUseOnly(value="until fully tested")
    public static MapKBT readJsonRest(String url) {
        return JsonUtilities.readJsonRest(url, null);
    }

    @ProvisionalUseOnly(value="until fully tested")
    public static MapKBT readJsonRest(URL url) throws RestRequestException {
        return JsonUtilities.readJsonRest(url, null);
    }

    @ProvisionalUseOnly(value="until fully tested")
    public static MapKBT readJsonRest(String url, MapKBT post) {
        try {
            return JsonUtilities.readJsonRest(new URI(url).toURL(), post);
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException("Unable to read from " + url, e);
        }
    }

    @ProvisionalUseOnly(value="until fully tested")
    public static MapKBT readJsonRest(URL url, MapKBT post) throws RestRequestException {
        try {
            int code;
            String method = post == null ? "GET" : "POST";
            String json = post == null ? null : JsonUtilities.toJSON(post).toString();
            byte[] body = json == null ? new byte[]{} : json.getBytes();
            LogUtilities.Duration duration = LogUtilities.duration();
            LogUtilities.Extra extra = LogUtilities.extra(URL2 -> url, METHOD -> method, LENGTH -> body.length);
            LogUtilities.log(Level.FINER, "Making REST {0} request to {1}", method, url, extra);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(json != null);
            conn.setDoInput(true);
            conn.setRequestMethod(method);
            conn.setRequestProperty("Accept", MEDIA_TYPE);
            conn.setRequestProperty("Content-Type", MEDIA_TYPE);
            conn.setRequestProperty("Content-Length", Integer.toString(body.length));
            if (json != null) {
                OutputStream out = conn.getOutputStream();
                out.write(body);
            }
            if ((code = conn.getResponseCode()) >= 200 && code < 300) {
                CharSequence in = FileUtil.readAllChars(conn.getInputStream());
                extra.put("ERRORS", (Object)0);
                extra.put("CHAR_COUNT", (Object)in.length());
                LogUtilities.log(Level.FINER, "Done with REST request to {0}", url, extra, duration);
                return MapKBT.wrapMap((Map)JsonUtilities.fromJSON(in));
            }
            CharSequence msg = FileUtil.readAllChars(conn.getErrorStream());
            extra.put("ERRORS", (Object)1);
            extra.put("CHAR_COUNT", (Object)msg.length());
            LogUtilities.log(Level.FINER, "Done with REST request to {0}", url, extra, duration);
            throw new RestRequestException(code, "Request for " + url + " returned " + code + ": " + msg);
        }
        catch (IOException e) {
            throw new RestRequestException(0, "Error while trying to read from " + url, e);
        }
    }

    public static <T> List<T> readJsonFile(Class<T> type, Object fname) {
        if (fname instanceof BaseFile) {
            fname = ((BaseFile)fname).getName();
        }
        return JsonUtilities.readJsonFile(type, new TextFile(null, fname));
    }

    public static MapKBT readJsonFile(Object fname) {
        if (fname instanceof BaseFile) {
            fname = ((BaseFile)fname).getName();
        }
        return JsonUtilities.readJsonFile(new TextFile(null, fname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> readJsonFile(Class<T> type, TextFile tf) {
        boolean doOpen = !tf.isOpen();
        ArrayList<T> entries = new ArrayList<T>(16);
        try {
            if (doOpen) {
                tf.open(8192);
            }
            String[] lines = tf.readAllLines();
            StringBuilder json = new StringBuilder(4096);
            for (int i = 0; i < lines.length; ++i) {
                String next;
                String line = lines[i];
                String string = next = i + 1 < lines.length ? lines[i + 1] : "";
                if (next.trim().isEmpty()) {
                    CharSequence txt = json.length() == 0 ? line : json.append(line);
                    Object obj = JsonUtilities.fromJSON(txt);
                    if (obj instanceof Map) {
                        obj = MapKBT.wrapMap(obj);
                    }
                    entries.add(type.cast(obj));
                    continue;
                }
                json.append(line).append('\n');
            }
        }
        finally {
            if (doOpen) {
                tf.close();
            }
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MapKBT readJsonFile(TextFile tf) {
        boolean doOpen = !tf.isOpen();
        try {
            if (doOpen) {
                tf.open(8192);
            }
            String txt = tf.readAll();
            MapKBT mapKBT = MapKBT.wrapMap((Map)JsonUtilities.fromJSON(txt));
            return mapKBT;
        }
        finally {
            if (doOpen) {
                tf.close();
            }
        }
    }

    public static String prettyPrint(String in_json) {
        StringBuilder sb = new StringBuilder();
        int indentLevel = 0;
        boolean inQuote = false;
        block8: for (char ccc : in_json.toCharArray()) {
            switch (ccc) {
                case '\"': {
                    inQuote = !inQuote;
                    sb.append(ccc);
                    continue block8;
                }
                case ' ': {
                    if (!inQuote) continue block8;
                    sb.append(ccc);
                    continue block8;
                }
                case ':': {
                    sb.append(ccc);
                    if (inQuote) continue block8;
                    sb.append(" ");
                    continue block8;
                }
                case '[': 
                case '{': {
                    sb.append(ccc);
                    JsonUtilities.appendIndentedNewLine(++indentLevel, sb);
                    continue block8;
                }
                case ']': 
                case '}': {
                    JsonUtilities.appendClosingCharacter(--indentLevel, sb, ccc);
                    continue block8;
                }
                case ',': {
                    sb.append(ccc);
                    if (inQuote) continue block8;
                    JsonUtilities.appendIndentedNewLine(indentLevel, sb);
                    continue block8;
                }
                default: {
                    sb.append(ccc);
                }
            }
        }
        return sb.toString();
    }

    private static void appendClosingCharacter(int indentLevel, StringBuilder sb, char closingCharacter) {
        sb.append("\n");
        for (int i = 0; i < indentLevel; ++i) {
            sb.append("  ");
        }
        sb.append(closingCharacter);
    }

    private static void appendIndentedNewLine(int indentLevel, StringBuilder sb) {
        sb.append("\n");
        for (int i = 0; i < indentLevel; ++i) {
            sb.append("  ");
        }
    }

    @ProvisionalUseOnly(value="until fully tested")
    public static void combineJSON(String outFileName, String ... inFileNames) {
        if (inFileNames.length == 0) {
            return;
        }
        TextFile outTextFile = new TextFile(Shell.getSharedMidasContext(), (Object)outFileName);
        outTextFile.open(2);
        outTextFile.setFlags("+Append");
        int numInFiles = inFileNames.length;
        for (int i = 0; i < numInFiles; ++i) {
            String inFileName = inFileNames[i];
            TextFile inTextFile = new TextFile(Shell.getSharedMidasContext(), (Object)inFileName);
            inTextFile.open(1);
            String inJSONTextTrimmed = inTextFile.readAll().trim();
            String outJSONText = "";
            if (numInFiles == 1) {
                outJSONText = inJSONTextTrimmed;
            } else if (i == 0) {
                outJSONText = inJSONTextTrimmed.substring(0, inJSONTextTrimmed.length() - 1).trim().concat(",\n ");
            } else if (i < numInFiles - 1) {
                outJSONText = inJSONTextTrimmed.substring(1, inJSONTextTrimmed.length() - 1).trim().concat(",\n ");
            } else if (i == numInFiles - 1) {
                outJSONText = inJSONTextTrimmed.substring(1).trim();
            }
            outTextFile.write(outJSONText);
            inTextFile.close();
        }
        outTextFile.close();
    }

    @InternalUseOnly
    public static interface AlternateJsonObject {
        default public Object toJsonObject() {
            return this.toString();
        }
    }

    @ProvisionalUseOnly(value="until fully tested")
    public static final class RestRequestException
    extends RuntimeException {
        private static final long serialVersionUID = 4165554185987284164L;
        private final int code;

        public RestRequestException(String msg, Throwable cause) {
            this(0, msg, cause);
        }

        public RestRequestException(int code, String msg) {
            this(code, msg, null);
        }

        public RestRequestException(int code, String msg, Throwable cause) {
            super(msg, cause);
            this.code = code;
        }

        public final int getResponseCode() {
            return this.code;
        }
    }

    static final class ParamType
    implements ParameterizedType {
        private final Type rawType;
        private final Type[] actTypes;

        ParamType(Type rawType, Type ... actTypes) {
            this.rawType = rawType;
            this.actTypes = actTypes;
        }

        public String toString() {
            StringBuilder str = new StringBuilder(80);
            str.append(this.rawType);
            str.append('<');
            for (int i = 0; i < this.actTypes.length; ++i) {
                if (i > 0) {
                    str.append(',');
                }
                str.append(this.actTypes[i]);
            }
            str.append('>');
            return str.toString();
        }

        @Override
        public Type getOwnerType() {
            return null;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actTypes;
        }
    }

    static final class TypeCastException
    extends ClassCastException {
        private static final long serialVersionUID = -2769692240467821376L;

        TypeCastException(Type type, Object val) {
            this(type, val, (String)null);
        }

        TypeCastException(Type type, Object val, String msg) {
            super("Unable to convert " + (val == null ? null : val.getClass()) + " to " + (type == null ? null : type) + (msg == null ? "" : ": " + msg));
        }

        TypeCastException(Type type, Object val, Throwable cause) {
            this(type, val, cause == null ? null : cause.getMessage());
            if (cause instanceof InvocationTargetException) {
                this.initCause(cause.getCause());
            } else if (!(cause instanceof ClassCastException) && cause != null) {
                this.initCause(cause);
            }
        }
    }

    static class JsonEntryInfo {
        final JsonEntry entry;
        Method setMethod;
        Method getMethod;
        Field field;

        JsonEntryInfo(JsonEntry entry) {
            this.entry = entry;
        }

        public String toString() {
            StringBuilder str = new StringBuilder(120);
            if (this.setMethod != null) {
                str.append(this.setMethod);
            }
            if (this.getMethod != null) {
                if (str.length() > 0) {
                    str.append(" / ");
                }
                str.append(this.getMethod);
            }
            if (this.field != null) {
                if (str.length() > 0) {
                    str.append(" / ");
                }
                str.append(this.field);
            }
            return str.toString();
        }

        public Type getType() {
            Class<?> clazz = this.entry.type();
            if (clazz != Type.class) {
                if (Collection.class.isAssignableFrom(clazz)) {
                    return new ParamType(clazz, this.entry.valtype());
                }
                if (Map.class.isAssignableFrom(clazz)) {
                    return new ParamType(clazz, this.entry.keytype(), this.entry.valtype());
                }
                return clazz;
            }
            if (this.field != null) {
                return this.field.getGenericType();
            }
            return this.setMethod.getGenericParameterTypes()[0];
        }

        public Object get(Object obj) throws IllegalAccessException, InvocationTargetException {
            return this.field != null ? this.field.get(obj) : this.getMethod.invoke(obj, new Object[0]);
        }

        public void set(Object obj, Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.entry.ignoreSet()) {
                return;
            }
            val = JsonUtilities.toType(this.getType(), val);
            if (this.field != null) {
                this.field.set(obj, val);
            } else {
                this.setMethod.invoke(obj, val);
            }
        }
    }

    static class JsonObjectInfo<T> {
        final Class<T> clazz;
        final JsonObject object;
        final Method factory;
        final Method validation;
        final SortedMap<String, JsonEntryInfo> entries;

        /*
         * WARNING - void declaration
         */
        JsonObjectInfo(Class<T> clazz, JsonObject object) {
            String n;
            JsonEntry je;
            void var5_9;
            this.clazz = clazz;
            this.object = object;
            this.entries = new TreeMap<String, JsonEntryInfo>();
            try {
                this.factory = object.factory().isEmpty() ? null : clazz.getMethod(object.factory(), Map.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not find factory method " + object.factory() + "(Map) in " + clazz, e);
            }
            try {
                this.validation = object.validator().isEmpty() ? null : clazz.getMethod(object.validator(), new Class[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not find validation method " + object.validator() + "() in " + clazz, e);
            }
            if (this.factory != null && !clazz.isAssignableFrom(this.factory.getReturnType())) {
                throw new RuntimeException("Conflicting return type on factory method " + object.factory() + "(Map) expected return type of " + clazz + " but found " + this.factory.getReturnType());
            }
            Field[] e = clazz.getFields();
            int n2 = e.length;
            boolean bl = false;
            while (var5_9 < n2) {
                Field f = e[var5_9];
                JsonEntry je2 = f.getAnnotation(JsonEntry.class);
                if (je2 != null) {
                    JsonEntryInfo jx;
                    String name = je2.name();
                    if (name.isEmpty()) {
                        name = f.getName();
                    }
                    if ((jx = (JsonEntryInfo)this.entries.get(name)) != null) {
                        throw new IllegalArgumentException("Duplicate JsonEntry in " + clazz + " for " + name + " found " + jx + " and " + f);
                    }
                    jx = new JsonEntryInfo(je2);
                    jx.field = f;
                    this.entries.put(name, jx);
                }
                ++var5_9;
            }
            LinkedHashMap<String, Method> otherMethods = new LinkedHashMap<String, Method>(32);
            for (Method m : clazz.getMethods()) {
                je = m.getAnnotation(JsonEntry.class);
                n = m.getName();
                Method mx = (Method)otherMethods.get(n);
                if (je != null) {
                    otherMethods.put(n, null);
                    continue;
                }
                if (!otherMethods.containsKey(n)) {
                    otherMethods.put(n, m);
                    continue;
                }
                if (mx == null) continue;
                if (n.startsWith("get") || n.startsWith("is")) {
                    if (m.getParameterTypes().length != 0) continue;
                    otherMethods.put(n, m);
                    continue;
                }
                if (!n.startsWith("set") || m.getParameterTypes().length != 1) continue;
                if (mx.getParameterTypes().length == 1) {
                    otherMethods.put(n, null);
                    continue;
                }
                otherMethods.put(n, m);
            }
            for (Method m : clazz.getMethods()) {
                String name;
                String defName;
                je = m.getAnnotation(JsonEntry.class);
                n = m.getName();
                Class<?> type = m.getReturnType();
                String setName = null;
                String getName1 = null;
                String getName2 = null;
                Method set = null;
                Method get = null;
                if (je == null) {
                    if (!object.auto() || Modifier.isStatic(m.getModifiers()) || !n.startsWith("set")) continue;
                    je = AUTO_ENTRY;
                }
                if (n.startsWith("get")) {
                    defName = n.substring(3);
                    get = m;
                    setName = "set" + n.substring(3);
                } else if (n.startsWith("is")) {
                    defName = n.substring(2);
                    get = m;
                    setName = "set" + n.substring(2);
                } else if (n.startsWith("set")) {
                    defName = n.substring(3);
                    set = m;
                    getName1 = "get" + n.substring(3);
                    getName2 = "is" + n.substring(3);
                } else if (type == Void.TYPE) {
                    defName = n;
                    set = m;
                    getName1 = n;
                } else {
                    defName = n;
                    get = m;
                    setName = n;
                }
                if (!je.name().isEmpty()) {
                    name = je.name();
                } else if (defName.isEmpty()) {
                    name = "value";
                } else {
                    String _name = Character.toLowerCase(defName.charAt(0)) + defName.substring(1);
                    name = _name.intern();
                }
                JsonEntryInfo jx = (JsonEntryInfo)this.entries.get(name);
                if (jx == null) {
                    jx = new JsonEntryInfo(je);
                    this.entries.put(name, jx);
                } else if (!jx.entry.equals(je)) {
                    throw new IllegalArgumentException("Conflicting JsonEntry in " + clazz + " for " + name + " found " + m + " and " + jx + " with conflicting information");
                }
                if (get != null) {
                    if (jx.getMethod != null) {
                        throw new IllegalArgumentException("Duplicate JsonEntry in " + clazz + " for " + name + " found " + get + " and " + jx.getMethod);
                    }
                    jx.getMethod = get;
                }
                if (set != null) {
                    if (jx.setMethod != null) {
                        throw new IllegalArgumentException("Duplicate JsonEntry in " + clazz + " for " + name + " found " + set + " and " + jx.setMethod);
                    }
                    jx.setMethod = set;
                }
                if (jx.setMethod == null && setName != null && !jx.entry.ignoreSet()) {
                    jx.setMethod = (Method)otherMethods.get(setName);
                }
                if (jx.getMethod != null || getName1 == null) continue;
                jx.getMethod = (Method)otherMethods.get(getName1);
                if (otherMethods.get(getName2) == null) continue;
                if (jx.getMethod == null) {
                    jx.getMethod = (Method)otherMethods.get(getName2);
                    continue;
                }
                throw new IllegalArgumentException("Duplicate JsonEntry in " + clazz + " for " + name + " found " + otherMethods.get(getName2) + " and " + jx.getMethod);
            }
            for (Map.Entry entry : this.entries.entrySet()) {
                String name = (String)entry.getKey();
                JsonEntryInfo jx = (JsonEntryInfo)entry.getValue();
                if (jx.field != null) {
                    if (jx.getMethod == null && ((JsonEntryInfo)entry.getValue()).setMethod == null) continue;
                    throw new IllegalArgumentException("Duplicate JsonEntry in " + clazz + " for " + name + " found " + jx);
                }
                if (jx.getMethod == null) {
                    throw new IllegalArgumentException("Invalid JsonEntry in " + clazz + " for " + name + " expected GET method taking 0 parameters but found none");
                }
                if (jx.getMethod.getParameterTypes().length != 0) {
                    throw new IllegalArgumentException("Invalid JsonEntry in " + clazz + " for " + name + " expected GET method taking 0 parameters but found " + jx.getMethod);
                }
                if (jx.entry.ignoreSet()) {
                    if (jx.setMethod == null) continue;
                    throw new IllegalArgumentException("Invalid JsonEntry in " + clazz + " for " + name + " expected no SET method but found " + jx.setMethod);
                }
                if (jx.setMethod == null) {
                    throw new IllegalArgumentException("Invalid JsonEntry in " + clazz + " for " + name + " expected SET method taking 1 parameter but found none");
                }
                if (jx.setMethod.getParameterTypes().length == 1) continue;
                throw new IllegalArgumentException("Invalid JsonEntry in " + clazz + " for " + name + " expected SET method taking 1 parameter but found " + jx.setMethod);
            }
        }

        public Map<String, Object> toJSON(T obj) {
            LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>(this.entries.size());
            for (Map.Entry<String, JsonEntryInfo> e : this.entries.entrySet()) {
                try {
                    json.put(e.getKey(), e.getValue().get(obj));
                }
                catch (Exception ex) {
                    throw new RuntimeException("Can not get " + e.getKey() + " in " + obj.getClass() + ": " + ex, ex);
                }
            }
            return json;
        }

        public T fromJSON(Map<String, Object> json) {
            T obj;
            try {
                obj = this.factory == null ? this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]) : this.clazz.cast(this.factory.invoke(null, json));
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException("Can not initialize " + this.clazz, ex.getCause());
            }
            catch (Exception ex) {
                throw new RuntimeException("Can not initialize " + this.clazz, ex);
            }
            if (this.object.strict()) {
                for (String string : json.keySet()) {
                    if (this.entries.containsKey(string)) continue;
                    throw new RuntimeException("Can not initialize " + this.clazz + " due to illegal entry '" + string + "'");
                }
            }
            for (Map.Entry entry : this.entries.entrySet()) {
                String name = (String)entry.getKey();
                JsonEntryInfo e = (JsonEntryInfo)entry.getValue();
                Object val = json.get(name);
                if (!json.containsKey(name)) {
                    if (!e.entry.required()) continue;
                    throw new RuntimeException("Can not initialize " + this.clazz + " due to missing required entry '" + name + "'");
                }
                try {
                    e.set(obj, val);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Can not set '" + name + "' in " + obj.getClass(), ex);
                }
            }
            try {
                if (this.validation != null) {
                    this.validation.invoke(obj, new Object[0]);
                }
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException("Validation failed for " + this.clazz, ex.getCause());
            }
            catch (Exception ex) {
                throw new RuntimeException("Validation failed for " + this.clazz, ex);
            }
            return obj;
        }
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.FIELD})
    public static @interface JsonEntry {
        public String name() default "";

        public boolean required() default false;

        public boolean ignoreSet() default false;

        public Class<?> type() default Type.class;

        public Class<?> valtype() default Object.class;

        public Class<?> keytype() default String.class;
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface JsonObject {
        public String name() default "";

        public String factory() default "";

        public String validator() default "";

        public boolean strict() default false;

        public boolean auto() default false;
    }

    public static enum Mode {
        Auto,
        FastAuto,
        Compact,
        Formal;

    }
}

