/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MapKBT;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.PlotFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.FileName;
import nxm.sys.lib.GeoJSONFileModSwap;
import nxm.sys.lib.GeoJSONObjects;
import nxm.sys.lib.JsonUtilities;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;

@InternalUseOnly(value="Experimental Prototype in NeXtMidas 4.1.3")
public final class GeoJSONFile
extends TextFile
implements GeoJSONFileModSwap,
PlotFile {
    private GeoJSONObjects jsonObjects = new GeoJSONObjects();
    private MapKBT geoJSONMap = null;
    private boolean enableJSONSearch = false;
    private int unnamedPointCnt = 0;
    private int unnamedLineStringCnt = 0;
    private int unnamedPolygonCnt = 0;
    private int unnamedGeoCollection = 0;
    private static final Table nameMatch = new Table("{\"Point\"=PNT_,\"LineString\"=LSTR_,\"Polygon\"=POLY_,\"MultiPoint\"=PNT_,\"MultiLineString\"=LSTR_,\"MultiPolygon\"=POLY_}", 64);
    private static final int MULTI_START_LETTER = 97;
    private double xstart = 0.0;
    private double xdelta = 1.0;
    private double ystart = 0.0;
    private double ydelta = 1.0;
    private double timecode = 0.0;
    private int xunits = 0;
    private int xframe = 1;
    private int yunits = 0;
    private int yframe = 1;
    private String format = "UNK";

    public GeoJSONFile() {
    }

    public GeoJSONFile(String filename) {
        this.init(null, (Object)filename);
    }

    public GeoJSONFile(FileName fn) {
        this.init(null, (Object)fn);
    }

    public GeoJSONFile(MidasReference ref, Object filename) {
        this.init(ref, filename);
    }

    public GeoJSONObjects getGeoJSONObjects() {
        return this.jsonObjects;
    }

    @Override
    public boolean open() {
        super.open();
        this.geoJSONMap = JsonUtilities.readJsonFile(this);
        String outerType = this.geoJSONMap.getS("type");
        if (outerType != null) {
            switch (outerType) {
                case "Feature": {
                    this.addFeature(this.geoJSONMap);
                    break;
                }
                case "FeatureCollection": {
                    List features = this.geoJSONMap.getList("features");
                    for (Object featObj : features) {
                        if (featObj instanceof Map) {
                            this.addFeature((Map)featObj);
                            continue;
                        }
                        Shell.warning("Skipping unsupported GeoJSON feature entry that is not a Map:" + featObj);
                    }
                    break;
                }
                case "Topology": {
                    throw new MidasException("TopoJSON is not currently supported");
                }
                default: {
                    if (this.enableJSONSearch) {
                        Object coorObj = this.geoJSONMap.get("coordinates");
                        if (coorObj == null || !(coorObj instanceof ArrayList)) break;
                        this.addFeature(outerType, null, (ArrayList)coorObj);
                        break;
                    }
                    Shell.warning("Unsupported GeoJSON type: " + outerType);
                }
            }
        }
        if (this.enableJSONSearch) {
            this.trySupportNonStandardGeoJSON(this.geoJSONMap);
        }
        return true;
    }

    private void addFeature(Map featureMap) {
        Object propertiesObj = featureMap.get("properties");
        Map properties = propertiesObj == null || !(propertiesObj instanceof Map) ? null : (Map)propertiesObj;
        Object geometry = featureMap.get("geometry");
        if (geometry instanceof Map) {
            String type = ((Map)geometry).get("type").toString();
            if ("GeometryCollection".equals(type)) {
                this.addGeometries((Map)geometry, properties);
            } else {
                ArrayList coordinates = this.getCoordinates((Map)geometry);
                this.addFeature(type, properties, coordinates);
            }
        }
    }

    private void addFeature(String type, Map properties, ArrayList coordinates) {
        this.addFeature(type, properties, coordinates, null);
    }

    private void addFeature(String type, Map properties, ArrayList coordinates, GeoJSONObjects.GeoJSONGroup geomCollGroup) {
        ArrayListFacts facts = this.getArrayListFacts(coordinates);
        String name = properties != null ? properties.getOrDefault("name", "").toString() : "";
        switch (type) {
            case "Point": {
                if (name == "") {
                    name = nameMatch.get(type).toString() + this.unnamedPointCnt++;
                }
                double[] flatCoords = this.getFlatArray(coordinates, facts);
                this.jsonObjects.addGeoJSONPoint(name, flatCoords, facts.atomsPerElem, properties, geomCollGroup);
                break;
            }
            case "LineString": {
                if (name == "") {
                    name = nameMatch.get(type).toString() + this.unnamedLineStringCnt++;
                }
                double[] flatCoords = this.getFlatArray(coordinates, facts);
                this.jsonObjects.addGeoJSONLineString(name, flatCoords, facts.atomsPerElem, properties, geomCollGroup);
                break;
            }
            case "Polygon": {
                if (name == "") {
                    name = nameMatch.get(type).toString() + this.unnamedPolygonCnt++;
                }
                this.addPolygon(name, coordinates, facts, properties, geomCollGroup);
                break;
            }
            case "MultiPoint": {
                if (name == "") {
                    name = nameMatch.get(type).toString() + this.unnamedPointCnt++;
                }
                if (facts.dimension == 1) {
                    double[] flatCoords = this.getFlatArray(coordinates, facts);
                    this.jsonObjects.addGeoJSONPoint(name, flatCoords, facts.atomsPerElem, properties, null);
                    break;
                }
                GeoJSONObjects.GeoJSONGroup group2 = new GeoJSONObjects.GeoJSONGroup(name, "GeoJSON" + type);
                for (int set = 0; set < facts.dimension; ++set) {
                    ArrayListFacts modFacts = new ArrayListFacts(facts);
                    modFacts.dimension = 1;
                    modFacts.numSets = facts.dimension;
                    modFacts.numElements = facts.numElements / modFacts.numSets;
                    String modName = name + (char)(97 + set);
                    double[] flatCoords = this.getFlatArray((ArrayList)coordinates.get(set), modFacts);
                    this.jsonObjects.addGeoJSONPoint(modName, flatCoords, modFacts.atomsPerElem, properties, group2);
                }
                break;
            }
            case "MultiLineString": {
                if (name == "") {
                    name = nameMatch.get(type).toString() + this.unnamedLineStringCnt++;
                }
                if (facts.numSets == 1) {
                    double[] flatCoords = this.getFlatArray(coordinates, facts);
                    this.jsonObjects.addGeoJSONLineString(name, flatCoords, facts.atomsPerElem, properties, null);
                    break;
                }
                GeoJSONObjects.GeoJSONGroup group3 = new GeoJSONObjects.GeoJSONGroup(name, "GeoJSON" + type);
                for (int set = 0; set < facts.numSets; ++set) {
                    ArrayListFacts modFacts = new ArrayListFacts(facts);
                    modFacts.dimension = facts.dimension - 1;
                    modFacts.numElements = facts.numElements / facts.numSets;
                    String modName = name + (char)(97 + set);
                    double[] flatCoords = this.getFlatArray((ArrayList)coordinates.get(set), modFacts);
                    this.jsonObjects.addGeoJSONLineString(modName, flatCoords, modFacts.atomsPerElem, properties, group3);
                }
                break;
            }
            case "MultiPolygon": {
                if (name == "") {
                    name = nameMatch.get(type).toString() + this.unnamedPolygonCnt++;
                }
                if (facts.numSets == 1) {
                    this.addPolygon(name, coordinates, facts, properties, null);
                    break;
                }
                GeoJSONObjects.GeoJSONGroup group4 = new GeoJSONObjects.GeoJSONGroup(name, "GeoJSON" + type);
                for (int set = 0; set < facts.numSets; ++set) {
                    ArrayList thisPolyArrayList = (ArrayList)coordinates.get(set);
                    ArrayListFacts modFacts = this.getArrayListFacts(thisPolyArrayList);
                    String modName = name + (char)(97 + set);
                    this.addPolygon(modName, thisPolyArrayList, modFacts, properties, group4);
                }
                break;
            }
            default: {
                Shell.warning("Unsupported GeoJSON type:" + type);
            }
        }
    }

    private void addGeometries(Map geometryCollection, Map properties) {
        Object geometries = geometryCollection.get("geometries");
        if (geometries instanceof ArrayList) {
            String gcName = "GC" + this.unnamedGeoCollection++;
            GeoJSONObjects.GeoJSONGroup group2 = new GeoJSONObjects.GeoJSONGroup(gcName, "GeoJSONGeometryCollection");
            int item = 0;
            for (Object geometry : (ArrayList)geometries) {
                if (!(geometry instanceof Map)) continue;
                String type = ((Map)geometry).get("type").toString();
                ArrayList coordinates = this.getCoordinates((Map)geometry);
                String name = nameMatch.get(type) + gcName;
                name = name + (char)(97 + item++);
                properties.put("name", name);
                this.addFeature(type, properties, coordinates, group2);
            }
        } else {
            throw new MidasException("Unsupported GeoJSON geometries object: " + geometries);
        }
    }

    private ArrayList getCoordinates(Map geometry) {
        Object coorObj = geometry.get("coordinates");
        if (coorObj instanceof ArrayList) {
            return (ArrayList)coorObj;
        }
        throw new MidasException("Unsupported GeoJSON coordinates object: " + coorObj);
    }

    private void addPolygon(String name, ArrayList coordinates, ArrayListFacts facts, Map properties, GeoJSONObjects.GeoJSONGroup group2) {
        double[] flatCoords = facts.dimension < 3 ? this.getFlatArray(coordinates, facts) : this.getFlatArray((ArrayList)coordinates.get(0), this.getArrayListFacts((ArrayList)coordinates.get(0)));
        double[][] flatCoordsInnerPoly = this.getInnerFlatCoords(coordinates, facts);
        if (flatCoordsInnerPoly != null) {
            this.jsonObjects.addGeoJSONPolygon(name, flatCoords, flatCoordsInnerPoly, facts.atomsPerElem, properties, group2);
        } else {
            this.jsonObjects.addGeoJSONPolygon(name, flatCoords, facts.atomsPerElem, properties, group2);
        }
    }

    private ArrayListFacts getArrayListFacts(ArrayList coordinates) {
        int dimensions = 0;
        int numElements = 0;
        int atomsPerElem = 0;
        int numSets = 1;
        if (coordinates == null) {
            Shell.warning("GeoJSON invalid null coordinates");
            return new ArrayListFacts(0, 0, 0, 0);
        }
        Object first = coordinates.get(0);
        if (first instanceof ArrayList) {
            Object initElem = ((ArrayList)first).get(0);
            if (initElem instanceof ArrayList) {
                atomsPerElem = ((ArrayList)initElem).size();
                for (Object set : coordinates) {
                    numElements += ((ArrayList)set).size();
                }
                numSets = coordinates.size();
                dimensions = 3;
            } else {
                atomsPerElem = ((ArrayList)first).size();
                numElements = coordinates.size();
                dimensions = 2;
            }
        } else {
            atomsPerElem = coordinates.size();
            numElements = 1;
            dimensions = 1;
        }
        return new ArrayListFacts(dimensions, numSets, numElements, atomsPerElem);
    }

    private double[] getFlatArray(ArrayList coordinates, ArrayListFacts facts) {
        double[] flatArray;
        block4: {
            block3: {
                flatArray = new double[facts.numElements * facts.atomsPerElem];
                if (facts.dimension != 1) break block3;
                for (int counter = 0; counter < coordinates.size(); ++counter) {
                    flatArray[counter] = (Double)coordinates.get(counter);
                }
                break block4;
            }
            if (facts.dimension != 2) break block4;
            int counter = 0;
            for (Object elemObj : coordinates) {
                ArrayList elemArrList = (ArrayList)elemObj;
                int i = 0;
                while (i < elemArrList.size()) {
                    Object value = elemArrList.get(i);
                    flatArray[counter] = value instanceof Double ? (Double)value : Double.valueOf(value.toString());
                    ++i;
                    ++counter;
                }
            }
        }
        return flatArray;
    }

    private double[][] getInnerFlatCoords(ArrayList coordinates, ArrayListFacts facts) {
        Object flatCoordsInnerPoly = null;
        if (facts.dimension == 3 && facts.numSets > 1) {
            flatCoordsInnerPoly = new double[facts.numSets - 1][];
            for (int i = 1; i < facts.numSets; ++i) {
                flatCoordsInnerPoly[i - 1] = this.getFlatArray((ArrayList)coordinates.get(i), this.getArrayListFacts((ArrayList)coordinates.get(i)));
            }
        }
        return flatCoordsInnerPoly;
    }

    private void trySupportNonStandardGeoJSON(Map mapToSearch) {
        ArrayList<Map> innerMapsWithType = new ArrayList<Map>();
        for (Object key : mapToSearch.keySet()) {
            if (!(mapToSearch.get(key) instanceof Map)) continue;
            Map innerMap = (Map)mapToSearch.get(key);
            if (innerMap.containsKey("type")) {
                innerMapsWithType.add(innerMap);
            }
            this.trySupportNonStandardGeoJSON(innerMap);
        }
        this.addEachType(innerMapsWithType);
    }

    private void addEachType(ArrayList<Map> mapsWithTypeEntry) {
        if (mapsWithTypeEntry == null || mapsWithTypeEntry.isEmpty()) {
            return;
        }
        for (Map map : mapsWithTypeEntry) {
            Object coorObj = map.get("coordinates");
            if (!(coorObj instanceof ArrayList)) continue;
            String type = map.get("type").toString();
            Object propertiesObj = map.get("properties");
            Map properties = propertiesObj == null || !(propertiesObj instanceof Map) ? null : (Map)propertiesObj;
            this.addFeature(type, properties, (ArrayList)coorObj);
        }
    }

    @InternalUseOnly
    public MapKBT getGeoJSONMap() {
        return this.geoJSONMap;
    }

    public void setEnableJSONSearch(boolean enabled) {
        this.enableJSONSearch = enabled;
    }

    public void setEnableJSONSearch(String enabled) {
        this.setEnableJSONSearch(Convert.s2z(enabled));
    }

    @Override
    public void connect(int mode) {
        Shell.warning("GeoJSONFile.connect(int) is unimplemented ");
    }

    @Override
    public int read(Data data, int elements) {
        Shell.warning("GeoJSONFile.read(Data,int) is unimplemented ");
        return -1;
    }

    @Override
    public int readDataTable(Table tbl) {
        Shell.warning("GeoJSONFile.readDataTable(Table) is unimplemented ");
        return 0;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public double getStart() {
        return this.ystart;
    }

    @Override
    public double getDelta() {
        return this.ydelta;
    }

    @Override
    public int getUnits() {
        return this.yunits;
    }

    @Override
    public double getXStart() {
        return this.xstart;
    }

    @Override
    public double getXDelta() {
        return this.xdelta;
    }

    @Override
    public int getXUnits() {
        return this.xunits;
    }

    @Override
    public int getXFrame() {
        return this.xframe;
    }

    @Override
    public double getYStart() {
        return this.ystart;
    }

    @Override
    public double getYDelta() {
        return this.ydelta;
    }

    @Override
    public int getYUnits() {
        return this.yunits;
    }

    @Override
    public int getYFrame() {
        return this.yframe;
    }

    @Override
    public double getTimeAt(double offset) {
        return this.timecode;
    }

    public void setFormat(String value) {
        this.format = value;
    }

    public void setXStart(double value) {
        this.xstart = value;
    }

    public void setXDelta(double value) {
        this.xdelta = value;
    }

    public void setXUnits(int value) {
        this.xunits = value;
    }

    public void setXFrame(int value) {
        this.xframe = value;
    }

    public void setYStart(double value) {
        this.ystart = value;
    }

    public void setYDelta(double value) {
        this.ydelta = value;
    }

    public void setYUnits(int value) {
        this.yunits = value;
    }

    public void setYFrame(int value) {
        this.yframe = value;
    }

    public void setTimeCode(double value) {
        this.timecode = value;
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public Data getDataBuffer(int size) {
        return null;
    }

    class ArrayListFacts {
        int dimension;
        int numSets;
        int atomsPerElem;
        int numElements;

        ArrayListFacts(int dimension, int numSets, int numElements, int atomsPerElem) {
            this.dimension = dimension;
            this.numSets = numSets;
            this.numElements = numElements;
            this.atomsPerElem = atomsPerElem;
        }

        ArrayListFacts(ArrayListFacts facts) {
            this.dimension = facts.dimension;
            this.numSets = facts.numSets;
            this.numElements = facts.numElements;
            this.atomsPerElem = facts.atomsPerElem;
        }

        public String toString() {
            return "ArrayListFacts: dimension:" + this.dimension + " numSets:" + this.numSets + " numElements:" + this.numElements + " atomsPerElem:" + this.atomsPerElem;
        }
    }
}

