/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.ListFile;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.PlotFile;
import nxm.sys.inc.PlotFileNH;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.DataFileHeader;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Foreign;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.JsonUtilities;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.Keywords;
import nxm.sys.lib.LogUtilities;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.PlotFileGetLayerModSwap;
import nxm.sys.lib.ReflectUtil;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StateVector;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Time;
import nxm.sys.lib.TimeLine;
import nxm.sys.lib.Util;

public final class FileUtil {
    public static final Pattern COMMA_OR_PATH_SEPARATOR = Pattern.compile("[," + File.pathSeparator + "]");
    private static final Pattern FILE_SEPARATOR = Pattern.compile("[/\\\\]");
    private static final Pattern WINDOWS_DRIVE = Pattern.compile("^[a-zA-Z]:.*");
    private static final Pattern SLASH_WINDOWS_DRIVE = Pattern.compile("^[/\\\\][a-zA-Z]:.*");
    private static String[] localPrefixList = null;
    public static final Object[] PROPAGATE = new Object[0];
    private static Constructor<?> urlConstructor2Arg = ReflectUtil.getConstructorOfClass(URL.class, URL.class, String.class);
    private static boolean useDeprecatedUrlAPI = urlConstructor2Arg != null;
    private static final CopyOption[] PRESERVE = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES};
    private static final CopyOption[] NO_PRESERVE = new CopyOption[0];
    private static final Set<PosixFilePermission> DEF_PERMISSIONS = FileUtil.getDefaultPosixFilePermissions();

    private FileUtil() {
    }

    public static void copyBaseFile(Midas midas, Object inFile, Object outFile) {
        FileUtil.copyBaseFile(midas, inFile, outFile, BaseFile.BUFFER_SIZE);
    }

    public static void copyBaseFile(Midas midas, Object inFile, Object outFile, int bufSize) {
        double pause;
        byte[] buf = new byte[bufSize];
        boolean done = false;
        BaseFile in = inFile instanceof BaseFile ? (BaseFile)inFile : new BaseFile(midas, inFile);
        BaseFile out = outFile instanceof BaseFile ? (BaseFile)outFile : new BaseFile(midas, outFile);
        double d = pause = midas != null ? midas.pause : 0.0125;
        if (!in.isOpen() && !in.open(1)) {
            throw new MidasException("BaseFile: Error opening URL=" + in.getURL() + " for INPUT.");
        }
        if (!out.isOpen() && !out.open(2)) {
            throw new MidasException("BaseFile: Error opening URL=" + out.getURL() + " for OUTPUT.");
        }
        if (out.getQualifiers().getState("PREALLOCATELENGTH", true)) {
            long inFileLen = in.getResource().getLength();
            IOResource ores = out.getResource();
            ores.setLength(inFileLen);
            if (ores.getLength() < inFileLen) {
                out.getResource().setLength(inFileLen);
            }
        }
        while (!done) {
            int bytesRead = in.read(buf, 0, buf.length);
            if (bytesRead == 0) {
                Time.sleep(pause);
                continue;
            }
            if (bytesRead < 0) {
                done = true;
                continue;
            }
            out.write(buf, 0, bytesRead);
        }
        in.close();
        out.close();
    }

    public static void copyListFile(Midas midas, Object inFile, Object outFile) {
        FileUtil.copyListFile(midas, inFile, outFile, PROPAGATE);
    }

    public static void copyListFile(Midas midas, Object inFile, Object outFile, Object[] cols) {
        FileUtil.copyListFile(midas, inFile, outFile, cols, 0);
    }

    public static void copyListFile(Midas midas, Object inFile, Object outFile, Object[] cols, String hdrPropMask) {
        int propmask = Parser.mask("Header,Keywords,KeywordMain,KeywordExt,TimeCode,PacketHandler", hdrPropMask, -1);
        FileUtil.copyListFile(midas, inFile, outFile, cols, propmask);
    }

    public static void copyListFile(Midas midas, Object inFile, Object outFile, Object[] cols, int hdrPropMask) {
        Table colDefs;
        ListFile in = (ListFile)((Object)BaseFile.getInstanceFor(midas, inFile));
        ListFile out = (ListFile)((Object)BaseFile.getInstanceFor(midas, outFile));
        if (!in.open(1)) {
            throw new MidasException("BaseFile: Error opening URL=" + in.getURL() + " for INPUT.");
        }
        if (hdrPropMask != 0) {
            if (in instanceof DataFile && out instanceof DataFile) {
                DataFile df = (DataFile)out;
                df.propagate((DataFile)in, hdrPropMask);
                df.setSubRecords("");
                df.setSize(0.0);
            } else if (in instanceof PlotFile && out instanceof PlotFile && (hdrPropMask & 1) != 0) {
                Table quals = new Table();
                quals.put("XDELTA", ((PlotFile)((Object)in)).getXDelta());
                quals.put("XFRAME", ((PlotFile)((Object)in)).getXFrame());
                quals.put("XSTART", ((PlotFile)((Object)in)).getXStart());
                quals.put("XUNITS", ((PlotFile)((Object)in)).getXUnits());
                quals.put("YDELTA", ((PlotFile)((Object)in)).getYDelta());
                quals.put("YFRAME", ((PlotFile)((Object)in)).getYFrame());
                quals.put("YSTART", ((PlotFile)((Object)in)).getYStart());
                quals.put("YUNITS", ((PlotFile)((Object)in)).getYUnits());
                quals.put("TYPE", ((PlotFile)((Object)in)).getType());
                quals.put("DELTA", ((PlotFile)((Object)in)).getDelta());
                quals.put("START", ((PlotFile)((Object)in)).getStart());
                quals.put("UNITS", ((PlotFile)((Object)in)).getUnits());
                KeyObject.setKeys(out, quals, null, 1);
            }
        }
        if (!out.open(2)) {
            throw new MidasException("BaseFile: Error opening URL=" + out.getURL() + " for OUTPUT.");
        }
        if (cols == PROPAGATE) {
            colDefs = in.getRecordDefs();
        } else if (cols == null) {
            colDefs = out.getRecordDefs();
        } else {
            Table inDefs = in.getRecordDefs();
            colDefs = new Table();
            for (int i = 0; i < cols.length; ++i) {
                String col = cols[i].toString();
                Table def = inDefs.getTable(col);
                if (def == null) {
                    def = FileUtil.recDef(col, null, null, null, null);
                }
                colDefs.put(col, (Object)def);
            }
        }
        String time = Convert.o2s(out.getName().getQualifier("TIME_NAME", ""));
        String absc = Convert.o2s(out.getName().getQualifier("ABSC_NAME", ""));
        String index = Convert.o2s(out.getName().getQualifier("INDEX_NAME", ""));
        if (time.startsWith("+")) {
            time = time.substring(1);
            if (in.getRecordDefs().containsKey(time)) {
                time = "";
            }
        }
        if (absc.startsWith("+")) {
            absc = absc.substring(1);
            if (in.getRecordDefs().containsKey(absc)) {
                absc = "";
            }
        }
        if (index.startsWith("+")) {
            index = time.substring(1);
            if (in.getRecordDefs().containsKey(index)) {
                index = "";
            }
        }
        if (cols == PROPAGATE) {
            String form;
            if (!time.isEmpty() && !colDefs.containsKey(time)) {
                form = out instanceof DataFile ? "SD" : null;
                colDefs.put(time, (Object)FileUtil.recDef(time, form, null, 1, 1));
            }
            if (!absc.isEmpty() && !colDefs.containsKey(absc)) {
                Integer units = in instanceof PlotFile ? Integer.valueOf(((PlotFile)((Object)in)).getUnits()) : null;
                colDefs.put(absc, (Object)FileUtil.recDef(absc, "SD", null, 1, units));
            }
            if (!index.isEmpty() && !colDefs.containsKey(index)) {
                form = in.getNumberOfRows() <= 2.147483647E9 ? "SL" : "SX";
                colDefs.put(index, (Object)FileUtil.recDef(index, form, null, 1, null));
            }
        }
        out.setRecordDefs(colDefs);
        if (in instanceof DataFile) {
            DataFile df = (DataFile)in;
            Table data = new Table();
            DataFile dftc = null;
            if ((hdrPropMask & 0x10) != 0 && out instanceof DataFile && df.getTimeLineHandler() != null) {
                dftc = (DataFile)out;
            }
            df.seek(0.0);
            long row = 0L;
            while (true) {
                Time _time = df.getTimeAtCurrent();
                double _absc = df.getStart() + df.getDelta() * (double)row;
                int numRead = df.readDataTable(data);
                if (numRead >= 0) {
                    data.put(time, (Object)_time);
                    data.put(absc, _absc);
                    data.put(index, row);
                    if (dftc != null) {
                        dftc.setTimeAt(_time);
                    }
                    out.insertData(-1.0, data);
                    ++row;
                    continue;
                }
                break;
            }
        } else if (in instanceof PlotFile) {
            PlotFile pf = (PlotFile)((Object)in);
            if (pf.getUnits() != 1 || pf.getUnits() != 4) {
                time = "";
            }
            pf.seek(0.0);
            long row = 0L;
            while ((double)row < in.getNumberOfRows()) {
                double _absc = pf.getStart() + pf.getDelta() * (double)row;
                Table data = in.getDataTable(row);
                data.put(time, (Object)new Time(_absc));
                data.put(absc, _absc);
                data.put(index, row);
                out.insertData(-1.0, data);
                ++row;
            }
        } else {
            long row = 0L;
            while ((double)row < in.getNumberOfRows()) {
                Table data = in.getDataTable(row);
                data.put(index, row);
                out.insertData(-1.0, data);
                ++row;
            }
        }
        in.close();
        out.close();
    }

    public static boolean makeDirSymLink(String linkName, String targetOfLink) throws MidasException {
        Path linkNamePath = Paths.get(linkName, new String[0]);
        Path targetOfLinkPath = Paths.get(targetOfLink, new String[0]);
        if (!Files.isDirectory(targetOfLinkPath, new LinkOption[0])) {
            throw new MidasException("Unable to create dir symlink '" + linkName + "' since targetOfLink is not a directory: " + targetOfLink);
        }
        if (Files.exists(linkNamePath, new LinkOption[0])) {
            String existType = "file";
            if (Files.isSymbolicLink(linkNamePath)) {
                existType = "symlink";
            } else if (Files.isDirectory(linkNamePath, new LinkOption[0])) {
                existType = "directory";
            }
            Shell.warning("Cannot make symbolic link because a " + existType + " exists at " + linkName + " targetOfLink=" + targetOfLink);
            return false;
        }
        try {
            Files.createSymbolicLink(linkNamePath, targetOfLinkPath, new FileAttribute[0]);
            return true;
        }
        catch (FileAlreadyExistsException ex) {
            Shell.warning("Symbolic link was not created at '" + linkName + "' " + ex);
        }
        catch (FileSystemException ex) {
            if (Shell.isWindows()) {
                StringBuilder stderr;
                StringBuilder stdout;
                String cmdline = "cmd /c mklink /j " + linkName + " " + targetOfLink;
                int exitCode = Foreign.runInternal(cmdline, stdout = new StringBuilder(), stderr = new StringBuilder());
                if (exitCode == 0) {
                    return true;
                }
                Shell.warning("Unable to create directory junction point. mklink returned exit code: " + exitCode + "\n === stdout ===\n" + stdout + "\n === stderr ===\n" + stderr);
            } else {
                Shell.warnStackTrace("Symbolic link was not created at '" + linkName + "' to " + targetOfLink, ex);
            }
        }
        catch (IOException | UnsupportedOperationException ex) {
            Shell.warnStackTrace("Symbolic link was not created. at '" + linkName + "' to " + targetOfLink, ex);
        }
        return false;
    }

    public static Table recDef(String name, String format) {
        if (name == null) {
            throw new NullPointerException("Name required, given null.");
        }
        Table def = new Table();
        def.put("NAME", (Object)name);
        if (format != null) {
            def.put("FORMAT", (Object)format);
        }
        return def;
    }

    public static Table recDef(String name, String format, Integer offset, Object type, Object units) {
        Table def = FileUtil.recDef(name, format);
        if (offset != null) {
            def.put("OFFSET", (Object)offset);
        }
        if (type != null) {
            def.put("TYPE", type);
        }
        if (units != null) {
            def.put("UNITS", units);
        }
        return def;
    }

    public static ListFile asListFile(Object file) {
        if (file instanceof ListFile) {
            return (ListFile)file;
        }
        if (file instanceof PlotFileNH) {
            return new PlotFileAsListFile((PlotFileNH)file);
        }
        return null;
    }

    public static PlotFileNH asPlotFileNH(Object file) {
        if (file instanceof PlotFileNH) {
            return (PlotFileNH)file;
        }
        if (file instanceof PlotFile) {
            if (file instanceof ListFile) {
                return new PlotFileWrapper2((PlotFile)file, (ListFile)file);
            }
            return new PlotFileWrapper((PlotFile)file);
        }
        return null;
    }

    public static File getCanonicalFile(File file) {
        File canonical;
        try {
            canonical = file.getCanonicalFile();
        }
        catch (IOException e) {
            canonical = file.getAbsoluteFile();
        }
        return canonical;
    }

    public static URL getCanonicalUrl(URL url) {
        try {
            URI uri = new URI(url.toString());
            uri = uri.normalize();
            url = uri.toURL();
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    public static String getCanonicalPath(String path) {
        try {
            String local = FileUtil.toLocalFileName(path);
            path = local != null ? FileUtil.getCanonicalFile(new File(local)).toString() : FileUtil.getCanonicalUrl(new URI(path).toURL()).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    public static String getRelativeDir(File src, File dest) {
        return FileUtil.getRelativeDir(FileName.terminatePath(src.toString()), FileName.terminatePath(dest.toString()), File.separatorChar);
    }

    public static String getRelativeUrl(URL src, URL dest) {
        int srcPort = src.getPort();
        int destPort = dest.getPort();
        String srcStr = src.toString();
        String destStr = dest.toString();
        if (!srcStr.endsWith("/")) {
            srcStr = srcStr + "/";
        }
        if (!destStr.endsWith("/")) {
            destStr = destStr + "/";
        }
        String relDir = src.getProtocol().equals(dest.getProtocol()) && srcPort == destPort && src.getHost().equals(dest.getHost()) ? FileUtil.getRelativeDir(srcStr, destStr, '/') : destStr;
        return relDir;
    }

    private static String getRelativeDir(Object src, Object dest, char separator) {
        StringBuilder relDir = new StringBuilder();
        try {
            int i;
            String[] srcPath = FileUtil.splitPath(src.toString());
            String[] destPath = FileUtil.splitPath(dest.toString());
            for (int sameCount = 1; sameCount < srcPath.length && sameCount < destPath.length && srcPath[sameCount].equals(destPath[sameCount]); ++sameCount) {
            }
            for (i = sameCount; i < srcPath.length; ++i) {
                relDir.append("..").append(separator);
            }
            for (i = sameCount; i < destPath.length; ++i) {
                relDir.append(destPath[i]).append(separator);
            }
        }
        catch (Exception e) {
            Shell.printStackTrace(e);
        }
        return relDir.toString();
    }

    public static String toLocalFileName(URL url) {
        return FileUtil.toLocalFileName(url.toString());
    }

    public static boolean isLocalFileName(URL url) {
        return FileUtil.isLocalFileName(url.toString());
    }

    public static String[] splitEntries(String entries) {
        if (entries == null) {
            return StringUtil.EMPTY_STRING_ARRAY;
        }
        return COMMA_OR_PATH_SEPARATOR.split(entries, 0);
    }

    private static String[] splitPath(Object path) {
        return FILE_SEPARATOR.split(path.toString());
    }

    public static String getPathSeparator(String path) {
        if (path.indexOf(47) >= 0) {
            return "/";
        }
        if (path.indexOf(92) >= 0) {
            return "\\";
        }
        if (path.indexOf(91) >= 0) {
            return "[";
        }
        return null;
    }

    public static String terminatePath(String path) {
        String term = FileUtil.getPathSeparator(path);
        if (term == null) {
            term = File.separator;
        }
        return path.endsWith(term) ? path : path + term;
    }

    public static String changePathSeparator(String path, String separator) {
        String repl = StringUtil.textToReplacement(separator);
        return FILE_SEPARATOR.matcher(path).replaceAll(repl);
    }

    public static String toLocalFileName(String path) {
        String prefix = FileUtil.getLocalPrefix(path);
        String fname = null;
        if (prefix != null) {
            fname = path.substring(prefix.length());
            if (fname.startsWith("///")) {
                fname = fname.substring(2);
            } else if (SLASH_WINDOWS_DRIVE.matcher(fname).matches()) {
                fname = fname.substring(1);
            }
            fname = FileUtil.changePathSeparator(fname, File.separator);
        }
        return fname;
    }

    public static boolean isLocalFileName(String path) {
        return FileUtil.getLocalPrefix(path) != null;
    }

    public static URL toURL(String fileName) throws MalformedURLException {
        URL url = null;
        try {
            if (FileUtil.isLocalFileName(fileName)) {
                url = new File(fileName).toURI().toURL();
            } else if (fileName.startsWith("classpath:")) {
                IOResource ior = Shell.getMidasContext().io.findResource(fileName, 0);
                String urlStr = ior.getURL();
                url = new URI(urlStr).toURL();
            } else {
                url = new URI(fileName).toURL();
            }
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException("Forming URL via URI failed:" + e.getMessage() + " " + e.getStackTrace());
        }
        return url;
    }

    public static URL toURL(String contextFile, String fileName) throws MalformedURLException {
        URL url = null;
        boolean nonStandardURL = false;
        try {
            if (FileUtil.isLocalFileName(contextFile)) {
                String filePath = fileName.replace("\\", "/");
                if (filePath.charAt(1) == ':') {
                    filePath = "file:" + filePath;
                }
                url = new File(contextFile).toURI().resolve(filePath).toURL();
            } else {
                if (!contextFile.startsWith("file:")) {
                    contextFile = "file:" + contextFile;
                }
                if (useDeprecatedUrlAPI) {
                    URL contextURL = new URI(contextFile).toURL();
                    try {
                        return (URL)urlConstructor2Arg.newInstance(contextURL, fileName);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                        Shell.info("File.toURL(" + contextFile + "," + fileName + ") switching to alternate code for deprecated URL constructor");
                    }
                }
                if (fileName.contains(":")) {
                    contextFile = fileName;
                    nonStandardURL = true;
                } else if (contextFile.startsWith("file:ram:")) {
                    contextFile = "file:" + fileName;
                    nonStandardURL = true;
                } else {
                    int indexLastSlash;
                    int idx = contextFile.indexOf(47);
                    if (idx > 0 && contextFile.charAt(idx - 1) == ':' && contextFile.indexOf(58) < idx - 1 && (indexLastSlash = contextFile.lastIndexOf("/")) > 0) {
                        contextFile = contextFile.substring(0, indexLastSlash + 1) + fileName;
                        nonStandardURL = true;
                    }
                }
                if (nonStandardURL) {
                    URI tryURI = new URI(contextFile);
                    url = tryURI.toURL();
                } else {
                    URL contextURL = new URI(contextFile).toURL();
                    Path finalPath = Paths.get(contextURL.toString(), fileName);
                    URI tryURI = new URI(finalPath.toString());
                    url = tryURI.toURL();
                }
            }
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException("Forming URL via URI failed:" + e.getMessage() + " " + e.getStackTrace());
        }
        return url;
    }

    private static String getLocalPrefix(String path) {
        String prefix = null;
        if (path.indexOf(58) < 0) {
            prefix = "";
        } else if (WINDOWS_DRIVE.matcher(path).matches()) {
            prefix = "";
        } else {
            String[] list3 = FileUtil.getLocalPrefixList();
            for (int i = 0; prefix == null && i < list3.length; ++i) {
                if (!path.startsWith(list3[i])) continue;
                prefix = list3[i];
            }
        }
        return prefix;
    }

    public static boolean startsWithRootDir(String path) {
        return path.startsWith(File.separator) || WINDOWS_DRIVE.matcher(path).matches();
    }

    private static String[] getLocalPrefixList() {
        if (localPrefixList == null) {
            localPrefixList = new String[]{"file:", "ramd:", "ice:"};
        }
        return localPrefixList;
    }

    public static File[] findFiles(File dir, FileFilter filter) {
        ArrayList<File> allFiles = new ArrayList<File>();
        if (dir.isDirectory() && dir.exists()) {
            HashMap<File, File> dirMap = new HashMap<File, File>();
            File can = FileUtil.getCanonicalFile(dir);
            dirMap.put(can, dir);
            FileUtil.findFiles(dirMap, allFiles, dir, filter);
        }
        return allFiles.toArray(new File[allFiles.size()]);
    }

    private static void findFiles(HashMap<File, File> dirMap, List<File> allFiles, File dir, FileFilter filter) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File can;
            File file = files[i];
            if (filter == null || filter.accept(file)) {
                allFiles.add(file);
            }
            if (!file.isDirectory() || dirMap.get(can = FileUtil.getCanonicalFile(file)) != null) continue;
            dirMap.put(can, file);
            FileUtil.findFiles(dirMap, allFiles, file, filter);
        }
    }

    public static int recursiveDelete(File file) {
        if (file == null) {
            return 0;
        }
        int count = 0;
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                count += FileUtil.recursiveDelete(child);
            }
        }
        if (file.delete()) {
            ++count;
        }
        return count;
    }

    public static int recursiveDelete(String path) {
        return FileUtil.recursiveDelete(new File(path));
    }

    public static FnFilter createFnFilter(String filter, String def) {
        return FileUtil.createFnFilter(null, filter, def);
    }

    public static FnFilter createFnFilter(String root, String filter, String def) {
        ArrayList<String> incPath = new ArrayList<String>();
        ArrayList<String> excPath = new ArrayList<String>();
        ArrayList<String> incFile = new ArrayList<String>();
        ArrayList<String> excFile = new ArrayList<String>();
        boolean includeDef = false;
        boolean includeAll = false;
        if (filter == null || filter.length() == 0) {
            filter = def != null ? def : "*";
        }
        String[] filtList = filter.split("[|]");
        int index = 0;
        if (filtList[0].equalsIgnoreCase("ALL") || filtList[0].equalsIgnoreCase("*")) {
            includeAll = true;
            ++index;
        } else if (filtList[0].equalsIgnoreCase("NONE")) {
            ++index;
        } else if (filtList[0].equalsIgnoreCase("DEF") || filtList[0].equalsIgnoreCase("DEFAULT")) {
            includeDef = true;
            ++index;
        } else if (filtList[0].startsWith("+") || filtList[0].startsWith("-")) {
            includeDef = true;
        }
        if (includeDef) {
            String[] defList;
            includeAll = def == null ? true : FileUtil.makeFilterList(incPath, incFile, excPath, excFile, defList = def.split("[|]"), 0) || includeAll;
        }
        boolean bl = includeAll = FileUtil.makeFilterList(incPath, incFile, excPath, excFile, filtList, index) || includeAll;
        if (includeAll) {
            incFile = null;
            incPath = null;
        }
        return new FnFilterImpl(root, incPath, incFile, excPath, excFile);
    }

    private static boolean makeFilterList(List<String> incPath, List<String> incFile, List<String> excPath, List<String> excFile, String[] list3, int index) {
        boolean includeAll = false;
        while (index < list3.length) {
            String filt = list3[index];
            boolean excl = false;
            if (filt.startsWith("-")) {
                filt = filt.substring(1);
                excl = true;
            } else if (filt.startsWith("+")) {
                filt = filt.substring(1);
                excl = false;
            }
            if (filt.length() != 0) {
                if (excl) {
                    if (filt.indexOf(47) >= 0) {
                        excPath.add(filt);
                    } else {
                        excFile.add(filt);
                    }
                } else if (filt.equals("*")) {
                    includeAll = true;
                } else if (filt.indexOf(47) >= 0) {
                    incPath.add(filt);
                } else {
                    incFile.add(filt);
                }
            }
            ++index;
        }
        return includeAll;
    }

    public static long lastModified(URL url) {
        long dateInSeconds = -1L;
        if (FileUtil.isLocalFileName(url.toString())) {
            dateInSeconds = (long)((double)new File(url.getPath()).lastModified() * 0.001);
        } else {
            try {
                URLConnection conn = url.openConnection();
                dateInSeconds = (long)((double)conn.getLastModified() * 0.001);
            }
            catch (IOException e) {
                Shell.printStackTrace(e);
            }
        }
        return dateInSeconds;
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int numRead;
        byte[] buf = new byte[23768];
        while ((numRead = in.read(buf)) > 0) {
            out.write(buf, 0, numRead);
        }
    }

    @InternalUseOnly(value="Since created")
    public static void test(String in, String out) {
        FileName keyConvFileName = new FileName("nxm.sys.dat.keyconv_plat2blue.tbl", FileName.FNCase.KeepCase);
        Table kwconv = new Table(new TextFile(keyConvFileName));
        kwconv.put("TOA_SIGMA.VALUE", 1);
        kwconv.put("FOA_SIGMA.VALUE", 2);
        FileUtil.convertKeywords(null, new FileName(in), new FileName(out), kwconv);
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.5.4")
    public static void convertKeywords(MidasReference ref, FileName in, FileName out, Table kwconv) {
        try (DataFile inDF = new DataFile(ref, (Object)in);
             BaseFile inFile = new BaseFile(ref, (Object)in);
             BaseFile outFile = new BaseFile(ref, (Object)out);){
            inDF.open();
            inFile.open(1);
            outFile.open(2);
            FileUtil.copy(inFile.io.getInputStream(), outFile.io.getOutputStream());
        }
        catch (Exception e) {
            throw new MidasException("Unable to create " + out + " from " + in, e);
        }
        DataFile df = new DataFile(ref, (Object)out);
        df.setQualifier("PROT", "FALSE");
        FileUtil.convertKeywordsInPlace(ref, df, kwconv);
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.5.4")
    public static void convertKeywordsInPlace(MidasReference ref, DataFile df, Table kwconv) {
        Keywords kw = df.getKeywordsObject();
        boolean closeDF = false;
        if (!df.isOpen()) {
            if (!kwconv.getState("_WARN_MISSING_", false)) {
                df.setAutoConvertPlatinum(false);
            }
            df.open(3);
            closeDF = true;
        }
        FileUtil.convertKeywordsInPlace(ref, df, kw, kwconv);
        if (closeDF) {
            df.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void convertKeywordsInPlace(MidasReference ref, DataFile df, Keywords kw, Table kwconv) {
        Table kwds = new Table();
        Table opts = kwconv.getTable("_OPTIONS_", new Table());
        boolean warnMissing = kwconv.getState("_WARN_MISSING_", false);
        String keys = null;
        try {
            for (String key : kwconv.getKeys()) {
                if (key.startsWith("_") && key.endsWith("_")) continue;
                Table ct = kwconv.getTable(key);
                keys = ct.getS("KEYS", key);
                String type = ct.getS("TYPE", null);
                String source = ct.getS("SOURCE", null);
                String sourceAlt = ct.getS("SOURCE_ALTERNATE", null);
                String conversion = ct.getS("CONVERSION", "NONE");
                Object val = ct.get("VALUE", null);
                String inlineFunc = ct.getS("INLINE_FUNC", null);
                String javaFunc = ct.getS("JAVA_FUNC", null);
                boolean required = ct.getState("REQUIRED", false);
                Table mapping = ct.getTable("MAPPING", null);
                if (!ct.containsKey("VALUE")) {
                    if (conversion.equals("MAPPING")) {
                        if (mapping == null) {
                            throw new NullPointerException("Missing MAPPING=");
                        }
                        val = kw.getKey(source);
                        if (val != null) {
                            val = mapping.get(val.toString());
                        }
                        if (val == null) {
                            val = ct.get("DEFAULT");
                        }
                    } else if (conversion.equals("INLINE_FUNC")) {
                        if (inlineFunc == null) {
                            throw new NullPointerException("Missing INLINE_FUNC=");
                        }
                        val = kw.getKey(source);
                        if (val != null) {
                            int i;
                            MidasReference m = null;
                            while ((i = inlineFunc.indexOf(94)) >= 0) {
                                String k;
                                int j;
                                if (i < inlineFunc.length() - 1 && inlineFunc.charAt(i + 1) == '{') {
                                    j = inlineFunc.indexOf(125, i + 1) + 1;
                                    if (j <= 0) {
                                        throw new IllegalArgumentException("Missing '}' in " + inlineFunc);
                                    }
                                    k = inlineFunc.substring(i + 2, j - 1);
                                } else {
                                    for (j = i + 1; j < inlineFunc.length() && inlineFunc.substring(j, j + 1).matches("[A-Za-z0-9_.]"); ++j) {
                                    }
                                    k = inlineFunc.substring(i + 1, j);
                                }
                                Object v = kw.getKey(k);
                                if (v == null) {
                                    v = "0";
                                }
                                inlineFunc = inlineFunc.substring(0, i) + v + inlineFunc.substring(j);
                            }
                            if (inlineFunc.startsWith("CALC(")) {
                                val = new Data(Convert.inLineCalc(m, inlineFunc));
                            } else if (inlineFunc.startsWith("SEDIT(")) {
                                val = Convert.inLineSedit(m, inlineFunc);
                            } else {
                                if (!inlineFunc.startsWith("TEST(")) throw new IllegalArgumentException("Unsupported INLINE_FUNC=" + inlineFunc);
                                val = Convert.inLineTest(m, inlineFunc);
                            }
                        } else {
                            val = ct.get("DEFAULT");
                        }
                    } else {
                        if (conversion.equals("JAVA_FUNC")) {
                            if (javaFunc == null) {
                                throw new NullPointerException("Missing JAVA_FUNC=");
                            }
                            int indexDot = javaFunc.lastIndexOf(46);
                            String className = javaFunc.substring(0, indexDot);
                            String methodName = javaFunc.substring(indexDot + 1);
                            Class<?> classObj = Class.forName(className);
                            Method method = classObj.getMethod(methodName, MidasReference.class, DataFile.class, Keywords.class, Table.class, String.class, Table.class);
                            method.invoke(null, ref, df, kw, kwconv, key, kwds);
                            continue;
                        }
                        if (!conversion.equals("NONE")) {
                            throw new IllegalArgumentException("Unsupported CONVERSION=" + conversion);
                        }
                        if (source == null) {
                            val = ct.get("DEFAULT");
                        } else {
                            val = kw.getKey(source);
                            if (val == null && sourceAlt != null) {
                                val = kw.getKey(sourceAlt);
                            }
                            if (val == null) {
                                val = ct.get("DEFAULT");
                            }
                        }
                    }
                }
                if (val != null) {
                    for (String k : keys.split(",")) {
                        String keyname = type == null ? k : type + ":" + k;
                        kwds.put(keyname, val);
                    }
                    continue;
                }
                if (!required) continue;
                for (String k : keys.split(",")) {
                    if (FileUtil.hasKeyword(kwds, k)) continue;
                    if (!warnMissing) throw new RuntimeException("No value found.");
                    ref.getMidas().warning("INCOMPLETE conversion of PLATINUM file. Source file is missing source key " + source + " for " + key + ".\n      file:" + df.filename);
                }
            }
            keys = null;
            String verifier = opts.getS("VERIFIER");
            if (verifier != null && !warnMissing) {
                int indexDot = verifier.lastIndexOf(46);
                String className = verifier.substring(0, indexDot);
                String methodName = verifier.substring(indexDot + 1);
                Class<?> classObj = Class.forName(className);
                Method method = classObj.getMethod(methodName, MidasReference.class, DataFile.class, Keywords.class, Table.class, Table.class);
                method.invoke(null, ref, df, kw, kwconv, kwds);
            }
        }
        catch (InvocationTargetException e) {
            if (keys != null) throw new MidasException("Could not set " + keys + " in " + df.getName(), e.getCause());
            keys = "keywords";
            throw new MidasException("Could not set " + keys + " in " + df.getName(), e.getCause());
        }
        catch (Exception e) {
            if (keys != null) throw new MidasException("Could not set " + keys + " in " + df.getName(), e);
            keys = "keywords";
            throw new MidasException("Could not set " + keys + " in " + df.getName(), e);
        }
        boolean keepExisting = opts.getState("KEEP_EXISTING", false);
        if (!keepExisting) {
            kw.deleteScope("EXT");
        }
        kw.setScope("EXT");
        kw.putAll(kwds);
    }

    @InternalUseOnly
    public static boolean hasKeyword(Table kwds, String key) {
        return FileUtil.getKeywordKey(kwds, key) != null;
    }

    @InternalUseOnly
    public static String getKeywordKey(Table kwds, String key) {
        String[] keys = kwds.getKeys();
        for (int i = keys.length - 1; i >= 0; --i) {
            String k = keys[i];
            if (k.equals(key)) {
                return k;
            }
            if (k.length() <= 2 || k.charAt(1) != ':' || !k.substring(2).equals(key)) continue;
            return k;
        }
        return null;
    }

    @InternalUseOnly
    public static void removeKeyword(Table kwds, String key) {
        kwds.remove(key);
        for (String k : kwds.getKeys()) {
            if (k.length() <= 2 || k.charAt(1) != ':' || !k.substring(2).equals(key)) continue;
            kwds.remove(k);
        }
    }

    @InternalUseOnly(value="Called via reflection by convertKeywordsInPlace(..) to support kwconv_plat2blue.tbl")
    public static void kwconvVerifyBlueKW(MidasReference ref, DataFile df, Keywords kw, Table kwconv, Table kwds) {
        String antKey = FileUtil.getKeywordKey(kwds, "ANTENNA");
        if (FileUtil.hasKeyword(kwds, "ANT_LAT") || FileUtil.hasKeyword(kwds, "ANT_LON") || FileUtil.hasKeyword(kwds, "ANT_ALT")) {
            if (!FileUtil.hasKeyword(kwds, "ANT_LAT")) {
                throw new MidasException("No TERMINAL.LAT found");
            }
            if (!FileUtil.hasKeyword(kwds, "ANT_LON")) {
                throw new MidasException("No TERMINAL.LON found");
            }
            if (!FileUtil.hasKeyword(kwds, "ANT_ALT")) {
                throw new MidasException("No TERMINAL.ALT found");
            }
            if (antKey != null && kwds.getS(antKey).equalsIgnoreCase("NULL")) {
                FileUtil.removeKeyword(kwds, "ANTENNA");
            }
        } else if (antKey == null || kwds.getS(antKey).equalsIgnoreCase("NULL")) {
            kwds.put("S:ANTENNA", (Object)"NONE");
        }
        if (FileUtil.hasKeyword(kwds, "SYSTEM_TOA_SIGMA") || FileUtil.hasKeyword(kwds, "SYSTEM_FOA_SIGMA")) {
            if (!FileUtil.hasKeyword(kwds, "SYSTEM_TOA_SIGMA")) {
                throw new MidasException("No SYSTEM_TOA_SIGMA found");
            }
            if (!FileUtil.hasKeyword(kwds, "SYSTEM_FOA_SIGMA")) {
                throw new MidasException("No SYSTEM_FOA_SIGMA found");
            }
        }
        if (FileUtil.hasKeyword(kwds, "POS_COVAR_MTX11") || FileUtil.hasKeyword(kwds, "TOA_SIGMA") || FileUtil.hasKeyword(kwds, "FOA_SIGMA")) {
            if (!FileUtil.hasKeyword(kwds, "POS_COVAR_MTX11")) {
                throw new MidasException("No COV found");
            }
            if (!FileUtil.hasKeyword(kwds, "TOA_SIGMA")) {
                throw new MidasException("No TOA_SIGMA found");
            }
            if (!FileUtil.hasKeyword(kwds, "FOA_SIGMA")) {
                throw new MidasException("No FOA_SIGMA found");
            }
        }
    }

    @InternalUseOnly(value="Called via reflection by convertKeywordsInPlace(..) to support kwconv_plat2blue.tbl")
    public static void kwconvConvertSV(MidasReference ref, DataFile df, Keywords kw, Table kwconv, String key, Table kwds) {
        StateVector sv;
        Table ct = kwconv.getTable(key);
        String fmt = ct.getS("JAVA_FUNC_OPTS.FORMAT", null);
        try {
            sv = new StateVector(df);
        }
        catch (MidasException nosv) {
            Shell.warning("INCOMPLETE conversion of PLATINUM file.missing StateVector data.\n      file:" + df.filename);
            return;
        }
        if (fmt == null) {
            kwds.putAll(sv.toKeywordsEph());
        } else if (fmt.equals("EPH")) {
            kwds.putAll(sv.toKeywordsEph());
        } else if (fmt.equals("PLAT")) {
            kwds.putAll(sv.toKeywordsPlat(df));
        } else if (fmt.equals("VEC")) {
            kwds.putAll(sv.toKeywordsVec());
        } else {
            throw new MidasException("Could not set StateVector keys " + df.getName() + ": Unsupported format " + fmt);
        }
    }

    @InternalUseOnly(value="Called via reflection by convertKeywordsInPlace(..) to support kwconv_plat2blue.tbl")
    public static void kwconvConvertTC(MidasReference ref, DataFile df, Keywords kw, Table kwconv, String key, Table kwds) {
        if (df.timeLine != null) {
            df.timeLine.format = TimeLine.Format.BLUE_HIGH_PRECISION;
        }
    }

    @InternalUseOnly(value="Called via reflection by convertKeywordsInPlace(..) to support kwconv_plat2blue.tbl")
    public static void kwconvConvertCOVAR(MidasReference ref, DataFile df, Keywords kw, Table kwconv, String key, Table kwds) {
        Data cov = (Data)kw.getKey("COV");
        if (cov == null) {
            return;
        }
        String[] KEYS = new String[]{"POS_COVAR_MTX11", "POS_COVAR_MTX12", "POS_COVAR_MTX13", "POS_COVAR_MTX14", "POS_COVAR_MTX15", "POS_COVAR_MTX16", "POS_COVAR_MTX22", "POS_COVAR_MTX23", "POS_COVAR_MTX24", "POS_COVAR_MTX25", "POS_COVAR_MTX26", "POS_COVAR_MTX33", "POS_COVAR_MTX34", "POS_COVAR_MTX35", "POS_COVAR_MTX36", "VEL_COVAR_MTX11", "VEL_COVAR_MTX12", "VEL_COVAR_MTX13", "VEL_COVAR_MTX22", "VEL_COVAR_MTX23", "VEL_COVAR_MTX33"};
        for (int i = 0; i < KEYS.length; ++i) {
            kwds.put("D:" + KEYS[i], (Object)cov.getNumber(i));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @InternalUseOnly(value="Called via reflection by convertKeywordsInPlace(..) to support kwconv_plat2blue.tbl")
    public static void kwconvConvertSBT(MidasReference ref, DataFile df, Keywords kw, Table kwconv, String key, Table kwds) {
        Integer specSenseMultiplier;
        Double sbt = kw.getD("ACQETF", null);
        if (sbt == null && (specSenseMultiplier = FileUtil.getSpectralSenseMultiplier(kw)) != null) {
            Double sbt_offset = FileUtil.getSbtOffset(kw);
            Double col_rf = kw.getD("COL_RF", null);
            if (sbt_offset != null && col_rf != null) {
                sbt = col_rf + (double)specSenseMultiplier.intValue() * sbt_offset;
            } else {
                Double col_locked_lo = kw.getD("COL_LOCKED_LO", null);
                Double gnd_locked_lo = kw.getD("GND_LOCKED_LO", null);
                Double fTIF = kw.getD("OUTPUT_IF", null);
                if (col_locked_lo != null && gnd_locked_lo != null && fTIF != null) {
                    sbt = col_locked_lo + gnd_locked_lo + (double)specSenseMultiplier.intValue() * fTIF;
                }
            }
        }
        if (sbt == null) {
            if (!kwconv.getState("_WARN_MISSING_", false)) throw new NullPointerException("No ACQETF or COL_RF to calculate SBT in PLATINUM file");
            Shell.warning("INCOMPLETE conversion of PLATINUM file. No ACQETF or COL_RF found in PLATINUM source file to calculate SBT..\n      file:" + df.filename);
            return;
        } else {
            kwds.put("D:SBT", (Object)sbt);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @InternalUseOnly(value="Called via reflection by convertKeywordsInPlace(..) to support kwconv_plat2blue.tbl")
    public static void kwconvConvertVRF(MidasReference ref, DataFile df, Keywords kw, Table kwconv, String key, Table kwds) {
        Double vrf = kw.getD("COL_RF", null);
        if (vrf == null) {
            Double sbt_offset = FileUtil.getSbtOffset(kw);
            Integer specSenseMultiplier = FileUtil.getSpectralSenseMultiplier(kw);
            if (specSenseMultiplier != null) {
                Double col_locked_lo = kw.getD("COL_LOCKED_LO", null);
                Double gnd_locked_lo = kw.getD("GND_LOCKED_LO", null);
                Double fNOM = kw.getD("COL_IF_CENTER", null);
                if (col_locked_lo != null && gnd_locked_lo != null && fNOM != null) {
                    vrf = col_locked_lo + gnd_locked_lo + (double)specSenseMultiplier.intValue() * fNOM;
                }
            }
        }
        if (vrf == null) {
            if (!kwconv.getState("_WARN_MISSING_", false)) throw new NullPointerException("No COL_RFF or keyword pairs to calculate VRF in PLATINUM file");
            Shell.warning("INCOMPLETE conversion of PLATINUM file. No COL_RFF or keyword pairs found in PLATINUM source file to calculate VRF.\n      file:" + df.filename);
            return;
        } else {
            kwds.put("D:VRF", (Object)vrf);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @InternalUseOnly(value="Called via reflection by convertKeywordsInPlace(..) to support kwconv_plat2blue.tbl")
    public static void kwconvConvertFNOM(MidasReference ref, DataFile df, Keywords kw, Table kwconv, String key, Table kwds) {
        Double fNOM = kw.getD("COL_IF_CENTER", null);
        if (fNOM == null) {
            Double fTIF = kw.getD("OUTPUT_IF", null);
            Double sbt_offset = FileUtil.getSbtOffset(kw);
            if (fTIF != null && sbt_offset != null) {
                fNOM = fTIF - sbt_offset;
            } else {
                Integer specSenseMultiplier = FileUtil.getSpectralSenseMultiplier(kw);
                Double col_locked_lo = kw.getD("COL_LOCKED_LO", null);
                Double gnd_locked_lo = kw.getD("GND_LOCKED_LO", null);
                Double sbt = kw.getD("ACQETF", null);
                if (specSenseMultiplier != null && col_locked_lo != null && gnd_locked_lo != null && sbt != null) {
                    fNOM = (sbt - (col_locked_lo + gnd_locked_lo)) * (double)specSenseMultiplier.intValue();
                }
            }
        }
        if (fNOM == null) {
            if (!kwconv.getState("_WARN_MISSING_", false)) throw new NullPointerException("No COL_IF_CENTER or keyword pairs to calculate FNOM in PLATINUM file");
            Shell.warning("INCOMPLETE conversion of PLATINUM file. No COL_IF_CENTER or keyword pairs found in PLATINUM source file to calculate FNOM.\n      file:" + df.filename);
            return;
        } else {
            kwds.put("D:FNOM", (Object)fNOM);
        }
    }

    private static Double getSbtOffset(Keywords kw) {
        Double sbt_offset = null;
        Integer sbt_offset_correct = kw.getL("SBT_OFFSET_CORRECT", null);
        if (sbt_offset_correct != null && sbt_offset_correct == 1) {
            sbt_offset = kw.getD("SBT_OFFSET", null);
        }
        return sbt_offset;
    }

    private static Integer getSpectralSenseMultiplier(Keywords kw) {
        Integer multiplier = null;
        Integer data_inversion_flag = kw.getL("DATA_INVERSION_FLAG", null);
        if (data_inversion_flag != null) {
            int flagValue = data_inversion_flag;
            switch (flagValue) {
                case 0: {
                    multiplier = 1;
                    break;
                }
                case 1: {
                    multiplier = -1;
                }
            }
        }
        return multiplier;
    }

    @InternalUseOnly
    public static void convertBlue2JSON(MidasReference ref, FileName datafileName, FileName textfileName, Table convTbl) {
        DataFile df = new DataFile(ref, (Object)datafileName);
        DataFileHeader dfHeader = new DataFileHeader(df);
        Table dfHeaderKeywordData = dfHeader.getHeaderAndKeywordsAsTable();
        Table dfRecordData = null;
        Table kwds = new Table();
        Table opts = convTbl.getTable("_OPTIONS_", new Table());
        boolean warnMissing = convTbl.getState("_WARN_MISSING_", false);
        HashMap<String, Object> nestedKwds = new HashMap<String, Object>();
        String keys = null;
        try {
            for (String key : convTbl.getKeys()) {
                if (key.startsWith("_") && key.endsWith("_")) continue;
                Table ct = convTbl.getTable(key);
                FileUtil.buildStructure(nestedKwds, key, df, ct, dfHeaderKeywordData, dfRecordData);
            }
            keys = null;
        }
        catch (InvocationTargetException e) {
            if (keys == null) {
                keys = "keywords";
            }
            throw new MidasException("2JSON InvocationTargetException failed with exception:", e);
        }
        catch (Exception e) {
            if (keys == null) {
                keys = "keywords";
            }
            System.out.println("convertHeadKey2JSON exception information:" + e.getSuppressed() + " " + e.getCause() + " " + e.getStackTrace());
            throw new MidasException("2JSON failed with exception:", e);
        }
        String json = JsonUtilities.toJSON(nestedKwds).toString();
        TextFile out = new TextFile(textfileName);
        out.open(2);
        out.write(json);
        out.close();
    }

    private static void buildStructure(Map<String, Object> nestedMap, String key, DataFile df, Table ct, Table dfHeaderKeywordData, Table dfRecordData) throws Exception {
        String type = ct.getS("TYPE", null);
        if ("MAP".equals(type)) {
            HashMap<String, Object> subMap = new HashMap<String, Object>();
            for (String subKey : ct.getKeys()) {
                if ("TYPE".equals(subKey)) continue;
                Table ctSub = ct.getTable(subKey);
                String subType = ctSub.getS("TYPE", null);
                if (FileUtil.typeIsStructure(subType)) {
                    FileUtil.buildStructure(subMap, subKey, df, ctSub, dfHeaderKeywordData, dfRecordData);
                    continue;
                }
                subMap.put(subKey, FileUtil.retrieveValue(ctSub, dfHeaderKeywordData, dfRecordData, subKey));
            }
            nestedMap.put(key, subMap);
        } else if ("ARRAY_MAP".equals(type)) {
            ArrayList<HashMap<String, Object>> mapArray = new ArrayList<HashMap<String, Object>>();
            for (String tempMapKey : ct.getKeys()) {
                if ("TYPE".equals(tempMapKey)) continue;
                Table ctMap = ct.getTable(tempMapKey);
                HashMap<String, Object> subMap = new HashMap<String, Object>();
                for (String subKey : ctMap.getKeys()) {
                    if ("TYPE".equals(subKey)) continue;
                    Table ctSub = ctMap.getTable(subKey);
                    String subType = ctSub.getS("TYPE", null);
                    if (FileUtil.typeIsStructure(subType)) {
                        FileUtil.buildStructure(subMap, subKey, df, ctSub, dfHeaderKeywordData, dfRecordData);
                        continue;
                    }
                    subMap.put(subKey, FileUtil.retrieveValue(ctSub, dfHeaderKeywordData, dfRecordData, subKey));
                }
                mapArray.add(subMap);
            }
            nestedMap.put(key, mapArray);
        } else if ("ARRAY_RECORDS".equals(type)) {
            ArrayList mapArray = new ArrayList();
            if (dfRecordData == null) {
                dfRecordData = FileUtil.getRecordDataAsTable(df);
            }
            for (String row : dfRecordData.getKeys()) {
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                Table rowTable = dfRecordData.getTable(row);
                for (String recMapKey : ct.getKeys()) {
                    if ("TYPE".equals(recMapKey)) continue;
                    Table ctMap = ct.getTable(recMapKey);
                    rowMap.put(recMapKey, FileUtil.retrieveValue(ctMap, rowTable, dfRecordData.getTable(row), recMapKey));
                }
                mapArray.add(rowMap);
            }
            nestedMap.put(key, mapArray);
        } else {
            nestedMap.put(key, FileUtil.retrieveValue(ct, dfHeaderKeywordData, dfRecordData, key));
        }
    }

    private static boolean typeIsStructure(String type) {
        return "ARRAY_MAP".equals(type) || "MAP".equals(type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object retrieveValue(Table ct, Table dfHeaderKeywordTable, Table dfRecordDataTable, String key) throws Exception {
        String keys = ct.getS("KEYS", key);
        String source = ct.getS("SOURCE", null);
        String location = ct.getS("LOCATION", "EXTENDED");
        if ("EXT".equals(location)) {
            location = "EXTENDED";
        }
        String conversion = ct.getS("CONVERSION", "NONE");
        Object val = ct.get("VALUE", null);
        String inlineFunc = ct.getS("INLINE_FUNC", null);
        String javaFunc = ct.getS("JAVA_FUNC", null);
        boolean required = ct.getState("REQUIRED", false);
        Table mapping = ct.getTable("MAPPING", null);
        location = location.toUpperCase();
        if (ct.containsKey("VALUE")) return val;
        if (conversion.equals("MAPPING")) {
            if (mapping == null) {
                throw new NullPointerException("Missing MAPPING=");
            }
            val = !"RECORD".equals(location) ? ((Table)dfHeaderKeywordTable.get(location)).getKey(source) : dfRecordDataTable.get(source);
            if (val != null) {
                val = mapping.get(val.toString());
            }
            if (val != null) return val;
            return ct.get("DEFAULT");
        }
        if (conversion.equals("INLINE_FUNC")) {
            int i;
            if (inlineFunc == null) {
                throw new NullPointerException("Missing INLINE_FUNC=");
            }
            val = !"RECORD".equals(location) ? ((Table)dfHeaderKeywordTable.get(location)).getKey(source) : dfRecordDataTable.get(source);
            if (val == null) return ct.get("DEFAULT");
            MidasReference m = null;
            while ((i = inlineFunc.indexOf(94)) >= 0) {
                String k;
                int j;
                if (i < inlineFunc.length() - 1 && inlineFunc.charAt(i + 1) == '{') {
                    j = inlineFunc.indexOf(125, i + 1) + 1;
                    if (j <= 0) {
                        throw new IllegalArgumentException("Missing '}' in " + inlineFunc);
                    }
                    k = inlineFunc.substring(i + 2, j - 1);
                } else {
                    for (j = i + 1; j < inlineFunc.length() && inlineFunc.substring(j, j + 1).matches("[A-Za-z0-9_.]"); ++j) {
                    }
                    k = inlineFunc.substring(i + 1, j);
                }
                Object v = ((Table)dfHeaderKeywordTable.get(location)).getKey(source);
                if (v == null) {
                    v = "0";
                }
                inlineFunc = inlineFunc.substring(0, i) + v + inlineFunc.substring(j);
            }
            if (inlineFunc.startsWith("CALC(")) {
                return new Data(Convert.inLineCalc(m, inlineFunc));
            }
            if (inlineFunc.startsWith("SEDIT(")) {
                return Convert.inLineSedit(m, inlineFunc);
            }
            if (!inlineFunc.startsWith("TEST(")) throw new IllegalArgumentException("Unsupported INLINE_FUNC=" + inlineFunc);
            return Convert.inLineTest(m, inlineFunc);
        }
        if (conversion.equals("JAVA_FUNC")) {
            if (javaFunc == null) {
                throw new NullPointerException("Missing JAVA_FUNC=");
            }
            int indexDot = javaFunc.lastIndexOf(46);
            String className = javaFunc.substring(0, indexDot);
            String methodName = javaFunc.substring(indexDot + 1);
            Class<?> classObj = Class.forName(className);
            Method method = classObj.getMethod(methodName, Table.class, Table.class, Table.class, String.class);
            return method.invoke(null, ct, dfHeaderKeywordTable, dfRecordDataTable, key);
        }
        if (!conversion.equals("NONE")) {
            throw new IllegalArgumentException("Unsupported CONVERSION=" + conversion);
        }
        if (source == null) {
            return ct.get("DEFAULT");
        }
        val = !"RECORD".equals(location) ? ((Table)dfHeaderKeywordTable.get(location)).getKey(source) : dfRecordDataTable.get(source);
        if (val != null) return val;
        return ct.get("DEFAULT");
    }

    @InternalUseOnly(value="Called via reflection by to support HEADKEY2JSON")
    public static String convMapConcat(Table ct, Table dfHeaderKeywordTable, Table dfRecordDataTable, String key) throws Exception {
        Table mapCatOpts = ct.getTable("JAVA_FUNC_OPTS");
        String concat = "";
        for (String mapKey : mapCatOpts.getKeys()) {
            Table mappingInfo = mapCatOpts.getTable(mapKey);
            Object valObj = FileUtil.retrieveValue(mappingInfo, dfHeaderKeywordTable, dfRecordDataTable, key);
            if (!(valObj instanceof String)) {
                valObj = Convert.o2s(valObj);
            }
            String valToMap = (String)valObj;
            Table mapping = mappingInfo.getTable("MAPPING", null);
            if (mapping != null) {
                if (valToMap == null) continue;
                concat = concat + mapping.get(valToMap);
                continue;
            }
            concat = concat + valToMap;
        }
        return concat;
    }

    @InternalUseOnly(value="Called via reflection by to support HEADKEY2JSON")
    public static String convDoubleTimeToFmt(Table ct, Table dfHeaderKeywordTable, Table dfRecordDataTable, String key) throws Exception {
        Table timeMapOpts = ct.getTable("JAVA_FUNC_OPTS");
        Double doubleTime = 0.0;
        if (!timeMapOpts.containsKey("TIME1")) {
            Object valTime = FileUtil.retrieveValue(timeMapOpts, dfHeaderKeywordTable, dfRecordDataTable, key);
            if (!(valTime instanceof Double)) {
                valTime = Convert.o2d(valTime);
            }
            doubleTime = (Double)valTime;
        } else {
            int timeNum = 1;
            while (timeMapOpts.containsKey("TIME" + timeNum)) {
                Table thisTime = timeMapOpts.getTable("TIME" + timeNum);
                Object valTime = FileUtil.retrieveValue(thisTime, dfHeaderKeywordTable, dfRecordDataTable, key);
                if (!(valTime instanceof Double)) {
                    valTime = Convert.o2d(valTime);
                }
                doubleTime = doubleTime + (Double)valTime;
                ++timeNum;
            }
        }
        String format = timeMapOpts.getS("FORMAT", "STD");
        return Time.toString((double)doubleTime, format, 6);
    }

    @InternalUseOnly
    public static Table getRecordDataAsTable(DataFile df) {
        Table tblRecordData = new Table();
        df.open();
        if (df.isRecordBased()) {
            int numRows = (int)df.getNumberOfRows();
            for (int i = 0; i < numRows; ++i) {
                tblRecordData.put("ROW_" + i, (Object)df.getDataTable(i));
            }
        }
        df.close();
        return tblRecordData;
    }

    @InternalUseOnly
    public static List<Table> getRecordDataAsList(DataFile df) {
        ArrayList<Table> listRecordData = new ArrayList<Table>();
        df.open();
        if (df.isRecordBased()) {
            int numRows = (int)df.getNumberOfRows();
            for (int i = 0; i < numRows; ++i) {
                listRecordData.add(df.getDataTable(i));
            }
        }
        df.close();
        return listRecordData;
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static InputStream getInputStreamFor(String fileName) throws IOException {
        return FileUtil.getInputStreamFor(FileUtil.class.getClassLoader(), fileName);
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static InputStream getInputStreamFor(ClassLoader classLoader, String fileName) throws IOException {
        InputStream in = classLoader.getResourceAsStream(fileName);
        return in != null ? in : new FileInputStream(fileName);
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static Path toLocalTemp(Path fname) {
        return fname.resolveSibling("." + fname.getFileName());
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static File toLocalTemp(File fname) {
        return new File(fname.getParentFile(), "." + fname.getName());
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static void createFile(File file) throws IOException {
        FileUtil.createFile(file.toPath());
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static void createFile(Path file) throws IOException {
        FileUtil.deleteIfExists(file);
        LogUtilities.log(Level.FINER, "Creating new file {0}", (Object)file);
        Files.createFile(file, new FileAttribute[0]);
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static void deleteDir(File dir) throws IOException {
        FileUtil.deleteIfExists(dir.toPath());
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static void deleteDir(Path dir) throws IOException {
        FileVisitor<Path> visitor = new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                FileUtil.deleteIfExists(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                FileUtil.deleteIfExists(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
                LogUtilities.log(Level.SEVERE, "File visit failed for {0}", (Throwable)e, (Object)file);
                return FileVisitResult.CONTINUE;
            }
        };
        LogUtilities.log(Level.FINE, "Deleting directory {0}", (Object)dir);
        Files.walkFileTree(dir, (FileVisitor<? super Path>)visitor);
        FileUtil.deleteIfExists(dir);
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static void deleteIfExists(File file) throws IOException {
        FileUtil.deleteIfExists(file.toPath());
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static void deleteIfExists(Path file) throws IOException {
        if (Files.deleteIfExists(file)) {
            LogUtilities.log(Level.FINE, "Deleting {0}", (Object)file);
        }
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static File move(File in, File out) throws IOException {
        return FileUtil.move(in.toPath(), out.toPath()).toFile();
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static Path move(Path in, Path out) throws IOException {
        Path temp;
        FileStore outFS;
        FileStore inFS;
        if (out.toFile().isDirectory()) {
            out = out.resolve(in.getFileName());
        }
        if (Objects.equals(inFS = Files.getFileStore(in.getParent()), outFS = Files.getFileStore(out.getParent()))) {
            LogUtilities.log(Level.FINE, "Moving {0} to {1} (via atomic move)", in, out);
            try {
                Files.move(in, out, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                return out;
            }
            catch (AtomicMoveNotSupportedException e) {
                LogUtilities.log(Level.WARNING, "Moving {0} to {1} (via atomic move) failed", (Throwable)e, in, out);
            }
        } else {
            LogUtilities.log(Level.FINE, "Moving {0} to {1} (via move+rename)", in, out);
            temp = FileUtil.toLocalTemp(out);
            try {
                Files.move(in, temp, StandardCopyOption.REPLACE_EXISTING);
                Files.move(temp, out, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                return out;
            }
            catch (AtomicMoveNotSupportedException e) {
                LogUtilities.log(Level.WARNING, "Moving {0} to {1} (via move+rename) failed", (Throwable)e, in, out);
            }
        }
        temp = FileUtil.toLocalTemp(out);
        LogUtilities.log(Level.FINE, "Moving {0} to {1} (via {2})", in, out, temp);
        FileUtil._copy(in, out, temp, PRESERVE);
        Files.delete(in);
        return out;
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static File moveByCopy(File in, File out) throws IOException {
        return FileUtil.move(in.toPath(), out.toPath()).toFile();
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static Path moveByCopy(Path in, Path out) throws IOException {
        if (out.toFile().isDirectory()) {
            out = out.resolve(in.getFileName());
        }
        Path temp = FileUtil.toLocalTemp(out);
        LogUtilities.log(Level.FINE, "Moving {0} to {1} (via {2})", in, out, temp);
        FileUtil._copy(in, out, temp, PRESERVE);
        Files.delete(in);
        return out;
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static void quickCopy(File in, File out) throws IOException {
        FileUtil.quickCopy(in.toPath(), out.toPath());
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static void quickCopy(Path in, Path out) throws IOException {
        if (out.toFile().isDirectory()) {
            out = out.resolve(in.getFileName());
        }
        LogUtilities.log(Level.FINE, "Copying {0} to {1}", in, out);
        FileUtil._quickCopy(in, out, NO_PRESERVE);
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static void quickCopyP(File in, File out) throws IOException {
        FileUtil.quickCopyP(in.toPath(), out.toPath());
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static void quickCopyP(Path in, Path out) throws IOException {
        if (out.toFile().isDirectory()) {
            out = out.resolve(in.getFileName());
        }
        LogUtilities.log(Level.FINE, "Copying {0} to {1}", in, out);
        FileUtil._quickCopy(in, out, PRESERVE);
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static void copy(File in, File out) throws IOException {
        FileUtil.copy(in.toPath(), out.toPath());
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static void copy(Path in, Path out) throws IOException {
        if (out.toFile().isDirectory()) {
            out = out.resolve(in.getFileName());
        }
        Path temp = FileUtil.toLocalTemp(out);
        LogUtilities.log(Level.FINE, "Copying {0} to {1} (via {2})", in, out, temp);
        FileUtil._copy(in, out, temp, NO_PRESERVE);
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static void copyP(File in, File out) throws IOException {
        FileUtil.copy(in.toPath(), out.toPath());
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static void copyP(Path in, Path out) throws IOException {
        if (out.toFile().isDirectory()) {
            out = out.resolve(in.getFileName());
        }
        Path temp = FileUtil.toLocalTemp(out);
        LogUtilities.log(Level.FINE, "Copying {0} to {1} (via {2})", in, out, temp);
        FileUtil._copy(in, out, temp, PRESERVE);
    }

    private static void _copy(Path in, Path out, Path temp, CopyOption[] opts) throws IOException {
        Files.deleteIfExists(out);
        Files.deleteIfExists(temp);
        FileUtil._quickCopy(in, temp, opts);
        try {
            Files.move(temp, out, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            LogUtilities.log(Level.FINE, "Atomic move within same directory failed", e);
            Files.move(temp, out, new CopyOption[0]);
        }
    }

    private static void _quickCopy(Path in, Path out, CopyOption[] opts) throws IOException {
        Files.deleteIfExists(out);
        Files.copy(in, out, opts);
        if (DEF_PERMISSIONS != null && opts == NO_PRESERVE) {
            Files.setPosixFilePermissions(out, DEF_PERMISSIONS);
        }
    }

    private static Set<PosixFilePermission> getDefaultPosixFilePermissions() {
        Set<PosixFilePermission> permissions = null;
        if (!Shell.isWindows()) {
            try {
                File f = File.createTempFile("Utils", ".tmp");
                permissions = Files.getPosixFilePermissions(f.toPath(), new LinkOption[0]);
                f.delete();
                LogUtilities.log(Level.FINEST, "Default POSIX file permissions: {0}", permissions);
            }
            catch (Exception e) {
                LogUtilities.log(Level.SEVERE, "Unable to determine default POSIX file permissions", e);
            }
        }
        return permissions;
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static BigInteger md5sum(Path inFile) {
        return FileUtil.md5sum(inFile.toFile());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ProvisionalUseOnly(value="until adequately tested")
    public static BigInteger md5sum(File inFile) {
        try (FileInputStream in = new FileInputStream(inFile);){
            BigInteger bigInteger = FileUtil.md5sum(inFile.toString(), in);
            return bigInteger;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to compute MD5 sum for " + inFile, e);
        }
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static BigInteger md5sum(InputStream in) {
        String name = Util.getShortClassName(in.getClass());
        return FileUtil.md5sum(name, in);
    }

    @ProvisionalUseOnly(value="until adequately tested")
    private static BigInteger md5sum(String name, InputStream in) {
        try {
            int num;
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buf = new byte[64436];
            while ((num = in.read(buf)) > 0) {
                md.update(buf, 0, num);
            }
            return new BigInteger(1, md.digest());
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to compute MD5 sum for " + name, e);
        }
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static byte[] readAll(Path inFile) throws IOException {
        return FileUtil.readAll(inFile.toFile());
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static byte[] readAll(File inFile) throws IOException {
        try (FileInputStream in = new FileInputStream(inFile);){
            byte[] byArray = FileUtil.readAll(in, (int)inFile.length());
            return byArray;
        }
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static byte[] readAll(HttpURLConnection c) throws IOException {
        int code = c.getResponseCode();
        boolean http200 = code >= 200 && code <= 299;
        InputStream in = http200 ? c.getInputStream() : c.getErrorStream();
        return FileUtil.readAll(in, c.getContentLength());
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static byte[] readAll(InputStream in) throws IOException {
        return FileUtil.readAll(in, -1);
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static byte[] readAll(InputStream in, int sizeHint) throws IOException {
        int n;
        byte[] buf = new byte[Math.max(64436, sizeHint)];
        int len = 0;
        while ((n = in.read(buf, len, buf.length - len)) > 0) {
            if ((len += n) != buf.length) continue;
            buf = Arrays.copyOf(buf, len + len / 2);
        }
        return Arrays.copyOf(buf, len);
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static CharSequence readAllChars(Path inFile) throws IOException {
        return FileUtil.readAllChars(inFile.toFile());
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static CharSequence readAllChars(File inFile) throws IOException {
        try (FileInputStream in = new FileInputStream(inFile);){
            CharSequence charSequence = FileUtil.readAllChars(in, (int)inFile.length());
            return charSequence;
        }
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static CharSequence readAllChars(InputStream in) throws IOException {
        return FileUtil.readAllChars(in, -1);
    }

    @ProvisionalUseOnly(value="until adequately tested")
    public static CharSequence readAllChars(InputStream in, int sizeHint) throws IOException {
        int n;
        byte[] buf = new byte[Math.max(64436, sizeHint)];
        int len = 0;
        while ((n = in.read(buf, len, buf.length - len)) > 0) {
            if ((len += n) != buf.length) continue;
            buf = Arrays.copyOf(buf, len + len / 2);
        }
        return new String(buf, 0, len);
    }

    public static String ext(String string) {
        return new FileName(string).getExt();
    }

    public static String head(String string) {
        FileName fn = new FileName(string);
        return fn.getPath();
    }

    public static String root(String string) {
        FileName fn = new FileName(string);
        return fn.getRoot();
    }

    public static String tail(String string) {
        FileName fn = new FileName(string);
        return fn.getRoot() + "." + fn.getExt();
    }

    @InternalUseOnly
    public static void setUseDeprecatedUrlAPI(boolean useDeprecatedUrlAPI) {
        FileUtil.useDeprecatedUrlAPI = useDeprecatedUrlAPI;
    }

    @InternalUseOnly
    public static boolean getUseDeprecatedUrlAPI() {
        return useDeprecatedUrlAPI;
    }

    private static class PlotFileWrapper2
    extends PlotFileWrapper {
        protected final ListFile lf;

        PlotFileWrapper2(PlotFile pf, ListFile lf) {
            super(pf);
            this.lf = lf;
            if (lf == null) {
                throw new NullPointerException("lf can not be null");
            }
            if (lf != pf) {
                throw new IllegalArgumentException("lf must match pf");
            }
        }

        @Override
        public double getNumberOfRows() {
            return this.lf.getNumberOfRows();
        }

        @Override
        public boolean getProtected() {
            return this.lf.getProtected();
        }

        @Override
        public int getRecordDefCount() {
            return this.lf.getRecordDefCount();
        }

        @Override
        public Table getRecordDef(int i) {
            return this.lf.getRecordDef(i);
        }

        @Override
        public Table getRecordDefs() {
            return this.lf.getRecordDefs();
        }

        @Override
        public Table getDataTable(double off) {
            return this.lf.getDataTable(off);
        }

        @Override
        public int setData(double off, Table tbl) {
            return this.lf.setData(off, tbl);
        }

        @Override
        public void setRecordDefs(Table defs) {
            this.lf.setRecordDefs(defs);
        }

        @Override
        public void removeData(double off) {
            this.lf.removeData(off);
        }

        @Override
        public void insertData(double off, Object obj) {
            this.lf.insertData(off, obj);
        }

        @Override
        public void removeData(double off, long count) {
            this.lf.removeData(off, count);
        }

        @Override
        public void setData(double off, String name, Object obj) {
            this.lf.setData(off, name, obj);
        }

        @Override
        public int writeDataTable(Table tbl) {
            double seek = this.seek();
            this.lf.setData(seek, tbl);
            this.seek(seek + 1.0);
            return 0;
        }

        @Override
        public int readDataTable(Table tbl) {
            double seek = this.seek();
            Table row = this.getDataTable(seek);
            if (row == null) {
                return -1;
            }
            tbl.merge(row);
            this.seek(seek + 1.0);
            return 1;
        }
    }

    @InternalUseOnly
    public static class PlotFileWrapper
    extends PlotFileGetLayerModSwap
    implements ListFile {
        protected final PlotFile pf;

        protected PlotFileWrapper(PlotFile pf) {
            super(pf);
            this.pf = pf;
            if (pf == null) {
                throw new NullPointerException("pf can not be null");
            }
        }

        @Override
        public String getURL() {
            return this.pf.getURL();
        }

        @Override
        public String getTag() {
            return this.pf.getTag();
        }

        @Override
        public double getSize() {
            return this.pf.getSize();
        }

        @Override
        public String getFormat() {
            return this.pf.getFormat();
        }

        @Override
        public double getStart() {
            return this.pf.getStart();
        }

        @Override
        public double getDelta() {
            return this.pf.getDelta();
        }

        @Override
        public int getUnits() {
            return this.pf.getUnits();
        }

        @Override
        public double getXStart() {
            return this.pf.getXStart();
        }

        @Override
        public double getXDelta() {
            return this.pf.getXDelta();
        }

        @Override
        public int getXUnits() {
            return this.pf.getXUnits();
        }

        @Override
        public int getXFrame() {
            return this.pf.getXFrame();
        }

        @Override
        public double getYStart() {
            return this.pf.getYStart();
        }

        @Override
        public double getYDelta() {
            return this.pf.getYDelta();
        }

        @Override
        public int getYUnits() {
            return this.pf.getYUnits();
        }

        @Override
        public int getYFrame() {
            return this.pf.getYFrame();
        }

        @Override
        public int getType() {
            return this.pf.getType();
        }

        @Override
        public int getMode() {
            return this.pf.getMode();
        }

        @Override
        public FileName getName() {
            return this.pf.getName();
        }

        @Override
        public boolean isStream() {
            return this.pf.isStream();
        }

        @Override
        public boolean isStreaming() {
            return this.pf.isStreaming();
        }

        @Override
        public boolean isOpen() {
            return this.pf.isOpen();
        }

        @Override
        public double seek() {
            return this.pf.seek();
        }

        @Override
        public double avail() {
            return this.pf.avail();
        }

        @Override
        public Data getDataBuffer(int size) {
            return this.pf.getDataBuffer(size);
        }

        @Override
        public double getTimeAt(double offset) {
            return this.pf.getTimeAt(offset);
        }

        @Override
        public Object getQualifier(String key) {
            return this.pf.getQualifier(key);
        }

        @Override
        public boolean find(int dir) {
            return this.pf.find(dir);
        }

        @Override
        public boolean open(int flags) {
            return this.pf.open(flags);
        }

        @Override
        public int read(Data data, int elem) {
            return this.pf.read(data, elem);
        }

        @Override
        public int seek(double off) {
            return this.pf.seek(off);
        }

        @Override
        public double getNumberOfRows() {
            return this.pf.getSize();
        }

        @Override
        public boolean getProtected() {
            return true;
        }

        @Override
        public int getRecordDefCount() {
            return this.pf.getXFrame();
        }

        @Override
        public void init(Object ref, Object fname) {
            this.pf.init(ref, fname);
        }

        @Override
        public void connect(int mode) {
            this.pf.connect(mode);
        }

        @Override
        public void close() {
            this.pf.close();
        }

        @Override
        public void removeData(double off) {
            this.removeData(off, 1L);
        }

        @Override
        public void setRecordDefs(Table defs) {
            throw new UnsupportedOperationException("Can not write to " + this.getName() + " file is read-only.");
        }

        @Override
        public int setData(double offset, Table table) {
            throw new UnsupportedOperationException("Can not write to " + this.getName() + " file is read-only.");
        }

        @Override
        public void setData(double element, String fieldName, Object obj) {
            throw new UnsupportedOperationException("Can not write to " + this.getName() + " file is read-only.");
        }

        @Override
        public void insertData(double offset, Object obj) {
            throw new UnsupportedOperationException("Can not write to " + this.getName() + " file is read-only.");
        }

        @Override
        public void removeData(double offset, long count) {
            throw new UnsupportedOperationException("Can not write to " + this.getName() + " file is read-only.");
        }

        public int writeDataTable(Table tbl) {
            throw new UnsupportedOperationException("Can not write to " + this.getName() + " file is read-only.");
        }

        @Override
        public void update() {
            throw new UnsupportedOperationException("Can not write to " + this.getName() + " file is read-only.");
        }

        @Override
        public Table getRecordDef(int i) {
            Table def = null;
            if (i >= 0 && i < this.getRecordDefCount()) {
                def = new Table();
                def.put("NAME", (Object)("F" + (i + 1)));
                def.put("FORMAT", (Object)this.getFormat());
            }
            return def;
        }

        @Override
        public Table getRecordDefs() {
            Table tbl = new Table();
            for (int i = 0; i < this.getRecordDefCount(); ++i) {
                tbl.put(Integer.toString(i), (Object)this.getRecordDef(i));
            }
            return tbl;
        }

        @Override
        public Table getDataTable(double offset) {
            double seek = this.seek();
            Table tbl = null;
            this.seek(offset);
            Data buf = this.getDataBuffer(1);
            int num = this.pf.read(buf, 1);
            if (num != 1) {
                tbl = new Table();
                for (int i = 0; i < buf.getAPE(); ++i) {
                    tbl.put("F" + (i + 1), (Object)buf.getAtomAt(i));
                }
            }
            this.seek(seek + 1.0);
            return tbl;
        }

        @Override
        public int readDataTable(Table tbl) {
            Table row = this.getDataTable(this.seek());
            if (row == null) {
                return -1;
            }
            tbl.merge(row);
            return 1;
        }
    }

    private static class PlotFileAsListFile
    implements ListFile {
        private final PlotFileNH pf;

        PlotFileAsListFile(PlotFileNH pf) {
            this.pf = pf;
        }

        @Override
        public boolean isOpen() {
            return this.pf.isOpen();
        }

        @Override
        public boolean open(int flags) {
            return this.pf.open(flags);
        }

        @Override
        public String getURL() {
            return this.pf.getURL();
        }

        @Override
        public FileName getName() {
            return this.pf.getName();
        }

        @Override
        public double getNumberOfRows() {
            return this.pf.getSize();
        }

        @Override
        public boolean getProtected() {
            return true;
        }

        @Override
        public int getRecordDefCount() {
            return this.pf.getRecordDefCount();
        }

        @Override
        public Table getRecordDef(int i) {
            return this.pf.getRecordDef(i);
        }

        @Override
        public Table getRecordDefs() {
            return this.pf.getRecordDefs();
        }

        @Override
        public Table getDataTable(double off) {
            return this.pf.getDataTable(off);
        }

        public int seek(double off) {
            return this.pf.seek(off);
        }

        public double seek() {
            return this.pf.seek();
        }

        public double avail() {
            return this.pf.avail();
        }

        @Override
        public void close() {
            this.pf.close();
        }

        public int readDataTable(Table tbl) {
            return this.pf.readDataTable(tbl);
        }

        @Override
        public void removeData(double off) {
            this.removeData(off, 1L);
        }

        @Override
        public void setRecordDefs(Table defs) {
            throw new UnsupportedOperationException("Can not write to " + this.getName() + " file is read-only.");
        }

        @Override
        public int setData(double offset, Table table) {
            throw new UnsupportedOperationException("Can not write to " + this.getName() + " file is read-only.");
        }

        @Override
        public void setData(double element, String fieldName, Object obj) {
            throw new UnsupportedOperationException("Can not write to " + this.getName() + " file is read-only.");
        }

        @Override
        public void insertData(double offset, Object obj) {
            throw new UnsupportedOperationException("Can not write to " + this.getName() + " file is read-only.");
        }

        @Override
        public void removeData(double offset, long count) {
            throw new UnsupportedOperationException("Can not write to " + this.getName() + " file is read-only.");
        }

        public int writeDataTable(Table tbl) {
            throw new UnsupportedOperationException("Can not write to " + this.getName() + " file is read-only.");
        }

        @Override
        public void update() {
            throw new UnsupportedOperationException("Can not write to " + this.getName() + " file is read-only.");
        }
    }

    private static final class FnFilterImpl
    implements FnFilter {
        private final StringBuffer description;
        private final Pattern[] pathAccept;
        private final Pattern[] pathReject;
        private final Pattern[] fileAccept;
        private final Pattern[] fileReject;

        FnFilterImpl(String root, List<String> accPath, List<String> accFile, List<String> rejPath, List<String> rejFile) {
            this.pathAccept = accPath == null ? null : new Pattern[accPath.size()];
            this.fileAccept = accFile == null ? null : new Pattern[accFile.size()];
            this.pathReject = rejPath == null ? new Pattern[]{} : new Pattern[rejPath.size()];
            this.fileReject = rejFile == null ? new Pattern[]{} : new Pattern[rejFile.size()];
            this.description = new StringBuffer();
            this.description.append("FnFilter: (accept: ");
            if (this.pathAccept == null) {
                this.description.append("* ");
            } else {
                this.compileRegex(this.description, this.fileAccept, accFile, "");
                this.compileRegex(this.description, this.pathAccept, accPath, root);
            }
            this.description.append("reject:");
            this.compileRegex(this.description, this.fileReject, rejFile, "");
            this.compileRegex(this.description, this.pathReject, rejPath, root);
            this.description.append(")");
        }

        private void compileRegex(StringBuffer descr, Pattern[] pat, List<String> wild, String root) {
            for (int i = 0; i < pat.length; ++i) {
                String wc = wild.get(i);
                if (wc.indexOf(47) >= 0) {
                    if (root == null || root.isEmpty()) {
                        throw new NullPointerException("FileUtil.createFnFilter: found '" + wc + "', but root was null.");
                    }
                    wc = FileUtil.terminatePath(root) + wc;
                }
                wc = wc.replace('/', File.separatorChar);
                pat[i] = Pattern.compile(StringUtil.wildcardsToRegex(wc));
                descr.append(wc).append(' ');
            }
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.accept(new File(dir, name));
        }

        @Override
        public boolean accept(File file) {
            boolean ok;
            String path = file.getPath();
            String name = file.getName();
            boolean bl = ok = this.fileAccept == null;
            if (file.isDirectory()) {
                int i;
                path = path + File.separator;
                for (i = 0; !ok && i < this.pathAccept.length; ++i) {
                    ok = this.pathAccept[i].matcher(path).matches();
                }
                for (i = 0; ok && i < this.pathReject.length; ++i) {
                    ok = !this.pathReject[i].matcher(path).matches();
                }
            } else {
                int i;
                for (i = 0; !ok && i < this.fileAccept.length; ++i) {
                    ok = this.fileAccept[i].matcher(name).matches();
                }
                for (i = 0; !ok && i < this.pathAccept.length; ++i) {
                    ok = this.pathAccept[i].matcher(path).matches();
                }
                for (i = 0; ok && i < this.fileReject.length; ++i) {
                    ok = !this.fileReject[i].matcher(name).matches();
                }
                for (i = 0; ok && i < this.pathReject.length; ++i) {
                    ok = !this.pathReject[i].matcher(path).matches();
                }
            }
            return ok;
        }

        @Override
        public String toString() {
            return this.description.toString();
        }
    }

    public static interface FnFilter
    extends FilenameFilter,
    FileFilter {
        public String toString();
    }
}

