/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import nxm.sys.inc.AsciiMap;
import nxm.sys.inc.DataTypes;
import nxm.sys.inc.Indexable;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.CoreIO;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.MFormat;
import nxm.sys.lib.Message;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Native;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.libm.Tolerance;

public class Data
implements Indexable,
DataTypes,
AsciiMap,
Serializable,
Comparable<Object> {
    private static final long serialVersionUID = 5144324106233708397L;
    public static final int EQ_BIN = 1;
    public static final int EQ_SIZE = 2;
    public static final int EQ_TOL = 32;
    public static final int EQ_MAG = 64;
    public static final int EQ_CS = 128;
    public static final int EQ_VEQ = 256;
    public static final int EQ_ABSTOL = 512;
    static final int EQ_LENLIM = 1024;
    public static final int EQ_DEF = 32768;
    public static final int EQ_DEFAULT = 386;
    private static final int MAX_BYTES_FOR_HASHCODE = 32;
    private static final String MODES = "SCVQ5678MX";
    private static final String DATA_MODES = "SCVQMTA123456789XKN";
    private static final String DATA_TYPES = "DFXLIJBNPA,ZWHO";
    private static final String EXTENDED_DATA_TYPES = "DFXLIJBNPA,ZUVWHO";
    @InternalUseOnly(value="Since NeXtMidas 3.5.1, use getSize() and/or setSize()")
    public int size;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1, use getFormatMode() and/or setFormatMode()")
    public byte mode;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1, use getFormatType(), setFormatType(), and/or getFormatTypeChar()")
    public byte type;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1, use getRep() and/or setRep()")
    public byte rep;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1")
    public byte attr;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1, use getBuf()")
    public byte[] buf;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1")
    public int boff;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1")
    public int bpe;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1, use getAPE() andor setAPE()")
    public int ape;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1, use getSPA() and/or setSPA()")
    public int spa;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1")
    public int bps;
    @InternalUseOnly
    public int writeMult;
    private transient Object array;
    private byte atype;
    private transient Object header;
    private Time headerTime;
    private static final Map<Byte, Method> FROM_BUF_METHODS = Data.getFromBufMethodsBuilder();
    private static final Map<Class<?>, Method> CASTING_METHODS = Data.getCastingMethods();

    public Data() {
        this(83, 66, 0);
    }

    private Data(byte newMode, byte newType, int newSize) {
        this.boff = 0;
        this.bpe = 1;
        this.ape = 1;
        this.spa = 1;
        this.bps = 1;
        this.writeMult = 1;
        Data.checkFormatPairing(newMode, newType);
        this.mode = Data.modeFromMode(newMode);
        this.type = Data.typeFromType(newType);
        this.bps = Data.bpsFromType(this.type);
        this.spa = Data.spaFromMode(this.mode);
        this.bpe = this.bps * this.spa * this.ape;
        this.writeMult = newType == 74 && this.spa % 2 != 0 ? 2 : 1;
        this.rep = Shell.rep;
        this.attr = 0;
        this.setSize(Data.sizeFromSize(newSize));
    }

    public Data(String format, int size) {
        this((byte)format.charAt(0), (byte)format.charAt(1), size);
    }

    public Data(String format, int size, Number defValue) {
        block4: {
            this(format, size);
            if (defValue == null || defValue.doubleValue() == 0.0 || size <= 0) break block4;
            if (this.bps >= 1) {
                this.setNumber(0, defValue);
                int start = this.boff + this.bps;
                int end = this.boff + size * this.bpe;
                int i = start;
                int j = 0;
                while (i < end) {
                    this.buf[i] = this.buf[this.boff + j % this.bpe];
                    ++i;
                    ++j;
                }
            } else {
                for (int i = 0; i < size * this.spa; ++i) {
                    this.setNumber(i, defValue);
                }
            }
        }
    }

    public static Data fromString(String string, char conversion, Object ref) {
        return Data.fromString(string, (byte)32, (byte)conversion, Convert.ref2MidasReference(ref));
    }

    private static Data fromString(String string, byte newMode, byte newType, MidasReference ref) {
        Object obj = Convert.s2o(string, Data.getFormat(newMode, newType), (Object)ref);
        if (obj instanceof Data) {
            return (Data)obj;
        }
        if (obj instanceof String) {
            return new Data((String)obj, newType == 90);
        }
        return new Data(Convert.o2d(obj));
    }

    static Data fromObject(Object obj, String format, int numElements, MidasReference ref) {
        Data dataOut = new Data(format, numElements);
        try {
            if (dataOut.isString()) {
                int _bpa = Data.getBPA(format);
                if (obj == null) {
                    obj = "";
                }
                dataOut.packS(0, _bpa, Convert.o2s(obj));
            } else {
                if (obj == null) {
                    obj = new Data(format, numElements);
                }
                obj = Convert.o2Data(obj, format, (Object)ref);
                dataOut.fillBufferFrom((Data)obj, numElements);
            }
        }
        catch (MidasException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new MidasException("Data: unable to convert value " + obj + " to format " + format, e);
        }
        return dataOut;
    }

    public static Data fromBuffer(byte[] buffer, byte rep, int offset, int ele, byte itype, int spa) {
        int bytes = ele * Data.getBPS(itype);
        byte[] buf = new byte[bytes];
        System.arraycopy(buffer, offset, buf, 0, bytes);
        Convert.rep(buf, 0, itype, ele, rep, Shell.rep);
        return new Data(buf, 0, buf.length, (int)itype);
    }

    public static Data fromBuffer(byte[] buffer, byte rep, int offset, int ele, String form) {
        byte itype = (byte)form.charAt(1);
        int spa = Data.getSPA(form.charAt(0));
        return Data.fromBuffer(buffer, rep, offset, ele, itype, spa);
    }

    public static Data fromBuffer(byte[] buffer, byte rep, int offset, int ele, byte itype) {
        return Data.fromBuffer(buffer, rep, offset, ele, itype, -1);
    }

    public Data(Object value) {
        this();
        if (value instanceof String) {
            this.initTo((String)value);
        } else if (value instanceof double[]) {
            this.initTo((double[])value);
        } else if (value instanceof float[]) {
            this.initTo((float[])value);
        } else if (value instanceof long[]) {
            this.initTo((long[])value);
        } else if (value instanceof int[]) {
            this.initTo((int[])value);
        } else if (value instanceof short[]) {
            this.initTo((short[])value);
        } else if (value instanceof byte[]) {
            this.initTo((byte[])value);
        } else if (value instanceof Double) {
            this.initTo((Double)value);
        } else if (value instanceof Float) {
            this.initTo(((Float)value).floatValue());
        } else if (value instanceof Long) {
            this.initTo((Long)value);
        } else if (value instanceof Integer) {
            this.initTo((Integer)value);
        } else if (value instanceof Short) {
            this.initTo((Short)value);
        } else if (value instanceof Byte) {
            this.initTo((Byte)value);
        } else if (value instanceof List) {
            this.fromList((List<?>)Data.castObjectToList(value));
        } else {
            throw new MidasException("Invalid object type passed to Data constructor");
        }
    }

    public Data(Object value, int spa) {
        this(value);
        this.setSPA(spa);
    }

    public Data(byte[] buffer, int offset, int bytes, int itype, int spa) {
        this();
        this.buf = buffer;
        this.boff = offset;
        this.setFormatType((byte)itype);
        this.setSize(bytes / this.bpe);
        if (spa < 0) {
            this.resetMode();
        } else if (spa > 1) {
            this.setSPA(spa);
        }
    }

    public Data(byte[] buffer, int offset, int bytes, int itype) {
        this(buffer, offset, bytes, itype, -1);
    }

    public Data(String value) {
        this();
        this.initTo(value);
    }

    public Data(String value, boolean isASCII256) {
        this();
        if (isASCII256) {
            this.initToASCII256(value);
        } else {
            this.initTo(value);
        }
    }

    public Data(double value) {
        this();
        this.initTo(value);
    }

    public Data(float value) {
        this();
        this.initTo(value);
    }

    public Data(long value) {
        this();
        this.initTo(value);
    }

    public Data(int value) {
        this();
        this.initTo(value);
    }

    public Data(short value) {
        this();
        this.initTo(value);
    }

    public Data(byte value) {
        this();
        this.initTo(value);
    }

    public Data(double ... value) {
        this();
        this.initTo(value);
    }

    public Data(float ... value) {
        this();
        this.initTo(value);
    }

    public Data(long ... value) {
        this();
        this.initTo(value);
    }

    public Data(int ... value) {
        this();
        this.initTo(value);
    }

    public Data(short ... value) {
        this();
        this.initTo(value);
    }

    public Data(byte ... value) {
        this();
        this.initTo(value);
    }

    public Data copy() {
        Data copy = new Data();
        int len = this.size * this.bpe;
        copy.size = this.size;
        copy.mode = this.mode;
        copy.type = this.type;
        copy.rep = this.rep;
        copy.attr = this.attr;
        copy.buf = new byte[len];
        copy.boff = 0;
        copy.bpe = this.bpe;
        copy.ape = this.ape;
        copy.spa = this.spa;
        copy.bps = this.bps;
        copy.writeMult = this.writeMult;
        copy.array = null;
        copy.atype = 0;
        copy.header = this.header;
        copy.headerTime = this.headerTime;
        System.arraycopy(this.buf, this.boff, copy.buf, 0, len);
        return copy;
    }

    private void initTo(double[] value) {
        this.setFormatType((byte)68);
        this.size = value.length;
        this.buf = new byte[this.size * this.bpe];
        this.fromArray(value);
    }

    private void initTo(float[] value) {
        this.setFormatType((byte)70);
        this.size = value.length;
        this.buf = new byte[this.size * this.bpe];
        this.fromArray(value);
    }

    private void initTo(long[] value) {
        this.setFormatType((byte)88);
        this.size = value.length;
        this.buf = new byte[this.size * this.bpe];
        this.fromArray(value);
    }

    private void initTo(int[] value) {
        this.setFormatType((byte)76);
        this.size = value.length;
        this.buf = new byte[this.size * this.bpe];
        this.fromArray(value);
    }

    private void initTo(short[] value) {
        this.setFormatType((byte)73);
        this.size = value.length;
        this.buf = new byte[this.size * this.bpe];
        this.fromArray(value);
    }

    private void initTo(byte[] value) {
        this.setFormatType((byte)66);
        this.size = value.length;
        this.buf = value;
    }

    private void initTo(double value) {
        this.setFormatType((byte)68);
        this.size = 1;
        this.buf = new byte[this.bpe];
        this.packD(0, value);
    }

    private void initTo(float value) {
        this.setFormatType((byte)70);
        this.size = 1;
        this.buf = new byte[this.bpe];
        this.packF(0, value);
    }

    private void initTo(long value) {
        this.setFormatType((byte)88);
        this.size = 1;
        this.buf = new byte[this.bpe];
        this.packX(0, value);
    }

    private void initTo(int value) {
        this.setFormatType((byte)76);
        this.size = 1;
        this.buf = new byte[this.bpe];
        this.packL(0, value);
    }

    private void initTo(short value) {
        this.setFormatType((byte)73);
        this.size = 1;
        this.buf = new byte[this.bpe];
        this.packI(0, value);
    }

    private void initTo(byte value) {
        this.setFormatType((byte)66);
        this.size = 1;
        this.buf = new byte[this.bpe];
        this.packB(0, value);
    }

    private void initTo(String value) {
        this.setFormatType((byte)65);
        this.size = (value.length() + 7) / 8;
        this.buf = new byte[this.size * this.bpe];
        this.packS(0, this.size * this.bpe, value);
    }

    private void initToASCII256(String value) {
        this.setFormatType((byte)90);
        this.size = (value.length() + 255) / 256;
        this.buf = new byte[this.size * this.bpe];
        this.packS(0, this.size * this.bpe, value);
    }

    public void setFormat(String format) {
        this.setFormatMode((byte)format.charAt(0));
        this.setFormatType((byte)format.charAt(1));
    }

    public void setType(byte type) {
        this.setFormatType(type);
    }

    public void setFormatType(byte type) {
        this.type = type;
        this.bps = Data.getBPS(type);
        this.bpe = this.ape * this.spa * this.bps;
        this.writeMult = type == 74 && this.spa % 2 != 0 ? 2 : 1;
    }

    public void setFormatType(char type) {
        this.setFormatType((byte)type);
    }

    public byte getFormatType() {
        return this.type;
    }

    public char getFormatTypeChar() {
        return (char)this.type;
    }

    @Deprecated
    public char getTypeLetter() {
        return this.getFormat().charAt(1);
    }

    public static boolean validType(char type) {
        return "DFXLIJBNPA,Z".indexOf(type) >= 0;
    }

    public void setMode(byte mode) {
        this.setFormatMode(mode);
    }

    public void setFormatMode(byte mode) {
        this.mode = mode;
        this.spa = Data.getSPA(mode);
        this.bpe = this.ape * this.spa * this.bps;
        this.writeMult = this.type == 74 && this.spa % 2 != 0 ? 2 : 1;
    }

    public void setFormatMode(char mode) {
        this.setFormatMode((byte)mode);
    }

    public byte getFormatMode() {
        return this.mode;
    }

    public char getFormatModeChar() {
        return (char)this.mode;
    }

    public void setSPA(int spa) {
        this.setSPA(spa, ' ');
    }

    void setSPA(int spa, char mode) {
        if (mode == ' ') {
            if (spa > 0 && spa <= 10) {
                this.mode = (byte)MODES.charAt(spa - 1);
            } else if (spa == 16) {
                this.mode = (byte)84;
            } else {
                this.mode = (byte)83;
                spa = 1;
            }
        } else if (spa == -1) {
            spa = Data.getSPA((byte)mode);
        } else if (Data.getSPA((byte)mode) != spa) {
            throw new MidasException("Data: Illegal combination mode='" + mode + "' spa=" + spa);
        }
        if (this.ape > 1) {
            this.ape = this.ape * this.spa / spa;
        } else {
            this.size = this.size * this.spa / spa;
            this.bpe = this.bpe * spa / this.spa;
        }
        this.spa = spa;
        this.writeMult = this.type == 74 && spa % 2 != 0 ? 2 : 1;
    }

    public void resetMode() {
        if (this.size > 0 && this.size <= 4) {
            this.setFormatMode((byte)MODES.charAt(this.size - 1));
        } else {
            this.setFormatMode((byte)83);
        }
        if (this.size == this.ape) {
            this.setSize(1);
        } else {
            this.setSize(this.size / this.spa);
        }
    }

    public void setFrame(int ape) {
        this.ape = ape;
        this.bpe = ape * this.spa * this.bps;
    }

    public void setRecLength(int bpe) {
        this.bpe = bpe;
        this.ape = bpe < 0 ? (this.bps < 0 ? bpe / (this.spa * this.bps) : bpe / (this.spa * this.bps * -8)) : (this.bps < 0 ? -8 * bpe / (this.spa * this.bps) : bpe / (this.spa * this.bps));
    }

    public void setSize(int size) {
        this.size = size;
        int bytes = this.boff;
        bytes = this.bpe > 0 ? (bytes += size * this.bpe) : (bytes += (-size * this.bpe + 7) / 8);
        try {
            if (this.buf == null) {
                this.buf = new byte[bytes];
            } else if (bytes > this.buf.length) {
                byte[] buffer = new byte[bytes];
                System.arraycopy(this.buf, 0, buffer, 0, Math.min(this.buf.length, bytes));
                this.buf = buffer;
            }
        }
        catch (OutOfMemoryError e) {
            throw new MidasException("Data.setSize(" + size + "): not enough memory to allocate a " + bytes + " byte array for SIZE=" + size + " APE=" + this.getAPE() + " FORM=" + this.getFormat() + ". Current free memory is " + Runtime.getRuntime().freeMemory() + " bytes.", e);
        }
        this.prepArray(this.atype);
    }

    public String getFormat() {
        byte[] form = new byte[]{this.mode, this.type};
        return new String(form);
    }

    public String getSpecs() {
        String specs = "";
        if (this.size > 1) {
            specs = specs + this.size;
        }
        if (this.mode != 83) {
            specs = specs + (char)this.mode;
        }
        specs = specs + (char)this.type;
        return specs;
    }

    public static int getBPA(String format) {
        if (format == null || format.length() < 2) {
            throw new MidasException("Data.getBPA() format='" + format + "' must contain at least 2 characters!");
        }
        byte dataMode = (byte)format.charAt(0);
        byte dataType = (byte)format.charAt(1);
        int bpa = Data.getSPA(dataMode) * Data.getBPS(dataType);
        if (bpa < 0 && -bpa % 8 == 0) {
            bpa = -bpa / 8;
        }
        return bpa;
    }

    public static int getBPS(char ctype) {
        byte btype = (byte)ctype;
        return Data.getBPS(btype);
    }

    static Type getJavaType(char type) {
        switch (type) {
            case 'F': {
                return Float.TYPE;
            }
            case 'X': {
                return Long.TYPE;
            }
            case 'L': {
                return Integer.TYPE;
            }
            case 'I': {
                return Short.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'A': {
                return String.class;
            }
            case 'Z': {
                return String.class;
            }
            case 'S': {
                return String.class;
            }
            case 'T': {
                return Table.class;
            }
        }
        return Object.class;
    }

    public static String getFormatTypeName(byte key) {
        String name;
        switch (key) {
            case 70: {
                name = "Float";
                break;
            }
            case 88: {
                name = "XLongInt";
                break;
            }
            case 76: {
                name = "LongInt";
                break;
            }
            case 73: {
                name = "Integer";
                break;
            }
            case 74: {
                name = "Int12Packed";
                break;
            }
            case 66: {
                name = "Byte";
                break;
            }
            case 77: {
                name = "MuLaw";
                break;
            }
            case 79: {
                name = "OffsetByte";
                break;
            }
            case 78: {
                name = "NibblePacked";
                break;
            }
            case 80: {
                name = "BitPacked";
                break;
            }
            case 68: {
                name = "Double";
                break;
            }
            case 65: {
                name = "Ascii";
                break;
            }
            case 90: {
                name = "Ascii256";
                break;
            }
            case 72: {
                name = "Homogeneous";
                break;
            }
            default: {
                name = "Undefined";
            }
        }
        return name;
    }

    public static String getFormatModeName(byte key) {
        String name;
        switch (key) {
            case 83: {
                name = "Scalar";
                break;
            }
            case 67: {
                name = "Complex";
                break;
            }
            case 86: {
                name = "Vector";
                break;
            }
            case 81: {
                name = "Quad";
                break;
            }
            case 77: {
                name = "Matrix";
                break;
            }
            case 88: {
                name = "Ten";
                break;
            }
            case 84: {
                name = "TransMatrix";
                break;
            }
            case 65: {
                name = "Thirty-Two";
                break;
            }
            case 78: {
                name = "Non";
                break;
            }
            case 49: {
                name = "One";
                break;
            }
            case 50: {
                name = "Two";
                break;
            }
            case 51: {
                name = "Three";
                break;
            }
            case 52: {
                name = "Four";
                break;
            }
            case 53: {
                name = "Five";
                break;
            }
            case 54: {
                name = "Six";
                break;
            }
            case 55: {
                name = "Seven";
                break;
            }
            case 56: {
                name = "Eight";
                break;
            }
            case 57: {
                name = "Nine";
                break;
            }
            default: {
                name = "Undefined";
            }
        }
        return name;
    }

    public static int getBPS(byte type) {
        int bps;
        switch (type) {
            case 70: {
                bps = 4;
                break;
            }
            case 68: {
                bps = 8;
                break;
            }
            case 88: {
                bps = 8;
                break;
            }
            case 76: {
                bps = 4;
                break;
            }
            case 86: {
                bps = 4;
                break;
            }
            case 73: {
                bps = 2;
                break;
            }
            case 85: {
                bps = 2;
                break;
            }
            case 74: {
                bps = -12;
                break;
            }
            case 66: {
                bps = 1;
                break;
            }
            case 78: {
                bps = -4;
                break;
            }
            case 80: {
                bps = -1;
                break;
            }
            case 77: {
                bps = 1;
                break;
            }
            case 65: {
                bps = 8;
                break;
            }
            case 90: {
                bps = 256;
                break;
            }
            default: {
                bps = 1;
            }
        }
        return bps;
    }

    public static int getSPA(byte mode) {
        int spa;
        if (mode >= 49 && mode <= 57) {
            spa = mode - 48;
        } else {
            switch (mode) {
                case 83: {
                    spa = 1;
                    break;
                }
                case 67: {
                    spa = 2;
                    break;
                }
                case 86: {
                    spa = 3;
                    break;
                }
                case 81: {
                    spa = 4;
                    break;
                }
                case 77: {
                    spa = 9;
                    break;
                }
                case 88: {
                    spa = 10;
                    break;
                }
                case 84: {
                    spa = 16;
                    break;
                }
                case 65: {
                    spa = 32;
                    break;
                }
                default: {
                    spa = 1;
                }
            }
        }
        return spa;
    }

    public static int getSPA(char mode) {
        return Data.getSPA((byte)mode);
    }

    public double getTypeMax() {
        return Data.getTypeMax(this.type);
    }

    public static double getTypeMax(byte type) {
        double d = 0.0;
        switch (type) {
            case 68: {
                d = 1.0E37;
                break;
            }
            case 70: {
                d = 1.0E37f;
                break;
            }
            case 88: {
                d = 9.223372036854776E18;
                break;
            }
            case 76: {
                d = 2.147483647E9;
                break;
            }
            case 73: {
                d = 32767.0;
                break;
            }
            case 66: {
                d = 127.0;
            }
        }
        return d;
    }

    public double getTypeMin() {
        return Data.getTypeMin(this.type);
    }

    public static double getTypeMin(byte type) {
        double d = 0.0;
        switch (type) {
            case 68: {
                d = -1.0E37;
                break;
            }
            case 70: {
                d = -1.0E37f;
                break;
            }
            case 88: {
                d = -9.223372036854776E18;
                break;
            }
            case 76: {
                d = -2.147483647E9;
                break;
            }
            case 73: {
                d = -32768.0;
                break;
            }
            case 66: {
                d = -128.0;
            }
        }
        return d;
    }

    public byte getRep() {
        return this.rep;
    }

    public static byte getRep(String rep) {
        String string = rep = rep == null ? "" : rep.toUpperCase();
        if (rep.startsWith("VAX")) {
            return 86;
        }
        if (rep.equals("IEEE")) {
            return 73;
        }
        if (rep.equals("EEEI")) {
            return 69;
        }
        if (rep.equals("CRAY")) {
            return 67;
        }
        return 0;
    }

    public String getRepName() {
        return Data.getRepName(this.getRep());
    }

    public static String getRepName(byte rep) {
        switch (rep) {
            case 86: {
                return "VAX";
            }
            case 73: {
                return "IEEE";
            }
            case 69: {
                return "EEEI";
            }
            case 67: {
                return "CRAY";
            }
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public int getAPE() {
        return this.ape;
    }

    public int getSPA() {
        return this.spa;
    }

    public String getValue() {
        return this.toString();
    }

    public void setAPE(int ape) {
        double factor = (double)this.ape / (double)ape;
        int newSize = (int)Math.ceil((double)this.size * factor);
        this.setFrame(ape);
        this.setSize(newSize);
    }

    public Data getElementAt(int byteoffset, String format, int nelement) {
        Data element = new Data(format, nelement);
        element.setFrame(this.ape);
        element.setSize(nelement);
        System.arraycopy(this.buf, this.boff + byteoffset, element.buf, 0, this.bpe * nelement);
        return element;
    }

    public Data getAtomAt(int index) {
        Data atom = new Data();
        atom.setFormatType(this.type);
        atom.setFormatMode(this.mode);
        atom.setSize(1);
        int localbpe = atom.bpe < 0 ? (int)((double)(-atom.bpe / 8) + 0.9) : atom.bpe;
        int localbps = this.bps < 0 ? (int)((double)(-this.bps / 8) + 0.9) : this.bps;
        System.arraycopy(this.buf, this.boff + index * this.spa * localbps, atom.buf, 0, localbpe);
        return atom;
    }

    public Data getAtomAt(int byteoffset, String format) {
        Data atom = new Data();
        atom.setFormat(format);
        atom.setSize(1);
        System.arraycopy(this.buf, this.boff + byteoffset, atom.buf, 0, atom.bpe);
        return atom;
    }

    public Data getAtomAt(int byteoffset, String format, int natom) {
        Data atom = new Data(format, natom);
        System.arraycopy(this.buf, this.boff + byteoffset, atom.buf, 0, atom.bpe * natom);
        return atom;
    }

    public Data getScalarAt(int index) {
        Data scalar = new Data();
        scalar.setFormatMode((byte)83);
        scalar.setFormatType(this.type);
        scalar.setSize(1);
        System.arraycopy(this.buf, index * this.bps, scalar.buf, 0, scalar.bps);
        return scalar;
    }

    public void setScalarAt(int off, Object value) {
        Data data = value instanceof Data ? (Data)value : new Data(value);
        this.setScalarAt(off, data);
    }

    public void setScalarAt(int off, Data data) {
        int localbps = this.bps < 0 ? (int)((double)(-this.bps / 8) + 0.9) : this.bps;
        System.arraycopy(data.buf, 0, this.buf, this.boff + off, localbps);
    }

    public void setAtomAt(int index, Data atom) {
        int localbps = this.bps < 0 ? (int)((double)(-this.bps / 8) + 0.9) : this.bps;
        int atomSize = this.spa * localbps;
        System.arraycopy(atom.buf, atom.boff, this.buf, this.boff + index * atomSize, atomSize);
    }

    public void setElementAt(int index, Data element) {
        int localbpe = this.bpe < 0 ? (int)((double)(-this.bpe / 8) + 0.9) : this.bpe;
        System.arraycopy(element.buf, element.boff, this.buf, this.boff + index * localbpe, localbpe);
    }

    public int getBufLength() {
        return this.buf.length;
    }

    public byte[] getBuf() {
        return this.buf;
    }

    @InternalUseOnly(value="Since NeXtMidas 3.7.1")
    public String dump() {
        return "size=" + this.size + " mode=" + (char)this.mode + " type=" + (char)this.type + " rep=" + (char)this.rep + " attr=" + this.attr + " (bufLen=" + this.buf.length + ") buf=[" + this.printableBuf() + "] boff=" + this.boff + " bpe=" + this.bpe + " ape=" + this.ape + " spa=" + this.spa + " bps=" + this.bps;
    }

    private StringBuilder printableBuf() {
        StringBuilder sb = new StringBuilder();
        for (byte b : this.buf) {
            sb.append((char)(b == 0 ? 96 : (char)(b < 32 || 126 < b ? 46 : (char)b)));
        }
        return sb;
    }

    public String toASCII() {
        return this.toASCII(0, this.size, 10);
    }

    public String toASCII(int offset, int elements, int radix) {
        if (!this.isString()) {
            return this.toString(offset, elements, radix);
        }
        return new String(this.buf, this.boff + offset, this.size * this.bpe - offset);
    }

    public String toString() {
        return this.toString(0, this.size, 10);
    }

    public String toString(String pattern) {
        if (pattern.startsWith("(") && pattern.endsWith(")")) {
            pattern = MFormat.convertFortranPattern(pattern);
        }
        double dval = this.toD();
        MFormat mfmt = MFormat.getNumberFormatFor(pattern);
        if (pattern.equalsIgnoreCase("DMS") || pattern.equalsIgnoreCase("LAT") || pattern.equalsIgnoreCase("LON")) {
            return Convert.deg2dms(dval);
        }
        return mfmt.format(dval).trim();
    }

    public String toString(int offset, int elements, int radix) {
        return this.toString(null, offset, elements, radix, null, null, null, false).toString();
    }

    public StringBuilder toString(StringBuilder str, int offset, int elements, int radix, Boolean parens, CharSequence sSep, CharSequence eSep, boolean error) {
        if (this.isString()) {
            if (str == null) {
                str = new StringBuilder(this.size * this.bpe);
            }
            return str.append(Convert.unpackS(this.buf, offset, this.size * this.bpe));
        }
        int nscalar = elements * this.ape * this.spa;
        int i = offset;
        int n = i + nscalar;
        if (str == null) {
            str = new StringBuilder(nscalar * 12);
        }
        if (parens == null) {
            parens = nscalar > 1;
        }
        if (sSep == null) {
            sSep = ",";
        }
        if (eSep == null) {
            eSep = ",";
        }
        if (sSep.length() == 0) {
            throw new IllegalArgumentException("scalar separator cannot be empty");
        }
        if (eSep.length() == 0) {
            throw new IllegalArgumentException("element separator cannot be empty");
        }
        if (parens.booleanValue()) {
            str.append('(');
        }
        if (radix == 16) {
            str.append(Convert.bb2hex(this.buf, i * this.bps, this.bps));
            ++i;
            while (i < n) {
                str.append(i % this.spa == 0 ? eSep : sSep).append(Convert.bb2hex(this.buf, i * this.bps, this.bps));
                ++i;
            }
        } else if (radix == 8) {
            str.append(Convert.bb2oct(this.buf, i * this.bps, this.bps));
            ++i;
            while (i < n) {
                str.append(i % this.spa == 0 ? eSep : sSep).append(Convert.bb2oct(this.buf, i * this.bps, this.bps));
                ++i;
            }
        } else if (radix == 1 || radix == 2) {
            str.append(Convert.bb2bin(this.buf, i * this.bps, this.bps));
            ++i;
            while (i < n) {
                str.append(i % this.spa == 0 ? eSep : sSep).append(Convert.bb2bin(this.buf, i * this.bps, this.bps));
                ++i;
            }
        } else {
            if (radix != 10) {
                if (error) {
                    throw new MidasException("Unsupported Radix " + radix);
                }
                return str.append("Unsupported Radix ").append(radix);
            }
            switch (this.type) {
                case 68: {
                    str.append(this.getD(i++));
                    while (i < n) {
                        str.append(i % this.spa == 0 ? eSep : sSep).append(this.getD(i));
                        ++i;
                    }
                    break;
                }
                case 70: {
                    str.append(this.getF(i++));
                    while (i < n) {
                        str.append(i % this.spa == 0 ? eSep : sSep).append(this.getF(i));
                        ++i;
                    }
                    break;
                }
                case 76: {
                    str.append(this.getL(i++));
                    while (i < n) {
                        str.append(i % this.spa == 0 ? eSep : sSep).append(this.getL(i));
                        ++i;
                    }
                    break;
                }
                case 73: {
                    str.append(this.getI(i++));
                    while (i < n) {
                        str.append(i % this.spa == 0 ? eSep : sSep).append(this.getI(i));
                        ++i;
                    }
                    break;
                }
                case 74: {
                    str.append(this.getJ(i++));
                    while (i < n) {
                        str.append(i % this.spa == 0 ? eSep : sSep).append(this.getJ(i));
                        ++i;
                    }
                    break;
                }
                case 66: {
                    str.append(this.getB(i++));
                    while (i < n) {
                        str.append(i % this.spa == 0 ? eSep : sSep).append(this.getB(i));
                        ++i;
                    }
                    break;
                }
                case 88: {
                    str.append(this.getX(i++));
                    while (i < n) {
                        str.append(i % this.spa == 0 ? eSep : sSep).append(this.getX(i));
                        ++i;
                    }
                    break;
                }
                case 78: {
                    str.append(this.getN(i++));
                    while (i < n) {
                        str.append(i % this.spa == 0 ? eSep : sSep).append(this.getN(i));
                        ++i;
                    }
                    break;
                }
                case 80: {
                    str.append(this.getP(i++));
                    while (i < n) {
                        str.append(i % 8 == 0 ? eSep : "").append(this.getP(i));
                        ++i;
                    }
                    break;
                }
                case 86: {
                    str.append(this.getUL(i++));
                    while (i < n) {
                        str.append(i % this.spa == 0 ? eSep : sSep).append(this.getUL(i));
                        ++i;
                    }
                    break;
                }
                case 85: {
                    str.append(this.getUI(i++));
                    while (i < n) {
                        str.append(i % this.spa == 0 ? eSep : sSep).append(this.getUI(i));
                        ++i;
                    }
                    break;
                }
                default: {
                    if (error) {
                        throw new MidasException("Unknown Conversion '" + (char)this.type + "'");
                    }
                    return str.append("Unknown Conversion '").append((char)this.type).append("'");
                }
            }
        }
        if (parens.booleanValue()) {
            str.append(')');
        }
        return str;
    }

    @InternalUseOnly(value="provisional API - subject to change in future beta series")
    public void fromString(String string, String delims) {
        if (this.isString()) {
            this.fromString(string);
            return;
        }
        Object ref = null;
        StringTokenizer st = new StringTokenizer(string, delims);
        int numTokens = st.countTokens();
        int newSize = numTokens / this.ape / this.spa;
        this.setSize(newSize);
        switch (this.type) {
            case 68: {
                int i = 0;
                while (st.hasMoreTokens()) {
                    this.setD(i, Convert.s2d(st.nextToken(), ref));
                    ++i;
                }
                break;
            }
            case 70: {
                int i = 0;
                while (st.hasMoreTokens()) {
                    this.setF(i, (float)Convert.s2d(st.nextToken(), ref));
                    ++i;
                }
                break;
            }
            case 76: {
                int i = 0;
                while (st.hasMoreTokens()) {
                    this.setL(i, Convert.s2l(st.nextToken(), ref));
                    ++i;
                }
                break;
            }
            case 73: {
                int i = 0;
                while (st.hasMoreTokens()) {
                    this.setI(i, (short)Convert.s2l(st.nextToken(), ref));
                    ++i;
                }
                break;
            }
            case 66: {
                int i = 0;
                while (st.hasMoreTokens()) {
                    this.setB(i, (byte)Convert.s2l(st.nextToken(), ref));
                    ++i;
                }
                break;
            }
            case 88: {
                int i = 0;
                while (st.hasMoreTokens()) {
                    this.setX(i, Convert.s2xl(st.nextToken(), ref));
                    ++i;
                }
                break;
            }
            case 78: {
                int i = 0;
                while (st.hasMoreTokens()) {
                    this.setN(i, (byte)Convert.s2l(st.nextToken(), ref));
                    ++i;
                }
                break;
            }
            case 80: {
                int i = 0;
                while (st.hasMoreTokens()) {
                    this.setP(i, (byte)Convert.s2l(st.nextToken(), ref));
                    ++i;
                }
                break;
            }
            default: {
                throw new MidasException("Unknown Conversion from String to '" + (char)this.type + "' numTokens=" + numTokens);
            }
        }
    }

    public byte[] toA() {
        if (this.type == 65) {
            return this.buf;
        }
        return this.toString().getBytes();
    }

    public byte toP() {
        return (byte)this.toD();
    }

    public byte toN() {
        return (byte)this.toD();
    }

    public byte toB() {
        return (byte)this.toD();
    }

    public short toI() {
        return (short)this.toD();
    }

    public int toL() {
        return (int)this.toD();
    }

    public long toX() {
        return this.toNumber().longValue();
    }

    public float toF() {
        return (float)this.toD();
    }

    public double toD() {
        if (this.type == 68) {
            return this.unpackD(0);
        }
        if (this.type == 70) {
            return this.unpackF(0);
        }
        if (this.type == 76) {
            return this.unpackL(0);
        }
        if (this.type == 88) {
            return this.unpackX(0);
        }
        if (this.type == 73) {
            return this.unpackI(0);
        }
        if (this.type == 74) {
            return this.getJ(0);
        }
        if (this.type == 66) {
            return this.unpackB(0);
        }
        if (this.type == 78) {
            return this.getN(0);
        }
        if (this.type == 80) {
            return this.getP(0);
        }
        if (this.type == 65) {
            return Convert.s2d(this.toString());
        }
        if (this.type == 90) {
            return Convert.s2d(this.toString());
        }
        return 0.0;
    }

    Number toNumber() {
        if (this.type == 68) {
            return this.unpackD(0);
        }
        if (this.type == 70) {
            return Float.valueOf(this.unpackF(0));
        }
        if (this.type == 76) {
            return this.unpackL(0);
        }
        if (this.type == 88) {
            return this.unpackX(0);
        }
        if (this.type == 73) {
            return this.unpackI(0);
        }
        if (this.type == 74) {
            return this.getJ(0);
        }
        if (this.type == 66) {
            return this.unpackB(0);
        }
        if (this.type == 78) {
            return this.getN(0);
        }
        if (this.type == 80) {
            return this.getP(0);
        }
        if (this.type == 65) {
            return Convert.s2d(this.toString());
        }
        if (this.type == 90) {
            return Convert.s2d(this.toString());
        }
        return 0.0;
    }

    public Data convertTo(char newType) {
        return this.convertTo(newType, -1, true);
    }

    public Data convertTo(char newType, int bufSize, boolean fast) {
        Data data;
        int oldSize = this.size * this.spa;
        if (bufSize == -1) {
            bufSize = oldSize;
        }
        if (fast && this.type == newType && oldSize == bufSize) {
            data = this;
        } else {
            int toCopy = Math.min(oldSize, bufSize);
            byte[] buffer = new byte[bufSize * Data.getBPS(newType)];
            Convert.type(this.buf, this.boff, this.type, buffer, 0, (byte)newType, toCopy, 1, true);
            data = new Data(buffer, 0, buffer.length, (int)newType, this.spa);
            data.setFormatMode(this.mode);
        }
        return data;
    }

    Data convertTo(int newSize, int newSPA, char newMode, char newType) {
        return this.convertTo(newSize, newSPA, (byte)newMode, (byte)newType);
    }

    private Data convertTo(int newSize, int newSPA, byte newMode, byte newType) {
        Integer newSpaFromNewMode = Data.nullOrSpaFromMode(newMode);
        Integer newSpaFromNewSpa = Data.nullOrSpaFromSpa(newSPA);
        Byte newTypeFromNewType = Data.nullOrTypeFromType(newType);
        Integer newSizeFromNewSize = Data.nullOrSizeFromSize(newSize);
        if (null == newSpaFromNewMode && null == newSpaFromNewSpa) {
            newMode = this.mode;
            newSPA = this.spa;
        } else {
            if (null != newSpaFromNewMode && null != newSpaFromNewSpa && newSpaFromNewMode != newSpaFromNewSpa) {
                throw new IllegalArgumentException("Data: " + newSPA + " is not the SPA for mode '" + (char)newMode + "'");
            }
            if (null == newSpaFromNewMode) {
                newMode = Data.modeFromSpa(newSPA);
            } else if (null == newSpaFromNewSpa) {
                newSPA = newSpaFromNewMode;
            }
        }
        if (null == newTypeFromNewType) {
            newType = this.type;
        }
        if (newType != this.type && (Data.isString(newType) || Data.isString(this.type) || newType == 79 || this.type == 79)) {
            throw new IllegalArgumentException("Data: Unable to convert from type '" + (char)this.type + "' to type '" + (char)newType + "'");
        }
        Data.checkFormatPairing(newMode, newType);
        if (null == newSizeFromNewSize) {
            newSize = (this.size * this.spa + newSPA - 1) / newSPA;
        }
        Data data = this.size == newSize && this.spa == newSPA && this.mode == newMode && this.type == newType ? this : this.convertTo(newMode, newType, newSize);
        return data;
    }

    private Data convertTo(byte newMode, byte newType, int newSize) {
        Data data = new Data(newMode, newType, newSize);
        int numScalars = Math.min(this.numScalars(), data.numScalars());
        Convert.type(this.buf, this.boff, this.type, data.buf, 0, newType, numScalars, 1, true);
        return data;
    }

    private int numScalars() {
        return this.spa * this.ape * this.size;
    }

    private int numBytes() {
        return this.bpe > 0 ? this.bpe * this.size : (-this.bpe * this.size + 7) / 8;
    }

    private int numBytes(int numElements) {
        return this.bpe > 0 ? this.bpe * numElements : (-this.bpe * numElements + 7) / 8;
    }

    private void fillBufferFrom(Data src, int numElements) {
        int numBytesToWrite = src.numBytes(numElements);
        int numBytesOfData = Math.min(src.numBytes(), numBytesToWrite);
        int numBytesOfZeroes = numBytesToWrite - numBytesOfData;
        if (this.boff + numBytesToWrite > this.buf.length) {
            this.buf = new byte[this.boff + numBytesToWrite];
            numBytesOfZeroes = 0;
        }
        System.arraycopy(src.buf, src.boff, this.buf, this.boff, numBytesOfData);
        if (numBytesOfZeroes > 0) {
            Arrays.fill(this.buf, this.boff + numBytesOfData, this.boff + numBytesToWrite, (byte)0);
        }
    }

    private static Integer nullOrSpaFromMode(byte mode) {
        return 32 == mode ? null : Integer.valueOf(Data.spaFromMode(mode));
    }

    private static Integer nullOrSpaFromSpa(int spa) {
        return -1 == spa ? null : Integer.valueOf(Data.spaFromSpa(spa));
    }

    private static Byte nullOrTypeFromType(byte type) {
        return 95 == type ? null : Byte.valueOf(Data.typeFromType(type));
    }

    private static Integer nullOrSizeFromSize(int size) {
        return -1 == size ? null : Integer.valueOf(Data.sizeFromSize(size));
    }

    private static String getFormat(byte mode, byte type) {
        return "" + (char)mode + (char)type;
    }

    private static void checkFormatPairing(byte mode, byte type) {
        if (mode == 78 && type != 72 || type == 72 && mode != 78 || mode == 75 && type != 87 || type == 87 && mode != 75) {
            throw new IllegalArgumentException("Data: \"" + (char)mode + (char)type + "\" is not a valid FORMAT");
        }
    }

    private static byte modeFromMode(byte mode) {
        if (DATA_MODES.indexOf((char)mode) >= 0) {
            return mode;
        }
        throw new IllegalArgumentException("Data: '" + (char)mode + "' is not a valid MODE");
    }

    private static byte typeFromType(byte type) {
        if (DATA_TYPES.indexOf((char)type) >= 0) {
            return type;
        }
        if (Shell.getMidasContext().io.isOptionSet(CoreIO.IOOptions.MinimalSupportForUnsupportedDataTypes) && EXTENDED_DATA_TYPES.indexOf((char)type) >= 0) {
            return type;
        }
        throw new IllegalArgumentException("Data: '" + (char)type + "' is not a valid TYPE");
    }

    private static int spaFromSpa(int spa) {
        if (0 < spa && spa < 11 || spa == 16 || spa == 32) {
            return spa;
        }
        throw new IllegalArgumentException("Data: " + spa + " is not a valid SPA");
    }

    private static int sizeFromSize(int size) {
        if (-1 < size) {
            return size;
        }
        throw new IllegalArgumentException("Data: " + size + " is not a valid SIZE");
    }

    private static int spaFromMode(byte mode) {
        switch ((char)mode) {
            case '1': 
            case 'K': 
            case 'N': 
            case 'S': {
                return 1;
            }
            case '2': 
            case 'C': {
                return 2;
            }
            case '3': 
            case 'V': {
                return 3;
            }
            case '4': 
            case 'Q': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': 
            case 'M': {
                return 9;
            }
            case 'X': {
                return 10;
            }
            case 'T': {
                return 16;
            }
            case 'A': {
                return 32;
            }
        }
        throw new IllegalArgumentException("Data: '" + (char)mode + "' is not a valid MODE");
    }

    private static byte modeFromSpa(int spa) {
        switch (spa) {
            case 1: {
                return 83;
            }
            case 2: {
                return 67;
            }
            case 3: {
                return 86;
            }
            case 4: {
                return 81;
            }
            case 5: {
                return 53;
            }
            case 6: {
                return 54;
            }
            case 7: {
                return 55;
            }
            case 8: {
                return 56;
            }
            case 9: {
                return 77;
            }
            case 10: {
                return 88;
            }
            case 16: {
                return 84;
            }
            case 32: {
                return 65;
            }
        }
        throw new IllegalArgumentException("Data: " + spa + " is not a valid SPA");
    }

    private static int bpsFromType(byte type) {
        switch ((char)type) {
            case 'A': 
            case 'D': 
            case 'X': {
                return 8;
            }
            case 'F': 
            case 'L': {
                return 4;
            }
            case 'U': {
                return 2;
            }
            case 'V': {
                return 4;
            }
            case 'I': {
                return 2;
            }
            case 'J': {
                return -12;
            }
            case 'B': 
            case 'H': 
            case 'M': 
            case 'O': 
            case 'W': {
                return 1;
            }
            case 'N': {
                return -4;
            }
            case 'P': {
                return -1;
            }
            case 'Z': {
                return 256;
            }
        }
        throw new IllegalArgumentException("Data: '" + (char)type + "' is not a valid TYPE");
    }

    @Deprecated
    public byte unpackP(int off) {
        return Convert.unpackP(this.buf, this.boff * 8 + off, this.rep);
    }

    @Deprecated
    public byte unpackN(int off) {
        return Convert.unpackN(this.buf, this.boff * 4 + off, this.rep);
    }

    public byte unpackB(int off) {
        return this.buf[this.boff + off];
    }

    public char unpackC(int off) {
        return (char)this.buf[this.boff + off];
    }

    public short unpackI(int off) {
        return Convert.unpackI(this.buf, this.boff + off);
    }

    public int unpackL(int off) {
        return Convert.unpackL(this.buf, this.boff + off);
    }

    public long unpackX(int off) {
        return Convert.unpackX(this.buf, this.boff + off);
    }

    public float unpackF(int off) {
        return Convert.unpackF(this.buf, this.boff + off);
    }

    public double unpackD(int off) {
        return Convert.unpackD(this.buf, this.boff + off);
    }

    public String unpackS(int off, int len) {
        return Convert.unpackS(this.buf, this.boff + off, len);
    }

    @Deprecated
    public void packP(int off, byte val) {
        Convert.packP(this.buf, this.boff * 8 + off, val, this.rep);
    }

    @Deprecated
    public void packN(int off, byte val) {
        Convert.packN(this.buf, this.boff * 4 + off, val, this.rep);
    }

    public void packB(int off, byte val) {
        this.buf[this.boff + off] = val;
    }

    public void packC(int off, char val) {
        this.buf[this.boff + off] = (byte)val;
    }

    public void packI(int off, short val) {
        Convert.packI(this.buf, this.boff + off, val);
    }

    public void packL(int off, int val) {
        Convert.packL(this.buf, this.boff + off, val);
    }

    public void packX(int off, long val) {
        Convert.packX(this.buf, this.boff + off, val);
    }

    public void packF(int off, float val) {
        Convert.packF(this.buf, this.boff + off, val);
    }

    public void packD(int off, double val) {
        Convert.packD(this.buf, this.boff + off, val);
    }

    public void packS(int off, int len, String val) {
        Convert.packS(this.buf, this.boff + off, len, val);
    }

    public void packS(int off, int len, CharSequence val) {
        Convert.packS(this.buf, this.boff + off, len, val);
    }

    public void packData(int off, Data val) {
        System.arraycopy(val.buf, val.boff, this.buf, this.boff + off, val.bpe);
    }

    public byte getP(int off) {
        return Convert.unpackP(this.buf, this.boff * 8 + off, this.rep);
    }

    public byte getN(int off) {
        return Convert.unpackN(this.buf, this.boff * 2 + off, this.rep);
    }

    public byte getB(int off) {
        return this.buf[this.boff + off];
    }

    public char getC(int off) {
        return (char)this.buf[this.boff + off];
    }

    public short getJ(int off) {
        return Convert.unpackJ(this.buf, this.boff * 2 / 3 + off);
    }

    public short getI(int off) {
        return Convert.unpackI(this.buf, this.boff + (off << 1));
    }

    @InternalUseOnly
    public int getUI(int off) {
        return Convert.unpackU(this.buf, this.boff + (off << 1));
    }

    public int getL(int off) {
        return Convert.unpackL(this.buf, this.boff + (off << 2));
    }

    public long getUL(int off) {
        return Convert.unpackUL(this.buf, this.boff + (off << 2));
    }

    public long getX(int off) {
        return Convert.unpackX(this.buf, this.boff + (off << 3));
    }

    public float getF(int off) {
        return Convert.unpackF(this.buf, this.boff + (off << 2));
    }

    public double getD(int off) {
        return Convert.unpackD(this.buf, this.boff + (off << 3));
    }

    public byte[] getA(int off, int len) {
        return Convert.unpackA(this.buf, this.boff + (off << 3), len);
    }

    public byte[] getZ(int off, int len) {
        return Convert.unpackZ(this.buf, this.boff + (off << 3), len);
    }

    public void setP(int off, byte val) {
        Convert.packP(this.buf, this.boff * 8 + off, val, this.rep);
    }

    public void setN(int off, byte val) {
        Convert.packN(this.buf, this.boff * 2 + off, val, this.rep);
    }

    public void setB(int off, byte val) {
        this.buf[this.boff + off] = val;
    }

    public void setC(int off, char val) {
        this.buf[this.boff + off] = (byte)val;
    }

    public void setI(int off, short val) {
        Convert.packI(this.buf, this.boff + (off << 1), val);
    }

    public void setL(int off, int val) {
        Convert.packL(this.buf, this.boff + (off << 2), val);
    }

    public void setX(int off, long val) {
        Convert.packX(this.buf, this.boff + (off << 3), val);
    }

    public void setF(int off, float val) {
        Convert.packF(this.buf, this.boff + (off << 2), val);
    }

    public void setD(int off, double val) {
        Convert.packD(this.buf, this.boff + (off << 3), val);
    }

    public void setA(int off, int len, byte[] val) {
        Convert.packA(this.buf, this.boff + (off << 3), len, val);
    }

    public void setZ(int off, int len, byte[] val) {
        Convert.packZ(this.buf, this.boff + (off << 3), len, val);
    }

    public Number getNumber(int off) {
        switch (this.type) {
            case 68: {
                return this.getD(off);
            }
            case 70: {
                return Float.valueOf(this.getF(off));
            }
            case 88: {
                return this.getX(off);
            }
            case 76: {
                return this.getL(off);
            }
            case 73: {
                return this.getI(off);
            }
            case 66: {
                return this.getB(off);
            }
            case 78: {
                return this.getN(off);
            }
            case 80: {
                return this.getP(off);
            }
        }
        return null;
    }

    public void setNumber(int off, Number val) {
        if (val == null) {
            throw new NullPointerException("Expected a number but given null.");
        }
        switch (this.type) {
            case 68: {
                this.setD(off, val.doubleValue());
                break;
            }
            case 70: {
                this.setF(off, val.floatValue());
                break;
            }
            case 88: {
                this.setX(off, val.longValue());
                break;
            }
            case 76: {
                this.setL(off, val.intValue());
                break;
            }
            case 73: {
                this.setI(off, val.shortValue());
                break;
            }
            case 66: {
                this.setB(off, val.byteValue());
                break;
            }
            case 78: {
                this.setN(off, val.byteValue());
                break;
            }
            case 80: {
                this.setP(off, val.byteValue());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Can not set a numeric value in a " + this.getFormat() + " buffer");
            }
        }
    }

    private void prepArray(byte ntype) {
        int n = this.size * this.ape * this.spa;
        if (ntype == 0) {
            return;
        }
        if (ntype == this.atype && n <= Array.getLength(this.array)) {
            return;
        }
        this.atype = ntype;
        switch (this.atype) {
            case 80: {
                this.array = new byte[n / 8];
                break;
            }
            case 117: {
                this.array = new byte[n];
                break;
            }
            case 66: {
                this.array = new byte[n];
                break;
            }
            case 73: {
                this.array = new short[n];
                break;
            }
            case 76: {
                this.array = new int[n];
                break;
            }
            case 88: {
                this.array = new long[n];
                break;
            }
            case 70: {
                this.array = new float[n];
                break;
            }
            case 68: {
                this.array = new double[n];
            }
        }
    }

    public static boolean isFloat(byte type) {
        return type == 70 || type == 68;
    }

    public static String promoteFormat(String form1, String form2, String form3) {
        char mode1 = form1.charAt(0);
        char mode2 = form2.charAt(0);
        char mode = Data.getSPA(mode1) >= Data.getSPA(mode2) ? mode1 : mode2;
        char type = Data.promoteType(form1.charAt(1), form2.charAt(1));
        if (form3 != null && form3.length() > 0) {
            char mode3 = form3.charAt(0);
            mode = Data.getSPA(mode) >= Data.getSPA(mode3) ? mode : mode3;
            type = Data.promoteType(type, form3.charAt(1));
        }
        return "" + mode + type;
    }

    public static byte promoteType(byte t1, byte t2) {
        char ctype = Data.promoteType((char)t1, (char)t2, false, false);
        return (byte)ctype;
    }

    public static char promoteType(char t1, char t2) {
        return Data.promoteType(t1, t2, false, false);
    }

    public static char promoteType(char t1, char t2, char t3) {
        char t = Data.promoteType(t1, t2, false, false);
        return Data.promoteType(t, t3, false, false);
    }

    public static char promoteType(char t1, char t2, boolean formatOverride, boolean doublePrec) throws MidasException {
        int type = 68;
        if (t1 == t2) {
            type = t1;
        } else {
            if (Data.isString((byte)t1) || Data.isString((byte)t2)) {
                throw new MidasException("promoteType: non-numeric format type cannot be promoted");
            }
            if (!doublePrec) {
                boolean fp = Data.isFloat((byte)t1) || Data.isFloat((byte)t2);
                int size = Math.max(Data.getBPS(t1), Data.getBPS(t2));
                switch (size) {
                    case 8: {
                        type = (char)(fp ? 68 : 88);
                        break;
                    }
                    case 4: {
                        type = (char)(fp ? (formatOverride ? 68 : 70) : 76);
                        break;
                    }
                    case 2: {
                        type = 73;
                        break;
                    }
                    default: {
                        type = 66;
                    }
                }
            }
        }
        return (char)type;
    }

    @InternalUseOnly
    public static Object toRadix(int radix, Object obj) {
        if (radix != -1) {
            if (obj instanceof double[]) {
                obj = new Data(obj);
            } else if (obj instanceof float[]) {
                obj = new Data(obj);
            } else if (obj instanceof long[]) {
                obj = new Data(obj);
            } else if (obj instanceof int[]) {
                obj = new Data(obj);
            } else if (obj instanceof short[]) {
                obj = new Data(obj);
            } else if (obj instanceof byte[]) {
                obj = new Data(obj);
            } else if (obj instanceof Double) {
                obj = new Data(obj);
            } else if (obj instanceof Float) {
                obj = new Data(obj);
            } else if (obj instanceof Long) {
                obj = new Data(obj);
            } else if (obj instanceof Integer) {
                obj = new Data(obj);
            } else if (obj instanceof Short) {
                obj = new Data(obj);
            } else if (obj instanceof Byte) {
                obj = new Data(obj);
            }
            if (obj instanceof Data) {
                obj = ((Data)obj).toString(0, 1, radix);
            }
        }
        return obj;
    }

    @InternalUseOnly
    public static int getMultiplier(Object object) {
        if (object instanceof String) {
            return ((String)object).length();
        }
        if (object instanceof Object[]) {
            return ((Object[])object).length;
        }
        if (object instanceof double[]) {
            return ((double[])object).length;
        }
        if (object instanceof float[]) {
            return ((float[])object).length;
        }
        if (object instanceof long[]) {
            return ((long[])object).length;
        }
        if (object instanceof int[]) {
            return ((int[])object).length;
        }
        if (object instanceof short[]) {
            return ((short[])object).length;
        }
        if (object instanceof byte[]) {
            return ((byte[])object).length;
        }
        if (object instanceof boolean[]) {
            return ((boolean[])object).length;
        }
        return -1;
    }

    @InternalUseOnly
    public static char getDataTypeLetter(Object object) {
        if (object instanceof Table) {
            return 'T';
        }
        if (object instanceof String) {
            return 'S';
        }
        if (object instanceof KeyVector) {
            return 'K';
        }
        if (object instanceof Message) {
            return 'M';
        }
        if (object instanceof Double) {
            return 'd';
        }
        if (object instanceof Float) {
            return 'f';
        }
        if (object instanceof Long) {
            return 'x';
        }
        if (object instanceof Integer) {
            return 'l';
        }
        if (object instanceof Short) {
            return 'i';
        }
        if (object instanceof Byte) {
            return 'b';
        }
        if (object instanceof Boolean) {
            return 'z';
        }
        if (object instanceof Object[]) {
            return 'O';
        }
        if (object instanceof double[]) {
            return 'd';
        }
        if (object instanceof float[]) {
            return 'f';
        }
        if (object instanceof long[]) {
            return 'x';
        }
        if (object instanceof int[]) {
            return 'l';
        }
        if (object instanceof short[]) {
            return 'i';
        }
        if (object instanceof byte[]) {
            return 'b';
        }
        if (object instanceof boolean[]) {
            return 'z';
        }
        return 'O';
    }

    static char getDataTypeLetterPlus(Object object) {
        if (object instanceof BigDecimal || object instanceof BigInteger) {
            return 'n';
        }
        return Data.getDataTypeLetter(object);
    }

    private Object cast(byte ntype, boolean copy) {
        if (this.type == 72 || ntype == 72) {
            throw new MidasException("Cannot cast non-homogeneous data " + (char)this.type + "->" + (char)ntype);
        }
        if (this.type == ntype) {
            if (this.type == 68 && Native.useCastX) {
                return Native.castD(this.buf);
            }
            if (this.type == 70 && Native.useCast) {
                return Native.castF(this.buf);
            }
            if (this.type == 76 && Native.useCast) {
                return Native.castL(this.buf);
            }
            if (this.type == 73 && Native.useCast) {
                return Native.castI(this.buf);
            }
            if (this.type == 66) {
                return this.buf;
            }
        }
        if (ntype != this.atype) {
            this.prepArray(ntype);
        }
        if (copy) {
            Convert.bb2ja(this.buf, 0, this.type, this.array, 0, this.atype, this.size * this.ape * this.spa);
        }
        return this.array;
    }

    private void uncast(byte ntype, Object array, boolean copy) {
        if (this.type == 72 || ntype == 72) {
            throw new MidasException("Cannot uncast non-homogeneous data " + (char)this.type + "->" + (char)ntype);
        }
        if (this.type == ntype) {
            if (this.type == 68 && Native.useCastX) {
                Native.uncastD(this.buf);
                return;
            }
            if (this.type == 70 && Native.useCast) {
                Native.uncastF(this.buf);
                return;
            }
            if (this.type == 76 && Native.useCast) {
                Native.uncastL(this.buf);
                return;
            }
            if (this.type == 73 && Native.useCast) {
                Native.uncastI(this.buf);
                return;
            }
            if (this.type == 66) {
                return;
            }
        }
        if (copy) {
            Convert.ja2bb(array, 0, ntype, this.buf, 0, this.type, this.size * this.ape * this.spa);
        }
    }

    public double[] castD(boolean copy) {
        return (double[])this.cast((byte)68, copy);
    }

    public float[] castF(boolean copy) {
        return (float[])this.cast((byte)70, copy);
    }

    public long[] castX(boolean copy) {
        return (long[])this.cast((byte)88, copy);
    }

    public int[] castL(boolean copy) {
        return (int[])this.cast((byte)76, copy);
    }

    public short[] castI(boolean copy) {
        return (short[])this.cast((byte)73, copy);
    }

    public byte[] castB(boolean copy) {
        return (byte[])this.cast((byte)66, copy);
    }

    public void uncast(double[] array, boolean copy) {
        this.uncast((byte)68, array, copy);
    }

    public void uncast(float[] array, boolean copy) {
        this.uncast((byte)70, array, copy);
    }

    public void uncast(long[] array, boolean copy) {
        this.uncast((byte)88, array, copy);
    }

    public void uncast(int[] array, boolean copy) {
        this.uncast((byte)76, array, copy);
    }

    public void uncast(short[] array, boolean copy) {
        this.uncast((byte)73, array, copy);
    }

    public void uncast(byte[] array, boolean copy) {
        this.uncast((byte)66, array, copy);
    }

    public void toArray(Object array) {
        this.toArray(array, 0);
    }

    public void toArray(Object array, int offset) {
        if (array instanceof float[]) {
            this.toArray(array, offset, (byte)70);
        } else if (array instanceof double[]) {
            this.toArray(array, offset, (byte)68);
        } else if (array instanceof long[]) {
            this.toArray(array, offset, (byte)88);
        } else if (array instanceof int[]) {
            this.toArray(array, offset, (byte)76);
        } else if (array instanceof short[]) {
            this.toArray(array, offset, (byte)73);
        } else if (array instanceof byte[]) {
            this.toArray(array, offset, (byte)66);
        }
    }

    public void toArray(Object array, int aoff, byte atype) {
        Convert.bb2ja(this.buf, 0, this.type, array, aoff, atype, this.size * this.ape * this.spa);
    }

    public void fromArray() {
        Convert.ja2bb(this.array, 0, this.type, this.buf, 0, this.type, this.size * this.ape * this.spa);
    }

    public void fromArray(Object array) {
        if (array == this.array) {
            this.fromArray();
        } else if (array instanceof float[]) {
            this.fromArray(array, 0, (byte)70);
        } else if (array instanceof double[]) {
            this.fromArray(array, 0, (byte)68);
        } else if (array instanceof long[]) {
            this.fromArray(array, 0, (byte)88);
        } else if (array instanceof int[]) {
            this.fromArray(array, 0, (byte)76);
        } else if (array instanceof short[]) {
            this.fromArray(array, 0, (byte)73);
        } else if (array instanceof byte[]) {
            this.fromArray(array, 0, (byte)66);
        }
    }

    public void fromArray(Object array, int aoff, byte atype) {
        Convert.ja2bb(array, aoff, atype, this.buf, 0, this.type, this.size * this.ape * this.spa);
    }

    public void fromString(String string) {
        if (this.isString()) {
            int len = string.length();
            if (len > this.bpe) {
                len = this.bpe;
            }
            byte[] bytes = string.getBytes();
            System.arraycopy(bytes, 0, this.buf, 0, len);
            for (int i = len; i < this.bpe; ++i) {
                this.buf[i] = 32;
            }
        } else {
            Shell.warning("Data.fromString(String) only Data objects that are ASCII types can be set with this method - not type '" + (char)this.type + "'");
        }
    }

    @Override
    public Data getIndex(int index) {
        if (this.size > 1) {
            return this.getAtomAt(index);
        }
        return this.getScalarAt(index);
    }

    @InternalUseOnly
    public Time getHeaderTime() {
        return this.headerTime;
    }

    public Object getHeader() {
        return this.header;
    }

    public void setHeader(Object header) {
        this.header = header;
        this.headerTime = header != null && header instanceof Time ? (Time)header : null;
    }

    @Override
    public void setIndex(int index, Object value) {
        Shell.warning("Data.setIndex: Not yet implemented. This does nothing");
    }

    public static int getKeyIndex(String key) {
        return KeyObject.getKeyIndex(key);
    }

    public boolean isString() {
        return this.type == 65 || this.type == 90;
    }

    @InternalUseOnly
    public static boolean isString(byte typeByte) {
        return typeByte == 65 || typeByte == 90;
    }

    @ProvisionalUseOnly(value="Added as ProvisionalUseOnly in 3.8.0.  Intended to become public in a future release")
    public Object toObject() {
        if (this.isString()) {
            return this.toString();
        }
        switch (this.numScalars()) {
            case 0: {
                return null;
            }
            case 1: {
                return this.toNumber();
            }
        }
        return this.toList();
    }

    public List<Number> toList() {
        int nscalar = this.numScalars();
        ArrayList<Number> v = new ArrayList<Number>(nscalar);
        switch (this.type) {
            case 68: {
                for (int i = 0; i < nscalar; ++i) {
                    v.add(this.unpackD(i * 8));
                }
                break;
            }
            case 70: {
                for (int i = 0; i < nscalar; ++i) {
                    v.add(Float.valueOf(this.unpackF(i * 4)));
                }
                break;
            }
            case 88: {
                for (int i = 0; i < nscalar; ++i) {
                    v.add(this.unpackX(i * 8));
                }
                break;
            }
            case 76: {
                for (int i = 0; i < nscalar; ++i) {
                    v.add(this.unpackL(i * 4));
                }
                break;
            }
            case 73: {
                for (int i = 0; i < nscalar; ++i) {
                    v.add(this.unpackI(i * 2));
                }
                break;
            }
            case 66: {
                for (int i = 0; i < nscalar; ++i) {
                    v.add(this.buf[this.boff + i]);
                }
                break;
            }
            case 78: {
                for (int i = 0; i < nscalar; ++i) {
                    v.add(this.getN(i));
                }
                break;
            }
            case 80: {
                for (int i = 0; i < nscalar; ++i) {
                    v.add(this.getP(i));
                }
                break;
            }
            case 65: {
                throw new IllegalStateException("Can not convert String to List<Number>");
            }
            case 90: {
                throw new IllegalStateException("Can not convert String to List<Number>");
            }
        }
        return v;
    }

    @InternalUseOnly
    public List<List<Number>> toListSPA() {
        int nelem = this.ape * this.size;
        int i = 0;
        ArrayList<List<Number>> nestedSPA = new ArrayList<List<Number>>(nelem);
        switch (this.type) {
            case 68: {
                for (int e = 0; e < nelem; ++e) {
                    ArrayList<Double> spaList = new ArrayList<Double>(this.spa);
                    for (int s = 0; s < this.spa; ++s) {
                        spaList.add(this.unpackD(i * 8));
                        ++i;
                    }
                    nestedSPA.add(spaList);
                }
                break;
            }
            case 70: {
                for (int e = 0; e < nelem; ++e) {
                    ArrayList<Float> spaList = new ArrayList<Float>(this.spa);
                    for (int s = 0; s < this.spa; ++s) {
                        spaList.add(Float.valueOf(this.unpackF(i * 4)));
                        ++i;
                    }
                    nestedSPA.add(spaList);
                }
                break;
            }
            case 88: {
                for (int e = 0; e < nelem; ++e) {
                    ArrayList<Long> spaList = new ArrayList<Long>(this.spa);
                    for (int s = 0; s < this.spa; ++s) {
                        spaList.add(this.unpackX(i * 8));
                        ++i;
                    }
                    nestedSPA.add(spaList);
                }
                break;
            }
            case 76: {
                for (int e = 0; e < nelem; ++e) {
                    ArrayList<Integer> spaList = new ArrayList<Integer>(this.spa);
                    int s = 0;
                    while (s < this.spa) {
                        spaList.add(this.unpackL(i * 4));
                        ++i;
                        ++e;
                    }
                    nestedSPA.add(spaList);
                }
                break;
            }
            case 73: {
                for (int e = 0; e < nelem; ++e) {
                    ArrayList<Short> spaList = new ArrayList<Short>(this.spa);
                    for (int s = 0; s < this.spa; ++s) {
                        spaList.add(this.unpackI(i * 2));
                        ++i;
                    }
                    nestedSPA.add(spaList);
                }
                break;
            }
            case 66: {
                for (int e = 0; e < nelem; ++e) {
                    ArrayList<Byte> spaList = new ArrayList<Byte>(this.spa);
                    for (int s = 0; s < this.spa; ++s) {
                        spaList.add(this.buf[this.boff + i]);
                        ++i;
                    }
                    nestedSPA.add(spaList);
                }
                break;
            }
            case 78: {
                for (int e = 0; e < nelem; ++e) {
                    ArrayList<Byte> spaList = new ArrayList<Byte>(this.spa);
                    for (int s = 0; s < this.spa; ++s) {
                        spaList.add(this.getN(i));
                        ++i;
                    }
                    nestedSPA.add(spaList);
                }
                break;
            }
            case 80: {
                for (int e = 0; e < nelem; ++e) {
                    ArrayList<Byte> spaList = new ArrayList<Byte>(this.spa);
                    for (int s = 0; s < this.spa; ++s) {
                        spaList.add(this.getP(i));
                        ++i;
                    }
                    nestedSPA.add(spaList);
                }
                break;
            }
            case 65: {
                throw new IllegalStateException("Can not convert String to List<Number>");
            }
            case 90: {
                throw new IllegalStateException("Can not convert String to List<Number>");
            }
        }
        return nestedSPA;
    }

    @InternalUseOnly
    public List<String> toStringList() {
        int nscalar = this.numScalars();
        int numBytesString = this.spa * this.bps;
        ArrayList<String> lst = new ArrayList<String>(nscalar);
        switch (this.type) {
            case 68: {
                for (int i = 0; i < nscalar; ++i) {
                    lst.add(String.valueOf(this.unpackD(i * 8)));
                }
                break;
            }
            case 70: {
                for (int i = 0; i < nscalar; ++i) {
                    lst.add(String.valueOf(this.unpackF(i * 4)));
                }
                break;
            }
            case 88: {
                for (int i = 0; i < nscalar; ++i) {
                    lst.add(String.valueOf(this.unpackX(i * 8)));
                }
                break;
            }
            case 76: {
                for (int i = 0; i < nscalar; ++i) {
                    lst.add(String.valueOf(this.unpackL(i * 4)));
                }
                break;
            }
            case 73: {
                for (int i = 0; i < nscalar; ++i) {
                    lst.add(String.valueOf(this.unpackI(i * 2)));
                }
                break;
            }
            case 66: {
                for (int i = 0; i < nscalar; ++i) {
                    lst.add(String.valueOf(this.buf[this.boff + i]));
                }
                break;
            }
            case 78: {
                for (int i = 0; i < nscalar; ++i) {
                    lst.add(String.valueOf(this.getN(i)));
                }
                break;
            }
            case 80: {
                for (int i = 0; i < nscalar; ++i) {
                    lst.add(String.valueOf(this.getP(i)));
                }
                break;
            }
            case 65: {
                for (int i = 0; i < nscalar / this.spa; ++i) {
                    lst.add(this.unpackS(i * numBytesString, this.bps));
                }
                break;
            }
            case 90: {
                for (int i = 0; i < nscalar / this.spa; ++i) {
                    lst.add(this.unpackS(i * numBytesString, this.bps));
                }
                break;
            }
        }
        return lst;
    }

    public Vector<Object> toVector() {
        int nscalar = this.size * this.ape * this.spa;
        Vector<Object> v = new Vector<Object>(nscalar);
        switch (this.type) {
            case 68: {
                for (int i = 0; i < nscalar; ++i) {
                    v.addElement(this.unpackD(i * 8));
                }
                break;
            }
            case 70: {
                for (int i = 0; i < nscalar; ++i) {
                    v.addElement(Float.valueOf(this.unpackF(i * 4)));
                }
                break;
            }
            case 88: {
                for (int i = 0; i < nscalar; ++i) {
                    v.addElement(this.unpackX(i * 8));
                }
                break;
            }
            case 76: {
                for (int i = 0; i < nscalar; ++i) {
                    v.addElement(this.unpackL(i * 4));
                }
                break;
            }
            case 73: {
                for (int i = 0; i < nscalar; ++i) {
                    v.addElement(this.unpackI(i * 2));
                }
                break;
            }
            case 66: {
                for (int i = 0; i < nscalar; ++i) {
                    v.addElement(this.buf[this.boff + i]);
                }
                break;
            }
            case 78: {
                for (int i = 0; i < nscalar; ++i) {
                    v.addElement(this.getN(i));
                }
                break;
            }
            case 80: {
                for (int i = 0; i < nscalar; ++i) {
                    v.addElement(this.getP(i));
                }
                break;
            }
            case 65: {
                int i = 0;
                int ioff = 0;
                while (i < this.size) {
                    v.addElement(this.unpackS(ioff, this.bpe));
                    ++i;
                    ioff += this.bpe;
                }
                break;
            }
            case 90: {
                int i = 0;
                int ioff = 0;
                while (i < this.size) {
                    v.addElement(this.unpackS(ioff, this.bpe));
                    ++i;
                    ioff += this.bpe;
                }
                break;
            }
        }
        return v;
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (obj == null) {
            throw new NullPointerException("Can not compare " + this + " to " + obj + ".");
        }
        if (obj instanceof Data) {
            Data data = (Data)obj;
            if (this.spa == 1 && data.spa == 1) {
                return this.compareTo((Data)obj, 128);
            }
            return this.compareTo((Data)obj, 192);
        }
        return this.toString().compareTo(obj.toString());
    }

    public int compareTo(Data data, int flags) {
        if (data == this) {
            return 0;
        }
        if (data == null) {
            throw new NullPointerException("Can not compare " + this + " to " + data + ".");
        }
        if (flags == 32768) {
            flags = this.spa == 1 ? 128 : (data.spa == 1 ? 128 : 192);
        }
        if (this.isString() || data.isString()) {
            String t = this.toString();
            String d = data.toString();
            if ((flags & 0x80) == 0) {
                t = t.toUpperCase();
                d = d.toUpperCase();
            }
            return t.compareTo(d);
        }
        if (flags == -1) {
            return (int)Math.signum(this.toD() - data.toD());
        }
        if (this.size != 1 || data.size != 1 || this.ape != 1 || data.ape != 1) {
            throw new IllegalArgumentException("Can not compare data buffers with more than one atom given buffers with sizes " + this.size + " and " + data.size + " and atom-per-element (APE) " + this.ape + " and " + data.ape + ".");
        }
        if ((flags & 0x40) != 0) {
            double[] t = this.getMagnitude();
            double[] d = data.getMagnitude();
            return (int)Math.signum(t[0] - d[0]);
        }
        if (this.spa != 1 || data.spa != 1) {
            throw new IllegalArgumentException("Can not directly compare non-scalar values. Given values with formats " + this.getFormat() + " and " + data.getFormat() + ".");
        }
        return (int)Math.signum(this.toD() - data.toD());
    }

    public boolean equals(Data data, int flags, double tol) {
        boolean absTol;
        if (data == this) {
            return true;
        }
        if (data == null) {
            return false;
        }
        if ((flags & 0x220) == 0) {
            tol = 0.0;
        }
        if (flags == 32768) {
            flags = 386;
        }
        if (this.isString() || data.isString()) {
            if ((flags & 0x80) != 0) {
                return this.toString().equals(data.toString());
            }
            return this.toString().equalsIgnoreCase(data.toString());
        }
        if ((flags & 2) != 0 && this.size != data.size) {
            return false;
        }
        int size = Math.min(this.size, data.size);
        boolean bl = absTol = (flags & 0x200) != 0;
        if ((flags & 1) != 0) {
            if (this.bpe != data.bpe) {
                return false;
            }
            if (this.boff == data.boff && this.buf == data.buf) {
                return true;
            }
            int i = this.boff;
            int j = data.boff;
            int ii = i + size * this.ape * this.spa * this.bps;
            while (i < ii) {
                if (this.buf[i] != data.buf[i]) {
                    return false;
                }
                ++i;
                ++j;
            }
            return true;
        }
        if ((flags & 0x100) != 0) {
            if (this.ape != data.ape) {
                return false;
            }
            if (this.spa != data.spa) {
                return false;
            }
            byte type = this.type;
            if (this.type != data.type) {
                type = Data.promoteType(this.type, data.type);
            }
            if (type == 80 || type == 78) {
                type = 66;
            }
            Object array1 = this.cast(type, true);
            Object array2 = data.cast(type, true);
            boolean equal = absTol ? Tolerance.equalsWithAbsTolerance(array1, 0, array2, 0, size * this.ape * this.spa, tol) : Tolerance.equalsWithTolerance(array1, 0, array2, 0, size * this.ape * this.spa, tol);
            this.uncast(type, array1, false);
            data.uncast(type, array2, false);
            return equal;
        }
        if ((flags & 0x40) != 0) {
            if (this.ape != data.ape) {
                return false;
            }
            return absTol ? Tolerance.equalsWithAbsTolerance(this.getMagnitude(), 0, data.getMagnitude(), 0, size * this.ape, tol) : Tolerance.equalsWithTolerance(this.getMagnitude(), 0, data.getMagnitude(), 0, size * this.ape, tol);
        }
        return true;
    }

    static int parseTestFlag(String eqString, boolean absTol) {
        if (eqString.equals("==")) {
            return 386;
        }
        if (eqString.equals("~=")) {
            return absTol ? 898 : 418;
        }
        int iSlash = eqString.indexOf(47);
        if (iSlash < 0) {
            return 386;
        }
        String str = eqString.substring(iSlash + 1).replace('/', '|');
        int mask = Parser.mask("B,S,,,,T,M,C,V", str, 0);
        if ((mask & 0x141) == 0) {
            mask |= 0x100;
        }
        if (absTol & (mask & 0x20) != 0) {
            mask = mask & 0xFFFFFFDF | 0x200;
        }
        return mask;
    }

    public double[] getMagnitude() {
        if (this.isString()) {
            return null;
        }
        double[] vals = this.castD(true);
        double[] mag = new double[vals.length / this.spa];
        int j = 0;
        for (int i = 0; i < mag.length; ++i) {
            double m = 0.0;
            for (int k = 0; k < this.spa; ++k) {
                m += vals[j] * vals[j];
                ++j;
            }
            mag[i] = Math.sqrt(m);
        }
        this.uncast(vals, false);
        return mag;
    }

    public static int hashCodeByteArray(byte[] array) {
        int prime = 31;
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (int ii = 0; ii < array.length && ii < 32; ++ii) {
            result = prime * result + array[ii];
        }
        return prime * result + array.length;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.size;
        result = 31 * result + this.mode;
        result = 31 * result + this.type;
        result = 31 * result + Data.hashCodeByteArray(this.buf);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Data)) {
            return false;
        }
        Data other = (Data)obj;
        if (this.size != other.size) {
            return false;
        }
        if (this.mode != other.mode) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return Arrays.equals(this.buf, other.buf);
    }

    public <T extends Number> List<T> toList(Class<T> classType) {
        Class currentClass = (Class)numberTypes.get(this.type);
        if (currentClass == null) {
            return null;
        }
        Method castMethod = CASTING_METHODS.get(classType);
        Method getFromBuf = FROM_BUF_METHODS.get(this.type);
        if (castMethod == null) {
            Midas.log("Converting Data object to ArrayList functionality not avaialbe for class " + classType, 1);
            return null;
        }
        if (getFromBuf == null) {
            Midas.log("Converting Data object to ArrayList functionality not avaialbe for type " + this.type, 1);
            return null;
        }
        ArrayList<Number> result = new ArrayList<Number>();
        try {
            for (int i = 0; i < this.size; ++i) {
                result.add((Number)castMethod.invoke(getFromBuf.invoke((Object)this, i), new Object[0]));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Midas.log("Converting Data object has failed for class " + classType + " with exception " + e, 2);
        }
        return result;
    }

    private void fromListL(List<Integer> valuesList) {
        this.initTo(valuesList.stream().mapToInt(Integer::intValue).toArray());
    }

    private void fromListI(List<Short> valuesList) {
        short[] temp = new short[valuesList.size()];
        for (int i = 0; i < valuesList.size(); ++i) {
            temp[i] = valuesList.get(i);
        }
        this.initTo(temp);
    }

    private void fromListX(List<Long> valuesList) {
        this.initTo(valuesList.stream().mapToLong(Long::longValue).toArray());
    }

    private void fromListF(List<Float> valuesList) {
        float[] temp = new float[valuesList.size()];
        for (int i = 0; i < valuesList.size(); ++i) {
            temp[i] = valuesList.get(i).floatValue();
        }
        this.initTo(temp);
    }

    private void fromListD(List<Double> valuesList) {
        this.initTo(valuesList.stream().mapToDouble(Double::doubleValue).toArray());
    }

    private void fromListB(List<Byte> valuesList) {
        byte[] temp = new byte[valuesList.size()];
        for (int i = 0; i < valuesList.size(); ++i) {
            temp[i] = valuesList.get(i);
        }
        this.initTo(temp);
    }

    public void fromList(List<?> object) {
        if (object.size() == 0) {
            return;
        }
        if (object.get(0) instanceof Byte) {
            this.fromListB(object);
        }
        if (object.get(0) instanceof Integer) {
            this.fromListL(object);
        }
        if (object.get(0) instanceof Float) {
            this.fromListF(object);
        }
        if (object.get(0) instanceof Long) {
            this.fromListX(object);
        }
        if (object.get(0) instanceof Double) {
            this.fromListD(object);
        }
        if (object.get(0) instanceof Short) {
            this.fromListI(object);
        }
    }

    private static Map<Class<?>, Method> getCastingMethods() {
        HashMap temp = new HashMap();
        try {
            temp.put(Short.class, Number.class.getDeclaredMethod("shortValue", new Class[0]));
            temp.put(Byte.class, Number.class.getDeclaredMethod("byteValue", new Class[0]));
            temp.put(Float.class, Number.class.getDeclaredMethod("floatValue", new Class[0]));
            temp.put(Integer.class, Number.class.getDeclaredMethod("intValue", new Class[0]));
            temp.put(Long.class, Number.class.getDeclaredMethod("longValue", new Class[0]));
            temp.put(Double.class, Number.class.getDeclaredMethod("doubleValue", new Class[0]));
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        return temp;
    }

    private static Map<Byte, Method> getFromBufMethodsBuilder() {
        HashMap<Byte, Method> temp = new HashMap<Byte, Method>();
        try {
            temp.put((byte)66, Data.class.getDeclaredMethod("getB", Integer.TYPE));
            temp.put((byte)70, Data.class.getDeclaredMethod("getF", Integer.TYPE));
            temp.put((byte)73, Data.class.getDeclaredMethod("getI", Integer.TYPE));
            temp.put((byte)76, Data.class.getDeclaredMethod("getL", Integer.TYPE));
            temp.put((byte)88, Data.class.getDeclaredMethod("getX", Integer.TYPE));
            temp.put((byte)68, Data.class.getDeclaredMethod("getD", Integer.TYPE));
        }
        catch (NoSuchMethodException | SecurityException e) {
            temp = null;
        }
        return temp;
    }

    private static <T extends List<?>> T castObjectToList(Object obj) {
        return (T)((List)obj);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.header = this.headerTime;
    }
}

