/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Vector;
import nxm.sys.inc.ListFile;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.CsvFileModSwapInterface;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Util;

public class CsvFile
extends BaseFile
implements ListFile,
CsvFileModSwapInterface {
    private static final ColumnDef[] NO_COLUMNS = new ColumnDef[0];
    private final Vector<Table> rows = new Vector();
    private final Vector<String> head = new Vector();
    private boolean upToDate = false;
    private int headerRows = -1;
    private int pad = 16;
    private double seek = 0.0;
    private double xStart = 0.0;
    private double xDelta = 1.0;
    private int xUnits = 0;
    private double yStart = 0.0;
    private double yDelta = 1.0;
    private int yUnits = 0;
    private String defRowName = "ROW";
    private ColumnDef[] cols = NO_COLUMNS;

    public CsvFile() {
    }

    public CsvFile(String filename) {
        this.init(null, (Object)filename);
    }

    public CsvFile(FileName fn) {
        this.init(null, (Object)fn);
    }

    @Deprecated
    public CsvFile(Object ref, Object filename) {
        if (ref instanceof MidasReference) {
            this.init((MidasReference)ref, filename);
        } else {
            this.init(Convert.ref2Midas(ref), filename);
        }
    }

    public CsvFile(MidasReference ref, Object filename) {
        this.init(ref, filename);
    }

    private static String removeQuotes(String str) {
        if (str != null && (str = str.trim()).startsWith("\"") && str.endsWith("\"")) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    @Override
    public int seek(double val) {
        this.seek = val;
        return 1;
    }

    @Override
    public double seek() {
        return this.seek;
    }

    @Override
    public double avail() {
        return this.getSize() - this.seek();
    }

    @Override
    public double getSize() {
        return this.rows.size();
    }

    @Override
    public String getMimeType() {
        return "text/csv";
    }

    @Override
    public boolean open() {
        if (super.open()) {
            if (this.isInput) {
                this.readAll();
            }
            this.setInternals();
        }
        return this.isOpen;
    }

    @Override
    public void close() {
        super.close();
        this.cols = NO_COLUMNS;
        this.rows.clear();
        this.head.clear();
    }

    @Override
    public void update() {
        this.flush();
    }

    @Override
    public void flush() {
        if (this.isOutput && !this.upToDate && this.isOpen) {
            PrintStream out = new PrintStream(this.io.getOutputStream());
            for (int i = 0; i < this.getHeaderRows(); ++i) {
                out.println(this.getHeaderData(i));
            }
            for (Table row : this.rows) {
                out.println(CsvFile.colValuesToString(this.cols, this.pad, row));
            }
        }
    }

    private static Table colValuesFromString(Midas midas, int lineNum, ColumnDef[] cols, Parser parser) {
        Table row = new Table(2, 4);
        for (int i = 0; i < cols.length; ++i) {
            String name = cols[i].name;
            if (i < parser.elements()) {
                row.put(name, (Object)CsvFile.removeQuotes(parser.get(i + 1)));
                continue;
            }
            if (midas == null) continue;
            midas.warning("CsvFile: Missing value on line " + lineNum + ": " + name);
        }
        row.setFlags(0);
        return row;
    }

    private static Table colValuesFromString(Midas midas, int lineNum, ColumnDef[] cols, ArrayList<String> str) {
        Table row = new Table(2, 4);
        for (int i = 0; i < cols.length; ++i) {
            String name = cols[i].name;
            if (i < str.size()) {
                row.put(name, (Object)str.get(i));
                continue;
            }
            if (midas == null) continue;
            midas.warning("CsvFile: Missing value on line " + lineNum + ": " + name);
        }
        row.setFlags(0);
        return row;
    }

    private static String colHeadersToString(ColumnDef[] cols, int pad) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < cols.length; ++i) {
            String name = cols[i].name;
            String fmt = cols[i].format;
            if (fmt != null) {
                name = fmt + ":" + name;
            }
            name = "\"" + name + "\"";
            if (i != cols.length - 1) {
                name = name + ",";
            }
            str.append(StringUtil.padRight(name, pad));
        }
        return str.toString();
    }

    private static String colValuesToString(ColumnDef[] cols, int pad, Table row) {
        StringBuilder str = new StringBuilder();
        for (int j = 0; j < cols.length; ++j) {
            String name = cols[j].name;
            String val = row.getS(name);
            if (!StringUtil.isNumber(val)) {
                val = "\"" + val + "\"";
            }
            if (j != cols.length - 1) {
                val = val + ",";
            }
            str.append(StringUtil.padRight(val, pad));
        }
        return str.toString();
    }

    public static String tableToCsv(Table defs, Table data) {
        return CsvFile.tableToCsv(defs, data, 0);
    }

    public static String tableToCsv(Table defs, Table data, int pad) {
        return CsvFile.tableToCsv(defs, data, pad, "\n");
    }

    public static String tableToCsv(Table defs, Table data, int pad, String cr) {
        String[] rowNumbers = data.getKeys();
        Table[] rows = new Table[rowNumbers.length];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = data.getTable(rowNumbers[i]);
        }
        return CsvFile.tablesToCsv(defs, rows, pad, cr);
    }

    public static String tablesToCsv(Table defs, Table[] rows) {
        return CsvFile.tablesToCsv(defs, rows, 0);
    }

    public static String tablesToCsv(Table defs, Table[] rows, int pad) {
        return CsvFile.tablesToCsv(defs, rows, pad, "\n");
    }

    public static String tablesToCsv(Table defs, Table[] rows, int pad, String cr) {
        ColumnDef[] cols = CsvFile.toColsList(defs);
        StringBuilder str = new StringBuilder();
        str.append(CsvFile.colHeadersToString(cols, pad)).append(cr);
        for (int i = 0; i < rows.length; ++i) {
            str.append(CsvFile.colValuesToString(cols, pad, rows[i])).append(cr);
        }
        return str.toString();
    }

    public static Table[] csvToTables(Table defs, String str, int headerRows) {
        int i;
        String[] lines = str == null ? new String[]{} : str.split("[\n\r]+");
        int rowCount = Math.max(0, lines.length - headerRows);
        Table[] allRows = new Table[rowCount];
        if (defs == null && headerRows != 0 && lines.length > headerRows) {
            Parser parser = new Parser(lines[headerRows]);
            defs = new Table();
            for (i = 1; i <= parser.elements(); ++i) {
                ColumnDef def = CsvFile.getColumnDef(parser.get(i));
                defs.put(def.name, (Object)def.toTable());
            }
        }
        ColumnDef[] cols = CsvFile.toColsList(defs);
        i = headerRows;
        int j = 0;
        while (i < lines.length) {
            Parser parser = new Parser(lines[i], ',');
            parser.setUseSpaceDelimiter(false);
            allRows[j] = CsvFile.colValuesFromString(null, i, cols, parser);
            ++i;
            ++j;
        }
        return allRows;
    }

    private static ColumnDef[] toColsList(Table defs) {
        String[] colNames = defs.getKeys();
        ArrayList<ColumnDef> cols = new ArrayList<ColumnDef>(colNames.length);
        for (String colName : colNames) {
            cols.add(new ColumnDef(defs.getTable(colName)));
        }
        return cols.toArray(NO_COLUMNS);
    }

    @Override
    public String toString() {
        return "CsvFile : " + this.getURL();
    }

    @Override
    public String listHeader() {
        int i;
        StringBuilder str = new StringBuilder(256);
        str.append("CsvFile     : ").append(this.getURL()).append("\n");
        str.append("Rows        : ").append(this.rows.size()).append("\n");
        str.append("Columns     : ").append(this.cols.length).append("\n");
        str.append("Header      : ");
        int hr = this.getHeaderRows();
        if (hr == 0) {
            str.append("None\n");
        } else if (hr == 1) {
            str.append("First Row\n");
        } else {
            str.append("First ").append(hr).append(" Rows\n");
        }
        str.append("User Header : ");
        for (i = 0; i < hr - 1; ++i) {
            if (i > 0) {
                str.append("\n              ");
            }
            str.append(this.getHeaderData(i));
        }
        str.append("\n");
        for (i = 0; i < this.cols.length; ++i) {
            String name = this.cols[i].name;
            String format = this.cols[i].format;
            if (format == null) {
                format = "??";
            }
            str.append("Column Name=").append(StringUtil.padRight(name, 12));
            str.append("    Format=").append(format).append("\n");
        }
        return str.toString();
    }

    @Override
    public String listElements(double start, int elem, String format, int flags) {
        String str = null;
        if (start < (double)this.rows.size()) {
            str = this.getDataTable(start).toString() + "\n";
        }
        return str;
    }

    @Override
    public int listElementsPerLine(int lineWidth, String format, int flags) {
        return 1;
    }

    @Override
    public double getNumberOfRows() {
        return this.getSize();
    }

    @Override
    public boolean getProtected() {
        return true;
    }

    @Override
    public int getRecordDefCount() {
        return this.cols.length;
    }

    @Override
    public Table getDataTable(double offset) {
        if (offset >= (double)this.rows.size()) {
            return null;
        }
        Table row = this.rows.get((int)offset);
        return row.copy();
    }

    @Override
    public int setData(double offset, Table table) {
        this.putData((int)offset, table, false);
        return 1;
    }

    @Override
    public void setData(double element, String fieldName, Object obj) {
        Table tbl = this.rows.get((int)this.offset);
        tbl.put(fieldName, obj);
        this.setData(this.offset, tbl);
    }

    @Override
    public void insertData(double offset, Object obj) {
        this.putData((int)offset, Convert.o2t(obj), true);
    }

    @Override
    public final void removeData(double offset) {
        this.removeData(offset, 1L);
    }

    @Override
    public void removeData(double offset, long count) {
        if (Util.removeListElements(this.rows, (int)offset, (int)count)) {
            this.upToDate = false;
        }
    }

    @Override
    public void setRecordDefs(Table defs) {
        String[] keys = defs.getKeys();
        ArrayList<ColumnDef> list3 = new ArrayList<ColumnDef>();
        if (this.headerRows < 0) {
            this.setHeaderRows(1);
        }
        for (String key : keys) {
            Table def = defs.getTable(key);
            String str = def.getS("NAME", key);
            String fmt = def.getS("FORMAT", null);
            list3.add(CsvFile.getColumnDef(str, fmt));
        }
        this.cols = list3.toArray(NO_COLUMNS);
    }

    @Override
    public Table getRecordDefs() {
        Table tbl = new Table();
        for (int i = 0; i < this.getRecordDefCount(); ++i) {
            Table def = this.getRecordDef(i);
            tbl.put(def.getS("NAME"), (Object)def);
        }
        return tbl;
    }

    @Override
    public Table getRecordDef(int i) {
        return this.cols[i].toTable();
    }

    @Override
    public double getStart() {
        return this.getXStart();
    }

    @Override
    public double getDelta() {
        return this.getXDelta();
    }

    @Override
    public int getUnits() {
        return this.getXUnits();
    }

    @Override
    public double getXStart() {
        return this.xStart;
    }

    @Override
    public double getXDelta() {
        return this.xDelta;
    }

    @Override
    public int getXUnits() {
        return this.xUnits;
    }

    @Override
    public int getXFrame() {
        return (int)this.getNumberOfRows();
    }

    @Override
    public double getYStart() {
        return this.yStart;
    }

    @Override
    public double getYDelta() {
        return this.yDelta;
    }

    @Override
    public int getYUnits() {
        return this.yUnits;
    }

    @Override
    public int getYFrame() {
        return 1;
    }

    @Override
    public String getFormat() {
        return "NH";
    }

    @Override
    public int getMode() {
        return this.getFormat().charAt(0);
    }

    @Override
    public int getType() {
        return this.getFormat().charAt(1);
    }

    @Override
    public void connect(int mode) {
    }

    @Override
    public Data getDataBuffer(int elements) {
        Data data = new Data();
        int numBytes = 0;
        for (ColumnDef colDef : this.cols) {
            String fmt = colDef.getFormat();
            numBytes += Data.getBPA(fmt);
        }
        data.setFormat("NH");
        data.setRecLength(numBytes);
        data.setSize(elements);
        return data;
    }

    @Override
    public double getTimeAt(double offset) {
        return this.getXStart() + this.getXDelta() * offset;
    }

    @Override
    public int read(Data data, int elements) {
        int numRead = 0;
        int offset = 0;
        elements = Math.min(elements, data.size);
        for (numRead = 0; numRead < elements && this.avail() > 0.0; ++numRead) {
            Table tbl = this.getDataTable(this.seek());
            this.seek(this.seek() + 1.0);
            for (ColumnDef colDef : this.cols) {
                String name = colDef.name;
                String fmt = colDef.getFormat();
                int bps = Data.getBPA(fmt);
                switch (fmt.charAt(1)) {
                    case 'D': {
                        data.packD(offset, tbl.getD(name));
                        break;
                    }
                    case 'F': {
                        data.packF(offset, tbl.getF(name));
                        break;
                    }
                    case 'X': {
                        data.packX(offset, tbl.getX(name));
                        break;
                    }
                    case 'L': {
                        data.packL(offset, tbl.getL(name));
                        break;
                    }
                    case 'I': {
                        data.packI(offset, tbl.getI(name));
                        break;
                    }
                    case 'B': {
                        data.packB(offset, tbl.getB(name));
                        break;
                    }
                    case 'A': {
                        data.packS(offset, bps, tbl.getS(name));
                        break;
                    }
                    case 'Z': {
                        data.packS(offset, bps, tbl.getS(name));
                    }
                }
                offset += bps;
            }
        }
        return numRead;
    }

    public void setXStart(double val) {
        this.xStart = val;
    }

    public void setXDelta(double val) {
        this.xDelta = val;
    }

    public void setXUnits(int val) {
        this.xUnits = val;
    }

    public void setYStart(double val) {
        this.yStart = val;
    }

    public void setYDelta(double val) {
        this.yDelta = val;
    }

    public void setYUnits(int val) {
        this.yUnits = val;
    }

    public void setXUnits(String value) {
        this.setXUnits(DataFile.getUnitsID(value));
    }

    public void setYUnits(String value) {
        this.setYUnits(DataFile.getUnitsID(value));
    }

    public Table toTable() {
        return this.toTable(null);
    }

    public Table toTable(String prefix) {
        if (prefix == null) {
            prefix = this.defRowName + "_";
        }
        Table tbl = new Table();
        int i = 0;
        while ((double)i < this.getNumberOfRows()) {
            tbl.put(prefix + (i + 1), (Object)this.getDataTable(i));
            ++i;
        }
        return tbl;
    }

    public String toXml() {
        return "<XML>\n" + this.toXmlBrief(2) + "</XML>";
    }

    public String toXmlBrief(int indent) {
        return this.toXmlBrief(null, indent);
    }

    public String toXmlBrief(String tag, int indent) {
        if (tag == null) {
            tag = this.defRowName;
        }
        StringBuilder str = new StringBuilder();
        String indentStr = StringUtil.padLeft("", indent);
        int i = 0;
        while ((double)i < this.getNumberOfRows()) {
            Table row = this.getDataTable(i);
            str.append(indentStr).append("<").append(tag);
            for (ColumnDef colDef : this.cols) {
                String name = colDef.name;
                String val = row.getS(name);
                str.append(' ').append(name).append("=\"").append(val).append("\"");
            }
            str.append("/>");
            if (indent != -1) {
                str.append("\n");
            }
            ++i;
        }
        return str.toString();
    }

    public int getHeaderRows() {
        return this.headerRows < 1 ? 0 : this.headerRows;
    }

    public void setHeaderRows(int rows) {
        this.headerRows = rows;
    }

    public String getHeaderData(int row) {
        if (this.headerRows <= 0) {
            return null;
        }
        if (row < 0) {
            return null;
        }
        if (row > this.headerRows) {
            return null;
        }
        if (row == this.headerRows - 1) {
            return CsvFile.colHeadersToString(this.cols, this.pad);
        }
        if (row >= this.head.size()) {
            return "";
        }
        String data = this.head.get(row);
        return this.head == null ? "" : data.toString();
    }

    public boolean setHeaderData(int row, String data) {
        if (!this.isOutput) {
            return false;
        }
        if (this.headerRows <= 0) {
            return false;
        }
        if (row < 0) {
            return false;
        }
        if (row > this.headerRows) {
            return false;
        }
        if (row == this.headerRows - 1) {
            return false;
        }
        if (data != null && data.indexOf(10) > 0) {
            return false;
        }
        while (this.head.size() <= row) {
            this.head.add(null);
        }
        this.head.set(row, data);
        return true;
    }

    public Table getColumnNamesTable() {
        Table tbl = new Table();
        for (ColumnDef colDef : this.cols) {
            String name = colDef.name;
            tbl.put(name, (Object)colDef.toTable());
        }
        return tbl;
    }

    public String getColumnNames() {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.cols.length; ++i) {
            String name = this.cols[i].name;
            String fmt = this.cols[i].format;
            if (i != 0) {
                str.append(",");
            }
            if (fmt != null) {
                str.append(fmt).append(":");
            }
            str.append(name);
        }
        return str.toString();
    }

    public void setColumnNames(String str) {
        ArrayList<ColumnDef> list3 = new ArrayList<ColumnDef>();
        if (str != null) {
            str = str.replaceAll("[|]", ",");
            Parser parser = new Parser(str);
            for (int i = 1; i <= parser.elements(); ++i) {
                list3.add(CsvFile.getColumnDef(parser.get(i)));
            }
        }
        this.cols = list3.toArray(NO_COLUMNS);
    }

    public String getRowName() {
        return this.defRowName;
    }

    public void setRowName(String str) {
        if (str != null && str.length() > 0) {
            this.defRowName = str;
        }
    }

    private static ColumnDef getColumnDef(int colNum) {
        return CsvFile.getColumnDef("COL_" + colNum, null);
    }

    private static ColumnDef getColumnDef(String def) {
        Table col = new Table();
        String name = CsvFile.removeQuotes(def).toUpperCase();
        String fmt = null;
        if (name.length() > 2 && name.charAt(2) == ':') {
            fmt = name.substring(0, 2);
            name = name.substring(3);
        } else if (name.length() > 1 && name.charAt(1) == ':') {
            fmt = "S" + name.substring(0, 1).toUpperCase();
            name = name.substring(2);
        }
        return CsvFile.getColumnDef(name, fmt);
    }

    private static ColumnDef getColumnDef(String name, String fmt) {
        if ((name = name.toUpperCase().replaceAll("[^A-Z0-9_.-]", "_")).contains(".")) {
            name = name.replace(".", "->");
        }
        return new ColumnDef(name, fmt);
    }

    private void putData(int index, Table tbl, boolean insert) {
        Table row = new Table(2, 4);
        if (tbl == null) {
            throw new MidasException("CsvFile: Attempting to set values using a null table.");
        }
        for (ColumnDef colDef : this.cols) {
            String name = colDef.name;
            String fmt = colDef.format;
            Object val = CsvFile.removeQuotes(tbl.getS(name));
            if (fmt != null && fmt.length() == 2) {
                if (val == null) {
                    switch (fmt.charAt(1)) {
                        case 'A': {
                            val = "";
                            break;
                        }
                        case 'Z': {
                            val = "";
                            break;
                        }
                        case 'S': {
                            val = "";
                            break;
                        }
                        default: {
                            val = "0";
                        }
                    }
                }
                val = Convert.o2Data(val, fmt.charAt(1), null);
            } else if (val == null) {
                val = "";
            }
            if (val == null) continue;
            row.putx(name, val, 0);
        }
        row.setFlags(0);
        while (index > this.rows.size()) {
            this.putData(-1, new Table(), false);
        }
        boolean bl = insert = insert || index == this.rows.size();
        if (index < 0) {
            this.rows.add(row);
        } else if (insert) {
            this.rows.add(index, row);
        } else {
            this.rows.set(index, row);
        }
        this.upToDate = false;
    }

    private void readFile() {
        if (this.isOpen) {
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(this.io.getInputStream()));
                String line = in.readLine();
                Object nextLine = null;
                int lineNum = 0;
                while (line != null) {
                    int i;
                    ArrayList<ColumnDef> list3;
                    Parser parser = new Parser(line, ',');
                    parser.setUseSpaceDelimiter(false);
                    if (++lineNum != 0 || this.headerRows == -1) {
                        // empty if block
                    }
                    if (lineNum < this.getHeaderRows()) {
                        this.head.add(line);
                    } else if (lineNum == this.getHeaderRows()) {
                        if (this.cols.length == 0) {
                            list3 = new ArrayList<ColumnDef>();
                            for (i = 1; i <= parser.elements(); ++i) {
                                list3.add(CsvFile.getColumnDef(parser.get(i)));
                            }
                            this.cols = list3.toArray(NO_COLUMNS);
                        }
                    } else {
                        if (this.cols.length == 0) {
                            list3 = new ArrayList();
                            for (i = 1; i <= parser.elements(); ++i) {
                                list3.add(CsvFile.getColumnDef(i));
                            }
                            this.cols = list3.toArray(NO_COLUMNS);
                        }
                        Table row = CsvFile.colValuesFromString(this.M, lineNum, this.cols, parser);
                        this.putData(-1, row, false);
                    }
                    if (nextLine != null) {
                        line = nextLine;
                        nextLine = null;
                        continue;
                    }
                    line = in.readLine();
                }
            }
            catch (IOException e) {
                throw new MidasException("Error writing " + this + ": " + e, e);
            }
        }
        this.upToDate = true;
    }

    private void readAll() {
        if (this.isOpen) {
            StringBuilder sb = new StringBuilder();
            ArrayList<String> data = new ArrayList<String>();
            BufferedReader in = null;
            int lineNum = 0;
            String line = "";
            boolean fieldWithQuote = false;
            try {
                in = new BufferedReader(new InputStreamReader(this.io.getInputStream()));
                for (lineNum = 1; lineNum < this.getHeaderRows() && (line = in.readLine()) != null; ++lineNum) {
                    this.head.add(line);
                }
                int nextChar = in.read();
                block15: while (nextChar >= 0 || !data.isEmpty()) {
                    int currentChar;
                    if (nextChar >= 0) {
                        currentChar = nextChar;
                        nextChar = in.read();
                    } else {
                        currentChar = 10;
                        nextChar = -1;
                    }
                    if (currentChar == 13 && nextChar == 10) {
                        currentChar = 10;
                        nextChar = in.read();
                    }
                    switch (currentChar) {
                        case 34: {
                            if (fieldWithQuote) {
                                Shell.warning("Multiple values found in a single column on line " + lineNum);
                            }
                            fieldWithQuote = true;
                            if (this.hasLinefeed) {
                                while (nextChar >= 0) {
                                    currentChar = nextChar;
                                    nextChar = in.read();
                                    if (currentChar == 13 && nextChar == 10) {
                                        currentChar = 10;
                                        nextChar = in.read();
                                    }
                                    if (currentChar == 34 && nextChar == 34) {
                                        sb.append('\"');
                                        nextChar = in.read();
                                        continue;
                                    }
                                    if (currentChar == 34) continue block15;
                                    sb.append((char)currentChar);
                                }
                                continue block15;
                            }
                            while (nextChar >= 0) {
                                currentChar = nextChar;
                                nextChar = in.read();
                                if (currentChar == 13 && nextChar == 10) {
                                    currentChar = 10;
                                    nextChar = in.read();
                                }
                                if (currentChar == 10 || currentChar == 34) continue block15;
                                sb.append((char)currentChar);
                            }
                            continue block15;
                        }
                        case 44: {
                            data.add(sb.toString());
                            sb.delete(0, sb.length());
                            fieldWithQuote = false;
                            continue block15;
                        }
                        case 10: {
                            ArrayList<ColumnDef> list3;
                            data.add(sb.toString());
                            sb.delete(0, sb.length());
                            if (lineNum != 0 || this.headerRows == -1) {
                                // empty if block
                            }
                            if (lineNum < this.getHeaderRows()) {
                                throw new AssertionError((Object)"This should be impossible!");
                            }
                            if (lineNum == this.getHeaderRows()) {
                                if (this.cols.length == 0) {
                                    list3 = new ArrayList<ColumnDef>();
                                    for (String col : data) {
                                        list3.add(CsvFile.getColumnDef(col));
                                    }
                                    this.cols = list3.toArray(NO_COLUMNS);
                                }
                            } else {
                                if (this.cols.length == 0) {
                                    list3 = new ArrayList();
                                    for (int i = 0; i < data.size(); ++i) {
                                        list3.add(CsvFile.getColumnDef(data.get(i)));
                                    }
                                    this.cols = list3.toArray(NO_COLUMNS);
                                }
                                Table row = CsvFile.colValuesFromString(this.M, lineNum, this.cols, data);
                                this.putData(-1, row, false);
                            }
                            data.clear();
                            fieldWithQuote = false;
                            ++lineNum;
                            continue block15;
                        }
                    }
                    if (currentChar != 32 && currentChar != 9 && fieldWithQuote) {
                        Shell.warning("Multiple values found in a single column on line " + lineNum);
                    }
                    sb.append((char)currentChar);
                }
            }
            catch (IOException e) {
                throw new MidasException("Error writing " + this + ": " + e, e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    throw new MidasException("Error closing buffered reader");
                }
            }
        }
        this.upToDate = true;
    }

    private static final class ColumnDef {
        final String name;
        final String format;

        ColumnDef(String name, String format) {
            this.name = name;
            this.format = format;
        }

        ColumnDef(Table tbl) {
            this(tbl.getS("NAME"), tbl.getS("FORMAT"));
        }

        String getName() {
            return this.name;
        }

        String getFormat() {
            return this.format == null ? "XA" : this.format;
        }

        Table toTable() {
            Table table = new Table(2, 4);
            table.put("NAME", (Object)this.name);
            if (this.format != null) {
                table.put("FORMAT", (Object)this.format);
            }
            table.setFlags(0);
            return table;
        }
    }
}

