/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.datatype.XMLGregorianCalendar;
import nxm.sys.inc.AsciiMap;
import nxm.sys.inc.Constants;
import nxm.sys.inc.DataTypes;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.inc.Tablizable;
import nxm.sys.lib.Args;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Command;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Native;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Results;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Time;
import nxm.sys.lib.XMValue;
import nxm.sys.lib.XmlFile;
import nxm.sys.libm.ArgStack;

public class Convert
implements DataTypes,
AsciiMap,
Constants {
    private static final String roundingList = "ROUND,UP,DOWN,CEILING,FLOOR,HALF_UP,HALF_DOWN,HALF_EVEN,UNNECESSARY";
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;
    public static final int ROUND_ROUND = -1;
    private static final BigDecimal BigDecimal_NEG1 = BigDecimal.ONE.negate();
    private static final BigDecimal BigDecimal_TWO = BigDecimal.valueOf(2L);
    private static final BigDecimal BigDecimal_THREE = BigDecimal.valueOf(3L);
    private static final BigDecimal BigDecimal_FOUR = BigDecimal.valueOf(4L);
    private static final BigDecimal BigDecimal_FIVE = BigDecimal.valueOf(5L);
    private static final BigDecimal BigDecimal_SIX = BigDecimal.valueOf(6L);
    private static final BigDecimal BigDecimal_SEVEN = BigDecimal.valueOf(7L);
    private static final BigDecimal BigDecimal_EIGHT = BigDecimal.valueOf(8L);
    private static final BigDecimal BigDecimal_NINE = BigDecimal.valueOf(9L);
    private static final String String_Integer_MAX_VALUE = String.valueOf(Integer.MAX_VALUE);
    private static final String String_Integer_MIN_VALUE = String.valueOf(Integer.MIN_VALUE);
    private static final int DIGITS_INTEGER_MAX_VALUE = String_Integer_MAX_VALUE.length();
    private static final String String_Long_MAX_VALUE = String.valueOf(Long.MAX_VALUE);
    private static final String String_Long_MIN_VALUE = String.valueOf(Long.MIN_VALUE);
    private static final int DIGITS_LONG_MAX_VALUE = String_Long_MAX_VALUE.length();
    private static Pattern WHOLE_NUMBER_PATTERN = Pattern.compile("^[-+]?\\d+$");
    private static Pattern FLOAT_NUMBER_PATTERN = Pattern.compile("^([+-]?([0-9]*)(\\.([0-9]*+))?)([e][+-]?\\d+)?$");
    private static final String s2StateTrueStates = "|Y|YES|T|TRUE|ON|1|ABSC|";
    private static final String s2StateFalseStates = "|N|NO|F|FALSE|OFF|0|INDEX|";
    private static DecimalFormat nf = new DecimalFormat("0.0000000");
    private static int seditWarnCount = 0;
    private static int numSeditWarns = 3;
    private static byte[] bitrev = Convert.genbitrev();
    private static short[] ulaw = Convert.genulaw();
    private static final char[] alphabet = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    public static final int NO_VALID_VALUE_FOUND = -1;
    private static boolean favorJavaBehavior = false;
    private static boolean alwaysDefaultToDouble = false;
    private static boolean minSupportUnsupportedDataTypes = false;
    private static final int HMS = -1;
    private static final int DMS = -2;
    private static final int HEX = -3;
    private static final int BIN = -4;
    private static final String hexstr = "0123456789ABCDEF0123456789ABCDEF";
    private static final byte DRD = -81;
    private static final byte DRC = -82;
    private static final byte DRF = -83;
    private static final byte DRE = -84;
    private static final byte DRU = -85;
    private static final byte DRR = -86;
    private static final byte DRL = -87;
    private static final byte FRD = -41;
    private static final byte FRC = -42;
    private static final byte FRF = -43;
    private static final byte FRE = -44;
    private static final byte FRU = -45;
    private static final byte FRR = -46;
    private static final byte FRL = -47;

    private Convert() {
    }

    public static double s2d(String string) {
        return Convert.s2d(string, null);
    }

    public static double s2d(String string, Object ref) {
        if (string == null || string.length() == 0) {
            return 0.0;
        }
        double[] dval = new double[3];
        if (Convert.s2d(string.getBytes(), 0, string.length(), dval, ref) < 0) {
            throw new MidasException("Illegal numeric expression: " + string);
        }
        return dval[0];
    }

    private static BigDecimal s2BigDecimal(String string, Object ref) {
        if (string == null || string.length() == 0) {
            return new BigDecimal(0.0);
        }
        BigDecimalValue bdVal = new BigDecimalValue();
        if (Convert.s2BigDecimal(string.getBytes(), 0, string.length(), bdVal, ref) < 0) {
            throw new MidasException("Illegal numeric expression: " + string);
        }
        return bdVal.getValue();
    }

    public static Number s2n(String string) {
        return Convert.s2n(string, null);
    }

    public static Number s2n(String string, Object ref) {
        return Convert.s2n(string, ref, false, true);
    }

    public static int s2l(String string) {
        double objAsRintDouble = Math.rint(Convert.s2d(string));
        if (!favorJavaBehavior) {
            return (int)objAsRintDouble;
        }
        return (int)objAsRintDouble;
    }

    public static int s2l(String string, Object ref) {
        return (int)Convert.s2d(string, ref);
    }

    public static long s2xl(String string) {
        return Convert.s2xl(string, null);
    }

    public static long s2xl(String string, Object ref) {
        if (string == null || string.length() == 0) {
            return 0L;
        }
        Long xlResult = Convert.s2xl(string.getBytes(), 0, string.length(), ref);
        if (xlResult == null) {
            xlResult = (long)Convert.s2d(string, ref);
        }
        return xlResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int s2d(byte[] buffer, int index1, int index2, double[] dval, Object ref) {
        boolean OP_NONE = false;
        boolean OP_ADD = true;
        int OP_SUB = 2;
        int OP_MUL = 3;
        int OP_DIV = 4;
        int OP_POW = 5;
        int op = 1;
        double d = 0.0;
        int i = index1;
        while (i < index2) {
            int i2 = 0;
            byte c = buffer[i];
            if (c > 32) {
                if (c >= 65 && c <= 90 || c >= 97 && c <= 122) {
                    i2 = Convert.s2d_r(buffer, i, index2, dval, ref);
                } else if (c >= 48 && c <= 57 || c == 46 && i < index2 - 1) {
                    i2 = Convert.s2d_n(buffer, i, index2, dval, ref);
                } else if (c == 40) {
                    i2 = Convert.s2d_p(buffer, i, index2, dval, ref);
                } else if (c == 43) {
                    if (op == 0) {
                        op = 1;
                    }
                } else if (c == 45) {
                    op = op == 0 ? 2 : -op;
                } else if (c == 42) {
                    if (op == 0) {
                        op = 3;
                    } else {
                        if (op != 3) return -1;
                        op = 5;
                    }
                } else {
                    if (c != 47) return -1;
                    if (op == 0) {
                        op = 4;
                    } else {
                        i2 = Convert.s2d_s(buffer, i, index2, dval, ref);
                    }
                }
            }
            if (i2 > 0) {
                double dd = dval[0];
                if (op < 0) {
                    op = -op;
                    dd = -dd;
                }
                if (op == 0) {
                    return -1;
                }
                if (op == 1) {
                    d += dd;
                } else if (op == 2) {
                    d -= dd;
                } else if (op == 3) {
                    d *= dd;
                } else if (op == 4) {
                    d /= dd;
                } else {
                    if (op != 5) return -1;
                    d = Math.pow(d, dd);
                }
                i += i2;
                op = 0;
                continue;
            }
            if (i2 != 0) return -1;
            ++i;
        }
        if (op == 0) {
            dval[0] = d;
            return 1;
        } else if (op == 1) {
            dval[0] = d + 1.0;
            return 1;
        } else {
            if (op != 2) return -1;
            dval[0] = d - 1.0;
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int s2BigDecimal(byte[] buffer, int index1, int index2, BigDecimalValue bigDecimalVal, Object ref) {
        boolean OP_NONE = false;
        boolean OP_ADD = true;
        int OP_SUB = 2;
        int OP_MUL = 3;
        int OP_DIV = 4;
        int OP_POW = 5;
        int op = 1;
        BigDecimal bd = new BigDecimal(0);
        int i = index1;
        while (i < index2) {
            int i2 = 0;
            byte c = buffer[i];
            if (c > 32) {
                if (c >= 65 && c <= 90 || c >= 97 && c <= 122) {
                    i2 = Convert.s2BigDecimal_result(buffer, i, index2, bigDecimalVal, ref);
                } else if (c >= 48 && c <= 57 || c == 46 && i < index2 - 1) {
                    i2 = Convert.s2BigDecimal_number(buffer, i, index2, bigDecimalVal, ref);
                } else if (c == 40) {
                    i2 = Convert.s2BigDecimal_paren(buffer, i, index2, bigDecimalVal, ref);
                } else if (c == 43) {
                    if (op == 0) {
                        op = 1;
                    }
                } else if (c == 45) {
                    op = op == 0 ? 2 : -op;
                } else if (c == 42) {
                    if (op == 0) {
                        op = 3;
                    } else {
                        if (op != 3) {
                            bigDecimalVal.setToInvalid();
                            return -1;
                        }
                        op = 5;
                    }
                } else {
                    if (c != 47) {
                        op = -1;
                        break;
                    }
                    if (op == 0) {
                        op = 4;
                    } else {
                        i2 = Convert.s2BigDecimal_switch(buffer, i, index2, bigDecimalVal, ref);
                    }
                }
            }
            if (i2 > 0) {
                BigDecimal bd2nd = bigDecimalVal.getValue();
                if (op < 0) {
                    op = -op;
                    bd2nd = bd2nd.negate(MathContext.DECIMAL128);
                }
                if (op == 0) {
                    return -1;
                }
                if (op == 1) {
                    bd = bd.add(bd2nd, MathContext.DECIMAL128);
                } else if (op == 2) {
                    bd = bd.subtract(bd2nd, MathContext.DECIMAL128);
                } else if (op == 3) {
                    bd = bd.multiply(bd2nd, MathContext.DECIMAL128);
                } else if (op == 4) {
                    bd = bd.divide(bd2nd, MathContext.DECIMAL128);
                } else {
                    if (op != 5) {
                        bigDecimalVal.setToInvalid();
                        return -1;
                    }
                    try {
                        int exponent = bd2nd.intValueExact();
                        bd = bd.pow(exponent, MathContext.DECIMAL128);
                    }
                    catch (ArithmeticException ae) {
                        double exponent = bd2nd.doubleValue();
                        double base = bd.doubleValue();
                        double result = Math.pow(base, exponent);
                        bd = new BigDecimal(result);
                    }
                }
                i += i2;
                op = 0;
                continue;
            }
            if (i2 != 0) {
                bigDecimalVal.setToInvalid();
                return -1;
            }
            ++i;
        }
        if (op == 0) {
            bigDecimalVal.setValue(bd);
            return 1;
        }
        if (op == 1) {
            bigDecimalVal.setValue(bd.add(BigDecimal.ONE));
            return 1;
        }
        if (op == 2) {
            bigDecimalVal.setValue(bd.subtract(BigDecimal.ONE));
            return 1;
        }
        bigDecimalVal.setToInvalid();
        return -1;
    }

    private static int s2d_n(byte[] buffer, int index, int index2, double[] dval, Object ref) {
        byte c;
        int used = 1;
        int ie = 0;
        int np = 0;
        double d = 0.0;
        int i = index;
        while (i < index2 - 1) {
            if ((c = buffer[++i]) < 48 || c > 57 || ie == -3 || ie == -4) {
                int ix;
                if (ie == 0) {
                    if (c == 46 && np == 0) {
                        ++np;
                    } else if (c == 69 || c == 101) {
                        ie = i;
                        c = buffer[i + 1];
                        if (c == 43 || c == 45) {
                            ++i;
                        }
                    } else if (c == 58) {
                        ie = -1;
                    } else if (c == 39) {
                        ie = -2;
                    } else if ((c == 88 || c == 120) && i == index + 1 && buffer[index] == 48) {
                        ie = -3;
                    } else {
                        if (c != 66 && c != 98 || i != index + 1 || buffer[index] != 48) break;
                        ie = -4;
                    }
                } else if (ie == -1) {
                    if (c != 46 && c != 58) {
                        break;
                    }
                } else if (ie == -2) {
                    if (c != 46 && c != 39) {
                        break;
                    }
                } else if (ie == -3) {
                    if (c >= 48 && c <= 57) {
                        ix = c - 48;
                    } else if (c >= 65 && c <= 70) {
                        ix = c - 65 + 10;
                    } else {
                        if (c < 97 || c > 102) break;
                        ix = c - 97 + 10;
                    }
                    d = d * 16.0 + (double)ix;
                } else {
                    if (ie != -4 || c < 48 || c > 49) break;
                    ix = c - 48;
                    d = d * 2.0 + (double)ix;
                }
            }
            used = i - index + 1;
        }
        if (ie >= 0) {
            String temp = new String(buffer, index, used);
            try {
                d = Double.parseDouble(temp);
            }
            catch (Exception e) {
                used = -1;
            }
        } else if (ie == -1) {
            try {
                d = Time.tod2sec(buffer, index, index + used);
            }
            catch (Exception e) {
                used = -1;
            }
        } else if (ie == -2) {
            try {
                d = Convert.dms2deg(buffer, index, index + used);
            }
            catch (Exception e) {
                used = -1;
            }
        } else if (ie == -3) {
            double d2G = 2.147483648E9;
            double d4G = d2G + d2G;
            if (d >= d2G && d < d4G) {
                d -= d4G;
            }
        }
        if (used > 0 && i < index2) {
            c = buffer[i];
            if (c == 75 || c == 107) {
                d *= 1024.0;
                ++used;
            }
            if (c == 77 || c == 109) {
                d *= 1048576.0;
                ++used;
            }
            if (c == 71 || c == 103) {
                d *= 1.073741824E9;
                ++used;
            }
            if (c == 84 || c == 116) {
                d *= 1.099511627776E12;
                ++used;
            }
        }
        dval[0] = d;
        return used;
    }

    @InternalUseOnly(value="since created")
    private static int s2BigDecimal_number(byte[] buffer, int index, int index2, BigDecimalValue bdVal, Object ref) {
        byte c;
        int used = 1;
        int ie = 0;
        int np = 0;
        BigDecimal bd = new BigDecimal(0.0);
        int i = index;
        while (i < index2 - 1) {
            if ((c = buffer[++i]) < 48 || c > 57 || ie == -3 || ie == -4) {
                int ix;
                if (ie == 0) {
                    if (c == 46 && np == 0) {
                        ++np;
                    } else if (c == 69 || c == 101) {
                        ie = i;
                        c = buffer[i + 1];
                        if (c == 43 || c == 45) {
                            ++i;
                        }
                    } else if (c == 58) {
                        ie = -1;
                    } else if (c == 39) {
                        ie = -2;
                    } else if ((c == 88 || c == 120) && i == index + 1 && buffer[index] == 48) {
                        ie = -3;
                    } else {
                        if (c != 66 && c != 98 || i != index + 1 || buffer[index] != 48) break;
                        ie = -4;
                    }
                } else if (ie == -1) {
                    if (c != 46 && c != 58) {
                        break;
                    }
                } else if (ie == -2) {
                    if (c != 46 && c != 39) {
                        break;
                    }
                } else if (ie == -3) {
                    if (c >= 48 && c <= 57) {
                        ix = c - 48;
                    } else if (c >= 65 && c <= 70) {
                        ix = c - 65 + 10;
                    } else {
                        if (c < 97 || c > 102) break;
                        ix = c - 97 + 10;
                    }
                    bd = bd.multiply(new BigDecimal(16), MathContext.DECIMAL128);
                    bd = bd.add(new BigDecimal(ix), MathContext.DECIMAL128);
                } else {
                    if (ie != -4 || c < 48 || c > 49) break;
                    ix = c - 48;
                    bd = bd.add(bd, MathContext.DECIMAL128);
                    bd = bd.add(new BigDecimal(ix), MathContext.DECIMAL128);
                }
            }
            used = i - index + 1;
        }
        if (ie >= 0) {
            String temp = new String(buffer, index, used);
            try {
                bd = new BigDecimal(temp);
            }
            catch (Exception e) {
                used = -1;
            }
        } else if (ie == -1) {
            try {
                bd = new BigDecimal(Time.tod2sec(buffer, index, index + used));
            }
            catch (Exception e) {
                used = -1;
            }
        } else if (ie == -2) {
            try {
                bd = new BigDecimal(Convert.dms2deg(buffer, index, index + used));
            }
            catch (Exception e) {
                used = -1;
            }
        } else if (ie == -3) {
            double d2G = 2.147483648E9;
            double d4G = d2G + d2G;
            BigDecimal bd_2G = new BigDecimal(d2G);
            BigDecimal bd_4G = new BigDecimal(d4G);
            if (bd.compareTo(bd_2G) >= 0 && bd.compareTo(bd_4G) == -1) {
                bd = bd.subtract(bd_4G, MathContext.DECIMAL128);
            }
        }
        if (used > 0 && i < index2) {
            c = buffer[i];
            if (c == 75 || c == 107) {
                bd = bd.multiply(new BigDecimal(1024), MathContext.DECIMAL128);
                ++used;
            }
            if (c == 77 || c == 109) {
                bd = bd.multiply(new BigDecimal(0x100000), MathContext.DECIMAL128);
                ++used;
            }
            if (c == 71 || c == 103) {
                bd = bd.multiply(new BigDecimal(0x40000000), MathContext.DECIMAL128);
                ++used;
            }
            if (c == 84 || c == 116) {
                bd = bd.multiply(new BigDecimal(0x10000000000L), MathContext.DECIMAL128);
                ++used;
            }
        }
        bdVal.setValue(bd);
        return used;
    }

    public static boolean o2z(Object val) {
        return Convert.o2z(val, null);
    }

    public static boolean o2z(Object val, Object ref) {
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        String str = Convert.o2s(val, ref);
        if (str == null) {
            return false;
        }
        if (str.length() == 0) {
            return false;
        }
        if (StringUtil.isTrue(str)) {
            return true;
        }
        if (StringUtil.isFalse(str)) {
            return false;
        }
        if (str.startsWith("TEST(")) {
            return Convert.inLineTest(ref, str);
        }
        throw new MidasException("Unable to convert " + str + " to type Z. No applicable conversion found.");
    }

    public static boolean s2z(String val, Object ref) {
        return Convert.o2z(val, ref);
    }

    public static boolean s2z(String val) {
        return Convert.s2z(val, null);
    }

    public static boolean s2state(String svalue, boolean defvalue) {
        StringBuilder sb = new StringBuilder("|");
        sb.append(svalue);
        sb.append("|");
        String text = sb.toString();
        if (s2StateTrueStates.indexOf(text) >= 0) {
            return true;
        }
        if (s2StateFalseStates.indexOf(text) >= 0) {
            return false;
        }
        return defvalue;
    }

    private static double dms2deg(byte[] buffer, int i1, int i2) {
        int deg = 0;
        int min = 0;
        int sec = 0;
        int field = 1;
        int place = 1;
        int val = 0;
        double frac = 0.0;
        boolean neg = false;
        if (buffer[i1] == 45) {
            neg = true;
            ++i1;
        }
        for (int i = i2 - 1; i >= i1; --i) {
            byte b = buffer[i];
            if (b >= 48 && b <= 57) {
                val += (b - 48) * place;
                place *= 10;
                if (i != i1 && buffer[i - 1] != 39) continue;
                switch (field) {
                    case 1: {
                        sec = val;
                        break;
                    }
                    case 2: {
                        min = val;
                        break;
                    }
                    case 3: {
                        deg = val;
                    }
                }
                ++field;
                place = 1;
                val = 0;
                --i;
                continue;
            }
            if (b == 46 && field == 1) {
                frac = (double)val / (double)place;
                place = 1;
                val = 0;
                continue;
            }
            return 0.0;
        }
        double value = field == 2 ? (double)sec + frac : (field == 3 ? (double)min + ((double)sec + frac) / 60.0 : (double)deg + (double)min / 60.0 + ((double)sec + frac) / 3600.0);
        if (neg) {
            value = -value;
        }
        return value;
    }

    public static double dms2deg(String str) {
        byte[] buffer = str.getBytes();
        return Convert.dms2deg(buffer, 0, buffer.length);
    }

    public static String deg2dms(double deg) {
        return Convert.deg2dms(deg, '\'', '\'', "00");
    }

    public static String deg2dms(double deg, String secFormat) {
        return Convert.deg2dms(deg, '\'', '\'', secFormat);
    }

    public static String deg2dms(double deg, char degSign, char minSign) {
        return Convert.deg2dms(deg, degSign, minSign, "00");
    }

    public static String deg2dms(double deg, char degSign, char minSign, String secFormat) {
        return Convert.deg2dms(deg, Character.toString(degSign), Character.toString(minSign), secFormat);
    }

    public static String deg2dms(double deg, String degSign, String minSign, String secFormat) {
        DecimalFormat degMinDF = new DecimalFormat("00");
        DecimalFormat secDF = new DecimalFormat(secFormat);
        StringBuilder sb = new StringBuilder();
        int mult = deg < 0.0 ? -1 : 1;
        double dms = (double)mult * deg * 3600.0;
        double d = (int)dms / 3600;
        double m = (int)(dms -= d * 3600.0) / 60;
        double s = dms -= m * 60.0;
        String degStr = degMinDF.format((double)mult * d);
        String minStr = degMinDF.format(m);
        String secStr = secDF.format(s);
        if (secStr.startsWith("60")) {
            if (m == 59.0) {
                d += 1.0;
                m = 0.0;
                s = 0.0;
            } else {
                m += 1.0;
                s = 0.0;
            }
            degStr = degMinDF.format((double)mult * d);
            minStr = degMinDF.format(m);
            secStr = secDF.format(s);
        }
        sb.append(degStr).append(degSign);
        sb.append(minStr).append(minSign);
        sb.append(secStr);
        return sb.toString();
    }

    public static String deg2dmsUnicode(double deg) {
        return Convert.deg2dms(deg, '\u00b0', '\'');
    }

    public static String deg2dmsUnicode(double deg, String axis) {
        if (axis == null || !axis.equals("NS") && !axis.equals("EW")) {
            throw new MidasException("Convert.deg2dmsUnicode(double,String): second parameter must be either 'NS' or 'EW', given '" + axis + "'.");
        }
        if (deg > 0.0) {
            return Convert.deg2dms(deg, '\u00b0', '\'') + axis.charAt(0);
        }
        return Convert.deg2dms(-deg, '\u00b0', '\'') + axis.charAt(1);
    }

    private static int s2d_i(double[] dval, String name, int lr) {
        if (StringUtil.isNaN(name)) {
            dval[0] = Double.NaN;
        } else if (StringUtil.isInf(name)) {
            dval[0] = Double.POSITIVE_INFINITY;
        } else {
            lr = -1;
        }
        return lr;
    }

    @InternalUseOnly
    static DataFile inLineFile(MidasReference ref, String name, boolean write) {
        FileName fn = BaseFile.getFileNameFor(ref, name);
        BaseFile bf = BaseFile.getInstanceFor(ref, (Object)fn);
        DataFile df = bf instanceof DataFile ? (DataFile)bf : new DataFile();
        df.init(ref, (Object)name, "", "", 0);
        df.open(write ? 11 : 1);
        return df;
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.5.4")
    public static Object inLineSedit(MidasReference ref, String test) {
        String testStr = test.substring(6, test.length() - 1);
        Midas midas = Convert.ref2Midas(ref);
        Parser p = new Parser(testStr, true);
        Args args = new Args(midas, p);
        if (ref instanceof Args) {
            ((Args)ref).copySwitchesTo(args);
        }
        return Convert.processSeditCommandLine(args.getCS(1), midas, args, 2, false);
    }

    @InternalUseOnly
    public static Object processSeditCommandLine(String inputString, Midas M, Args MA, int nextArgIndex, boolean dbg) {
        Object obj = null;
        String currString = inputString;
        int inputStringArgNum = 1;
        int argCount = nextArgIndex;
        boolean clean = MA.getState("/CLEAN", true);
        boolean strip = MA.getState("/STRIP", false);
        boolean legacy = MA.getState("/LEGACY", MA.getState("/SEDITLEGACY", true));
        int base = MA.getL("/BASE", MA.getState("/ONEBASE") || MA.getState("/OB") ? 1 : 0);
        while (argCount <= MA.getNArgs()) {
            String func = MA.getU(argCount++);
            if (dbg) {
                System.out.println("SEDIT: argc=" + argCount + " str='" + currString + "' func=" + func + " P1='" + MA.getU(argCount) + "' P2='" + MA.getU(argCount + 1) + "'");
            }
            if (func.startsWith("APPEND")) {
                String p1 = MA.getCS(argCount++);
                obj = currString + p1;
            } else if (func.startsWith("BETW") && legacy) {
                int imin = MA.getL(argCount++);
                int imax = MA.getL(argCount++);
                if (seditWarnCount++ < numSeditWarns && (base == 1 && imin <= 0 || imin < 0 || base == 1 && imax <= 0 || imax < 0)) {
                    M.deprecate("SEDIT: As of NeXtMidas 3.1.2, the current default behaviour of SEDIT BETWEEN when using  negative numbers (and zero when one-based) will change in a future release. See the SEDIt explain file for details of new behaviour.");
                }
                if (imin >= 0 && imin < currString.length()) {
                    imin -= base;
                } else if (base == 1 && imin == 0) {
                    imin = currString.length();
                }
                if (imax >= 0 && imax <= currString.length()) {
                    imax -= base;
                } else if (base == 1 && imax == 0) {
                    imax = currString.length();
                }
                obj = StringUtil.substring(currString, imin, imax);
            } else if (func.startsWith("BETW")) {
                int i1 = MA.getL(argCount++);
                int i2 = MA.getL(argCount++);
                obj = StringUtil.between(currString, i1 -= base, i2 -= base);
            } else if (func.startsWith("BSEA")) {
                String p1;
                int retVal;
                if ((retVal = currString.lastIndexOf(p1 = MA.getU(argCount++))) >= 0) {
                    retVal += base;
                }
                obj = new Data(retVal);
            } else if (func.startsWith("CARETS")) {
                obj = MA.evaluateCarets(currString);
            } else if (func.equals("CLEAN")) {
                obj = StringUtil.cleanString(currString);
            } else if (func.startsWith("ELEM")) {
                int lval = MA.getL(argCount++);
                String p2 = MA.getU(argCount++);
                obj = StringUtil.getWordByElement(currString, lval, p2);
            } else if (func.startsWith("ENDS")) {
                String p1 = MA.getCS(argCount++);
                obj = currString.endsWith(p1);
            } else if (func.equals("EXT")) {
                obj = FileUtil.ext(currString);
            } else if (func.startsWith("GSUB")) {
                String p1 = MA.getU(argCount++);
                String p2 = MA.getU(argCount++);
                obj = StringUtil.subs(currString, p1, p2, true);
            } else if (func.equals("HEAD") || func.equals("PATH")) {
                obj = FileUtil.head(currString);
            } else if (func.equals("JOIN")) {
                Object tempObj = MA.getO(inputStringArgNum);
                String p1 = MA.getU(argCount++);
                obj = StringUtil.join((String[])tempObj, p1);
            } else if (func.equals("KEY")) {
                String p1 = MA.getU(argCount++);
                String p2 = MA.getU(argCount++);
                obj = StringUtil.getKeyValue(currString, p1, p2);
            } else if (func.startsWith("LEN") && legacy) {
                int index;
                if ((index = MA.getL(argCount++, -1)) >= 0) {
                    index -= base;
                }
                obj = new Data(StringUtil.length(currString, index));
            } else if (func.startsWith("LEN")) {
                int index = MA.getL(argCount++);
                obj = new Data(StringUtil.lengthElement(currString, index));
            } else if (func.startsWith("LOCA")) {
                obj = currString.toLowerCase();
            } else if (func.startsWith("MASK")) {
                String p1 = MA.getU(argCount++);
                int retval = Parser.mask(currString, p1, 0);
                obj = new Data(retval);
            } else if (func.startsWith("NEL")) {
                String p1;
                if ((p1 = MA.getU(argCount++)).equals("")) {
                    p1 = ",";
                }
                obj = new Data(StringUtil.nelements(currString, p1));
            } else if (func.equals("NFORM")) {
                double dval = MA.getD(inputStringArgNum);
                String p1 = MA.getU(argCount++);
                obj = StringUtil.nform(dval, p1);
            } else if (func.startsWith("NSEA")) {
                String p1 = MA.getU(argCount++);
                int p2 = MA.getL(argCount++);
                obj = new Data(StringUtil.getOccurrenceOf(currString, p1, p2) + base);
            } else if (func.startsWith("PAD")) {
                String newLenStr = MA.getCS(argCount);
                int newLen = MA.getL(argCount++);
                if (newLenStr != null && newLenStr.length() > 1 && newLenStr.charAt(0) == '+') {
                    newLen = currString.length() + Integer.parseInt(newLenStr.substring(1));
                }
                String padStr = MA.getCS(argCount++);
                obj = StringUtil.pad(currString, newLen, func, padStr);
            } else if (func.equals("PARSE")) {
                String p2;
                int lval = MA.getL(argCount++);
                if ((p2 = MA.getU(argCount++)).length() > 1) {
                    p2 = "";
                    --argCount;
                }
                obj = StringUtil.parse(currString, lval, p2, clean);
            } else if (func.startsWith("PARSEAL")) {
                int lval = MA.getL(argCount++);
                String p2 = MA.getU(argCount++);
                obj = StringUtil.parseAll(currString, lval, p2, clean);
            } else if (func.startsWith("PARSEAR")) {
                obj = Args.parseCommand(M, currString);
            } else if (func.startsWith("PARSEDI")) {
                String p1;
                int retval;
                if ((retval = StringUtil.getParsedElementIndex(currString, p1 = MA.getU(argCount++), clean)) >= 0) {
                    retval += base;
                }
                obj = new Data(retval);
            } else if (func.startsWith("PREPEND")) {
                String p1 = MA.getCS(argCount++);
                obj = p1 + currString;
            } else if (func.equals("RANGE") && legacy) {
                String p2;
                int i1 = MA.getL(argCount++);
                int i2 = MA.getL(argCount);
                if ((p2 = MA.getU(argCount++)).equals("")) {
                    i2 = currString.length();
                }
                if (base == 1 && (i1 == 0 || i2 == 0)) {
                    if (i1 == 0) {
                        i1 = currString.length();
                    }
                    if (i2 == 0) {
                        i2 = currString.length();
                    }
                }
                if (i1 >= 0 && i1 <= currString.length()) {
                    i1 -= base;
                }
                if (i2 >= 0 && i2 < currString.length()) {
                    i2 -= base;
                }
                if (seditWarnCount++ < numSeditWarns && base == 0 && (i1 < 0 || i2 < 0)) {
                    M.deprecate("SEDIT: As of NeXtMidas 3.1.2, behaviour of negative numbers in RANGE function will change in a future release. See SEDIT explain file for details.");
                }
                obj = StringUtil.range(currString, i1, i2);
            } else if (func.equals("RANGE")) {
                int i1 = MA.getL(argCount++);
                int i2 = MA.getL(argCount++);
                obj = StringUtil.getStringInRange(currString, i1 -= base, i2 -= base);
            } else if (func.equals("ROOT")) {
                obj = FileUtil.root(currString);
            } else if (func.startsWith("SEAR")) {
                String p1;
                int retVal;
                if ((retVal = currString.indexOf(p1 = MA.getU(argCount++))) >= 0) {
                    retVal += base;
                }
                obj = new Data(retVal);
            } else if (func.startsWith("SEL") && legacy) {
                String p1 = MA.getU(argCount++);
                int retVal = -1;
                if (seditWarnCount++ < numSeditWarns && base != 1) {
                    M.deprecate("SEDIT: As of NeXtMidas 3.1.2, the current behaviour of SEDIT SELECT is deprecated. SEDIT SELECT will become 1-index based in a future release");
                }
                if ((retVal = StringUtil.select(currString, p1)) >= 0) {
                    retVal += base;
                }
                obj = new Data(retVal);
            } else if (func.startsWith("SEL")) {
                String p1 = MA.getU(argCount++);
                int retVal = StringUtil.selectElement(currString, p1);
                obj = new Data(retVal);
            } else if (func.startsWith("SPLIT")) {
                String p1 = MA.getU(argCount++);
                obj = StringUtil.split(currString, p1);
            } else if (func.startsWith("STARTS")) {
                String p1 = MA.getCS(argCount++);
                obj = currString.startsWith(p1);
            } else if (func.equals("STRIM")) {
                obj = currString.trim();
            } else if (func.equals("STRIP")) {
                obj = StringUtil.stripQuotes(currString);
            } else if (func.startsWith("SUB")) {
                String p1 = MA.getU(argCount++);
                String p2 = MA.getU(argCount++);
                obj = StringUtil.subs(currString, p1, p2, false);
            } else if (func.equals("TAIL")) {
                obj = FileUtil.tail(currString);
            } else if (func.equals("TRIM")) {
                String p1 = MA.getU(argCount++);
                String p2 = MA.getU(argCount++);
                obj = StringUtil.trim(currString, p1, p2);
            } else if (func.startsWith("UPCA")) {
                obj = currString.toUpperCase();
            } else if (func.equals("WORD")) {
                String p1 = MA.getU(argCount++);
                obj = StringUtil.getWordByString(currString, p1);
            } else {
                M.warning("Unsupported function: " + func);
            }
            if (strip) {
                obj = StringUtil.stripQuotes(obj.toString());
            }
            obj = StringUtil.convertNullsToEmpty(obj);
            currString = obj.toString();
        }
        return obj;
    }

    @Deprecated
    public static boolean inLineTest(Object ref, String test) {
        if (ref instanceof MidasReference) {
            return Args.logicalTest((MidasReference)ref, test);
        }
        return Args.logicalTest(Convert.ref2Midas(ref), test);
    }

    public static boolean inLineTest(MidasReference ref, String test) {
        return Args.logicalTest(ref, test);
    }

    @Deprecated
    public static double[] inLineCalc(Object ref, String clac) {
        if (ref instanceof MidasReference) {
            return Convert.inLineCalc((MidasReference)ref, clac);
        }
        return Convert.inLineCalc(Convert.ref2Midas(ref), clac);
    }

    public static double[] inLineCalc(MidasReference ref, String clac) {
        Midas M = Convert.ref2Midas(ref);
        Parser p = new Parser(clac.substring(5, clac.length() - 1) + ",=InLineCalc", true);
        int narg = p.elements();
        ArgStack calc = new ArgStack(narg, narg, 'D', 1, 0);
        for (int i = 1; i <= narg; ++i) {
            calc.parseNext(p.get(i), M);
        }
        calc.parseDone();
        calc.process();
        return calc.result();
    }

    private static int s2d_r(byte[] buffer, int index, int size, double[] dval, Object ref) {
        Results rt = Convert.ref2Results(ref);
        int lr = Results.validNameLength(buffer, index, size);
        if (lr <= 0) {
            return 0;
        }
        String name = new String(buffer, index, lr);
        if (rt == null) {
            return Convert.s2d_i(dval, name, lr);
        }
        if (name.startsWith("TEST(")) {
            dval[0] = Convert.inLineTest(ref, name) ? 1.0 : 0.0;
        } else if (name.startsWith("CALC(")) {
            dval[0] = Convert.inLineCalc(ref, name)[0];
        } else {
            Object obj = rt.get(name);
            if (obj == null) {
                return Convert.s2d_i(dval, name, lr);
            }
            try {
                dval[0] = Convert.o2d(obj);
            }
            catch (Exception e) {
                return Convert.s2d_i(dval, name, lr);
            }
        }
        return lr;
    }

    private static int s2d_p(byte[] buffer, int index, int size, double[] dval, Object ref) {
        int i;
        int ip = 1;
        for (i = index + 1; ip > 0 && i < size; ++i) {
            if (buffer[i] == 41) {
                --ip;
            }
            if (buffer[i] != 40) continue;
            ++ip;
        }
        int x = Convert.s2d(buffer, index + 1, i - 1, dval, ref);
        return x == -1 ? x : i - index;
    }

    private static int s2d_s(byte[] buffer, int index, int size, double[] dval, Object ref) {
        Args args = Convert.ref2Args(ref);
        if (args == null) {
            return 0;
        }
        int switchLength = Results.validNameLength(buffer, index + 1, size) + 1;
        if (switchLength <= 0) {
            return 0;
        }
        String name = new String(buffer, index, switchLength);
        if (index == 0 && buffer.length > switchLength + 1 && buffer[switchLength] == 47) {
            return 0;
        }
        try {
            dval[0] = args.getD(name, -1.0);
        }
        catch (Exception e) {
            throw new MidasException("Error converting '" + name + "=" + args.getU(name) + "' to DOUBLE.", e);
        }
        return switchLength;
    }

    private static int s2BigDecimal_result(byte[] buffer, int index, int size, BigDecimalValue bdVal, Object ref) {
        Results rt = Convert.ref2Results(ref);
        int lr = Results.validNameLength(buffer, index, size);
        if (lr <= 0) {
            return 0;
        }
        String name = new String(buffer, index, lr);
        if (rt == null) {
            return -1;
        }
        if (name.startsWith("TEST(")) {
            bdVal.setValue(new BigDecimal(Convert.inLineTest(ref, name) ? 1 : 0));
        } else if (name.startsWith("CALC(")) {
            bdVal.setValue(new BigDecimal(Convert.inLineCalc(ref, name)[0]));
        } else {
            Object obj = rt.get(name);
            if (obj == null) {
                return -1;
            }
            try {
                bdVal.setValue(Convert.o2BigDecimal(obj));
            }
            catch (Exception e) {
                return -1;
            }
        }
        return lr;
    }

    private static int s2BigDecimal_paren(byte[] buffer, int index, int size, BigDecimalValue bdVal, Object ref) {
        int i;
        int ip = 1;
        for (i = index + 1; ip > 0 && i < size; ++i) {
            if (buffer[i] == 41) {
                --ip;
            }
            if (buffer[i] != 40) continue;
            ++ip;
        }
        int x = Convert.s2BigDecimal(buffer, index + 1, i - 1, bdVal, ref);
        return x == -1 ? x : i - index;
    }

    private static int s2BigDecimal_switch(byte[] buffer, int index, int size, BigDecimalValue bdVal, Object ref) {
        Args args = Convert.ref2Args(ref);
        if (args == null) {
            return 0;
        }
        int switchLength = Results.validNameLength(buffer, index + 1, size) + 1;
        if (switchLength <= 0) {
            return 0;
        }
        String name = new String(buffer, index, switchLength);
        if (index == 0 && buffer.length > switchLength + 1 && buffer[switchLength] == 47) {
            return 0;
        }
        try {
            bdVal.setValue(new BigDecimal(args.getD(name, -1.0)));
        }
        catch (Exception e) {
            throw new MidasException("Error converting '" + name + "=" + args.getU(name) + "' to DOUBLE.", e);
        }
        return switchLength;
    }

    public static String d2s(double dval) {
        return Convert.d2s(dval, 0, "VIS");
    }

    public static String l2s(int lval) {
        return "" + lval;
    }

    public static String l2x(int lval) {
        byte[] buf = new byte[4];
        Convert.packL(buf, 0, lval);
        return Convert.bb2hex(buf, 0, 4);
    }

    public static String d2s(double dval, int exp, String format) {
        if (format.equals("VIS")) {
            return Double.toString(dval);
        }
        if (exp == -1) {
            exp = Convert.d2s_exp(dval, dval);
        }
        if (exp != 0) {
            dval *= Math.pow(10.0, -exp);
        }
        int fb = format.indexOf(35);
        int fe = format.lastIndexOf(35);
        int fp = format.indexOf(46);
        int fsig = fe - fp;
        if (fp < 0) {
            fp = fe + 1;
            fsig = 0;
        }
        double round = Math.pow(10.0, -fsig) * 0.5;
        if (dval > 0.0) {
            dval += round;
        }
        if (dval < 0.0) {
            dval -= round;
        }
        String ts = nf.format(dval);
        int tp = ts.indexOf(46);
        char[] fs = format.toCharArray();
        for (int fi = 0; fi < fs.length; ++fi) {
            if (fs[fi] == '#') {
                int ti = fi - fp + tp;
                if (ti >= 0) {
                    fs[fi] = ts.charAt(ti);
                    continue;
                }
                fs[fi] = 32;
                continue;
            }
            if (fs[fi] != '?') continue;
            fs[fi] = Convert.d2s_expchar(exp);
        }
        return new String(fs);
    }

    public static char d2s_expchar(int exp) {
        char c;
        switch (exp) {
            case 0: {
                c = ' ';
                break;
            }
            case 3: {
                c = 'k';
                break;
            }
            case 6: {
                c = 'M';
                break;
            }
            case 9: {
                c = 'G';
                break;
            }
            case 12: {
                c = 'T';
                break;
            }
            case -2: {
                c = 'c';
                break;
            }
            case -3: {
                c = 'm';
                break;
            }
            case -6: {
                c = 'u';
                break;
            }
            case -9: {
                c = 'p';
                break;
            }
            default: {
                c = '?';
            }
        }
        return c;
    }

    public static int d2s_exp(double dmin, double dmax) {
        double absmax = Math.max(Math.abs(dmin), Math.abs(dmax));
        if (absmax == 0.0) {
            return 0;
        }
        int kengr = (int)(0.1447648 * Math.log(absmax) + 0.5);
        if (absmax < 1.0) {
            --kengr;
        }
        return kengr * 3;
    }

    public static boolean sameEndian(byte repa, byte repb) {
        if (repa == repb) {
            return true;
        }
        boolean biga = repa == 73;
        boolean bigb = repb == 73;
        return biga == bigb;
    }

    public static boolean isBigEndian(byte rep) {
        return rep == 73;
    }

    public static Results ref2Results(Object ref) {
        Results rt = null;
        if (ref instanceof Args) {
            rt = ((Args)ref).M.results;
        } else if (ref instanceof Midas) {
            rt = ((Midas)ref).results;
        } else if (ref instanceof Results) {
            rt = (Results)ref;
        } else if (ref instanceof Command) {
            rt = ((Command)ref).M.results;
        }
        return rt;
    }

    public static Midas ref2Midas(Object ref) {
        if (ref instanceof MidasReference) {
            return ((MidasReference)ref).getMidas();
        }
        return null;
    }

    public static Midas ref2Midas(MidasReference ref) {
        if (ref == null) {
            return Shell.getSharedMidasContext();
        }
        Midas midas = ref.getMidas();
        if (midas == null) {
            midas = Shell.getSharedMidasContext();
        }
        return midas;
    }

    @InternalUseOnly(value="Since added - should only be used by BaseFile and DataFile")
    public static MidasReference ref2MidasReference(Object ref) {
        if (ref instanceof MidasReference) {
            return (MidasReference)ref;
        }
        return null;
    }

    public static String ref2String(Object ref) {
        if (ref instanceof Command) {
            Command cmd = (Command)ref;
            String str = cmd.getID();
            if (str.length() == 0) {
                str = cmd.getName();
            }
            return str;
        }
        if (ref != null) {
            return ref.toString();
        }
        return null;
    }

    static Args ref2Args(Object ref) {
        if (ref instanceof Args) {
            return (Args)ref;
        }
        if (ref instanceof Command) {
            return ((Command)ref).args;
        }
        return null;
    }

    public static int rep(byte[] buf, int off, String form, int n, byte repa, byte repb) {
        if (form.equals("NH")) {
            throw new IllegalArgumentException("Can not convert rep for NH data.");
        }
        if (form.equals("KW")) {
            throw new IllegalArgumentException("Can not convert rep for KW data.");
        }
        byte type = (byte)form.charAt(1);
        int num = n * Data.getSPA(form.charAt(0));
        return Convert.rep(buf, off, type, num, repa, repb);
    }

    public static int rep(byte[] buf, int off, byte type, int n, byte repa, byte repb) {
        if (repa != repb) {
            block0 : switch (type) {
                case 66: {
                    break;
                }
                case 65: {
                    break;
                }
                case 90: {
                    break;
                }
                case 83: {
                    break;
                }
                case 74: {
                    if (repa == 73 == (repb == 73)) break;
                    Convert.swapJ(buf, off, n, repa, repb);
                    break;
                }
                case 73: {
                    if (repa == 73 == (repb == 73)) break;
                    Convert.swap2(buf, off, n);
                    break;
                }
                case 76: {
                    if (repa == 73 == (repb == 73)) break;
                    Convert.swap4(buf, off, n);
                    break;
                }
                case 88: {
                    if (repa == 73 == (repb == 73)) break;
                    Convert.swap8(buf, off, n);
                    break;
                }
                case 80: {
                    if (repa == 73 == (repb == 73)) break;
                    Convert.swap1(buf, off, n);
                    break;
                }
                case 70: {
                    block13 : switch (repa) {
                        case 86: {
                            switch (repb) {
                                case 69: {
                                    Convert.f_vax2eeei(buf, off, n);
                                    break;
                                }
                                case 73: {
                                    Convert.f_vax2ieee(buf, off, n);
                                }
                            }
                            break;
                        }
                        case 73: {
                            switch (repb) {
                                case 86: {
                                    Convert.f_ieee2vax(buf, off, n);
                                    break;
                                }
                                case 69: {
                                    Convert.swap4(buf, off, n);
                                }
                            }
                            break;
                        }
                        case 69: {
                            switch (repb) {
                                case 86: {
                                    Convert.f_eeei2vax(buf, off, n);
                                    break block13;
                                }
                                case 73: {
                                    Convert.swap4(buf, off, n);
                                }
                            }
                        }
                    }
                    break;
                }
                case 68: {
                    switch (repa) {
                        case 86: {
                            switch (repb) {
                                case 69: {
                                    Convert.d_vax2eeei(buf, off, n);
                                    break block0;
                                }
                                case 73: {
                                    Convert.d_vax2ieee(buf, off, n);
                                }
                            }
                            break block0;
                        }
                        case 73: {
                            switch (repb) {
                                case 86: {
                                    Convert.d_ieee2vax(buf, off, n);
                                    break block0;
                                }
                                case 69: {
                                    Convert.swap8(buf, off, n);
                                }
                            }
                            break block0;
                        }
                        case 69: {
                            switch (repb) {
                                case 86: {
                                    Convert.d_eeei2vax(buf, off, n);
                                    break block0;
                                }
                                case 73: {
                                    Convert.swap8(buf, off, n);
                                }
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    static int rep(long lbuf, int off, byte type, int n, byte repa, byte repb) {
        if (repa != repb) {
            Native.rep(lbuf, off, type, n, repa, repb);
        }
        return n;
    }

    static int rep(long lbuf, int off, byte type, int n, byte repa, byte repb, int nn, int inc) {
        if (repa != repb) {
            Native.repsoi(lbuf, off, type, n, repa, repb, nn, inc);
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int rep(byte[] buf, int off, byte type, int n, byte repa, byte repb, int nn, int inc) {
        if (repa == repb) return n;
        switch (type) {
            case 66: {
                return n;
            }
            case 65: {
                return n;
            }
            case 90: {
                return n;
            }
            case 83: {
                return n;
            }
            case 73: {
                if (repa == 73 == (repb == 73)) return n;
                while (--nn >= 0) {
                    Convert.swap2(buf, off, n);
                    off += inc;
                }
                return n;
            }
            case 76: {
                if (repa == 73 == (repb == 73)) return n;
                while (--nn >= 0) {
                    Convert.swap4(buf, off, n);
                    off += inc;
                }
                return n;
            }
            case 88: {
                if (repa == 73 == (repb == 73)) return n;
                while (--nn >= 0) {
                    Convert.swap8(buf, off, n);
                    off += inc;
                }
                return n;
            }
            case 80: {
                if (repa == 73 == (repb == 73)) return n;
                while (--nn >= 0) {
                    Convert.swap1(buf, off, n);
                    off += inc;
                }
                return n;
            }
            case 70: {
                switch (repa) {
                    case 86: {
                        switch (repb) {
                            case 69: {
                                while (--nn >= 0) {
                                    Convert.f_vax2eeei(buf, off, n);
                                    off += inc;
                                }
                                return n;
                            }
                            case 73: {
                                while (--nn >= 0) {
                                    Convert.f_vax2ieee(buf, off, n);
                                    off += inc;
                                }
                                return n;
                            }
                        }
                        return n;
                    }
                    case 73: {
                        switch (repb) {
                            case 86: {
                                while (--nn >= 0) {
                                    Convert.f_ieee2vax(buf, off, n);
                                    off += inc;
                                }
                                return n;
                            }
                            case 69: {
                                while (--nn >= 0) {
                                    Convert.swap4(buf, off, n);
                                    off += inc;
                                }
                                return n;
                            }
                        }
                        return n;
                    }
                    case 69: {
                        switch (repb) {
                            case 86: {
                                while (--nn >= 0) {
                                    Convert.f_eeei2vax(buf, off, n);
                                    off += inc;
                                }
                                break;
                            }
                            case 73: {
                                while (--nn >= 0) {
                                    Convert.swap4(buf, off, n);
                                    off += inc;
                                }
                                break block25;
                            }
                        }
                        return n;
                    }
                }
                return n;
            }
            case 68: {
                switch (repa) {
                    case 86: {
                        switch (repb) {
                            case 69: {
                                while (--nn >= 0) {
                                    Convert.d_vax2eeei(buf, off, n);
                                    off += inc;
                                }
                                return n;
                            }
                            case 73: {
                                while (--nn >= 0) {
                                    Convert.d_vax2ieee(buf, off, n);
                                    off += inc;
                                }
                                return n;
                            }
                        }
                        return n;
                    }
                    case 73: {
                        switch (repb) {
                            case 86: {
                                while (--nn >= 0) {
                                    Convert.d_ieee2vax(buf, off, n);
                                    off += inc;
                                }
                                return n;
                            }
                            case 69: {
                                while (--nn >= 0) {
                                    Convert.swap8(buf, off, n);
                                    off += inc;
                                }
                                return n;
                            }
                        }
                        return n;
                    }
                    case 69: {
                        switch (repb) {
                            case 86: {
                                while (--nn >= 0) {
                                    Convert.d_eeei2vax(buf, off, n);
                                    off += inc;
                                }
                                return n;
                            }
                            case 73: {
                                while (--nn >= 0) {
                                    Convert.swap8(buf, off, n);
                                    off += inc;
                                }
                                return n;
                            }
                        }
                    }
                }
                return n;
            }
        }
        return n;
    }

    public static void bitrev(byte[] buf, int n) {
        for (int i = 0; i < n; ++i) {
            buf[i] = bitrev[buf[i] & 0xFF];
        }
    }

    public static void bitrev(int[] buf, int n) {
        for (int i = 0; i < n; ++i) {
            buf[i] = Convert.bitrev(buf[i]);
        }
    }

    public static int bitrev(int a) {
        int b = (bitrev[a >> 0 & 0xFF] & 0xFF) << 24 | (bitrev[a >> 8 & 0xFF] & 0xFF) << 16 | (bitrev[a >> 16 & 0xFF] & 0xFF) << 8 | (bitrev[a >> 24 & 0xFF] & 0xFF) << 0;
        return b;
    }

    private static byte[] genbitrev() {
        byte[] buf = new byte[256];
        for (int i = 0; i < 256; ++i) {
            int j = (i & 1) << 7 | (i & 2) << 5 | (i & 4) << 3 | (i & 8) << 1 | (i & 0x10) >> 1 | (i & 0x20) >> 3 | (i & 0x40) >> 5 | (i & 0x80) >> 7;
            buf[i] = (byte)(j & 0xFF);
        }
        return buf;
    }

    private static short[] genulaw() {
        short[] table = new short[256];
        for (int i = 0; i < 256; ++i) {
            int j = i - 128;
            int x = j ^ 0x7F;
            int S = 1 - 2 * ((x & 0x80) / 128);
            int L = (x & 0x70) / 16;
            int V = x & 0xF;
            table[i] = (short)Math.round((double)S * (Math.pow(2.0, L) * (double)(2 * V + 33) - 33.0) * 32767.0 / 8031.0);
        }
        return table;
    }

    public static void swap1(byte[] buf, int off, int n) {
        int i = 0;
        while (i < n >> 3) {
            buf[off] = bitrev[buf[off] & 0xFF];
            ++i;
            ++off;
        }
    }

    public static void swap2(byte[] buf, int off, int n) {
        for (int i = 0; i < n; ++i) {
            byte b = buf[off];
            buf[off++] = buf[off];
            buf[off++] = b;
        }
    }

    public static void swap4(byte[] buf, int off, int n) {
        int i = 0;
        while (i < n) {
            byte b = buf[off + 0];
            buf[off + 0] = buf[off + 3];
            buf[off + 3] = b;
            b = buf[off + 1];
            buf[off + 1] = buf[off + 2];
            buf[off + 2] = b;
            ++i;
            off += 4;
        }
    }

    public static void swap8(byte[] buf, int off, int n) {
        int i = 0;
        while (i < n) {
            byte b = buf[off + 0];
            buf[off + 0] = buf[off + 7];
            buf[off + 7] = b;
            b = buf[off + 1];
            buf[off + 1] = buf[off + 6];
            buf[off + 6] = b;
            b = buf[off + 2];
            buf[off + 2] = buf[off + 5];
            buf[off + 5] = b;
            b = buf[off + 3];
            buf[off + 3] = buf[off + 4];
            buf[off + 4] = b;
            ++i;
            off += 8;
        }
    }

    public static void swapJ(byte[] buf, int off, int n, byte repa, byte repb) {
        byte b;
        int i;
        int m = n / 2 * 3;
        if (repa == 73 && repb != 73) {
            for (i = off; i < off + m; i += 3) {
                b = buf[i + 1];
                buf[i + 1] = (byte)(buf[i + 2] << 4 | buf[i] >> 4 & 0xF);
                buf[i + 2] = (byte)(b << 4 | buf[i + 2] >> 4 & 0xF);
                buf[i] = (byte)(buf[i] << 4 | b >> 4 & 0xF);
            }
        }
        if (repa != 73 && repb == 73) {
            for (i = off; i < off + m; i += 3) {
                b = buf[i + 1];
                buf[i + 1] = (byte)(buf[i] << 4 | buf[i + 2] >> 4 & 0xF);
                buf[i] = (byte)(b << 4 | buf[i] >> 4 & 0xF);
                buf[i + 2] = (byte)(buf[i + 2] << 4 | b >> 4 & 0xF);
            }
        }
    }

    public static void f_vax2ieee(byte[] buf, int off, int n) {
        int i = 0;
        while (i < n) {
            byte b0 = buf[off + 0];
            byte b1 = buf[off + 1];
            byte b2 = buf[off + 2];
            byte b3 = buf[off + 3];
            if (b0 != 0 || b1 != 0 || b2 != 0 || b3 != 0) {
                b1 = (byte)(b1 - 1);
            }
            buf[off + 3] = b2;
            buf[off + 2] = b3;
            buf[off + 1] = b0;
            buf[off + 0] = b1;
            ++i;
            off += 4;
        }
    }

    public static void f_vax2eeei(byte[] buf, int off, int n) {
        int i = 0;
        while (i < n) {
            byte b0 = buf[off + 0];
            byte b1 = buf[off + 1];
            byte b2 = buf[off + 2];
            byte b3 = buf[off + 3];
            if (b0 != 0 || b1 != 0 || b2 != 0 || b3 != 0) {
                b1 = (byte)(b1 - 1);
            }
            buf[off + 0] = b2;
            buf[off + 1] = b3;
            buf[off + 2] = b0;
            buf[off + 3] = b1;
            ++i;
            off += 4;
        }
    }

    public static void f_ieee2vax(byte[] buf, int off, int n) {
        int i = 0;
        while (i < n) {
            byte b2 = buf[off + 3];
            byte b3 = buf[off + 2];
            byte b0 = buf[off + 1];
            byte b1 = buf[off];
            if (b0 != 0 || b1 != 0 || b2 != 0 || b3 != 0) {
                b1 = (byte)(b1 + 1);
            }
            buf[off] = b0;
            buf[off + 1] = b1;
            buf[off + 2] = b2;
            buf[off + 3] = b3;
            ++i;
            off += 4;
        }
    }

    public static void f_eeei2vax(byte[] buf, int off, int n) {
        int i = 0;
        while (i < n) {
            byte b2 = buf[off];
            byte b3 = buf[off + 1];
            byte b0 = buf[off + 2];
            byte b1 = buf[off + 3];
            if (b0 != 0 || b1 != 0 || b2 != 0 || b3 != 0) {
                b1 = (byte)(b1 + 1);
            }
            buf[off] = b0;
            buf[off + 1] = b1;
            buf[off + 2] = b2;
            buf[off + 3] = b3;
            ++i;
            off += 4;
        }
    }

    public static void d_vax2ieee(byte[] buf, int off, int n) {
        int bias = 937426944;
        int i = 0;
        while (i < n) {
            int i0 = (buf[off + 6] & 0xFF) << 0;
            i0 |= (buf[off + 7] & 0xFF) << 8;
            i0 |= (buf[off + 4] & 0xFF) << 16;
            int i1 = (buf[off + 2] & 0xFF) << 0;
            i1 |= (buf[off + 3] & 0xFF) << 8;
            i1 |= (buf[off + 0] & 0xFF) << 16;
            if ((i0 |= (buf[off + 5] & 0xFF) << 24) != 0 || (i1 |= (buf[off + 1] & 0x7F) << 24) != 0) {
                i0 = i0 >> 3 & 0x1FFFFFFF | i1 << 29;
                i1 = (i1 >> 3) + bias;
                if (buf[off + 1] < 0) {
                    i1 |= Integer.MIN_VALUE;
                }
            }
            buf[off + 7] = (byte)(i0 & 0xFF);
            buf[off + 6] = (byte)(i0 >> 8 & 0xFF);
            buf[off + 5] = (byte)(i0 >> 16 & 0xFF);
            buf[off + 4] = (byte)(i0 >> 24 & 0xFF);
            buf[off + 3] = (byte)(i1 & 0xFF);
            buf[off + 2] = (byte)(i1 >> 8 & 0xFF);
            buf[off + 1] = (byte)(i1 >> 16 & 0xFF);
            buf[off + 0] = (byte)(i1 >> 24 & 0xFF);
            ++i;
            off += 8;
        }
    }

    public static void d_vax2eeei(byte[] buf, int off, int n) {
        int bias = 937426944;
        int i = 0;
        while (i < n) {
            int i0 = (buf[off + 6] & 0xFF) << 0;
            i0 |= (buf[off + 7] & 0xFF) << 8;
            i0 |= (buf[off + 4] & 0xFF) << 16;
            int i1 = (buf[off + 2] & 0xFF) << 0;
            i1 |= (buf[off + 3] & 0xFF) << 8;
            i1 |= (buf[off + 0] & 0xFF) << 16;
            if ((i0 |= (buf[off + 5] & 0xFF) << 24) != 0 || (i1 |= (buf[off + 1] & 0x7F) << 24) != 0) {
                i0 = i0 >> 3 & 0x1FFFFFFF | i1 << 29;
                i1 = (i1 >> 3) + bias;
                if (buf[off + 1] < 0) {
                    i1 |= Integer.MIN_VALUE;
                }
            }
            buf[off + 0] = (byte)(i0 & 0xFF);
            buf[off + 1] = (byte)(i0 >> 8 & 0xFF);
            buf[off + 2] = (byte)(i0 >> 16 & 0xFF);
            buf[off + 3] = (byte)(i0 >> 24 & 0xFF);
            buf[off + 4] = (byte)(i1 & 0xFF);
            buf[off + 5] = (byte)(i1 >> 8 & 0xFF);
            buf[off + 6] = (byte)(i1 >> 16 & 0xFF);
            buf[off + 7] = (byte)(i1 >> 24 & 0xFF);
            ++i;
            off += 8;
        }
    }

    public static void d_ieee2vax(byte[] buf, int off, int n) {
        int bias = 937426944;
        int i = 0;
        while (i < n) {
            int i0 = (buf[off + 7] & 0xFF) << 0;
            i0 |= (buf[off + 6] & 0xFF) << 8;
            i0 |= (buf[off + 5] & 0xFF) << 16;
            int i1 = (buf[off + 3] & 0xFF) << 0;
            i1 |= (buf[off + 2] & 0xFF) << 8;
            i1 |= (buf[off + 1] & 0xFF) << 16;
            if ((i0 |= (buf[off + 4] & 0xFF) << 24) != 0 || (i1 |= (buf[off] & 0x7F) << 24) != 0) {
                i1 = i1 - bias << 3 | i0 >>> 29;
                if (buf[off] < 0) {
                    i1 |= Integer.MIN_VALUE;
                }
                i0 <<= 3;
            }
            buf[off] = (byte)(i1 >> 16 & 0xFF);
            buf[off + 1] = (byte)(i1 >> 24 & 0xFF);
            buf[off + 2] = (byte)(i1 & 0xFF);
            buf[off + 3] = (byte)(i1 >> 8 & 0xFF);
            buf[off + 4] = (byte)(i0 >> 16 & 0xFF);
            buf[off + 5] = (byte)(i0 >> 24 & 0xFF);
            buf[off + 6] = (byte)(i0 & 0xFF);
            buf[off + 7] = (byte)(i0 >> 8 & 0xFF);
            ++i;
            off += 8;
        }
    }

    public static void d_eeei2vax(byte[] buf, int off, int n) {
        int bias = 937426944;
        int i = 0;
        while (i < n) {
            int i0 = (buf[off] & 0xFF) << 0;
            i0 |= (buf[off + 1] & 0xFF) << 8;
            i0 |= (buf[off + 2] & 0xFF) << 16;
            int i1 = (buf[off + 4] & 0xFF) << 0;
            i1 |= (buf[off + 5] & 0xFF) << 8;
            i1 |= (buf[off + 6] & 0xFF) << 16;
            if ((i0 |= (buf[off + 3] & 0xFF) << 24) != 0 || (i1 |= (buf[off + 7] & 0x7F) << 24) != 0) {
                i1 = i1 - bias << 3 | i0 >>> 29;
                if (buf[off + 7] < 0) {
                    i1 |= Integer.MIN_VALUE;
                }
                i0 <<= 3;
            }
            buf[off] = (byte)(i1 >> 16 & 0xFF);
            buf[off + 1] = (byte)(i1 >> 24 & 0xFF);
            buf[off + 2] = (byte)(i1 & 0xFF);
            buf[off + 3] = (byte)(i1 >> 8 & 0xFF);
            buf[off + 4] = (byte)(i0 >> 16 & 0xFF);
            buf[off + 5] = (byte)(i0 >> 24 & 0xFF);
            buf[off + 6] = (byte)(i0 & 0xFF);
            buf[off + 7] = (byte)(i0 >> 8 & 0xFF);
            ++i;
            off += 8;
        }
    }

    public static Object o2o(Object obj, Object ref) {
        return Convert.o2o(obj, "_", ref);
    }

    public static Object o2o(Object obj, char newType, Object ref) {
        return Convert.o2o(obj, Character.toString(newType), ref);
    }

    public static Object s2o(String string, String format, Object ref) {
        if (string == null) {
            return null;
        }
        String newFormat = Convert.getNewFormat(format);
        int newSize = -1;
        int newSPA = -1;
        char newMode = newFormat.charAt(0);
        char newType = newFormat.charAt(1);
        if (newMode != ' ') {
            newSPA = Data.getSPA(newMode);
        }
        if (!Convert.validType(newType)) {
            throw new MidasException("Invalid conversion type '" + newType + "' in format string '" + format.toUpperCase() + "'.");
        }
        return Convert.s2o(string, format.toUpperCase(), newSize, newSPA, newMode, newType, false, ref);
    }

    public static Object o2o(Object obj, String format, Object ref) {
        if (obj == null) {
            return null;
        }
        String newFormat = Convert.getNewFormat(format);
        int newSize = -1;
        int newSPA = -1;
        char newMode = newFormat.charAt(0);
        char newType = newFormat.charAt(1);
        if (newMode != ' ') {
            newSPA = Data.getSPA(newMode);
        }
        if (!Convert.validType(newType)) {
            throw new MidasException("Invalid conversion type '" + newType + "' in format string '" + format.toUpperCase() + "'.");
        }
        return Convert.o2o(obj, format.toUpperCase(), newSize, newSPA, newMode, newType, false, ref);
    }

    @InternalUseOnly
    public static Data o2Data(Object obj, char newType, Object ref) {
        return Convert.o2Data(obj, Character.toString(newType), ref);
    }

    @InternalUseOnly
    public static Data o2Data(Object obj, String format, Object ref) {
        if (obj == null) {
            return null;
        }
        String newFormat = Convert.getNewFormat(format);
        int newSize = -1;
        int newSPA = -1;
        char newMode = newFormat.charAt(0);
        char newType = newFormat.charAt(1);
        if (newMode != ' ') {
            newSPA = Data.getSPA(newMode);
        }
        if ("DFXLIJBNPA,Z".indexOf(newType) == -1) {
            throw new MidasException("Invalid conversion type '" + newType + "' in format string '" + format.toUpperCase() + "'.");
        }
        Object dataObj = Convert.o2o(obj, format.toUpperCase(), newSize, newSPA, newMode, newType, true, ref);
        if (!(dataObj instanceof Data)) {
            throw new MidasException("Convert: Unable to convert '" + obj + "' to Data object with " + format + ".");
        }
        return (Data)dataObj;
    }

    private static String getNewFormat(String format) {
        String form = format.toUpperCase();
        char newMode = ' ';
        char newType = '_';
        int len = form.length();
        if (len >= 2 && form.charAt(len - 1) == ':') {
            --len;
        }
        if (len == 0) {
            newType = '_';
            newMode = ' ';
        } else if (len == 1) {
            newType = form.charAt(0);
            newMode = ' ';
        } else if (len == 2) {
            newType = form.charAt(1);
            newMode = form.charAt(0);
        } else {
            throw new IllegalArgumentException("Illegal format string '" + form + "'.");
        }
        return "" + newMode + newType;
    }

    private static Object o2o(Object obj, String form, int newSize, int newSPA, char newMode, char newType, boolean isData, Object ref) {
        if (obj == null) {
            return null;
        }
        Data data = null;
        String str = null;
        boolean single = newSize == -1 || newSize == 1;
        boolean scalar = newSPA == -1 || newSPA == 1;
        boolean ncv = Convert.isNumericConversion(newType);
        boolean xmv = Convert.isXMValueConversion(newType);
        if (newType == '_') {
            newType = Convert.guessType(obj, '_', '_');
        }
        if (single && scalar) {
            if (newType == 'T') {
                obj = obj instanceof String && Time.isSTDTimeString((String)obj) ? new Time((String)obj) : Convert.o2t(obj, ref);
            } else if (obj instanceof String) {
                str = (String)obj;
                String trimmed = str.trim();
                if (trimmed.startsWith("{") && trimmed.endsWith("}")) {
                    str = null;
                    obj = Convert.o2t(obj, ref);
                }
            } else if (newType == 'S') {
                obj = obj.toString();
            } else if (newType == 'U') {
                obj = obj.toString();
            } else if (newType == 'A') {
                obj = obj.toString();
            } else if (isData && newType == 'Z') {
                obj = obj.toString();
            } else if (newType == 'Z') {
                obj = Convert.o2z(obj, ref);
            } else if (obj instanceof Data) {
                data = (Data)obj;
            } else if (newType == 'D') {
                data = new Data(Convert.o2d(obj));
            } else if (newType == 'F') {
                data = new Data(Convert.o2f(obj));
            } else if (newType == 'X') {
                data = new Data(Convert.o2x(obj));
            } else if (newType == 'L') {
                data = new Data(Convert.o2l(obj));
            } else if (newType == 'I') {
                data = new Data(Convert.o2i(obj));
            } else if (newType == 'B') {
                data = new Data(Convert.o2b(obj));
            } else if (xmv) {
                obj = XMValue.toXMValue(obj, newMode, newType, ref);
            } else {
                Shell.warning("Convert.o2o: unable to convert " + obj + " to '" + form + "'");
            }
        } else if (obj instanceof String) {
            str = (String)obj;
        } else if (obj instanceof Data) {
            data = (Data)obj;
        } else if (ncv) {
            data = new Data(Convert.o2da(obj));
        } else {
            throw new MidasException("Convert.o2o: unable to convert " + obj + " to '" + form + "'");
        }
        if (str != null) {
            obj = Convert.s2o(str, form, newSize, newSPA, newMode, newType, isData, ref);
        }
        if (data != null) {
            obj = data.convertTo(newSize, newSPA, newMode, newType);
        }
        return obj;
    }

    public static Object s2o(String string, Object ref) {
        return Convert.s2o(string, "_", ref);
    }

    public static Object s2o(String string, char newType, Object ref) {
        return Convert.s2o(string, Character.toString(newType), ref);
    }

    private static Object s2o(String string, String form, int newSize, int newSPA, char newMode, char newType, boolean isData, Object ref) {
        int size;
        Long xlResult;
        int vnl;
        long[] xlval;
        double[] dval;
        Object obj = null;
        int ndef = 0;
        double[] dvals = dval = new double[1];
        long[] xlvals = xlval = new long[1];
        int type = 83;
        boolean ncv = Convert.isNumericConversion(newType);
        boolean xmv = Convert.isXMValueConversion(newType);
        if (string == null) {
            return null;
        }
        int length = string.length();
        if (length > 1 && string.charAt(0) == '/' && ref instanceof Args) {
            vnl = Results.validNameLength(string, null, 1, length);
            if (vnl == length - 1) {
                string = ((Args)ref).getRaw(string);
            }
            if (string == null) {
                string = "NULL";
            }
            if ((length = string.length()) == 0) {
                ndef = 1;
            }
        }
        if (length == 0) {
            if (ncv) {
                return new Data(ndef).convertTo(newSize, newSPA, newMode, newType);
            }
            return Convert.toStringObj("", form, newSize, newSPA, newMode, newType, isData);
        }
        if (length == 4 && string.equals("NULL")) {
            if (ncv) {
                return new Data(-1).convertTo(newSize, newSPA, newMode, newType);
            }
            return Convert.toStringObj("", form, newSize, newSPA, newMode, newType, isData);
        }
        if (string.charAt(0) == '\"') {
            if (newType == 'Q') {
                return string;
            }
            if (ncv) {
                throw new MidasException("Unable to convert " + string + " to type " + newType + " given value is a quoted string.");
            }
            if (string.charAt(length - 1) == '\"') {
                --length;
            }
            return Convert.toStringObj(string.substring(1, length), form, newSize, newSPA, newMode, newType, isData);
        }
        if (newType == 'U') {
            return string;
        }
        obj = null;
        Results rt = Convert.ref2Results(ref);
        if (rt != null && (vnl = Results.validNameLength(string, null, 0, length)) == length && !string.startsWith("TEST(")) {
            obj = rt.get(string.toUpperCase());
        }
        if (obj != null) {
            if (ncv && obj instanceof Boolean) {
                obj = (Boolean)obj != false ? 1 : 0;
            }
            if (newType == '_') {
                return obj;
            }
            if (newType == 'O') {
                return obj;
            }
            if (newType == 'S') {
                if (obj instanceof String) {
                    return obj;
                }
            } else if (newType == 'T') {
                if (obj instanceof Tablizable) {
                    return Convert.o2t(obj);
                }
            } else if (newType == 'K') {
                if (obj instanceof KeyVector) {
                    return obj;
                }
            } else {
                if (!isData && newType == 'Z') {
                    return Convert.o2z(obj);
                }
                if (xmv) {
                    return XMValue.toXMValue(obj, newMode, newType, ref);
                }
                if (obj instanceof Data) {
                    return ((Data)obj).convertTo(newSize, newSPA, newMode, newType);
                }
                if (obj instanceof Double) {
                    return new Data(obj).convertTo(newSize, newSPA, newMode, newType);
                }
                if (obj instanceof Float) {
                    return new Data(obj).convertTo(newSize, newSPA, newMode, newType);
                }
                if (obj instanceof Long) {
                    return new Data(obj).convertTo(newSize, newSPA, newMode, newType);
                }
                if (obj instanceof Integer) {
                    return new Data(obj).convertTo(newSize, newSPA, newMode, newType);
                }
                if (obj instanceof Short) {
                    return new Data(obj).convertTo(newSize, newSPA, newMode, newType);
                }
                if (obj instanceof Byte) {
                    return new Data(obj).convertTo(newSize, newSPA, newMode, newType);
                }
                if (obj instanceof XMValue) {
                    return ((XMValue)obj).convertTo(newSize, newSPA, newMode, newType);
                }
            }
        }
        if (newType == 'S' || newType == 'A' || isData && newType == 'Z') {
            return Convert.toStringObj(string, form, newSize, newSPA, newMode, newType, isData);
        }
        if (newType == 'T') {
            if (Time.isSTDTimeString(string)) {
                return new Time(string);
            }
            return Convert.o2t(string, ref);
        }
        if (newType == 'O') {
            return Convert.o2t(string, ref).getCore();
        }
        if (newType == 'K') {
            return KeyVector.fromString(string);
        }
        if (newType == 'Z') {
            return Convert.o2z(string, ref);
        }
        if (xmv) {
            return XMValue.toXMValue(string, newMode, newType, ref);
        }
        byte[] buf = string.getBytes();
        if (buf[0] == 123 && buf[length - 1] == 125 && (obj = new Table(buf)) != null) {
            return obj;
        }
        if (newType == 'X' && (xlResult = Convert.s2xl(buf, 0, length, ref)) != null) {
            xlvals[0] = xlResult;
            type = 88;
            size = 1;
        } else if (Convert.s2d(buf, 0, length, dval, ref) > 0) {
            type = 68;
            size = 1;
            if (dval[0] == Math.floor(dval[0]) && dval[0] >= -2.147483648E9 && dval[0] <= 2.147483647E9) {
                type = 76;
                int ip = string.indexOf(46);
                if (ip >= 0 && (ip == 0 || Character.isDigit(string.charAt(ip - 1))) && (ip == length - 1 || Character.isDigit(string.charAt(ip + 1)))) {
                    type = 68;
                }
            }
        } else if (buf[0] == 40 && buf[length - 1] == 41) {
            int j;
            int i;
            int k;
            boolean isXLongArray = false;
            size = 0;
            if (newType == 'X') {
                k = 1;
                for (i = 1; i < length - 1; ++i) {
                    if (buf[i] != 44) continue;
                    ++k;
                }
                xlvals = new long[k];
                j = 1;
                k = 0;
                for (i = 1; i < length; ++i) {
                    if (buf[i] != 44 && i != length - 1) continue;
                    xlResult = Convert.s2xl(buf, j, i, ref);
                    if (xlResult != null) {
                        xlvals[k++] = xlResult;
                        j = i + 1;
                        isXLongArray = true;
                        continue;
                    }
                    isXLongArray = false;
                    break;
                }
                type = 88;
                size = k;
            }
            if (!isXLongArray) {
                k = 1;
                for (i = 1; i < length - 1; ++i) {
                    if (buf[i] != 44) continue;
                    ++k;
                }
                dvals = new double[k];
                j = 1;
                k = 0;
                for (i = 1; i < length; ++i) {
                    if (buf[i] != 44 && i != length - 1) continue;
                    if (Convert.s2d(buf, j, i, dval, ref) < 0) {
                        return string;
                    }
                    dvals[k++] = dval[0];
                    j = i + 1;
                }
                type = 68;
                size = k;
            }
        } else {
            size = 0;
        }
        if (type == 68 || type == 76) {
            Data data = new Data();
            if (ncv) {
                type = (byte)newType;
            }
            data.setFormatType((byte)type);
            data.setSize(size);
            data.fromArray(dvals);
            if (size > 0 && size <= 4) {
                data.resetMode();
            }
            data = data.convertTo(newSize, newSPA, newMode, newType);
            return data;
        }
        if (type == 88) {
            Data data = new Data();
            if (ncv) {
                type = (byte)newType;
            }
            data.setFormatType((byte)type);
            data.setSize(size);
            data.fromArray(xlvals);
            if (size > 0 && size <= 4) {
                data.resetMode();
            }
            data = data.convertTo(newSize, newSPA, newMode, newType);
            return data;
        }
        if (ncv) {
            throw new MidasException("Unable to convert \"" + string + "\" to type " + newType + ". No applicable conversion found. " + form);
        }
        return string;
    }

    private static Long s2xl(byte[] buffer, int index1, int index2, Object ref) {
        BigDecimalValue bdVal = new BigDecimalValue();
        Long xlResult = null;
        try {
            if (Convert.s2BigDecimal(buffer, index1, index2, bdVal, ref) >= 0) {
                BigDecimal rounded = bdVal.getValue().setScale(0, RoundingMode.FLOOR);
                xlResult = rounded.longValueExact();
            }
        }
        catch (Exception e) {
            xlResult = null;
        }
        return xlResult;
    }

    private static Object toStringObj(String string, String form, int newSize, int newSPA, char newMode, char newType, boolean isData) {
        Object obj = newType == 'A' || isData && newType == 'Z' ? (newSPA == -1 ? new Data(string, newType == 'Z') : new Data(string, newSPA)) : (newSPA == -1 ? string : (string.length() > newSPA ? string.substring(0, newSPA) : (string.length() < newSPA ? StringUtil.padRight(string, newSPA, ' ') : string)));
        return obj;
    }

    public static char guessType(Object obj, char str, char def) {
        if (obj == null) {
            return def;
        }
        if (obj instanceof String) {
            return str;
        }
        if (obj instanceof Data) {
            return (char)((Data)obj).getFormatType();
        }
        if (obj instanceof XMValue) {
            return ((XMValue)obj).getFormatType();
        }
        if (obj instanceof Table) {
            return 'T';
        }
        if (obj instanceof Time) {
            return 'D';
        }
        if (obj instanceof Double) {
            return 'D';
        }
        if (obj instanceof Float) {
            return 'F';
        }
        if (obj instanceof Long) {
            return 'X';
        }
        if (obj instanceof Integer) {
            return 'L';
        }
        if (obj instanceof Short) {
            return 'I';
        }
        if (obj instanceof Byte) {
            return 'B';
        }
        if (obj instanceof Boolean) {
            return 'Z';
        }
        if (obj instanceof Character) {
            return 'S';
        }
        if (obj instanceof Number) {
            return 'D';
        }
        if (obj instanceof Tablizable) {
            return 'T';
        }
        return def;
    }

    private static boolean isXMValueConversion(char conversion) {
        switch (conversion) {
            case 'V': {
                return true;
            }
            case 'C': {
                return true;
            }
            case 'K': {
                return true;
            }
            case 'H': {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumericConversion(char conversion) {
        return "DFXLIJBNP".indexOf(conversion) >= 0;
    }

    public static Object d2o(double value) {
        return new Data(value);
    }

    public static Object f2o(float value) {
        return new Data(value);
    }

    public static Object x2o(long value) {
        return new Data(value);
    }

    public static Object l2o(int value) {
        return new Data(value);
    }

    public static Object i2o(short value) {
        return new Data(value);
    }

    public static Object b2o(byte value) {
        return new Data(value);
    }

    public static String o2s(Object obj, Object ref) {
        Results rt;
        Object robj;
        if (ref != null && obj instanceof String && (robj = (rt = Convert.ref2Results(ref)).get((String)obj)) instanceof String) {
            return (String)robj;
        }
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    public static double o2d(Object obj, Object ref) {
        if (obj instanceof String) {
            return Convert.s2d((String)obj, ref);
        }
        return Convert.o2d(obj);
    }

    public static float o2f(Object obj, Object ref) {
        return (float)Convert.o2d(obj, ref);
    }

    public static long o2x(Object obj, Object ref) {
        long xlResult;
        if (obj instanceof Data) {
            return ((Data)obj).toX();
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        try {
            BigDecimal rounded = Convert.o2BigDecimal(obj).setScale(0, RoundingMode.HALF_EVEN);
            xlResult = rounded.longValueExact();
        }
        catch (Exception e) {
            xlResult = (long)Math.rint(Convert.o2d(obj, ref));
        }
        return xlResult;
    }

    public static int o2l(Object obj, Object ref) {
        if (!favorJavaBehavior) {
            double objAsRintDouble = Math.rint(Convert.o2d(obj, ref));
            return (int)objAsRintDouble;
        }
        return Convert.o2lJava(obj, null);
    }

    public static short o2i(Object obj, Object ref) {
        return (short)Convert.o2l(obj, ref);
    }

    public static byte o2b(Object obj, Object ref) {
        return (byte)Convert.o2l(obj, ref);
    }

    public static String o2s(Object obj, Object ref, String def) {
        String s = Convert.o2s(obj, ref);
        if (s == null) {
            s = def;
        }
        return s;
    }

    public static double o2d(Object obj, Object ref, double def) {
        if (obj == null) {
            return def;
        }
        return Convert.o2d(obj, ref);
    }

    public static int o2l(Object obj, Object ref, int def) {
        if (obj == null) {
            return def;
        }
        return Convert.o2l(obj, ref);
    }

    public static String o2s(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    public static double o2d(Object obj) {
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Data) {
            return ((Data)obj).toD();
        }
        if (obj instanceof String) {
            return Convert.s2d((String)obj);
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof Time) {
            return ((Time)obj).getSec();
        }
        if (obj instanceof XMValue) {
            return ((XMValue)obj).toD();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1.0 : 0.0;
        }
        throw new IllegalArgumentException("Unconvertable type [" + obj + "] to double");
    }

    public static List<?> o2List(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof List) {
            return (List)val;
        }
        if (val instanceof Data) {
            return ((Data)val).toVector();
        }
        if (val instanceof Object[]) {
            return Arrays.asList((Object[])val);
        }
        throw new MidasException("Convert.o2List() could not convert " + val.getClass() + " value = " + val.toString());
    }

    public static BigDecimal o2BigDecimal(Object obj) {
        return (BigDecimal)Convert.o2n(obj, null, BigDecimal.ZERO, true, false);
    }

    public static Number o2n(Object obj) {
        return Convert.o2n(obj, null, null, false, true);
    }

    public static Number o2n(Object obj, Object ref, Number def, boolean asBigDecimal, boolean noAbort) {
        if (obj == null) {
            return def;
        }
        try {
            String str;
            if (obj instanceof Instant) {
                obj = Time.toTime(obj);
            }
            if (obj instanceof Calendar) {
                obj = Time.toTime(obj);
            }
            if (obj instanceof XMLGregorianCalendar) {
                obj = Time.toTime(obj);
            }
            if (obj instanceof Date) {
                obj = Time.toTime(obj);
            }
            if (obj instanceof Time) {
                obj = ((Time)obj).toNumber();
            }
            if (obj instanceof Data) {
                obj = ((Data)obj).toNumber();
            }
            if (obj instanceof XMValue) {
                obj = ((XMValue)obj).toNumber();
            }
            if (obj instanceof Boolean) {
                obj = (Boolean)obj != false ? 1 : 0;
            }
            if (asBigDecimal) {
                if (obj instanceof Byte) {
                    return BigDecimal.valueOf(((Byte)obj).byteValue());
                }
                if (obj instanceof Short) {
                    return BigDecimal.valueOf(((Short)obj).shortValue());
                }
                if (obj instanceof Integer) {
                    return BigDecimal.valueOf(((Integer)obj).intValue());
                }
                if (obj instanceof BigDecimal) {
                    return (Number)obj;
                }
                if (obj instanceof BigInteger) {
                    return new BigDecimal((BigInteger)obj);
                }
                if (obj instanceof Number) {
                    return new BigDecimal(((Number)obj).toString());
                }
            } else if (obj instanceof Number) {
                if (alwaysDefaultToDouble) {
                    return ((Number)obj).doubleValue();
                }
                return (Number)obj;
            }
            boolean objOriginallyString = obj instanceof String;
            switch (str = obj.toString().trim()) {
                case "-1": {
                    return asBigDecimal ? BigDecimal_NEG1 : Integer.valueOf(-1);
                }
                case "0": {
                    return asBigDecimal ? BigDecimal.ZERO : Integer.valueOf(0);
                }
                case "1": {
                    return asBigDecimal ? BigDecimal.ONE : Integer.valueOf(1);
                }
                case "2": {
                    return asBigDecimal ? BigDecimal_TWO : Integer.valueOf(2);
                }
                case "3": {
                    return asBigDecimal ? BigDecimal_THREE : Integer.valueOf(3);
                }
                case "4": {
                    return asBigDecimal ? BigDecimal_FOUR : Integer.valueOf(4);
                }
                case "5": {
                    return asBigDecimal ? BigDecimal_FIVE : Integer.valueOf(5);
                }
                case "6": {
                    return asBigDecimal ? BigDecimal_SIX : Integer.valueOf(6);
                }
                case "7": {
                    return asBigDecimal ? BigDecimal_SEVEN : Integer.valueOf(7);
                }
                case "8": {
                    return asBigDecimal ? BigDecimal_EIGHT : Integer.valueOf(8);
                }
                case "9": {
                    return asBigDecimal ? BigDecimal_NINE : Integer.valueOf(9);
                }
                case "10": {
                    return asBigDecimal ? BigDecimal.TEN : Integer.valueOf(10);
                }
            }
            if (str.isEmpty()) {
                str = "<empty>";
            } else {
                Number val = Convert.s2n(str, ref, asBigDecimal, objOriginallyString);
                if (val != null) {
                    return val;
                }
            }
            if (noAbort) {
                return def;
            }
            throw new MidasException("Illegal numberic expression:" + str);
        }
        catch (RuntimeException e) {
            if (noAbort) {
                return def;
            }
            throw e;
        }
    }

    public static Number s2n(String string, Object ref, boolean asBigDecimal) {
        return Convert.s2n(string, ref, asBigDecimal, true);
    }

    public static Number s2n(String string, Object ref, boolean asBigDecimal, boolean handleResultsName) {
        if (!asBigDecimal) {
            if (!alwaysDefaultToDouble) {
                Object resObj;
                Results rt;
                Number quickNumber = Convert.getQuickNumber(string);
                if (quickNumber != null) {
                    return quickNumber;
                }
                if (handleResultsName && ref != null && (rt = Convert.ref2Results(ref)) != null && !string.startsWith("TEST(") && !string.startsWith("CALC(") && (resObj = rt.get(string)) != null) {
                    if (resObj instanceof Number) {
                        return (Number)resObj;
                    }
                    if (resObj instanceof Data) {
                        return ((Data)resObj).toNumber();
                    }
                }
            }
            double[] val = new double[3];
            if (Convert.s2d(string.getBytes(), 0, string.length(), val, ref) >= 0) {
                return val[0];
            }
            return null;
        }
        BigDecimalValue val = new BigDecimalValue();
        try {
            if (Convert.s2BigDecimal(string.getBytes(), 0, string.length(), val, ref) >= 0) {
                return val.getValue();
            }
        }
        catch (Exception e) {
            val.setValue(new BigDecimal(Convert.s2d(string, ref)));
            return val.getValue();
        }
        return null;
    }

    private static Number getQuickNumber(String strValue) {
        boolean isSigned;
        Number quickNumber = null;
        String strValueLC = strValue.trim().toLowerCase();
        boolean isNegative = strValueLC.charAt(0) == '-';
        boolean hasPlus = strValueLC.charAt(0) == '+';
        boolean bl = isSigned = isNegative || hasPlus;
        if (WHOLE_NUMBER_PATTERN.matcher(strValueLC).matches()) {
            int numDigits;
            int n = numDigits = isSigned ? strValueLC.length() - 1 : strValueLC.length();
            quickNumber = numDigits < DIGITS_INTEGER_MAX_VALUE ? (Number)Integer.valueOf(strValueLC) : (Number)(numDigits == DIGITS_INTEGER_MAX_VALUE && Convert.isTenDigitInteger(isNegative, hasPlus ? strValueLC.substring(1) : strValueLC) ? (Number)Integer.valueOf(strValueLC) : (Number)(numDigits < DIGITS_LONG_MAX_VALUE ? (Number)Long.valueOf(strValueLC) : (Number)(numDigits == DIGITS_LONG_MAX_VALUE && Convert.isNineteenDigitLong(isNegative, hasPlus ? strValueLC.substring(1) : strValueLC) ? Long.valueOf(strValueLC) : new BigInteger(strValueLC))));
        } else if (FLOAT_NUMBER_PATTERN.matcher(strValueLC).matches()) {
            int locOfDecimal = strValueLC.indexOf(46);
            int numDigitsBeforeDecimal = isSigned ? locOfDecimal - 1 : locOfDecimal;
            int locOfExponent = strValueLC.indexOf(101);
            int numDigitsWhole = locOfExponent == -1 ? numDigitsBeforeDecimal : numDigitsBeforeDecimal + Integer.valueOf(strValue.substring(locOfExponent + 1));
            int numDigitsPrecision = strValue.length();
            if (isSigned) {
                --numDigitsPrecision;
            }
            if (locOfDecimal > -1) {
                --numDigitsPrecision;
            }
            if (locOfExponent > -1) {
                numDigitsPrecision -= strValue.length() - locOfExponent;
            }
            if (numDigitsPrecision > 15 || numDigitsWhole > 309) {
                quickNumber = new BigDecimal(strValueLC);
            } else if (numDigitsWhole == 309) {
                quickNumber = Double.valueOf(strValueLC);
                if ((Double)quickNumber == Double.POSITIVE_INFINITY || (Double)quickNumber == Double.NEGATIVE_INFINITY) {
                    quickNumber = new BigDecimal(strValueLC);
                }
            } else {
                quickNumber = Double.valueOf(strValueLC);
            }
        } else if (strValueLC.equals("nan")) {
            quickNumber = Double.NaN;
        } else if (strValueLC.equals("infinity")) {
            quickNumber = Double.POSITIVE_INFINITY;
        } else if (strValueLC.equals("-infinity")) {
            quickNumber = Double.NEGATIVE_INFINITY;
        }
        return quickNumber;
    }

    private static boolean isTenDigitInteger(boolean isNegative, String value) {
        if (isNegative) {
            return value.compareTo(String_Integer_MIN_VALUE) >= 0;
        }
        return value.compareTo(String_Integer_MAX_VALUE) <= 0;
    }

    private static boolean isNineteenDigitLong(boolean isNegative, String value) {
        if (isNegative) {
            return value.compareTo(String_Long_MIN_VALUE) >= 0;
        }
        return value.compareTo(String_Long_MAX_VALUE) <= 0;
    }

    public static float o2f(Object obj) {
        return (float)Convert.o2d(obj);
    }

    public static long o2x(Object obj) {
        return Convert.o2x(obj, null);
    }

    @InternalUseOnly
    public static Data o2u(Object obj) {
        String sval = obj instanceof Data ? String.valueOf(Convert.unpackUI(((Data)obj).buf, 0, Shell.rep)) : obj.toString();
        Data data = new Data((short)Integer.parseInt(sval));
        data.type = (byte)85;
        return data;
    }

    @InternalUseOnly
    public static Data o2v(Object obj) {
        String sval = obj instanceof Data ? String.valueOf(Convert.unpackV(((Data)obj).buf, 0, Shell.rep)) : (obj instanceof Integer ? Integer.toUnsignedString((Integer)obj) : obj.toString());
        Data data = new Data(Integer.parseUnsignedInt(sval));
        data.type = (byte)86;
        return data;
    }

    public static int o2l(Object obj) {
        if (!favorJavaBehavior) {
            double objAsRintDouble = Math.rint(Convert.o2d(obj));
            return (int)objAsRintDouble;
        }
        return Convert.o2lJava(obj, null);
    }

    public static int o2lJava(Object obj, Object ref) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Data) {
            return ((Data)obj).toNumber().intValue();
        }
        if (obj instanceof String) {
            Object resObj;
            Results rt;
            String strObj = (String)obj;
            Number directNumber = Convert.getQuickNumber(strObj);
            if (directNumber != null) {
                return directNumber.intValue();
            }
            if (ref != null && (rt = Convert.ref2Results(ref)) != null && !strObj.startsWith("TEST(") && !strObj.startsWith("CALC(") && (resObj = rt.get(strObj)) != null) {
                if (resObj instanceof Number) {
                    return ((Number)resObj).intValue();
                }
                if (resObj instanceof Data) {
                    return ((Data)resObj).toNumber().intValue();
                }
            }
            return (int)Convert.s2d((String)obj);
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof Time) {
            return (int)((Time)obj).getWSec();
        }
        if (obj instanceof XMValue) {
            return ((XMValue)obj).toL();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1 : 0;
        }
        throw new IllegalArgumentException("Unconvertable type [" + obj + "] to Midas long");
    }

    public static short o2i(Object obj) {
        return (short)Convert.o2l(obj);
    }

    public static byte o2b(Object obj) {
        return (byte)Convert.o2l(obj);
    }

    public static double o2d(Object obj, int off, double defValue) {
        if (obj instanceof Data) {
            Data data = (Data)obj;
            if (off < 0 || off >= data.size * data.spa) {
                return defValue;
            }
            return data.getD(off);
        }
        if (obj instanceof double[]) {
            double[] data = (double[])obj;
            if (off < 0 || off >= data.length) {
                return defValue;
            }
            return data[off];
        }
        return defValue;
    }

    public static double[] o2da(Object obj) {
        double[] da = null;
        if (obj instanceof Data) {
            Data data = (Data)obj;
            da = new double[data.size * data.spa];
            for (int i = 0; i < data.size * data.spa; ++i) {
                da[i] = data.getD(i);
            }
        } else if (obj instanceof double[]) {
            da = (double[])obj;
        }
        return da;
    }

    public static boolean o2bool(Object obj, Object ref) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            String string = (String)obj;
            if (Convert.isTrueString(string)) {
                return true;
            }
            if (Convert.isFalseString(string)) {
                return false;
            }
        }
        return Convert.o2d(obj, ref) > 0.0;
    }

    public static boolean isTrueString(String state) {
        StringBuilder sb = new StringBuilder("|");
        sb.append(state);
        sb.append("|");
        return "|Y|YES|T|TRUE|ON|".indexOf(sb.toString()) >= 0;
    }

    public static boolean isFalseString(String state) {
        StringBuilder sb = new StringBuilder("|");
        sb.append(state);
        sb.append("|");
        return "|N|NO|F|FALSE|OFF|".indexOf(sb.toString()) >= 0;
    }

    public static Table o2t(Object obj) {
        if (obj instanceof Table) {
            return (Table)obj;
        }
        if (obj instanceof String) {
            return new Table((String)obj);
        }
        if (obj instanceof Tablizable) {
            return ((Tablizable)obj).toTable();
        }
        return null;
    }

    @InternalUseOnly
    public static Table o2tStrict(Object obj) {
        if (obj instanceof Table) {
            return (Table)obj;
        }
        if (obj instanceof String) {
            Table t = new Table(4, 1024);
            t.fromBytes(((String)obj).getBytes());
            return t;
        }
        if (obj instanceof Tablizable) {
            return ((Tablizable)obj).toTable();
        }
        return null;
    }

    public static Table o2t(Object obj, Object ref) {
        if (obj instanceof Table) {
            return (Table)obj;
        }
        if (obj instanceof Map) {
            return new Table((Map)obj);
        }
        if (obj instanceof Tablizable) {
            return ((Tablizable)obj).toTable();
        }
        if (!(obj instanceof String)) {
            return null;
        }
        String string = (String)obj;
        int ib = string.indexOf(123);
        if (ib >= 0 && ib <= 5) {
            int mode;
            int ic = string.indexOf(58);
            int n = mode = (Table.getDefaultFlagsInt() & 0x400) != 0 ? 6 : 1;
            if (ic > 0 && ic == ib - 1) {
                mode = Parser.find("FB,KV,HT,HM,LHM,SLHM,TM,STM,MAP,KEY,CHM", string.substring(0, ic), mode);
                string = string.substring(ib);
            }
            Table t = new Table(1);
            t.fromBytes(string.getBytes());
            if (mode != 1) {
                t.setMode(mode);
            }
            return t;
        }
        Results rt = Convert.ref2Results(ref);
        if (rt != null) {
            obj = rt.get(string);
        }
        if (obj instanceof Table) {
            return (Table)obj;
        }
        if (obj instanceof Map) {
            return new Table((Map)obj);
        }
        if (obj instanceof Tablizable) {
            return ((Tablizable)obj).toTable();
        }
        TextFile tf = new TextFile(Convert.ref2MidasReference(ref), (Object)string);
        if (tf.find(-1)) {
            String fname = tf.getURL().toLowerCase();
            if (fname.endsWith(".tbl")) {
                return new Table(tf);
            }
            if (fname.endsWith(".xml")) {
                return XmlFile.fastXmlFileToTable(tf);
            }
        }
        return null;
    }

    public static byte[] o2ba(Object obj) {
        if (obj instanceof Table) {
            return ((Table)obj).toBytes();
        }
        if (obj instanceof String) {
            return ((String)obj).getBytes();
        }
        if (obj instanceof Data) {
            return ((Data)obj).buf;
        }
        if (obj instanceof float[]) {
            return Convert.ja2ba((float[])obj);
        }
        if (obj instanceof double[]) {
            return Convert.ja2ba((double[])obj);
        }
        if (obj instanceof long[]) {
            return Convert.ja2ba((long[])obj);
        }
        if (obj instanceof int[]) {
            return Convert.ja2ba((int[])obj);
        }
        if (obj instanceof short[]) {
            return Convert.ja2ba((short[])obj);
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        return null;
    }

    public static byte[] ja2ba(double[] ja) {
        int size = ja.length;
        byte[] buf = new byte[size * 8];
        for (int i = 0; i < size; ++i) {
            Convert.packD(buf, i * 8, ja[i]);
        }
        return buf;
    }

    public static byte[] ja2ba(float[] ja) {
        int size = ja.length;
        byte[] buf = new byte[size * 4];
        for (int i = 0; i < size; ++i) {
            Convert.packF(buf, i * 4, ja[i]);
        }
        return buf;
    }

    public static byte[] ja2ba(long[] ja) {
        int size = ja.length;
        byte[] buf = new byte[size * 8];
        for (int i = 0; i < size; ++i) {
            Convert.packX(buf, i * 8, ja[i]);
        }
        return buf;
    }

    public static byte[] ja2ba(int[] ja) {
        int size = ja.length;
        byte[] buf = new byte[size * 4];
        for (int i = 0; i < size; ++i) {
            Convert.packL(buf, i * 4, ja[i]);
        }
        return buf;
    }

    public static byte[] ja2ba(short[] ja) {
        int size = ja.length;
        byte[] buf = new byte[size * 2];
        for (int i = 0; i < size; ++i) {
            Convert.packI(buf, i * 2, ja[i]);
        }
        return buf;
    }

    public static byte unpackP(byte[] buf, int off) {
        return (byte)(buf[off >> 3] >> (off & 7) & 1);
    }

    public static byte unpackP(byte[] buf, int off, byte rep) {
        int start = off;
        if (rep == 73) {
            start = off / 8 * 8 + (7 - off % 8);
        }
        return (byte)(buf[start >> 3] >> (start & 7) & 1);
    }

    public static byte unpackN(byte[] buf, int off) {
        return (byte)(buf[off >> 1] << ((off & 1) == 0 ? 28 : 24) >> 28);
    }

    public static byte unpackN(byte[] buf, int off, byte rep) {
        int start = off;
        if (rep == 73) {
            start = off / 2 * 2 + (1 - off % 2);
        }
        return (byte)(buf[start >> 1] << ((start & 1) == 0 ? 28 : 24) >> 28);
    }

    public static byte unpackB(byte[] buf, int off) {
        return buf[off];
    }

    public static char unpackC(byte[] buf, int off) {
        return (char)buf[off];
    }

    public static short unpackJ(byte[] buf, int off, byte rep) {
        int boff = off / 2 * 3;
        if ((off & 1) == 0) {
            return (short)(rep == 73 ? (buf[boff + 0] & 0xFF) << 12 | (buf[boff + 1] & 0xFF) << 4 : (buf[boff + 1] & 0xFF) << 12 | (buf[boff + 0] & 0xFF) << 4);
        }
        return (short)(Shell.rep == 73 ? (buf[boff + 0] & 0xFF) << 8 | buf[boff + 1] & 0xF0 : (buf[boff + 2] & 0xFF) << 8 | buf[boff + 1] & 0xF0);
    }

    public static short unpackJ(byte[] buf, int off) {
        return Convert.unpackJ(buf, off, Shell.rep);
    }

    public static short unpackI(byte[] buf, int off) {
        return (short)(Shell.rep == 73 ? buf[off + 1] & 0xFF | (buf[off + 0] & 0xFF) << 8 : buf[off + 0] & 0xFF | (buf[off + 1] & 0xFF) << 8);
    }

    public static short unpackI(byte[] buf, int off, byte rep) {
        return (short)(rep == 73 ? buf[off + 1] & 0xFF | (buf[off + 0] & 0xFF) << 8 : buf[off + 0] & 0xFF | (buf[off + 1] & 0xFF) << 8);
    }

    public static int unpackL(byte[] buf, int off) {
        return Shell.rep == 73 ? buf[off + 3] & 0xFF | (buf[off + 2] & 0xFF) << 8 | (buf[off + 1] & 0xFF) << 16 | buf[off + 0] << 24 : buf[off + 0] & 0xFF | (buf[off + 1] & 0xFF) << 8 | (buf[off + 2] & 0xFF) << 16 | buf[off + 3] << 24;
    }

    public static int unpackL(byte[] buf, int off, byte rep) {
        return rep == 73 ? buf[off + 3] & 0xFF | (buf[off + 2] & 0xFF) << 8 | (buf[off + 1] & 0xFF) << 16 | buf[off + 0] << 24 : buf[off + 0] & 0xFF | (buf[off + 1] & 0xFF) << 8 | (buf[off + 2] & 0xFF) << 16 | buf[off + 3] << 24;
    }

    @InternalUseOnly
    public static int unpackU(byte[] buf, int off) {
        return Convert.unpackUI(buf, off, Shell.rep);
    }

    @InternalUseOnly
    public static int unpackUI(byte[] buf, int off, byte rep) {
        return rep == 73 ? Short.toUnsignedInt((short)((short)(buf[off + 1] & 0xFF) | (short)(buf[off + 0] & 0xFF) << 8)) : Short.toUnsignedInt((short)((short)(buf[off + 0] & 0xFF) | (short)(buf[off + 1] & 0xFF) << 8));
    }

    @InternalUseOnly
    public static long unpackUL(byte[] buf, int off) {
        return Convert.unpackV(buf, off, Shell.rep);
    }

    @InternalUseOnly
    public static long unpackV(byte[] buf, int off, byte rep) {
        return rep == 73 ? Integer.toUnsignedLong(buf[off + 3] & 0xFF | (buf[off + 2] & 0xFF) << 8 | (buf[off + 1] & 0xFF) << 16 | buf[off + 0] << 24) : Integer.toUnsignedLong(buf[off + 0] & 0xFF | (buf[off + 1] & 0xFF) << 8 | (buf[off + 2] & 0xFF) << 16 | buf[off + 3] << 24);
    }

    public static long unpackX(byte[] buf, int off) {
        int val1;
        int val0;
        if (Shell.rep == 73) {
            val0 = buf[off + 7] & 0xFF | (buf[off + 6] & 0xFF) << 8 | (buf[off + 5] & 0xFF) << 16 | buf[off + 4] << 24;
            val1 = buf[off + 3] & 0xFF | (buf[off + 2] & 0xFF) << 8 | (buf[off + 1] & 0xFF) << 16 | buf[off + 0] << 24;
        } else {
            val0 = buf[off + 0] & 0xFF | (buf[off + 1] & 0xFF) << 8 | (buf[off + 2] & 0xFF) << 16 | buf[off + 3] << 24;
            val1 = buf[off + 4] & 0xFF | (buf[off + 5] & 0xFF) << 8 | (buf[off + 6] & 0xFF) << 16 | buf[off + 7] << 24;
        }
        return (long)val0 & 0xFFFFFFFFL | (long)val1 << 32;
    }

    public static long unpackX(byte[] buf, int off, byte rep) {
        int val1;
        int val0;
        if (rep == 73) {
            val0 = buf[off + 7] & 0xFF | (buf[off + 6] & 0xFF) << 8 | (buf[off + 5] & 0xFF) << 16 | buf[off + 4] << 24;
            val1 = buf[off + 3] & 0xFF | (buf[off + 2] & 0xFF) << 8 | (buf[off + 1] & 0xFF) << 16 | buf[off + 0] << 24;
        } else {
            val0 = buf[off + 0] & 0xFF | (buf[off + 1] & 0xFF) << 8 | (buf[off + 2] & 0xFF) << 16 | buf[off + 3] << 24;
            val1 = buf[off + 4] & 0xFF | (buf[off + 5] & 0xFF) << 8 | (buf[off + 6] & 0xFF) << 16 | buf[off + 7] << 24;
        }
        return (long)val0 & 0xFFFFFFFFL | (long)val1 << 32;
    }

    public static float unpackF(byte[] buf, int off) {
        return Float.intBitsToFloat(Convert.unpackL(buf, off));
    }

    public static float unpackF(byte[] buf, int off, byte rep) {
        return Float.intBitsToFloat(Convert.unpackL(buf, off, rep));
    }

    public static double unpackD(byte[] buf, int off) {
        return Double.longBitsToDouble(Convert.unpackX(buf, off));
    }

    public static double unpackD(byte[] buf, int off, byte rep) {
        return Double.longBitsToDouble(Convert.unpackX(buf, off, rep));
    }

    public static byte[] unpackA(byte[] buf, int off, int len) {
        byte[] val = new byte[len];
        System.arraycopy(buf, off, val, 0, len);
        return val;
    }

    public static byte[] unpackZ(byte[] buf, int off, int len) {
        byte[] val = new byte[len];
        System.arraycopy(buf, off, val, 0, len);
        return val;
    }

    public static String unpackS(byte[] buf, int off, int len) {
        while (len > 0 && buf[off + len - 1] <= 32) {
            --len;
        }
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)buf[off + i];
        }
        return new String(chars);
    }

    public static void packP(byte[] buf, int off, byte val) {
        if (val == 0) {
            int n = off >> 3;
            buf[n] = (byte)(buf[n] & ~(1 << (off & 7)));
        } else {
            int n = off >> 3;
            buf[n] = (byte)(buf[n] | 1 << (off & 7));
        }
    }

    public static void packP(byte[] buf, int off, byte val, byte rep) {
        int start = off;
        if (rep == 73) {
            start = off / 8 * 8 + (7 - off % 8);
        }
        Convert.packP(buf, start, val);
    }

    public static void packN(byte[] buf, int off, byte val) {
        int boff = off >> 1;
        int bn = buf[boff];
        bn = (off & 1) != 0 ? bn & 0xF | val << 4 & 0xF0 : bn & 0xF0 | val & 0xF;
        buf[boff] = (byte)bn;
    }

    public static void packN(byte[] buf, int off, byte val, byte rep) {
        int start = off;
        if (rep == 73) {
            start = off / 2 * 2 + (1 - off % 2);
        }
        Convert.packN(buf, start, val);
    }

    public static void packB(byte[] buf, int off, byte val) {
        buf[off] = val;
    }

    public static void packC(byte[] buf, int off, char val) {
        buf[off] = (byte)val;
    }

    public static void packI(byte[] buf, int off, short val) {
        if (Shell.rep == 73) {
            buf[off + 1] = (byte)val;
            buf[off + 0] = (byte)(val >> 8);
        } else {
            buf[off + 0] = (byte)val;
            buf[off + 1] = (byte)(val >> 8);
        }
    }

    public static void packI(byte[] buf, int off, short val, byte rep) {
        if (rep == 73) {
            buf[off + 1] = (byte)val;
            buf[off + 0] = (byte)(val >> 8);
        } else {
            buf[off + 0] = (byte)val;
            buf[off + 1] = (byte)(val >> 8);
        }
    }

    public static void packL(byte[] buf, int off, int val) {
        if (Shell.rep == 73) {
            buf[off + 3] = (byte)val;
            buf[off + 2] = (byte)(val >> 8);
            buf[off + 1] = (byte)(val >> 16);
            buf[off + 0] = (byte)(val >> 24);
        } else {
            buf[off + 0] = (byte)val;
            buf[off + 1] = (byte)(val >> 8);
            buf[off + 2] = (byte)(val >> 16);
            buf[off + 3] = (byte)(val >> 24);
        }
    }

    public static void packL(byte[] buf, int off, int val, byte rep) {
        if (rep == 73) {
            buf[off + 3] = (byte)val;
            buf[off + 2] = (byte)(val >> 8);
            buf[off + 1] = (byte)(val >> 16);
            buf[off + 0] = (byte)(val >> 24);
        } else {
            buf[off + 0] = (byte)val;
            buf[off + 1] = (byte)(val >> 8);
            buf[off + 2] = (byte)(val >> 16);
            buf[off + 3] = (byte)(val >> 24);
        }
    }

    public static void packX(byte[] buf, int off, long val) {
        int val1 = (int)val;
        int val2 = (int)(val >>> 32);
        if (Shell.rep == 73) {
            buf[off + 7] = (byte)val1;
            buf[off + 6] = (byte)(val1 >> 8);
            buf[off + 5] = (byte)(val1 >> 16);
            buf[off + 4] = (byte)(val1 >> 24);
            buf[off + 3] = (byte)val2;
            buf[off + 2] = (byte)(val2 >> 8);
            buf[off + 1] = (byte)(val2 >> 16);
            buf[off + 0] = (byte)(val2 >> 24);
        } else {
            buf[off + 0] = (byte)val1;
            buf[off + 1] = (byte)(val1 >> 8);
            buf[off + 2] = (byte)(val1 >> 16);
            buf[off + 3] = (byte)(val1 >> 24);
            buf[off + 4] = (byte)val2;
            buf[off + 5] = (byte)(val2 >> 8);
            buf[off + 6] = (byte)(val2 >> 16);
            buf[off + 7] = (byte)(val2 >> 24);
        }
    }

    public static void packX(byte[] buf, int off, long val, byte rep) {
        int val1 = (int)val;
        int val2 = (int)(val >>> 32);
        if (rep == 73) {
            buf[off + 7] = (byte)val1;
            buf[off + 6] = (byte)(val1 >> 8);
            buf[off + 5] = (byte)(val1 >> 16);
            buf[off + 4] = (byte)(val1 >> 24);
            buf[off + 3] = (byte)val2;
            buf[off + 2] = (byte)(val2 >> 8);
            buf[off + 1] = (byte)(val2 >> 16);
            buf[off + 0] = (byte)(val2 >> 24);
        } else {
            buf[off + 0] = (byte)val1;
            buf[off + 1] = (byte)(val1 >> 8);
            buf[off + 2] = (byte)(val1 >> 16);
            buf[off + 3] = (byte)(val1 >> 24);
            buf[off + 4] = (byte)val2;
            buf[off + 5] = (byte)(val2 >> 8);
            buf[off + 6] = (byte)(val2 >> 16);
            buf[off + 7] = (byte)(val2 >> 24);
        }
    }

    public static void packF(byte[] buf, int off, float val) {
        Convert.packL(buf, off, Float.floatToIntBits(val));
    }

    public static void packF(byte[] buf, int off, float val, byte rep) {
        Convert.packL(buf, off, Float.floatToIntBits(val), rep);
    }

    public static void packD(byte[] buf, int off, double val) {
        Convert.packX(buf, off, Double.doubleToLongBits(val));
    }

    public static void packD(byte[] buf, int off, double val, byte rep) {
        Convert.packX(buf, off, Double.doubleToLongBits(val), rep);
    }

    public static void packA(byte[] buf, int off, int len, byte[] value) {
        System.arraycopy(value, 0, buf, off, len);
    }

    public static void packZ(byte[] buf, int off, int len, byte[] value) {
        System.arraycopy(value, 0, buf, off, len);
    }

    public static void packS(byte[] buf, int off, int len, String value) {
        Convert.packS(buf, off, len, (CharSequence)value);
    }

    public static void packS(byte[] buf, int off, int len, CharSequence value) {
        int i;
        if (value == null) {
            value = "";
        }
        int lenv = Math.min(value.length(), len);
        for (i = 0; i < lenv; ++i) {
            buf[off + i] = (byte)value.charAt(i);
        }
        for (i = lenv; i < len; ++i) {
            buf[off + i] = 32;
        }
    }

    static void packJs(byte[] b16, byte[] b12, int off, int size) {
        int b16idx = 0;
        int b12idx = 0;
        int i = 0;
        while (i < size / 2) {
            b12[b12idx + 0] = (byte)(b16[b16idx + 1] << 4 | b16[b16idx + 0] >> 4 & 0xF);
            b12[b12idx + 1] = (byte)(b16[b16idx + 2] & 0xF0 | b16[b16idx + 1] >> 4 & 0xF);
            b12[b12idx + 2] = b16[b16idx + 3];
            ++i;
            b16idx += 4;
            b12idx += 3;
        }
        if ((size & 1) != 0) {
            if ((off & 1) == 0) {
                b12[b12idx + 0] = (byte)(b16[b16idx + 1] << 4 | b16[b16idx + 0] >> 4 & 0xF);
                b12[b12idx + 1] = (byte)(b16[b16idx + 1] >> 4 & 0xF);
            } else {
                b12[b12idx + 0] = (byte)(b16[b16idx + 1] & 0xF0 | b16[b16idx + 0] >> 4 & 0xF);
                b12[b12idx + 1] = b16[b16idx + 2];
            }
        }
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.6.0")
    public static byte[] getSHA1(String s) {
        byte[] sha1 = null;
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA1");
            crypt.reset();
            crypt.update(s.getBytes("UTF-8"));
            sha1 = crypt.digest();
        }
        catch (Exception e) {
            System.out.println("SHA-1 err: " + e);
        }
        return sha1;
    }

    public static String encodeBase64(String s) {
        return Convert.encodeBase64(s.getBytes());
    }

    public static String encodeBase64(byte[] octetString) {
        int bits6;
        int bits24;
        char[] out = new char[((octetString.length - 1) / 3 + 1) * 4];
        int outIndex = 0;
        int i = 0;
        while (i + 3 <= octetString.length) {
            bits24 = (octetString[i++] & 0xFF) << 16;
            bits24 |= (octetString[i++] & 0xFF) << 8;
            bits6 = ((bits24 |= (octetString[i++] & 0xFF) << 0) & 0xFC0000) >> 18;
            out[outIndex++] = alphabet[bits6];
            bits6 = (bits24 & 0x3F000) >> 12;
            out[outIndex++] = alphabet[bits6];
            bits6 = (bits24 & 0xFC0) >> 6;
            out[outIndex++] = alphabet[bits6];
            bits6 = bits24 & 0x3F;
            out[outIndex++] = alphabet[bits6];
        }
        if (octetString.length - i == 2) {
            bits24 = (octetString[i] & 0xFF) << 16;
            bits6 = ((bits24 |= (octetString[i + 1] & 0xFF) << 8) & 0xFC0000) >> 18;
            out[outIndex++] = alphabet[bits6];
            bits6 = (bits24 & 0x3F000) >> 12;
            out[outIndex++] = alphabet[bits6];
            bits6 = (bits24 & 0xFC0) >> 6;
            out[outIndex++] = alphabet[bits6];
            out[outIndex++] = 61;
        } else if (octetString.length - i == 1) {
            bits24 = (octetString[i] & 0xFF) << 16;
            bits6 = (bits24 & 0xFC0000) >> 18;
            out[outIndex++] = alphabet[bits6];
            bits6 = (bits24 & 0x3F000) >> 12;
            out[outIndex++] = alphabet[bits6];
            out[outIndex++] = 61;
            out[outIndex++] = 61;
        }
        return new String(out);
    }

    public static boolean validType(char type) {
        return "DFXLIJBNPA,ZSOTZVCKH_UQ".indexOf(type) >= 0;
    }

    public static void data2ja(Data data, Object array, int aoff, byte atype) {
        int n = data.size * data.ape * data.spa;
        Convert.bb2ja(data.buf, 0, data.type, array, aoff, atype, n);
    }

    public static double data2d(Data data, int offset, char format) {
        double result = 0.0;
        switch (format) {
            case 'F': {
                result = data.unpackF(offset);
                break;
            }
            case 'D': {
                result = data.unpackD(offset);
                break;
            }
            case 'X': {
                result = data.unpackX(offset);
                break;
            }
            case 'L': {
                result = data.unpackL(offset);
                break;
            }
            case 'I': {
                result = data.unpackI(offset);
                break;
            }
            case 'B': {
                result = data.unpackB(offset);
                break;
            }
            default: {
                result = 0.0;
            }
        }
        return result;
    }

    public static void bb2ja(byte[] buf1, byte type1, Object buf2, byte type2, int n) {
        Convert.bb2ja(buf1, 0, type1, buf2, 0, type2, n);
    }

    public static String bb2hex(byte[] buf, int offset, int bpe) {
        int k;
        short j;
        String text = "0x";
        if (bpe < 0) {
            if (offset < 0) {
                offset /= bpe;
            }
            if (bpe == -1) {
                text = text + hexstr.charAt(Convert.unpackP(buf, offset));
            }
            if (bpe == -4) {
                text = text + hexstr.charAt(Convert.unpackN(buf, offset) + 16);
            }
            if (bpe == -12) {
                j = Convert.unpackJ(buf, offset);
                for (k = 12; k >= 4; k -= 4) {
                    text = text + hexstr.charAt(j >> k & 0xF);
                }
            }
        }
        if (Shell.osrep == "EEEI") {
            for (int i = bpe - 1; i >= 0; --i) {
                j = buf[offset + i];
                k = j >> 4 & 0xF;
                text = text + hexstr.charAt(k);
                k = j & 0xF;
                text = text + hexstr.charAt(k);
            }
        } else {
            for (int i = 0; i <= bpe - 1; ++i) {
                j = buf[offset + i];
                k = j >> 4 & 0xF;
                text = text + hexstr.charAt(k);
                k = j & 0xF;
                text = text + hexstr.charAt(k);
            }
        }
        return text;
    }

    public static String bb2bin(byte[] buf, int offset, int bpe) {
        String text = "0b";
        if (Shell.osrep == "EEEI") {
            for (int i = bpe - 1; i >= 0; --i) {
                byte j = buf[offset + i];
                for (int k = 7; k >= 0; --k) {
                    text = (j & 1 << k) != 0 ? text + '1' : text + '0';
                }
            }
        } else {
            for (int i = 0; i <= bpe - 1; ++i) {
                byte j = buf[offset + i];
                for (int k = 7; k >= 0; --k) {
                    text = (j & 1 << k) != 0 ? text + '1' : text + '0';
                }
            }
        }
        return text;
    }

    public static String bb2oct(byte[] buf, int offset, int bpe) {
        return Convert.bb2oct(buf, offset, bpe, false);
    }

    public static String bb2oct(byte[] buf, int offset, int bpe, boolean signed) {
        int shift = 336;
        String bin = Convert.bb2bin(buf, offset, bpe);
        StringBuilder oct = new StringBuilder(bin.length() / 3);
        int index = 2;
        oct.append("0o");
        switch ((bin.length() - 2) % 3) {
            case 2: {
                index = 4;
                oct.append((signed ? bin.charAt(2) << 2 : 192) + (bin.charAt(2) << 1) + bin.charAt(3) - 336);
                break;
            }
            case 1: {
                index = 3;
                oct.append((signed ? bin.charAt(2) << 2 : 192) + (signed ? bin.charAt(2) << 1 : 96) + bin.charAt(2) - 336);
            }
        }
        while (index < bin.length()) {
            oct.append((bin.charAt(index) << 2) + (bin.charAt(index + 1) << 1) + bin.charAt(index + 2) - 336);
            index += 3;
        }
        return oct.toString();
    }

    public static void ja2data(Object array, int aoff, byte atype, Data data) {
        int n = data.size * data.ape * data.spa;
        Convert.ja2bb(array, aoff, atype, data.buf, 0, data.type, n);
    }

    public static void ja2bb(Object buf1, byte type1, byte[] buf2, byte type2, int n) {
        Convert.ja2bb(buf1, 0, type1, buf2, 0, type2, n);
    }

    public static void formatVAX() {
    }

    public static void formatIEEE() {
    }

    public static void move(byte[] buf1, int off1, int stride1, byte[] buf2, int off2, int stride2, int bpe, int n) {
        while (n > 0) {
            System.arraycopy(buf1, off1, buf2, off2, bpe);
            off1 += stride1;
            off2 += stride2;
            --n;
        }
    }

    public static double[] castD(byte[] buf, boolean copy) {
        if (Native.useCastX) {
            return Native.castD(buf);
        }
        int n = buf.length / 8;
        double[] array = new double[n];
        if (copy) {
            Convert.bb2ja(buf, 0, (byte)68, array, 0, (byte)68, n);
        }
        return array;
    }

    public static float[] castF(byte[] buf, boolean copy) {
        if (Native.useCast) {
            return Native.castF(buf);
        }
        int n = buf.length / 4;
        float[] array = new float[n];
        if (copy) {
            Convert.bb2ja(buf, 0, (byte)70, array, 0, (byte)70, n);
        }
        return array;
    }

    public static int[] castL(byte[] buf, boolean copy) {
        if (Native.useCast) {
            return Native.castL(buf);
        }
        int n = buf.length / 4;
        int[] array = new int[n];
        if (copy) {
            Convert.bb2ja(buf, 0, (byte)76, array, 0, (byte)76, n);
        }
        return array;
    }

    public static short[] castI(byte[] buf, boolean copy) {
        if (Native.useCast) {
            return Native.castI(buf);
        }
        int n = buf.length / 2;
        short[] array = new short[n];
        if (copy) {
            Convert.bb2ja(buf, 0, (byte)73, array, 0, (byte)73, n);
        }
        return array;
    }

    public static void uncast(double[] array, byte[] buf, boolean copy) {
        if (Native.useCastX) {
            Native.uncastD(buf);
        } else if (copy) {
            Convert.ja2bb(array, 0, (byte)68, buf, 0, (byte)68, array.length);
        }
    }

    public static void uncast(float[] array, byte[] buf, boolean copy) {
        if (Native.useCast) {
            Native.uncastF(buf);
        } else if (copy) {
            Convert.ja2bb(array, 0, (byte)70, buf, 0, (byte)70, array.length);
        }
    }

    public static void uncast(int[] array, byte[] buf, boolean copy) {
        if (Native.useCast) {
            Native.uncastL(buf);
        } else if (copy) {
            Convert.ja2bb(array, 0, (byte)76, buf, 0, (byte)76, array.length);
        }
    }

    public static void uncast(short[] array, byte[] buf, boolean copy) {
        if (Native.useCast) {
            Native.uncastI(buf);
        } else if (copy) {
            Convert.ja2bb(array, 0, (byte)73, buf, 0, (byte)73, array.length);
        }
    }

    public static int getRoundingMode(String str, int def) {
        if (str == null) {
            return def;
        }
        if (str.startsWith("ROUND_")) {
            str = str.substring(6);
        }
        return Parser.find(roundingList, str, def, -2);
    }

    public static String getRoundingModeString(int round) {
        return Parser.get(roundingList, round, -2);
    }

    public static double lround(double n) {
        return n > 0.0 ? n + 0.5 : n - 0.5;
    }

    private static int n2l_sat(long val) {
        return val >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (val <= Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)val);
    }

    private static short n2i_sat(double val) {
        return (short)(val >= 32767.0 ? Short.MAX_VALUE : (short)(val <= -32768.0 ? Short.MIN_VALUE : (short)val));
    }

    private static short n2i_sat(float val) {
        return (short)(val >= 32767.0f ? Short.MAX_VALUE : (short)(val <= -32768.0f ? Short.MIN_VALUE : (short)val));
    }

    private static short n2i_sat(long val) {
        return (short)(val >= 32767L ? Short.MAX_VALUE : (short)(val <= -32768L ? Short.MIN_VALUE : (short)val));
    }

    private static short n2i_sat(int val) {
        return (short)(val >= Short.MAX_VALUE ? Short.MAX_VALUE : (short)(val <= Short.MIN_VALUE ? Short.MIN_VALUE : (short)val));
    }

    private static byte n2b_sat(double val) {
        return (byte)(val >= 127.0 ? 127 : (byte)(val <= -128.0 ? -128 : (byte)val));
    }

    private static byte n2b_sat(float val) {
        return (byte)(val >= 127.0f ? 127 : (byte)(val <= -128.0f ? -128 : (byte)val));
    }

    private static byte n2b_sat(long val) {
        return (byte)(val >= 127L ? 127 : (byte)(val <= -128L ? -128 : (byte)val));
    }

    private static byte n2b_sat(int val) {
        return (byte)(val >= 127 ? 127 : (byte)(val <= -128 ? -128 : (byte)val));
    }

    private static byte n2b_sat(short val) {
        return (byte)(val >= 127 ? 127 : (byte)(val <= -128 ? -128 : (byte)val));
    }

    private static byte d2n_sat(double val) {
        return (byte)(val >= 7.0 ? 7 : (byte)(val <= -8.0 ? -8 : (byte)val));
    }

    private static byte f2n_sat(float val) {
        return (byte)(val >= 7.0f ? 7 : (byte)(val <= -8.0f ? -8 : (byte)val));
    }

    private static byte x2n_sat(long val) {
        return (byte)(val >= 7L ? 7 : (byte)(val <= -8L ? -8 : (byte)val));
    }

    private static byte l2n_sat(int val) {
        return (byte)(val >= 7 ? 7 : (byte)(val <= -8 ? -8 : (byte)val));
    }

    private static byte i2n_sat(short val) {
        return (byte)(val >= 7 ? 7 : (byte)(val <= -8 ? -8 : (byte)val));
    }

    private static byte b2n_sat(byte val) {
        return (byte)(val >= 7 ? 7 : (val <= -8 ? -8 : (int)val));
    }

    public static void bb2ja(byte[] buf1, int off1, byte type1, Object buf2, int off2, byte type2, int n) {
        Convert.bb2ja(buf1, off1, type1, buf2, off2, type2, n, 1, true);
    }

    public static void ja2bb(Object buf1, int off1, byte type1, byte[] buf2, int off2, byte type2, int n) {
        Convert.ja2bb(buf1, off1, type1, buf2, off2, type2, n, 1, true);
    }

    public static void type(byte[] buf1, int off1, byte type1, byte[] buf2, int off2, byte type2, int n) {
        Convert.type(buf1, off1, type1, buf2, off2, type2, n, 4, true);
    }

    public static void bb2ja(byte[] buf1, int off1, byte type1, Object buf2, int off2, byte type2, int n, int round, boolean saturating) {
        int status;
        block423: {
            int type;
            int j;
            int i;
            block422: {
                block421: {
                    block420: {
                        if (type1 == 72 || type2 == 72) {
                            throw new MidasException("Cannot convert non-homogeneous typed buffer to Java array for " + (char)type1 + "->" + (char)type2 + " conversion not supported.");
                        }
                        if (Native.useConvert && n > 1 && Native.type(buf1, off1, (byte)type1, buf2, off2, type2, n, round, saturating) == 0) {
                            return;
                        }
                        i = off1;
                        j = off2;
                        status = n += off1;
                        if (type1 == 74) {
                            byte[] buf1orig = buf1;
                            int buf1Lth = buf1.length % 2 == 0 ? buf1.length * 3 / 2 : buf1.length * 3 / 2 + 1;
                            buf1 = new byte[buf1Lth];
                            int bpsInt = Math.max(1, Data.getBPS((byte)73));
                            int iOff = 0;
                            int jOff = off1;
                            int maxIOff = n * bpsInt;
                            while (iOff < maxIOff) {
                                Convert.packI(buf1, iOff, Convert.unpackJ(buf1orig, jOff));
                                iOff += bpsInt;
                                ++jOff;
                            }
                            type1 = 73;
                        }
                        type = type1;
                        if (type1 != 68 || type2 == 68 || type2 == 70) break block420;
                        switch (round) {
                            case 1: {
                                type = -81;
                                break block421;
                            }
                            case 2: {
                                type = -82;
                                break block421;
                            }
                            case 3: {
                                type = -83;
                                break block421;
                            }
                            case 4: {
                                type = -87;
                                break block421;
                            }
                            case 6: {
                                type = -84;
                                break block421;
                            }
                            case -1: {
                                type = -86;
                                break block421;
                            }
                            case 7: {
                                throw new ArithmeticException("Can not use ROUND_UNNECESSARY for " + (char)type1 + "->" + (char)type2 + " conversion.");
                            }
                            default: {
                                throw new IllegalArgumentException("Illegal rounding mode " + round + " for " + (char)type1 + "->" + (char)type2 + " conversion.");
                            }
                        }
                    }
                    if (type1 == 70 && type2 != 68 && type2 != 70) {
                        switch (round) {
                            case 1: {
                                type = -41;
                                break;
                            }
                            case 2: {
                                type = -42;
                                break;
                            }
                            case 3: {
                                type = -43;
                                break;
                            }
                            case 4: {
                                type = -47;
                                break;
                            }
                            case 6: {
                                type = -44;
                                break;
                            }
                            case -1: {
                                type = -46;
                                break;
                            }
                            case 7: {
                                throw new ArithmeticException("Can not use ROUND_UNNECESSARY for " + (char)type1 + "->" + (char)type2 + " conversion.");
                            }
                            default: {
                                throw new IllegalArgumentException("Illegal rounding mode " + round + " for " + (char)type1 + "->" + (char)type2 + " conversion.");
                            }
                        }
                    }
                }
                if (!saturating) break block422;
                switch (type2) {
                    case 68: {
                        double[] array = (double[])buf2;
                        switch (type1) {
                            case 68: {
                                while (i < n) {
                                    array[j] = Double.longBitsToDouble(Convert.unpackX(buf1, i * 8));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 70: {
                                while (i < n) {
                                    array[j] = Float.intBitsToFloat(Convert.unpackL(buf1, i * 4));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 88: {
                                while (i < n) {
                                    array[j] = Convert.unpackX(buf1, i * 8);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 76: {
                                while (i < n) {
                                    array[j] = Convert.unpackL(buf1, i * 4);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 73: {
                                while (i < n) {
                                    array[j] = Convert.unpackI(buf1, i * 2);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 66: {
                                while (i < n) {
                                    array[j] = buf1[i];
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 78: {
                                while (i < n) {
                                    array[j] = Convert.unpackN(buf1, i);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 80: {
                                while (i < n) {
                                    array[j] = Convert.unpackP(buf1, i);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            default: {
                                status = -1;
                                break;
                            }
                        }
                        break block423;
                    }
                    case 70: {
                        float[] array = (float[])buf2;
                        switch (type1) {
                            case 68: {
                                while (i < n) {
                                    array[j] = (float)Double.longBitsToDouble(Convert.unpackX(buf1, i * 8));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 70: {
                                while (i < n) {
                                    array[j] = Float.intBitsToFloat(Convert.unpackL(buf1, i * 4));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 88: {
                                while (i < n) {
                                    array[j] = Convert.unpackX(buf1, i * 8);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 76: {
                                while (i < n) {
                                    array[j] = Convert.unpackL(buf1, i * 4);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 73: {
                                while (i < n) {
                                    array[j] = Convert.unpackI(buf1, i * 2);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 66: {
                                while (i < n) {
                                    array[j] = buf1[i];
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 78: {
                                while (i < n) {
                                    array[j] = Convert.unpackN(buf1, i);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 80: {
                                while (i < n) {
                                    array[j] = Convert.unpackP(buf1, i);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            default: {
                                status = -1;
                                break;
                            }
                        }
                        break block423;
                    }
                    case 88: {
                        long[] array = (long[])buf2;
                        switch (type) {
                            case -81: {
                                while (i < n) {
                                    array[j] = (long)Double.longBitsToDouble(Convert.unpackX(buf1, i * 8));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -82: {
                                while (i < n) {
                                    array[j] = (long)Math.ceil(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -83: {
                                while (i < n) {
                                    array[j] = (long)Math.floor(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -84: {
                                while (i < n) {
                                    array[j] = (long)Math.rint(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -86: {
                                while (i < n) {
                                    array[j] = (long)Math.floor(0.5 + Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -87: {
                                while (i < n) {
                                    array[j] = (long)Convert.lround(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -41: {
                                while (i < n) {
                                    array[j] = (long)Float.intBitsToFloat(Convert.unpackL(buf1, i * 4));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -42: {
                                while (i < n) {
                                    array[j] = (long)Math.ceil(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -43: {
                                while (i < n) {
                                    array[j] = (long)Math.floor(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -44: {
                                while (i < n) {
                                    array[j] = (long)Math.rint(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -46: {
                                while (i < n) {
                                    array[j] = (long)Math.floor(0.5 + (double)Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -47: {
                                while (i < n) {
                                    array[j] = (long)Convert.lround(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 88: {
                                while (i < n) {
                                    array[j] = Convert.unpackX(buf1, i * 8);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 76: {
                                while (i < n) {
                                    array[j] = Convert.unpackL(buf1, i * 4);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 73: {
                                while (i < n) {
                                    array[j] = Convert.unpackI(buf1, i * 2);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 66: {
                                while (i < n) {
                                    array[j] = buf1[i];
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 78: {
                                while (i < n) {
                                    array[j] = Convert.unpackN(buf1, i);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 80: {
                                while (i < n) {
                                    array[j] = Convert.unpackP(buf1, i);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            default: {
                                status = -1;
                                break;
                            }
                        }
                        break block423;
                    }
                    case 76: {
                        int[] array = (int[])buf2;
                        switch (type) {
                            case -81: {
                                while (i < n) {
                                    array[j] = (int)Double.longBitsToDouble(Convert.unpackX(buf1, i * 8));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -82: {
                                while (i < n) {
                                    array[j] = (int)Math.ceil(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -83: {
                                while (i < n) {
                                    array[j] = (int)Math.floor(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -84: {
                                while (i < n) {
                                    array[j] = (int)Math.rint(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -86: {
                                while (i < n) {
                                    array[j] = (int)Math.floor(0.5 + Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -87: {
                                while (i < n) {
                                    array[j] = (int)Convert.lround(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -41: {
                                while (i < n) {
                                    array[j] = (int)Float.intBitsToFloat(Convert.unpackL(buf1, i * 4));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -42: {
                                while (i < n) {
                                    array[j] = (int)Math.ceil(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -43: {
                                while (i < n) {
                                    array[j] = (int)Math.floor(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -44: {
                                while (i < n) {
                                    array[j] = (int)Math.rint(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -46: {
                                while (i < n) {
                                    array[j] = (int)Math.floor(0.5 + (double)Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -47: {
                                while (i < n) {
                                    array[j] = (int)Convert.lround(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 88: {
                                while (i < n) {
                                    array[j] = Convert.n2i_sat(Convert.unpackX(buf1, i * 8));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 76: {
                                while (i < n) {
                                    array[j] = Convert.unpackL(buf1, i * 4);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 73: {
                                while (i < n) {
                                    array[j] = Convert.unpackI(buf1, i * 2);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 66: {
                                while (i < n) {
                                    array[j] = buf1[i];
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 78: {
                                while (i < n) {
                                    array[j] = Convert.unpackN(buf1, i);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 80: {
                                while (i < n) {
                                    array[j] = Convert.unpackP(buf1, i);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            default: {
                                status = -1;
                                break;
                            }
                        }
                        break block423;
                    }
                    case 73: {
                        short[] array = (short[])buf2;
                        switch (type) {
                            case -81: {
                                while (i < n) {
                                    array[j] = Convert.n2i_sat(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -82: {
                                while (i < n) {
                                    array[j] = Convert.n2i_sat(Math.ceil(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8))));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -83: {
                                while (i < n) {
                                    array[j] = Convert.n2i_sat(Math.floor(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8))));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -84: {
                                while (i < n) {
                                    array[j] = Convert.n2i_sat(Math.rint(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8))));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -86: {
                                while (i < n) {
                                    array[j] = Convert.n2i_sat(Math.floor(0.5 + Double.longBitsToDouble(Convert.unpackX(buf1, i * 8))));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -87: {
                                while (i < n) {
                                    array[j] = Convert.n2i_sat(Convert.lround(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8))));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -41: {
                                while (i < n) {
                                    array[j] = Convert.n2i_sat(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -42: {
                                while (i < n) {
                                    array[j] = Convert.n2i_sat(Math.ceil(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4))));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -43: {
                                while (i < n) {
                                    array[j] = Convert.n2i_sat(Math.floor(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4))));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -44: {
                                while (i < n) {
                                    array[j] = Convert.n2i_sat(Math.rint(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4))));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -46: {
                                while (i < n) {
                                    array[j] = Convert.n2i_sat(Math.floor(0.5 + (double)Float.intBitsToFloat(Convert.unpackL(buf1, i * 4))));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -47: {
                                while (i < n) {
                                    array[j] = Convert.n2i_sat(Convert.lround(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4))));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 88: {
                                while (i < n) {
                                    array[j] = Convert.n2i_sat(Convert.unpackX(buf1, i * 8));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 76: {
                                while (i < n) {
                                    array[j] = Convert.n2i_sat(Convert.unpackL(buf1, i * 4));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 73: {
                                while (i < n) {
                                    array[j] = Convert.unpackI(buf1, i * 2);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 66: {
                                while (i < n) {
                                    array[j] = buf1[i];
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 78: {
                                while (i < n) {
                                    array[j] = Convert.unpackN(buf1, i);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 80: {
                                while (i < n) {
                                    array[j] = Convert.unpackP(buf1, i);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            default: {
                                status = -1;
                                break;
                            }
                        }
                        break block423;
                    }
                    case 66: {
                        byte[] array = (byte[])buf2;
                        switch (type) {
                            case -81: {
                                while (i < n) {
                                    array[j] = Convert.n2b_sat(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -82: {
                                while (i < n) {
                                    array[j] = Convert.n2b_sat(Math.ceil(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8))));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -83: {
                                while (i < n) {
                                    array[j] = Convert.n2b_sat(Math.floor(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8))));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -84: {
                                while (i < n) {
                                    array[j] = Convert.n2b_sat(Math.rint(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8))));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -86: {
                                while (i < n) {
                                    array[j] = Convert.n2b_sat(Math.floor(0.5 + Double.longBitsToDouble(Convert.unpackX(buf1, i * 8))));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -87: {
                                while (i < n) {
                                    array[j] = Convert.n2b_sat(Convert.lround(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8))));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -41: {
                                while (i < n) {
                                    array[j] = Convert.n2b_sat(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -42: {
                                while (i < n) {
                                    array[j] = Convert.n2b_sat(Math.ceil(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4))));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -43: {
                                while (i < n) {
                                    array[j] = Convert.n2b_sat(Math.floor(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4))));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -44: {
                                while (i < n) {
                                    array[j] = Convert.n2b_sat(Math.rint(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4))));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -46: {
                                while (i < n) {
                                    array[j] = Convert.n2b_sat(Math.floor(0.5 + (double)Float.intBitsToFloat(Convert.unpackL(buf1, i * 4))));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case -47: {
                                while (i < n) {
                                    array[j] = Convert.n2b_sat(Convert.lround(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4))));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 88: {
                                while (i < n) {
                                    array[j] = Convert.n2b_sat(Convert.unpackX(buf1, i * 8));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 76: {
                                while (i < n) {
                                    array[j] = Convert.n2b_sat(Convert.unpackL(buf1, i * 4));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 73: {
                                while (i < n) {
                                    array[j] = Convert.n2b_sat(Convert.unpackI(buf1, i * 2));
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 66: {
                                while (i < n) {
                                    array[j] = buf1[i];
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 78: {
                                while (i < n) {
                                    array[j] = Convert.unpackN(buf1, i);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            case 80: {
                                while (i < n) {
                                    array[j] = Convert.unpackP(buf1, i);
                                    ++i;
                                    ++j;
                                }
                                break block423;
                            }
                            default: {
                                status = -1;
                                break;
                            }
                        }
                        break block423;
                    }
                    case 78: {
                        throw new ClassCastException("Convert: Can not convert " + buf2.getClass() + " to nibble[].");
                    }
                    case 80: {
                        throw new ClassCastException("Convert: Can not convert " + buf2.getClass() + " to packed[].");
                    }
                    default: {
                        status = -1;
                        break;
                    }
                }
                break block423;
            }
            block128 : switch (type2) {
                case 68: {
                    double[] array = (double[])buf2;
                    switch (type1) {
                        case 68: {
                            while (i < n) {
                                array[j] = Double.longBitsToDouble(Convert.unpackX(buf1, i * 8));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 70: {
                            while (i < n) {
                                array[j] = Float.intBitsToFloat(Convert.unpackL(buf1, i * 4));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 88: {
                            while (i < n) {
                                array[j] = Convert.unpackX(buf1, i * 8);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 76: {
                            while (i < n) {
                                array[j] = Convert.unpackL(buf1, i * 4);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 73: {
                            while (i < n) {
                                array[j] = Convert.unpackI(buf1, i * 2);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 66: {
                            while (i < n) {
                                array[j] = buf1[i];
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 78: {
                            while (i < n) {
                                array[j] = Convert.unpackN(buf1, i);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 80: {
                            while (i < n) {
                                array[j] = Convert.unpackP(buf1, i);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 70: {
                    float[] array = (float[])buf2;
                    switch (type1) {
                        case 68: {
                            while (i < n) {
                                array[j] = (float)Double.longBitsToDouble(Convert.unpackX(buf1, i * 8));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 70: {
                            while (i < n) {
                                array[j] = Float.intBitsToFloat(Convert.unpackL(buf1, i * 4));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 88: {
                            while (i < n) {
                                array[j] = Convert.unpackX(buf1, i * 8);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 76: {
                            while (i < n) {
                                array[j] = Convert.unpackL(buf1, i * 4);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 73: {
                            while (i < n) {
                                array[j] = Convert.unpackI(buf1, i * 2);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 66: {
                            while (i < n) {
                                array[j] = buf1[i];
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 78: {
                            while (i < n) {
                                array[j] = Convert.unpackN(buf1, i);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 80: {
                            while (i < n) {
                                array[j] = Convert.unpackP(buf1, i);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 88: {
                    long[] array = (long[])buf2;
                    switch (type) {
                        case -81: {
                            while (i < n) {
                                array[j] = (long)Double.longBitsToDouble(Convert.unpackX(buf1, i * 8));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -82: {
                            while (i < n) {
                                array[j] = (long)Math.ceil(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -83: {
                            while (i < n) {
                                array[j] = (long)Math.floor(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -84: {
                            while (i < n) {
                                array[j] = (long)Math.rint(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -86: {
                            while (i < n) {
                                array[j] = (long)Math.floor(0.5 + Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -87: {
                            while (i < n) {
                                array[j] = (long)Convert.lround(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -41: {
                            while (i < n) {
                                array[j] = (long)Float.intBitsToFloat(Convert.unpackL(buf1, i * 4));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -42: {
                            while (i < n) {
                                array[j] = (long)Math.ceil(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -43: {
                            while (i < n) {
                                array[j] = (long)Math.floor(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -44: {
                            while (i < n) {
                                array[j] = (long)Math.rint(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -46: {
                            while (i < n) {
                                array[j] = (long)Math.floor(0.5 + (double)Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -47: {
                            while (i < n) {
                                array[j] = (long)Convert.lround(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 88: {
                            while (i < n) {
                                array[j] = Convert.unpackX(buf1, i * 8);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 76: {
                            while (i < n) {
                                array[j] = Convert.unpackL(buf1, i * 4);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 73: {
                            while (i < n) {
                                array[j] = Convert.unpackI(buf1, i * 2);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 66: {
                            while (i < n) {
                                array[j] = buf1[i];
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 78: {
                            while (i < n) {
                                array[j] = Convert.unpackN(buf1, i);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 80: {
                            while (i < n) {
                                array[j] = Convert.unpackP(buf1, i);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 76: {
                    int[] array = (int[])buf2;
                    switch (type) {
                        case -81: {
                            while (i < n) {
                                array[j] = (int)Double.longBitsToDouble(Convert.unpackX(buf1, i * 8));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -82: {
                            while (i < n) {
                                array[j] = (int)Math.ceil(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -83: {
                            while (i < n) {
                                array[j] = (int)Math.floor(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -84: {
                            while (i < n) {
                                array[j] = (int)Math.rint(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -86: {
                            while (i < n) {
                                array[j] = (int)Math.floor(0.5 + Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -87: {
                            while (i < n) {
                                array[j] = (int)Convert.lround(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -41: {
                            while (i < n) {
                                array[j] = (int)Float.intBitsToFloat(Convert.unpackL(buf1, i * 4));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -42: {
                            while (i < n) {
                                array[j] = (int)Math.ceil(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -43: {
                            while (i < n) {
                                array[j] = (int)Math.floor(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -44: {
                            while (i < n) {
                                array[j] = (int)Math.rint(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -46: {
                            while (i < n) {
                                array[j] = (int)Math.floor(0.5 + (double)Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -47: {
                            while (i < n) {
                                array[j] = (int)Convert.lround(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 88: {
                            while (i < n) {
                                array[j] = (int)Convert.unpackX(buf1, i * 8);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 76: {
                            while (i < n) {
                                array[j] = Convert.unpackL(buf1, i * 4);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 73: {
                            while (i < n) {
                                array[j] = Convert.unpackI(buf1, i * 2);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 66: {
                            while (i < n) {
                                array[j] = buf1[i];
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 78: {
                            while (i < n) {
                                array[j] = Convert.unpackN(buf1, i);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 80: {
                            while (i < n) {
                                array[j] = Convert.unpackP(buf1, i);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 73: {
                    short[] array = (short[])buf2;
                    switch (type) {
                        case -81: {
                            while (i < n) {
                                array[j] = (short)Double.longBitsToDouble(Convert.unpackX(buf1, i * 8));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -82: {
                            while (i < n) {
                                array[j] = (short)Math.ceil(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -83: {
                            while (i < n) {
                                array[j] = (short)Math.floor(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -84: {
                            while (i < n) {
                                array[j] = (short)Math.rint(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -86: {
                            while (i < n) {
                                array[j] = (short)Math.floor(0.5 + Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -87: {
                            while (i < n) {
                                array[j] = (short)Convert.lround(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -41: {
                            while (i < n) {
                                array[j] = (short)Float.intBitsToFloat(Convert.unpackL(buf1, i * 4));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -42: {
                            while (i < n) {
                                array[j] = (short)Math.ceil(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -43: {
                            while (i < n) {
                                array[j] = (short)Math.floor(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -44: {
                            while (i < n) {
                                array[j] = (short)Math.rint(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -46: {
                            while (i < n) {
                                array[j] = (short)Math.floor(0.5 + (double)Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -47: {
                            while (i < n) {
                                array[j] = (short)Convert.lround(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 88: {
                            while (i < n) {
                                array[j] = (short)Convert.unpackX(buf1, i * 8);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 76: {
                            while (i < n) {
                                array[j] = (short)Convert.unpackL(buf1, i * 4);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 73: {
                            while (i < n) {
                                array[j] = Convert.unpackI(buf1, i * 2);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 66: {
                            while (i < n) {
                                array[j] = buf1[i];
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 78: {
                            while (i < n) {
                                array[j] = Convert.unpackN(buf1, i);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 80: {
                            while (i < n) {
                                array[j] = Convert.unpackP(buf1, i);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 66: {
                    byte[] array = (byte[])buf2;
                    switch (type) {
                        case -81: {
                            while (i < n) {
                                array[j] = (byte)Double.longBitsToDouble(Convert.unpackX(buf1, i * 8));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -82: {
                            while (i < n) {
                                array[j] = (byte)Math.ceil(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -83: {
                            while (i < n) {
                                array[j] = (byte)Math.floor(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -84: {
                            while (i < n) {
                                array[j] = (byte)Math.rint(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -86: {
                            while (i < n) {
                                array[j] = (byte)Math.floor(0.5 + Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -87: {
                            while (i < n) {
                                array[j] = (byte)Convert.lround(Double.longBitsToDouble(Convert.unpackX(buf1, i * 8)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -41: {
                            while (i < n) {
                                array[j] = (byte)Float.intBitsToFloat(Convert.unpackL(buf1, i * 4));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -42: {
                            while (i < n) {
                                array[j] = (byte)Math.ceil(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -43: {
                            while (i < n) {
                                array[j] = (byte)Math.floor(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -44: {
                            while (i < n) {
                                array[j] = (byte)Math.rint(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -46: {
                            while (i < n) {
                                array[j] = (byte)Math.floor(0.5 + (double)Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case -47: {
                            while (i < n) {
                                array[j] = (byte)Convert.lround(Float.intBitsToFloat(Convert.unpackL(buf1, i * 4)));
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 88: {
                            while (i < n) {
                                array[j] = (byte)Convert.unpackX(buf1, i * 8);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 76: {
                            while (i < n) {
                                array[j] = (byte)Convert.unpackL(buf1, i * 4);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 73: {
                            while (i < n) {
                                array[j] = (byte)Convert.unpackI(buf1, i * 2);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 66: {
                            while (i < n) {
                                array[j] = buf1[i];
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 78: {
                            while (i < n) {
                                array[j] = Convert.unpackN(buf1, i);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        case 80: {
                            while (i < n) {
                                array[j] = Convert.unpackP(buf1, i);
                                ++i;
                                ++j;
                            }
                            break block128;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 78: {
                    throw new ClassCastException("Convert: Can not convert " + buf2.getClass() + " to nibble[].");
                }
                case 80: {
                    throw new ClassCastException("Convert: Can not convert " + buf2.getClass() + " to packed[].");
                }
                default: {
                    status = -1;
                }
            }
        }
        if (status < 0) {
            Shell.warning("ERROR: bb2ja(..) Unknown conversion " + (char)type1 + "->" + (char)type2);
        }
    }

    public static void ja2bb(Object buf1, int off1, byte type1, byte[] buf2, int off2, byte type2, int n, int round, boolean saturating) {
        int off2orig;
        byte[] buf2orig;
        byte type2s;
        int status;
        block639: {
            Object[] array;
            int j;
            int i;
            block638: {
                if (type1 == 72 || type2 == 72) {
                    throw new MidasException("Cannot convert non-homogeneous Java array to typed buffer for " + (char)type1 + "->" + (char)type2 + " conversion not supported.");
                }
                if (Native.useConvert && n > 1 && Native.type(buf1, off1, type1, buf2, off2, type2, n, round, saturating) == 0) {
                    return;
                }
                i = off1;
                j = off2;
                status = n += off1;
                type2s = type2;
                buf2orig = buf2;
                off2orig = off2;
                if (type2 == 74) {
                    type2 = (byte)73;
                    buf2 = new byte[buf2.length * 4 / 3];
                    off2 = 0;
                }
                if (round == 7 && (type2 != 70 || type2 == 68)) {
                    round = 1;
                }
                if (!saturating) break block638;
                switch (type1) {
                    case 68: {
                        array = (double[])buf1;
                        switch (round) {
                            case 1: {
                                switch (type2) {
                                    case 68: {
                                        while (i < n) {
                                            Convert.packD(buf2, j * 8, array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 70: {
                                        while (i < n) {
                                            Convert.packF(buf2, j * 4, (float)array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 88: {
                                        while (i < n) {
                                            Convert.packX(buf2, j * 8, (long)array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 76: {
                                        while (i < n) {
                                            Convert.packL(buf2, j * 4, (int)array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 73: {
                                        while (i < n) {
                                            Convert.packI(buf2, j * 2, Convert.n2i_sat(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 66: {
                                        while (i < n) {
                                            buf2[j] = Convert.n2b_sat(array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 78: {
                                        while (i < n) {
                                            Convert.packN(buf2, j, Convert.d2n_sat(array[j]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 80: {
                                        while (i < n) {
                                            Convert.packP(buf2, j, Convert.n2b_sat(array[j]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    default: {
                                        status = -1;
                                        break;
                                    }
                                }
                                break block639;
                            }
                            case 2: {
                                switch (type2) {
                                    case 68: {
                                        while (i < n) {
                                            Convert.packD(buf2, j * 8, array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 70: {
                                        while (i < n) {
                                            Convert.packF(buf2, j * 4, (float)array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 88: {
                                        while (i < n) {
                                            Convert.packX(buf2, j * 8, (long)Math.ceil(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 76: {
                                        while (i < n) {
                                            Convert.packL(buf2, j * 4, (int)Math.ceil(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 73: {
                                        while (i < n) {
                                            Convert.packI(buf2, j * 2, Convert.n2i_sat(Math.ceil(array[i])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 66: {
                                        while (i < n) {
                                            buf2[j] = Convert.n2b_sat(Math.ceil(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 78: {
                                        while (i < n) {
                                            Convert.packN(buf2, j, Convert.d2n_sat(Math.ceil(array[j])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 80: {
                                        while (i < n) {
                                            Convert.packP(buf2, j, Convert.n2b_sat(Math.ceil(array[j])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    default: {
                                        status = -1;
                                        break;
                                    }
                                }
                                break block639;
                            }
                            case 3: {
                                switch (type2) {
                                    case 68: {
                                        while (i < n) {
                                            Convert.packD(buf2, j * 8, array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 70: {
                                        while (i < n) {
                                            Convert.packF(buf2, j * 4, (float)array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 88: {
                                        while (i < n) {
                                            Convert.packX(buf2, j * 8, (long)Math.floor(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 76: {
                                        while (i < n) {
                                            Convert.packL(buf2, j * 4, (int)Math.floor(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 73: {
                                        while (i < n) {
                                            Convert.packI(buf2, j * 2, Convert.n2i_sat(Math.floor(array[i])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 66: {
                                        while (i < n) {
                                            buf2[j] = Convert.n2b_sat(Math.floor(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 78: {
                                        while (i < n) {
                                            Convert.packN(buf2, j, Convert.d2n_sat(Math.floor(array[j])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 80: {
                                        while (i < n) {
                                            Convert.packP(buf2, j, Convert.n2b_sat(Math.floor(array[j])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    default: {
                                        status = -1;
                                        break;
                                    }
                                }
                                break block639;
                            }
                            case 6: {
                                switch (type2) {
                                    case 68: {
                                        while (i < n) {
                                            Convert.packD(buf2, j * 8, array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 70: {
                                        while (i < n) {
                                            Convert.packF(buf2, j * 4, (float)array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 88: {
                                        while (i < n) {
                                            Convert.packX(buf2, j * 8, (long)Math.rint(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 76: {
                                        while (i < n) {
                                            Convert.packL(buf2, j * 4, (int)Math.rint(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 73: {
                                        while (i < n) {
                                            Convert.packI(buf2, j * 2, Convert.n2i_sat(Math.rint(array[i])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 66: {
                                        while (i < n) {
                                            buf2[j] = Convert.n2b_sat(Math.rint(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 78: {
                                        while (i < n) {
                                            Convert.packN(buf2, j, Convert.d2n_sat(Math.rint(array[j])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 80: {
                                        while (i < n) {
                                            Convert.packP(buf2, j, Convert.n2b_sat(Math.rint(array[j])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    default: {
                                        status = -1;
                                        break;
                                    }
                                }
                                break block639;
                            }
                            case -1: {
                                switch (type2) {
                                    case 68: {
                                        while (i < n) {
                                            Convert.packD(buf2, j * 8, array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 70: {
                                        while (i < n) {
                                            Convert.packF(buf2, j * 4, (float)array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 88: {
                                        while (i < n) {
                                            Convert.packX(buf2, j * 8, (long)Math.floor(0.5 + array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 76: {
                                        while (i < n) {
                                            Convert.packL(buf2, j * 4, (int)Math.floor(0.5 + array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 73: {
                                        while (i < n) {
                                            Convert.packI(buf2, j * 2, Convert.n2i_sat(Math.floor(0.5 + array[i])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 66: {
                                        while (i < n) {
                                            buf2[j] = Convert.n2b_sat(Math.floor(0.5 + array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 78: {
                                        while (i < n) {
                                            Convert.packN(buf2, j, Convert.d2n_sat(Math.floor(0.5 + array[j])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 80: {
                                        while (i < n) {
                                            Convert.packP(buf2, j, Convert.n2b_sat(Math.floor(0.5 + array[j])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    default: {
                                        status = -1;
                                        break;
                                    }
                                }
                                break block639;
                            }
                            case 4: {
                                switch (type2) {
                                    case 68: {
                                        while (i < n) {
                                            Convert.packD(buf2, j * 8, array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 70: {
                                        while (i < n) {
                                            Convert.packF(buf2, j * 4, (float)array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 88: {
                                        while (i < n) {
                                            Convert.packX(buf2, j * 8, (long)Convert.lround(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 76: {
                                        while (i < n) {
                                            Convert.packL(buf2, j * 4, (int)Convert.lround(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 73: {
                                        while (i < n) {
                                            Convert.packI(buf2, j * 2, Convert.n2i_sat(Convert.lround(array[i])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 66: {
                                        while (i < n) {
                                            buf2[j] = Convert.n2b_sat(Convert.lround(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 78: {
                                        while (i < n) {
                                            Convert.packN(buf2, j, Convert.d2n_sat(Convert.lround(array[j])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 80: {
                                        while (i < n) {
                                            Convert.packP(buf2, j, Convert.n2b_sat(Convert.lround(array[j])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    default: {
                                        status = -1;
                                        break;
                                    }
                                }
                                break block639;
                            }
                            case 7: {
                                throw new ArithmeticException("Can not use ROUND_UNNECESSARY for " + (char)type1 + "->" + (char)type2 + " conversion.");
                            }
                            default: {
                                throw new IllegalArgumentException("Illegal rounding mode " + round + " for " + (char)type1 + "->" + (char)type2 + " conversion.");
                            }
                        }
                    }
                    case 70: {
                        array = (float[])buf1;
                        switch (round) {
                            case 1: {
                                switch (type2) {
                                    case 68: {
                                        while (i < n) {
                                            Convert.packD(buf2, j * 8, array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 70: {
                                        while (i < n) {
                                            Convert.packF(buf2, j * 4, (float)array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 88: {
                                        while (i < n) {
                                            Convert.packX(buf2, j * 8, (long)array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 76: {
                                        while (i < n) {
                                            Convert.packL(buf2, j * 4, (int)array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 73: {
                                        while (i < n) {
                                            Convert.packI(buf2, j * 2, Convert.n2i_sat((float)array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 66: {
                                        while (i < n) {
                                            buf2[j] = Convert.n2b_sat((float)array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 78: {
                                        while (i < n) {
                                            Convert.packN(buf2, j, Convert.f2n_sat((float)array[j]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 80: {
                                        while (i < n) {
                                            Convert.packP(buf2, j, Convert.n2b_sat((float)array[j]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    default: {
                                        status = -1;
                                        break;
                                    }
                                }
                                break block639;
                            }
                            case 2: {
                                switch (type2) {
                                    case 68: {
                                        while (i < n) {
                                            Convert.packD(buf2, j * 8, array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 70: {
                                        while (i < n) {
                                            Convert.packF(buf2, j * 4, (float)array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 88: {
                                        while (i < n) {
                                            Convert.packX(buf2, j * 8, (long)Math.ceil(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 76: {
                                        while (i < n) {
                                            Convert.packL(buf2, j * 4, (int)Math.ceil(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 73: {
                                        while (i < n) {
                                            Convert.packI(buf2, j * 2, Convert.n2i_sat(Math.ceil(array[i])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 66: {
                                        while (i < n) {
                                            buf2[j] = Convert.n2b_sat(Math.ceil(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 78: {
                                        while (i < n) {
                                            Convert.packN(buf2, j, Convert.d2n_sat(Math.ceil(array[j])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 80: {
                                        while (i < n) {
                                            Convert.packP(buf2, j, Convert.n2b_sat(Math.ceil(array[j])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    default: {
                                        status = -1;
                                        break;
                                    }
                                }
                                break block639;
                            }
                            case 3: {
                                switch (type2) {
                                    case 68: {
                                        while (i < n) {
                                            Convert.packD(buf2, j * 8, array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 70: {
                                        while (i < n) {
                                            Convert.packF(buf2, j * 4, (float)array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 88: {
                                        while (i < n) {
                                            Convert.packX(buf2, j * 8, (long)Math.floor(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 76: {
                                        while (i < n) {
                                            Convert.packL(buf2, j * 4, (int)Math.floor(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 73: {
                                        while (i < n) {
                                            Convert.packI(buf2, j * 2, Convert.n2i_sat(Math.floor(array[i])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 66: {
                                        while (i < n) {
                                            buf2[j] = Convert.n2b_sat(Math.floor(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 78: {
                                        while (i < n) {
                                            Convert.packN(buf2, j, Convert.d2n_sat(Math.floor(array[j])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 80: {
                                        while (i < n) {
                                            Convert.packP(buf2, j, Convert.n2b_sat(Math.floor(array[j])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    default: {
                                        status = -1;
                                        break;
                                    }
                                }
                                break block639;
                            }
                            case 6: {
                                switch (type2) {
                                    case 68: {
                                        while (i < n) {
                                            Convert.packD(buf2, j * 8, array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 70: {
                                        while (i < n) {
                                            Convert.packF(buf2, j * 4, (float)array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 88: {
                                        while (i < n) {
                                            Convert.packX(buf2, j * 8, (long)Math.rint(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 76: {
                                        while (i < n) {
                                            Convert.packL(buf2, j * 4, (int)Math.rint(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 73: {
                                        while (i < n) {
                                            Convert.packI(buf2, j * 2, Convert.n2i_sat(Math.rint(array[i])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 66: {
                                        while (i < n) {
                                            buf2[j] = Convert.n2b_sat(Math.rint(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 78: {
                                        while (i < n) {
                                            Convert.packN(buf2, j, Convert.d2n_sat(Math.rint(array[j])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 80: {
                                        while (i < n) {
                                            Convert.packP(buf2, j, Convert.n2b_sat(Math.rint(array[j])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    default: {
                                        status = -1;
                                        break;
                                    }
                                }
                                break block639;
                            }
                            case -1: {
                                switch (type2) {
                                    case 68: {
                                        while (i < n) {
                                            Convert.packD(buf2, j * 8, array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 70: {
                                        while (i < n) {
                                            Convert.packF(buf2, j * 4, (float)array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 88: {
                                        while (i < n) {
                                            Convert.packX(buf2, j * 8, (long)Math.floor(0.5 + (double)array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 76: {
                                        while (i < n) {
                                            Convert.packL(buf2, j * 4, (int)Math.floor(0.5 + (double)array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 73: {
                                        while (i < n) {
                                            Convert.packI(buf2, j * 2, Convert.n2i_sat(Math.floor(0.5 + (double)array[i])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 66: {
                                        while (i < n) {
                                            buf2[j] = Convert.n2b_sat(Math.floor(0.5 + (double)array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 78: {
                                        while (i < n) {
                                            Convert.packN(buf2, j, Convert.d2n_sat(Math.floor(0.5 + (double)array[j])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 80: {
                                        while (i < n) {
                                            Convert.packP(buf2, j, Convert.n2b_sat(Math.floor(0.5 + (double)array[j])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    default: {
                                        status = -1;
                                        break;
                                    }
                                }
                                break block639;
                            }
                            case 4: {
                                switch (type2) {
                                    case 68: {
                                        while (i < n) {
                                            Convert.packD(buf2, j * 8, array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 70: {
                                        while (i < n) {
                                            Convert.packF(buf2, j * 4, (float)array[i]);
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 88: {
                                        while (i < n) {
                                            Convert.packX(buf2, j * 8, (long)Convert.lround(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 76: {
                                        while (i < n) {
                                            Convert.packL(buf2, j * 4, (int)Convert.lround(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 73: {
                                        while (i < n) {
                                            Convert.packI(buf2, j * 2, Convert.n2i_sat(Convert.lround(array[i])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 66: {
                                        while (i < n) {
                                            buf2[j] = Convert.n2b_sat(Convert.lround(array[i]));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 78: {
                                        while (i < n) {
                                            Convert.packN(buf2, j, Convert.d2n_sat(Convert.lround(array[j])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    case 80: {
                                        while (i < n) {
                                            Convert.packP(buf2, j, Convert.n2b_sat(Convert.lround(array[j])));
                                            ++i;
                                            ++j;
                                        }
                                        break block639;
                                    }
                                    default: {
                                        status = -1;
                                        break;
                                    }
                                }
                                break block639;
                            }
                            case 7: {
                                throw new ArithmeticException("Can not use ROUND_UNNECESSARY for " + (char)type1 + "->" + (char)type2 + " conversion.");
                            }
                            default: {
                                throw new IllegalArgumentException("Illegal rounding mode " + round + " for " + (char)type1 + "->" + (char)type2 + " conversion.");
                            }
                        }
                    }
                    case 88: {
                        array = (long[])buf1;
                        switch (type2) {
                            case 68: {
                                while (i < n) {
                                    Convert.packD(buf2, j * 8, array[i]);
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 70: {
                                while (i < n) {
                                    Convert.packF(buf2, j * 4, (float)array[i]);
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 88: {
                                while (i < n) {
                                    Convert.packX(buf2, j * 8, (long)array[i]);
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 76: {
                                while (i < n) {
                                    Convert.packL(buf2, j * 4, Convert.n2l_sat((long)array[i]));
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 73: {
                                while (i < n) {
                                    Convert.packI(buf2, j * 2, Convert.n2i_sat((long)array[i]));
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 66: {
                                while (i < n) {
                                    buf2[j] = Convert.n2b_sat((long)array[i]);
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 78: {
                                while (i < n) {
                                    Convert.packN(buf2, j, Convert.x2n_sat((long)array[j]));
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 80: {
                                while (i < n) {
                                    Convert.packP(buf2, j, Convert.n2b_sat((long)array[j]));
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            default: {
                                status = -1;
                                break;
                            }
                        }
                        break block639;
                    }
                    case 76: {
                        array = (int[])buf1;
                        switch (type2) {
                            case 68: {
                                while (i < n) {
                                    Convert.packD(buf2, j * 8, array[i]);
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 70: {
                                while (i < n) {
                                    Convert.packF(buf2, j * 4, (float)array[i]);
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 88: {
                                while (i < n) {
                                    Convert.packX(buf2, j * 8, (long)array[i]);
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 76: {
                                while (i < n) {
                                    Convert.packL(buf2, j * 4, (int)array[i]);
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 73: {
                                while (i < n) {
                                    Convert.packI(buf2, j * 2, Convert.n2i_sat((int)array[i]));
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 66: {
                                while (i < n) {
                                    buf2[j] = Convert.n2b_sat((int)array[i]);
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 78: {
                                while (i < n) {
                                    Convert.packN(buf2, j, Convert.l2n_sat((int)array[j]));
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 80: {
                                while (i < n) {
                                    Convert.packP(buf2, j, Convert.n2b_sat((int)array[j]));
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            default: {
                                status = -1;
                                break;
                            }
                        }
                        break block639;
                    }
                    case 73: {
                        array = (short[])buf1;
                        switch (type2) {
                            case 68: {
                                while (i < n) {
                                    Convert.packD(buf2, j * 8, array[i]);
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 70: {
                                while (i < n) {
                                    Convert.packF(buf2, j * 4, (float)array[i]);
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 88: {
                                while (i < n) {
                                    Convert.packX(buf2, j * 8, (long)array[i]);
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 76: {
                                while (i < n) {
                                    Convert.packL(buf2, j * 4, (int)array[i]);
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 73: {
                                while (i < n) {
                                    Convert.packI(buf2, j * 2, (short)array[i]);
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 66: {
                                while (i < n) {
                                    buf2[j] = Convert.n2b_sat((short)array[i]);
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 78: {
                                while (i < n) {
                                    Convert.packN(buf2, j, Convert.i2n_sat((short)array[j]));
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 80: {
                                while (i < n) {
                                    Convert.packP(buf2, j, Convert.n2b_sat((short)array[j]));
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            default: {
                                status = -1;
                                break;
                            }
                        }
                        break block639;
                    }
                    case 66: {
                        array = (byte[])buf1;
                        switch (type2) {
                            case 68: {
                                while (i < n) {
                                    Convert.packD(buf2, j * 8, array[i]);
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 70: {
                                while (i < n) {
                                    Convert.packF(buf2, j * 4, (float)array[i]);
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 88: {
                                while (i < n) {
                                    Convert.packX(buf2, j * 8, (long)array[i]);
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 76: {
                                while (i < n) {
                                    Convert.packL(buf2, j * 4, (int)array[i]);
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 73: {
                                while (i < n) {
                                    Convert.packI(buf2, j * 2, (short)array[i]);
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 66: {
                                while (i < n) {
                                    buf2[j] = (byte)array[i];
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 78: {
                                while (i < n) {
                                    Convert.packN(buf2, j, Convert.b2n_sat((byte)array[j]));
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            case 80: {
                                while (i < n) {
                                    Convert.packP(buf2, j, (byte)array[j]);
                                    ++i;
                                    ++j;
                                }
                                break block639;
                            }
                            default: {
                                status = -1;
                                break;
                            }
                        }
                        break block639;
                    }
                    case 78: {
                        throw new ClassCastException("Convert: Can not convert " + buf1.getClass() + " to nibble[].");
                    }
                    case 80: {
                        throw new ClassCastException("Convert: Can not convert " + buf1.getClass() + " to packed[].");
                    }
                    default: {
                        status = -1;
                        break;
                    }
                }
                break block639;
            }
            block188 : switch (type1) {
                case 68: {
                    array = (double[])buf1;
                    switch (round) {
                        case 1: {
                            switch (type2) {
                                case 68: {
                                    while (i < n) {
                                        Convert.packD(buf2, j * 8, array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 70: {
                                    while (i < n) {
                                        Convert.packF(buf2, j * 4, (float)array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 88: {
                                    while (i < n) {
                                        Convert.packX(buf2, j * 8, (long)array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 76: {
                                    while (i < n) {
                                        Convert.packL(buf2, j * 4, (int)array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 73: {
                                    while (i < n) {
                                        Convert.packI(buf2, j * 2, (short)array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 66: {
                                    while (i < n) {
                                        buf2[j] = (byte)array[i];
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 78: {
                                    while (i < n) {
                                        Convert.packN(buf2, j, (byte)array[j]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 80: {
                                    while (i < n) {
                                        Convert.packP(buf2, j, (byte)array[j]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block188;
                        }
                        case 2: {
                            switch (type2) {
                                case 68: {
                                    while (i < n) {
                                        Convert.packD(buf2, j * 8, array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 70: {
                                    while (i < n) {
                                        Convert.packF(buf2, j * 4, (float)array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 88: {
                                    while (i < n) {
                                        Convert.packX(buf2, j * 8, (long)Math.ceil(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 76: {
                                    while (i < n) {
                                        Convert.packL(buf2, j * 4, (int)Math.ceil(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 73: {
                                    while (i < n) {
                                        Convert.packI(buf2, j * 2, (short)Math.ceil(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 66: {
                                    while (i < n) {
                                        buf2[j] = (byte)Math.ceil(array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 78: {
                                    while (i < n) {
                                        Convert.packN(buf2, j, (byte)Math.ceil(array[j]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 80: {
                                    while (i < n) {
                                        Convert.packP(buf2, j, (byte)Math.ceil(array[j]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block188;
                        }
                        case 3: {
                            switch (type2) {
                                case 68: {
                                    while (i < n) {
                                        Convert.packD(buf2, j * 8, array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 70: {
                                    while (i < n) {
                                        Convert.packF(buf2, j * 4, (float)array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 88: {
                                    while (i < n) {
                                        Convert.packX(buf2, j * 8, (long)Math.floor(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 76: {
                                    while (i < n) {
                                        Convert.packL(buf2, j * 4, (int)Math.floor(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 73: {
                                    while (i < n) {
                                        Convert.packI(buf2, j * 2, (short)Math.floor(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 66: {
                                    while (i < n) {
                                        buf2[j] = (byte)Math.floor(array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 78: {
                                    while (i < n) {
                                        Convert.packN(buf2, j, (byte)Math.floor(array[j]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 80: {
                                    while (i < n) {
                                        Convert.packP(buf2, j, (byte)Math.floor(array[j]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block188;
                        }
                        case 6: {
                            switch (type2) {
                                case 68: {
                                    while (i < n) {
                                        Convert.packD(buf2, j * 8, array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 70: {
                                    while (i < n) {
                                        Convert.packF(buf2, j * 4, (float)array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 88: {
                                    while (i < n) {
                                        Convert.packX(buf2, j * 8, (long)Math.rint(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 76: {
                                    while (i < n) {
                                        Convert.packL(buf2, j * 4, (int)Math.rint(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 73: {
                                    while (i < n) {
                                        Convert.packI(buf2, j * 2, (short)Math.rint(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 66: {
                                    while (i < n) {
                                        buf2[j] = (byte)Math.rint(array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 78: {
                                    while (i < n) {
                                        Convert.packN(buf2, j, (byte)Math.rint(array[j]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 80: {
                                    while (i < n) {
                                        Convert.packP(buf2, j, (byte)Math.rint(array[j]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block188;
                        }
                        case -1: {
                            switch (type2) {
                                case 68: {
                                    while (i < n) {
                                        Convert.packD(buf2, j * 8, array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 70: {
                                    while (i < n) {
                                        Convert.packF(buf2, j * 4, (float)array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 88: {
                                    while (i < n) {
                                        Convert.packX(buf2, j * 8, (long)Math.floor(0.5 + array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 76: {
                                    while (i < n) {
                                        Convert.packL(buf2, j * 4, (int)Math.floor(0.5 + array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 73: {
                                    while (i < n) {
                                        Convert.packI(buf2, j * 2, (short)Math.floor(0.5 + array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 66: {
                                    while (i < n) {
                                        buf2[j] = (byte)Math.floor(0.5 + array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 78: {
                                    while (i < n) {
                                        Convert.packN(buf2, j, (byte)Math.floor(0.5 + array[j]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 80: {
                                    while (i < n) {
                                        Convert.packP(buf2, j, (byte)Math.floor(0.5 + array[j]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block188;
                        }
                        case 4: {
                            switch (type2) {
                                case 68: {
                                    while (i < n) {
                                        Convert.packD(buf2, j * 8, array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 70: {
                                    while (i < n) {
                                        Convert.packF(buf2, j * 4, (float)array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 88: {
                                    while (i < n) {
                                        Convert.packX(buf2, j * 8, (long)Convert.lround(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 76: {
                                    while (i < n) {
                                        Convert.packL(buf2, j * 4, (int)Convert.lround(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 73: {
                                    while (i < n) {
                                        Convert.packI(buf2, j * 2, (short)Convert.lround(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 66: {
                                    while (i < n) {
                                        buf2[j] = (byte)Convert.lround(array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 78: {
                                    while (i < n) {
                                        Convert.packN(buf2, j, (byte)Convert.lround(array[j]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 80: {
                                    while (i < n) {
                                        Convert.packP(buf2, j, (byte)Convert.lround(array[j]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block188;
                        }
                        case 7: {
                            throw new ArithmeticException("Can not use ROUND_UNNECESSARY for " + (char)type1 + "->" + (char)type2 + " conversion.");
                        }
                        default: {
                            throw new IllegalArgumentException("Illegal rounding mode " + round + " for " + (char)type1 + "->" + (char)type2 + " conversion.");
                        }
                    }
                }
                case 70: {
                    array = (float[])buf1;
                    switch (round) {
                        case 1: {
                            switch (type2) {
                                case 68: {
                                    while (i < n) {
                                        Convert.packD(buf2, j * 8, array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 70: {
                                    while (i < n) {
                                        Convert.packF(buf2, j * 4, (float)array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 88: {
                                    while (i < n) {
                                        Convert.packX(buf2, j * 8, (long)array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 76: {
                                    while (i < n) {
                                        Convert.packL(buf2, j * 4, (int)array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 73: {
                                    while (i < n) {
                                        Convert.packI(buf2, j * 2, (short)array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 66: {
                                    while (i < n) {
                                        buf2[j] = (byte)array[i];
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 78: {
                                    while (i < n) {
                                        Convert.packN(buf2, j, (byte)array[j]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 80: {
                                    while (i < n) {
                                        Convert.packP(buf2, j, (byte)array[j]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block188;
                        }
                        case 2: {
                            switch (type2) {
                                case 68: {
                                    while (i < n) {
                                        Convert.packD(buf2, j * 8, array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 70: {
                                    while (i < n) {
                                        Convert.packF(buf2, j * 4, (float)array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 88: {
                                    while (i < n) {
                                        Convert.packX(buf2, j * 8, (long)Math.ceil(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 76: {
                                    while (i < n) {
                                        Convert.packL(buf2, j * 4, (int)Math.ceil(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 73: {
                                    while (i < n) {
                                        Convert.packI(buf2, j * 2, (short)Math.ceil(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 66: {
                                    while (i < n) {
                                        buf2[j] = (byte)Math.ceil(array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 78: {
                                    while (i < n) {
                                        Convert.packN(buf2, j, (byte)Math.ceil(array[j]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 80: {
                                    while (i < n) {
                                        Convert.packP(buf2, j, (byte)Math.ceil(array[j]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block188;
                        }
                        case 3: {
                            switch (type2) {
                                case 68: {
                                    while (i < n) {
                                        Convert.packD(buf2, j * 8, array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 70: {
                                    while (i < n) {
                                        Convert.packF(buf2, j * 4, (float)array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 88: {
                                    while (i < n) {
                                        Convert.packX(buf2, j * 8, (long)Math.floor(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 76: {
                                    while (i < n) {
                                        Convert.packL(buf2, j * 4, (int)Math.floor(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 73: {
                                    while (i < n) {
                                        Convert.packI(buf2, j * 2, (short)Math.floor(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 66: {
                                    while (i < n) {
                                        buf2[j] = (byte)Math.floor(array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 78: {
                                    while (i < n) {
                                        Convert.packN(buf2, j, (byte)Math.floor(array[j]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 80: {
                                    while (i < n) {
                                        Convert.packP(buf2, j, (byte)Math.floor(array[j]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block188;
                        }
                        case 6: {
                            switch (type2) {
                                case 68: {
                                    while (i < n) {
                                        Convert.packD(buf2, j * 8, array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 70: {
                                    while (i < n) {
                                        Convert.packF(buf2, j * 4, (float)array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 88: {
                                    while (i < n) {
                                        Convert.packX(buf2, j * 8, (long)Math.rint(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 76: {
                                    while (i < n) {
                                        Convert.packL(buf2, j * 4, (int)Math.rint(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 73: {
                                    while (i < n) {
                                        Convert.packI(buf2, j * 2, (short)Math.rint(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 66: {
                                    while (i < n) {
                                        buf2[j] = (byte)Math.rint(array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 78: {
                                    while (i < n) {
                                        Convert.packN(buf2, j, (byte)Math.rint(array[j]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 80: {
                                    while (i < n) {
                                        Convert.packP(buf2, j, (byte)Math.rint(array[j]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block188;
                        }
                        case -1: {
                            switch (type2) {
                                case 68: {
                                    while (i < n) {
                                        Convert.packD(buf2, j * 8, array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 70: {
                                    while (i < n) {
                                        Convert.packF(buf2, j * 4, (float)array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 88: {
                                    while (i < n) {
                                        Convert.packX(buf2, j * 8, (long)Math.floor(0.5 + (double)array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 76: {
                                    while (i < n) {
                                        Convert.packL(buf2, j * 4, (int)Math.floor(0.5 + (double)array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 73: {
                                    while (i < n) {
                                        Convert.packI(buf2, j * 2, (short)Math.floor(0.5 + (double)array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 66: {
                                    while (i < n) {
                                        buf2[j] = (byte)Math.floor(0.5 + (double)array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 78: {
                                    while (i < n) {
                                        Convert.packN(buf2, j, (byte)Math.floor(0.5 + (double)array[j]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 80: {
                                    while (i < n) {
                                        Convert.packP(buf2, j, (byte)Math.floor(0.5 + (double)array[j]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block188;
                        }
                        case 4: {
                            switch (type2) {
                                case 68: {
                                    while (i < n) {
                                        Convert.packD(buf2, j * 8, array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 70: {
                                    while (i < n) {
                                        Convert.packF(buf2, j * 4, (float)array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 88: {
                                    while (i < n) {
                                        Convert.packX(buf2, j * 8, (long)Convert.lround(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 76: {
                                    while (i < n) {
                                        Convert.packL(buf2, j * 4, (int)Convert.lround(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 73: {
                                    while (i < n) {
                                        Convert.packI(buf2, j * 2, (short)Convert.lround(array[i]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 66: {
                                    while (i < n) {
                                        buf2[j] = (byte)Convert.lround(array[i]);
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 78: {
                                    while (i < n) {
                                        Convert.packN(buf2, j, (byte)Convert.lround(array[j]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                case 80: {
                                    while (i < n) {
                                        Convert.packP(buf2, j, (byte)Convert.lround(array[j]));
                                        ++i;
                                        ++j;
                                    }
                                    break block188;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block188;
                        }
                        case 7: {
                            throw new ArithmeticException("Can not use ROUND_UNNECESSARY for " + (char)type1 + "->" + (char)type2 + " conversion.");
                        }
                        default: {
                            throw new IllegalArgumentException("Illegal rounding mode " + round + " for " + (char)type1 + "->" + (char)type2 + " conversion.");
                        }
                    }
                }
                case 88: {
                    array = (long[])buf1;
                    switch (type2) {
                        case 68: {
                            while (i < n) {
                                Convert.packD(buf2, j * 8, array[i]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 70: {
                            while (i < n) {
                                Convert.packF(buf2, j * 4, (float)array[i]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 88: {
                            while (i < n) {
                                Convert.packX(buf2, j * 8, (long)array[i]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 76: {
                            while (i < n) {
                                Convert.packL(buf2, j * 4, (int)array[i]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 73: {
                            while (i < n) {
                                Convert.packI(buf2, j * 2, (short)array[i]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 66: {
                            while (i < n) {
                                buf2[j] = (byte)array[i];
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 78: {
                            while (i < n) {
                                Convert.packN(buf2, j, (byte)array[j]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 80: {
                            while (i < n) {
                                Convert.packP(buf2, j, (byte)array[j]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 76: {
                    array = (int[])buf1;
                    switch (type2) {
                        case 68: {
                            while (i < n) {
                                Convert.packD(buf2, j * 8, array[i]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 70: {
                            while (i < n) {
                                Convert.packF(buf2, j * 4, (float)array[i]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 88: {
                            while (i < n) {
                                Convert.packX(buf2, j * 8, (long)array[i]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 76: {
                            while (i < n) {
                                Convert.packL(buf2, j * 4, (int)array[i]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 73: {
                            while (i < n) {
                                Convert.packI(buf2, j * 2, (short)array[i]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 66: {
                            while (i < n) {
                                buf2[j] = (byte)array[i];
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 78: {
                            while (i < n) {
                                Convert.packN(buf2, j, (byte)array[j]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 80: {
                            while (i < n) {
                                Convert.packP(buf2, j, (byte)array[j]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 73: {
                    array = (short[])buf1;
                    switch (type2) {
                        case 68: {
                            while (i < n) {
                                Convert.packD(buf2, j * 8, array[i]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 70: {
                            while (i < n) {
                                Convert.packF(buf2, j * 4, (float)array[i]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 88: {
                            while (i < n) {
                                Convert.packX(buf2, j * 8, (long)array[i]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 76: {
                            while (i < n) {
                                Convert.packL(buf2, j * 4, (int)array[i]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 73: {
                            while (i < n) {
                                Convert.packI(buf2, j * 2, (short)array[i]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 66: {
                            while (i < n) {
                                buf2[j] = (byte)array[i];
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 78: {
                            while (i < n) {
                                Convert.packN(buf2, j, (byte)array[j]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 80: {
                            while (i < n) {
                                Convert.packP(buf2, j, (byte)array[j]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 66: {
                    array = (byte[])buf1;
                    switch (type2) {
                        case 68: {
                            while (i < n) {
                                Convert.packD(buf2, j * 8, array[i]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 70: {
                            while (i < n) {
                                Convert.packF(buf2, j * 4, (float)array[i]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 88: {
                            while (i < n) {
                                Convert.packX(buf2, j * 8, (long)array[i]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 76: {
                            while (i < n) {
                                Convert.packL(buf2, j * 4, (int)array[i]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 73: {
                            while (i < n) {
                                Convert.packI(buf2, j * 2, (short)array[i]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 66: {
                            while (i < n) {
                                buf2[j] = (byte)array[i];
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 78: {
                            while (i < n) {
                                Convert.packN(buf2, j, (byte)array[j]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        case 80: {
                            while (i < n) {
                                Convert.packP(buf2, j, (byte)array[j]);
                                ++i;
                                ++j;
                            }
                            break block188;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 78: {
                    throw new ClassCastException("Convert: Can not convert " + buf1.getClass() + " to nibble[].");
                }
                case 80: {
                    throw new ClassCastException("Convert: Can not convert " + buf1.getClass() + " to packed[].");
                }
                default: {
                    status = -1;
                }
            }
        }
        if (type2s == 74) {
            int offset = (int)Math.ceil((double)off2orig * 3.0 / 2.0);
            Convert.packJs(buf2, buf2orig, offset, n);
        }
        if (status < 0) {
            Shell.warning("ERROR: ja2bb(..) Unknown conversion " + (char)type1 + "->" + (char)type2);
        }
    }

    private static boolean isUnsignedType(byte type) {
        return type == 85 || type == 86;
    }

    @InternalUseOnly
    public static void setFavorJavaBehavior(boolean preferJavaToMidas) {
        favorJavaBehavior = preferJavaToMidas;
    }

    @InternalUseOnly
    public static void setAlwaysDefaultToDouble(boolean alwaysDefaultToDouble) {
        Convert.alwaysDefaultToDouble = alwaysDefaultToDouble;
    }

    @InternalUseOnly
    public static void setMinSupportUnsupportedDataTypes(boolean minSupportUnsupportedDataTypes) {
        Convert.minSupportUnsupportedDataTypes = minSupportUnsupportedDataTypes;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void type(byte[] buf1, int off1, byte type1, byte[] buf2, int off2, byte type2, int n, int round, boolean saturating) {
        if (n == 0 || buf1 == null || buf2 == null) {
            return;
        }
        if (Convert.isUnsignedType(type2)) {
            Midas.log("Converting values to 'U' or 'V' is not supported'", 1);
            return;
        }
        if (type1 == 72 || type2 == 72) {
            throw new MidasException("Cannot convert non-homogeneous type buffer for " + (char)type1 + "->" + (char)type2 + " conversion not supported.");
        }
        if (!Convert.isUnsignedType(type1) && Native.useConvert && n > 1 && type2 != type1 && Native.type(buf1, off1, type1, buf2, off2, type2, n, round, saturating) == 0) {
            return;
        }
        byte type2s = type2;
        byte[] buf2orig = buf2;
        int off2orig = off2;
        if (type2 == 74) {
            type2 = (byte)73;
            buf2 = type1 == 73 ? buf1 : new byte[buf2.length * 4 / 3];
            off2 = 0;
        }
        int bps1 = Math.max(1, Data.getBPS(type1));
        int bps2 = Math.max(1, Data.getBPS(type2));
        int i = off1 * bps1;
        int j = off2 * bps2;
        if (type1 == type2s) {
            System.arraycopy(buf1, i, buf2, j, n * bps1);
            return;
        }
        int ii = i + n * bps1;
        int jj = j + n * bps2;
        int status = n;
        if (round == 7 && (type2 != 70 || type2 == 68)) {
            round = 1;
        }
        if (saturating) {
            block0 : switch (type1) {
                case 68: {
                    switch (round) {
                        case 1: {
                            switch (type2) {
                                case 70: {
                                    while (i < ii) {
                                        Convert.packF(buf2, j, (float)Convert.unpackD(buf1, i));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 88: {
                                    while (i < ii) {
                                        Convert.packX(buf2, j, (long)Convert.unpackD(buf1, i));
                                        j += 8;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Convert.unpackD(buf1, i));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, Convert.n2i_sat(Convert.unpackD(buf1, i)));
                                        j += 2;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, Convert.n2b_sat(Convert.unpackD(buf1, i)));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, Convert.d2n_sat(Convert.unpackD(buf1, i)));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, Convert.n2b_sat(Convert.unpackD(buf1, i)));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block0;
                        }
                        case 2: {
                            switch (type2) {
                                case 70: {
                                    while (i < ii) {
                                        Convert.packF(buf2, j, (float)Convert.unpackD(buf1, i));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 88: {
                                    while (i < ii) {
                                        Convert.packX(buf2, j, (long)Math.ceil(Convert.unpackD(buf1, i)));
                                        j += 8;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Math.ceil(Convert.unpackD(buf1, i)));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, Convert.n2i_sat(Math.ceil(Convert.unpackD(buf1, i))));
                                        j += 2;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, Convert.n2b_sat(Math.ceil(Convert.unpackD(buf1, i))));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, Convert.d2n_sat(Math.ceil(Convert.unpackD(buf1, i))));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, Convert.n2b_sat(Math.ceil(Convert.unpackD(buf1, i))));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block0;
                        }
                        case 3: {
                            switch (type2) {
                                case 70: {
                                    while (i < ii) {
                                        Convert.packF(buf2, j, (float)Convert.unpackD(buf1, i));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 88: {
                                    while (i < ii) {
                                        Convert.packX(buf2, j, (long)Math.floor(Convert.unpackD(buf1, i)));
                                        j += 8;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Math.floor(Convert.unpackD(buf1, i)));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, Convert.n2i_sat(Math.floor(Convert.unpackD(buf1, i))));
                                        j += 2;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, Convert.n2b_sat(Math.floor(Convert.unpackD(buf1, i))));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, Convert.d2n_sat(Math.floor(Convert.unpackD(buf1, i))));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, Convert.n2b_sat(Math.floor(Convert.unpackD(buf1, i))));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block0;
                        }
                        case 6: {
                            switch (type2) {
                                case 70: {
                                    while (i < ii) {
                                        Convert.packF(buf2, j, (float)Convert.unpackD(buf1, i));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 88: {
                                    while (i < ii) {
                                        Convert.packX(buf2, j, (long)Math.rint(Convert.unpackD(buf1, i)));
                                        j += 8;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Math.rint(Convert.unpackD(buf1, i)));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, Convert.n2i_sat(Math.rint(Convert.unpackD(buf1, i))));
                                        j += 2;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, Convert.n2b_sat(Math.rint(Convert.unpackD(buf1, i))));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, Convert.d2n_sat(Math.rint(Convert.unpackD(buf1, i))));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, Convert.n2b_sat(Math.rint(Convert.unpackD(buf1, i))));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block0;
                        }
                        case -1: {
                            switch (type2) {
                                case 70: {
                                    while (i < ii) {
                                        Convert.packF(buf2, j, (float)Convert.unpackD(buf1, i));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 88: {
                                    while (i < ii) {
                                        Convert.packX(buf2, j, (long)Math.floor(0.5 + Convert.unpackD(buf1, i)));
                                        j += 8;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Math.floor(0.5 + Convert.unpackD(buf1, i)));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, Convert.n2i_sat(Math.floor(0.5 + Convert.unpackD(buf1, i))));
                                        j += 2;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, Convert.n2b_sat(Math.floor(0.5 + Convert.unpackD(buf1, i))));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, Convert.d2n_sat(Math.floor(0.5 + Convert.unpackD(buf1, i))));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, Convert.n2b_sat(Math.floor(0.5 + Convert.unpackD(buf1, i))));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block0;
                        }
                        case 4: {
                            switch (type2) {
                                case 70: {
                                    while (i < ii) {
                                        Convert.packF(buf2, j, (float)Convert.unpackD(buf1, i));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 88: {
                                    while (i < ii) {
                                        Convert.packX(buf2, j, (long)Convert.lround(Convert.unpackD(buf1, i)));
                                        j += 8;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Convert.lround(Convert.unpackD(buf1, i)));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, Convert.n2i_sat(Convert.lround(Convert.unpackD(buf1, i))));
                                        j += 2;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, Convert.n2b_sat(Convert.lround(Convert.unpackD(buf1, i))));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, Convert.d2n_sat(Convert.lround(Convert.unpackD(buf1, i))));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, Convert.n2b_sat(Convert.lround(Convert.unpackD(buf1, i))));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block0;
                        }
                        case 7: {
                            throw new ArithmeticException("Can not use ROUND_UNNECESSARY for " + (char)type1 + "->" + (char)type2 + " conversion.");
                        }
                        default: {
                            throw new IllegalArgumentException("Illegal rounding mode " + round + " for " + (char)type1 + "->" + (char)type2 + " conversion.");
                        }
                    }
                }
                case 70: {
                    switch (round) {
                        case 1: {
                            switch (type2) {
                                case 68: {
                                    while (ii > i) {
                                        Convert.packD(buf2, jj -= 8, Convert.unpackF(buf1, ii -= 4));
                                    }
                                    break;
                                }
                                case 88: {
                                    while (ii > i) {
                                        Convert.packX(buf2, jj -= 8, (long)Convert.unpackF(buf1, ii -= 4));
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Convert.unpackF(buf1, i));
                                        j += 4;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, Convert.n2i_sat(Convert.unpackF(buf1, i)));
                                        j += 2;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, Convert.n2b_sat(Convert.unpackF(buf1, i)));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, Convert.f2n_sat(Convert.unpackF(buf1, i)));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, Convert.n2b_sat(Convert.unpackF(buf1, i)));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block0;
                        }
                        case 2: {
                            switch (type2) {
                                case 68: {
                                    while (ii > i) {
                                        Convert.packD(buf2, jj -= 8, Convert.unpackF(buf1, ii -= 4));
                                    }
                                    break;
                                }
                                case 88: {
                                    while (ii > i) {
                                        Convert.packX(buf2, jj -= 8, (long)Math.ceil(Convert.unpackF(buf1, ii -= 4)));
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Math.ceil(Convert.unpackF(buf1, i)));
                                        j += 4;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, Convert.n2i_sat(Math.ceil(Convert.unpackF(buf1, i))));
                                        j += 2;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, Convert.n2b_sat(Math.ceil(Convert.unpackF(buf1, i))));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, Convert.d2n_sat(Math.ceil(Convert.unpackF(buf1, i))));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, Convert.n2b_sat(Math.ceil(Convert.unpackF(buf1, i))));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block0;
                        }
                        case 3: {
                            switch (type2) {
                                case 68: {
                                    while (ii > i) {
                                        Convert.packD(buf2, jj -= 8, Convert.unpackF(buf1, ii -= 4));
                                    }
                                    break;
                                }
                                case 88: {
                                    while (ii > i) {
                                        Convert.packX(buf2, jj -= 8, (long)Math.floor(Convert.unpackF(buf1, ii -= 4)));
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Math.floor(Convert.unpackF(buf1, i)));
                                        j += 4;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, Convert.n2i_sat(Math.floor(Convert.unpackF(buf1, i))));
                                        j += 2;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, Convert.n2b_sat(Math.floor(Convert.unpackF(buf1, i))));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, Convert.d2n_sat(Math.floor(Convert.unpackF(buf1, i))));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, Convert.n2b_sat(Math.floor(Convert.unpackF(buf1, i))));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block0;
                        }
                        case 6: {
                            switch (type2) {
                                case 68: {
                                    while (ii > i) {
                                        Convert.packD(buf2, jj -= 8, Convert.unpackF(buf1, ii -= 4));
                                    }
                                    break;
                                }
                                case 88: {
                                    while (ii > i) {
                                        Convert.packX(buf2, jj -= 8, (long)Math.rint(Convert.unpackF(buf1, ii -= 4)));
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Math.rint(Convert.unpackF(buf1, i)));
                                        j += 4;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, Convert.n2i_sat(Math.rint(Convert.unpackF(buf1, i))));
                                        j += 2;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, Convert.n2b_sat(Math.rint(Convert.unpackF(buf1, i))));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, Convert.d2n_sat(Math.rint(Convert.unpackF(buf1, i))));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, Convert.n2b_sat(Math.rint(Convert.unpackF(buf1, i))));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block0;
                        }
                        case -1: {
                            switch (type2) {
                                case 68: {
                                    while (ii > i) {
                                        Convert.packD(buf2, jj -= 8, Convert.unpackF(buf1, ii -= 4));
                                    }
                                    break;
                                }
                                case 88: {
                                    while (ii > i) {
                                        Convert.packX(buf2, jj -= 8, (long)Math.floor(0.5f + Convert.unpackF(buf1, ii -= 4)));
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Math.floor(0.5f + Convert.unpackF(buf1, i)));
                                        j += 4;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, Convert.n2i_sat(Math.floor(0.5f + Convert.unpackF(buf1, i))));
                                        j += 2;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, Convert.n2b_sat(Math.floor(0.5f + Convert.unpackF(buf1, i))));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, Convert.d2n_sat(Math.floor(0.5f + Convert.unpackF(buf1, i))));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, Convert.n2b_sat(Math.floor(0.5f + Convert.unpackF(buf1, i))));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block0;
                        }
                        case 4: {
                            switch (type2) {
                                case 68: {
                                    while (ii > i) {
                                        Convert.packD(buf2, jj -= 8, Convert.unpackF(buf1, ii -= 4));
                                    }
                                    break;
                                }
                                case 88: {
                                    while (ii > i) {
                                        Convert.packX(buf2, jj -= 8, (long)Convert.lround(Convert.unpackF(buf1, ii -= 4)));
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Convert.lround(Convert.unpackF(buf1, i)));
                                        j += 4;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, Convert.n2i_sat(Convert.lround(Convert.unpackF(buf1, i))));
                                        j += 2;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, Convert.n2b_sat(Convert.lround(Convert.unpackF(buf1, i))));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, Convert.d2n_sat(Convert.lround(Convert.unpackF(buf1, i))));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, Convert.n2b_sat(Convert.lround(Convert.unpackF(buf1, i))));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block0;
                        }
                        case 7: {
                            throw new ArithmeticException("Can not use ROUND_UNNECESSARY for " + (char)type1 + "->" + (char)type2 + " conversion.");
                        }
                        default: {
                            throw new IllegalArgumentException("Illegal rounding mode " + round + " for " + (char)type1 + "->" + (char)type2 + " conversion.");
                        }
                    }
                }
                case 88: {
                    switch (type2) {
                        case 68: {
                            while (i < ii) {
                                Convert.packD(buf2, j, Convert.unpackX(buf1, i));
                                j += 8;
                                i += 8;
                            }
                            break;
                        }
                        case 70: {
                            while (i < ii) {
                                Convert.packF(buf2, j, Convert.unpackX(buf1, i));
                                j += 4;
                                i += 8;
                            }
                            break;
                        }
                        case 76: {
                            while (i < ii) {
                                Convert.packL(buf2, j, Convert.n2l_sat(Convert.unpackX(buf1, i)));
                                j += 4;
                                i += 8;
                            }
                            break;
                        }
                        case 73: {
                            while (i < ii) {
                                Convert.packI(buf2, j, Convert.n2i_sat(Convert.unpackX(buf1, i)));
                                j += 2;
                                i += 8;
                            }
                            break;
                        }
                        case 66: {
                            while (i < ii) {
                                Convert.packB(buf2, j, Convert.n2b_sat(Convert.unpackX(buf1, i)));
                                ++j;
                                i += 8;
                            }
                            break;
                        }
                        case 78: {
                            while (i < ii) {
                                Convert.packN(buf2, j, Convert.x2n_sat(Convert.unpackX(buf1, i)));
                                ++j;
                                i += 8;
                            }
                            break;
                        }
                        case 80: {
                            while (i < ii) {
                                Convert.packP(buf2, j, Convert.n2b_sat(Convert.unpackX(buf1, i)));
                                ++j;
                                i += 8;
                            }
                            break;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 76: {
                    switch (type2) {
                        case 68: {
                            while (ii > i) {
                                Convert.packD(buf2, jj -= 8, Convert.unpackL(buf1, ii -= 4));
                            }
                            break;
                        }
                        case 70: {
                            while (i < ii) {
                                Convert.packF(buf2, j, Convert.unpackL(buf1, i));
                                j += 4;
                                i += 4;
                            }
                            break;
                        }
                        case 88: {
                            while (ii > i) {
                                Convert.packX(buf2, jj -= 8, Convert.unpackL(buf1, ii -= 4));
                            }
                            break;
                        }
                        case 73: {
                            while (i < ii) {
                                Convert.packI(buf2, j, Convert.n2i_sat(Convert.unpackL(buf1, i)));
                                j += 2;
                                i += 4;
                            }
                            break;
                        }
                        case 66: {
                            while (i < ii) {
                                Convert.packB(buf2, j, Convert.n2b_sat(Convert.unpackL(buf1, i)));
                                ++j;
                                i += 4;
                            }
                            break;
                        }
                        case 78: {
                            while (i < ii) {
                                Convert.packN(buf2, j, Convert.l2n_sat(Convert.unpackL(buf1, i)));
                                ++j;
                                i += 4;
                            }
                            break;
                        }
                        case 80: {
                            while (i < ii) {
                                Convert.packP(buf2, j, Convert.n2b_sat(Convert.unpackL(buf1, i)));
                                ++j;
                                i += 4;
                            }
                            break;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 73: {
                    switch (type2) {
                        case 68: {
                            while (ii > i) {
                                Convert.packD(buf2, jj -= 8, Convert.unpackI(buf1, ii -= 2));
                            }
                            break;
                        }
                        case 70: {
                            while (ii > i) {
                                Convert.packF(buf2, jj -= 4, Convert.unpackI(buf1, ii -= 2));
                            }
                            break;
                        }
                        case 88: {
                            while (ii > i) {
                                Convert.packX(buf2, jj -= 8, Convert.unpackI(buf1, ii -= 2));
                            }
                            break;
                        }
                        case 76: {
                            while (ii > i) {
                                Convert.packL(buf2, jj -= 4, Convert.unpackI(buf1, ii -= 2));
                            }
                            break;
                        }
                        case 73: {
                            if (type2s == 74) break;
                            status = -1;
                            break;
                        }
                        case 66: {
                            while (i < ii) {
                                Convert.packB(buf2, j, Convert.n2b_sat(Convert.unpackI(buf1, i)));
                                ++j;
                                i += 2;
                            }
                            break;
                        }
                        case 78: {
                            while (i < ii) {
                                Convert.packN(buf2, j, Convert.i2n_sat(Convert.unpackI(buf1, i)));
                                ++j;
                                i += 2;
                            }
                            break;
                        }
                        case 80: {
                            while (i < ii) {
                                Convert.packP(buf2, j, Convert.n2b_sat(Convert.unpackI(buf1, i)));
                                ++j;
                                i += 2;
                            }
                            break;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 74: {
                    switch (type2) {
                        case 68: {
                            while (ii > i) {
                                Convert.packD(buf2, jj -= 8, Convert.unpackJ(buf1, --ii));
                            }
                            break;
                        }
                        case 70: {
                            while (ii > i) {
                                Convert.packF(buf2, jj -= 4, Convert.unpackJ(buf1, --ii));
                            }
                            break;
                        }
                        case 88: {
                            while (ii > i) {
                                Convert.packX(buf2, jj -= 8, Convert.unpackJ(buf1, --ii));
                            }
                            break;
                        }
                        case 76: {
                            while (ii > i) {
                                Convert.packL(buf2, jj -= 4, Convert.unpackJ(buf1, --ii));
                            }
                            break;
                        }
                        case 73: {
                            while (i < ii) {
                                Convert.packI(buf2, j, Convert.unpackJ(buf1, i));
                                j += 2;
                                ++i;
                            }
                            break;
                        }
                        case 66: {
                            while (i < ii) {
                                Convert.packB(buf2, j, Convert.n2b_sat(Convert.unpackJ(buf1, i)));
                                ++j;
                                ++i;
                            }
                            break;
                        }
                        case 78: {
                            while (i < ii) {
                                Convert.packN(buf2, j, Convert.i2n_sat(Convert.unpackJ(buf1, i)));
                                ++j;
                                ++i;
                            }
                            break;
                        }
                        case 80: {
                            while (i < ii) {
                                Convert.packP(buf2, j, Convert.n2b_sat(Convert.unpackJ(buf1, i)));
                                ++j;
                                ++i;
                            }
                            break;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 66: {
                    switch (type2) {
                        case 68: {
                            while (ii > i) {
                                Convert.packD(buf2, jj -= 8, buf1[--ii]);
                            }
                            break;
                        }
                        case 70: {
                            while (ii > i) {
                                Convert.packF(buf2, jj -= 4, buf1[--ii]);
                            }
                            break;
                        }
                        case 88: {
                            while (ii > i) {
                                Convert.packX(buf2, jj -= 8, buf1[--ii]);
                            }
                            break;
                        }
                        case 76: {
                            while (ii > i) {
                                Convert.packL(buf2, jj -= 4, buf1[--ii]);
                            }
                            break;
                        }
                        case 73: {
                            while (ii > i) {
                                Convert.packI(buf2, jj -= 2, buf1[--ii]);
                            }
                            break;
                        }
                        case 78: {
                            while (i < ii) {
                                Convert.packN(buf2, j, Convert.b2n_sat(buf1[i++]));
                                ++j;
                            }
                            break;
                        }
                        case 80: {
                            while (i < ii) {
                                Convert.packP(buf2, j, buf1[i++]);
                                ++j;
                            }
                            break;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 78: {
                    switch (type2) {
                        case 68: {
                            while (ii > i) {
                                Convert.packD(buf2, jj -= 8, Convert.unpackN(buf1, --ii));
                            }
                            break;
                        }
                        case 70: {
                            while (ii > i) {
                                Convert.packF(buf2, jj -= 4, Convert.unpackN(buf1, --ii));
                            }
                            break;
                        }
                        case 88: {
                            while (ii > i) {
                                Convert.packX(buf2, jj -= 8, Convert.unpackN(buf1, --ii));
                            }
                            break;
                        }
                        case 76: {
                            while (ii > i) {
                                Convert.packL(buf2, jj -= 4, Convert.unpackN(buf1, --ii));
                            }
                            break;
                        }
                        case 73: {
                            while (ii > i) {
                                Convert.packI(buf2, jj -= 2, Convert.unpackN(buf1, --ii));
                            }
                            break;
                        }
                        case 66: {
                            while (ii > i) {
                                Convert.packB(buf2, --jj, Convert.unpackN(buf1, --ii));
                            }
                            break;
                        }
                        case 80: {
                            while (ii > i) {
                                Convert.packP(buf2, --jj, Convert.unpackN(buf1, --ii));
                            }
                            break;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 80: {
                    switch (type2) {
                        case 68: {
                            while (ii > i) {
                                Convert.packD(buf2, jj -= 8, buf1[--ii >> 3] >> (ii & 7) & 1);
                            }
                            break;
                        }
                        case 70: {
                            while (ii > i) {
                                Convert.packF(buf2, jj -= 4, buf1[--ii >> 3] >> (ii & 7) & 1);
                            }
                            break;
                        }
                        case 88: {
                            while (ii > i) {
                                Convert.packX(buf2, jj -= 8, buf1[--ii >> 3] >> (ii & 7) & 1);
                            }
                            break;
                        }
                        case 76: {
                            while (ii > i) {
                                Convert.packL(buf2, jj -= 4, buf1[--ii >> 3] >> (ii & 7) & 1);
                            }
                            break;
                        }
                        case 73: {
                            while (ii > i) {
                                Convert.packI(buf2, jj -= 2, (byte)(buf1[--ii >> 3] >> (ii & 7) & 1));
                            }
                            break;
                        }
                        case 66: {
                            while (ii > i) {
                                Convert.packB(buf2, --jj, (byte)(buf1[--ii >> 3] >> (ii & 7) & 1));
                            }
                            break;
                        }
                        case 78: {
                            while (ii > i) {
                                Convert.packN(buf2, --jj, (byte)(buf1[--ii >> 3] >> (ii & 7) & 1));
                            }
                            break;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 86: {
                    if (minSupportUnsupportedDataTypes) {
                        switch (type2) {
                            case 68: {
                                while (ii > i) {
                                    Convert.packD(buf2, jj -= 8, Convert.unpackUL(buf1, ii -= 4));
                                }
                                break;
                            }
                            case 70: {
                                while (i < ii) {
                                    Convert.packF(buf2, j, Convert.unpackUL(buf1, i));
                                    j += 4;
                                    i += 4;
                                }
                                break;
                            }
                            case 88: {
                                while (ii > i) {
                                    Convert.packX(buf2, jj -= 8, Convert.unpackUL(buf1, ii -= 4));
                                }
                                break;
                            }
                            case 76: {
                                while (i < ii) {
                                    Convert.packL(buf2, j, Convert.n2l_sat(Convert.unpackUL(buf1, i)));
                                    j += 4;
                                    i += 4;
                                }
                                break;
                            }
                            case 73: {
                                while (i < ii) {
                                    Convert.packI(buf2, j, Convert.n2i_sat(Convert.unpackUL(buf1, i)));
                                    j += 2;
                                    i += 4;
                                }
                                break;
                            }
                            case 66: {
                                while (i < ii) {
                                    Convert.packB(buf2, j, Convert.n2b_sat(Convert.unpackUL(buf1, i)));
                                    ++j;
                                    i += 4;
                                }
                                break;
                            }
                            case 78: {
                                while (i < ii) {
                                    Convert.packN(buf2, j, Convert.x2n_sat(Convert.unpackUL(buf1, i)));
                                    ++j;
                                    i += 4;
                                }
                                break;
                            }
                            case 80: {
                                while (i < ii) {
                                    Convert.packP(buf2, j, Convert.n2b_sat(Convert.unpackUL(buf1, i)));
                                    ++j;
                                    i += 4;
                                }
                                break;
                            }
                            default: {
                                status = -1;
                                break;
                            }
                        }
                        break;
                    }
                    Midas.log("Support for conversion from type 'V' needs the IOOption +MinimalSupportForUnsupportedDataTypes set", 1);
                    break;
                }
                case 85: {
                    if (minSupportUnsupportedDataTypes) {
                        switch (type2) {
                            case 68: {
                                while (ii > i) {
                                    Convert.packD(buf2, jj -= 8, Convert.unpackU(buf1, ii -= 2));
                                }
                                break;
                            }
                            case 70: {
                                while (ii > i) {
                                    Convert.packF(buf2, jj -= 4, Convert.unpackU(buf1, ii -= 2));
                                }
                                break;
                            }
                            case 88: {
                                while (ii > i) {
                                    Convert.packX(buf2, jj -= 8, Convert.unpackU(buf1, ii -= 2));
                                }
                                break;
                            }
                            case 76: {
                                while (ii > i) {
                                    Convert.packL(buf2, jj -= 4, Convert.unpackU(buf1, ii -= 2));
                                }
                                break;
                            }
                            case 73: {
                                while (ii > i) {
                                    Convert.packI(buf2, j, Convert.n2i_sat(Convert.unpackU(buf1, i)));
                                    ++j;
                                    i += 2;
                                }
                                break;
                            }
                            case 66: {
                                while (i < ii) {
                                    Convert.packB(buf2, j, Convert.n2b_sat(Convert.unpackU(buf1, i)));
                                    ++j;
                                    i += 2;
                                }
                                break;
                            }
                            case 78: {
                                while (i < ii) {
                                    Convert.packN(buf2, j, Convert.l2n_sat(Convert.unpackU(buf1, i)));
                                    ++j;
                                    i += 2;
                                }
                                break;
                            }
                            case 80: {
                                while (i < ii) {
                                    Convert.packP(buf2, j, Convert.n2b_sat(Convert.unpackU(buf1, i)));
                                    ++j;
                                    i += 2;
                                }
                                break;
                            }
                            default: {
                                status = -1;
                                break;
                            }
                        }
                        break;
                    }
                    Midas.log("Support for conversion from type 'U' needs the IOOption +MinimalSupportForUnsupportedDataTypes set", 1);
                    break;
                }
                default: {
                    status = -1;
                    break;
                }
            }
        } else {
            block224 : switch (type1) {
                case 68: {
                    switch (round) {
                        case 1: {
                            switch (type2) {
                                case 70: {
                                    while (i < ii) {
                                        Convert.packF(buf2, j, (float)Convert.unpackD(buf1, i));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 88: {
                                    while (i < ii) {
                                        Convert.packX(buf2, j, (long)Convert.unpackD(buf1, i));
                                        j += 8;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Convert.unpackD(buf1, i));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, (short)Convert.unpackD(buf1, i));
                                        j += 2;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, (byte)Convert.unpackD(buf1, i));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, (byte)Convert.unpackD(buf1, i));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, (byte)Convert.unpackD(buf1, i));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block224;
                        }
                        case 2: {
                            switch (type2) {
                                case 70: {
                                    while (i < ii) {
                                        Convert.packF(buf2, j, (float)Convert.unpackD(buf1, i));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 88: {
                                    while (i < ii) {
                                        Convert.packX(buf2, j, (long)Math.ceil(Convert.unpackD(buf1, i)));
                                        j += 8;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Math.ceil(Convert.unpackD(buf1, i)));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, (short)Math.ceil(Convert.unpackD(buf1, i)));
                                        j += 2;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, (byte)Math.ceil(Convert.unpackD(buf1, i)));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, (byte)Math.ceil(Convert.unpackD(buf1, i)));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, (byte)Math.ceil(Convert.unpackD(buf1, i)));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block224;
                        }
                        case 3: {
                            switch (type2) {
                                case 70: {
                                    while (i < ii) {
                                        Convert.packF(buf2, j, (float)Convert.unpackD(buf1, i));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 88: {
                                    while (i < ii) {
                                        Convert.packX(buf2, j, (long)Math.floor(Convert.unpackD(buf1, i)));
                                        j += 8;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Math.floor(Convert.unpackD(buf1, i)));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, (short)Math.floor(Convert.unpackD(buf1, i)));
                                        j += 2;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, (byte)Math.floor(Convert.unpackD(buf1, i)));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, (byte)Math.floor(Convert.unpackD(buf1, i)));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, (byte)Math.floor(Convert.unpackD(buf1, i)));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block224;
                        }
                        case 6: {
                            switch (type2) {
                                case 70: {
                                    while (i < ii) {
                                        Convert.packF(buf2, j, (float)Convert.unpackD(buf1, i));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 88: {
                                    while (i < ii) {
                                        Convert.packX(buf2, j, (long)Math.rint(Convert.unpackD(buf1, i)));
                                        j += 8;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Math.rint(Convert.unpackD(buf1, i)));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, (short)Math.rint(Convert.unpackD(buf1, i)));
                                        j += 2;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, (byte)Math.rint(Convert.unpackD(buf1, i)));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, (byte)Math.rint(Convert.unpackD(buf1, i)));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, (byte)Math.rint(Convert.unpackD(buf1, i)));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block224;
                        }
                        case -1: {
                            switch (type2) {
                                case 70: {
                                    while (i < ii) {
                                        Convert.packF(buf2, j, (float)Convert.unpackD(buf1, i));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 88: {
                                    while (i < ii) {
                                        Convert.packX(buf2, j, (long)Math.floor(0.5 + Convert.unpackD(buf1, i)));
                                        j += 8;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Math.floor(0.5 + Convert.unpackD(buf1, i)));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, (short)Math.floor(0.5 + Convert.unpackD(buf1, i)));
                                        j += 2;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, (byte)Math.floor(0.5 + Convert.unpackD(buf1, i)));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, (byte)Math.floor(0.5 + Convert.unpackD(buf1, i)));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, (byte)Math.floor(0.5 + Convert.unpackD(buf1, i)));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block224;
                        }
                        case 4: {
                            switch (type2) {
                                case 70: {
                                    while (i < ii) {
                                        Convert.packF(buf2, j, (float)Convert.unpackD(buf1, i));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 88: {
                                    while (i < ii) {
                                        Convert.packX(buf2, j, (long)Convert.lround(Convert.unpackD(buf1, i)));
                                        j += 8;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Convert.lround(Convert.unpackD(buf1, i)));
                                        j += 4;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, (short)Convert.lround(Convert.unpackD(buf1, i)));
                                        j += 2;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, (byte)Convert.lround(Convert.unpackD(buf1, i)));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, (byte)Convert.lround(Convert.unpackD(buf1, i)));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, (byte)Convert.lround(Convert.unpackD(buf1, i)));
                                        ++j;
                                        i += 8;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block224;
                        }
                        case 7: {
                            throw new ArithmeticException("Can not use ROUND_UNNECESSARY for " + (char)type1 + "->" + (char)type2 + " conversion.");
                        }
                        default: {
                            throw new IllegalArgumentException("Illegal rounding mode " + round + " for " + (char)type1 + "->" + (char)type2 + " conversion.");
                        }
                    }
                }
                case 70: {
                    switch (round) {
                        case 1: {
                            switch (type2) {
                                case 68: {
                                    while (ii > i) {
                                        Convert.packD(buf2, jj -= 8, Convert.unpackF(buf1, ii -= 4));
                                    }
                                    break;
                                }
                                case 88: {
                                    while (ii > i) {
                                        Convert.packX(buf2, jj -= 8, (long)Convert.unpackF(buf1, ii -= 4));
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Convert.unpackF(buf1, i));
                                        j += 4;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, (short)Convert.unpackF(buf1, i));
                                        j += 2;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, (byte)Convert.unpackF(buf1, i));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, (byte)Convert.unpackF(buf1, i));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, (byte)Convert.unpackF(buf1, i));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block224;
                        }
                        case 2: {
                            switch (type2) {
                                case 68: {
                                    while (ii > i) {
                                        Convert.packD(buf2, jj -= 8, Convert.unpackF(buf1, ii -= 4));
                                    }
                                    break;
                                }
                                case 88: {
                                    while (ii > i) {
                                        Convert.packX(buf2, jj -= 8, (long)Math.ceil(Convert.unpackF(buf1, ii -= 4)));
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Math.ceil(Convert.unpackF(buf1, i)));
                                        j += 4;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, (short)Math.ceil(Convert.unpackF(buf1, i)));
                                        j += 2;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, (byte)Math.ceil(Convert.unpackF(buf1, i)));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, (byte)Math.ceil(Convert.unpackF(buf1, i)));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, (byte)Math.ceil(Convert.unpackF(buf1, i)));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block224;
                        }
                        case 3: {
                            switch (type2) {
                                case 68: {
                                    while (ii > i) {
                                        Convert.packD(buf2, jj -= 8, Convert.unpackF(buf1, ii -= 4));
                                    }
                                    break;
                                }
                                case 88: {
                                    while (ii > i) {
                                        Convert.packX(buf2, jj -= 8, (long)Math.floor(Convert.unpackF(buf1, ii -= 4)));
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Math.floor(Convert.unpackF(buf1, i)));
                                        j += 4;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, (short)Math.floor(Convert.unpackF(buf1, i)));
                                        j += 2;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, (byte)Math.floor(Convert.unpackF(buf1, i)));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, (byte)Math.floor(Convert.unpackF(buf1, i)));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, (byte)Math.floor(Convert.unpackF(buf1, i)));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block224;
                        }
                        case 6: {
                            switch (type2) {
                                case 68: {
                                    while (ii > i) {
                                        Convert.packD(buf2, jj -= 8, Convert.unpackF(buf1, ii -= 4));
                                    }
                                    break;
                                }
                                case 88: {
                                    while (ii > i) {
                                        Convert.packX(buf2, jj -= 8, (long)Math.rint(Convert.unpackF(buf1, ii -= 4)));
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Math.rint(Convert.unpackF(buf1, i)));
                                        j += 4;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, (short)Math.rint(Convert.unpackF(buf1, i)));
                                        j += 2;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, (byte)Math.rint(Convert.unpackF(buf1, i)));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, (byte)Math.rint(Convert.unpackF(buf1, i)));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, (byte)Math.rint(Convert.unpackF(buf1, i)));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block224;
                        }
                        case -1: {
                            switch (type2) {
                                case 68: {
                                    while (ii > i) {
                                        Convert.packD(buf2, jj -= 8, Convert.unpackF(buf1, ii -= 4));
                                    }
                                    break;
                                }
                                case 88: {
                                    while (ii > i) {
                                        Convert.packX(buf2, jj -= 8, (long)Math.floor(0.5f + Convert.unpackF(buf1, ii -= 4)));
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Math.floor(0.5f + Convert.unpackF(buf1, i)));
                                        j += 4;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, (short)Math.floor(0.5f + Convert.unpackF(buf1, i)));
                                        j += 2;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, (byte)Math.floor(0.5f + Convert.unpackF(buf1, i)));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, (byte)Math.floor(0.5f + Convert.unpackF(buf1, i)));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, (byte)Math.floor(0.5f + Convert.unpackF(buf1, i)));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block224;
                        }
                        case 4: {
                            switch (type2) {
                                case 68: {
                                    while (ii > i) {
                                        Convert.packD(buf2, jj -= 8, Convert.unpackF(buf1, ii -= 4));
                                    }
                                    break;
                                }
                                case 88: {
                                    while (ii > i) {
                                        Convert.packX(buf2, jj -= 8, (long)Convert.lround(Convert.unpackF(buf1, ii -= 4)));
                                    }
                                    break;
                                }
                                case 76: {
                                    while (i < ii) {
                                        Convert.packL(buf2, j, (int)Convert.lround(Convert.unpackF(buf1, i)));
                                        j += 4;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 73: {
                                    while (i < ii) {
                                        Convert.packI(buf2, j, (short)Convert.lround(Convert.unpackF(buf1, i)));
                                        j += 2;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 66: {
                                    while (i < ii) {
                                        Convert.packB(buf2, j, (byte)Convert.lround(Convert.unpackF(buf1, i)));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 78: {
                                    while (i < ii) {
                                        Convert.packN(buf2, j, (byte)Convert.lround(Convert.unpackF(buf1, i)));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                case 80: {
                                    while (i < ii) {
                                        Convert.packP(buf2, j, (byte)Convert.lround(Convert.unpackF(buf1, i)));
                                        ++j;
                                        i += 4;
                                    }
                                    break;
                                }
                                default: {
                                    status = -1;
                                    break;
                                }
                            }
                            break block224;
                        }
                        case 7: {
                            throw new ArithmeticException("Can not use ROUND_UNNECESSARY for " + (char)type1 + "->" + (char)type2 + " conversion.");
                        }
                        default: {
                            throw new IllegalArgumentException("Illegal rounding mode " + round + " for " + (char)type1 + "->" + (char)type2 + " conversion.");
                        }
                    }
                }
                case 88: {
                    switch (type2) {
                        case 68: {
                            while (i < ii) {
                                Convert.packD(buf2, j, Convert.unpackX(buf1, i));
                                j += 8;
                                i += 8;
                            }
                            break;
                        }
                        case 70: {
                            while (i < ii) {
                                Convert.packF(buf2, j, Convert.unpackX(buf1, i));
                                j += 4;
                                i += 8;
                            }
                            break;
                        }
                        case 76: {
                            while (i < ii) {
                                Convert.packL(buf2, j, (int)Convert.unpackX(buf1, i));
                                j += 4;
                                i += 8;
                            }
                            break;
                        }
                        case 73: {
                            while (i < ii) {
                                Convert.packI(buf2, j, (short)Convert.unpackX(buf1, i));
                                j += 2;
                                i += 8;
                            }
                            break;
                        }
                        case 66: {
                            while (i < ii) {
                                Convert.packB(buf2, j, (byte)Convert.unpackX(buf1, i));
                                ++j;
                                i += 8;
                            }
                            break;
                        }
                        case 78: {
                            while (i < ii) {
                                Convert.packN(buf2, j, (byte)Convert.unpackX(buf1, i));
                                ++j;
                                i += 8;
                            }
                            break;
                        }
                        case 80: {
                            while (i < ii) {
                                Convert.packP(buf2, j, (byte)Convert.unpackX(buf1, i));
                                ++j;
                                i += 8;
                            }
                            break;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 76: {
                    switch (type2) {
                        case 68: {
                            while (ii > i) {
                                Convert.packD(buf2, jj -= 8, Convert.unpackL(buf1, ii -= 4));
                            }
                            break;
                        }
                        case 70: {
                            while (i < ii) {
                                Convert.packF(buf2, j, Convert.unpackL(buf1, i));
                                j += 4;
                                i += 4;
                            }
                            break;
                        }
                        case 88: {
                            while (ii > i) {
                                Convert.packX(buf2, jj -= 8, Convert.unpackL(buf1, ii -= 4));
                            }
                            break;
                        }
                        case 73: {
                            while (i < ii) {
                                Convert.packI(buf2, j, (short)Convert.unpackL(buf1, i));
                                j += 2;
                                i += 4;
                            }
                            break;
                        }
                        case 66: {
                            while (i < ii) {
                                Convert.packB(buf2, j, (byte)Convert.unpackL(buf1, i));
                                ++j;
                                i += 4;
                            }
                            break;
                        }
                        case 78: {
                            while (i < ii) {
                                Convert.packN(buf2, j, (byte)Convert.unpackL(buf1, i));
                                ++j;
                                i += 4;
                            }
                            break;
                        }
                        case 80: {
                            while (i < ii) {
                                Convert.packP(buf2, j, (byte)Convert.unpackL(buf1, i));
                                ++j;
                                i += 4;
                            }
                            break;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 73: {
                    switch (type2) {
                        case 68: {
                            while (ii > i) {
                                Convert.packD(buf2, jj -= 8, Convert.unpackI(buf1, ii -= 2));
                            }
                            break;
                        }
                        case 70: {
                            while (ii > i) {
                                Convert.packF(buf2, jj -= 4, Convert.unpackI(buf1, ii -= 2));
                            }
                            break;
                        }
                        case 88: {
                            while (ii > i) {
                                Convert.packX(buf2, jj -= 8, Convert.unpackI(buf1, ii -= 2));
                            }
                            break;
                        }
                        case 76: {
                            while (ii > i) {
                                Convert.packL(buf2, jj -= 4, Convert.unpackI(buf1, ii -= 2));
                            }
                            break;
                        }
                        case 73: {
                            if (type2s == 74) break;
                            status = -1;
                            break;
                        }
                        case 66: {
                            while (i < ii) {
                                Convert.packB(buf2, j, (byte)Convert.unpackI(buf1, i));
                                ++j;
                                i += 2;
                            }
                            break;
                        }
                        case 78: {
                            while (i < ii) {
                                Convert.packN(buf2, j, (byte)Convert.unpackI(buf1, i));
                                ++j;
                                i += 2;
                            }
                            break;
                        }
                        case 80: {
                            while (i < ii) {
                                Convert.packP(buf2, j, (byte)Convert.unpackI(buf1, i));
                                ++j;
                                i += 2;
                            }
                            break;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 74: {
                    switch (type2) {
                        case 68: {
                            while (ii > i) {
                                Convert.packD(buf2, jj -= 8, Convert.unpackJ(buf1, --ii));
                            }
                            break;
                        }
                        case 70: {
                            while (ii > i) {
                                Convert.packF(buf2, jj -= 4, Convert.unpackJ(buf1, --ii));
                            }
                            break;
                        }
                        case 88: {
                            while (ii > i) {
                                Convert.packX(buf2, jj -= 8, Convert.unpackJ(buf1, --ii));
                            }
                            break;
                        }
                        case 76: {
                            while (ii > i) {
                                Convert.packL(buf2, jj -= 4, Convert.unpackJ(buf1, --ii));
                            }
                            break;
                        }
                        case 73: {
                            while (i < ii) {
                                Convert.packI(buf2, j, Convert.unpackJ(buf1, i));
                                j += 2;
                                ++i;
                            }
                            break;
                        }
                        case 66: {
                            while (i < ii) {
                                Convert.packB(buf2, j, (byte)Convert.unpackJ(buf1, i));
                                ++j;
                                ++i;
                            }
                            break;
                        }
                        case 78: {
                            while (i < ii) {
                                Convert.packN(buf2, j, (byte)Convert.unpackJ(buf1, i));
                                ++j;
                                ++i;
                            }
                            break;
                        }
                        case 80: {
                            while (i < ii) {
                                Convert.packP(buf2, j, (byte)Convert.unpackJ(buf1, i));
                                ++j;
                                ++i;
                            }
                            break;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 66: {
                    switch (type2) {
                        case 68: {
                            while (ii > i) {
                                Convert.packD(buf2, jj -= 8, buf1[--ii]);
                            }
                            break;
                        }
                        case 70: {
                            while (ii > i) {
                                Convert.packF(buf2, jj -= 4, buf1[--ii]);
                            }
                            break;
                        }
                        case 88: {
                            while (ii > i) {
                                Convert.packX(buf2, jj -= 8, buf1[--ii]);
                            }
                            break;
                        }
                        case 76: {
                            while (ii > i) {
                                Convert.packL(buf2, jj -= 4, buf1[--ii]);
                            }
                            break;
                        }
                        case 73: {
                            while (ii > i) {
                                Convert.packI(buf2, jj -= 2, buf1[--ii]);
                            }
                            break;
                        }
                        case 78: {
                            while (i < ii) {
                                Convert.packN(buf2, j, buf1[i++]);
                                ++j;
                            }
                            break;
                        }
                        case 80: {
                            while (i < ii) {
                                Convert.packP(buf2, j, buf1[i++]);
                                ++j;
                            }
                            break;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 78: {
                    switch (type2) {
                        case 68: {
                            while (ii > i) {
                                Convert.packD(buf2, jj -= 8, Convert.unpackN(buf1, --ii));
                            }
                            break;
                        }
                        case 70: {
                            while (ii > i) {
                                Convert.packF(buf2, jj -= 4, Convert.unpackN(buf1, --ii));
                            }
                            break;
                        }
                        case 88: {
                            while (ii > i) {
                                Convert.packX(buf2, jj -= 8, Convert.unpackN(buf1, --ii));
                            }
                            break;
                        }
                        case 76: {
                            while (ii > i) {
                                Convert.packL(buf2, jj -= 4, Convert.unpackN(buf1, --ii));
                            }
                            break;
                        }
                        case 73: {
                            while (ii > i) {
                                Convert.packI(buf2, jj -= 2, Convert.unpackN(buf1, --ii));
                            }
                            break;
                        }
                        case 66: {
                            while (ii > i) {
                                Convert.packB(buf2, --jj, Convert.unpackN(buf1, --ii));
                            }
                            break;
                        }
                        case 80: {
                            while (ii > i) {
                                Convert.packP(buf2, --jj, Convert.unpackN(buf1, --ii));
                            }
                            break;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 80: {
                    switch (type2) {
                        case 68: {
                            while (ii > i) {
                                Convert.packD(buf2, jj -= 8, buf1[--ii >> 3] >> (ii & 7) & 1);
                            }
                            break;
                        }
                        case 70: {
                            while (ii > i) {
                                Convert.packF(buf2, jj -= 4, buf1[--ii >> 3] >> (ii & 7) & 1);
                            }
                            break;
                        }
                        case 88: {
                            while (ii > i) {
                                Convert.packX(buf2, jj -= 8, buf1[--ii >> 3] >> (ii & 7) & 1);
                            }
                            break;
                        }
                        case 76: {
                            while (ii > i) {
                                Convert.packL(buf2, jj -= 4, buf1[--ii >> 3] >> (ii & 7) & 1);
                            }
                            break;
                        }
                        case 73: {
                            while (ii > i) {
                                Convert.packI(buf2, jj -= 2, (byte)(buf1[--ii >> 3] >> (ii & 7) & 1));
                            }
                            break;
                        }
                        case 66: {
                            while (ii > i) {
                                Convert.packB(buf2, --jj, (byte)(buf1[--ii >> 3] >> (ii & 7) & 1));
                            }
                            break;
                        }
                        case 78: {
                            while (ii > i) {
                                Convert.packN(buf2, --jj, (byte)(buf1[--ii >> 3] >> (ii & 7) & 1));
                            }
                            break;
                        }
                        default: {
                            status = -1;
                            break;
                        }
                    }
                    break;
                }
                case 85: {
                    Midas.log("Converting values from 'U' in unsaturated mode is not supported", 1);
                    return;
                }
                case 86: {
                    Midas.log("Converting values from 'V' in unsaturated mode is not supported", 1);
                    return;
                }
                default: {
                    status = -1;
                }
            }
        }
        if (type2s == 74) {
            int offset = (int)Math.ceil((double)off2orig * 3.0 / 2.0);
            Convert.packJs(buf2, buf2orig, offset, n);
            if (type2 == 73) {
                return;
            }
        }
        if (status < 0) {
            Shell.warning("ERROR: type(..) Unknown conversion " + (char)type1 + "->" + (char)type2);
        }
    }

    @InternalUseOnly(value="since created")
    private static class BigDecimalValue {
        boolean valid;
        BigDecimal bdVal;

        public BigDecimalValue() {
            this.bdVal = null;
            this.valid = false;
        }

        public BigDecimalValue(BigDecimal bdVal) {
            this.bdVal = bdVal;
            this.valid = true;
        }

        public BigDecimal getValue() {
            return this.bdVal;
        }

        public void setValue(BigDecimal bdVal) {
            this.bdVal = bdVal;
            this.valid = true;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean valid) {
            this.valid = valid;
        }

        public void setToValid() {
            this.valid = true;
        }

        public void setToInvalid() {
            this.valid = false;
        }
    }
}

