/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import nxm.sys.lib.Convert;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.MidasException;

public class AudioFile
extends DataFile {
    private String version;

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    protected void readHeader() {
        this.ioh.read(this.hb, 0, 512, 0L);
        this.version = Convert.unpackS(this.hb, 0, 4);
        if (this.version.equals("RIFF")) {
            this.convertWFHeader();
        } else if (this.version.equals("RIFX")) {
            this.convertWFHeader();
        } else if (this.version.equals(".snd")) {
            this.convertAUHeader();
        } else {
            throw new MidasException("AudioFile " + this.getURL() + " does not have a valid Audio Header");
        }
    }

    private void convertWFHeader() {
        String id = Convert.unpackS(this.hb, 0, 4);
        short codec = Convert.unpackI(this.hb, 20, (byte)69);
        short numChan = Convert.unpackI(this.hb, 22, (byte)69);
        int rate = Convert.unpackL(this.hb, 24, (byte)69);
        short bits = Convert.unpackI(this.hb, 34, (byte)69);
        int sub1size = Convert.unpackL(this.hb, 40, (byte)69);
        for (int i = 0; i < 512; ++i) {
            this.hb[i] = 0;
        }
        this.initMain();
        if (numChan == 1) {
            this.setFormatMode((byte)83);
        } else if (numChan == 2) {
            this.setFormatMode((byte)67);
        } else {
            throw new MidasException("WaveFile: format must be S=mono or C=stereo");
        }
        if (bits == 8) {
            this.setFormatType((byte)66);
        } else if (bits == 16) {
            this.setFormatType((byte)73);
        } else if (bits == 32) {
            this.setFormatType((byte)76);
        } else {
            throw new MidasException("WaveFile: bits=" + bits + " not allowed");
        }
        if (rate > 0) {
            this.setXDelta(1.0 / (double)rate);
        }
        this.setXUnits(1);
        if (id.equals("RIFF")) {
            this.setDataRep("EEEI");
        } else if (id.equals("RIFX")) {
            this.setDataRep("IEEE");
        } else {
            throw new MidasException("WaveFile: file type must be RIFF or RIFX, given '" + id + "'.");
        }
        this.setDataStart(44.0);
        this.setDataSize(sub1size);
        this.setBlueVerIO();
        this.keywords.putMain("SOURCE", id + " WAVE " + bits + "-bit " + rate + "-Hz codec=" + codec, false);
    }

    private static byte AuEncodingToMidasFormatType(int encoding) {
        byte type = 66;
        switch (encoding) {
            case 1: 
            case 2: 
            case 10: 
            case 27: {
                break;
            }
            case 3: 
            case 11: 
            case 18: 
            case 19: 
            case 20: {
                type = 73;
                break;
            }
            case 5: 
            case 13: {
                type = 76;
                break;
            }
            case 6: {
                type = 70;
                break;
            }
            case 7: {
                type = 68;
                break;
            }
            default: {
                throw new MidasException("DataFile: Unsupported Au encoding type: " + encoding);
            }
        }
        return type;
    }

    private void convertAUHeader() {
        String magicNum = Convert.unpackS(this.hb, 0, 4);
        int offset = Convert.unpackL(this.hb, 4, (byte)73);
        int size = Convert.unpackL(this.hb, 8, (byte)73);
        int encoding = Convert.unpackL(this.hb, 12, (byte)73);
        int rate = Convert.unpackL(this.hb, 16, (byte)73);
        int channels = Convert.unpackL(this.hb, 20, (byte)73);
        for (int i = 0; i < 512; ++i) {
            this.hb[i] = 0;
        }
        this.initMain();
        this.setDataRep("IEEE");
        if (channels == 1) {
            this.setFormatMode((byte)83);
        } else if (channels == 2) {
            this.setFormatMode((byte)67);
        } else {
            throw new MidasException("DataFile: Au format must be S=mono or C=stereo, channels=" + channels);
        }
        this.setFormatType(AudioFile.AuEncodingToMidasFormatType(encoding));
        if (rate > 0) {
            this.setXDelta(1.0 / (double)rate);
        }
        this.setXUnits(1);
        this.setDataStart(offset);
        this.setDataSize(size);
        this.setBlueVerIO();
        this.keywords.putMain("SOURCE", magicNum + " Au " + rate + "-Hz codec=" + encoding, false);
    }
}

