/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.util.ArrayList;
import java.util.Hashtable;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.test.junit.NMTestCase;

public class Unittest
extends Intrinsic {
    public static final int OUTPUT_OVERHEAD_LENGTH = 12;
    public static final int OUTPUT_LENGTH = 68;
    private static final String ERR_FLAG = " <--";
    private boolean showError;
    private boolean showFailure;
    private boolean showTrace;
    private String results;
    private int tests;
    private int failures;
    private int errors;
    private int broken;
    private int missing;
    private TestSuite testSuite;
    private int nextTest;

    @Override
    public int open() {
        String toTest = this.MA.getQ("OPT", "SYS").trim();
        boolean isSingleClass = toTest.indexOf(".") >= 0;
        this.showError = this.MA.getState("/ERROR", true);
        this.showFailure = this.MA.getState("/FAILURE", true);
        this.showTrace = this.MA.getState("/ST", false);
        this.results = this.MA.getS("RES").trim();
        this.tests = 0;
        this.failures = 0;
        this.errors = 0;
        this.broken = 0;
        this.missing = 0;
        this.nextTest = 0;
        if (isSingleClass) {
            if (toTest.indexOf(".test.junit.") < 0 && toTest.startsWith("nxm.")) {
                int index = toTest.indexOf(46, 4);
                toTest = toTest.substring(0, index) + ".test.junit" + toTest.substring(index) + "Test";
            }
            this.testSuite = new TestSuite();
            this.testSuite.addTest((Test)this.buildTestSuite(toTest));
        } else {
            this.testSuite = this.buildOptionTestSuite(toTest);
        }
        return 0;
    }

    @Override
    public int process() {
        int status = 0;
        if (this.nextTest >= this.testSuite.testCount()) {
            status = 9;
        } else {
            NMTestResult results = new NMTestResult();
            results.addListener(new NMTestListener());
            String msg = "Testing " + this.testSuite.testAt(this.nextTest) + " ";
            if (this.verbose) {
                this.M.info(msg);
            }
            this.testSuite.testAt(this.nextTest).run((TestResult)results);
            if (this.verbose) {
                msg = "    Results of testing " + this.testSuite.testAt(this.nextTest);
            }
            if (results.wasSuccessful()) {
                this.M.info(StringUtil.padRight(msg, 68, '.') + "..PASS");
            } else {
                this.M.warning(StringUtil.padRight(msg, 68, '.') + "..FAIL" + ERR_FLAG);
            }
            this.tests += results.runCount();
            this.failures += results.failureCount();
            this.errors += results.errorCount();
            this.missing += results.missingCount();
            ++this.nextTest;
        }
        return status;
    }

    @Override
    public int close() {
        int status;
        String message;
        String summary = "Ran " + this.tests + " JUnit tests, " + (this.failures + this.errors) + " failed. (" + this.broken + " known drs, " + this.errors + " exceptions, " + this.missing + " missing)";
        if (this.failures == 0 && this.errors == 0) {
            message = "PASSED ALL TESTS";
            status = 1;
        } else {
            message = "FAILED SOME TESTS";
            status = -1;
        }
        if (this.results != null && this.results.length() > 0) {
            Table res = new Table();
            res.put("MSG", (Object)message);
            res.put("STATUS", status);
            res.put("SUMMARY", (Object)summary);
            res.put("TEST_COUNT", this.tests);
            res.put("FAILURE_COUNT", this.failures + this.errors);
            res.put("ERROR_COUNT", this.errors);
            res.put("BROKEN_COUNT", this.broken);
            res.put("MISSING_COUNT", this.missing);
            this.MR.put(this.results, (Object)res);
        } else if (this.failures == 0 && this.errors == 0) {
            this.M.info(summary);
        } else {
            this.M.warning(summary);
        }
        return 0;
    }

    public TestSuite buildOptionTestSuite(String option) {
        String msg;
        ArrayList<String> testClasses = new ArrayList<String>();
        TestSuite testSuite = new TestSuite();
        option = option.toLowerCase();
        String testPath = Shell.getOptPath(option, "TEST");
        String configFile = FileName.addPathRoot(FileName.addPathDir(testPath, "junit"), "unittest_config.tbl");
        String optUpperCase = option.toUpperCase();
        TextFile tf = new TextFile(this.M, (Object)configFile);
        if (!tf.exists()) {
            msg = "No unit test configuration file found for option " + optUpperCase;
            this.M.info(StringUtil.padRight(msg, 68, '.') + "..MISS");
        } else if (!tf.open(33)) {
            msg = "Error in loading unit test configuration for option " + optUpperCase;
            this.M.warning(StringUtil.padRight(msg, 68, '.') + "..FAIL");
            ++this.errors;
        }
        String line = tf.read();
        while (line != null) {
            if (!(line = line.trim()).startsWith("!") && line.length() > 0) {
                int indexEq = line.indexOf(61);
                String name = null;
                String params = null;
                if (indexEq < 0) {
                    name = line;
                    params = null;
                } else {
                    name = line.substring(0, indexEq).trim();
                    params = line.substring(indexEq + 1).trim().toUpperCase();
                }
                if (params == null || params.length() == 0) {
                    String className = "nxm." + option + ".test.junit." + name;
                    testClasses.add(className);
                } else if (params.equals("BROKEN")) {
                    int index = name.lastIndexOf("Test");
                    String className = index <= 0 ? "nxm." + option + name : "nxm." + option + name.substring(0, index);
                    String msg2 = className + ": Test skipped - known DR. ";
                    this.M.info(StringUtil.padRight(msg2, 68, '.') + "..BROK");
                    ++this.broken;
                } else {
                    this.M.error("Unknown test specifier (" + line + ") expected '" + name + "' or '" + name + "=BROKEN'.");
                }
            }
            line = tf.read();
        }
        tf.close();
        for (String className : testClasses) {
            TestSuite test = this.buildTestSuite(className);
            testSuite.addTest((Test)test);
        }
        return testSuite;
    }

    public TestSuite buildTestSuite(String className) {
        TestSuite suite = new TestSuite(className);
        try {
            NMTestCase[] set = NMTestCase.buildTestSet((Midas)this.M, (String)className);
            for (int i = 0; i < set.length; ++i) {
                suite.addTest((Test)set[i]);
            }
            if (set.length > 0) {
                String name = set[0].toString();
                int index = name.lastIndexOf(40);
                if (index > 0 && (index = (name = name.substring(0, index)).lastIndexOf(46)) > 0) {
                    name = name.substring(0, index);
                }
                suite.setName(name);
            }
        }
        catch (ClassNotFoundException exception) {
            String msg = "Unable to instantiate test class " + className + ". ";
            this.M.warning(StringUtil.padRight(msg, 68, '.') + "..FAIL");
            ++this.errors;
        }
        return suite;
    }

    private static class NMTestResult
    extends TestResult {
        private int fMissing = 0;

        private NMTestResult() {
        }

        public void addFailure(Test test, AssertionFailedError t) {
            if (t == NMTestCase.MISSING_TEST_ERROR) {
                ++this.fMissing;
            } else {
                super.addFailure(test, t);
            }
        }

        private int missingCount() {
            return this.fMissing;
        }
    }

    protected class NMTestListener
    implements TestListener {
        protected Hashtable<Test, NMTestResult> activeTests = new Hashtable();

        public void addError(Test test, Throwable error) {
            NMTestResult testResult = this.activeTests.get(test);
            testResult.addError(test, error);
            if (Unittest.this.showError) {
                Unittest.this.M.printStackTrace("TEST ERROR", error, Unittest.this.showTrace);
            }
        }

        public void addFailure(Test test, AssertionFailedError error) {
            NMTestResult testResult = this.activeTests.get(test);
            testResult.addFailure(test, error);
            if (error != NMTestCase.MISSING_TEST_ERROR && Unittest.this.showFailure) {
                Unittest.this.M.printStackTrace("TEST FAILURE", (Throwable)error, Unittest.this.showTrace);
            }
        }

        public void endTest(Test test) {
            NMTestResult testResult = this.activeTests.remove(test);
            String name = test.toString().substring(((NMTestCase)test).getTestedClass().length() + 1);
            String msg = "    Testing " + name + " ";
            if (test instanceof NMTestCase.MissingTest) {
                msg = "    Testing " + name + ": No test method found ";
                if (Unittest.this.verbose) {
                    Unittest.this.M.info(StringUtil.padRight(msg, 68, '.') + "..MISS");
                }
            } else if (testResult.wasSuccessful()) {
                if (Unittest.this.verbose) {
                    Unittest.this.M.info(StringUtil.padRight(msg, 68, '.') + "..PASS");
                }
            } else {
                Unittest.this.M.warning(StringUtil.padRight(msg, 68, '.') + "..FAIL");
            }
        }

        public void startTest(Test test) {
            this.activeTests.put(test, new NMTestResult());
        }
    }
}

