/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.util.Arrays;
import java.util.TreeSet;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.intr.Results;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Util;
import nxm.sys.lib.XmlFile;

public class Table
extends Intrinsic {
    private static final TreeSet<String> FUNCS_TABLE_NOT_INPUT = new TreeSet<String>(Arrays.asList("CREATE", "GETDEFAULTFLAGS", "GETDEFAULTMODE", "LOAD", "LOAD/O", "LOAD/O/C", "LOAD/C/O", "LOAD/T", "LOAD/X", "MERGE", "MERGE/L", "MERGE/R", "SETDEFAULTFLAGS", "SETDEFAULTMODE"));
    private static final String flagsList = "AutoReadPrev,AutoWritePrev,Add,ReadOnly,Force,AddRoot,CaseSensitive,ExceptionOnNull,DisableEscapeSequences,OnlyDotIntoSubTables,CheckMalformed,SerializeTimeAsTColon,IgnoreEmptyInserts,InlineTypeConversion,InlineResultsConversion,PermitNull,KeepJavaNumericType,SerializeWithOriginalFlags,DisableConsistentHandlingOfWhiteSpace,OnlyJavaNumericSerialization,QuotedKeysSerialization,AllowDotsInKeys";

    @Override
    public int process() {
        nxm.sys.lib.Table tab = null;
        String func = this.MA.getU("FUNC", "LIST");
        if (!FUNCS_TABLE_NOT_INPUT.contains(func) && (tab = this.MA.getTable("TAB")) == null && !func.equals("EQUALS")) {
            this.M.error("TABLE: TAB= is required for FUNC=" + func);
        }
        if (func.equals("LIST")) {
            Results.listMultipleResult(this.M, tab, "*", 0, true);
        } else if (func.equals("COPY")) {
            String label = this.MA.getUQ("P3");
            nxm.sys.lib.Table tabout = new nxm.sys.lib.Table(tab.toString());
            this.MR.put(label, (Object)tabout);
        } else if (func.equals("CREATE")) {
            String label = this.MA.getUQ("TAB");
            nxm.sys.lib.Table newtab = this.MA.isPresent("P3") ? this.MA.getTable("P3") : new nxm.sys.lib.Table();
            this.MR.put(label, (Object)newtab);
        } else if (func.startsWith("MERGE")) {
            nxm.sys.lib.Table tab3;
            nxm.sys.lib.Table tab2 = this.MA.getTable("P3");
            if (tab2 == null) {
                this.M.warning("Missing table1 -> Usage: 'TABLE <out> MERGE <table1> <table2>'");
            }
            if ((tab3 = this.MA.getTable("P4")) == null) {
                this.M.warning("Missing table2 -> Usage: 'TABLE <out> MERGE <table1> <table2>'");
            }
            boolean recurse = false;
            if (func.indexOf("/R") > 0) {
                recurse = true;
            }
            nxm.sys.lib.Table tabout = nxm.sys.lib.Table.merge(tab2, tab3, recurse);
            String label = this.MA.getUQ("TAB");
            this.MR.put(label, (Object)tabout);
        } else if (func.equals("EQUALS")) {
            nxm.sys.lib.Table tab2 = this.MA.getTable("P3");
            String resName = this.MA.getU("P4");
            boolean equal = true;
            if (tab != tab2) {
                if (tab == null || tab2 == null) {
                    equal = false;
                } else if (tab.size() != tab2.size()) {
                    equal = false;
                } else {
                    String[] keys = tab.getKeys();
                    for (int i = 0; equal && i < keys.length; ++i) {
                        equal = Util.equals(tab.getO(keys[i]), tab2.getO(keys[i]));
                    }
                }
            }
            if (resName == null || resName.length() == 0) {
                this.M.println("Table: Equal=" + equal);
            } else {
                this.MR.put(resName, equal);
            }
        } else if (func.equals("GETKEY")) {
            String key = this.MA.getU("P3");
            String label = this.MA.getU("P4", null);
            Object value = tab.getx(key);
            if (label != null) {
                this.MR.put(label, value);
            } else {
                Results.listSingleResult(this.M, tab, key, 0, true);
            }
        } else if (func.equals("SETKEY")) {
            String key = this.MA.getU("P3");
            Object value = this.MA.getO("P4", null);
            tab.putx(key, value);
        } else if (func.equals("SETMODE")) {
            String tabMode = this.MA.getS("P3");
            tab.setMode(tabMode);
        } else if (func.equals("GETMODE")) {
            String modeName = tab.getModeName();
            this.MR.setKey(this.MA.getU("P3"), modeName);
            if (this.verbose) {
                this.M.info("Table mode = " + modeName);
            }
        } else if (func.equals("SETFLAGS")) {
            String tabFlags = this.MA.getS("P3");
            tab.setFlags(tabFlags);
        } else if (func.equals("GETFLAGS")) {
            String tabFlags = tab.getFlags();
            this.MR.setKey(this.MA.getU("P3"), tabFlags);
            if (this.verbose) {
                this.M.info("Table flags = " + tabFlags);
            }
        } else if (func.equals("SETDEFAULTMODE")) {
            String tabMode = this.MA.getS("P3");
            nxm.sys.lib.Table.setDefaultMode(tabMode);
        } else if (func.equals("GETDEFAULTMODE")) {
            String defModeName = nxm.sys.lib.Table.getDefaultModeName();
            this.MR.setKey(this.MA.getU("P3"), defModeName);
            if (this.verbose) {
                this.M.info("Default table mode = " + defModeName);
            }
        } else if (func.equals("SETDEFAULTFLAGS")) {
            String tabFlags = this.MA.getS("P3");
            nxm.sys.lib.Table.setDefaultFlags(tabFlags);
        } else if (func.equals("GETDEFAULTFLAGS")) {
            String defTableFlags = nxm.sys.lib.Table.getDefaultFlags();
            this.MR.setKey(this.MA.getU("P3"), defTableFlags);
            if (this.verbose) {
                this.M.info("Default table flags = " + defTableFlags);
            }
        } else if (func.equals("GETSIZE")) {
            int tabSize = tab.getSize();
            this.MR.setKey(this.MA.getU("P3"), Convert.l2o(tabSize));
            if (this.verbose) {
                this.M.info("Table size = " + tabSize);
            }
        } else if (func.equals("GETESCAPEDSTRING")) {
            this.MR.setKey(this.MA.getU("P3"), tab.getEscapedString());
        } else if (func.startsWith("GETKEYS")) {
            Object[] keys = tab.getKeys();
            if (func.indexOf("/R") > 0) {
                for (int i = 0; i < keys.length / 2; ++i) {
                    Object temp = keys[i];
                    keys[i] = keys[keys.length - i - 1];
                    keys[keys.length - i - 1] = temp;
                }
            }
            Object value = func.indexOf("/S") > 0 ? StringUtil.join(keys, ",") : keys;
            this.MR.setKey(this.MA.getU("P3"), value);
        } else if (func.startsWith("GETVALUESS")) {
            Object[] values = tab.getValuesS();
            Object value = func.indexOf("/S") > 0 ? StringUtil.join(values, ",") : values;
            this.MR.setKey(this.MA.getU("P3"), value);
        } else if (func.startsWith("SORT")) {
            boolean reverse;
            boolean bl = reverse = func.indexOf("/R") > 0;
            if (func.indexOf("/K") > 0) {
                tab.sortByKey(reverse);
            } else if (func.indexOf("/V") > 0) {
                this.M.warning("TABLE: Function SORT/V not implemented yet.");
            } else {
                this.M.error("TABLE: The SORT function requires either the /K or /V modifier.");
            }
        } else if (func.startsWith("LOADCFG")) {
            TextFile inFile = this.MA.getTextFile("P3");
            boolean cs = func.contains("/C");
            boolean merge = func.contains("/D");
            inFile.open(8192);
            String[] allLines = inFile.readAllLines();
            inFile.close();
            this.MR.put(this.MA.getUQ("TAB"), (Object)nxm.sys.lib.Table.fromConfigFile(allLines, cs, merge));
        } else if (func.equals("SAVECFG")) {
            tab = this.MA.getTable("TAB");
            TextFile outFile = this.MA.getTextFile("P3");
            outFile.open(2);
            for (String line : tab.toConfigFile()) {
                outFile.writeln(line);
            }
            outFile.close();
        } else if (func.startsWith("LOAD")) {
            boolean hasFlags = this.MA.isPresent("/FLAGS");
            int tabFlags = this.MA.getOptionMask("/FLAGS", flagsList, nxm.sys.lib.Table.getDefaultFlagsInt());
            nxm.sys.lib.Table inTable = func.indexOf("/T") > 0 ? (hasFlags ? new nxm.sys.lib.Table(this.MA.getTextFile("P3"), tabFlags) : new nxm.sys.lib.Table(this.MA.getTextFile("P3"))) : (func.indexOf("/X") > 0 ? XmlFile.fastXmlFileToTable(this.MA.getTextFile("P3")) : (func.indexOf("/O") > 0 ? nxm.sys.lib.Table.fromOpalFile(this, this.MA.getFileName("P3"), func.contains("/C")) : this.MA.getTable("P3")));
            if (hasFlags) {
                inTable.setFlags(tabFlags);
            }
            this.MR.put(this.MA.getUQ("TAB"), (Object)inTable);
        } else if (func.equals("SAVE")) {
            boolean hasFlags = this.MA.isPresent("/FLAGS");
            int tabFlags = this.MA.getOptionMask("/FLAGS", flagsList, nxm.sys.lib.Table.getDefaultFlagsInt());
            if (hasFlags) {
                tab.setFlags(tabFlags);
            }
            tab.toTextFile(this.MA.getTextFile("P3"));
        } else if (func.equals("KEYMOD")) {
            String regexToReplace = this.MA.getU("P3");
            String replacement = this.MA.getU("P4");
            tab.modifyKeys(regexToReplace, replacement);
        } else {
            this.M.error("Unsupported table function: " + func);
        }
        return 9;
    }

    @Deprecated
    @InternalUseOnly
    public static nxm.sys.lib.Table loadOpalTable(TextFile in, boolean keepCase) {
        in.open(1);
        String[] lines = in.readAllLines();
        in.close();
        return nxm.sys.lib.Table.fromOpalFile(lines, keepCase);
    }
}

