/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import nxm.sys.inc.ListFile;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;

public class Status
extends Intrinsic {
    static final String positionalKeys = "FILE,SZ,XS,XD,XU,FS,YS,YD,YU,TYPE,FORMAT";

    @Override
    public int open() {
        BaseFile file = this.MA.getFile("FILE");
        file.open();
        for (int n = 2; n <= this.MA.numberOf(); ++n) {
            String key = this.MA.getKey(n);
            String label = this.MA.getU(key);
            if (label.length() == 0) continue;
            if (key.equals("P" + n)) {
                key = Parser.get(positionalKeys, n);
            }
            Object value = null;
            if (file instanceof DataFile) {
                if (key.equalsIgnoreCase("SZ")) {
                    key = "SIZE";
                } else if (key.equalsIgnoreCase("DS")) {
                    key = "DATASTART";
                } else if (key.equalsIgnoreCase("XU")) {
                    key = "XUNITS";
                } else if (key.equalsIgnoreCase("YU")) {
                    key = "YUNITS";
                }
                if (key.startsWith("SR(") || key.startsWith("C(")) {
                    value = this.getSubRecord((ListFile)((Object)file), key);
                }
            }
            if (value == null) {
                value = KeyObject.getKey(file, key);
            }
            if (value != null) {
                this.MR.put(label, value);
                continue;
            }
            this.M.println("Bad parameter syntax: " + key + "=" + label);
        }
        if (this.MA.numberOf() == 1) {
            this.M.print(file.listHeader());
        }
        if (this.MA.getState("/K") || this.MA.getState("/KEY")) {
            this.M.print(file.listKeywords());
        }
        if (this.MA.getState("/T") || this.MA.getState("/TIME") && file instanceof DataFile) {
            DataFile df = (DataFile)file;
            if (df.getTimeLineHandler() == null) {
                this.M.warning("There are no TIMELINE keywords in " + df.getURL());
            } else {
                int decimalPlaces = this.MA.getL("/PRECISION", this.MA.getL("/PREC", 3));
                this.M.print(df.getTimeLineHandler().list(decimalPlaces));
            }
        }
        if (this.MA.find("/D") || this.MA.find("/DATA")) {
            String dataElsToList = this.MA.getS("/D", this.MA.getS("/DATA"));
            Shell.runCommand(this.M, "DATALIST/CMDRUNMODE=RunToCompletion," + file.getFileName() + ",0," + dataElsToList);
        }
        file.close();
        return 9;
    }

    private Table getSubRecord(ListFile listFile, String key) {
        Table retVal = null;
        int iLParen = key.indexOf("(");
        int iRParen = key.indexOf(")");
        String numOrString = key.substring(iLParen + 1, iRParen);
        double dIndex = -1.0;
        Object recObject = Convert.o2o((Object)numOrString, '_', (Object)this);
        if (recObject != null) {
            if (StringUtil.isNumber("" + recObject)) {
                dIndex = Convert.o2d(recObject);
            } else {
                numOrString = "" + recObject;
            }
        }
        if (dIndex != -1.0) {
            retVal = listFile.getRecordDef((int)(dIndex - 1.0));
        } else {
            try {
                Table allRecDefs = listFile.getRecordDefs();
                if (allRecDefs.containsKey(numOrString)) {
                    retVal = allRecDefs.getTable(numOrString);
                } else {
                    this.M.warning("STATUS: Unable to find key '" + numOrString + "' in file");
                }
            }
            catch (Exception e) {
                this.M.warning("Unable to find subrecord in string " + key);
            }
        }
        return retVal;
    }
}

