/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import nxm.sys.lib.FileName;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.Logger;

public class Report
extends Intrinsic {
    @Override
    public int process() {
        String func = this.MA.getU("FUNC");
        if (func.equals("ON")) {
            FileName fname = this.MA.getFileName("FILE");
            Logger prevLogger = this.M.logger;
            if (prevLogger != null) {
                fname.setExt("mlog");
                this.M.info("Existing M.logger is being replaced by REPORT ON " + fname + " -> " + this.M);
                prevLogger.close();
            }
            this.M.logger = new Logger(this.M);
            this.M.logger.open(fname);
        } else if (func.equals("FLUSH")) {
            if (this.M.logger == null) {
                return 9;
            }
            this.M.logger.flush();
        } else if (func.equals("OFF")) {
            if (this.M.logger == null) {
                return 9;
            }
            this.M.info("Existing M.logger is being disabled by REPORT OFF -> " + this.M);
            this.M.logger.close();
            this.M.logger = null;
        } else if (func.equals("AUTOSAVE")) {
            Logger.setAutoSave(this.MA.getState("FILE", true));
        } else if (func.equals("SAVEOFF")) {
            if (this.M.logger == null) {
                return 9;
            }
            this.M.info("Existing M.logger is being disabled by REPORT SAVEOFF -> " + this.M);
            this.M.logger.close();
            this.M.logger.saveOff();
            this.M.logger = null;
        } else {
            this.M.error("Unsupported LOGGER function: " + func);
        }
        return 9;
    }
}

