/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import nxm.sys.intr.Results;
import nxm.sys.lib.FileName;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.Foreign;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.OptionTree;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;

public class Option
extends Intrinsic {
    public static final String COMMAND_FILE_NAME = "commands.cnf";
    private boolean debug = false;
    private boolean IsALink;
    private boolean InNmRoot;
    static final DirectoryFilter DIR_FILTER = new DirectoryFilter();

    @Override
    public int process() {
        this.IsALink = false;
        this.InNmRoot = false;
        this.debug = this.MA.getState("/DEBUG", this.debug);
        String optName = this.MA.getU("NAME");
        String pathInOptTable = this.MR.getString("OPT." + optName.toUpperCase());
        String physPath = this.MA.getCS("PATH", null);
        boolean createOption = this.MA.getState("/CREATE", false);
        boolean deleteOption = this.MA.getState("/DELETE", false);
        String linkPath = this.MA.getCS("/LINK", null);
        boolean restartRequired = false;
        this.debug("OPTION: INPUTS - optName = [" + optName + "]  /create=" + createOption);
        this.debug("                 phys path '" + physPath + "'");
        this.debug("                 link path '" + linkPath + "'");
        if (createOption && deleteOption) {
            this.M.warning("/CREATE and /DELETE switches both present. Using /CREATE.");
        }
        if (linkPath == null || linkPath.equals("")) {
            this.IsALink = false;
            if (createOption) {
                if (Option.isValidPath(physPath)) {
                    String newPhysPath = this.addNxmOpt(physPath = FileUtil.terminatePath(physPath), optName);
                    if (newPhysPath != null) {
                        this.M.warning("Option tree path entered '" + physPath + "' is not valid. Modified to '" + newPhysPath + "'");
                        physPath = newPhysPath;
                    }
                } else {
                    this.M.error("Option path '" + physPath + "' not defined, or invalid");
                }
            }
        } else {
            this.IsALink = true;
            if (linkPath.equalsIgnoreCase("NXM")) {
                this.InNmRoot = true;
                linkPath = Option.getNMRootNxmDir(optName.toLowerCase());
            } else {
                if (linkPath.equalsIgnoreCase("BACK")) {
                    this.M.warning("Back link is TBD");
                    return 9;
                }
                String str = FileName.terminatePath(linkPath).toLowerCase();
                if (!str.endsWith(optName.toLowerCase() + File.separator)) {
                    this.M.info("Link '" + linkPath + "' does not end with option tree name, adding");
                    linkPath = str + optName.toLowerCase();
                }
            }
        }
        if (createOption) {
            if (physPath == null && pathInOptTable != null) {
                physPath = pathInOptTable;
            }
            this.debug("createOptionTree: optName " + optName + " physPath " + physPath + " linkPath " + linkPath);
            if (this.createOptionTree(optName, physPath, linkPath)) {
                if (this.IsALink) {
                    if (!this.InNmRoot) {
                        restartRequired = OptionTree.defineOptionTree(this.M, optName, linkPath);
                    }
                } else {
                    restartRequired = OptionTree.defineOptionTree(this.M, optName, physPath);
                }
            } else {
                this.M.warning("Unable to create option tree [" + optName + "] at path " + physPath);
            }
        } else if (linkPath != null && !linkPath.equals("")) {
            Option.makeLink(this.M, this.verbose, linkPath, physPath);
        } else if (deleteOption) {
            if (optName.length() <= 0) {
                this.M.warning("No option specified to delete.");
            } else if (OptionTree.removeOptionTree(this.M, optName)) {
                this.M.info("Deleted option tree [" + optName + "] from mappings.");
            }
        } else if (physPath != null && physPath.length() > 0) {
            if ("*".equals(optName)) {
                restartRequired = this.defineAllOptsUnder(physPath);
            } else if ("CLASSPATH".equals(physPath)) {
                String optPath = this.find(optName, this.MA.getU("/FIND"), true);
                restartRequired = OptionTree.defineOptionTree(this.M, optName, optPath);
            } else {
                restartRequired = OptionTree.defineOptionTree(this.M, optName, physPath);
            }
        } else if ("*".equals(optName)) {
            this.M.warning("Path not provided for definining all option tree via '*' (star syntax)");
        } else if (this.MA.isPresent("/FIND")) {
            this.find(optName, this.MA.getU("/FIND"), false);
        } else if (this.MA.isPresent("/INFO")) {
            this.info(optName, this.MA.getU("/INFO"));
        } else if (optName.length() > 0) {
            this.listOpt(optName);
        } else if (this.MA.isPresent("/GET")) {
            this.getDefinedOptsList(this.MA.getU("/GET"));
        } else {
            this.listAllOpts();
        }
        if (restartRequired) {
            if (!this.MA.getState("/NOEXIT", this.M.macro != null) && this.M.terminal.isExtCmdSupported() && !Shell.isOneShot()) {
                if (this.verbose) {
                    this.M.info("Restarting shell to reload redefined [" + optName + "] option tree");
                }
                Foreign.runExternal(this.M, "");
            } else {
                this.M.warning("You must exit the shell to reload [" + optName + "] option tree");
            }
        }
        return 9;
    }

    private void getDefinedOptsList(String resLabel) {
        Table options = OptionTree.getAllOptions(this.M);
        String keyList = options.getKeyList();
        if (resLabel != null && resLabel.length() > 0) {
            this.MR.put(resLabel, (Object)keyList);
        }
        if (this.verbose) {
            this.M.println("All defined option trees: " + keyList);
        }
    }

    private String find(String optName, String resLabel, boolean error) {
        if (optName == null || optName.length() <= 0) {
            if (error) {
                this.M.error("No option tree specified.");
            } else {
                this.M.warning("No option tree specified.");
            }
            return null;
        }
        String optRoot = OptionTree.findOptRoot(optName);
        if (optRoot == null) {
            if (error) {
                this.M.error("Unable to find option tree [" + optName + "] in CLASSPATH.");
            } else {
                this.M.warning("Unable to find option tree [" + optName + "] in CLASSPATH.");
            }
        } else if (this.verbose) {
            this.M.println("Found option tree [" + optName + "] at " + optRoot);
        }
        if (resLabel != null && resLabel.length() > 0) {
            this.MR.put(resLabel, (Object)optRoot);
        }
        return optRoot;
    }

    private void info(String optName, String resLabel) {
        if (optName == null || optName.length() <= 0) {
            this.M.warning("No option tree to get information on.");
        } else {
            Table optInfoTbl = OptionTree.getInfo(optName, this.M, this.verbose, true);
            if (optInfoTbl == null) {
                this.M.warning("Unable to get info for option tree [" + optName + "].");
            } else if (this.verbose) {
                String displayKey = resLabel != null && resLabel.length() > 0 ? resLabel : optName + "_OPT_INFO";
                Results.doMultiple(this.M, displayKey, optInfoTbl, null, 0, true, 0, -1, false, this.verbose);
            }
            if (resLabel != null && resLabel.length() > 0) {
                this.MR.put(resLabel, (Object)optInfoTbl);
            }
        }
    }

    private String addNxmOpt(String pathIn, String optName) {
        String pathOut = null;
        String str = "nxm" + File.separator + optName.toLowerCase() + File.separator;
        if (pathIn.indexOf(str) < 0) {
            pathOut = FileName.terminatePath(pathIn) + str;
        }
        return pathOut;
    }

    private static String getNMRootNxmDir(String optName) {
        if (optName == null) {
            return Shell.getNmRoot() + "nxm" + File.separator;
        }
        return Shell.getNmRoot() + "nxm" + File.separator + optName;
    }

    public static boolean isValidPath(String optionPath) {
        boolean validPath = false;
        validPath = optionPath != null && optionPath.length() != 0 && optionPath.indexOf(Shell.getProperty("file.separator")) >= 0;
        return validPath;
    }

    public static boolean makeLink(String linkPath, String physicalPath) {
        return Option.makeLink(Shell.getSharedMidasContext(), false, linkPath, physicalPath);
    }

    public static boolean makeLink(Midas midas, boolean verbose, String linkPath, String physicalPath) {
        boolean madeLink;
        block8: {
            madeLink = false;
            File linkFile = new File(linkPath);
            String ostype = (String)midas.results.get("ENV.OSTYPE");
            if (ostype.indexOf("UNIX") >= 0) {
                boolean mkdirResult;
                File linkParentFile = new File(linkFile.getParent());
                if (!linkParentFile.exists() && !(mkdirResult = linkParentFile.mkdirs())) {
                    midas.warning("Unable to create parent directory: " + linkParentFile);
                }
                if (linkFile.getParentFile().exists()) {
                    try {
                        String cmd = "ln -s -n -f " + physicalPath + " " + linkFile.getPath();
                        boolean wait = true;
                        int status = Foreign.runInternal(midas, cmd, wait);
                        if (status == 0) {
                            if (verbose) {
                                midas.info("Created link " + linkFile.getPath() + " to " + physicalPath);
                            }
                            madeLink = true;
                            break block8;
                        }
                        midas.warning("Link command '" + cmd + "' FAILED");
                        madeLink = false;
                    }
                    catch (Exception ex) {
                        midas.warning("Could not create link '" + linkFile.getPath() + " to '" + physicalPath + "'");
                    }
                }
            } else {
                Shell.warning("Links not supported in os type " + ostype);
            }
        }
        return madeLink;
    }

    public boolean createOptionSubDirs(File treeRoot) {
        boolean createdSubDirs = true;
        Parser parseSubDirs = new Parser("CFG,MCR,INC,PRIM,EXP,DAT,HOST,DOCS,TEST".toLowerCase());
        for (int i = 1; i <= parseSubDirs.elements(); ++i) {
            File subDir = new File(treeRoot, parseSubDirs.get(i));
            if (subDir.exists()) continue;
            createdSubDirs = subDir.mkdir();
        }
        return createdSubDirs;
    }

    private void debug(String str) {
        if (this.debug) {
            this.M.type(str);
        }
    }

    public File getOptionSubDirFile(File treeRoot, String subName) {
        File subDirFile = null;
        String lowerCaseSubName = subName.toLowerCase();
        Parser parseSubDirs = new Parser("CFG,MCR,INC,PRIM,EXP,DAT,HOST,DOCS,TEST".toLowerCase());
        for (int i = 1; i <= parseSubDirs.elements(); ++i) {
            File subDir = new File(treeRoot, parseSubDirs.get(i));
            if (subDir.toString().indexOf(lowerCaseSubName) < 0) continue;
            subDirFile = subDir;
            break;
        }
        return subDirFile;
    }

    public boolean createOptionTree(String treeName, String physicalPath, String linkPath) {
        boolean optionTreeCreated = false;
        this.debug("createOptionTree: Option physical path name " + physicalPath);
        this.debug("createOptionTree: Option link path name " + linkPath);
        this.debug("createOptionTree: IsALink? " + this.IsALink);
        boolean problemMakingLink = false;
        if (this.IsALink) {
            boolean bl = problemMakingLink = !Option.makeLink(this.M, this.verbose, linkPath, physicalPath);
        }
        if (!problemMakingLink) {
            File optTreeRootFile = new File(physicalPath);
            if (optTreeRootFile.exists()) {
                this.M.warning("Tree root " + optTreeRootFile + " already exists");
            } else if (optTreeRootFile.mkdirs()) {
                this.debug("Created tree root " + optTreeRootFile);
            } else {
                this.M.warning("Unable to create option tree root " + optTreeRootFile);
            }
            this.debug("Option tree root " + optTreeRootFile);
            if (optTreeRootFile.exists()) {
                boolean problemCreatingSubDirs;
                boolean bl = problemCreatingSubDirs = !this.createOptionSubDirs(optTreeRootFile);
                if (!problemCreatingSubDirs) {
                    optionTreeCreated = true;
                }
                if (optionTreeCreated) {
                    File cfgDir = this.getOptionSubDirFile(optTreeRootFile, "CFG");
                    File cmdFile = new File(cfgDir, COMMAND_FILE_NAME);
                    if (cmdFile.exists()) {
                        this.M.info("commands.cnf already exists in " + cfgDir);
                    } else {
                        String sysCfgDirName = Shell.getOptPath("SYS", "CFG");
                        File cmdTemplateFile = new File(sysCfgDirName, "commands.template");
                        try {
                            FileUtil.copyBaseFile(this.M, cmdTemplateFile, cmdFile);
                        }
                        catch (Exception e) {
                            this.M.printStackTrace("Problem copying " + cmdTemplateFile + " to " + cmdFile, e);
                        }
                        this.M.info("Created option tree [" + treeName + "] in path " + physicalPath);
                    }
                }
            }
        } else {
            optionTreeCreated = false;
        }
        return optionTreeCreated;
    }

    private void listOpt(String name) {
        this.listAllOpts(name);
    }

    private void listAllOpts() {
        this.listAllOpts(null);
    }

    private void listAllOpts(String listOnly) {
        String path;
        Table options = OptionTree.getAllOptions(this.M);
        String optPath = this.MR.getS("OPT.PATH");
        Object[] keys = options.getKeys();
        Arrays.sort(keys);
        if (listOnly == null) {
            this.M.println("Available Option Trees (<n> = index on path):");
        } else if (!options.containsKey(listOnly.toUpperCase())) {
            this.M.warning("Option tree [" + listOnly + "] not found.");
        }
        int max = Parser.findIndex(optPath, "SYS");
        for (int i = 0; i < keys.length; ++i) {
            int index = Parser.findIndex(optPath, (String)keys[i]);
            String marker = "    ";
            if (index >= 10) {
                marker = "<" + index + ">";
            } else if (index >= 0 && max >= 10) {
                marker = "< " + index + ">";
            } else if (index >= 0) {
                marker = " <" + index + ">";
            }
            marker = listOnly == null ? "  " + marker + " " : "";
            Table opt = options.getTable((String)keys[i]);
            String name = StringUtil.padRight((String)keys[i], 12);
            path = opt.getS("PATH");
            String base = opt.getS("CFGROOT");
            String root = opt.getS("NXMROOT");
            String type = opt.getS("TYPE");
            String dir = null;
            boolean link = opt.getState("LINK");
            if (type.equals("UNDER_NMROOT")) {
                dir = base;
            } else if (type.equals("JAR_FILE")) {
                dir = root;
            } else if (link) {
                dir = path + " -> " + base;
                if (type.equals("BACK_LINK")) {
                    dir = dir + " <UnusedBackLink>";
                }
            } else {
                dir = base;
                if (type.equals("BACK_LINK")) {
                    dir = dir + " <UsesBackLink>";
                }
            }
            if (listOnly != null && !listOnly.equalsIgnoreCase((String)keys[i])) continue;
            this.M.println(marker + name + " = " + dir);
        }
        for (Object optname : keys) {
            Table opt = options.getTable((String)optname);
            path = opt.getS("PATH");
            String type = opt.getS("TYPE");
            if (type != null && !type.equals("ERROR") || listOnly != null && !listOnly.equalsIgnoreCase((String)optname)) continue;
            this.M.warning("OPTION: The path " + path + " may not be a valid option tree path for [" + (String)optname + "]. Could not find " + path + "nxm" + File.separator + ((String)optname).toLowerCase() + File.separator + "cfg.");
        }
    }

    private boolean defineAllOptsUnder(String pathstr) {
        boolean restartRequired = false;
        File path = new File(pathstr = FileUtil.terminatePath(pathstr));
        File[] files = path.listFiles(DIR_FILTER);
        if (files == null) {
            throw new MidasException("OPTION: No files found for [" + pathstr + "].");
        }
        for (File dir : files) {
            String optName = dir.getName().toUpperCase();
            String optPath = dir.getPath() + File.separator;
            restartRequired |= OptionTree.defineOptionTree(this.M, optName, optPath);
            if (!this.verbose) continue;
            this.M.info("Defined option [" + optName + "] under path " + optPath);
        }
        return restartRequired;
    }

    private static class DirectoryFilter
    implements FileFilter {
        private DirectoryFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() && pathname.getName().indexOf(46) == -1;
        }
    }
}

