/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import nxm.sys.lib.Args;
import nxm.sys.lib.Command;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.Macro;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Shell;
import nxm.sys.lib.TextFile;

public class Macrofunc
extends Intrinsic {
    private String func;
    private String name;
    private Macro macro;
    private int index1;
    private int index2;
    private int wind;

    @Override
    public int process() {
        this.name = this.MA.getU("NAME");
        this.func = this.MA.getU("FUNC");
        this.wind = this.MA.getL("WIND");
        if (this.func.equals("ENTER")) {
            if (this.name == null || this.name.length() <= 0) {
                this.M.error("Need to give a macro name (like mymacro) to generate new macro");
            } else {
                String userMacro = this.name;
                if (!this.name.startsWith("%")) {
                    userMacro = "%" + userMacro;
                }
                Macrofunc.enterMacroText(this.M, userMacro, "startmacro", "endmacro");
                Shell.runCommand(this.M, userMacro);
            }
        } else if (this.func.equals("LIST")) {
            if (this.M.macro != null && (this.name == null || this.name.equals(""))) {
                this.macro = this.M.macro;
                this.index1 = Math.max(1, this.macro.nextIndex - this.wind);
                this.index2 = Math.min(this.macro.lastIndex, this.macro.nextIndex + this.wind);
            } else {
                Args targs = Shell.parseCommand(this.M, this.name);
                Command command = Shell.loadCommand(this.M, targs);
                if (!(command instanceof Macro)) {
                    this.M.error("Unable to load macro: '" + this.name + "'");
                    return 9;
                }
                this.macro = (Macro)command;
                this.macro.loadText();
                this.index1 = 1;
                this.index2 = this.macro.lastIndex;
            }
            this.M.more(1);
            for (int i = this.index1; i < this.index2; ++i) {
                String line = i == this.macro.nextIndex ? "*" : " ";
                this.M.more(line + i + "-> " + this.macro.lines[i].toString());
            }
            this.M.more(9);
        }
        return 9;
    }

    public static void enterMacroText(Midas M, String name, String seed, String term) {
        String fname = Macro.getFileName(M, name, "USER");
        Macrofunc.writeMacroText(M, fname, seed, term);
    }

    static String enterIntrMacroText(Midas M, String name, String seed, String term) {
        String aux = Shell.getAuxPath("HOMEPATH").startsWith("classpath:") ? "WRITE" : "HOMEPATH";
        String fname = M.io.name(aux, name.substring(1), "MM", "AUX");
        Macrofunc.writeMacroText(M, fname, seed, term);
        return "%" + fname;
    }

    private static void writeMacroText(Midas M, String fname, String seed, String term) {
        Shell shell;
        TextFile tf = new TextFile(M, (Object)fname);
        tf.open(8194);
        String line = "OK";
        tf.writeln("startmacro /sharemask=+RESULTS \n");
        tf.writeln("  global;sys/readall\n");
        if (!seed.startsWith("startmacro")) {
            tf.writeln("  " + seed);
        }
        Shell shell2 = shell = M.getTerminal() != null && M.getTerminal().getShell() != null ? M.getTerminal().getShell() : Shell.getCurrent();
        while (line.length() > 0) {
            line = shell.getNextCommand(">>> ", "");
            if (line.length() > 0) {
                if (line.startsWith(term)) {
                    tf.writeln("  " + line);
                } else {
                    tf.writeln("    " + line);
                }
            }
            if (line.startsWith(term)) break;
            seed = "";
        }
        if (line.length() == 0) {
            if (term.startsWith("endmacro")) {
                tf.writeln(term);
            } else {
                tf.writeln("  " + term + "\n");
            }
            M.println(">>> " + term);
        }
        if (!term.startsWith("endmacro")) {
            tf.writeln("endmacro");
        }
        tf.close();
    }
}

