/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.util.Arrays;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.Parser;

public class Invoke
extends Intrinsic {
    protected boolean moreVerbose = false;
    protected boolean debug = false;

    @Override
    public int open() {
        if (this.verbose) {
            this.moreVerbose = this.MA.getState("/VERBOSE");
        }
        this.debug = this.MA.getState("/DEBUG");
        return 0;
    }

    @Override
    public int process() {
        boolean oldSchool;
        String label = this.MA.getU("LABEL");
        String func = this.MA.getQ("FUNC");
        String firstKey = this.MA.getKey(1);
        boolean bl = oldSchool = !this.isEmpty(label) && !this.isEmpty(func) || this.MA.getNArgs() == 2 && (firstKey.equals("LABEL") || firstKey.equals("P1"));
        if (oldSchool) {
            label = this.MA.getU(1);
            func = this.MA.getQ(2);
            Object value = this.doInvoke(func, false);
            this.outputResults(label, value);
        } else {
            int argCount = 0;
            while (argCount < this.MA.getNArgs()) {
                String key;
                label = key = this.MA.getKey(++argCount);
                func = this.MA.getQ(key);
                Object value = this.doInvoke(func, false);
                this.outputResults(label, value);
            }
        }
        return 9;
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private void outputResults(String label, Object value) {
        if (!this.isEmpty(label)) {
            this.MR.put(label, value);
        }
        if (this.verbose) {
            if (this.isEmpty(label)) {
                this.M.println("Invoke: ANSWER = " + value);
            } else if (this.moreVerbose) {
                this.M.println("Invoke: " + label + " = " + value);
            }
        }
    }

    protected Object doInvoke(String func, boolean assumeClassName) {
        int funcLen = func.length();
        int iLparen = func.indexOf(40);
        if (iLparen < 0) {
            iLparen = funcLen;
        } else {
            int iRparen = func.lastIndexOf(41);
            if (iRparen < funcLen - 1) {
                this.M.error("Missing closing right parenthesis ')' or extra character(s) after it.");
            }
        }
        int i = func.substring(0, iLparen).lastIndexOf(46);
        if (i <= 0) {
            this.M.error("Malformed function string: '" + func + "'");
        }
        String name = func.substring(0, i);
        Object root = null;
        Object[] args = null;
        if (!assumeClassName && !name.equals("") && (root = this.MR.get(name.toUpperCase())) == null && (root = this.MR.get("REG." + name.toUpperCase())) == null) {
            assumeClassName = true;
        }
        if (assumeClassName) {
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                if (this.debug) {
                    this.M.info("Loading " + name + " using ClassLoader=" + loader);
                }
                Class<?> c = loader.loadClass(name);
                root = c;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (root == null) {
            this.M.error("Could not find Object named: " + name);
        }
        if (iLparen < funcLen) {
            args = this.parseArgs(func.substring(iLparen + 1, func.length() - 1));
            func = func.substring(i + 1, iLparen);
        } else {
            args = null;
            func = func.substring(i + 1);
        }
        if (this.moreVerbose) {
            this.M.type("doInvoke() calling KeyObject.getKey() root=" + root + " func=" + func + " args[]=" + Arrays.toString(args));
        }
        return KeyObject.getKey(root, func, args, this);
    }

    private Object[] parseArgs(String str) {
        Parser parser = new Parser(str);
        parser.clean(false);
        Object[] objs = new Object[parser.elements()];
        for (int i = 0; i < objs.length; ++i) {
            objs[i] = Convert.s2o(parser.get(i + 1), '_', (Object)this);
        }
        return objs;
    }
}

