/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.util.HashSet;
import nxm.sys.intr.Erase;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.TextFile;

public class Files
extends Intrinsic {
    private String path;
    private String name;
    private String ext;
    private String aux;
    private String uid;
    private boolean erase;
    private boolean toFile;
    private String listRes;
    private StringBuilder listVal;
    private boolean verboseListing;
    private boolean headerOnly;
    private int recurse;
    private boolean debug;
    private boolean nameOnly;
    private boolean outputToText;
    public String recurseList = "Full,LevelFind,FirstFind";
    private static final int R_NONE = 0;
    private static final int R_FULL = 1;
    private static final int R_LEVELFIND = 2;
    private static final int R_FIRSTFIND = 3;
    public static final int ROOT = 1;
    public static final int EXT = 2;
    private DataFile df;
    private TextFile tf;
    private Data db;

    @Override
    public int process() {
        this.outputToText = false;
        this.name = this.MA.getS("NAME");
        FileName fn = new FileName(this.name);
        this.ext = this.MA.getS("EXT");
        boolean strict = false;
        if ((this.ext == null || this.ext.isEmpty()) && this.MA.getState("/STRICT")) {
            strict = true;
        } else {
            if (this.ext == null || this.ext.isEmpty()) {
                this.ext = Files.parseComplexName(this.name, 2);
            }
            this.name = Files.parseComplexName(this.name, 1);
        }
        this.path = fn.getPath();
        this.aux = this.MA.getS("AUX");
        this.uid = this.MA.getS("UID");
        this.debug = this.MA.getState("/DEBUG", false);
        if (this.debug) {
            this.M.info("Name '" + this.name + "', ext '" + this.ext + "', aux '" + this.aux + "'");
        }
        if (this.aux.equals("*")) {
            this.aux = "";
        }
        if (this.aux.equals("ALL")) {
            this.aux = "";
        }
        this.listRes = this.MA.getU("/LIST", null);
        this.toFile = this.MA.find("/F");
        this.verboseListing = this.MA.getState("/V", false);
        this.headerOnly = this.verboseListing ? false : this.MA.getState("/H", false);
        this.erase = this.MA.find("/E");
        this.recurse = this.MA.getSelectionIndex("/R", this.recurseList, 0);
        this.nameOnly = this.MA.getState("/NAMEONLY");
        if (this.listRes != null) {
            if (this.toFile) {
                this.M.error("Cannot combine /F and /LIST=");
            }
            this.listVal = new StringBuilder();
        } else if (this.toFile) {
            FileName outfn = this.MA.getFileName("/F", "files.tmp", "files.tmp");
            String form = this.MA.getS("/FORM", "XA");
            if (outfn.getExt().equalsIgnoreCase("txt")) {
                this.tf = new TextFile(this.M, (Object)outfn);
                this.tf.open(2);
                this.outputToText = true;
                if (this.verbose) {
                    this.M.info(" ... writing to TextFile '" + this.tf.filename + "'");
                }
            } else {
                this.df = new DataFile();
                this.df.init(this.M, (Object)outfn, "1000", form, 0);
                this.df.open(2);
                this.db = this.df.getDataBuffer(1);
                if (this.verbose) {
                    this.M.info(" ... writing to DataFile '" + this.df.filename + "'");
                }
            }
        } else {
            this.M.terminal.more(1);
        }
        if (this.path.length() > 0) {
            this.listFiles("NOT", this.path, this.name, this.ext, strict);
        } else if (this.aux.isEmpty()) {
            String excludeList = this.MA.getS("/EXCLUDE");
            HashSet<String> xset = null;
            if (excludeList != null && !excludeList.isEmpty()) {
                excludeList = excludeList.toUpperCase();
                Parser xauxes = new Parser("|" + excludeList + "|", '|');
                xset = new HashSet<String>();
                for (String aux : xauxes.getArray(0)) {
                    xset.add(aux);
                }
            }
            String raux = this.MR.getString("AUX.READ");
            Parser auxes = new Parser(raux, '|');
            int naux = auxes.elements();
            for (int i = 1; i <= naux; ++i) {
                String iaux = auxes.get(i);
                if (xset != null ? xset.contains(iaux) : Shell.getCurrent().isExcludedAux(iaux)) continue;
                String ipath = this.M.io.getAuxPath(iaux);
                String match = null;
                for (int j = 1; j < i && match == null; ++j) {
                    String jaux = auxes.get(j);
                    String jpath = this.M.io.getAuxPath(jaux);
                    if (!jpath.equals(ipath)) continue;
                    match = jaux;
                }
                if (match == null) {
                    this.listFiles(iaux, ipath, this.name, this.ext, strict);
                    continue;
                }
                if (this.toFile || this.listRes != null) continue;
                this.M.more("Auxiliary [" + iaux + "] = " + ipath + " matches Auxiliary [" + match + "] (skipping)");
            }
        } else {
            String auxPath = this.M.io.getAuxPath(this.aux);
            if (auxPath != null) {
                this.listFiles(this.aux, auxPath, this.name, this.ext, strict);
            } else {
                this.listFiles("NOT", this.aux, this.name, this.ext, strict);
            }
        }
        if (this.listRes != null) {
            this.MR.put(this.listRes, (Object)this.listVal.toString());
        } else if (this.toFile) {
            if (this.df != null && this.df.isOpen) {
                this.df.close();
            }
            if (this.tf != null && this.tf.isOpen) {
                this.tf.close();
            }
        } else {
            this.M.terminal.more(9);
        }
        return 9;
    }

    private boolean checkForExcludedAux(String aux, String[] list3) {
        for (String xaux : list3) {
            if (!aux.equals(xaux)) continue;
            return true;
        }
        return false;
    }

    private int listFiles(String aux, String path, String name, String ext, boolean strict) {
        if (strict) {
            if (name.indexOf(124) == 0) {
                name = name.substring(1);
            }
            int barPos = name.indexOf(124);
            int count = 0;
            if (barPos > 0) {
                while (barPos > 0) {
                    FileName fn = new FileName(name.substring(0, barPos));
                    String tmpExt = fn.getExt();
                    String tmpName = fn.getRoot();
                    count += Math.max(0, this.listFiles(aux, path, tmpName, tmpExt));
                    name = name.substring(barPos + 1) + "|";
                    barPos = name.indexOf(124);
                }
            } else {
                FileName fn = new FileName(name.substring(0, barPos));
                String tmpExt = fn.getExt();
                String tmpName = fn.getRoot();
                count += Math.max(0, this.listFiles(aux, path, tmpName, tmpExt));
            }
            return count;
        }
        return this.listFiles(aux, path, name, ext);
    }

    private static String parseComplexName(String name, int type) {
        if (type != 1 && type != 2 || name == null || name.isEmpty()) {
            return "";
        }
        StringBuilder retStr = new StringBuilder();
        int len = name.length();
        while (name.indexOf(124) == 0) {
            name = name.substring(1);
        }
        while (name.lastIndexOf(124) == len - 1) {
            name = name.substring(0, len - 1);
        }
        int barPos = name.indexOf(124);
        if (barPos >= 0) {
            retStr.append(Files.parseComplexName(name.substring(0, barPos), type));
            retStr.append("|");
            name = name.substring(barPos + 1);
            barPos = name.indexOf(124);
            if (barPos > 0) {
                retStr.append(Files.parseComplexName(name, type));
            }
        }
        FileName fn = new FileName(name);
        if (type == 1) {
            retStr.append(fn.getRoot());
        } else if (type == 2) {
            retStr.append(fn.getExt());
        }
        return retStr.toString();
    }

    private int listFiles(String aux, String path, String name, String ext) {
        BaseFile bf;
        String[] files = this.M.io.listFiles(path, name, ext);
        FileName fn = null;
        if (files == null) {
            fn = new FileName(path, true);
            files = this.M.io.listFiles(fn, name, ext);
        }
        if (files == null) {
            if (!this.toFile && !this.erase && this.listRes == null) {
                this.M.more("Auxiliary [" + aux + "] = " + path + " (not a directory)");
            }
            return -1;
        }
        int n = files.length;
        if (this.recurse == 3 && n > 0) {
            this.recurse = 0;
            n = 1;
        }
        if (this.listRes != null) {
            for (String filename : files) {
                if (this.listVal.length() > 0) {
                    this.listVal.append(',');
                }
                if (!this.nameOnly) {
                    this.listVal.append(path);
                }
                this.listVal.append(filename);
            }
        } else if (this.toFile) {
            for (String filename : files) {
                String str;
                String string = str = this.nameOnly ? filename : path + filename;
                if (this.outputToText) {
                    this.tf.writeln(str);
                    continue;
                }
                this.db.fromString(str);
                this.df.write(this.db);
            }
        } else if (this.erase) {
            for (String filename : files) {
                bf = BaseFile.getInstanceFor(this, (Object)(path + filename));
                Erase.eraseFile(this.M, bf, this.verbose, true, false);
            }
        } else {
            this.M.more("Auxiliary [" + aux + "] = " + path + "   (" + n + " files)");
            if (this.headerOnly && n > 0) {
                this.M.more(" Type  Form   Elements   Data Bytes  Filename");
                this.M.more(" ------------------------------------------------------");
            }
            for (String filename : files) {
                fn = new FileName(path + filename, true);
                if (this.verboseListing) {
                    bf = BaseFile.getInstanceFor(this, (Object)fn);
                    if (!bf.open()) {
                        --n;
                        continue;
                    }
                    this.M.print(bf.listHeader());
                    bf.close();
                    this.M.more("");
                    continue;
                }
                if (this.headerOnly) {
                    bf = null;
                    try {
                        bf = BaseFile.getInstanceFor(this, (Object)fn);
                    }
                    catch (Exception e) {
                        this.M.printStackTrace("Exception when getting Instance for file " + filename, e);
                        --n;
                        continue;
                    }
                    String typeAndForStr = "";
                    String elemStr = "";
                    String sizeStr = "";
                    boolean dfOpenError = false;
                    if (bf instanceof DataFile) {
                        try {
                            if (!bf.open()) {
                                --n;
                                continue;
                            }
                            DataFile hcb = (DataFile)bf;
                            typeAndForStr = typeAndForStr + hcb.getType() + "  " + hcb.getFormat();
                            elemStr = elemStr + hcb.size;
                            sizeStr = sizeStr + (long)hcb.getDataSize();
                            hcb.close();
                        }
                        catch (Exception e) {
                            dfOpenError = true;
                            bf = new BaseFile(this, (Object)fn);
                        }
                    }
                    if (!(bf instanceof DataFile)) {
                        try {
                            if (!bf.open()) {
                                --n;
                                continue;
                            }
                        }
                        catch (Exception e) {
                            this.M.printStackTrace("Exception when attempting to open file " + bf.filename, e);
                        }
                        String type = bf.getClass().getName();
                        int index = Math.max(type.lastIndexOf(46), type.lastIndexOf(36));
                        if (index > 0) {
                            type = type.substring(index + 1);
                        }
                        if (type.endsWith("File")) {
                            type = type.substring(0, type.length() - 4);
                        }
                        typeAndForStr = typeAndForStr + type.toUpperCase();
                        sizeStr = sizeStr + (long)bf.getSize();
                        bf.close();
                    }
                    if (dfOpenError) {
                        typeAndForStr = "ERROR";
                    }
                    StringBuilder sb = new StringBuilder(120);
                    sb.append(' ');
                    StringUtil.padRight(sb, typeAndForStr, 10, ' ');
                    sb.append("  ");
                    StringUtil.padRight(sb, elemStr, 10, ' ');
                    sb.append("  ");
                    StringUtil.padRight(sb, sizeStr, 10, ' ');
                    sb.append("  ");
                    sb.append(filename);
                    this.M.more(sb);
                    continue;
                }
                this.M.more("  " + filename, 20);
            }
            if (this.headerOnly && n > 0) {
                this.M.more("");
            }
            this.M.more(2);
        }
        if (this.recurse != 0 && (this.recurse != 2 || n <= 0)) {
            String[] dirs = this.M.io.listFiles(path, "*", "dir");
            if (dirs == null && fn != null) {
                fn = new FileName(path, true);
                dirs = this.M.io.listFiles(fn, "*", "dir");
            }
            for (int i = 0; i < dirs.length && this.recurse != 0; ++i) {
                this.listFiles(aux + ".", FileName.addPathDir(path, dirs[i]), name, ext);
            }
        }
        return n;
    }
}

