/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import nxm.sys.lib.BaseFile;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.Parser;
import nxm.sys.lib.TextFile;

public class File
extends Intrinsic {
    @Override
    public int process() {
        String func = this.MA.getU("FUNC");
        String label = this.MA.getU("LABEL");
        if (func.startsWith("OPEN")) {
            int flags = 0;
            if (func.indexOf("/A") > 0) {
                flags |= 8;
            }
            if (func.indexOf("/N") > 0) {
                flags |= 2;
            }
            if (func.indexOf("/W") > 0) {
                flags |= 3;
            }
            BaseFile bf = func.indexOf("/D") > 0 ? this.MA.getDataFile("P1") : (func.indexOf("/T") > 0 ? this.MA.getTextFile("P1") : this.MA.getFile("P1"));
            bf.open(flags);
            this.MR.put(label, (Object)bf);
        } else if (func.equals("PROTECT") || func.equals("UNPROTECT")) {
            String fname = this.MA.getFileName("LABEL") + "";
            fname = fname + (fname.endsWith(".cdif") ? "{PROT=0,FORCE=TRUE}" : "{PROT=0}");
            DataFile df = new DataFile(this, (Object)fname);
            df.open(3);
            df.setProtected(func.equals("PROTECT"));
            df.close();
        } else if (func.startsWith("SAVE")) {
            BaseFile bf = this.MA.getBaseFile("LABEL");
            if (!bf.find(-1)) {
                this.M.error("File " + bf.getURL() + " not found for save");
            }
            FileName fn = new FileName(bf.getURL());
            fn.setExt("prm");
            bf.rename(fn.getFullName());
        } else if (func.startsWith("RENAME")) {
            boolean overWrite;
            BaseFile bfi = this.MA.getFile("LABEL");
            if (!bfi.find(-1)) {
                this.M.error("File " + bfi.getURL() + " not found for rename");
            }
            BaseFile bfo = this.MA.getFile("P1");
            boolean bl = overWrite = func.indexOf("/F") > 0;
            if (!overWrite && this.MA.getState("/F")) {
                this.M.deprecate("FILE: /F command switch is deprecated use RENAME/F.");
                overWrite = true;
            }
            if (bfo.find(1) && !overWrite) {
                this.M.error("Use RENAME/F to overwrite existing file: " + bfo.getURL());
            }
            bfi.rename(bfo.getURL());
        } else if (func.startsWith("COPY")) {
            FileName inFile = this.MA.getFileName("LABEL");
            FileName outFile = this.MA.getFileName("P1");
            int xfer = this.MA.getL("/TL", BaseFile.BUFFER_SIZE);
            if (func.indexOf("/F") < 0 && this.exists(outFile)) {
                this.M.error("Use COPY/F to overwrite existing file: " + outFile);
            }
            if (func.indexOf("/M") > 0) {
                Object flags = outFile.getQualifier("FLAGS");
                if (flags == null) {
                    outFile.setQualifier("FLAGS", "MKDIR");
                } else {
                    outFile.setQualifier("FLAGS", flags.toString() + "|MKDIR");
                }
            }
            if (func.indexOf("/L") > 0) {
                String propMask = this.MA.getS("/PROPMASK", "NONE");
                if (this.MA.getState("/PROPAGATE", true)) {
                    FileUtil.copyListFile(this.M, (Object)inFile, (Object)outFile, FileUtil.PROPAGATE, propMask);
                } else {
                    FileUtil.copyListFile(this.M, (Object)inFile, (Object)outFile, null, propMask);
                }
            } else {
                FileUtil.copyBaseFile(this.M, inFile, outFile, xfer);
            }
        } else if (func.startsWith("NAME")) {
            FileName fn;
            String[] path = this.parseList(this.MA.getCS("P1"));
            String root = this.MA.getCS("P2");
            String ext = this.MA.getCS("P3");
            if (path != null && path.length != 0) {
                if (!FileUtil.startsWithRootDir(path[0]) && path[0].indexOf(58) <= 0) {
                    path[0] = FileName.LOCAL_PATH_DELIM + path[0];
                }
                fn = new FileName(path, root, ext);
            } else {
                fn = new FileName("", root, ext);
            }
            this.MR.put(label, (Object)fn.getFullName());
        } else if (func.startsWith("DETACH")) {
            DataFile dfi = this.MA.getDataFile("LABEL", "", "", 3);
            String dataFnExtension = this.MA.getCS("P1", "1");
            boolean overwriteExisting = func.indexOf("/F") > 0;
            boolean copyDataToNewFile = func.indexOf("/D") > 0;
            this.detachBLUE(dfi, dataFnExtension, overwriteExisting, copyDataToNewFile);
        } else {
            Object f = this.MR.get(label);
            TextFile tf = null;
            DataFile df = null;
            BaseFile bf = null;
            if (f instanceof TextFile) {
                tf = (TextFile)f;
            } else if (f instanceof DataFile) {
                df = (DataFile)f;
            } else if (f instanceof BaseFile) {
                bf = (BaseFile)f;
            } else {
                this.M.error("File " + label + " must be a Text|Data|BaseFile object");
            }
            if (func.equals("READ")) {
                String p1;
                Object value = null;
                if (tf != null && tf.isOpen) {
                    value = tf.read();
                }
                if (df != null && df.isOpen) {
                    value = df.getData(df.seek());
                }
                if ((p1 = this.MA.getU("P1")).length() > 0) {
                    this.MR.put(p1, value);
                } else {
                    this.M.println(value.toString());
                }
            } else if (func.equals("NEXT")) {
                String p1;
                String value = null;
                if (tf != null && tf.isOpen) {
                    value = tf.readProper();
                }
                if ((p1 = this.MA.getU("P1")).length() > 0) {
                    this.MR.put(p1, (Object)value);
                } else {
                    this.M.println(value.toString());
                }
            } else if (func.equals("WRITE")) {
                if (tf != null && tf.isOpen) {
                    tf.writeln(this.MA.getS("P1"));
                }
                if (df != null && df.isOpen) {
                    df.setData(df.seek(), this.MA.getO("P1"));
                }
            } else if (func.equals("CLOSE")) {
                if (tf != null && tf.isOpen) {
                    tf.close();
                }
                if (df != null && df.isOpen) {
                    df.close();
                }
                if (bf != null && bf.isOpen) {
                    bf.close();
                }
                this.MR.remove(label);
            } else {
                this.M.warning("Unsupported function: " + func);
            }
        }
        return 9;
    }

    private boolean exists(FileName fn) {
        return this.M.io.findResource(fn, -1).exists();
    }

    public String[] parseList(String in) {
        String[] plist = null;
        if (in != null && !in.isEmpty()) {
            if (in.indexOf(40) >= 0) {
                if (in.indexOf(41) >= 0) {
                    String pathDelimString = in.substring(1, in.length() - 1);
                    Parser p = new Parser(pathDelimString);
                    plist = new String[p.elements()];
                    int i = 1;
                    while (p.more()) {
                        plist[i - 1] = p.get(i);
                        ++i;
                    }
                } else {
                    this.M.warning("invalid parentheses");
                }
            } else {
                plist = new String[]{in};
            }
        }
        return plist;
    }

    private void detachBLUE(DataFile df, String detachExt, boolean overwrite, boolean copyData) {
        df.open();
        if (df.getDetached() != 0) {
            this.M.warning("Header is already detached for " + df.getURL());
        } else {
            df.setDetached(detachExt);
            String detfilename = df.getDetachName();
            if (!overwrite && this.M.io.exists(detfilename)) {
                df.setOutput(false);
                df.close();
                this.M.error("Use DETACH/F modifier to overwrite existing file: " + detfilename);
            }
            String inurl = df.getURL();
            DataFile dfHeader = new DataFile(this.M, (Object)inurl, df, 1024);
            if (copyData) {
                BaseFile bfData = new BaseFile(this.M, (Object)detfilename);
                FileUtil.copyBaseFile(this.M, df, bfData);
                dfHeader.setDataStart(0.0);
                bfData.close();
                if (this.verbose) {
                    this.M.info("Data section copied to: " + detfilename);
                }
            } else {
                int renameStatus = df.rename(detfilename);
                if (renameStatus == 1 || renameStatus == 16) {
                    if (this.verbose) {
                        this.M.info("Data renamed to: " + detfilename + " dataStart=" + df.getDataStart());
                    }
                } else {
                    this.M.error("Renaming " + inurl + " to " + detfilename + " - Deatch aborted");
                }
            }
            dfHeader.open();
            dfHeader.setDetached(detachExt);
            dfHeader.setSize(df.getSize());
            dfHeader.close();
            if (this.verbose) {
                this.M.info("Header detached to: " + inurl);
            }
        }
        df.close();
    }
}

