/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.net.InetAddress;
import java.util.Map;
import java.util.Properties;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.intr.Results;
import nxm.sys.lib.Convert;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Native;
import nxm.sys.lib.Privileges;
import nxm.sys.lib.Registry;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.libg.Theme;
import nxm.sys.net.NetUtil;

public class Environment
extends Intrinsic
implements Keyable {
    private static final String[] keysCS = new String[]{"CompletionAuxExclude", "DefaultTableFlags", "DefaultTableMode", "FileNameCase", "HostNameFQDN", "NumNonVirtScreens", "NumScreens", "Priv", "Server", "ServerFQDN", "UseNative"};
    private static final String[] keys = Environment.toUpper(keysCS);

    @Override
    public int process() {
        String func = this.MA.getU("FUNC");
        String key = this.MA.getU("KEY").toUpperCase();
        String label = this.MA.getU("VALUE");
        boolean all = this.MA.getState("/ALL");
        if (func.startsWith("SH")) {
            if (key.length() == 0) {
                this.showEnvironment(all);
            } else if (key.startsWith("THR")) {
                this.listAllThreads();
            } else if (key.startsWith("MEM")) {
                this.listAllMemory();
            } else if (key.startsWith("PROP")) {
                this.listAllProperties(label);
            } else if (key.equals("HANDLERS")) {
                Results.listMultipleResult(this.M, Registry.handlers, "*", 0, true);
            } else if (key.equals("KEYGETS") || key.equals("KEYSETS")) {
                this.M.deprecate("ENVIRONMENT: Since NeXtMidas 2.7.0 " + key + " is deprecated (always blank).");
                Results.listMultipleResult(this.M, new Table(), "*", 0, true);
            } else {
                Results.listSingleResult(this.M, this.M.results, "ENV." + key, 0, all);
            }
        } else if (func.equals("SET")) {
            Object value = this.MA.getO("VALUE");
            this.setKey(key, value);
            if (this.M.macro != null && this.M.macro.isTxt() && key.equals("BREAK") && this.M.pipeMode != 0) {
                this.M.pipeMode = 5;
            }
        } else if (func.equals("GET")) {
            Object value = this.getKey(key);
            if (label == null || label.length() == 0) {
                this.M.type(key + " = " + value);
            } else {
                this.MR.put(label, value);
            }
        } else if (func.startsWith("NSLOOKUP")) {
            try {
                InetAddress addr = InetAddress.getByName(key);
                String hostaddr = addr.getHostAddress();
                if (label == null || label.length() == 0) {
                    this.M.info("Inet = " + hostaddr);
                }
                this.MR.put(label, (Object)hostaddr);
            }
            catch (Exception e) {
                throw new MidasException("NSLOOKUP exception: " + e, e);
            }
        } else if (func.equals("GC")) {
            if (this.verbose) {
                this.M.print("before GC: ");
                this.listAllMemory();
            }
            System.gc();
            Time.sleep(0.01);
            System.gc();
            if (this.verbose) {
                this.M.print("after  GC: ");
                this.listAllMemory();
            }
        } else {
            this.M.error("Unknown environment function: " + func);
        }
        return 9;
    }

    private static String[] toUpper(String[] orig) {
        String[] array = new String[orig.length];
        for (int i = 0; i < orig.length; ++i) {
            array[i] = orig[i].toUpperCase();
        }
        return array;
    }

    @Override
    public String[] getKeys() {
        return keys;
    }

    @Override
    public Object setKey(String name, Object value) {
        if (name.equals("COMPLETIONAUXEXCLUDE")) {
            Shell.getCurrent().setCompletionExcludedAuxes(value.toString());
        } else if (name.equals("DEFAULTTABLEFLAGS")) {
            Table.setDefaultFlags(Convert.o2s(value));
        } else if (name.equals("DEFAULTTABLEMODE")) {
            Table.setDefaultMode(Convert.o2s(value));
        } else if (name.equals("FILENAMECASE") || name.equals("FNCASE")) {
            FileName.setDefaultFNCase(Convert.o2s(value));
        } else if (name.equals("PRIV")) {
            if (value.toString().equals("ALL")) {
                Shell.setPriv(-1);
            }
        } else {
            if (name.equals("GRAPHICS")) {
                Theme.setOptions(value.toString());
                value = Theme.getOptions();
            }
            if (name.equals("USENATIVE")) {
                Native.setUse(value.toString());
                value = Native.getUse();
            }
            if (name.equals("UIMANAGER")) {
                value = this.mergeUIManagerData((Table)value);
            }
            if (name.equals("IOOPTIONS")) {
                this.M.io.setOptions(value.toString());
                value = this.M.io.getOptions();
            }
            if (name.equals("PAUSE")) {
                this.M.pause = Convert.o2d(value);
            }
            if (name.equals("KEYMAP")) {
                value = Convert.o2t(value, this);
            }
            this.MR.put("ENV." + name, value, 16);
        }
        return this.getKey(name);
    }

    @Override
    public Object getKey(String name) {
        if (name.equals("COMPLETIONAUXEXCLUDE")) {
            return Shell.getCurrent().getExcludedAuxes();
        }
        if (name.equals("DEFAULTTABLEFLAGS")) {
            return Table.getDefaultFlags();
        }
        if (name.equals("DEFAULTTABLEMODE")) {
            return Table.getDefaultMode();
        }
        if (name.equals("FILENAMECASE")) {
            return FileName.getDefaultFNCase();
        }
        if (name.equals("FNCASE")) {
            return FileName.getDefaultFNCase();
        }
        if (name.equals("HOSTNAMEFQDN")) {
            return NetUtil.getFQDN(Convert.o2s(this.getKey("HOSTNAME")));
        }
        if (name.startsWith("NUMNONVIRTSCR")) {
            return Environment.getNumScreens(false);
        }
        if (name.startsWith("NUMSCR")) {
            return Environment.getNumScreens(true);
        }
        if (name.equals("PRIV")) {
            return Privileges.getPrivMaskString();
        }
        if (name.equals("SERVER")) {
            return this.getServer();
        }
        if (name.equals("SERVERFQDN")) {
            return NetUtil.getFQDN(Convert.o2s(this.getKey("SERVER")));
        }
        if (name.equals("USENATIVE")) {
            return Native.getUse();
        }
        return this.MR.getS("ENV." + name);
    }

    private String getServer() {
        String value = this.MA.getQ("/REMOTE", null);
        if (value == null) {
            value = this.MR.getS("ENV.SERVER");
        }
        if (value == null) {
            value = this.M.getServer();
        }
        return value;
    }

    public static int getNumScreens() {
        return Environment.getNumScreens(true);
    }

    @InternalUseOnly
    @ProvisionalUseOnly(value="Will become private, please use the new nxm.sys.lib.GraphicsUtil.getNumScreens(boolean).")
    public static int getNumScreens(boolean virtuals) {
        int numScreens = 0;
        if (!Theme.isHeadless()) {
            try {
                GraphicsDevice[] screens = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
                if (virtuals) {
                    numScreens = screens.length;
                } else {
                    for (GraphicsDevice gd : screens) {
                        GraphicsConfiguration[] gconfs = gd.getConfigurations();
                        int maxx = 0;
                        int maxy = 0;
                        for (GraphicsConfiguration gconf : gconfs) {
                            Rectangle virtualBounds = gconf.getBounds();
                            if (virtualBounds.x != 0) {
                                maxx = virtualBounds.x;
                            }
                            if (virtualBounds.y == 0) continue;
                            maxy = virtualBounds.y;
                        }
                        if (maxx != 0 || maxy != 0) continue;
                        ++numScreens;
                    }
                }
            }
            catch (Exception e) {
                Shell.warning("Unable to determine the number of screens");
            }
        }
        return numScreens;
    }

    private void showEnvironment(boolean all) {
        Environment.getNumScreens();
        this.M.type("------- Environment Table Settings ------");
        Results.listSingleResult(this.M, this.M.results, "ENV", 0, all);
        this.M.type("------- Other Environment Settings ------");
        for (int i = 0; i < keys.length; ++i) {
            String keyCS = keysCS[i];
            String key = keys[i];
            Object value = this.getKey(key);
            if (value == null) {
                value = "";
            }
            this.M.type(StringUtil.padRight(keyCS, 20) + " = " + value);
        }
    }

    public void listAllThreads() {
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        for (ThreadGroup parent = root.getParent(); parent != null; parent = parent.getParent()) {
            root = parent;
        }
        this.listThreadGroup(root, "");
    }

    public void listThreadGroup(ThreadGroup g, String indent) {
        int i;
        if (g == null) {
            return;
        }
        int num_threads = g.activeCount();
        int num_groups = g.activeGroupCount();
        Thread[] threads = new Thread[num_threads];
        ThreadGroup[] groups = new ThreadGroup[num_groups];
        g.enumerate(threads, false);
        g.enumerate(groups, false);
        this.M.println(indent + "ThreadGroup: " + g.getName() + " MaxPriority: " + g.getMaxPriority());
        for (i = 0; i < num_threads; ++i) {
            if (threads[i] == null) continue;
            this.M.println("  " + indent + "Thread: " + threads[i].getName() + " Priority: " + threads[i].getPriority() + (threads[i].isDaemon() ? "  Daemon" : ""));
        }
        for (i = 0; i < num_groups; ++i) {
            this.listThreadGroup(groups[i], indent + "  ");
        }
    }

    public void listAllMemory() {
        Runtime rt = Runtime.getRuntime();
        long tm = rt.totalMemory();
        long fm = rt.freeMemory();
        this.M.println("Memory: Total=" + tm + " Free=" + fm + " bytes");
    }

    @Deprecated
    public void listAllProperties() {
        this.listAllProperties(null);
    }

    private void listAllProperties(String filter) {
        Properties p = System.getProperties();
        if (filter != null) {
            filter = filter.toUpperCase();
        }
        for (Map.Entry<Object, Object> elem : p.entrySet()) {
            String keyAndValue = elem.toString();
            if (filter != null && !keyAndValue.toUpperCase().contains(filter)) continue;
            this.M.println(keyAndValue);
        }
    }

    private Object mergeUIManagerData(Table tab) {
        Table uim = this.MR.getTable("ENV.UIMANAGER");
        if (uim == null) {
            uim = new Table();
        }
        if (tab != null) {
            tab = Table.merge(uim, tab, true);
            tab = Theme.updateUIManager(tab);
            return tab;
        }
        return uim;
    }
}

