/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.io.File;
import nxm.sys.lib.Args;
import nxm.sys.lib.Command;
import nxm.sys.lib.Foreign;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.Macro;
import nxm.sys.lib.Shell;

public class Edit
extends Intrinsic {
    @Override
    public int process() {
        String name = this.MA.getCS("NAME");
        String area = this.MA.getU("AREA");
        String option = this.MA.getU("OPT", "SYS");
        boolean build = !this.MA.getState("/NB");
        String editor = this.MR.getString("ENV.EDITOR");
        String ext = "java";
        int ip = name.lastIndexOf(46);
        if (ip >= 0) {
            ext = name.substring(ip + 1);
            name = name.substring(0, ip);
        }
        Args targs = null;
        if (area == null || area.length() <= 0) {
            targs = Shell.parseCommand(this.M, name);
            option = targs.option.toLowerCase();
        }
        if (targs == null) {
            String inputName = this.M.io.name(area, name, ext, option);
            String fname = this.findCloseMatch(inputName, option, area, name, ext);
            if (fname == null) {
                build = false;
                this.M.warning("Could not find file match for '" + inputName + "'");
            } else {
                if (ext.equals("exp")) {
                    build = false;
                }
                Foreign.runInternal(this.M, editor + " " + fname);
            }
        } else if (targs.support == 'M') {
            String fname = Macro.getFileName(this.M, name, option);
            String fnamet = fname.substring(0, fname.length() - 2) + "txt";
            if (!this.M.io.fexists(fname)) {
                if (this.M.io.fexists(fnamet)) {
                    fname = fnamet;
                } else {
                    this.M.error("File for macro=" + targs.name + " not found");
                }
            }
            Foreign.runInternal(this.M, editor + " " + fname);
            Command command = Shell.loadCommand(this.M, targs);
            ((Macro)command).loadText();
            build = false;
        } else if (targs.support == 'P') {
            String fname = targs.name.toLowerCase();
            fname = this.M.io.getName(option, "prim", fname, ext);
            Foreign.runInternal(this.M, editor + " " + fname);
        } else if (targs.support == 'H') {
            String fname = targs.name.toLowerCase();
            if (ip < 0) {
                ext = "for";
            }
            fname = this.M.io.getName(option, "host", fname, ext);
            Foreign.runInternal(this.M, editor + " " + fname);
        } else if (targs.support == 'I') {
            String fname = targs.name.substring(0, 1) + targs.name.substring(1).toLowerCase();
            fname = this.M.io.getName(option, "intr", fname, ext);
            Foreign.runInternal(this.M, editor + " " + fname);
        } else {
            build = false;
            this.M.warning("Could not find command " + name);
        }
        if (build) {
            Shell.runCommand(this.M, "BLD," + name + "," + area + "," + option);
        }
        if (area.equals("LIBM") && (name.equals("operators") || name.equals("generate"))) {
            Shell.runCommand(this.M, "GENERATE,OPER,ALL");
            Shell.runCommand(this.M, "BLD,ALL,LIBM");
        }
        return 9;
    }

    private String findCloseMatch(String inputName, String option, String area, String name, String ext) {
        String outName = null;
        if (new File(inputName).exists()) {
            outName = inputName;
        } else {
            String path = this.M.io.name(area, "", "", option);
            String[] files = this.M.io.listFiles(path, name, ext);
            if (files.length > 0) {
                outName = path + files[0];
            }
            if (files.length > 1) {
                this.M.warning("Found " + files.length + " matching files. Using first = " + files[0]);
                for (int i = 0; i < files.length; ++i) {
                    this.M.warning("\tFile " + i + " = " + files[i]);
                }
            }
        }
        return outName;
    }
}

