/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;

public class Assert
extends Intrinsic {
    private static final String ERR_FLAG = " <--";
    private static final TestCount global = new TestCount();
    private static final TestCount local = new TestCount();
    private static Table gStatus = null;

    @Override
    public int process() {
        if (this.MA.find("/INIT")) {
            global.reset();
            local.reset();
            gStatus = new Table();
            this.MR.put(this.MA.getS("/INIT"), (Object)gStatus);
            return 9;
        }
        String tableID = this.MA.getS("/TID", "TEST");
        String text = this.MA.getS("/TEXT", null);
        int ltext = this.MA.getL("/LTEXT", 80);
        int pad = this.MA.getState("/PAD", true) ? ltext - 12 : 0;
        boolean fail = false;
        boolean except = this.MA.getState("/EXCEPT", false);
        Table group2 = this.MA.getTable("/GROUP");
        boolean summary = this.MA.getState("/SUMMARY");
        boolean defDebug = true;
        if (group2 != null) {
            String txt = group2.getS("TEXT");
            if (txt != null) {
                text = text == null ? txt : txt + " - " + text;
            }
            defDebug = summary;
        } else if (summary) {
            throw new MidasException("Can not use /SUMMARY without /GROUP=");
        }
        if (this.MA.isPresent("/TEST")) {
            boolean bl = fail = !this.MA.getState("/TEST");
            text = text != null ? text + " - " + this.MA.getRawArgs().trim() : (this.M.getMacro() == null ? "ASSERT: " + this.MA.getRawArgs().trim() : this.M.getMacro().getName() + ": " + this.MA.getRawArgs().trim());
            if (fail) {
                text = text + " fails";
            }
            if (except) {
                text = text + " throws Exception";
            }
        }
        if (text == null) {
            text = tableID;
        }
        String msgOut = StringUtil.padRight(text, pad, '.');
        String stat = this.MA.getU("/STAT");
        String total = this.MA.getS("/TOTAL");
        String noop2 = null;
        boolean test = false;
        boolean miss = false;
        boolean debug = this.MA.getState("/DEBUG", defDebug);
        boolean count = true;
        String label = this.MA.getU("/LABEL", "");
        boolean hidefail = this.MA.getState("/HIDEFAIL", false);
        String passFlag = "";
        if (total.length() > 0) {
            TestCount tc = null;
            if (total.equals("TEST")) {
                global.add(local);
                tc = local;
            }
            if (total.equals("RESET")) {
                tc = local;
                test = true;
            }
            if (total.equals("TESTALL")) {
                global.add(local);
                tc = global;
            }
            if (tc == null) {
                throw new MidasException("Illegal value for /TOTAL= given '" + total + "' expected 'TEST' or 'TESTALL'");
            }
            count = false;
            boolean bl = test = test || tc.failCount == 0;
            if (label.length() > 0) {
                this.MR.put(label, (Object)tc.toTable());
            } else {
                gStatus.put(tableID, (Object)tc.toTable());
            }
            local.reset();
        } else if (this.MA.isPresent("/NOOP")) {
            noop2 = this.MA.getS("/NOOP");
            miss = noop2.equals("MISS");
            if (noop2.length() == 0) {
                noop2 = "N/A";
            }
        } else if (except) {
            try {
                this.MA.logicalTest();
                test = false;
            }
            catch (Exception e) {
                test = true;
            }
        } else if (summary) {
            int numMiss = group2.getL("MISS", 0);
            int numNA = group2.getL("N/A", 0);
            int numPass = group2.getL("PASS", 0);
            int numFail = group2.getL("FAIL", 0);
            int numTests = numMiss + numNA + numPass + numFail;
            String txt = "PASS=" + numPass + " FAIL=" + numFail;
            if (numFail == 0) {
                test = true;
                boolean bl = miss = numTests == 0;
                if (numMiss > 0) {
                    passFlag = ERR_FLAG;
                    txt = txt + " MISS=" + numMiss;
                    miss = true;
                }
                if (numNA > 0) {
                    passFlag = ERR_FLAG;
                    txt = txt + " N/A=" + numNA;
                    noop2 = "N/A";
                }
            }
            msgOut = text + "." + StringUtil.padLeft("[" + txt + "]", pad - text.length() - 1, '.');
            group2 = null;
        } else {
            test = this.MA.logicalTest();
        }
        if (fail) {
            boolean bl = test = !test;
        }
        if (miss) {
            this.MR.put(stat, (Object)"N/A");
            if (debug) {
                this.M.message(msgOut + "..MISS" + ERR_FLAG, 0, null);
            }
            if (count) {
                ++Assert.local.missCount;
            }
            if (group2 != null) {
                group2.put("MISS", group2.getL("MISS", 0) + 1);
            }
        } else if (noop2 != null) {
            this.MR.put(stat, (Object)"N/A");
            if (debug) {
                this.M.message(msgOut + ".." + noop2 + ERR_FLAG, 0, null);
            }
            if (count) {
                ++Assert.local.noopCount;
            }
            if (group2 != null) {
                group2.put("N/A", group2.getL("N/A", 0) + 1);
            }
        } else if (test) {
            this.MR.put(stat, (Object)"PASS");
            if (debug) {
                this.M.message(msgOut + "..PASS" + passFlag, 0, null);
            }
            if (count) {
                ++Assert.local.passCount;
            }
            if (group2 != null) {
                group2.put("PASS", group2.getL("PASS", 0) + 1);
            }
        } else {
            this.MR.put(stat, (Object)"FAIL");
            if (!hidefail) {
                this.M.message(msgOut + "..FAIL" + ERR_FLAG, 1, null);
            }
            if (count) {
                ++Assert.local.failCount;
            }
            if (group2 != null) {
                group2.put("FAIL", group2.getL("FAIL", 0) + 1);
            }
        }
        return 9;
    }

    private static class TestCount {
        int passCount;
        int failCount;
        int missCount;
        int noopCount;

        private TestCount() {
        }

        void reset() {
            this.noopCount = 0;
            this.missCount = 0;
            this.failCount = 0;
            this.passCount = 0;
        }

        void add(TestCount tc) {
            this.passCount += tc.passCount;
            this.failCount += tc.failCount;
            this.missCount += tc.missCount;
            this.noopCount += tc.noopCount;
        }

        Table toTable() {
            Table tbl = new Table();
            tbl.put("MSG", (Object)(this.failCount == 0 ? "PASSED ALL TESTS" : "FAILED SOME TESTS"));
            tbl.put("STATUS", this.failCount == 0 ? 1 : -1);
            tbl.put("TEST_COUNT", this.passCount + this.failCount + this.missCount + this.noopCount);
            tbl.put("PASS_COUNT", this.passCount);
            tbl.put("FAIL_COUNT", this.failCount);
            tbl.put("MISS_COUNT", this.missCount);
            tbl.put("NOOP_COUNT", this.noopCount);
            return tbl;
        }

        public String toString() {
            return "TestCount: " + this.toTable();
        }
    }
}

