/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.inc;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import nxm.sys.inc.Filter;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.KeyValuePair;
import nxm.sys.inc.KeyableByType;
import nxm.sys.inc.SpecialLoggingRequired;

@SpecialLoggingRequired
@InternalUseOnly
public interface MapKBT
extends Map<String, Object>,
KeyableByType {
    public static final MapKBT EMPTY_MAP = new AbstractMapKBT(Collections.emptyMap());

    @Override
    default public Object getKey(String k) {
        return this.get(k);
    }

    @Override
    default public Object setKey(String k, Object v) {
        return this.put(k, v);
    }

    @Override
    default public Object getO(String k) {
        return this.get(k);
    }

    @Override
    default public String[] getKeys() {
        return this.getKeys(null);
    }

    @Override
    default public Object getO(String k, Object d) {
        Object v = this.get(k);
        return v == null ? d : v;
    }

    default public int getSize() {
        return this.size();
    }

    default public Enumeration<String> keys() {
        return Collections.enumeration(this.keySet());
    }

    default public String[] getKeys(Filter valueFilter) {
        if (this.isEmpty()) {
            return new String[0];
        }
        Collection keys = valueFilter == null ? (Collection)this.keySet().stream().collect(Collectors.toList()) : (Collection)this.keySet().stream().filter(k -> valueFilter.accept(this.get(k))).collect(Collectors.toList());
        return keys.toArray(new String[keys.size()]);
    }

    default public String getKeyList() {
        return this.getKeyList(null);
    }

    default public String getKeyList(Filter valueFilter) {
        if (this.isEmpty()) {
            return "";
        }
        if (valueFilter == null) {
            return this.keySet().stream().collect(Collectors.joining(","));
        }
        return this.keySet().stream().filter(k -> valueFilter.accept(this.get(k))).collect(Collectors.joining(","));
    }

    public static MapKBT toMap(KeyValuePair<?> ... kvPairs) {
        return KeyValuePair.toMap(kvPairs);
    }

    public static MapKBT toMap(Iterable<KeyValuePair<?>> kvPairs) {
        return KeyValuePair.toMap(kvPairs);
    }

    public static MapKBT wrapMap(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        return map instanceof MapKBT ? (MapKBT)map : new AbstractMapKBT(map);
    }

    public static <T> MapKBT wrapMap(T map) {
        Map m;
        if (map == null || map instanceof MapKBT) {
            return (MapKBT)map;
        }
        try {
            m = (Map)map;
        }
        catch (ClassCastException e) {
            throw new ClassCastException("Expected Map<String,Object> but given " + map.getClass());
        }
        m.keySet().forEach((? super T k) -> {
            if (!(k instanceof String) && k != null) {
                throw new ClassCastException("Expected Map<String,Object> but given Map<K super " + k.getClass() + ",V>");
            }
        });
        return new AbstractMapKBT(m);
    }

    @InternalUseOnly
    public static MapKBT newMap() {
        return new AbstractMapKBT();
    }

    @InternalUseOnly
    public static MapKBT emptyMap() {
        return EMPTY_MAP;
    }

    @InternalUseOnly
    public static MapKBT unmodifiableMap(Map<String, Object> map) {
        return new AbstractMapKBT(Collections.unmodifiableMap(map));
    }

    @InternalUseOnly
    public static MapKBT synchronizedMap(Map<String, Object> map) {
        return new AbstractMapKBT(Collections.synchronizedMap(map));
    }

    @InternalUseOnly
    public static MapKBT singletonMap(String key, Object val) {
        return new AbstractMapKBT(Collections.singletonMap(key, val));
    }

    @InternalUseOnly
    public static MapKBT wrapProperties(Properties props) {
        return props == null ? null : new PropsImpl(props);
    }

    @InternalUseOnly
    public static ArrayList<Map> getSubMapsWithKey(Map map, String keyName) {
        ArrayList<Map> mapsWithEntry = new ArrayList<Map>();
        if (map.containsKey(keyName)) {
            mapsWithEntry.add(map);
        }
        for (Object key : map.keySet()) {
            if (!(map.get(key) instanceof Map)) continue;
            Map subMap = (Map)map.get(key);
            if (subMap.containsKey(keyName)) {
                mapsWithEntry.add(subMap);
                continue;
            }
            ArrayList<Map> subMapsWithEntry = MapKBT.getSubMapsWithKey(subMap, keyName);
            for (Map subMapWithEntry : subMapsWithEntry) {
                mapsWithEntry.add(subMapWithEntry);
            }
        }
        return mapsWithEntry;
    }

    @InternalUseOnly
    public static class PropsImpl
    implements MapKBT {
        private final Properties props;

        @InternalUseOnly
        public PropsImpl(Properties props) {
            this.props = Objects.requireNonNull(props);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            this.props.putAll(m);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Map && this.entrySet().equals(((Map)o).entrySet());
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            LinkedHashSet<Map.Entry<String, Object>> entrySet = new LinkedHashSet<Map.Entry<String, Object>>(this.props.size());
            this.keySet().forEach((? super T k) -> entrySet.add(new AbstractMap.SimpleImmutableEntry<String, String>((String)k, this.props.getProperty((String)k))));
            return entrySet;
        }

        @Override
        public Collection<Object> values() {
            ArrayList<Object> values = new ArrayList<Object>(this.props.size());
            this.keySet().forEach((? super T k) -> values.add(this.props.getProperty((String)k)));
            return values;
        }

        @Override
        public int hashCode() {
            return this.props.hashCode();
        }

        public String toString() {
            return this.props.toString();
        }

        @Override
        public int size() {
            return this.keySet().size();
        }

        @Override
        public boolean isEmpty() {
            return this.keySet().isEmpty();
        }

        @Override
        public boolean containsKey(Object k) {
            return this.keySet().contains(k);
        }

        @Override
        public boolean containsValue(Object v) {
            return this.values().contains(v);
        }

        @Override
        public Object get(Object k) {
            return this.props.getProperty(k.toString());
        }

        @Override
        public Object put(String k, Object v) {
            return this.props.put(k, v);
        }

        @Override
        public Object remove(Object k) {
            return this.props.remove(k);
        }

        @Override
        public Set<String> keySet() {
            return this.props.stringPropertyNames();
        }

        @Override
        public void clear() {
            this.keySet().forEach((? super T k) -> this.remove(k));
        }
    }

    public static class AbstractMapKBT
    implements MapKBT {
        protected final Map<String, Object> map;

        @InternalUseOnly
        public AbstractMapKBT() {
            this(new TreeMap<String, Object>());
        }

        @InternalUseOnly
        public AbstractMapKBT(Map<String, Object> map) {
            this.map = Objects.requireNonNull(map);
        }

        public AbstractMapKBT(Supplier<Map<String, Object>> cons) {
            this(cons != null ? cons.get() : new TreeMap());
        }

        public MapKBT newMap(Supplier<Map<String, Object>> cons) {
            return new AbstractMapKBT(cons);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            this.map.putAll(m);
        }

        @Override
        public void forEach(BiConsumer<? super String, ? super Object> a) {
            this.map.forEach(a);
        }

        @Override
        public void replaceAll(BiFunction<? super String, ? super Object, ? extends Object> f) {
            this.map.replaceAll(f);
        }

        @Override
        public Object computeIfAbsent(String k, Function<? super String, ? extends Object> f) {
            return this.map.computeIfAbsent(k, f);
        }

        @Override
        public Object computeIfPresent(String k, BiFunction<? super String, ? super Object, ? extends Object> f) {
            return this.map.computeIfPresent(k, f);
        }

        @Override
        public Object compute(String k, BiFunction<? super String, ? super Object, ? extends Object> f) {
            return this.map.compute(k, f);
        }

        @Override
        public Object merge(String k, Object v, BiFunction<? super Object, ? super Object, ? extends Object> f) {
            return this.map.merge(k, v, f);
        }

        @Override
        public boolean equals(Object o) {
            return this.map.equals(o);
        }

        @Override
        public int hashCode() {
            return this.map.hashCode();
        }

        public String toString() {
            return this.map.toString();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object k) {
            return this.map.containsKey(k);
        }

        @Override
        public boolean containsValue(Object v) {
            return this.map.containsValue(v);
        }

        @Override
        public Object get(Object k) {
            return this.map.get(k);
        }

        @Override
        public Object put(String k, Object v) {
            return this.map.put(k, v);
        }

        @Override
        public Object remove(Object k) {
            return this.map.remove(k);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Set<String> keySet() {
            return this.map.keySet();
        }

        @Override
        public Collection<Object> values() {
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.map.entrySet();
        }

        @Override
        public Object getOrDefault(Object k, Object d) {
            return this.map.getOrDefault(k, d);
        }

        @Override
        public boolean remove(Object k, Object v) {
            return this.map.remove(k, v);
        }

        @Override
        public boolean replace(String k, Object o, Object n) {
            return this.map.replace(k, o, n);
        }

        @Override
        public Object replace(String k, Object v) {
            return this.map.replace(k, v);
        }

        @Override
        public Object putIfAbsent(String k, Object v) {
            return this.map.putIfAbsent(k, v);
        }
    }

    @FunctionalInterface
    @InternalUseOnly
    public static interface ToMapKBT {
        public MapKBT toMapKBT();
    }
}

