!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! PROFILER - Profiles the current Java VM. This requires Java 5+
! @author  J. Czechowski IV
! @version $Id: profiler.mm,v 1.4 2009/12/24 21:20:37 ntn Exp $
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
startmacro/theme=gear2
  invoke checkVer nxm.sys.lib.StringUtil.compareVersions(1.5.0,ENV.JVMVERSION)

  if checkVer GT 0 then
    error "PROFILER: The profiler requires Java 5+ to run."
  else
    pipe on
      panel/setup/msgid=main

      system MONITOR/MEMORY  ,, _memory
      system MONITOR/THREADS ,, _threads

      set s:cmap "(red,green,blue,yellow)"

      ! NTN BUG 2033: set AUTOM=-1 (or to 31 to autoscale on all four layers)
      plot/id=mem/YMULT=M &
          _memory{TAG="TOTAL_USED",LAYER={LT="Multi",COLUMNS="USED",COLORMAP="^cmap"}}|&
          _memory{TAG="TOTAL_COMMITTED",LAYER={LT="Multi",COLUMNS="COMM",COLORMAP="^cmap"}}|&
          _memory{TAG="HEAP_MEMORY",LAYER={LT="Multi",COLUMNS="HEAP",COLORMAP="^cmap"}}|&
          _memory{TAG="NONHEAP_MEMORY",LAYER={LT="Multi",COLUMNS="NONH",COLORMAP="^cmap"}} &
          Y1=0 AUTOM=-1

      ! NTN BUG 2033: set AUTOM=-1 (or to 15 to autoscale on all three layers)
      plot/id=thrd &
          _threads{TAG="CURRENT_COUNT",LAYER={LT="Multi",COLUMNS="CURR",COLORMAP="^cmap"}}|&
          _threads{TAG="PEAK_NUMBER",LAYER={LT="Multi",COLUMNS="PEAK",COLORMAP="^cmap"}}|&
          _threads{TAG="TOTAL_CREATED",LAYER={LT="Multi",COLUMNS="TOTL",COLORMAP="^cmap"}} &
          Y1=0 AUTOM=-1

      gcontrol label  macro "MACRO" AlwaysOpen
      gcontrol button state "" "Stop"
      gcontrol button legend "Legend" "Show,Hide"
    pipe off
  endif
endmacro


procedure processMessage m:msg
  !say "^{reg.main.name}: Msg ^msg.name = ^msg.data"

  if msg.fid eqs "PANEL"
    if msg.name eqs "STATE"
      pipe ^msg.data

    elseif msg.name eqs "LEGEND"
      if msg.data eqs "SHOW" then
        invoke ,, reg.mem.showLegend("BR")
        invoke ,, reg.thrd.showLegend("BR")
      else
        invoke ,, reg.mem.hideLegend()
        invoke ,, reg.thrd.hideLegend()
      endif
    endif
  else
    ! say "^{reg.main.name}: Unhandled message ^msg.name from ^msg.fid"
  endif
return
