%% Run a NeXtMidas command
%
% Run a NeXtMidas command. The first argument should be (at a minimum) the
% NeXtMidas function name. NeXtMidas arguments are seperated by spaces;
% therefore, all additional arguments will be converted into strings and
% appended to the command.
%  
% Syntax
% nm(cmd)
% nm(cmd,arg1,...,argN)
% nm cmd arg1,...,argN 
% 
% Input Arguments
% cmd  - command name
% args - additional arguments to append to command
%
% Examples:
% 0. Initialize a NeXtMidas session
% nm('start')
%
% 1. Generate a generic wave
% nm('wave', 'my_wave')
%
% 2. Generate the same wave with a slightly different call
% nm('wave my_wave')
%
% 3. Genereate a wave with a few more parameters
% nm('wave my_wave', 'cf', 16384, 'amp=1024')
% 
% 4. Plot the wave we just generated
% nm('plot my_wave')
%
% 5. End a NeXtMidas session
% nm('end')
%
function nm (cmd, varargin) 
  nmfunc(cmd,varargin{:});
end

